// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Describes one or more Capacity Manager data export configurations. Returns
//
// information about export settings, delivery status, and recent export activity.
func (c *Client) DescribeCapacityManagerDataExports(ctx context.Context, params *DescribeCapacityManagerDataExportsInput, optFns ...func(*Options)) (*DescribeCapacityManagerDataExportsOutput, error) {
	if params == nil {
		params = &DescribeCapacityManagerDataExportsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCapacityManagerDataExports", params, optFns, c.addOperationDescribeCapacityManagerDataExportsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCapacityManagerDataExportsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCapacityManagerDataExportsInput struct {

	//  The IDs of the data export configurations to describe. If not specified, all
	// export configurations are returned.
	CapacityManagerDataExportIds []string

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	//  One or more filters to narrow the results. Supported filters include export
	// status, creation date, and S3 bucket name.
	Filters []types.Filter

	//  The maximum number of results to return in a single call. If not specified, up
	// to 1000 results are returned.
	MaxResults *int32

	//  The token for the next page of results. Use this value in a subsequent call to
	// retrieve additional results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeCapacityManagerDataExportsOutput struct {

	//  Information about the data export configurations, including export settings,
	// delivery status, and recent activity.
	CapacityManagerDataExports []types.CapacityManagerDataExportResponse

	//  The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCapacityManagerDataExportsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeCapacityManagerDataExports{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeCapacityManagerDataExports{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeCapacityManagerDataExports"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCapacityManagerDataExports(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCapacityManagerDataExportsPaginatorOptions is the paginator options for
// DescribeCapacityManagerDataExports
type DescribeCapacityManagerDataExportsPaginatorOptions struct {
	//  The maximum number of results to return in a single call. If not specified, up
	// to 1000 results are returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCapacityManagerDataExportsPaginator is a paginator for
// DescribeCapacityManagerDataExports
type DescribeCapacityManagerDataExportsPaginator struct {
	options   DescribeCapacityManagerDataExportsPaginatorOptions
	client    DescribeCapacityManagerDataExportsAPIClient
	params    *DescribeCapacityManagerDataExportsInput
	nextToken *string
	firstPage bool
}

// NewDescribeCapacityManagerDataExportsPaginator returns a new
// DescribeCapacityManagerDataExportsPaginator
func NewDescribeCapacityManagerDataExportsPaginator(client DescribeCapacityManagerDataExportsAPIClient, params *DescribeCapacityManagerDataExportsInput, optFns ...func(*DescribeCapacityManagerDataExportsPaginatorOptions)) *DescribeCapacityManagerDataExportsPaginator {
	if params == nil {
		params = &DescribeCapacityManagerDataExportsInput{}
	}

	options := DescribeCapacityManagerDataExportsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCapacityManagerDataExportsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCapacityManagerDataExportsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeCapacityManagerDataExports page.
func (p *DescribeCapacityManagerDataExportsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCapacityManagerDataExportsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeCapacityManagerDataExports(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeCapacityManagerDataExportsAPIClient is a client that implements the
// DescribeCapacityManagerDataExports operation.
type DescribeCapacityManagerDataExportsAPIClient interface {
	DescribeCapacityManagerDataExports(context.Context, *DescribeCapacityManagerDataExportsInput, ...func(*Options)) (*DescribeCapacityManagerDataExportsOutput, error)
}

var _ DescribeCapacityManagerDataExportsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeCapacityManagerDataExports(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeCapacityManagerDataExports",
	}
}
