/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaptics-cxaudio-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_synaptics_cxaudio_device_kind_to_string(FuSynapticsCxaudioDeviceKind val)
{
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_UNKNOWN)
        return "unknown";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX20562)
        return "cx20562";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2070X)
        return "cx2070x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2077X)
        return "cx2077x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2076X)
        return "cx2076x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2085X)
        return "cx2085x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2089X)
        return "cx2089x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2098X)
        return "cx2098x";
    if (val == FU_SYNAPTICS_CXAUDIO_DEVICE_KIND_CX2198X)
        return "cx2198x";
    return NULL;
}


const gchar *
fu_synaptics_cxaudio_file_kind_to_string(FuSynapticsCxaudioFileKind val)
{
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_UNKNOWN)
        return "unknown";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2070X_FW)
        return "cx2070x-fw";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2070X_PATCH)
        return "cx2070x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2077X_PATCH)
        return "cx2077x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2076X_PATCH)
        return "cx2076x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2085X_PATCH)
        return "cx2085x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2089X_PATCH)
        return "cx2089x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2098X_PATCH)
        return "cx2098x-patch";
    if (val == FU_SYNAPTICS_CXAUDIO_FILE_KIND_CX2198X_PATCH)
        return "cx2198x-patch";
    return NULL;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_ref: (skip):
 **/
FuStructSynapticsCxaudioCustomInfo *
fu_struct_synaptics_cxaudio_custom_info_ref(FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_unref: (skip):
 **/
void
fu_struct_synaptics_cxaudio_custom_info_unref(FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCxaudioCustomInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCxaudioCustomInfo *
fu_struct_synaptics_cxaudio_custom_info_new_internal(void)
{
    FuStructSynapticsCxaudioCustomInfo *st = g_new0(FuStructSynapticsCxaudioCustomInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version: (skip):
 **/
const guint8 *
fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version(const FuStructSynapticsCxaudioCustomInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 3;
    return st->buf->data + 2;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version: (skip):
 **/
const guint8 *
fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version(const FuStructSynapticsCxaudioCustomInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->buf->data + 5;
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_layout_signature: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_layout_signature(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_layout_version: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_layout_version(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_application_status: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_custom_info_get_application_status(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_vendor_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_vendor_id(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_product_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_product_id(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_revision_id: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_revision_id(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_language_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_language_string_address(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_product_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_product_string_address(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_custom_info_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_custom_info_to_string(const FuStructSynapticsCxaudioCustomInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCxaudioCustomInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  patch_version_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_patch_version_string_address(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaptics_cxaudio_custom_info_get_cpx_patch_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  cpx_patch_version: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaptics_cxaudio_custom_info_get_spx_patch_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  spx_patch_version: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  layout_signature: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_layout_signature(st));
    g_string_append_printf(str, "  layout_version: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_layout_version(st));
    g_string_append_printf(str, "  application_status: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_application_status(st));
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_vendor_id(st));
    g_string_append_printf(str, "  product_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_product_id(st));
    g_string_append_printf(str, "  revision_id: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_revision_id(st));
    g_string_append_printf(str, "  language_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_language_string_address(st));
    g_string_append_printf(str, "  manufacturer_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_manufacturer_string_address(st));
    g_string_append_printf(str, "  product_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_product_string_address(st));
    g_string_append_printf(str, "  serial_number_string_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_custom_info_get_serial_number_string_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cxaudio_custom_info_validate_internal(FuStructSynapticsCxaudioCustomInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_cxaudio_custom_info_parse_internal(FuStructSynapticsCxaudioCustomInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cxaudio_custom_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cxaudio_custom_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_cxaudio_custom_info_parse: (skip):
 **/
FuStructSynapticsCxaudioCustomInfo *
fu_struct_synaptics_cxaudio_custom_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCxaudioCustomInfo) st = fu_struct_synaptics_cxaudio_custom_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 26, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsCxaudioCustomInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 26);
    if (!fu_struct_synaptics_cxaudio_custom_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_cxaudio_string_header_ref: (skip):
 **/
FuStructSynapticsCxaudioStringHeader *
fu_struct_synaptics_cxaudio_string_header_ref(FuStructSynapticsCxaudioStringHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cxaudio_string_header_unref: (skip):
 **/
void
fu_struct_synaptics_cxaudio_string_header_unref(FuStructSynapticsCxaudioStringHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCxaudioStringHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCxaudioStringHeader *
fu_struct_synaptics_cxaudio_string_header_new_internal(void)
{
    FuStructSynapticsCxaudioStringHeader *st = g_new0(FuStructSynapticsCxaudioStringHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cxaudio_string_header_get_length: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_string_header_get_length(const FuStructSynapticsCxaudioStringHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_string_header_get_type: (skip):
 **/
static guint8
fu_struct_synaptics_cxaudio_string_header_get_type(const FuStructSynapticsCxaudioStringHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_string_header_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_string_header_to_string(const FuStructSynapticsCxaudioStringHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCxaudioStringHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_string_header_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cxaudio_string_header_validate_internal(FuStructSynapticsCxaudioStringHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_synaptics_cxaudio_string_header_get_type(st) != 0x03) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructSynapticsCxaudioStringHeader.type was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_synaptics_cxaudio_string_header_parse_internal(FuStructSynapticsCxaudioStringHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cxaudio_string_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cxaudio_string_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_cxaudio_string_header_parse: (skip):
 **/
FuStructSynapticsCxaudioStringHeader *
fu_struct_synaptics_cxaudio_string_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCxaudioStringHeader) st = fu_struct_synaptics_cxaudio_string_header_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsCxaudioStringHeader: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_synaptics_cxaudio_string_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_cxaudio_validity_signature_ref: (skip):
 **/
FuStructSynapticsCxaudioValiditySignature *
fu_struct_synaptics_cxaudio_validity_signature_ref(FuStructSynapticsCxaudioValiditySignature *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cxaudio_validity_signature_unref: (skip):
 **/
void
fu_struct_synaptics_cxaudio_validity_signature_unref(FuStructSynapticsCxaudioValiditySignature *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCxaudioValiditySignature refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCxaudioValiditySignature *
fu_struct_synaptics_cxaudio_validity_signature_new_internal(void)
{
    FuStructSynapticsCxaudioValiditySignature *st = g_new0(FuStructSynapticsCxaudioValiditySignature, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte(const FuStructSynapticsCxaudioValiditySignature *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code(const FuStructSynapticsCxaudioValiditySignature *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_validity_signature_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_validity_signature_to_string(const FuStructSynapticsCxaudioValiditySignature *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCxaudioValiditySignature:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  magic_byte: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_validity_signature_get_magic_byte(st));
    g_string_append_printf(str, "  eeprom_size_code: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_validity_signature_get_eeprom_size_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cxaudio_validity_signature_validate_internal(FuStructSynapticsCxaudioValiditySignature *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_cxaudio_validity_signature_parse_internal(FuStructSynapticsCxaudioValiditySignature *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cxaudio_validity_signature_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cxaudio_validity_signature_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_cxaudio_validity_signature_parse: (skip):
 **/
FuStructSynapticsCxaudioValiditySignature *
fu_struct_synaptics_cxaudio_validity_signature_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCxaudioValiditySignature) st = fu_struct_synaptics_cxaudio_validity_signature_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsCxaudioValiditySignature: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_synaptics_cxaudio_validity_signature_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_ref: (skip):
 **/
FuStructSynapticsCxaudioPatchInfo *
fu_struct_synaptics_cxaudio_patch_info_ref(FuStructSynapticsCxaudioPatchInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_unref: (skip):
 **/
void
fu_struct_synaptics_cxaudio_patch_info_unref(FuStructSynapticsCxaudioPatchInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsCxaudioPatchInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsCxaudioPatchInfo *
fu_struct_synaptics_cxaudio_patch_info_new_internal(void)
{
    FuStructSynapticsCxaudioPatchInfo *st = g_new0(FuStructSynapticsCxaudioPatchInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_cxaudio_patch_info_get_patch_signature: (skip):
 **/
guint8
fu_struct_synaptics_cxaudio_patch_info_get_patch_signature(const FuStructSynapticsCxaudioPatchInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_get_patch_address: (skip):
 **/
guint16
fu_struct_synaptics_cxaudio_patch_info_get_patch_address(const FuStructSynapticsCxaudioPatchInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_cxaudio_patch_info_set_patch_signature: (skip):
 **/
void
fu_struct_synaptics_cxaudio_patch_info_set_patch_signature(FuStructSynapticsCxaudioPatchInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_set_patch_address: (skip):
 **/
void
fu_struct_synaptics_cxaudio_patch_info_set_patch_address(FuStructSynapticsCxaudioPatchInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_cxaudio_patch_info_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_cxaudio_patch_info_to_string(const FuStructSynapticsCxaudioPatchInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsCxaudioPatchInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  patch_signature: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_patch_info_get_patch_signature(st));
    g_string_append_printf(str, "  patch_address: 0x%x\n",
                           (guint) fu_struct_synaptics_cxaudio_patch_info_get_patch_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_cxaudio_patch_info_validate_internal(FuStructSynapticsCxaudioPatchInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_cxaudio_patch_info_parse_internal(FuStructSynapticsCxaudioPatchInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_cxaudio_patch_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_cxaudio_patch_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_cxaudio_patch_info_parse: (skip):
 **/
FuStructSynapticsCxaudioPatchInfo *
fu_struct_synaptics_cxaudio_patch_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsCxaudioPatchInfo) st = fu_struct_synaptics_cxaudio_patch_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsCxaudioPatchInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 3);
    if (!fu_struct_synaptics_cxaudio_patch_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
