/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-mei-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_mei_family_to_string:
 * @val: value, e.g. %FU_MEI_FAMILY_SPS
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_mei_family_to_string(FuMeiFamily val)
{
    if (val == FU_MEI_FAMILY_SPS)
        return "sps";
    if (val == FU_MEI_FAMILY_TXE)
        return "txe";
    if (val == FU_MEI_FAMILY_ME)
        return "me";
    if (val == FU_MEI_FAMILY_CSME)
        return "csme";
    if (val == FU_MEI_FAMILY_CSME18)
        return "csme18";
    return NULL;
}

/**
 * fu_mei_issue_to_string:
 * @val: value, e.g. %FU_MEI_ISSUE_NOT_VULNERABLE
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_mei_issue_to_string(FuMeiIssue val)
{
    if (val == FU_MEI_ISSUE_NOT_VULNERABLE)
        return "not-vulnerable";
    if (val == FU_MEI_ISSUE_VULNERABLE)
        return "vulnerable";
    if (val == FU_MEI_ISSUE_PATCHED)
        return "patched";
    return NULL;
}



/**
 * fu_me_hfs_mode_to_string:
 * @val: value, e.g. %FU_ME_HFS_MODE___RESERVED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_me_hfs_mode_to_string(FuMeHfsMode val)
{
    if (val == FU_ME_HFS_MODE_NORMAL)
        return "normal";
    if (val == FU_ME_HFS_MODE___RESERVED)
        return "--reserved";
    if (val == FU_ME_HFS_MODE_DEBUG)
        return "debug";
    if (val == FU_ME_HFS_MODE_DISABLE)
        return "disable";
    if (val == FU_ME_HFS_MODE_OVERRIDE_JUMPER)
        return "override-jumper";
    if (val == FU_ME_HFS_MODE_OVERRIDE_MEI)
        return "override-mei";
    if (val == FU_ME_HFS_MODE_UNKNOWN6)
        return "unknown6";
    if (val == FU_ME_HFS_MODE_ENHANCED_DEBUG)
        return "enhanced-debug";
    return NULL;
}


/**
 * fu_me_hfs_enforcement_policy_to_string:
 * @val: value, e.g. %FU_ME_HFS_ENFORCEMENT_POLICY_SHUTDOWN_TO
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_me_hfs_enforcement_policy_to_string(FuMeHfsEnforcementPolicy val)
{
    if (val == FU_ME_HFS_ENFORCEMENT_POLICY_NOTHING)
        return "nothing";
    if (val == FU_ME_HFS_ENFORCEMENT_POLICY_SHUTDOWN_TO)
        return "shutdown-to";
    if (val == FU_ME_HFS_ENFORCEMENT_POLICY_SHUTDOWN_NOW)
        return "shutdown-now";
    if (val == FU_ME_HFS_ENFORCEMENT_POLICY_SHUTDOWN_30MINS)
        return "shutdown-30mins";
    return NULL;
}


/**
 * fu_mei_csme11_hfsts1_ref: (skip):
 **/
FuMeiCsme11Hfsts1 *
fu_mei_csme11_hfsts1_ref(FuMeiCsme11Hfsts1 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts1_unref: (skip):
 **/
void
fu_mei_csme11_hfsts1_unref(FuMeiCsme11Hfsts1 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts1 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mei_csme11_hfsts1_new_internal: (skip):
 **/
static FuMeiCsme11Hfsts1 *
fu_mei_csme11_hfsts1_new_internal(void)
{
    FuMeiCsme11Hfsts1 *st = g_new0(FuMeiCsme11Hfsts1, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mei_csme11_hfsts1_get_mfg_mode: (skip):
 **/
guint32
fu_mei_csme11_hfsts1_get_mfg_mode(const FuMeiCsme11Hfsts1 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 4) & 1;
}
/**
 * fu_mei_csme11_hfsts1_get_operation_mode: (skip):
 **/
FuMeHfsMode
fu_mei_csme11_hfsts1_get_operation_mode(const FuMeiCsme11Hfsts1 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(FuMeHfsMode), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 16) & 15;
}

/* setters */
/**
 * fu_mei_csme11_hfsts1_to_string: (skip):
 **/
static gchar *
fu_mei_csme11_hfsts1_to_string(const FuMeiCsme11Hfsts1 *st)
{
    g_autoptr(GString) str = g_string_new("FuMeiCsme11Hfsts1:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  mfg_mode: 0x%x\n",
                           (guint) fu_mei_csme11_hfsts1_get_mfg_mode(st));
    {
        const gchar *tmp = fu_me_hfs_mode_to_string(fu_mei_csme11_hfsts1_get_operation_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  operation_mode: 0x%x [%s]\n", (guint) fu_mei_csme11_hfsts1_get_operation_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  operation_mode: 0x%x\n", (guint) fu_mei_csme11_hfsts1_get_operation_mode(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mei_csme11_hfsts1_validate_internal(FuMeiCsme11Hfsts1 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mei_csme11_hfsts1_parse_internal(FuMeiCsme11Hfsts1 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mei_csme11_hfsts1_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mei_csme11_hfsts1_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mei_csme11_hfsts1_parse: (skip):
 **/
FuMeiCsme11Hfsts1 *
fu_mei_csme11_hfsts1_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMeiCsme11Hfsts1) st = fu_mei_csme11_hfsts1_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMeiCsme11Hfsts1: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mei_csme11_hfsts1_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mei_csme11_hfsts2_ref: (skip):
 **/
FuMeiCsme11Hfsts2 *
fu_mei_csme11_hfsts2_ref(FuMeiCsme11Hfsts2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts2_unref: (skip):
 **/
void
fu_mei_csme11_hfsts2_unref(FuMeiCsme11Hfsts2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme11_hfsts3_ref: (skip):
 **/
FuMeiCsme11Hfsts3 *
fu_mei_csme11_hfsts3_ref(FuMeiCsme11Hfsts3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts3_unref: (skip):
 **/
void
fu_mei_csme11_hfsts3_unref(FuMeiCsme11Hfsts3 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts3 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme11_hfsts4_ref: (skip):
 **/
FuMeiCsme11Hfsts4 *
fu_mei_csme11_hfsts4_ref(FuMeiCsme11Hfsts4 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts4_unref: (skip):
 **/
void
fu_mei_csme11_hfsts4_unref(FuMeiCsme11Hfsts4 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts4 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme11_hfsts5_ref: (skip):
 **/
FuMeiCsme11Hfsts5 *
fu_mei_csme11_hfsts5_ref(FuMeiCsme11Hfsts5 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts5_unref: (skip):
 **/
void
fu_mei_csme11_hfsts5_unref(FuMeiCsme11Hfsts5 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts5 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme11_hfsts6_ref: (skip):
 **/
FuMeiCsme11Hfsts6 *
fu_mei_csme11_hfsts6_ref(FuMeiCsme11Hfsts6 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme11_hfsts6_unref: (skip):
 **/
void
fu_mei_csme11_hfsts6_unref(FuMeiCsme11Hfsts6 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme11Hfsts6 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mei_csme11_hfsts6_new_internal: (skip):
 **/
static FuMeiCsme11Hfsts6 *
fu_mei_csme11_hfsts6_new_internal(void)
{
    FuMeiCsme11Hfsts6 *st = g_new0(FuMeiCsme11Hfsts6, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mei_csme11_hfsts6_get_force_boot_guard_acm: (skip):
 **/
guint32
fu_mei_csme11_hfsts6_get_force_boot_guard_acm(const FuMeiCsme11Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 0) & 1;
}
/**
 * fu_mei_csme11_hfsts6_get_error_enforce_policy: (skip):
 **/
FuMeHfsEnforcementPolicy
fu_mei_csme11_hfsts6_get_error_enforce_policy(const FuMeiCsme11Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(FuMeHfsEnforcementPolicy), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 6) & 3;
}
/**
 * fu_mei_csme11_hfsts6_get_verified_boot: (skip):
 **/
guint32
fu_mei_csme11_hfsts6_get_verified_boot(const FuMeiCsme11Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 9) & 1;
}
/**
 * fu_mei_csme11_hfsts6_get_boot_guard_disable: (skip):
 **/
guint32
fu_mei_csme11_hfsts6_get_boot_guard_disable(const FuMeiCsme11Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 28) & 1;
}
/**
 * fu_mei_csme11_hfsts6_get_fpf_soc_lock: (skip):
 **/
guint32
fu_mei_csme11_hfsts6_get_fpf_soc_lock(const FuMeiCsme11Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 30) & 1;
}

/* setters */
/**
 * fu_mei_csme11_hfsts6_to_string: (skip):
 **/
static gchar *
fu_mei_csme11_hfsts6_to_string(const FuMeiCsme11Hfsts6 *st)
{
    g_autoptr(GString) str = g_string_new("FuMeiCsme11Hfsts6:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  force_boot_guard_acm: 0x%x\n",
                           (guint) fu_mei_csme11_hfsts6_get_force_boot_guard_acm(st));
    {
        const gchar *tmp = fu_me_hfs_enforcement_policy_to_string(fu_mei_csme11_hfsts6_get_error_enforce_policy(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  error_enforce_policy: 0x%x [%s]\n", (guint) fu_mei_csme11_hfsts6_get_error_enforce_policy(st), tmp);
        } else {
            g_string_append_printf(str, "  error_enforce_policy: 0x%x\n", (guint) fu_mei_csme11_hfsts6_get_error_enforce_policy(st));
        }
    }
    g_string_append_printf(str, "  verified_boot: 0x%x\n",
                           (guint) fu_mei_csme11_hfsts6_get_verified_boot(st));
    g_string_append_printf(str, "  boot_guard_disable: 0x%x\n",
                           (guint) fu_mei_csme11_hfsts6_get_boot_guard_disable(st));
    g_string_append_printf(str, "  fpf_soc_lock: 0x%x\n",
                           (guint) fu_mei_csme11_hfsts6_get_fpf_soc_lock(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mei_csme11_hfsts6_validate_internal(FuMeiCsme11Hfsts6 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mei_csme11_hfsts6_parse_internal(FuMeiCsme11Hfsts6 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mei_csme11_hfsts6_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mei_csme11_hfsts6_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mei_csme11_hfsts6_parse: (skip):
 **/
FuMeiCsme11Hfsts6 *
fu_mei_csme11_hfsts6_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMeiCsme11Hfsts6) st = fu_mei_csme11_hfsts6_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMeiCsme11Hfsts6: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mei_csme11_hfsts6_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mei_csme18_hfsts1_ref: (skip):
 **/
FuMeiCsme18Hfsts1 *
fu_mei_csme18_hfsts1_ref(FuMeiCsme18Hfsts1 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts1_unref: (skip):
 **/
void
fu_mei_csme18_hfsts1_unref(FuMeiCsme18Hfsts1 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts1 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mei_csme18_hfsts1_new_internal: (skip):
 **/
static FuMeiCsme18Hfsts1 *
fu_mei_csme18_hfsts1_new_internal(void)
{
    FuMeiCsme18Hfsts1 *st = g_new0(FuMeiCsme18Hfsts1, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mei_csme18_hfsts1_get_spi_protection_mode: (skip):
 **/
guint32
fu_mei_csme18_hfsts1_get_spi_protection_mode(const FuMeiCsme18Hfsts1 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 4) & 1;
}
/**
 * fu_mei_csme18_hfsts1_get_operation_mode: (skip):
 **/
FuMeHfsMode
fu_mei_csme18_hfsts1_get_operation_mode(const FuMeiCsme18Hfsts1 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(FuMeHfsMode), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 16) & 15;
}

/* setters */
/**
 * fu_mei_csme18_hfsts1_to_string: (skip):
 **/
static gchar *
fu_mei_csme18_hfsts1_to_string(const FuMeiCsme18Hfsts1 *st)
{
    g_autoptr(GString) str = g_string_new("FuMeiCsme18Hfsts1:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  spi_protection_mode: 0x%x\n",
                           (guint) fu_mei_csme18_hfsts1_get_spi_protection_mode(st));
    {
        const gchar *tmp = fu_me_hfs_mode_to_string(fu_mei_csme18_hfsts1_get_operation_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  operation_mode: 0x%x [%s]\n", (guint) fu_mei_csme18_hfsts1_get_operation_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  operation_mode: 0x%x\n", (guint) fu_mei_csme18_hfsts1_get_operation_mode(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mei_csme18_hfsts1_validate_internal(FuMeiCsme18Hfsts1 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mei_csme18_hfsts1_parse_internal(FuMeiCsme18Hfsts1 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mei_csme18_hfsts1_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mei_csme18_hfsts1_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mei_csme18_hfsts1_parse: (skip):
 **/
FuMeiCsme18Hfsts1 *
fu_mei_csme18_hfsts1_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMeiCsme18Hfsts1) st = fu_mei_csme18_hfsts1_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMeiCsme18Hfsts1: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mei_csme18_hfsts1_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mei_csme18_hfsts2_ref: (skip):
 **/
FuMeiCsme18Hfsts2 *
fu_mei_csme18_hfsts2_ref(FuMeiCsme18Hfsts2 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts2_unref: (skip):
 **/
void
fu_mei_csme18_hfsts2_unref(FuMeiCsme18Hfsts2 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts2 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme18_hfsts3_ref: (skip):
 **/
FuMeiCsme18Hfsts3 *
fu_mei_csme18_hfsts3_ref(FuMeiCsme18Hfsts3 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts3_unref: (skip):
 **/
void
fu_mei_csme18_hfsts3_unref(FuMeiCsme18Hfsts3 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts3 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme18_hfsts4_ref: (skip):
 **/
FuMeiCsme18Hfsts4 *
fu_mei_csme18_hfsts4_ref(FuMeiCsme18Hfsts4 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts4_unref: (skip):
 **/
void
fu_mei_csme18_hfsts4_unref(FuMeiCsme18Hfsts4 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts4 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_mei_csme18_hfsts5_ref: (skip):
 **/
FuMeiCsme18Hfsts5 *
fu_mei_csme18_hfsts5_ref(FuMeiCsme18Hfsts5 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts5_unref: (skip):
 **/
void
fu_mei_csme18_hfsts5_unref(FuMeiCsme18Hfsts5 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts5 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mei_csme18_hfsts5_new_internal: (skip):
 **/
static FuMeiCsme18Hfsts5 *
fu_mei_csme18_hfsts5_new_internal(void)
{
    FuMeiCsme18Hfsts5 *st = g_new0(FuMeiCsme18Hfsts5, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mei_csme18_hfsts5_get_btg_acm_active: (skip):
 **/
guint32
fu_mei_csme18_hfsts5_get_btg_acm_active(const FuMeiCsme18Hfsts5 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 0) & 1;
}
/**
 * fu_mei_csme18_hfsts5_get_valid: (skip):
 **/
guint32
fu_mei_csme18_hfsts5_get_valid(const FuMeiCsme18Hfsts5 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 1) & 1;
}
/**
 * fu_mei_csme18_hfsts5_get_acm_done_sts: (skip):
 **/
guint32
fu_mei_csme18_hfsts5_get_acm_done_sts(const FuMeiCsme18Hfsts5 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 8) & 1;
}

/* setters */
/**
 * fu_mei_csme18_hfsts5_to_string: (skip):
 **/
static gchar *
fu_mei_csme18_hfsts5_to_string(const FuMeiCsme18Hfsts5 *st)
{
    g_autoptr(GString) str = g_string_new("FuMeiCsme18Hfsts5:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  btg_acm_active: 0x%x\n",
                           (guint) fu_mei_csme18_hfsts5_get_btg_acm_active(st));
    g_string_append_printf(str, "  valid: 0x%x\n",
                           (guint) fu_mei_csme18_hfsts5_get_valid(st));
    g_string_append_printf(str, "  acm_done_sts: 0x%x\n",
                           (guint) fu_mei_csme18_hfsts5_get_acm_done_sts(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mei_csme18_hfsts5_validate_internal(FuMeiCsme18Hfsts5 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mei_csme18_hfsts5_parse_internal(FuMeiCsme18Hfsts5 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mei_csme18_hfsts5_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mei_csme18_hfsts5_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mei_csme18_hfsts5_parse: (skip):
 **/
FuMeiCsme18Hfsts5 *
fu_mei_csme18_hfsts5_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMeiCsme18Hfsts5) st = fu_mei_csme18_hfsts5_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMeiCsme18Hfsts5: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mei_csme18_hfsts5_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_mei_csme18_hfsts6_ref: (skip):
 **/
FuMeiCsme18Hfsts6 *
fu_mei_csme18_hfsts6_ref(FuMeiCsme18Hfsts6 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_mei_csme18_hfsts6_unref: (skip):
 **/
void
fu_mei_csme18_hfsts6_unref(FuMeiCsme18Hfsts6 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuMeiCsme18Hfsts6 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_mei_csme18_hfsts6_new_internal: (skip):
 **/
static FuMeiCsme18Hfsts6 *
fu_mei_csme18_hfsts6_new_internal(void)
{
    FuMeiCsme18Hfsts6 *st = g_new0(FuMeiCsme18Hfsts6, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_mei_csme18_hfsts6_get_fpf_soc_configuration_lock: (skip):
 **/
guint32
fu_mei_csme18_hfsts6_get_fpf_soc_configuration_lock(const FuMeiCsme18Hfsts6 *st)
{
    guint32 val;
    g_return_val_if_fail(st != NULL, 0x0);
    g_return_val_if_fail(st->buf->len >= sizeof(guint32), 0x0);
    val = fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
    return (val >> 30) & 1;
}

/* setters */
/**
 * fu_mei_csme18_hfsts6_to_string: (skip):
 **/
static gchar *
fu_mei_csme18_hfsts6_to_string(const FuMeiCsme18Hfsts6 *st)
{
    g_autoptr(GString) str = g_string_new("FuMeiCsme18Hfsts6:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  fpf_soc_configuration_lock: 0x%x\n",
                           (guint) fu_mei_csme18_hfsts6_get_fpf_soc_configuration_lock(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_mei_csme18_hfsts6_validate_internal(FuMeiCsme18Hfsts6 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_mei_csme18_hfsts6_parse_internal(FuMeiCsme18Hfsts6 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_mei_csme18_hfsts6_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_mei_csme18_hfsts6_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_mei_csme18_hfsts6_parse: (skip):
 **/
FuMeiCsme18Hfsts6 *
fu_mei_csme18_hfsts6_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuMeiCsme18Hfsts6) st = fu_mei_csme18_hfsts6_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuMeiCsme18Hfsts6: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_mei_csme18_hfsts6_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
