/* auto-generated, do not modify */
#pragma once
#include <fu-input-stream.h>
/**
 * FuPixartTpSystemBank:
 *
 * bank ids
 */
typedef enum {
    /**
     * FU_PIXART_TP_SYSTEM_BANK_BANK0:
     */
    FU_PIXART_TP_SYSTEM_BANK_BANK0 = 0x00,
    /**
     * FU_PIXART_TP_SYSTEM_BANK_BANK1:
     */
    FU_PIXART_TP_SYSTEM_BANK_BANK1 = 0x01,
    /**
     * FU_PIXART_TP_SYSTEM_BANK_BANK2:
     */
    FU_PIXART_TP_SYSTEM_BANK_BANK2 = 0x02,
    /**
     * FU_PIXART_TP_SYSTEM_BANK_BANK4:
     */
    FU_PIXART_TP_SYSTEM_BANK_BANK4 = 0x04,
    /**
     * FU_PIXART_TP_SYSTEM_BANK_BANK6:
     */
    FU_PIXART_TP_SYSTEM_BANK_BANK6 = 0x06,
}  FuPixartTpSystemBank;
/**
 * FuPixartTpUserBank:
 */
typedef enum {
    /**
     * FU_PIXART_TP_USER_BANK_BANK0:
     */
    FU_PIXART_TP_USER_BANK_BANK0 = 0x00,
    /**
     * FU_PIXART_TP_USER_BANK_BANK1:
     */
    FU_PIXART_TP_USER_BANK_BANK1 = 0x01,
    /**
     * FU_PIXART_TP_USER_BANK_BANK2:
     */
    FU_PIXART_TP_USER_BANK_BANK2 = 0x02,
}  FuPixartTpUserBank;
/**
 * FuPixartTpRegSys4:
 *
 * system bank 4 (flash engine registers)
 */
typedef enum {
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_STATUS:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_STATUS = 0x1c,
    /**
     * FU_PIXART_TP_REG_SYS4_SWAP_FLAG:
     */
    FU_PIXART_TP_REG_SYS4_SWAP_FLAG = 0x29,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_INST_CMD:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_INST_CMD = 0x2c,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_BUF_ADDR0:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_BUF_ADDR0 = 0x2e,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_BUF_ADDR1:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_BUF_ADDR1 = 0x2f,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_CCR0:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_CCR0 = 0x40,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_CCR1:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_CCR1 = 0x41,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_CCR2:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_CCR2 = 0x42,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_CCR3:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_CCR3 = 0x43,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_DATA_CNT0:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_DATA_CNT0 = 0x44,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_DATA_CNT1:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_DATA_CNT1 = 0x45,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_ADDR0:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_ADDR0 = 0x48,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_ADDR1:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_ADDR1 = 0x49,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_ADDR2:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_ADDR2 = 0x4a,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_ADDR3:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_ADDR3 = 0x4b,
    /**
     * FU_PIXART_TP_REG_SYS4_FLASH_EXECUTE:
     */
    FU_PIXART_TP_REG_SYS4_FLASH_EXECUTE = 0x56,
}  FuPixartTpRegSys4;
/**
 * FuPixartTpRegSys6:
 *
 * system bank 6 (sram buffer)
 */
typedef enum {
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_GAIN_SELECT:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_GAIN_SELECT = 0x08,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_SELECT:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_SELECT = 0x09,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_TRIGGER:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_TRIGGER = 0x0a,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_DATA:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_DATA = 0x0b,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_CHECKSUM:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_CHECKSUM = 0x0c,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_ADDR0:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_ADDR0 = 0x10,
    /**
     * FU_PIXART_TP_REG_SYS6_SRAM_ADDR1:
     */
    FU_PIXART_TP_REG_SYS6_SRAM_ADDR1 = 0x11,
}  FuPixartTpRegSys6;
/**
 * FuPixartTpRegSys1:
 *
 * system bank 1 (reset control registers)
 */
typedef enum {
    /**
     * FU_PIXART_TP_REG_SYS1_CLOCKS_POWER_UP:
     */
    FU_PIXART_TP_REG_SYS1_CLOCKS_POWER_UP = 0x0d,
    /**
     * FU_PIXART_TP_REG_SYS1_RESET_KEY1:
     */
    FU_PIXART_TP_REG_SYS1_RESET_KEY1 = 0x2c,
    /**
     * FU_PIXART_TP_REG_SYS1_RESET_KEY2:
     */
    FU_PIXART_TP_REG_SYS1_RESET_KEY2 = 0x2d,
}  FuPixartTpRegSys1;
/**
 * FuPixartTpRegUser0:
 *
 * user bank 0 (part id + crc registers)
 */
typedef enum {
    /**
     * FU_PIXART_TP_REG_USER0_BOOT_STAUS:
     */
    FU_PIXART_TP_REG_USER0_BOOT_STAUS = 0x00,
    /**
     * FU_PIXART_TP_REG_USER0_RUN_MODE:
     */
    FU_PIXART_TP_REG_USER0_RUN_MODE = 0x16,
    /**
     * FU_PIXART_TP_REG_USER0_PROXY_MODE:
     */
    FU_PIXART_TP_REG_USER0_PROXY_MODE = 0x56,
    /**
     * FU_PIXART_TP_REG_USER0_PART_ID0:
     */
    FU_PIXART_TP_REG_USER0_PART_ID0 = 0x78,
    /**
     * FU_PIXART_TP_REG_USER0_PART_ID1:
     */
    FU_PIXART_TP_REG_USER0_PART_ID1 = 0x79,
    /**
     * FU_PIXART_TP_REG_USER0_CRC_CTRL:
     */
    FU_PIXART_TP_REG_USER0_CRC_CTRL = 0x82,
    /**
     * FU_PIXART_TP_REG_USER0_CRC_RESULT0:
     */
    FU_PIXART_TP_REG_USER0_CRC_RESULT0 = 0x84,
    /**
     * FU_PIXART_TP_REG_USER0_CRC_RESULT1:
     */
    FU_PIXART_TP_REG_USER0_CRC_RESULT1 = 0x85,
    /**
     * FU_PIXART_TP_REG_USER0_CRC_RESULT2:
     */
    FU_PIXART_TP_REG_USER0_CRC_RESULT2 = 0x86,
    /**
     * FU_PIXART_TP_REG_USER0_CRC_RESULT3:
     */
    FU_PIXART_TP_REG_USER0_CRC_RESULT3 = 0x87,
}  FuPixartTpRegUser0;
/**
 * FuPixartTpBootStatus:
 */
typedef enum {
    /**
     * FU_PIXART_TP_BOOT_STATUS_ROM:
     */
    FU_PIXART_TP_BOOT_STATUS_ROM = 0x8c,
}  FuPixartTpBootStatus;
/**
 * FuPixartTpRunMode:
 */
typedef enum {
    /**
     * FU_PIXART_TP_RUN_MODE_AUTO:
     */
    FU_PIXART_TP_RUN_MODE_AUTO = 0x00,
    /**
     * FU_PIXART_TP_RUN_MODE_FORCE_RUN:
     */
    FU_PIXART_TP_RUN_MODE_FORCE_RUN = 0x01,
}  FuPixartTpRunMode;
/**
 * FuPixartTpResetMode:
 */
typedef enum {
    /**
     * FU_PIXART_TP_RESET_MODE_APPLICATION:
     */
    FU_PIXART_TP_RESET_MODE_APPLICATION,
    /**
     * FU_PIXART_TP_RESET_MODE_BOOTLOADER:
     */
    FU_PIXART_TP_RESET_MODE_BOOTLOADER,
}  FuPixartTpResetMode;
#define FU_PIXART_TP_RESET_MODE_LAST 2
/**
 * FuPixartTpResetKey1:
 */
typedef enum {
    /**
     * FU_PIXART_TP_RESET_KEY1_SUSPEND:
     */
    FU_PIXART_TP_RESET_KEY1_SUSPEND = 0xaa,
}  FuPixartTpResetKey1;
/**
 * FuPixartTpResetKey2:
 */
typedef enum {
    /**
     * FU_PIXART_TP_RESET_KEY2_REGULAR:
     */
    FU_PIXART_TP_RESET_KEY2_REGULAR = 0xbb,
    /**
     * FU_PIXART_TP_RESET_KEY2_BOOTLOADER:
     */
    FU_PIXART_TP_RESET_KEY2_BOOTLOADER = 0xcc,
}  FuPixartTpResetKey2;
/**
 * FuPixartTpFlashInst:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FLASH_INST_NONE:
     */
    FU_PIXART_TP_FLASH_INST_NONE = 0,
    /**
     * FU_PIXART_TP_FLASH_INST_RD2_REG_BANK:
     */
    FU_PIXART_TP_FLASH_INST_RD2_REG_BANK = 1<<0,
    /**
     * FU_PIXART_TP_FLASH_INST_PROGRAM:
     */
    FU_PIXART_TP_FLASH_INST_PROGRAM = 1<<2,
    /**
     * FU_PIXART_TP_FLASH_INST_INTERNAL_SRAM_ACCESS:
     */
    FU_PIXART_TP_FLASH_INST_INTERNAL_SRAM_ACCESS = 1<<7,
} G_GNUC_FLAG_ENUM FuPixartTpFlashInst;
/**
 * FuPixartTpClocksPowerUp:
 */
typedef enum {
    /**
     * FU_PIXART_TP_CLOCKS_POWER_UP_CPU:
     */
    FU_PIXART_TP_CLOCKS_POWER_UP_CPU = 1<<1,
} G_GNUC_FLAG_ENUM FuPixartTpClocksPowerUp;
/**
 * FuPixartTpFlashExecState:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FLASH_EXEC_STATE_BUSY:
     */
    FU_PIXART_TP_FLASH_EXEC_STATE_BUSY = 0x01,
    /**
     * FU_PIXART_TP_FLASH_EXEC_STATE_SUCCESS:
     */
    FU_PIXART_TP_FLASH_EXEC_STATE_SUCCESS = 0x00,
}  FuPixartTpFlashExecState;
/**
 * FuPixartTpFlashWriteEnable:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FLASH_WRITE_ENABLE_SUCCESS:
     */
    FU_PIXART_TP_FLASH_WRITE_ENABLE_SUCCESS = 0x02,
}  FuPixartTpFlashWriteEnable;
/**
 * FuPixartTpFlashStatus:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FLASH_STATUS_BUSY:
     */
    FU_PIXART_TP_FLASH_STATUS_BUSY = 0x01,
}  FuPixartTpFlashStatus;
/**
 * FuPixartTpFlashCcr:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FLASH_CCR_WRITE_ENABLE:
     */
    FU_PIXART_TP_FLASH_CCR_WRITE_ENABLE = 0x00000106,
    /**
     * FU_PIXART_TP_FLASH_CCR_READ_STATUS:
     */
    FU_PIXART_TP_FLASH_CCR_READ_STATUS = 0x01000105,
    /**
     * FU_PIXART_TP_FLASH_CCR_ERASE_SECTOR:
     */
    FU_PIXART_TP_FLASH_CCR_ERASE_SECTOR = 0x00002520,
    /**
     * FU_PIXART_TP_FLASH_CCR_PROGRAM_PAGE:
     */
    FU_PIXART_TP_FLASH_CCR_PROGRAM_PAGE = 0x01002502,
}  FuPixartTpFlashCcr;
/**
 * FuPixartTpPartId:
 */
typedef enum {
    /**
     * FU_PIXART_TP_PART_ID_PJP274:
     */
    FU_PIXART_TP_PART_ID_PJP274 = 0x0274,
}  FuPixartTpPartId;
/**
 * FuPixartTpCrcCtrl:
 */
typedef enum {
    /**
     * FU_PIXART_TP_CRC_CTRL_FW_BANK0:
     */
    FU_PIXART_TP_CRC_CTRL_FW_BANK0 = 0x02,
    /**
     * FU_PIXART_TP_CRC_CTRL_FW_BANK1:
     */
    FU_PIXART_TP_CRC_CTRL_FW_BANK1 = 0x10,
    /**
     * FU_PIXART_TP_CRC_CTRL_PARAM_BANK0:
     */
    FU_PIXART_TP_CRC_CTRL_PARAM_BANK0 = 0x04,
    /**
     * FU_PIXART_TP_CRC_CTRL_PARAM_BANK1:
     */
    FU_PIXART_TP_CRC_CTRL_PARAM_BANK1 = 0x20,
    /**
     * FU_PIXART_TP_CRC_CTRL_BUSY:
     */
    FU_PIXART_TP_CRC_CTRL_BUSY = 0x01,
}  FuPixartTpCrcCtrl;
/**
 * FuPixartTpProxyMode:
 *
 * host <-> tf pass-through proxy mode
 */
typedef enum {
    /**
     * FU_PIXART_TP_PROXY_MODE_NORMAL:
     */
    FU_PIXART_TP_PROXY_MODE_NORMAL = 0x00,
    /**
     * FU_PIXART_TP_PROXY_MODE_TF_UPDATE:
     */
    FU_PIXART_TP_PROXY_MODE_TF_UPDATE = 0x01,
}  FuPixartTpProxyMode;
/**
 * FuPixartTpTfFrameConst:
 *
 * tf feature report / rmi frame constants
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE:
     */
    FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE = 0x5a,
    /**
     * FU_PIXART_TP_TF_FRAME_CONST_TAIL:
     */
    FU_PIXART_TP_TF_FRAME_CONST_TAIL = 0xa5,
    /**
     * FU_PIXART_TP_TF_FRAME_CONST_EXCEPTION_FLAG:
     */
    FU_PIXART_TP_TF_FRAME_CONST_EXCEPTION_FLAG = 0x80,
}  FuPixartTpTfFrameConst;
/**
 * FuPixartTpTfReportId:
 *
 * tf hid report ids
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH:
     */
    FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH = 0xcc,
}  FuPixartTpTfReportId;
/**
 * FuPixartTpTfTargetAddr:
 *
 * tf rmi target address
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME:
     */
    FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME = 0x2c,
}  FuPixartTpTfTargetAddr;
/**
 * FuPixartTpTfRmiFunc:
 *
 * tf rmi function codes (func field)
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_RMI_FUNC_WRITE_SIMPLE:
     */
    FU_PIXART_TP_TF_RMI_FUNC_WRITE_SIMPLE = 0x00,
    /**
     * FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET:
     */
    FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET = 0x04,
    /**
     * FU_PIXART_TP_TF_RMI_FUNC_READ:
     */
    FU_PIXART_TP_TF_RMI_FUNC_READ = 0x0b,
}  FuPixartTpTfRmiFunc;
/**
 * FuPixartTpTfCmd:
 *
 * tf function command ids (high-level tf commands)
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_CMD_SET_UPGRADE_MODE:
     */
    FU_PIXART_TP_TF_CMD_SET_UPGRADE_MODE = 0x0001,
    /**
     * FU_PIXART_TP_TF_CMD_WRITE_UPGRADE_DATA:
     */
    FU_PIXART_TP_TF_CMD_WRITE_UPGRADE_DATA = 0x0002,
    /**
     * FU_PIXART_TP_TF_CMD_READ_UPGRADE_STATUS:
     */
    FU_PIXART_TP_TF_CMD_READ_UPGRADE_STATUS = 0x0003,
    /**
     * FU_PIXART_TP_TF_CMD_READ_VERSION:
     */
    FU_PIXART_TP_TF_CMD_READ_VERSION = 0x0007,
    /**
     * FU_PIXART_TP_TF_CMD_TOUCH_CONTROL:
     */
    FU_PIXART_TP_TF_CMD_TOUCH_CONTROL = 0x0303,
}  FuPixartTpTfCmd;
/**
 * FuPixartTpTfUpgradeMode:
 *
 * tf upgrade mode payload
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_UPGRADE_MODE_EXIT:
     */
    FU_PIXART_TP_TF_UPGRADE_MODE_EXIT = 0x00,
    /**
     * FU_PIXART_TP_TF_UPGRADE_MODE_ENTER_BOOT:
     */
    FU_PIXART_TP_TF_UPGRADE_MODE_ENTER_BOOT = 0x01,
    /**
     * FU_PIXART_TP_TF_UPGRADE_MODE_ERASE_FLASH:
     */
    FU_PIXART_TP_TF_UPGRADE_MODE_ERASE_FLASH = 0x02,
}  FuPixartTpTfUpgradeMode;
/**
 * FuPixartTpTfTouchControl:
 *
 * tf touch control
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_TOUCH_CONTROL_ENABLE:
     */
    FU_PIXART_TP_TF_TOUCH_CONTROL_ENABLE = 0x00,
    /**
     * FU_PIXART_TP_TF_TOUCH_CONTROL_DISABLE:
     */
    FU_PIXART_TP_TF_TOUCH_CONTROL_DISABLE = 0x01,
}  FuPixartTpTfTouchControl;
/**
 * FuPixartTpTfFwMode:
 *
 * tf firmware version mode
 */
typedef enum {
    /**
     * FU_PIXART_TP_TF_FW_MODE_APP:
     */
    FU_PIXART_TP_TF_FW_MODE_APP = 1,
    /**
     * FU_PIXART_TP_TF_FW_MODE_BOOT:
     */
    FU_PIXART_TP_TF_FW_MODE_BOOT = 2,
    /**
     * FU_PIXART_TP_TF_FW_MODE_ALGO:
     */
    FU_PIXART_TP_TF_FW_MODE_ALGO = 3,
}  FuPixartTpTfFwMode;
/**
 * FuPixartTpUpdateType:
 */
typedef enum {
    /**
     * FU_PIXART_TP_UPDATE_TYPE_GENERAL:
     */
    FU_PIXART_TP_UPDATE_TYPE_GENERAL = 0,
    /**
     * FU_PIXART_TP_UPDATE_TYPE_FW_SECTION:
     */
    FU_PIXART_TP_UPDATE_TYPE_FW_SECTION = 1,
    /**
     * FU_PIXART_TP_UPDATE_TYPE_BOOTLOADER:
     */
    FU_PIXART_TP_UPDATE_TYPE_BOOTLOADER = 2,
    /**
     * FU_PIXART_TP_UPDATE_TYPE_PARAM:
     */
    FU_PIXART_TP_UPDATE_TYPE_PARAM = 3,
    /**
     * FU_PIXART_TP_UPDATE_TYPE_TF_FORCE:
     */
    FU_PIXART_TP_UPDATE_TYPE_TF_FORCE = 16,
}  FuPixartTpUpdateType;
const gchar *fu_pixart_tp_update_type_to_string(FuPixartTpUpdateType val) G_GNUC_CONST;
FuPixartTpUpdateType fu_pixart_tp_update_type_from_string(const gchar *val) G_GNUC_CONST G_GNUC_NON_NULL(1);
/**
 * FuPixartTpFirmwareFlags:
 */
typedef enum {
    /**
     * FU_PIXART_TP_FIRMWARE_FLAG_NONE:
     */
    FU_PIXART_TP_FIRMWARE_FLAG_NONE = 0,
    /**
     * FU_PIXART_TP_FIRMWARE_FLAG_VALID:
     */
    FU_PIXART_TP_FIRMWARE_FLAG_VALID = 1<<0,
    /**
     * FU_PIXART_TP_FIRMWARE_FLAG_IS_EXTERNAL:
     */
    FU_PIXART_TP_FIRMWARE_FLAG_IS_EXTERNAL = 1<<1,
} G_GNUC_FLAG_ENUM FuPixartTpFirmwareFlags;
gchar *fu_pixart_tp_firmware_flags_to_string(FuPixartTpFirmwareFlags val) G_GNUC_CONST;
FuPixartTpFirmwareFlags fu_pixart_tp_firmware_flags_from_string(const gchar *val) G_GNUC_CONST G_GNUC_NON_NULL(1);
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfVersionPayload;

FuStructPixartTpTfVersionPayload *fu_struct_pixart_tp_tf_version_payload_ref(FuStructPixartTpTfVersionPayload *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_version_payload_unref(FuStructPixartTpTfVersionPayload *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfVersionPayload, fu_struct_pixart_tp_tf_version_payload_unref)
FuStructPixartTpTfVersionPayload *fu_struct_pixart_tp_tf_version_payload_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_struct_pixart_tp_tf_version_payload_get_major(const FuStructPixartTpTfVersionPayload *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_struct_pixart_tp_tf_version_payload_get_minor(const FuStructPixartTpTfVersionPayload *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_struct_pixart_tp_tf_version_payload_get_patch(const FuStructPixartTpTfVersionPayload *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_VERSION_PAYLOAD_OFFSET_MAJOR 0x0
#define FU_STRUCT_PIXART_TP_TF_VERSION_PAYLOAD_OFFSET_MINOR 0x1
#define FU_STRUCT_PIXART_TP_TF_VERSION_PAYLOAD_OFFSET_PATCH 0x2
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_VERSION_PAYLOAD_SIZE 0x3
#endif

#ifndef __GI_SCANNER__
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfDownloadStatusPayload;

FuStructPixartTpTfDownloadStatusPayload *fu_struct_pixart_tp_tf_download_status_payload_ref(FuStructPixartTpTfDownloadStatusPayload *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_download_status_payload_unref(FuStructPixartTpTfDownloadStatusPayload *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfDownloadStatusPayload, fu_struct_pixart_tp_tf_download_status_payload_unref)
FuStructPixartTpTfDownloadStatusPayload *fu_struct_pixart_tp_tf_download_status_payload_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_struct_pixart_tp_tf_download_status_payload_get_status(const FuStructPixartTpTfDownloadStatusPayload *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_tf_download_status_payload_get_packet_number(const FuStructPixartTpTfDownloadStatusPayload *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_DOWNLOAD_STATUS_PAYLOAD_OFFSET_STATUS 0x0
#define FU_STRUCT_PIXART_TP_TF_DOWNLOAD_STATUS_PAYLOAD_OFFSET_PACKET_NUMBER 0x1
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_DOWNLOAD_STATUS_PAYLOAD_SIZE 0x3
#endif

#ifndef __GI_SCANNER__
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfWriteSimpleCmd;

FuStructPixartTpTfWriteSimpleCmd *fu_struct_pixart_tp_tf_write_simple_cmd_ref(FuStructPixartTpTfWriteSimpleCmd *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_unref(FuStructPixartTpTfWriteSimpleCmd *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfWriteSimpleCmd, fu_struct_pixart_tp_tf_write_simple_cmd_unref)
FuStructPixartTpTfWriteSimpleCmd *fu_struct_pixart_tp_tf_write_simple_cmd_new(void) G_GNUC_WARN_UNUSED_RESULT;
void fu_struct_pixart_tp_tf_write_simple_cmd_set_report_id(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfReportId value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_set_preamble(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfFrameConst value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_set_target_addr(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfTargetAddr value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_set_func(FuStructPixartTpTfWriteSimpleCmd *st, FuPixartTpTfRmiFunc value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_set_addr(FuStructPixartTpTfWriteSimpleCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_simple_cmd_set_len(FuStructPixartTpTfWriteSimpleCmd *st, guint16 value) G_GNUC_NON_NULL(1);

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_REPORT_ID 0x0
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_PREAMBLE 0x1
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_TARGET_ADDR 0x2
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_FUNC 0x3
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_ADDR 0x4
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_OFFSET_LEN 0x6
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_SIZE 0x8
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_DEFAULT_REPORT_ID FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_DEFAULT_PREAMBLE FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_DEFAULT_TARGET_ADDR FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME
#define FU_STRUCT_PIXART_TP_TF_WRITE_SIMPLE_CMD_DEFAULT_FUNC FU_PIXART_TP_TF_RMI_FUNC_WRITE_SIMPLE
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfWritePacketCmd;

FuStructPixartTpTfWritePacketCmd *fu_struct_pixart_tp_tf_write_packet_cmd_ref(FuStructPixartTpTfWritePacketCmd *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_unref(FuStructPixartTpTfWritePacketCmd *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfWritePacketCmd, fu_struct_pixart_tp_tf_write_packet_cmd_unref)
FuStructPixartTpTfWritePacketCmd *fu_struct_pixart_tp_tf_write_packet_cmd_new(void) G_GNUC_WARN_UNUSED_RESULT;
void fu_struct_pixart_tp_tf_write_packet_cmd_set_report_id(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfReportId value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_preamble(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfFrameConst value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_target_addr(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfTargetAddr value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_func(FuStructPixartTpTfWritePacketCmd *st, FuPixartTpTfRmiFunc value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_addr(FuStructPixartTpTfWritePacketCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_datalen(FuStructPixartTpTfWritePacketCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_total(FuStructPixartTpTfWritePacketCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_write_packet_cmd_set_packet_index(FuStructPixartTpTfWritePacketCmd *st, guint16 value) G_GNUC_NON_NULL(1);

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_REPORT_ID 0x0
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_PREAMBLE 0x1
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_TARGET_ADDR 0x2
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_FUNC 0x3
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_ADDR 0x4
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_DATALEN 0x6
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_PACKET_TOTAL 0x8
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_OFFSET_PACKET_INDEX 0xA
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_SIZE 0xC
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_DEFAULT_REPORT_ID FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_DEFAULT_PREAMBLE FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_DEFAULT_TARGET_ADDR FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME
#define FU_STRUCT_PIXART_TP_TF_WRITE_PACKET_CMD_DEFAULT_FUNC FU_PIXART_TP_TF_RMI_FUNC_WRITE_PACKET
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfReadCmd;

FuStructPixartTpTfReadCmd *fu_struct_pixart_tp_tf_read_cmd_ref(FuStructPixartTpTfReadCmd *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_unref(FuStructPixartTpTfReadCmd *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfReadCmd, fu_struct_pixart_tp_tf_read_cmd_unref)
FuStructPixartTpTfReadCmd *fu_struct_pixart_tp_tf_read_cmd_new(void) G_GNUC_WARN_UNUSED_RESULT;
void fu_struct_pixart_tp_tf_read_cmd_set_report_id(FuStructPixartTpTfReadCmd *st, FuPixartTpTfReportId value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_preamble(FuStructPixartTpTfReadCmd *st, FuPixartTpTfFrameConst value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_target_addr(FuStructPixartTpTfReadCmd *st, FuPixartTpTfTargetAddr value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_func(FuStructPixartTpTfReadCmd *st, FuPixartTpTfRmiFunc value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_addr(FuStructPixartTpTfReadCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_datalen(FuStructPixartTpTfReadCmd *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_read_cmd_set_reply_len(FuStructPixartTpTfReadCmd *st, guint16 value) G_GNUC_NON_NULL(1);

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_REPORT_ID 0x0
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_PREAMBLE 0x1
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_TARGET_ADDR 0x2
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_FUNC 0x3
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_ADDR 0x4
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_DATALEN 0x6
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_OFFSET_REPLY_LEN 0x8
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_SIZE 0xA
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_DEFAULT_REPORT_ID FU_PIXART_TP_TF_REPORT_ID_PASS_THROUGH
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_DEFAULT_PREAMBLE FU_PIXART_TP_TF_FRAME_CONST_PREAMBLE
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_DEFAULT_TARGET_ADDR FU_PIXART_TP_TF_TARGET_ADDR_RMI_FRAME
#define FU_STRUCT_PIXART_TP_TF_READ_CMD_DEFAULT_FUNC FU_PIXART_TP_TF_RMI_FUNC_READ
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpTfReplyHdr;

FuStructPixartTpTfReplyHdr *fu_struct_pixart_tp_tf_reply_hdr_ref(FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_tf_reply_hdr_unref(FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpTfReplyHdr, fu_struct_pixart_tp_tf_reply_hdr_unref)
FuStructPixartTpTfReplyHdr *fu_struct_pixart_tp_tf_reply_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuPixartTpTfReportId fu_struct_pixart_tp_tf_reply_hdr_get_report_id(const FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuPixartTpTfFrameConst fu_struct_pixart_tp_tf_reply_hdr_get_preamble(const FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuPixartTpTfTargetAddr fu_struct_pixart_tp_tf_reply_hdr_get_target_addr(const FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuPixartTpTfRmiFunc fu_struct_pixart_tp_tf_reply_hdr_get_func(const FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_tf_reply_hdr_get_datalen(const FuStructPixartTpTfReplyHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_OFFSET_REPORT_ID 0x0
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_OFFSET_PREAMBLE 0x1
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_OFFSET_TARGET_ADDR 0x2
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_OFFSET_FUNC 0x3
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_OFFSET_DATALEN 0x4
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_TF_REPLY_HDR_SIZE 0x6
#endif

#ifndef __GI_SCANNER__
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpFirmwareHdr;

FuStructPixartTpFirmwareHdr *fu_struct_pixart_tp_firmware_hdr_ref(FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_unref(FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpFirmwareHdr, fu_struct_pixart_tp_firmware_hdr_unref)
FuStructPixartTpFirmwareHdr *fu_struct_pixart_tp_firmware_hdr_new(void) G_GNUC_WARN_UNUSED_RESULT;
FuStructPixartTpFirmwareHdr *fu_struct_pixart_tp_firmware_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
gboolean fu_struct_pixart_tp_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_firmware_hdr_get_header_ver(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_firmware_hdr_get_file_ver(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_firmware_hdr_get_ic_part_id(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_firmware_hdr_get_flash_sectors(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint32 fu_struct_pixart_tp_firmware_hdr_get_file_crc32(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_struct_pixart_tp_firmware_hdr_get_num_sections(const FuStructPixartTpFirmwareHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
void fu_struct_pixart_tp_firmware_hdr_set_header_ver(FuStructPixartTpFirmwareHdr *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_set_file_ver(FuStructPixartTpFirmwareHdr *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_set_ic_part_id(FuStructPixartTpFirmwareHdr *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_set_flash_sectors(FuStructPixartTpFirmwareHdr *st, guint16 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_set_file_crc32(FuStructPixartTpFirmwareHdr *st, guint32 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_hdr_set_num_sections(FuStructPixartTpFirmwareHdr *st, guint16 value) G_GNUC_NON_NULL(1);

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_MAGIC 0x0
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_HEADER_LEN 0x4
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_HEADER_VER 0x6
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_FILE_VER 0x8
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_IC_PART_ID 0xA
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_FLASH_SECTORS 0xC
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_FILE_CRC32 0xE
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_OFFSET_NUM_SECTIONS 0x12
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_SIZE_MAGIC 0x4
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_N_ELEMENTS_MAGIC 4
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_SIZE 0x14
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_DEFAULT_MAGIC "FWHD"
#define FU_STRUCT_PIXART_TP_FIRMWARE_HDR_DEFAULT_HEADER_LEN 0x0218
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuStructPixartTpFirmwareSectionHdr;

FuStructPixartTpFirmwareSectionHdr *fu_struct_pixart_tp_firmware_section_hdr_ref(FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_unref(FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuStructPixartTpFirmwareSectionHdr, fu_struct_pixart_tp_firmware_section_hdr_unref)
FuStructPixartTpFirmwareSectionHdr *fu_struct_pixart_tp_firmware_section_hdr_new(void) G_GNUC_WARN_UNUSED_RESULT;
FuStructPixartTpFirmwareSectionHdr *fu_struct_pixart_tp_firmware_section_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuPixartTpUpdateType fu_struct_pixart_tp_firmware_section_hdr_get_update_type(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_struct_pixart_tp_firmware_section_hdr_get_update_info(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint32 fu_struct_pixart_tp_firmware_section_hdr_get_target_flash_start(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint32 fu_struct_pixart_tp_firmware_section_hdr_get_internal_file_start(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint32 fu_struct_pixart_tp_firmware_section_hdr_get_section_length(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint32 fu_struct_pixart_tp_firmware_section_hdr_get_section_crc(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
const guint8 *fu_struct_pixart_tp_firmware_section_hdr_get_shared(const FuStructPixartTpFirmwareSectionHdr *st, gsize *bufsz) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
gchar *fu_struct_pixart_tp_firmware_section_hdr_get_extname(const FuStructPixartTpFirmwareSectionHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
void fu_struct_pixart_tp_firmware_section_hdr_set_update_type(FuStructPixartTpFirmwareSectionHdr *st, FuPixartTpUpdateType value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_set_update_info(FuStructPixartTpFirmwareSectionHdr *st, guint8 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_set_target_flash_start(FuStructPixartTpFirmwareSectionHdr *st, guint32 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_set_internal_file_start(FuStructPixartTpFirmwareSectionHdr *st, guint32 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_set_section_length(FuStructPixartTpFirmwareSectionHdr *st, guint32 value) G_GNUC_NON_NULL(1);
void fu_struct_pixart_tp_firmware_section_hdr_set_section_crc(FuStructPixartTpFirmwareSectionHdr *st, guint32 value) G_GNUC_NON_NULL(1);
gboolean fu_struct_pixart_tp_firmware_section_hdr_set_shared(FuStructPixartTpFirmwareSectionHdr *st, const guint8 *buf, gsize bufsz, GError **error) G_GNUC_NON_NULL(1, 2) G_GNUC_WARN_UNUSED_RESULT;
gboolean fu_struct_pixart_tp_firmware_section_hdr_set_extname(FuStructPixartTpFirmwareSectionHdr *st, const gchar *value, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_UPDATE_TYPE 0x0
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_UPDATE_INFO 0x1
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_TARGET_FLASH_START 0x2
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_INTERNAL_FILE_START 0x6
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_SECTION_LENGTH 0xA
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_SECTION_CRC 0xE
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_SHARED 0x12
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_OFFSET_EXTNAME 0x1E
#endif

#ifndef __GI_SCANNER__
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_SIZE_SHARED 0xC
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_N_ELEMENTS_SHARED 12
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_SIZE_EXTNAME 0x22
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_N_ELEMENTS_EXTNAME 34
#define FU_STRUCT_PIXART_TP_FIRMWARE_SECTION_HDR_SIZE 0x40
#endif

#ifndef __GI_SCANNER__
#endif
