/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaptics-rmi-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_rmi_partition_id_to_string:
 * @val: value, e.g. %FU_RMI_PARTITION_ID_BOOTLOADER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_rmi_partition_id_to_string(FuRmiPartitionId val)
{
    if (val == FU_RMI_PARTITION_ID_NONE)
        return "none";
    if (val == FU_RMI_PARTITION_ID_BOOTLOADER)
        return "bootloader";
    if (val == FU_RMI_PARTITION_ID_DEVICE_CONFIG)
        return "device-config";
    if (val == FU_RMI_PARTITION_ID_FLASH_CONFIG)
        return "flash-config";
    if (val == FU_RMI_PARTITION_ID_MANUFACTURING_BLOCK)
        return "manufacturing-block";
    if (val == FU_RMI_PARTITION_ID_GUEST_SERIALIZATION)
        return "guest-serialization";
    if (val == FU_RMI_PARTITION_ID_GLOBAL_PARAMETERS)
        return "global-parameters";
    if (val == FU_RMI_PARTITION_ID_CORE_CODE)
        return "core-code";
    if (val == FU_RMI_PARTITION_ID_CORE_CONFIG)
        return "core-config";
    if (val == FU_RMI_PARTITION_ID_GUEST_CODE)
        return "guest-code";
    if (val == FU_RMI_PARTITION_ID_DISPLAY_CONFIG)
        return "display-config";
    if (val == FU_RMI_PARTITION_ID_EXTERNAL_TOUCH_AFE_CONFIG)
        return "external-touch-afe-config";
    if (val == FU_RMI_PARTITION_ID_UTILITY_PARAMETER)
        return "utility-parameter";
    if (val == FU_RMI_PARTITION_ID_PUBKEY)
        return "pubkey";
    if (val == FU_RMI_PARTITION_ID_FIXED_LOCATION_DATA)
        return "fixed-location-data";
    return NULL;
}

/**
 * fu_rmi_container_id_to_string:
 * @val: value, e.g. %FU_RMI_CONTAINER_ID_UI
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_rmi_container_id_to_string(FuRmiContainerId val)
{
    if (val == FU_RMI_CONTAINER_ID_TOP_LEVEL)
        return "top-level";
    if (val == FU_RMI_CONTAINER_ID_UI)
        return "ui";
    if (val == FU_RMI_CONTAINER_ID_UI_CONFIG)
        return "ui-config";
    if (val == FU_RMI_CONTAINER_ID_BL)
        return "bl";
    if (val == FU_RMI_CONTAINER_ID_BL_IMAGE)
        return "bl-image";
    if (val == FU_RMI_CONTAINER_ID_BL_CONFIG)
        return "bl-config";
    if (val == FU_RMI_CONTAINER_ID_BL_LOCKDOWN_INFO)
        return "bl-lockdown-info";
    if (val == FU_RMI_CONTAINER_ID_PERMANENT_CONFIG)
        return "permanent-config";
    if (val == FU_RMI_CONTAINER_ID_GUEST_CODE)
        return "guest-code";
    if (val == FU_RMI_CONTAINER_ID_BL_PROTOCOL_DESCRIPTOR)
        return "bl-protocol-descriptor";
    if (val == FU_RMI_CONTAINER_ID_UI_PROTOCOL_DESCRIPTOR)
        return "ui-protocol-descriptor";
    if (val == FU_RMI_CONTAINER_ID_RMI_SELF_DISCOVERY)
        return "rmi-self-discovery";
    if (val == FU_RMI_CONTAINER_ID_RMI_PAGE_CONTENT)
        return "rmi-page-content";
    if (val == FU_RMI_CONTAINER_ID_GENERAL_INFORMATION)
        return "general-information";
    if (val == FU_RMI_CONTAINER_ID_DEVICE_CONFIG)
        return "device-config";
    if (val == FU_RMI_CONTAINER_ID_FLASH_CONFIG)
        return "flash-config";
    if (val == FU_RMI_CONTAINER_ID_GUEST_SERIALIZATION)
        return "guest-serialization";
    if (val == FU_RMI_CONTAINER_ID_GLOBAL_PARAMETERS)
        return "global-parameters";
    if (val == FU_RMI_CONTAINER_ID_CORE_CODE)
        return "core-code";
    if (val == FU_RMI_CONTAINER_ID_CORE_CONFIG)
        return "core-config";
    if (val == FU_RMI_CONTAINER_ID_DISPLAY_CONFIG)
        return "display-config";
    if (val == FU_RMI_CONTAINER_ID_EXTERNAL_TOUCH_AFE_CONFIG)
        return "external-touch-afe-config";
    if (val == FU_RMI_CONTAINER_ID_UTILITY)
        return "utility";
    if (val == FU_RMI_CONTAINER_ID_UTILITY_PARAMETER)
        return "utility-parameter";
    if (val == FU_RMI_CONTAINER_ID_FIXED_LOCATION_DATA)
        return "fixed-location-data";
    return NULL;
}







/**
 * fu_struct_rmi_partition_tbl_ref: (skip):
 **/
FuStructRmiPartitionTbl *
fu_struct_rmi_partition_tbl_ref(FuStructRmiPartitionTbl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_rmi_partition_tbl_unref: (skip):
 **/
void
fu_struct_rmi_partition_tbl_unref(FuStructRmiPartitionTbl *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructRmiPartitionTbl refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_rmi_partition_tbl_new_internal: (skip):
 **/
static FuStructRmiPartitionTbl *
fu_struct_rmi_partition_tbl_new_internal(void)
{
    FuStructRmiPartitionTbl *st = g_new0(FuStructRmiPartitionTbl, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_rmi_partition_tbl_get_partition_id: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_id(const FuStructRmiPartitionTbl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_len: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_len(const FuStructRmiPartitionTbl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_addr: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_addr(const FuStructRmiPartitionTbl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_partition_tbl_get_partition_prop: (skip):
 **/
guint16
fu_struct_rmi_partition_tbl_get_partition_prop(const FuStructRmiPartitionTbl *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_partition_tbl_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_partition_tbl_to_string(const FuStructRmiPartitionTbl *st)
{
    g_autoptr(GString) str = g_string_new("FuStructRmiPartitionTbl:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  partition_id: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_id(st));
    g_string_append_printf(str, "  partition_len: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_len(st));
    g_string_append_printf(str, "  partition_addr: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_addr(st));
    g_string_append_printf(str, "  partition_prop: 0x%x\n",
                           (guint) fu_struct_rmi_partition_tbl_get_partition_prop(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_rmi_partition_tbl_validate_internal(FuStructRmiPartitionTbl *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_rmi_partition_tbl_parse_internal(FuStructRmiPartitionTbl *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_rmi_partition_tbl_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_rmi_partition_tbl_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_rmi_partition_tbl_parse: (skip):
 **/
FuStructRmiPartitionTbl *
fu_struct_rmi_partition_tbl_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructRmiPartitionTbl) st = fu_struct_rmi_partition_tbl_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructRmiPartitionTbl: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_rmi_partition_tbl_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_rmi_img_ref: (skip):
 **/
FuStructRmiImg *
fu_struct_rmi_img_ref(FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_rmi_img_unref: (skip):
 **/
void
fu_struct_rmi_img_unref(FuStructRmiImg *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructRmiImg refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_rmi_img_new_internal: (skip):
 **/
static FuStructRmiImg *
fu_struct_rmi_img_new_internal(void)
{
    FuStructRmiImg *st = g_new0(FuStructRmiImg, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_rmi_img_get_checksum: (skip):
 **/
guint32
fu_struct_rmi_img_get_checksum(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_io_offset: (skip):
 **/
guint8
fu_struct_rmi_img_get_io_offset(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_rmi_img_get_bootloader_version: (skip):
 **/
guint8
fu_struct_rmi_img_get_bootloader_version(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_rmi_img_get_image_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_image_size(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_config_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_config_size(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_product_id: (skip):
 **/
gchar *
fu_struct_rmi_img_get_product_id(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 10, NULL);
}
/**
 * fu_struct_rmi_img_get_package_id: (skip):
 **/
guint32
fu_struct_rmi_img_get_package_id(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_product_info: (skip):
 **/
guint32
fu_struct_rmi_img_get_product_info(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 30, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_fw_build_id: (skip):
 **/
guint32
fu_struct_rmi_img_get_fw_build_id(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 80, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_get_signature_size: (skip):
 **/
guint32
fu_struct_rmi_img_get_signature_size(const FuStructRmiImg *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 84, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_img_set_checksum: (skip):
 **/
void
fu_struct_rmi_img_set_checksum(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_io_offset: (skip):
 **/
void
fu_struct_rmi_img_set_io_offset(FuStructRmiImg *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_rmi_img_set_bootloader_version: (skip):
 **/
void
fu_struct_rmi_img_set_bootloader_version(FuStructRmiImg *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_rmi_img_set_image_size: (skip):
 **/
void
fu_struct_rmi_img_set_image_size(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_config_size: (skip):
 **/
void
fu_struct_rmi_img_set_config_size(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_product_id: (skip):
 **/
gboolean
fu_struct_rmi_img_set_product_id(FuStructRmiImg *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 16, 0x0, 10);
        return TRUE;
    }
    len = strlen(value);
    if (len > 10) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructRmiImg.product_id (0x%x bytes)",
                    value, (guint) len, (guint) 10);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_rmi_img_set_package_id: (skip):
 **/
void
fu_struct_rmi_img_set_package_id(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_product_info: (skip):
 **/
void
fu_struct_rmi_img_set_product_info(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_fw_build_id: (skip):
 **/
void
fu_struct_rmi_img_set_fw_build_id(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 80, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_set_signature_size: (skip):
 **/
void
fu_struct_rmi_img_set_signature_size(FuStructRmiImg *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 84, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_img_new: (skip):
 **/
FuStructRmiImg *
fu_struct_rmi_img_new(void)
{
    FuStructRmiImg *st = fu_struct_rmi_img_new_internal();
    st->buf = g_byte_array_sized_new(88);
    fu_byte_array_set_size(st->buf, 88, 0x0);
    return st;
}
/**
 * fu_struct_rmi_img_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_img_to_string(const FuStructRmiImg *st)
{
    g_autoptr(GString) str = g_string_new("FuStructRmiImg:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_checksum(st));
    g_string_append_printf(str, "  io_offset: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_io_offset(st));
    g_string_append_printf(str, "  bootloader_version: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_bootloader_version(st));
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_image_size(st));
    g_string_append_printf(str, "  config_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_config_size(st));
    {
        g_autofree gchar *tmp = fu_struct_rmi_img_get_product_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  product_id: %s\n", tmp);
    }
    g_string_append_printf(str, "  package_id: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_package_id(st));
    g_string_append_printf(str, "  product_info: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_product_info(st));
    g_string_append_printf(str, "  fw_build_id: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_fw_build_id(st));
    g_string_append_printf(str, "  signature_size: 0x%x\n",
                           (guint) fu_struct_rmi_img_get_signature_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_rmi_img_validate_internal(FuStructRmiImg *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_rmi_img_parse_internal(FuStructRmiImg *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_rmi_img_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_rmi_img_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_rmi_img_parse_stream: (skip):
 **/
FuStructRmiImg *
fu_struct_rmi_img_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructRmiImg) st = fu_struct_rmi_img_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 88, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructRmiImg failed read of 0x%x: ", (guint) 88);
        return NULL;
    }
    if (st->buf->len != 88) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructRmiImg requested 0x%x and got 0x%x",
                    (guint) 88,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_rmi_img_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_rmi_container_descriptor_ref: (skip):
 **/
FuStructRmiContainerDescriptor *
fu_struct_rmi_container_descriptor_ref(FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_rmi_container_descriptor_unref: (skip):
 **/
void
fu_struct_rmi_container_descriptor_unref(FuStructRmiContainerDescriptor *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructRmiContainerDescriptor refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_rmi_container_descriptor_new_internal: (skip):
 **/
static FuStructRmiContainerDescriptor *
fu_struct_rmi_container_descriptor_new_internal(void)
{
    FuStructRmiContainerDescriptor *st = g_new0(FuStructRmiContainerDescriptor, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_rmi_container_descriptor_get_content_checksum: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_checksum(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_container_id: (skip):
 **/
FuRmiContainerId
fu_struct_rmi_container_descriptor_get_container_id(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_minor_version: (skip):
 **/
guint8
fu_struct_rmi_container_descriptor_get_minor_version(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_rmi_container_descriptor_get_major_version: (skip):
 **/
guint8
fu_struct_rmi_container_descriptor_get_major_version(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_rmi_container_descriptor_get_signature_size: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_signature_size(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_container_option_flags: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_container_option_flags(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_options_length: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_options_length(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_options_address: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_options_address(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_length: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_length(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_get_content_address: (skip):
 **/
guint32
fu_struct_rmi_container_descriptor_get_content_address(const FuStructRmiContainerDescriptor *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_rmi_container_descriptor_set_content_checksum: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_checksum(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_container_id: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_container_id(FuStructRmiContainerDescriptor *st, FuRmiContainerId value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_minor_version: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_minor_version(FuStructRmiContainerDescriptor *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_rmi_container_descriptor_set_major_version: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_major_version(FuStructRmiContainerDescriptor *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_rmi_container_descriptor_set_signature_size: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_signature_size(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_container_option_flags: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_container_option_flags(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_options_length: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_options_length(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_options_address: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_options_address(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_length: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_length(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_set_content_address: (skip):
 **/
void
fu_struct_rmi_container_descriptor_set_content_address(FuStructRmiContainerDescriptor *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_rmi_container_descriptor_new: (skip):
 **/
FuStructRmiContainerDescriptor *
fu_struct_rmi_container_descriptor_new(void)
{
    FuStructRmiContainerDescriptor *st = fu_struct_rmi_container_descriptor_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    return st;
}
/**
 * fu_struct_rmi_container_descriptor_to_string: (skip):
 **/
static gchar *
fu_struct_rmi_container_descriptor_to_string(const FuStructRmiContainerDescriptor *st)
{
    g_autoptr(GString) str = g_string_new("FuStructRmiContainerDescriptor:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  content_checksum: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_checksum(st));
    {
        const gchar *tmp = fu_rmi_container_id_to_string(fu_struct_rmi_container_descriptor_get_container_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  container_id: 0x%x [%s]\n", (guint) fu_struct_rmi_container_descriptor_get_container_id(st), tmp);
        } else {
            g_string_append_printf(str, "  container_id: 0x%x\n", (guint) fu_struct_rmi_container_descriptor_get_container_id(st));
        }
    }
    g_string_append_printf(str, "  minor_version: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_minor_version(st));
    g_string_append_printf(str, "  major_version: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_major_version(st));
    g_string_append_printf(str, "  signature_size: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_signature_size(st));
    g_string_append_printf(str, "  container_option_flags: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_container_option_flags(st));
    g_string_append_printf(str, "  content_options_length: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_options_length(st));
    g_string_append_printf(str, "  content_options_address: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_options_address(st));
    g_string_append_printf(str, "  content_length: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_length(st));
    g_string_append_printf(str, "  content_address: 0x%x\n",
                           (guint) fu_struct_rmi_container_descriptor_get_content_address(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_rmi_container_descriptor_validate_internal(FuStructRmiContainerDescriptor *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_rmi_container_descriptor_parse_internal(FuStructRmiContainerDescriptor *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_rmi_container_descriptor_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_rmi_container_descriptor_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_rmi_container_descriptor_parse_stream: (skip):
 **/
FuStructRmiContainerDescriptor *
fu_struct_rmi_container_descriptor_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructRmiContainerDescriptor) st = fu_struct_rmi_container_descriptor_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructRmiContainerDescriptor failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructRmiContainerDescriptor requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_rmi_container_descriptor_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_ref: (skip):
 **/
FuStructSynapticsRmiV7F34x *
fu_struct_synaptics_rmi_v7_f34x_ref(FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_f34x_unref(FuStructSynapticsRmiV7F34x *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7F34x refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7F34x *
fu_struct_synaptics_rmi_v7_f34x_new_internal(void)
{
    FuStructSynapticsRmiV7F34x *st = g_new0(FuStructSynapticsRmiV7F34x, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id0: (skip):
 **/
guint8
fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id0(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id1: (skip):
 **/
guint8
fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id1(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_build_id: (skip):
 **/
guint32
fu_struct_synaptics_rmi_v7_f34x_get_build_id(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_block_size: (skip):
 **/
guint16
fu_struct_synaptics_rmi_v7_f34x_get_block_size(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 7, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_config_length: (skip):
 **/
guint16
fu_struct_synaptics_rmi_v7_f34x_get_config_length(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 13, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_payload_length: (skip):
 **/
guint16
fu_struct_synaptics_rmi_v7_f34x_get_payload_length(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 15, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaptics_rmi_v7_f34x_get_supported_partitions: (skip):
 **/
guint16
fu_struct_synaptics_rmi_v7_f34x_get_supported_partitions(const FuStructSynapticsRmiV7F34x *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 17, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_f34x_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_rmi_v7_f34x_to_string(const FuStructSynapticsRmiV7F34x *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsRmiV7F34x:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  bootloader_id0: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id0(st));
    g_string_append_printf(str, "  bootloader_id1: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_bootloader_id1(st));
    g_string_append_printf(str, "  build_id: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_build_id(st));
    g_string_append_printf(str, "  block_size: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_block_size(st));
    g_string_append_printf(str, "  config_length: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_config_length(st));
    g_string_append_printf(str, "  payload_length: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_payload_length(st));
    g_string_append_printf(str, "  supported_partitions: 0x%x\n",
                           (guint) fu_struct_synaptics_rmi_v7_f34x_get_supported_partitions(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_rmi_v7_f34x_validate_internal(FuStructSynapticsRmiV7F34x *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_rmi_v7_f34x_parse_internal(FuStructSynapticsRmiV7F34x *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_rmi_v7_f34x_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_rmi_v7_f34x_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_rmi_v7_f34x_parse: (skip):
 **/
FuStructSynapticsRmiV7F34x *
fu_struct_synaptics_rmi_v7_f34x_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsRmiV7F34x) st = fu_struct_synaptics_rmi_v7_f34x_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 19, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsRmiV7F34x: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 19);
    if (!fu_struct_synaptics_rmi_v7_f34x_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_ref: (skip):
 **/
FuStructSynapticsRmiV7EnterSbl *
fu_struct_synaptics_rmi_v7_enter_sbl_ref(FuStructSynapticsRmiV7EnterSbl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_sbl_unref(FuStructSynapticsRmiV7EnterSbl *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7EnterSbl refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7EnterSbl *
fu_struct_synaptics_rmi_v7_enter_sbl_new_internal(void)
{
    FuStructSynapticsRmiV7EnterSbl *st = g_new0(FuStructSynapticsRmiV7EnterSbl, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_set_partition_id: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_enter_sbl_set_partition_id(FuStructSynapticsRmiV7EnterSbl *st, FuRmiPartitionId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_set_cmd: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_enter_sbl_set_cmd(FuStructSynapticsRmiV7EnterSbl *st, FuSynapticsRmiFlashCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_set_bootloader_id0: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_sbl_set_bootloader_id0(FuStructSynapticsRmiV7EnterSbl *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_set_bootloader_id1: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_sbl_set_bootloader_id1(FuStructSynapticsRmiV7EnterSbl *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_set_unknown: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_enter_sbl_set_unknown(FuStructSynapticsRmiV7EnterSbl *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_sbl_new: (skip):
 **/
FuStructSynapticsRmiV7EnterSbl *
fu_struct_synaptics_rmi_v7_enter_sbl_new(void)
{
    FuStructSynapticsRmiV7EnterSbl *st = fu_struct_synaptics_rmi_v7_enter_sbl_new_internal();
    st->buf = g_byte_array_sized_new(9);
    fu_byte_array_set_size(st->buf, 9, 0x0);
    fu_struct_synaptics_rmi_v7_enter_sbl_set_partition_id(st, FU_RMI_PARTITION_ID_BOOTLOADER);
    fu_struct_synaptics_rmi_v7_enter_sbl_set_cmd(st, FU_SYNAPTICS_RMI_FLASH_CMD_ENTER_BL);
    fu_struct_synaptics_rmi_v7_enter_sbl_set_unknown(st, 0x1);
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_ref: (skip):
 **/
FuStructSynapticsRmiV7EnterBl *
fu_struct_synaptics_rmi_v7_enter_bl_ref(FuStructSynapticsRmiV7EnterBl *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_bl_unref(FuStructSynapticsRmiV7EnterBl *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7EnterBl refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7EnterBl *
fu_struct_synaptics_rmi_v7_enter_bl_new_internal(void)
{
    FuStructSynapticsRmiV7EnterBl *st = g_new0(FuStructSynapticsRmiV7EnterBl, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_set_partition_id: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_enter_bl_set_partition_id(FuStructSynapticsRmiV7EnterBl *st, FuRmiPartitionId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_set_cmd: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_enter_bl_set_cmd(FuStructSynapticsRmiV7EnterBl *st, FuSynapticsRmiFlashCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_set_bootloader_id0: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_bl_set_bootloader_id0(FuStructSynapticsRmiV7EnterBl *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_set_bootloader_id1: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_enter_bl_set_bootloader_id1(FuStructSynapticsRmiV7EnterBl *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_enter_bl_new: (skip):
 **/
FuStructSynapticsRmiV7EnterBl *
fu_struct_synaptics_rmi_v7_enter_bl_new(void)
{
    FuStructSynapticsRmiV7EnterBl *st = fu_struct_synaptics_rmi_v7_enter_bl_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_synaptics_rmi_v7_enter_bl_set_partition_id(st, FU_RMI_PARTITION_ID_BOOTLOADER);
    fu_struct_synaptics_rmi_v7_enter_bl_set_cmd(st, FU_SYNAPTICS_RMI_FLASH_CMD_ENTER_BL);
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_ref: (skip):
 **/
FuStructSynapticsRmiV7Erase *
fu_struct_synaptics_rmi_v7_erase_ref(FuStructSynapticsRmiV7Erase *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_unref(FuStructSynapticsRmiV7Erase *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7Erase refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_erase_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7Erase *
fu_struct_synaptics_rmi_v7_erase_new_internal(void)
{
    FuStructSynapticsRmiV7Erase *st = g_new0(FuStructSynapticsRmiV7Erase, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_erase_set_partition_id: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_set_partition_id(FuStructSynapticsRmiV7Erase *st, FuRmiPartitionId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_set_cmd: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_erase_set_cmd(FuStructSynapticsRmiV7Erase *st, FuSynapticsRmiFlashCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_set_bootloader_id0: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_set_bootloader_id0(FuStructSynapticsRmiV7Erase *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_set_bootloader_id1: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_set_bootloader_id1(FuStructSynapticsRmiV7Erase *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_new: (skip):
 **/
FuStructSynapticsRmiV7Erase *
fu_struct_synaptics_rmi_v7_erase_new(void)
{
    FuStructSynapticsRmiV7Erase *st = fu_struct_synaptics_rmi_v7_erase_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_synaptics_rmi_v7_erase_set_cmd(st, FU_SYNAPTICS_RMI_FLASH_CMD_ERASE);
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_ref: (skip):
 **/
FuStructSynapticsRmiV7EraseCoreCode *
fu_struct_synaptics_rmi_v7_erase_core_code_ref(FuStructSynapticsRmiV7EraseCoreCode *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_core_code_unref(FuStructSynapticsRmiV7EraseCoreCode *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7EraseCoreCode refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7EraseCoreCode *
fu_struct_synaptics_rmi_v7_erase_core_code_new_internal(void)
{
    FuStructSynapticsRmiV7EraseCoreCode *st = g_new0(FuStructSynapticsRmiV7EraseCoreCode, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_set_partition_id: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_erase_core_code_set_partition_id(FuStructSynapticsRmiV7EraseCoreCode *st, FuRmiPartitionId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_set_cmd: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_core_code_set_cmd(FuStructSynapticsRmiV7EraseCoreCode *st, FuSynapticsRmiFlashCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_set_bootloader_id0: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_core_code_set_bootloader_id0(FuStructSynapticsRmiV7EraseCoreCode *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_set_bootloader_id1: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_core_code_set_bootloader_id1(FuStructSynapticsRmiV7EraseCoreCode *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_code_new: (skip):
 **/
FuStructSynapticsRmiV7EraseCoreCode *
fu_struct_synaptics_rmi_v7_erase_core_code_new(void)
{
    FuStructSynapticsRmiV7EraseCoreCode *st = fu_struct_synaptics_rmi_v7_erase_core_code_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_synaptics_rmi_v7_erase_core_code_set_partition_id(st, FU_RMI_PARTITION_ID_CORE_CODE);
    fu_struct_synaptics_rmi_v7_erase_core_code_set_cmd(st, FU_SYNAPTICS_RMI_FLASH_CMD_ERASE_AP);
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_ref: (skip):
 **/
FuStructSynapticsRmiV7EraseCoreConfig *
fu_struct_synaptics_rmi_v7_erase_core_config_ref(FuStructSynapticsRmiV7EraseCoreConfig *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_unref: (skip):
 **/
void
fu_struct_synaptics_rmi_v7_erase_core_config_unref(FuStructSynapticsRmiV7EraseCoreConfig *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsRmiV7EraseCoreConfig refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_new_internal: (skip):
 **/
static FuStructSynapticsRmiV7EraseCoreConfig *
fu_struct_synaptics_rmi_v7_erase_core_config_new_internal(void)
{
    FuStructSynapticsRmiV7EraseCoreConfig *st = g_new0(FuStructSynapticsRmiV7EraseCoreConfig, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_set_partition_id: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_erase_core_config_set_partition_id(FuStructSynapticsRmiV7EraseCoreConfig *st, FuRmiPartitionId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_set_cmd: (skip):
 **/
static void
fu_struct_synaptics_rmi_v7_erase_core_config_set_cmd(FuStructSynapticsRmiV7EraseCoreConfig *st, FuSynapticsRmiFlashCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaptics_rmi_v7_erase_core_config_new: (skip):
 **/
FuStructSynapticsRmiV7EraseCoreConfig *
fu_struct_synaptics_rmi_v7_erase_core_config_new(void)
{
    FuStructSynapticsRmiV7EraseCoreConfig *st = fu_struct_synaptics_rmi_v7_erase_core_config_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    fu_struct_synaptics_rmi_v7_erase_core_config_set_partition_id(st, FU_RMI_PARTITION_ID_CORE_CONFIG);
    fu_struct_synaptics_rmi_v7_erase_core_config_set_cmd(st, FU_SYNAPTICS_RMI_FLASH_CMD_ERASE);
    return st;
}
