/* Barrier.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Barrier.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/barrier.h>
#include <meta/meta-backend.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BARRIER (gala_barrier_get_type ())
#define GALA_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BARRIER, GalaBarrier))
#define GALA_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BARRIER, GalaBarrierClass))
#define GALA_IS_BARRIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BARRIER))
#define GALA_IS_BARRIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BARRIER))
#define GALA_BARRIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BARRIER, GalaBarrierClass))

typedef struct _GalaBarrier GalaBarrier;
typedef struct _GalaBarrierClass GalaBarrierClass;
typedef struct _GalaBarrierPrivate GalaBarrierPrivate;
enum  {
	GALA_BARRIER_0_PROPERTY,
	GALA_BARRIER_TRIGGERED_PROPERTY,
	GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY,
	GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY,
	GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY,
	GALA_BARRIER_RETRIGGER_DELAY_PROPERTY,
	GALA_BARRIER_NUM_PROPERTIES
};
static GParamSpec* gala_barrier_properties[GALA_BARRIER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_BARRIER_TRIGGER_SIGNAL,
	GALA_BARRIER_NUM_SIGNALS
};
static guint gala_barrier_signals[GALA_BARRIER_NUM_SIGNALS] = {0};

struct _GalaBarrier {
	GObject parent_instance;
	GalaBarrierPrivate * priv;
};

struct _GalaBarrierClass {
	GObjectClass parent_class;
};

struct _GalaBarrierPrivate {
	gboolean _triggered;
	gdouble _trigger_pressure_threshold;
	gdouble _release_pressure_threshold;
	gdouble _retrigger_pressure_threshold;
	gint _retrigger_delay;
	MetaBarrier* barrier;
	guint32 triggered_time;
	gdouble pressure;
};

static gint GalaBarrier_private_offset;
static gpointer gala_barrier_parent_class = NULL;

VALA_EXTERN GType gala_barrier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBarrier, g_object_unref)
VALA_EXTERN GalaBarrier* gala_barrier_new (MetaBackend* backend,
                               gint x1,
                               gint y1,
                               gint x2,
                               gint y2,
                               MetaBarrierDirection directions,
                               gdouble trigger_pressure_threshold,
                               gdouble release_pressure_threshold,
                               gdouble retrigger_pressure_threshold,
                               gint retrigger_delay);
VALA_EXTERN GalaBarrier* gala_barrier_construct (GType object_type,
                                     MetaBackend* backend,
                                     gint x1,
                                     gint y1,
                                     gint x2,
                                     gint y2,
                                     MetaBarrierDirection directions,
                                     gdouble trigger_pressure_threshold,
                                     gdouble release_pressure_threshold,
                                     gdouble retrigger_pressure_threshold,
                                     gint retrigger_delay);
static void gala_barrier_on_hit (GalaBarrier* self,
                          MetaBarrierEvent* event);
static void _gala_barrier_on_hit_meta_barrier_hit (MetaBarrier* _sender,
                                            MetaBarrierEvent* event,
                                            gpointer self);
static void gala_barrier_on_left (GalaBarrier* self);
static void _gala_barrier_on_left_meta_barrier_left (MetaBarrier* _sender,
                                              MetaBarrierEvent* event,
                                              gpointer self);
VALA_EXTERN gboolean gala_barrier_get_triggered (GalaBarrier* self);
VALA_EXTERN gdouble gala_barrier_get_trigger_pressure_threshold (GalaBarrier* self);
static void gala_barrier_emit_trigger (GalaBarrier* self,
                                guint32 time);
VALA_EXTERN gdouble gala_barrier_get_release_pressure_threshold (GalaBarrier* self);
VALA_EXTERN gdouble gala_barrier_get_retrigger_pressure_threshold (GalaBarrier* self);
VALA_EXTERN gint gala_barrier_get_retrigger_delay (GalaBarrier* self);
VALA_EXTERN void gala_barrier_set_triggered (GalaBarrier* self,
                                 gboolean value);
static void gala_barrier_set_trigger_pressure_threshold (GalaBarrier* self,
                                                  gdouble value);
static void gala_barrier_set_release_pressure_threshold (GalaBarrier* self,
                                                  gdouble value);
static void gala_barrier_set_retrigger_pressure_threshold (GalaBarrier* self,
                                                    gdouble value);
static void gala_barrier_set_retrigger_delay (GalaBarrier* self,
                                       gint value);
static void gala_barrier_finalize (GObject * obj);
static GType gala_barrier_get_type_once (void);
static void _vala_gala_barrier_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gala_barrier_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
gala_barrier_get_instance_private (GalaBarrier* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBarrier_private_offset);
}

/**
     * @param trigger_pressure_threshold The amount of pixels to travel additionally for
     * the barrier to trigger. Set to 0 to immediately activate.
     * @param retrigger_pressure_threshold The amount of pixels to travel additionally for
     * the barrier to trigger again. Set to int.MAX to disallow retrigger.
     */
static void
_gala_barrier_on_hit_meta_barrier_hit (MetaBarrier* _sender,
                                       MetaBarrierEvent* event,
                                       gpointer self)
{
	gala_barrier_on_hit ((GalaBarrier*) self, event);
}

static void
_gala_barrier_on_left_meta_barrier_left (MetaBarrier* _sender,
                                         MetaBarrierEvent* event,
                                         gpointer self)
{
	gala_barrier_on_left ((GalaBarrier*) self);
}

GalaBarrier*
gala_barrier_construct (GType object_type,
                        MetaBackend* backend,
                        gint x1,
                        gint y1,
                        gint x2,
                        gint y2,
                        MetaBarrierDirection directions,
                        gdouble trigger_pressure_threshold,
                        gdouble release_pressure_threshold,
                        gdouble retrigger_pressure_threshold,
                        gint retrigger_delay)
{
	GalaBarrier * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (backend != NULL, NULL);
	self = (GalaBarrier*) g_object_new (object_type, "trigger-pressure-threshold", trigger_pressure_threshold, "release-pressure-threshold", release_pressure_threshold, "retrigger-pressure-threshold", retrigger_pressure_threshold, "retrigger-delay", retrigger_delay, NULL);
	{
		MetaBarrier* _tmp0_ = NULL;
		MetaBarrier* _tmp1_;
		MetaBarrier* _tmp2_;
		MetaBarrier* _tmp3_;
		MetaBarrier* _tmp4_;
		_tmp1_ = meta_barrier_new (backend, x1, y1, x2, y2, directions, META_BARRIER_FLAG_NONE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->barrier);
		self->priv->barrier = _tmp2_;
		_tmp3_ = self->priv->barrier;
		g_signal_connect_object (_tmp3_, "hit", (GCallback) _gala_barrier_on_hit_meta_barrier_hit, self, 0);
		_tmp4_ = self->priv->barrier;
		g_signal_connect_object (_tmp4_, "left", (GCallback) _gala_barrier_on_left_meta_barrier_left, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("Barrier.vala:54: Failed to create Meta Barrier");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

GalaBarrier*
gala_barrier_new (MetaBackend* backend,
                  gint x1,
                  gint y1,
                  gint x2,
                  gint y2,
                  MetaBarrierDirection directions,
                  gdouble trigger_pressure_threshold,
                  gdouble release_pressure_threshold,
                  gdouble retrigger_pressure_threshold,
                  gint retrigger_delay)
{
	return gala_barrier_construct (GALA_TYPE_BARRIER, backend, x1, y1, x2, y2, directions, trigger_pressure_threshold, release_pressure_threshold, retrigger_pressure_threshold, retrigger_delay);
}

static void
gala_barrier_on_hit (GalaBarrier* self,
                     MetaBarrierEvent* event)
{
	gboolean _tmp0_ = FALSE;
	MetaBarrier* _tmp1_;
	MetaBarrierDirection _tmp2_;
	MetaBarrierDirection _tmp3_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = self->priv->barrier;
	g_object_get (_tmp1_, "directions", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if ((_tmp3_ & META_BARRIER_DIRECTION_POSITIVE_X) == META_BARRIER_DIRECTION_POSITIVE_X) {
		_tmp0_ = TRUE;
	} else {
		MetaBarrier* _tmp4_;
		MetaBarrierDirection _tmp5_;
		MetaBarrierDirection _tmp6_;
		_tmp4_ = self->priv->barrier;
		g_object_get (_tmp4_, "directions", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp0_ = (_tmp6_ & META_BARRIER_DIRECTION_NEGATIVE_X) == META_BARRIER_DIRECTION_NEGATIVE_X;
	}
	if (_tmp0_) {
		self->priv->pressure = self->priv->pressure + fabs (event->dx);
	} else {
		self->priv->pressure = self->priv->pressure + fabs (event->dy);
	}
	_tmp8_ = self->priv->_triggered;
	if (!_tmp8_) {
		gdouble _tmp9_;
		_tmp9_ = self->priv->_trigger_pressure_threshold;
		_tmp7_ = self->priv->pressure > _tmp9_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gala_barrier_emit_trigger (self, event->time);
	}
	_tmp11_ = self->priv->_triggered;
	if (!_tmp11_) {
		gdouble _tmp12_;
		_tmp12_ = self->priv->_release_pressure_threshold;
		_tmp10_ = self->priv->pressure > _tmp12_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		MetaBarrier* _tmp13_;
		_tmp13_ = self->priv->barrier;
		meta_barrier_release (_tmp13_, event);
	}
	_tmp15_ = self->priv->_triggered;
	if (_tmp15_) {
		_tmp14_ = (event->time - self->priv->triggered_time) > ((guint32) 150);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		MetaBarrier* _tmp16_;
		_tmp16_ = self->priv->barrier;
		meta_barrier_release (_tmp16_, event);
	}
	_tmp19_ = self->priv->_triggered;
	if (_tmp19_) {
		gdouble _tmp20_;
		_tmp20_ = self->priv->_retrigger_pressure_threshold;
		_tmp18_ = fabs (self->priv->pressure) > _tmp20_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint _tmp21_;
		_tmp21_ = self->priv->_retrigger_delay;
		_tmp17_ = event->time > (_tmp21_ + self->priv->triggered_time);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gala_barrier_emit_trigger (self, event->time);
	}
}

static void
gala_barrier_emit_trigger (GalaBarrier* self,
                           guint32 time)
{
	g_return_if_fail (self != NULL);
	gala_barrier_set_triggered (self, TRUE);
	self->priv->pressure = (gdouble) 0;
	self->priv->triggered_time = time;
	g_signal_emit (self, gala_barrier_signals[GALA_BARRIER_TRIGGER_SIGNAL], 0);
}

static void
gala_barrier_on_left (GalaBarrier* self)
{
	g_return_if_fail (self != NULL);
	self->priv->pressure = (gdouble) 0;
	gala_barrier_set_triggered (self, FALSE);
}

gboolean
gala_barrier_get_triggered (GalaBarrier* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_triggered;
	return result;
}

void
gala_barrier_set_triggered (GalaBarrier* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_triggered (self);
	if (old_value != value) {
		self->priv->_triggered = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_TRIGGERED_PROPERTY]);
	}
}

gdouble
gala_barrier_get_trigger_pressure_threshold (GalaBarrier* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_trigger_pressure_threshold;
	return result;
}

static void
gala_barrier_set_trigger_pressure_threshold (GalaBarrier* self,
                                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_trigger_pressure_threshold (self);
	if (old_value != value) {
		self->priv->_trigger_pressure_threshold = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY]);
	}
}

gdouble
gala_barrier_get_release_pressure_threshold (GalaBarrier* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_release_pressure_threshold;
	return result;
}

static void
gala_barrier_set_release_pressure_threshold (GalaBarrier* self,
                                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_release_pressure_threshold (self);
	if (old_value != value) {
		self->priv->_release_pressure_threshold = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY]);
	}
}

gdouble
gala_barrier_get_retrigger_pressure_threshold (GalaBarrier* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_retrigger_pressure_threshold;
	return result;
}

static void
gala_barrier_set_retrigger_pressure_threshold (GalaBarrier* self,
                                               gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_retrigger_pressure_threshold (self);
	if (old_value != value) {
		self->priv->_retrigger_pressure_threshold = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY]);
	}
}

gint
gala_barrier_get_retrigger_delay (GalaBarrier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_retrigger_delay;
	return result;
}

static void
gala_barrier_set_retrigger_delay (GalaBarrier* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_barrier_get_retrigger_delay (self);
	if (old_value != value) {
		self->priv->_retrigger_delay = value;
		g_object_notify_by_pspec ((GObject *) self, gala_barrier_properties[GALA_BARRIER_RETRIGGER_DELAY_PROPERTY]);
	}
}

static void
gala_barrier_class_init (GalaBarrierClass * klass,
                         gpointer klass_data)
{
	gala_barrier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBarrier_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_barrier_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_barrier_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_barrier_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_TRIGGERED_PROPERTY, gala_barrier_properties[GALA_BARRIER_TRIGGERED_PROPERTY] = g_param_spec_boolean ("triggered", "triggered", "triggered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY, gala_barrier_properties[GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY] = g_param_spec_double ("trigger-pressure-threshold", "trigger-pressure-threshold", "trigger-pressure-threshold", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY, gala_barrier_properties[GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY] = g_param_spec_double ("release-pressure-threshold", "release-pressure-threshold", "release-pressure-threshold", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY, gala_barrier_properties[GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY] = g_param_spec_double ("retrigger-pressure-threshold", "retrigger-pressure-threshold", "retrigger-pressure-threshold", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BARRIER_RETRIGGER_DELAY_PROPERTY, gala_barrier_properties[GALA_BARRIER_RETRIGGER_DELAY_PROPERTY] = g_param_spec_int ("retrigger-delay", "retrigger-delay", "retrigger-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_barrier_signals[GALA_BARRIER_TRIGGER_SIGNAL] = g_signal_new ("trigger", GALA_TYPE_BARRIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_barrier_instance_init (GalaBarrier * self,
                            gpointer klass)
{
	self->priv = gala_barrier_get_instance_private (self);
	self->priv->_triggered = FALSE;
}

static void
gala_barrier_finalize (GObject * obj)
{
	GalaBarrier * self;
	MetaBarrier* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BARRIER, GalaBarrier);
	_tmp0_ = self->priv->barrier;
	meta_barrier_destroy (_tmp0_);
	_g_object_unref0 (self->priv->barrier);
	G_OBJECT_CLASS (gala_barrier_parent_class)->finalize (obj);
}

/**
  * A pointer barrier supporting pressured activation.
  */
 G_GNUC_NO_INLINE static GType
gala_barrier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBarrierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_barrier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBarrier), 0, (GInstanceInitFunc) gala_barrier_instance_init, NULL };
	GType gala_barrier_type_id;
	gala_barrier_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBarrier", &g_define_type_info, 0);
	GalaBarrier_private_offset = g_type_add_instance_private (gala_barrier_type_id, sizeof (GalaBarrierPrivate));
	return gala_barrier_type_id;
}

GType
gala_barrier_get_type (void)
{
	static gsize gala_barrier_type_id__once = 0;
	if (g_once_init_enter (&gala_barrier_type_id__once)) {
		GType gala_barrier_type_id;
		gala_barrier_type_id = gala_barrier_get_type_once ();
		g_once_init_leave (&gala_barrier_type_id__once, gala_barrier_type_id);
	}
	return gala_barrier_type_id__once;
}

static void
_vala_gala_barrier_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GalaBarrier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BARRIER, GalaBarrier);
	switch (property_id) {
		case GALA_BARRIER_TRIGGERED_PROPERTY:
		g_value_set_boolean (value, gala_barrier_get_triggered (self));
		break;
		case GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY:
		g_value_set_double (value, gala_barrier_get_trigger_pressure_threshold (self));
		break;
		case GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY:
		g_value_set_double (value, gala_barrier_get_release_pressure_threshold (self));
		break;
		case GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY:
		g_value_set_double (value, gala_barrier_get_retrigger_pressure_threshold (self));
		break;
		case GALA_BARRIER_RETRIGGER_DELAY_PROPERTY:
		g_value_set_int (value, gala_barrier_get_retrigger_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_barrier_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GalaBarrier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BARRIER, GalaBarrier);
	switch (property_id) {
		case GALA_BARRIER_TRIGGERED_PROPERTY:
		gala_barrier_set_triggered (self, g_value_get_boolean (value));
		break;
		case GALA_BARRIER_TRIGGER_PRESSURE_THRESHOLD_PROPERTY:
		gala_barrier_set_trigger_pressure_threshold (self, g_value_get_double (value));
		break;
		case GALA_BARRIER_RELEASE_PRESSURE_THRESHOLD_PROPERTY:
		gala_barrier_set_release_pressure_threshold (self, g_value_get_double (value));
		break;
		case GALA_BARRIER_RETRIGGER_PRESSURE_THRESHOLD_PROPERTY:
		gala_barrier_set_retrigger_pressure_threshold (self, g_value_get_double (value));
		break;
		case GALA_BARRIER_RETRIGGER_DELAY_PROPERTY:
		gala_barrier_set_retrigger_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

