/* folder-list-tree.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from folder-list-tree.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define FOLDER_LIST_TREE_INBOX_ORDINAL -2
#define FOLDER_LIST_TREE_SEARCH_ORDINAL -1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLDER_LIST_TREE_0_PROPERTY,
	FOLDER_LIST_TREE_SELECTED_PROPERTY,
	FOLDER_LIST_TREE_NUM_PROPERTIES
};
static GParamSpec* folder_list_tree_properties[FOLDER_LIST_TREE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
enum  {
	FOLDER_LIST_TREE_FOLDER_SELECTED_SIGNAL,
	FOLDER_LIST_TREE_FOLDER_ACTIVATED_SIGNAL,
	FOLDER_LIST_TREE_COPY_CONVERSATION_SIGNAL,
	FOLDER_LIST_TREE_MOVE_CONVERSATION_SIGNAL,
	FOLDER_LIST_TREE_NUM_SIGNALS
};
static guint folder_list_tree_signals[FOLDER_LIST_TREE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolderListTreePrivate {
	GearyFolder* _selected;
	GeeHashMap* account_branches;
	FolderListInboxesBranch* inboxes_branch;
	FolderListSearchBranch* search_branch;
};

static gint FolderListTree_private_offset;
static gpointer folder_list_tree_parent_class = NULL;
static GearyBaseInterfaceIface * folder_list_tree_geary_base_interface_parent_iface = NULL;

static void folder_list_tree_set_selected (FolderListTree* self,
                                    GearyFolder* value);
static void folder_list_tree_drop_handler (FolderListTree* self,
                                    GdkDragContext* context,
                                    SidebarEntry* entry,
                                    GtkSelectionData* data,
                                    guint info,
                                    guint time);
static void _folder_list_tree_drop_handler_sidebar_tree_external_drop_handler (GdkDragContext* context,
                                                                        SidebarEntry* entry,
                                                                        GtkSelectionData* data,
                                                                        guint info,
                                                                        guint time,
                                                                        gpointer self);
static void folder_list_tree_on_entry_selected (FolderListTree* self,
                                         SidebarSelectableEntry* selectable);
static void _folder_list_tree_on_entry_selected_sidebar_tree_entry_selected (SidebarTree* _sender,
                                                                      SidebarSelectableEntry* selectable,
                                                                      gpointer self);
static void folder_list_tree_on_entry_activated (FolderListTree* self,
                                          SidebarSelectableEntry* selectable);
static void _folder_list_tree_on_entry_activated_sidebar_tree_entry_activated (SidebarTree* _sender,
                                                                        SidebarSelectableEntry* selectable,
                                                                        gpointer self);
static void folder_list_tree_real_get_preferred_width (GtkWidget* base,
                                                gint* minimum_size,
                                                gint* natural_size);
static FolderListFolderEntry* folder_list_tree_get_folder_entry (FolderListTree* self,
                                                          GearyFolder* folder);
static gboolean folder_list_tree_real_accept_cursor_changed (SidebarTree* base);
VALA_EXTERN gboolean application_main_window_close_composer (ApplicationMainWindow* self,
                                                 gboolean should_prompt,
                                                 gboolean is_shutdown);
static void folder_list_tree_on_ordinal_changed (FolderListTree* self);
static void _folder_list_tree_on_ordinal_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static gboolean folder_list_tree_real_drag_motion (GtkWidget* base,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            guint time);
static void folder_list_tree_finalize (GObject * obj);
static GType folder_list_tree_get_type_once (void);
static void _vala_folder_list_tree_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_folder_list_tree_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

const GtkTargetEntry FOLDER_LIST_TREE_TARGET_ENTRY_LIST[1] = {{"application/x-geary-mail", (guint) GTK_TARGET_SAME_APP, (guint) 0}};

static inline gpointer
folder_list_tree_get_instance_private (FolderListTree* self)
{
	return G_STRUCT_MEMBER_P (self, FolderListTree_private_offset);
}

GearyFolder*
folder_list_tree_get_selected (FolderListTree* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (FOLDER_LIST_IS_TREE (self), NULL);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folder_list_tree_set_selected (FolderListTree* self,
                               GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	old_value = folder_list_tree_get_selected (self);
	if (old_value != value) {
		GearyFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected);
		self->priv->_selected = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folder_list_tree_properties[FOLDER_LIST_TREE_SELECTED_PROPERTY]);
	}
}

static void
_folder_list_tree_drop_handler_sidebar_tree_external_drop_handler (GdkDragContext* context,
                                                                   SidebarEntry* entry,
                                                                   GtkSelectionData* data,
                                                                   guint info,
                                                                   guint time,
                                                                   gpointer self)
{
	folder_list_tree_drop_handler ((FolderListTree*) self, context, entry, data, info, time);
}

static void
_folder_list_tree_on_entry_selected_sidebar_tree_entry_selected (SidebarTree* _sender,
                                                                 SidebarSelectableEntry* selectable,
                                                                 gpointer self)
{
	folder_list_tree_on_entry_selected ((FolderListTree*) self, selectable);
}

static void
_folder_list_tree_on_entry_activated_sidebar_tree_entry_activated (SidebarTree* _sender,
                                                                   SidebarSelectableEntry* selectable,
                                                                   gpointer self)
{
	folder_list_tree_on_entry_activated ((FolderListTree*) self, selectable);
}

FolderListTree*
folder_list_tree_construct (GType object_type)
{
	FolderListTree * self = NULL;
	GtkBindingSet* binding_set = NULL;
	GtkBindingSet* _tmp0_;
	self = (FolderListTree*) sidebar_tree_construct (object_type, FOLDER_LIST_TREE_TARGET_ENTRY_LIST, (gint) G_N_ELEMENTS (FOLDER_LIST_TREE_TARGET_ENTRY_LIST), GDK_ACTION_COPY | GDK_ACTION_MOVE, _folder_list_tree_drop_handler_sidebar_tree_external_drop_handler, self, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	gtk_tree_view_set_activate_on_single_click (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), TRUE);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), "entry-selected", (GCallback) _folder_list_tree_on_entry_selected_sidebar_tree_entry_selected, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), "entry-activated", (GCallback) _folder_list_tree_on_entry_activated_sidebar_tree_entry_activated, self, 0);
	_tmp0_ = gtk_binding_set_find ("GtkTreeView");
	binding_set = _tmp0_;
	_vala_assert (binding_set != NULL, "binding_set != null");
	gtk_binding_entry_remove (binding_set, GDK_KEY_N, GDK_CONTROL_MASK);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
	return self;
}

FolderListTree*
folder_list_tree_new (void)
{
	return folder_list_tree_construct (FOLDER_LIST_TYPE_TREE);
}

static void
folder_list_tree_real_get_preferred_width (GtkWidget* base,
                                           gint* minimum_size,
                                           gint* natural_size)
{
	FolderListTree * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_TREE, FolderListTree);
	_vala_minimum_size = 360;
	_vala_natural_size = 500;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

void
folder_list_tree_set_has_new (FolderListTree* self,
                              GearyFolder* folder,
                              gboolean has_new)
{
	FolderListFolderEntry* entry = NULL;
	FolderListFolderEntry* _tmp0_;
	FolderListFolderEntry* _tmp1_;
	gboolean _tmp3_ = FALSE;
	GearyFolderSpecialUse _tmp4_;
	GearyFolderSpecialUse _tmp5_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	_tmp0_ = folder_list_tree_get_folder_entry (self, folder);
	entry = _tmp0_;
	_tmp1_ = entry;
	if (_tmp1_ != NULL) {
		FolderListFolderEntry* _tmp2_;
		_tmp2_ = entry;
		folder_list_folder_entry_set_has_new (_tmp2_, has_new);
	}
	_tmp4_ = geary_folder_get_used_as (folder);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == GEARY_FOLDER_SPECIAL_USE_INBOX) {
		FolderListInboxesBranch* _tmp6_;
		_tmp6_ = self->priv->inboxes_branch;
		_tmp3_ = sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		FolderListInboxesBranch* _tmp7_;
		GearyAccount* _tmp8_;
		GearyAccount* _tmp9_;
		FolderListInboxFolderEntry* _tmp10_;
		FolderListFolderEntry* _tmp11_;
		_tmp7_ = self->priv->inboxes_branch;
		_tmp8_ = geary_folder_get_account (folder);
		_tmp9_ = _tmp8_;
		_tmp10_ = folder_list_inboxes_branch_get_entry_for_account (_tmp7_, _tmp9_);
		_g_object_unref0 (entry);
		entry = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, FOLDER_LIST_TYPE_FOLDER_ENTRY, FolderListFolderEntry);
		_tmp11_ = entry;
		if (_tmp11_ != NULL) {
			FolderListFolderEntry* _tmp12_;
			_tmp12_ = entry;
			folder_list_folder_entry_set_has_new (_tmp12_, has_new);
		}
	}
	_g_object_unref0 (entry);
}

static void
folder_list_tree_drop_handler (FolderListTree* self,
                               GdkDragContext* context,
                               SidebarEntry* entry,
                               GtkSelectionData* data,
                               guint info,
                               guint time)
{
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()));
	g_return_if_fail ((entry == NULL) || SIDEBAR_IS_ENTRY (entry));
	g_return_if_fail (data != NULL);
}

static FolderListFolderEntry*
folder_list_tree_get_folder_entry (FolderListTree* self,
                                   GearyFolder* folder)
{
	FolderListAccountBranch* account_branch = NULL;
	GeeHashMap* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	gpointer _tmp3_;
	FolderListFolderEntry* _tmp4_ = NULL;
	FolderListAccountBranch* _tmp5_;
	FolderListFolderEntry* result;
	g_return_val_if_fail (FOLDER_LIST_IS_TREE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER), NULL);
	_tmp0_ = self->priv->account_branches;
	_tmp1_ = geary_folder_get_account (folder);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	account_branch = (FolderListAccountBranch*) _tmp3_;
	_tmp5_ = account_branch;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (_tmp4_);
		_tmp4_ = NULL;
	} else {
		FolderListAccountBranch* _tmp6_;
		GearyFolderPath* _tmp7_;
		GearyFolderPath* _tmp8_;
		FolderListFolderEntry* _tmp9_;
		_tmp6_ = account_branch;
		_tmp7_ = geary_folder_get_path (folder);
		_tmp8_ = _tmp7_;
		_tmp9_ = folder_list_account_branch_get_entry_for_path (_tmp6_, _tmp8_);
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp9_;
	}
	result = _tmp4_;
	_g_object_unref0 (account_branch);
	return result;
}

static gboolean
folder_list_tree_real_accept_cursor_changed (SidebarTree* base)
{
	FolderListTree * self;
	gboolean can_switch = FALSE;
	ApplicationMainWindow* parent = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_TREE, FolderListTree);
	can_switch = TRUE;
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	parent = _tmp1_;
	_tmp2_ = parent;
	if (_tmp2_ != NULL) {
		ApplicationMainWindow* _tmp3_;
		_tmp3_ = parent;
		can_switch = application_main_window_close_composer (_tmp3_, FALSE, FALSE);
	}
	result = can_switch;
	_g_object_unref0 (parent);
	return result;
}

static void
folder_list_tree_on_entry_selected (FolderListTree* self,
                                    SidebarSelectableEntry* selectable)
{
	FolderListAbstractFolderEntry* entry = NULL;
	FolderListAbstractFolderEntry* _tmp0_;
	FolderListAbstractFolderEntry* _tmp1_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_SELECTABLE_ENTRY (selectable));
	_tmp0_ = _g_object_ref0 (FOLDER_LIST_IS_ABSTRACT_FOLDER_ENTRY (selectable) ? ((FolderListAbstractFolderEntry*) selectable) : NULL);
	entry = _tmp0_;
	_tmp1_ = entry;
	if (_tmp1_ != NULL) {
		FolderListAbstractFolderEntry* _tmp2_;
		GearyFolder* _tmp3_;
		GearyFolder* _tmp4_;
		FolderListAbstractFolderEntry* _tmp5_;
		GearyFolder* _tmp6_;
		GearyFolder* _tmp7_;
		_tmp2_ = entry;
		_tmp3_ = folder_list_abstract_folder_entry_get_folder (_tmp2_);
		_tmp4_ = _tmp3_;
		folder_list_tree_set_selected (self, _tmp4_);
		_tmp5_ = entry;
		_tmp6_ = folder_list_abstract_folder_entry_get_folder (_tmp5_);
		_tmp7_ = _tmp6_;
		g_signal_emit (self, folder_list_tree_signals[FOLDER_LIST_TREE_FOLDER_SELECTED_SIGNAL], 0, _tmp7_);
	}
	_g_object_unref0 (entry);
}

static void
folder_list_tree_on_entry_activated (FolderListTree* self,
                                     SidebarSelectableEntry* selectable)
{
	FolderListAbstractFolderEntry* entry = NULL;
	FolderListAbstractFolderEntry* _tmp0_;
	FolderListAbstractFolderEntry* _tmp1_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (SIDEBAR_IS_SELECTABLE_ENTRY (selectable));
	_tmp0_ = _g_object_ref0 (FOLDER_LIST_IS_ABSTRACT_FOLDER_ENTRY (selectable) ? ((FolderListAbstractFolderEntry*) selectable) : NULL);
	entry = _tmp0_;
	_tmp1_ = entry;
	if (_tmp1_ != NULL) {
		FolderListAbstractFolderEntry* _tmp2_;
		GearyFolder* _tmp3_;
		GearyFolder* _tmp4_;
		_tmp2_ = entry;
		_tmp3_ = folder_list_abstract_folder_entry_get_folder (_tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_emit (self, folder_list_tree_signals[FOLDER_LIST_TREE_FOLDER_ACTIVATED_SIGNAL], 0, _tmp4_);
	}
	_g_object_unref0 (entry);
}

void
folder_list_tree_set_user_folders_root_name (FolderListTree* self,
                                             GearyAccount* account,
                                             const gchar* name)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->account_branches;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account)) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		FolderListAccountBranch* _tmp3_;
		FolderListSpecialGrouping* _tmp4_;
		FolderListSpecialGrouping* _tmp5_;
		_tmp1_ = self->priv->account_branches;
		_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account);
		_tmp3_ = (FolderListAccountBranch*) _tmp2_;
		_tmp4_ = folder_list_account_branch_get_user_folder_group (_tmp3_);
		_tmp5_ = _tmp4_;
		sidebar_renameable_entry_rename (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SIDEBAR_TYPE_RENAMEABLE_ENTRY, SidebarRenameableEntry), name);
		_g_object_unref0 (_tmp3_);
	}
}

static void
_folder_list_tree_on_ordinal_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	folder_list_tree_on_ordinal_changed ((FolderListTree*) self);
}

void
folder_list_tree_add_folder (FolderListTree* self,
                             ApplicationFolderContext* context)
{
	GearyFolder* folder = NULL;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyAccount* account = NULL;
	GearyFolder* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	GeeHashMap* _tmp7_;
	GearyAccount* _tmp8_;
	FolderListAccountBranch* account_branch = NULL;
	GeeHashMap* _tmp17_;
	GearyAccount* _tmp18_;
	gpointer _tmp19_;
	FolderListAccountBranch* _tmp20_;
	gboolean _tmp27_ = FALSE;
	GeeHashMap* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GearyFolder* _tmp33_;
	GearyFolderSpecialUse _tmp34_;
	GearyFolderSpecialUse _tmp35_;
	FolderListAccountBranch* _tmp37_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (context));
	_tmp0_ = application_folder_context_get_folder (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	folder = _tmp2_;
	_tmp3_ = folder;
	_tmp4_ = geary_folder_get_account (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	account = _tmp6_;
	_tmp7_ = self->priv->account_branches;
	_tmp8_ = account;
	if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_)) {
		GeeHashMap* _tmp9_;
		GearyAccount* _tmp10_;
		GearyAccount* _tmp11_;
		FolderListAccountBranch* _tmp12_;
		FolderListAccountBranch* _tmp13_;
		GearyAccount* _tmp14_;
		GearyAccountInformation* _tmp15_;
		GearyAccountInformation* _tmp16_;
		_tmp9_ = self->priv->account_branches;
		_tmp10_ = account;
		_tmp11_ = account;
		_tmp12_ = folder_list_account_branch_new (_tmp11_);
		_tmp13_ = _tmp12_;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, _tmp13_);
		_g_object_unref0 (_tmp13_);
		_tmp14_ = account;
		_tmp15_ = geary_account_get_information (_tmp14_);
		_tmp16_ = _tmp15_;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "notify::ordinal", (GCallback) _folder_list_tree_on_ordinal_changed_g_object_notify, self, 0);
	}
	_tmp17_ = self->priv->account_branches;
	_tmp18_ = account;
	_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
	account_branch = (FolderListAccountBranch*) _tmp19_;
	_tmp20_ = account_branch;
	if (!sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, SIDEBAR_TYPE_BRANCH, SidebarBranch))) {
		FolderListAccountBranch* _tmp21_;
		GearyAccount* _tmp22_;
		GearyAccountInformation* _tmp23_;
		GearyAccountInformation* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp21_ = account_branch;
		_tmp22_ = account;
		_tmp23_ = geary_account_get_information (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = geary_account_information_get_ordinal (_tmp24_);
		_tmp26_ = _tmp25_;
		sidebar_tree_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp26_);
	}
	_tmp28_ = self->priv->account_branches;
	_tmp29_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp30_ = _tmp29_;
	if (_tmp30_ > 1) {
		FolderListInboxesBranch* _tmp31_;
		_tmp31_ = self->priv->inboxes_branch;
		_tmp27_ = !sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		FolderListInboxesBranch* _tmp32_;
		_tmp32_ = self->priv->inboxes_branch;
		sidebar_tree_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, SIDEBAR_TYPE_BRANCH, SidebarBranch), FOLDER_LIST_TREE_INBOX_ORDINAL);
	}
	_tmp33_ = folder;
	_tmp34_ = geary_folder_get_used_as (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == GEARY_FOLDER_SPECIAL_USE_INBOX) {
		FolderListInboxesBranch* _tmp36_;
		_tmp36_ = self->priv->inboxes_branch;
		folder_list_inboxes_branch_add_inbox (_tmp36_, context);
	}
	_tmp37_ = account_branch;
	folder_list_account_branch_add_folder (_tmp37_, context);
	_g_object_unref0 (account_branch);
	_g_object_unref0 (account);
	_g_object_unref0 (folder);
}

void
folder_list_tree_remove_folder (FolderListTree* self,
                                ApplicationFolderContext* context)
{
	GearyFolder* folder = NULL;
	GearyFolder* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyAccount* account = NULL;
	GearyFolder* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccount* _tmp5_;
	GearyAccount* _tmp6_;
	FolderListAccountBranch* account_branch = NULL;
	GeeHashMap* _tmp7_;
	GearyAccount* _tmp8_;
	gpointer _tmp9_;
	FolderListFolderEntry* entry = NULL;
	FolderListAccountBranch* _tmp10_;
	GearyFolder* _tmp11_;
	GearyFolderPath* _tmp12_;
	GearyFolderPath* _tmp13_;
	FolderListFolderEntry* _tmp14_;
	gboolean _tmp15_ = FALSE;
	FolderListInboxesBranch* _tmp16_;
	gboolean _tmp31_ = FALSE;
	FolderListFolderEntry* _tmp32_;
	GearyFolder* _tmp34_;
	GearyFolderSpecialUse _tmp35_;
	GearyFolderSpecialUse _tmp36_;
	FolderListAccountBranch* _tmp39_;
	GearyFolder* _tmp40_;
	GearyFolderPath* _tmp41_;
	GearyFolderPath* _tmp42_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (APPLICATION_IS_FOLDER_CONTEXT (context));
	_tmp0_ = application_folder_context_get_folder (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	folder = _tmp2_;
	_tmp3_ = folder;
	_tmp4_ = geary_folder_get_account (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	account = _tmp6_;
	_tmp7_ = self->priv->account_branches;
	_tmp8_ = account;
	_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
	account_branch = (FolderListAccountBranch*) _tmp9_;
	_tmp10_ = account_branch;
	_tmp11_ = folder;
	_tmp12_ = geary_folder_get_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = folder_list_account_branch_get_entry_for_path (_tmp10_, _tmp13_);
	entry = _tmp14_;
	_tmp16_ = self->priv->inboxes_branch;
	if (sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, SIDEBAR_TYPE_BRANCH, SidebarBranch))) {
		gboolean _tmp17_ = FALSE;
		FolderListFolderEntry* _tmp18_;
		_tmp18_ = entry;
		if (_tmp18_ == NULL) {
			_tmp17_ = TRUE;
		} else {
			FolderListFolderEntry* _tmp19_;
			_tmp19_ = entry;
			_tmp17_ = !sidebar_tree_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
		}
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		FolderListInboxFolderEntry* inbox_entry = NULL;
		FolderListInboxesBranch* _tmp20_;
		GearyAccount* _tmp21_;
		FolderListInboxFolderEntry* _tmp22_;
		gboolean _tmp23_ = FALSE;
		FolderListInboxFolderEntry* _tmp24_;
		_tmp20_ = self->priv->inboxes_branch;
		_tmp21_ = account;
		_tmp22_ = folder_list_inboxes_branch_get_entry_for_account (_tmp20_, _tmp21_);
		inbox_entry = _tmp22_;
		_tmp24_ = inbox_entry;
		if (_tmp24_ != NULL) {
			FolderListInboxFolderEntry* _tmp25_;
			GearyFolder* _tmp26_;
			GearyFolder* _tmp27_;
			GearyFolder* _tmp28_;
			_tmp25_ = inbox_entry;
			_tmp26_ = folder_list_abstract_folder_entry_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, FOLDER_LIST_TYPE_ABSTRACT_FOLDER_ENTRY, FolderListAbstractFolderEntry));
			_tmp27_ = _tmp26_;
			_tmp28_ = folder;
			_tmp23_ = _tmp27_ == _tmp28_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			FolderListInboxFolderEntry* _tmp29_;
			FolderListFolderEntry* _tmp30_;
			_tmp29_ = inbox_entry;
			_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, FOLDER_LIST_TYPE_FOLDER_ENTRY, FolderListFolderEntry));
			_g_object_unref0 (entry);
			entry = _tmp30_;
		}
		_g_object_unref0 (inbox_entry);
	}
	_tmp32_ = entry;
	if (_tmp32_ != NULL) {
		FolderListFolderEntry* _tmp33_;
		_tmp33_ = entry;
		_tmp31_ = sidebar_tree_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, SIDEBAR_TYPE_ENTRY, SidebarEntry));
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		folder_list_tree_deselect_folder (self);
	}
	_tmp34_ = folder;
	_tmp35_ = geary_folder_get_used_as (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == GEARY_FOLDER_SPECIAL_USE_INBOX) {
		FolderListInboxesBranch* _tmp37_;
		GearyAccount* _tmp38_;
		_tmp37_ = self->priv->inboxes_branch;
		_tmp38_ = account;
		folder_list_inboxes_branch_remove_inbox (_tmp37_, _tmp38_);
	}
	_tmp39_ = account_branch;
	_tmp40_ = folder;
	_tmp41_ = geary_folder_get_path (_tmp40_);
	_tmp42_ = _tmp41_;
	folder_list_account_branch_remove_folder (_tmp39_, _tmp42_);
	_g_object_unref0 (entry);
	_g_object_unref0 (account_branch);
	_g_object_unref0 (account);
	_g_object_unref0 (folder);
}

void
folder_list_tree_remove_account (FolderListTree* self,
                                 GearyAccount* account)
{
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyFolder* _tmp5_;
	FolderListAccountBranch* account_branch = NULL;
	GeeHashMap* _tmp9_;
	gpointer _tmp10_;
	FolderListAccountBranch* _tmp11_;
	FolderListInboxesBranch* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeHashMap* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	_tmp0_ = geary_account_get_information (account);
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("notify::ordinal", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _folder_list_tree_on_ordinal_changed_g_object_notify, self);
	_tmp5_ = self->priv->_selected;
	if (_tmp5_ != NULL) {
		GearyFolder* _tmp6_;
		GearyAccount* _tmp7_;
		GearyAccount* _tmp8_;
		_tmp6_ = self->priv->_selected;
		_tmp7_ = geary_folder_get_account (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == account;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		folder_list_tree_deselect_folder (self);
	}
	_tmp9_ = self->priv->account_branches;
	_tmp10_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account);
	account_branch = (FolderListAccountBranch*) _tmp10_;
	_tmp11_ = account_branch;
	if (_tmp11_ != NULL) {
		FolderListAccountBranch* _tmp12_;
		GeeHashMap* _tmp14_;
		_tmp12_ = account_branch;
		if (sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SIDEBAR_TYPE_BRANCH, SidebarBranch))) {
			FolderListAccountBranch* _tmp13_;
			_tmp13_ = account_branch;
			sidebar_tree_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
		}
		_tmp14_ = self->priv->account_branches;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), account, NULL);
	}
	_tmp15_ = self->priv->inboxes_branch;
	folder_list_inboxes_branch_remove_inbox (_tmp15_, account);
	_tmp17_ = self->priv->account_branches;
	_tmp18_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp19_ = _tmp18_;
	if (_tmp19_ <= 1) {
		FolderListInboxesBranch* _tmp20_;
		_tmp20_ = self->priv->inboxes_branch;
		_tmp16_ = sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		FolderListInboxesBranch* _tmp21_;
		_tmp21_ = self->priv->inboxes_branch;
		sidebar_tree_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	}
	_g_object_unref0 (account_branch);
}

void
folder_list_tree_select_folder (FolderListTree* self,
                                GearyFolder* to_select)
{
	GearyFolder* _tmp0_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_select, GEARY_TYPE_FOLDER));
	_tmp0_ = self->priv->_selected;
	if (_tmp0_ != to_select) {
		gboolean selected = FALSE;
		GearyFolderSpecialUse _tmp1_;
		GearyFolderSpecialUse _tmp2_;
		selected = FALSE;
		_tmp1_ = geary_folder_get_used_as (to_select);
		_tmp2_ = _tmp1_;
		if (_tmp2_ == GEARY_FOLDER_SPECIAL_USE_INBOX) {
			GearyAccount* _tmp3_;
			GearyAccount* _tmp4_;
			_tmp3_ = geary_folder_get_account (to_select);
			_tmp4_ = _tmp3_;
			selected = folder_list_tree_select_inbox (self, _tmp4_);
		}
		if (!selected) {
			FolderListFolderEntry* entry = NULL;
			FolderListFolderEntry* _tmp5_;
			FolderListFolderEntry* _tmp6_;
			_tmp5_ = folder_list_tree_get_folder_entry (self, to_select);
			entry = _tmp5_;
			_tmp6_ = entry;
			if (_tmp6_ != NULL) {
				FolderListFolderEntry* _tmp7_;
				_tmp7_ = entry;
				sidebar_tree_place_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SIDEBAR_TYPE_ENTRY, SidebarEntry), FALSE);
			}
			_g_object_unref0 (entry);
		}
	}
}

gboolean
folder_list_tree_select_inbox (FolderListTree* self,
                               GearyAccount* account)
{
	FolderListInboxesBranch* _tmp0_;
	FolderListInboxFolderEntry* entry = NULL;
	FolderListInboxesBranch* _tmp1_;
	FolderListInboxFolderEntry* _tmp2_;
	FolderListInboxFolderEntry* _tmp3_;
	FolderListInboxFolderEntry* _tmp4_;
	gboolean result;
	g_return_val_if_fail (FOLDER_LIST_IS_TREE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), FALSE);
	_tmp0_ = self->priv->inboxes_branch;
	if (!sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SIDEBAR_TYPE_BRANCH, SidebarBranch))) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->inboxes_branch;
	_tmp2_ = folder_list_inboxes_branch_get_entry_for_account (_tmp1_, account);
	entry = _tmp2_;
	_tmp3_ = entry;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (entry);
		return result;
	}
	_tmp4_ = entry;
	sidebar_tree_place_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SIDEBAR_TYPE_ENTRY, SidebarEntry), FALSE);
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

void
folder_list_tree_deselect_folder (FolderListTree* self)
{
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	GtkTreeSelection* _tmp10_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	_tmp0_ = gtk_tree_view_get_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp4_ = gtk_tree_model_get_iter_first (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkTreePath* first = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		GtkTreePath* _tmp7_;
		GtkTreePath* _tmp8_;
		_tmp5_ = model;
		_tmp6_ = iter;
		_tmp7_ = gtk_tree_model_get_path (_tmp5_, &_tmp6_);
		first = _tmp7_;
		_tmp8_ = first;
		if (_tmp8_ != NULL) {
			GtkTreePath* _tmp9_;
			_tmp9_ = first;
			gtk_tree_view_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView), _tmp9_, NULL, FALSE);
		}
		__vala_GtkTreePath_free0 (first);
	}
	_tmp10_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_view_get_type (), GtkTreeView));
	gtk_tree_selection_unselect_all (_tmp10_);
	folder_list_tree_set_selected (self, NULL);
	g_signal_emit (self, folder_list_tree_signals[FOLDER_LIST_TREE_FOLDER_SELECTED_SIGNAL], 0, NULL);
	_g_object_unref0 (model);
}

static gboolean
folder_list_tree_real_drag_motion (GtkWidget* base,
                                   GdkDragContext* context,
                                   gint x,
                                   gint y,
                                   guint time)
{
	FolderListTree * self;
	gboolean ret = FALSE;
	GdkModifierType mask = 0U;
	gdouble* axes = NULL;
	gdouble* _tmp0_;
	gint axes_length1;
	gint _axes_size_;
	GdkDevice* _tmp1_;
	GdkWindow* _tmp2_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	GdkModifierType _tmp4_ = 0U;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FOLDER_LIST_TYPE_TREE, FolderListTree);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, gdk_drag_context_get_type ()), FALSE);
	ret = GTK_WIDGET_CLASS (folder_list_tree_parent_class)->drag_motion (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), gtk_widget_get_type (), GtkWidget), context, x, y, time);
	_tmp0_ = g_new0 (gdouble, 2);
	axes = _tmp0_;
	axes_length1 = 2;
	_axes_size_ = axes_length1;
	_tmp1_ = gdk_drag_context_get_device (context);
	_tmp2_ = gdk_drag_context_get_dest_window (context);
	_tmp3_ = axes;
	_tmp3__length1 = axes_length1;
	gdk_device_get_state (_tmp1_, _tmp2_, _tmp3_, &_tmp4_);
	mask = _tmp4_;
	if ((mask & GDK_CONTROL_MASK) != 0) {
		gdk_drag_status (context, GDK_ACTION_COPY, (guint32) time);
	} else {
		gdk_drag_status (context, GDK_ACTION_MOVE, (guint32) time);
	}
	result = ret;
	axes = (g_free (axes), NULL);
	return result;
}

void
folder_list_tree_set_search (FolderListTree* self,
                             GearyEngine* engine,
                             GearyAppSearchFolder* search_folder)
{
	gboolean _tmp0_ = FALSE;
	FolderListSearchBranch* _tmp1_;
	FolderListSearchBranch* _tmp10_;
	FolderListSearchBranch* _tmp11_;
	FolderListSearchBranch* _tmp12_;
	SidebarEntry* _tmp13_;
	SidebarEntry* _tmp14_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (engine, GEARY_TYPE_ENGINE));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (search_folder, GEARY_APP_TYPE_SEARCH_FOLDER));
	_tmp1_ = self->priv->search_branch;
	if (_tmp1_ != NULL) {
		FolderListSearchBranch* _tmp2_;
		_tmp2_ = self->priv->search_branch;
		_tmp0_ = sidebar_tree_has_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FolderListSearchBranch* _tmp3_;
		GearyAppSearchFolder* _tmp4_;
		GearyAppSearchFolder* _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->search_branch;
		_tmp4_ = folder_list_search_branch_get_search_folder (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = search_folder == _tmp5_;
		_g_object_unref0 (_tmp5_);
		if (_tmp6_) {
			FolderListSearchBranch* _tmp7_;
			SidebarEntry* _tmp8_;
			SidebarEntry* _tmp9_;
			_tmp7_ = self->priv->search_branch;
			_tmp8_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
			_tmp9_ = _tmp8_;
			sidebar_tree_place_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), _tmp9_, FALSE);
			_g_object_unref0 (_tmp9_);
			return;
		} else {
			folder_list_tree_remove_search (self);
		}
	}
	_tmp10_ = folder_list_search_branch_new (search_folder, engine);
	_g_object_unref0 (self->priv->search_branch);
	self->priv->search_branch = _tmp10_;
	_tmp11_ = self->priv->search_branch;
	sidebar_tree_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SIDEBAR_TYPE_BRANCH, SidebarBranch), FOLDER_LIST_TREE_SEARCH_ORDINAL);
	_tmp12_ = self->priv->search_branch;
	_tmp13_ = sidebar_branch_get_root (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
	_tmp14_ = _tmp13_;
	sidebar_tree_place_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), _tmp14_, FALSE);
	_g_object_unref0 (_tmp14_);
}

void
folder_list_tree_remove_search (FolderListTree* self)
{
	FolderListSearchBranch* _tmp0_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	_tmp0_ = self->priv->search_branch;
	if (_tmp0_ != NULL) {
		FolderListSearchBranch* _tmp1_;
		_tmp1_ = self->priv->search_branch;
		sidebar_tree_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
		_g_object_unref0 (self->priv->search_branch);
		self->priv->search_branch = NULL;
	}
}

static void
folder_list_tree_on_ordinal_changed (FolderListTree* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* branches_to_reorder = NULL;
	GeeArrayList* _tmp3_;
	g_return_if_fail (FOLDER_LIST_IS_TREE (self));
	_tmp0_ = self->priv->account_branches;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 1) {
		return;
	}
	_tmp3_ = gee_array_list_new (FOLDER_LIST_TYPE_ACCOUNT_BRANCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	branches_to_reorder = _tmp3_;
	{
		GeeIterator* _branch_it = NULL;
		GeeHashMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp4_ = self->priv->account_branches;
		_tmp5_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_branch_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			FolderListAccountBranch* branch = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			FolderListAccountBranch* _tmp13_;
			FolderListAccountBranch* _tmp14_;
			GearyAccount* _tmp15_;
			GearyAccount* _tmp16_;
			GearyAccountInformation* _tmp17_;
			GearyAccountInformation* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp10_ = _branch_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _branch_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			branch = (FolderListAccountBranch*) _tmp12_;
			_tmp13_ = branch;
			_tmp14_ = branch;
			_tmp15_ = folder_list_account_branch_get_account (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = geary_account_get_information (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = geary_account_information_get_ordinal (_tmp18_);
			_tmp20_ = _tmp19_;
			if (sidebar_tree_get_position_for_branch (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SIDEBAR_TYPE_BRANCH, SidebarBranch)) != _tmp20_) {
				FolderListAccountBranch* _tmp21_;
				GeeArrayList* _tmp22_;
				FolderListAccountBranch* _tmp23_;
				_tmp21_ = branch;
				sidebar_tree_prune (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SIDEBAR_TYPE_BRANCH, SidebarBranch));
				_tmp22_ = branches_to_reorder;
				_tmp23_ = branch;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_);
			}
			_g_object_unref0 (branch);
		}
		_g_object_unref0 (_branch_it);
	}
	{
		GeeArrayList* _branch_list = NULL;
		GeeArrayList* _tmp24_;
		gint _branch_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _branch_index = 0;
		_tmp24_ = branches_to_reorder;
		_branch_list = _tmp24_;
		_tmp25_ = _branch_list;
		_tmp26_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp27_ = _tmp26_;
		_branch_size = _tmp27_;
		_branch_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			FolderListAccountBranch* branch = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			FolderListAccountBranch* _tmp32_;
			FolderListAccountBranch* _tmp33_;
			GearyAccount* _tmp34_;
			GearyAccount* _tmp35_;
			GearyAccountInformation* _tmp36_;
			GearyAccountInformation* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_branch_index = _branch_index + 1;
			_tmp28_ = _branch_index;
			_tmp29_ = _branch_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _branch_list;
			_tmp31_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _branch_index);
			branch = (FolderListAccountBranch*) _tmp31_;
			_tmp32_ = branch;
			_tmp33_ = branch;
			_tmp34_ = folder_list_account_branch_get_account (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = geary_account_get_information (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = geary_account_information_get_ordinal (_tmp37_);
			_tmp39_ = _tmp38_;
			sidebar_tree_graft (G_TYPE_CHECK_INSTANCE_CAST (self, SIDEBAR_TYPE_TREE, SidebarTree), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, SIDEBAR_TYPE_BRANCH, SidebarBranch), _tmp39_);
			_g_object_unref0 (branch);
		}
	}
	_g_object_unref0 (branches_to_reorder);
}

static void
folder_list_tree_class_init (FolderListTreeClass * klass,
                             gpointer klass_data)
{
	folder_list_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolderListTree_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) folder_list_tree_real_get_preferred_width;
	((SidebarTreeClass *) klass)->accept_cursor_changed = (gboolean (*) (SidebarTree*)) folder_list_tree_real_accept_cursor_changed;
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) folder_list_tree_real_drag_motion;
	G_OBJECT_CLASS (klass)->get_property = _vala_folder_list_tree_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folder_list_tree_set_property;
	G_OBJECT_CLASS (klass)->finalize = folder_list_tree_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLDER_LIST_TREE_SELECTED_PROPERTY, folder_list_tree_properties[FOLDER_LIST_TREE_SELECTED_PROPERTY] = g_param_spec_object ("selected", "selected", "selected", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	folder_list_tree_signals[FOLDER_LIST_TREE_FOLDER_SELECTED_SIGNAL] = g_signal_new ("folder-selected", FOLDER_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_FOLDER);
	folder_list_tree_signals[FOLDER_LIST_TREE_FOLDER_ACTIVATED_SIGNAL] = g_signal_new ("folder-activated", FOLDER_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_FOLDER);
	folder_list_tree_signals[FOLDER_LIST_TREE_COPY_CONVERSATION_SIGNAL] = g_signal_new ("copy-conversation", FOLDER_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_FOLDER);
	folder_list_tree_signals[FOLDER_LIST_TREE_MOVE_CONVERSATION_SIGNAL] = g_signal_new ("move-conversation", FOLDER_LIST_TYPE_TREE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_FOLDER);
}

static void
folder_list_tree_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                      gpointer iface_data)
{
	folder_list_tree_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
folder_list_tree_instance_init (FolderListTree * self,
                                gpointer klass)
{
	GeeHashMap* _tmp0_;
	FolderListInboxesBranch* _tmp1_;
	self->priv = folder_list_tree_get_instance_private (self);
	self->priv->_selected = NULL;
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, FOLDER_LIST_TYPE_ACCOUNT_BRANCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->account_branches = _tmp0_;
	_tmp1_ = folder_list_inboxes_branch_new ();
	self->priv->inboxes_branch = _tmp1_;
	self->priv->search_branch = NULL;
}

static void
folder_list_tree_finalize (GObject * obj)
{
	FolderListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLDER_LIST_TYPE_TREE, FolderListTree);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->_selected);
	_g_object_unref0 (self->priv->account_branches);
	_g_object_unref0 (self->priv->inboxes_branch);
	_g_object_unref0 (self->priv->search_branch);
	G_OBJECT_CLASS (folder_list_tree_parent_class)->finalize (obj);
}

static GType
folder_list_tree_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolderListTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folder_list_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolderListTree), 0, (GInstanceInitFunc) folder_list_tree_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) folder_list_tree_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType folder_list_tree_type_id;
	folder_list_tree_type_id = g_type_register_static (SIDEBAR_TYPE_TREE, "FolderListTree", &g_define_type_info, 0);
	g_type_add_interface_static (folder_list_tree_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	FolderListTree_private_offset = g_type_add_instance_private (folder_list_tree_type_id, sizeof (FolderListTreePrivate));
	return folder_list_tree_type_id;
}

GType
folder_list_tree_get_type (void)
{
	static volatile gsize folder_list_tree_type_id__once = 0;
	if (g_once_init_enter (&folder_list_tree_type_id__once)) {
		GType folder_list_tree_type_id;
		folder_list_tree_type_id = folder_list_tree_get_type_once ();
		g_once_init_leave (&folder_list_tree_type_id__once, folder_list_tree_type_id);
	}
	return folder_list_tree_type_id__once;
}

static void
_vala_folder_list_tree_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	FolderListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_TREE, FolderListTree);
	switch (property_id) {
		case FOLDER_LIST_TREE_SELECTED_PROPERTY:
		g_value_set_object (value, folder_list_tree_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folder_list_tree_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	FolderListTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLDER_LIST_TYPE_TREE, FolderListTree);
	switch (property_id) {
		case FOLDER_LIST_TREE_SELECTED_PROPERTY:
		folder_list_tree_set_selected (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

