/* plugin-info-bar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-info-bar.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLUGIN_INFO_BAR_0_PROPERTY,
	PLUGIN_INFO_BAR_STATUS_PROPERTY,
	PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY,
	PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY,
	PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY,
	PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY,
	PLUGIN_INFO_BAR_NUM_PROPERTIES
};
static GParamSpec* plugin_info_bar_properties[PLUGIN_INFO_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLUGIN_INFO_BAR_CLOSE_ACTIVATED_SIGNAL,
	PLUGIN_INFO_BAR_NUM_SIGNALS
};
static guint plugin_info_bar_signals[PLUGIN_INFO_BAR_NUM_SIGNALS] = {0};

struct _PluginInfoBarPrivate {
	gchar* _status;
	gchar* _description;
	gboolean _show_close_button;
	PluginActionable* _primary_button;
	GeeBidirList* _secondary_buttons;
};

static gint PluginInfoBar_private_offset;
static gpointer plugin_info_bar_parent_class = NULL;

static void plugin_info_bar_set_secondary_buttons (PluginInfoBar* self,
                                            GeeBidirList* value);
static void plugin_info_bar_finalize (GObject * obj);
static GType plugin_info_bar_get_type_once (void);
static void _vala_plugin_info_bar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_plugin_info_bar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
plugin_info_bar_get_instance_private (PluginInfoBar* self)
{
	return G_STRUCT_MEMBER_P (self, PluginInfoBar_private_offset);
}

const gchar*
plugin_info_bar_get_status (PluginInfoBar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}

void
plugin_info_bar_set_status (PluginInfoBar* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_IS_INFO_BAR (self));
	old_value = plugin_info_bar_get_status (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_status);
		self->priv->_status = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_info_bar_properties[PLUGIN_INFO_BAR_STATUS_PROPERTY]);
	}
}

const gchar*
plugin_info_bar_get_description (PluginInfoBar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
plugin_info_bar_set_description (PluginInfoBar* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (PLUGIN_IS_INFO_BAR (self));
	old_value = plugin_info_bar_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_info_bar_properties[PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY]);
	}
}

gboolean
plugin_info_bar_get_show_close_button (PluginInfoBar* self)
{
	gboolean result;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (self), FALSE);
	result = self->priv->_show_close_button;
	return result;
}

void
plugin_info_bar_set_show_close_button (PluginInfoBar* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (PLUGIN_IS_INFO_BAR (self));
	old_value = plugin_info_bar_get_show_close_button (self);
	if (old_value != value) {
		self->priv->_show_close_button = value;
		g_object_notify_by_pspec ((GObject *) self, plugin_info_bar_properties[PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY]);
	}
}

PluginActionable*
plugin_info_bar_get_primary_button (PluginInfoBar* self)
{
	PluginActionable* result;
	PluginActionable* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_primary_button;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plugin_info_bar_set_primary_button (PluginInfoBar* self,
                                    PluginActionable* value)
{
	PluginActionable* old_value;
	g_return_if_fail (PLUGIN_IS_INFO_BAR (self));
	old_value = plugin_info_bar_get_primary_button (self);
	if (old_value != value) {
		PluginActionable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_button);
		self->priv->_primary_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_info_bar_properties[PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY]);
	}
}

GeeBidirList*
plugin_info_bar_get_secondary_buttons (PluginInfoBar* self)
{
	GeeBidirList* result;
	GeeBidirList* _tmp0_;
	g_return_val_if_fail (PLUGIN_IS_INFO_BAR (self), NULL);
	_tmp0_ = self->priv->_secondary_buttons;
	result = _tmp0_;
	return result;
}

static void
plugin_info_bar_set_secondary_buttons (PluginInfoBar* self,
                                       GeeBidirList* value)
{
	GeeBidirList* old_value;
	g_return_if_fail (PLUGIN_IS_INFO_BAR (self));
	old_value = plugin_info_bar_get_secondary_buttons (self);
	if (old_value != value) {
		GeeBidirList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_secondary_buttons);
		self->priv->_secondary_buttons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_info_bar_properties[PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY]);
	}
}

/** Constructs a new info bar with the given status. */
PluginInfoBar*
plugin_info_bar_construct (GType object_type,
                           const gchar* status,
                           const gchar* description)
{
	PluginInfoBar * self = NULL;
	g_return_val_if_fail (status != NULL, NULL);
	self = (PluginInfoBar*) geary_base_object_construct (object_type);
	plugin_info_bar_set_status (self, status);
	plugin_info_bar_set_description (self, description);
	return self;
}

PluginInfoBar*
plugin_info_bar_new (const gchar* status,
                     const gchar* description)
{
	return plugin_info_bar_construct (PLUGIN_TYPE_INFO_BAR, status, description);
}

static void
plugin_info_bar_class_init (PluginInfoBarClass * klass,
                            gpointer klass_data)
{
	plugin_info_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginInfoBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_info_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_info_bar_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_info_bar_finalize;
	/**
	     * A short, human-readable status message.
	     *
	     * This should ideally be less than 20 characters long.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_INFO_BAR_STATUS_PROPERTY, plugin_info_bar_properties[PLUGIN_INFO_BAR_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * An optional, longer human-readable explanation of the status.
	     *
	     * This provides additional information and context for {@link
	     * status}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY, plugin_info_bar_properties[PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if a close button is displayed by the info bar. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY, plugin_info_bar_properties[PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY] = g_param_spec_boolean ("show-close-button", "show-close-button", "show-close-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * An optional primary button for the info bar.
	     *
	     * The info bar is not automatically dismissed when the button is
	     * clicked. If it should be hidden then the action's handler
	     * should explicitly do so by calling the appropriate context
	     * object's method, such as {@link
	     * FolderContext.remove_folder_info_bar}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY, plugin_info_bar_properties[PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY] = g_param_spec_object ("primary-button", "primary-button", "primary-button", PLUGIN_TYPE_ACTIONABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Optional secondary buttons for the info bar.
	     *
	     * Secondary buttons are either placed before the primary button,
	     * or on a drop-down menu under it, depending on available space.
	     *
	     * The info bar is not automatically dismissed when a button is
	     * clicked. If it should be hidden then the action's handler
	     * should explicitly do so by calling the appropriate context
	     * object's method, such as {@link
	     * FolderContext.remove_folder_info_bar}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY, plugin_info_bar_properties[PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY] = g_param_spec_object ("secondary-buttons", "secondary-buttons", "secondary-buttons", GEE_TYPE_BIDIR_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when the close button is activated. */
	plugin_info_bar_signals[PLUGIN_INFO_BAR_CLOSE_ACTIVATED_SIGNAL] = g_signal_new ("close-activated", PLUGIN_TYPE_INFO_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
plugin_info_bar_instance_init (PluginInfoBar * self,
                               gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = plugin_info_bar_get_instance_private (self);
	self->priv->_show_close_button = FALSE;
	self->priv->_primary_button = NULL;
	_tmp0_ = gee_linked_list_new (PLUGIN_TYPE_ACTIONABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_secondary_buttons = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_BIDIR_LIST, GeeBidirList);
}

static void
plugin_info_bar_finalize (GObject * obj)
{
	PluginInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_TYPE_INFO_BAR, PluginInfoBar);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_primary_button);
	_g_object_unref0 (self->priv->_secondary_buttons);
	G_OBJECT_CLASS (plugin_info_bar_parent_class)->finalize (obj);
}

/**
 * Enables plugins to report ongoing status messages.
 *
 * The info bar supports two text descriptions, a short (approximately
 * 20 charters at most) status message, and a possibly longer
 * explanation of what is happening.
 */
static GType
plugin_info_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginInfoBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_info_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginInfoBar), 0, (GInstanceInitFunc) plugin_info_bar_instance_init, NULL };
	GType plugin_info_bar_type_id;
	plugin_info_bar_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "PluginInfoBar", &g_define_type_info, 0);
	PluginInfoBar_private_offset = g_type_add_instance_private (plugin_info_bar_type_id, sizeof (PluginInfoBarPrivate));
	return plugin_info_bar_type_id;
}

GType
plugin_info_bar_get_type (void)
{
	static volatile gsize plugin_info_bar_type_id__once = 0;
	if (g_once_init_enter (&plugin_info_bar_type_id__once)) {
		GType plugin_info_bar_type_id;
		plugin_info_bar_type_id = plugin_info_bar_get_type_once ();
		g_once_init_leave (&plugin_info_bar_type_id__once, plugin_info_bar_type_id);
	}
	return plugin_info_bar_type_id__once;
}

static void
_vala_plugin_info_bar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PluginInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_INFO_BAR, PluginInfoBar);
	switch (property_id) {
		case PLUGIN_INFO_BAR_STATUS_PROPERTY:
		g_value_set_string (value, plugin_info_bar_get_status (self));
		break;
		case PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY:
		g_value_set_string (value, plugin_info_bar_get_description (self));
		break;
		case PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY:
		g_value_set_boolean (value, plugin_info_bar_get_show_close_button (self));
		break;
		case PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY:
		g_value_set_object (value, plugin_info_bar_get_primary_button (self));
		break;
		case PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY:
		g_value_set_object (value, plugin_info_bar_get_secondary_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_info_bar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PluginInfoBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_INFO_BAR, PluginInfoBar);
	switch (property_id) {
		case PLUGIN_INFO_BAR_STATUS_PROPERTY:
		plugin_info_bar_set_status (self, g_value_get_string (value));
		break;
		case PLUGIN_INFO_BAR_DESCRIPTION_PROPERTY:
		plugin_info_bar_set_description (self, g_value_get_string (value));
		break;
		case PLUGIN_INFO_BAR_SHOW_CLOSE_BUTTON_PROPERTY:
		plugin_info_bar_set_show_close_button (self, g_value_get_boolean (value));
		break;
		case PLUGIN_INFO_BAR_PRIMARY_BUTTON_PROPERTY:
		plugin_info_bar_set_primary_button (self, g_value_get_object (value));
		break;
		case PLUGIN_INFO_BAR_SECONDARY_BUTTONS_PROPERTY:
		plugin_info_bar_set_secondary_buttons (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

