/* app-conversation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from app-conversation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_APP_CONVERSATION_0_PROPERTY,
	GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY,
	GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY,
	GEARY_APP_CONVERSATION_NUM_PROPERTIES
};
static GParamSpec* geary_app_conversation_properties[GEARY_APP_CONVERSATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
enum  {
	GEARY_APP_CONVERSATION_APPENDED_SIGNAL,
	GEARY_APP_CONVERSATION_TRIMMED_SIGNAL,
	GEARY_APP_CONVERSATION_EMAIL_FLAGS_CHANGED_SIGNAL,
	GEARY_APP_CONVERSATION_NUM_SIGNALS
};
static guint geary_app_conversation_signals[GEARY_APP_CONVERSATION_NUM_SIGNALS] = {0};

struct _GearyAppConversationPrivate {
	GearyFolder* _base_folder;
	GeeHashMultiMap* _path_map;
	GeeHashMultiSet* message_ids;
	gint convnum;
	GeeHashMap* emails;
	GeeSortedSet* sent_date_ascending;
	GeeSortedSet* sent_date_descending;
	GeeSortedSet* recv_date_ascending;
	GeeSortedSet* recv_date_descending;
};

struct _Block12Data {
	int _ref_count_;
	GearyAppConversation* self;
	GeeCollection* blacklist;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	GearyFolderPath* blacklist_path;
};

static gint GearyAppConversation_private_offset;
static gpointer geary_app_conversation_parent_class = NULL;
static gint geary_app_conversation_next_convnum;
static gint geary_app_conversation_next_convnum = 0;

static void geary_app_conversation_set_base_folder (GearyAppConversation* self,
                                             GearyFolder* value);
VALA_EXTERN GeeHashMultiMap* geary_app_conversation_get_path_map (GearyAppConversation* self);
static void geary_app_conversation_set_path_map (GearyAppConversation* self,
                                          GeeHashMultiMap* value);
static gint _geary_email_compare_sent_date_ascending_gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self);
static gint _geary_email_compare_sent_date_descending_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
static gint _geary_email_compare_recv_date_ascending_gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self);
static gint _geary_email_compare_recv_date_descending_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
VALA_EXTERN GearyAppConversation* geary_app_conversation_new (GearyFolder* base_folder);
VALA_EXTERN GearyAppConversation* geary_app_conversation_construct (GType object_type,
                                                        GearyFolder* base_folder);
static gboolean geary_app_conversation_has_flag (GearyAppConversation* self,
                                          GearyNamedFlag* flag);
static gboolean geary_app_conversation_is_missing_flag (GearyAppConversation* self,
                                                 GearyNamedFlag* flag);
static gboolean __lambda160_ (GearyAppConversation* self,
                       GearyEmail* e);
static gboolean ___lambda160__gee_predicate (gconstpointer g,
                                      gpointer self);
static GearyEmail* geary_app_conversation_get_single_email (GearyAppConversation* self,
                                                     GearyAppConversationOrdering ordering,
                                                     GearyAppConversationLocation location,
                                                     GeeCollection* blacklist);
static gboolean __lambda163_ (GearyAppConversation* self,
                       GearyEmail* e);
static gboolean ___lambda163__gee_predicate (gconstpointer g,
                                      gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean ___lambda154_ (GearyAppConversation* self,
                        GearyEmail* e);
static gboolean ____lambda154__gee_predicate (gconstpointer g,
                                       gpointer self);
static gboolean ___lambda155_ (GearyAppConversation* self,
                        GearyEmail* e);
static gboolean ____lambda155__gee_predicate (gconstpointer g,
                                       gpointer self);
static gboolean ___lambda156_ (GearyAppConversation* self,
                        GearyEmail* e);
static gboolean ____lambda156__gee_predicate (gconstpointer g,
                                       gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean ____lambda157_ (Block13Data* _data13_,
                         GearyEmail* e);
static gboolean _____lambda157__gee_predicate (gconstpointer g,
                                        gpointer self);
static gboolean ____lambda158_ (Block12Data* _data12_,
                         GearyEmail* e);
static gboolean __lambda159_ (Block12Data* _data12_,
                       GearyFolderPath* p);
static gboolean ___lambda159__gee_predicate (gconstpointer g,
                                      gpointer self);
static gboolean _____lambda158__gee_predicate (gconstpointer g,
                                        gpointer self);
VALA_EXTERN gboolean geary_app_conversation_add (GearyAppConversation* self,
                                     GearyEmail* email,
                                     GeeCollection* known_paths);
VALA_EXTERN GeeSet* geary_app_conversation_remove (GearyAppConversation* self,
                                       GearyEmail* email);
VALA_EXTERN void geary_app_conversation_remove_path (GearyAppConversation* self,
                                         GearyEmailIdentifier* id,
                                         GearyFolderPath* path);
static gboolean ___lambda161_ (GearyAppConversation* self,
                        GearyEmail* email);
static gboolean ____lambda161__gee_predicate (gconstpointer g,
                                       gpointer self);
static gboolean ___lambda162_ (GearyAppConversation* self,
                        GearyEmail* email);
static gboolean ____lambda162__gee_predicate (gconstpointer g,
                                       gpointer self);
static gboolean geary_app_conversation_check_flag (GearyAppConversation* self,
                                            GearyNamedFlag* flag,
                                            gboolean contains);
static void geary_app_conversation_finalize (GObject * obj);
static GType geary_app_conversation_get_type_once (void);
static void _vala_geary_app_conversation_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_app_conversation_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
geary_app_conversation_get_instance_private (GearyAppConversation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppConversation_private_offset);
}

/**
     * Specify the ordering of {@link Email} returned by various accessors.
     *
     * Note that sorting in {@link Conversation} is done by the RFC822 Date: header (i.e.
     * {@link Email.date}) and not the date received (i.e. {@link EmailProperties.date_received}).
     */
 G_GNUC_NO_INLINE static GType
geary_app_conversation_ordering_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_APP_CONVERSATION_ORDERING_NONE, "GEARY_APP_CONVERSATION_ORDERING_NONE", "none"}, {GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_ASCENDING, "GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_ASCENDING", "sent-date-ascending"}, {GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_DESCENDING, "GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_DESCENDING", "sent-date-descending"}, {GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING, "GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING", "recv-date-ascending"}, {GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_DESCENDING, "GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_DESCENDING", "recv-date-descending"}, {0, NULL, NULL}};
	GType geary_app_conversation_ordering_type_id;
	geary_app_conversation_ordering_type_id = g_enum_register_static ("GearyAppConversationOrdering", values);
	return geary_app_conversation_ordering_type_id;
}

GType
geary_app_conversation_ordering_get_type (void)
{
	static gsize geary_app_conversation_ordering_type_id__once = 0;
	if (g_once_init_enter (&geary_app_conversation_ordering_type_id__once)) {
		GType geary_app_conversation_ordering_type_id;
		geary_app_conversation_ordering_type_id = geary_app_conversation_ordering_get_type_once ();
		g_once_init_leave (&geary_app_conversation_ordering_type_id__once, geary_app_conversation_ordering_type_id);
	}
	return geary_app_conversation_ordering_type_id__once;
}

/**
     * Specify the location of the {@link Email} in relation to the base folder being monitored
     * by the {@link Conversation}'s {@link ConversationMonitor}.
     *
     * IN_FOLDER represents Email that is found in the Folder the ConversationMonitor is
     * monitoring.  OUT_OF_FOLDER means the Email is located elsewhere in the {@link Account}.
     *
     * Some methods honor IN_FOLDER_OUT_OF_FOLDER and OUT_OF_FOLDER_IN_FOLDER.  These represent
     * preferences for finding an Email.  The first (IN_FOLDER / OUT_OF_FOLDER) is searched.  If
     * an Email is not found in that location, the other criteria is used.
     */
 G_GNUC_NO_INLINE static GType
geary_app_conversation_location_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER, "GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER", "in-folder"}, {GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER, "GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER", "out-of-folder"}, {GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER, "GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER", "in-folder-out-of-folder"}, {GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER_IN_FOLDER, "GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER_IN_FOLDER", "out-of-folder-in-folder"}, {GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, "GEARY_APP_CONVERSATION_LOCATION_ANYWHERE", "anywhere"}, {0, NULL, NULL}};
	GType geary_app_conversation_location_type_id;
	geary_app_conversation_location_type_id = g_enum_register_static ("GearyAppConversationLocation", values);
	return geary_app_conversation_location_type_id;
}

GType
geary_app_conversation_location_get_type (void)
{
	static gsize geary_app_conversation_location_type_id__once = 0;
	if (g_once_init_enter (&geary_app_conversation_location_type_id__once)) {
		GType geary_app_conversation_location_type_id;
		geary_app_conversation_location_type_id = geary_app_conversation_location_get_type_once ();
		g_once_init_leave (&geary_app_conversation_location_type_id__once, geary_app_conversation_location_type_id);
	}
	return geary_app_conversation_location_type_id__once;
}

GearyFolder*
geary_app_conversation_get_base_folder (GearyAppConversation* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	_tmp0_ = self->priv->_base_folder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_app_conversation_set_base_folder (GearyAppConversation* self,
                                        GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (self));
	old_value = geary_app_conversation_get_base_folder (self);
	if (old_value != value) {
		GearyFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_folder);
		self->priv->_base_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_app_conversation_properties[GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY]);
	}
}

GeeHashMultiMap*
geary_app_conversation_get_path_map (GearyAppConversation* self)
{
	GeeHashMultiMap* result;
	GeeHashMultiMap* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	_tmp0_ = self->priv->_path_map;
	result = _tmp0_;
	return result;
}

static void
geary_app_conversation_set_path_map (GearyAppConversation* self,
                                     GeeHashMultiMap* value)
{
	GeeHashMultiMap* old_value;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (self));
	old_value = geary_app_conversation_get_path_map (self);
	if (old_value != value) {
		GeeHashMultiMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_path_map);
		self->priv->_path_map = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_app_conversation_properties[GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY]);
	}
}

static gint
_geary_email_compare_sent_date_ascending_gcompare_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gint result;
	result = geary_email_compare_sent_date_ascending ((GearyEmail*) a, (GearyEmail*) b);
	return result;
}

static gint
_geary_email_compare_sent_date_descending_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = geary_email_compare_sent_date_descending ((GearyEmail*) a, (GearyEmail*) b);
	return result;
}

static gint
_geary_email_compare_recv_date_ascending_gcompare_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gint result;
	result = geary_email_compare_recv_date_ascending ((GearyEmail*) a, (GearyEmail*) b);
	return result;
}

static gint
_geary_email_compare_recv_date_descending_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = geary_email_compare_recv_date_descending ((GearyEmail*) a, (GearyEmail*) b);
	return result;
}

/**
     * Constructs a conversation relative to the given base folder.
     */
GearyAppConversation*
geary_app_conversation_construct (GType object_type,
                                  GearyFolder* base_folder)
{
	GearyAppConversation * self = NULL;
	gint _tmp0_;
	g_return_val_if_fail (GEARY_IS_FOLDER (base_folder), NULL);
	self = (GearyAppConversation*) geary_base_object_construct (object_type);
	_tmp0_ = geary_app_conversation_next_convnum;
	geary_app_conversation_next_convnum = _tmp0_ + 1;
	self->priv->convnum = _tmp0_;
	geary_app_conversation_set_base_folder (self, base_folder);
	return self;
}

GearyAppConversation*
geary_app_conversation_new (GearyFolder* base_folder)
{
	return geary_app_conversation_construct (GEARY_APP_TYPE_CONVERSATION, base_folder);
}

/**
     * Returns the number of emails in the conversation.
     */
gint
geary_app_conversation_get_count (GearyAppConversation* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), 0);
	_tmp0_ = self->priv->emails;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Returns the number of emails in the conversation in a particular folder.
     */
guint
geary_app_conversation_get_count_in_folder (GearyAppConversation* self,
                                            GearyFolderPath* path)
{
	guint count = 0U;
	guint result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), 0U);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), 0U);
	count = (guint) 0;
	{
		GeeIterator* _id_it = NULL;
		GeeHashMultiMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->_path_map;
		_tmp1_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_id_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GearyEmailIdentifier* id = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeHashMultiMap* _tmp8_;
			GearyEmailIdentifier* _tmp9_;
			GeeCollection* _tmp10_;
			GeeCollection* _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _id_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _id_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			id = (GearyEmailIdentifier*) _tmp7_;
			_tmp8_ = self->priv->_path_map;
			_tmp9_ = id;
			_tmp10_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_collection_contains (_tmp11_, path);
			_g_object_unref0 (_tmp11_);
			if (_tmp12_) {
				guint _tmp13_;
				_tmp13_ = count;
				count = _tmp13_ + 1;
			}
			_g_object_unref0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	result = count;
	return result;
}

/**
     * Returns true if *any* message in the conversation is unread.
     */
gboolean
geary_app_conversation_is_unread (GearyAppConversation* self)
{
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp1_;
	GearyNamedFlag* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	_tmp0_ = geary_email_flags_get_UNREAD ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_app_conversation_has_flag (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Returns true if any message in the conversation is not unread.
     */
gboolean
geary_app_conversation_has_any_read_message (GearyAppConversation* self)
{
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp1_;
	GearyNamedFlag* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	_tmp0_ = geary_email_flags_get_UNREAD ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_app_conversation_is_missing_flag (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Returns true if *any* message in the conversation is flagged.
     */
gboolean
geary_app_conversation_is_flagged (GearyAppConversation* self)
{
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp1_;
	GearyNamedFlag* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	_tmp0_ = geary_email_flags_get_FLAGGED ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_app_conversation_has_flag (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Determines if the conversation contains un-deleted email messages.
     */
static gboolean
__lambda160_ (GearyAppConversation* self,
              GearyEmail* e)
{
	GearyEmailFlags* _tmp0_;
	GearyEmailFlags* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = geary_email_get_email_flags (e);
	_tmp1_ = _tmp0_;
	result = !geary_email_flags_is_deleted (_tmp1_);
	return result;
}

static gboolean
___lambda160__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda160_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

gboolean
geary_app_conversation_has_any_non_deleted_email (GearyAppConversation* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GearyIterable* _tmp4_;
	GearyIterable* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	_tmp0_ = self->priv->emails;
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_iterable_any (_tmp5_, ___lambda160__gee_predicate, g_object_ref (self), g_object_unref);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

/**
     * Returns the earliest (first sent) email in the Conversation.
     *
     * Note that here, sent denotes the value of the Date header, not
     * being contained in the Sent folder.
     */
GearyEmail*
geary_app_conversation_get_earliest_sent_email (GearyAppConversation* self,
                                                GearyAppConversationLocation location,
                                                GeeCollection* blacklist)
{
	GearyEmail* _tmp0_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_single_email (self, GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_ASCENDING, location, blacklist);
	result = _tmp0_;
	return result;
}

/**
     * Returns the latest (most recently sent) email in the Conversation.
     *
     * Note that here, sent denotes the value of the Date header, not
     * being contained in the Sent folder.
     */
GearyEmail*
geary_app_conversation_get_latest_sent_email (GearyAppConversation* self,
                                              GearyAppConversationLocation location,
                                              GeeCollection* blacklist)
{
	GearyEmail* _tmp0_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_single_email (self, GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_DESCENDING, location, NULL);
	result = _tmp0_;
	return result;
}

/**
     * Returns the earliest (first received) email in the Conversation.
     */
GearyEmail*
geary_app_conversation_get_earliest_recv_email (GearyAppConversation* self,
                                                GearyAppConversationLocation location,
                                                GeeCollection* blacklist)
{
	GearyEmail* _tmp0_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_single_email (self, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING, location, NULL);
	result = _tmp0_;
	return result;
}

/**
     * Returns the latest (most recently received) email in the Conversation.
     */
GearyEmail*
geary_app_conversation_get_latest_recv_email (GearyAppConversation* self,
                                              GearyAppConversationLocation location,
                                              GeeCollection* blacklist)
{
	GearyEmail* _tmp0_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_single_email (self, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_DESCENDING, location, NULL);
	result = _tmp0_;
	return result;
}

static gboolean
__lambda163_ (GearyAppConversation* self,
              GearyEmail* e)
{
	GearyEmailFlags* _tmp0_;
	GearyEmailFlags* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = geary_email_get_email_flags (e);
	_tmp1_ = _tmp0_;
	result = geary_email_flags_is_deleted (_tmp1_);
	return result;
}

static gboolean
___lambda163__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda163_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

GeeCollection*
geary_app_conversation_get_emails_flagged_for_deletion (GearyAppConversation* self,
                                                        GearyAppConversationLocation location,
                                                        GeeCollection* blacklist)
{
	GeeCollection* emails = NULL;
	GeeList* _tmp0_;
	GearyIterable* filtered = NULL;
	GearyIterable* _tmp1_;
	GearyIterable* _tmp2_;
	GearyIterable* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_emails (self, GEARY_APP_CONVERSATION_ORDERING_NONE, location, blacklist, FALSE);
	emails = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp1_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (emails, GEE_TYPE_ITERABLE, GeeIterable));
	filtered = _tmp1_;
	_tmp2_ = geary_iterable_filter (filtered, ___lambda163__gee_predicate, g_object_ref (self), g_object_unref);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_iterable_to_array_list (_tmp3_, NULL, NULL, NULL);
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection);
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	_g_object_unref0 (filtered);
	_g_object_unref0 (emails);
	return result;
}

/**
     * Returns the conversation's email, possibly sorted and filtered.
     *
     * {@link Location.IN_FOLDER} and {@link Location.OUT_OF_FOLDER} are the
     * only preferences honored; the others ({@link Location.IN_FOLDER_OUT_OF_FOLDER},
     * {@link Location.IN_FOLDER_OUT_OF_FOLDER}, and {@link Location.ANYWHERE}
     * are all treated as ANYWHERE.
     */
static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GearyAppConversation* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->blacklist);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
___lambda154_ (GearyAppConversation* self,
               GearyEmail* e)
{
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = geary_email_get_id (e);
	_tmp1_ = _tmp0_;
	result = geary_app_conversation_is_in_base_folder (self, _tmp1_);
	return result;
}

static gboolean
____lambda154__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda154_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

static gboolean
___lambda155_ (GearyAppConversation* self,
               GearyEmail* e)
{
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = geary_email_get_id (e);
	_tmp1_ = _tmp0_;
	result = !geary_app_conversation_is_in_base_folder (self, _tmp1_);
	return result;
}

static gboolean
____lambda155__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda155_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

static gboolean
___lambda156_ (GearyAppConversation* self,
               GearyEmail* e)
{
	gboolean _tmp0_ = FALSE;
	GearyEmailFlags* _tmp1_;
	GearyEmailFlags* _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp1_ = geary_email_get_email_flags (e);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GearyEmailFlags* _tmp3_;
		GearyEmailFlags* _tmp4_;
		_tmp3_ = geary_email_get_email_flags (e);
		_tmp4_ = _tmp3_;
		_tmp0_ = !geary_email_flags_is_deleted (_tmp4_);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
____lambda156__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda156_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GearyAppConversation* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->blacklist_path);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
____lambda157_ (Block13Data* _data13_,
                GearyEmail* e)
{
	Block12Data* _data12_;
	GearyAppConversation* self;
	GeeHashMultiMap* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GearyFolderPath* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = self->priv->_path_map;
	_tmp1_ = geary_email_get_id (e);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data13_->blacklist_path;
	_tmp6_ = !gee_collection_contains (_tmp4_, _tmp5_);
	_g_object_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gboolean
_____lambda157__gee_predicate (gconstpointer g,
                               gpointer self)
{
	gboolean result;
	result = ____lambda157_ (self, (GearyEmail*) g);
	return result;
}

static gboolean
__lambda159_ (Block12Data* _data12_,
              GearyFolderPath* p)
{
	GearyAppConversation* self;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (p), FALSE);
	result = !gee_collection_contains (_data12_->blacklist, p);
	return result;
}

static gboolean
___lambda159__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda159_ (self, (GearyFolderPath*) g);
	return result;
}

static gboolean
____lambda158_ (Block12Data* _data12_,
                GearyEmail* e)
{
	GearyAppConversation* self;
	GeeHashMultiMap* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (GEARY_IS_EMAIL (e), FALSE);
	_tmp0_ = self->priv->_path_map;
	_tmp1_ = geary_email_get_id (e);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_traversable_any_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda159__gee_predicate, block12_data_ref (_data12_), block12_data_unref);
	_g_object_unref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static gboolean
_____lambda158__gee_predicate (gconstpointer g,
                               gpointer self)
{
	gboolean result;
	result = ____lambda158_ (self, (GearyEmail*) g);
	return result;
}

GeeList*
geary_app_conversation_get_emails (GearyAppConversation* self,
                                   GearyAppConversationOrdering ordering,
                                   GearyAppConversationLocation location,
                                   GeeCollection* blacklist,
                                   gboolean filter_deleted)
{
	Block12Data* _data12_;
	GeeCollection* _tmp0_;
	GeeCollection* email = NULL;
	GearyIterable* filtered = NULL;
	GeeCollection* _tmp12_;
	GearyIterable* _tmp13_;
	gboolean _tmp20_ = FALSE;
	GearyIterable* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeList* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (blacklist);
	_g_object_unref0 (_data12_->blacklist);
	_data12_->blacklist = _tmp0_;
	switch (ordering) {
		case GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_ASCENDING:
		{
			GeeSortedSet* _tmp1_;
			GeeCollection* _tmp2_;
			_tmp1_ = self->priv->sent_date_ascending;
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (email);
			email = _tmp2_;
			break;
		}
		case GEARY_APP_CONVERSATION_ORDERING_SENT_DATE_DESCENDING:
		{
			GeeSortedSet* _tmp3_;
			GeeCollection* _tmp4_;
			_tmp3_ = self->priv->sent_date_descending;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (email);
			email = _tmp4_;
			break;
		}
		case GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING:
		{
			GeeSortedSet* _tmp5_;
			GeeCollection* _tmp6_;
			_tmp5_ = self->priv->recv_date_ascending;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (email);
			email = _tmp6_;
			break;
		}
		case GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_DESCENDING:
		{
			GeeSortedSet* _tmp7_;
			GeeCollection* _tmp8_;
			_tmp7_ = self->priv->recv_date_descending;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
			_g_object_unref0 (email);
			email = _tmp8_;
			break;
		}
		case GEARY_APP_CONVERSATION_ORDERING_NONE:
		{
			GeeHashMap* _tmp9_;
			GeeCollection* _tmp10_;
			GeeCollection* _tmp11_;
			_tmp9_ = self->priv->emails;
			_tmp10_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
			_tmp11_ = _tmp10_;
			_g_object_unref0 (email);
			email = _tmp11_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp12_ = email;
	_tmp13_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
	filtered = _tmp13_;
	switch (location) {
		case GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER:
		{
			GearyIterable* _tmp14_;
			GearyIterable* _tmp15_;
			_tmp14_ = filtered;
			_tmp15_ = geary_iterable_filter (_tmp14_, ____lambda154__gee_predicate, g_object_ref (self), g_object_unref);
			_g_object_unref0 (filtered);
			filtered = _tmp15_;
			break;
		}
		case GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER:
		{
			GearyIterable* _tmp16_;
			GearyIterable* _tmp17_;
			_tmp16_ = filtered;
			_tmp17_ = geary_iterable_filter (_tmp16_, ____lambda155__gee_predicate, g_object_ref (self), g_object_unref);
			_g_object_unref0 (filtered);
			filtered = _tmp17_;
			break;
		}
		default:
		{
			break;
		}
	}
	if (filter_deleted) {
		GearyIterable* _tmp18_;
		GearyIterable* _tmp19_;
		_tmp18_ = filtered;
		_tmp19_ = geary_iterable_filter (_tmp18_, ____lambda156__gee_predicate, g_object_ref (self), g_object_unref);
		_g_object_unref0 (filtered);
		filtered = _tmp19_;
	}
	if (_data12_->blacklist != NULL) {
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp21_ = gee_collection_get_is_empty (_data12_->blacklist);
		_tmp22_ = _tmp21_;
		_tmp20_ = !_tmp22_;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gint _tmp23_;
		gint _tmp24_;
		_tmp23_ = gee_collection_get_size (_data12_->blacklist);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == 1) {
			Block13Data* _data13_;
			GearyIterable* _tmp25_;
			GearyIterable* _tmp26_;
			gpointer _tmp27_;
			GearyFolderPath* _tmp28_;
			GearyIterable* _tmp29_;
			GearyIterable* _tmp30_;
			_data13_ = g_slice_new0 (Block13Data);
			_data13_->_ref_count_ = 1;
			_data13_->_data12_ = block12_data_ref (_data12_);
			_tmp25_ = geary_traverse (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data12_->blacklist, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp26_ = _tmp25_;
			_tmp27_ = geary_iterable_first (_tmp26_);
			_tmp28_ = (GearyFolderPath*) _tmp27_;
			_g_object_unref0 (_tmp26_);
			_data13_->blacklist_path = _tmp28_;
			_tmp29_ = filtered;
			_tmp30_ = geary_iterable_filter (_tmp29_, _____lambda157__gee_predicate, block13_data_ref (_data13_), block13_data_unref);
			_g_object_unref0 (filtered);
			filtered = _tmp30_;
			block13_data_unref (_data13_);
			_data13_ = NULL;
		} else {
			GearyIterable* _tmp31_;
			GearyIterable* _tmp32_;
			_tmp31_ = filtered;
			_tmp32_ = geary_iterable_filter (_tmp31_, _____lambda158__gee_predicate, block12_data_ref (_data12_), block12_data_unref);
			_g_object_unref0 (filtered);
			filtered = _tmp32_;
		}
	}
	_tmp33_ = filtered;
	_tmp34_ = geary_iterable_to_array_list (_tmp33_, NULL, NULL, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_LIST, GeeList);
	_g_object_unref0 (filtered);
	_g_object_unref0 (email);
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}

/**
     * Determines if the given id is in the conversation's base folder.
     */
gboolean
geary_app_conversation_is_in_base_folder (GearyAppConversation* self,
                                          GearyEmailIdentifier* id)
{
	GeeCollection* paths = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), FALSE);
	_tmp0_ = self->priv->_path_map;
	_tmp1_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), id);
	paths = _tmp1_;
	_tmp3_ = paths;
	if (_tmp3_ != NULL) {
		GeeCollection* _tmp4_;
		GearyFolder* _tmp5_;
		GearyFolderPath* _tmp6_;
		GearyFolderPath* _tmp7_;
		_tmp4_ = paths;
		_tmp5_ = self->priv->_base_folder;
		_tmp6_ = geary_folder_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = gee_collection_contains (_tmp4_, _tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_object_unref0 (paths);
	return result;
}

/**
     * Determines if the given id is in the conversation's base folder.
     */
guint
geary_app_conversation_get_folder_count (GearyAppConversation* self,
                                         GearyEmailIdentifier* id)
{
	GeeCollection* paths = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	guint count = 0U;
	GeeCollection* _tmp2_;
	guint result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), 0U);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), 0U);
	_tmp0_ = self->priv->_path_map;
	_tmp1_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), id);
	paths = _tmp1_;
	count = (guint) 0;
	_tmp2_ = paths;
	if (_tmp2_ != NULL) {
		GeeCollection* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = paths;
		_tmp4_ = gee_collection_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		count = (guint) _tmp5_;
	}
	result = count;
	_g_object_unref0 (paths);
	return result;
}

/**
     * Determines if an email with the give id exists in the conversation.
     */
gboolean
geary_app_conversation_contains_email_by_id (GearyAppConversation* self,
                                             GearyEmailIdentifier* id)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), FALSE);
	_tmp0_ = self->priv->emails;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	return result;
}

/**
     * Returns the email associated with the EmailIdentifier, if it exists.
     */
GearyEmail*
geary_app_conversation_get_email_by_id (GearyAppConversation* self,
                                        GearyEmailIdentifier* id)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), NULL);
	_tmp0_ = self->priv->emails;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	result = (GearyEmail*) _tmp1_;
	return result;
}

/**
     * Returns all EmailIdentifiers in the conversation, unsorted.
     */
GeeCollection*
geary_app_conversation_get_email_ids (GearyAppConversation* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	_tmp0_ = self->priv->emails;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

/**
     * Return all Message IDs associated with the conversation.
     */
GeeCollection*
geary_app_conversation_get_message_ids (GearyAppConversation* self)
{
	GeeHashSet* ids = NULL;
	GeeHashSet* _tmp0_;
	GeeHashMultiSet* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	_tmp0_ = gee_hash_set_new (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	ids = _tmp0_;
	_tmp1_ = self->priv->message_ids;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (ids, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
	result = G_TYPE_CHECK_INSTANCE_CAST (ids, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

/**
     * Returns a string representation for debugging.
     */
gchar*
geary_app_conversation_to_string (GearyAppConversation* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	_tmp0_ = self->priv->emails;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("[#%d] (%d emails)", self->priv->convnum, _tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Add the email to the conversation if not already present.
     *
     * The value of `known_paths` should contain all the known {@link
     * FolderPath} instances this email is contained within.
     *
     * Returns if the email was added, else false if already present
     * and only `known_paths` were merged.
     */
gboolean
geary_app_conversation_add (GearyAppConversation* self,
                            GearyEmail* email,
                            GeeCollection* known_paths)
{
	gboolean added = FALSE;
	GeeHashMap* _tmp8_;
	GearyEmailIdentifier* _tmp9_;
	GearyEmailIdentifier* _tmp10_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_EMAIL (email), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (known_paths, GEE_TYPE_COLLECTION), FALSE);
	{
		GeeIterator* _path_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (known_paths, GEE_TYPE_ITERABLE, GeeIterable));
		_path_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			GearyFolderPath* path = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashMultiMap* _tmp4_;
			GearyEmailIdentifier* _tmp5_;
			GearyEmailIdentifier* _tmp6_;
			GearyFolderPath* _tmp7_;
			_tmp1_ = _path_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _path_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			path = (GearyFolderPath*) _tmp3_;
			_tmp4_ = self->priv->_path_map;
			_tmp5_ = geary_email_get_id (email);
			_tmp6_ = _tmp5_;
			_tmp7_ = path;
			gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp6_, _tmp7_);
			_g_object_unref0 (path);
		}
		_g_object_unref0 (_path_it);
	}
	added = FALSE;
	_tmp8_ = self->priv->emails;
	_tmp9_ = geary_email_get_id (email);
	_tmp10_ = _tmp9_;
	if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_)) {
		GeeHashMap* _tmp11_;
		GearyEmailIdentifier* _tmp12_;
		GearyEmailIdentifier* _tmp13_;
		GeeSortedSet* _tmp14_;
		GeeSortedSet* _tmp15_;
		GeeSortedSet* _tmp16_;
		GeeSortedSet* _tmp17_;
		GeeSet* ancestors = NULL;
		GeeSet* _tmp18_;
		GeeSet* _tmp19_;
		_tmp11_ = self->priv->emails;
		_tmp12_ = geary_email_get_id (email);
		_tmp13_ = _tmp12_;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, email);
		_tmp14_ = self->priv->sent_date_ascending;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp15_ = self->priv->sent_date_descending;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp16_ = self->priv->recv_date_ascending;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp17_ = self->priv->recv_date_descending;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp18_ = geary_email_get_ancestors (email);
		ancestors = _tmp18_;
		_tmp19_ = ancestors;
		if (_tmp19_ != NULL) {
			GeeHashMultiSet* _tmp20_;
			GeeSet* _tmp21_;
			_tmp20_ = self->priv->message_ids;
			_tmp21_ = ancestors;
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
		}
		g_signal_emit (self, geary_app_conversation_signals[GEARY_APP_CONVERSATION_APPENDED_SIGNAL], 0, email);
		added = TRUE;
		_g_object_unref0 (ancestors);
	}
	result = added;
	return result;
}

/**
     * Unconditionally removes an email from the conversation.
     *
     * Returns all Message-IDs that should be removed as result of
     * removing this message, or `null` if none were removed.
     */
GeeSet*
geary_app_conversation_remove (GearyAppConversation* self,
                               GearyEmail* email)
{
	GeeSet* removed_ids = NULL;
	GeeHashMap* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail (GEARY_IS_EMAIL (email), NULL);
	removed_ids = NULL;
	_tmp0_ = self->priv->emails;
	_tmp1_ = geary_email_get_id (email);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL)) {
		GeeSortedSet* _tmp3_;
		GeeSortedSet* _tmp4_;
		GeeSortedSet* _tmp5_;
		GeeSortedSet* _tmp6_;
		GeeHashMultiMap* _tmp7_;
		GearyEmailIdentifier* _tmp8_;
		GearyEmailIdentifier* _tmp9_;
		GeeSet* ancestors = NULL;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		_tmp3_ = self->priv->sent_date_ascending;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp4_ = self->priv->sent_date_descending;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp5_ = self->priv->recv_date_ascending;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp6_ = self->priv->recv_date_descending;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), email);
		_tmp7_ = self->priv->_path_map;
		_tmp8_ = geary_email_get_id (email);
		_tmp9_ = _tmp8_;
		gee_multi_map_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp9_);
		_tmp10_ = geary_email_get_ancestors (email);
		ancestors = _tmp10_;
		_tmp11_ = ancestors;
		if (_tmp11_ != NULL) {
			GeeHashSet* _tmp12_;
			GeeSet* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp12_ = gee_hash_set_new (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (removed_ids);
			removed_ids = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_SET, GeeSet);
			{
				GeeIterator* _ancestor_id_it = NULL;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				_tmp13_ = ancestors;
				_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
				_ancestor_id_it = _tmp14_;
				while (TRUE) {
					GeeIterator* _tmp15_;
					GearyRFC822MessageID* ancestor_id = NULL;
					GeeIterator* _tmp16_;
					gpointer _tmp17_;
					gboolean _tmp18_ = FALSE;
					GeeHashMultiSet* _tmp19_;
					GearyRFC822MessageID* _tmp20_;
					_tmp15_ = _ancestor_id_it;
					if (!gee_iterator_next (_tmp15_)) {
						break;
					}
					_tmp16_ = _ancestor_id_it;
					_tmp17_ = gee_iterator_get (_tmp16_);
					ancestor_id = (GearyRFC822MessageID*) _tmp17_;
					_tmp19_ = self->priv->message_ids;
					_tmp20_ = ancestor_id;
					if (gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_)) {
						GeeHashMultiSet* _tmp21_;
						GearyRFC822MessageID* _tmp22_;
						_tmp21_ = self->priv->message_ids;
						_tmp22_ = ancestor_id;
						_tmp18_ = !gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp22_);
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						GeeSet* _tmp23_;
						GearyRFC822MessageID* _tmp24_;
						_tmp23_ = removed_ids;
						_tmp24_ = ancestor_id;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection), _tmp24_);
					}
					_g_object_unref0 (ancestor_id);
				}
				_g_object_unref0 (_ancestor_id_it);
			}
			_tmp25_ = removed_ids;
			_tmp26_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp27_ = _tmp26_;
			if (_tmp27_ == 0) {
				_g_object_unref0 (removed_ids);
				removed_ids = NULL;
			}
		}
		g_signal_emit (self, geary_app_conversation_signals[GEARY_APP_CONVERSATION_TRIMMED_SIGNAL], 0, email);
		_g_object_unref0 (ancestors);
	}
	result = removed_ids;
	return result;
}

/**
     * Removes the target path from the known set for the given id.
     */
void
geary_app_conversation_remove_path (GearyAppConversation* self,
                                    GearyEmailIdentifier* id,
                                    GearyFolderPath* path)
{
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (self));
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (path));
	_tmp0_ = self->priv->_path_map;
	gee_multi_map_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), id, path);
}

static gboolean
___lambda161_ (GearyAppConversation* self,
               GearyEmail* email)
{
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (email), FALSE);
	_tmp0_ = geary_email_get_id (email);
	_tmp1_ = _tmp0_;
	result = geary_app_conversation_is_in_base_folder (self, _tmp1_);
	return result;
}

static gboolean
____lambda161__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda161_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

static gboolean
___lambda162_ (GearyAppConversation* self,
               GearyEmail* email)
{
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_EMAIL (email), FALSE);
	_tmp0_ = geary_email_get_id (email);
	_tmp1_ = _tmp0_;
	result = !geary_app_conversation_is_in_base_folder (self, _tmp1_);
	return result;
}

static gboolean
____lambda162__gee_predicate (gconstpointer g,
                              gpointer self)
{
	gboolean result;
	result = ___lambda162_ ((GearyAppConversation*) self, (GearyEmail*) g);
	return result;
}

static GearyEmail*
geary_app_conversation_get_single_email (GearyAppConversation* self,
                                         GearyAppConversationOrdering ordering,
                                         GearyAppConversationLocation location,
                                         GeeCollection* blacklist)
{
	GeeCollection* all = NULL;
	GeeList* _tmp0_;
	GeeCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), NULL);
	g_return_val_if_fail ((blacklist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (blacklist, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_app_conversation_get_emails (self, ordering, location, blacklist, TRUE);
	all = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp1_ = all;
	_tmp2_ = gee_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = NULL;
		_g_object_unref0 (all);
		return result;
	}
	switch (location) {
		case GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER:
		case GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER:
		case GEARY_APP_CONVERSATION_LOCATION_ANYWHERE:
		{
			GeeCollection* _tmp4_;
			GearyIterable* _tmp5_;
			GearyIterable* _tmp6_;
			gpointer _tmp7_;
			GearyEmail* _tmp8_;
			_tmp4_ = all;
			_tmp5_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp6_ = _tmp5_;
			_tmp7_ = geary_iterable_first (_tmp6_);
			_tmp8_ = (GearyEmail*) _tmp7_;
			_g_object_unref0 (_tmp6_);
			result = _tmp8_;
			_g_object_unref0 (all);
			return result;
		}
		case GEARY_APP_CONVERSATION_LOCATION_IN_FOLDER_OUT_OF_FOLDER:
		{
			GearyEmail* found = NULL;
			GeeCollection* _tmp9_;
			GearyIterable* _tmp10_;
			GearyIterable* _tmp11_;
			gpointer _tmp12_;
			GearyEmail* _tmp13_;
			GearyEmail* _tmp14_ = NULL;
			GearyEmail* _tmp15_;
			GearyEmail* _tmp16_;
			GearyEmail* _tmp21_;
			_tmp9_ = all;
			_tmp10_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp11_ = _tmp10_;
			_tmp12_ = geary_iterable_first_matching (_tmp11_, ____lambda161__gee_predicate, g_object_ref (self), g_object_unref);
			_tmp13_ = (GearyEmail*) _tmp12_;
			_g_object_unref0 (_tmp11_);
			found = _tmp13_;
			_tmp15_ = found;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_tmp14_ = _tmp16_;
			if (_tmp14_ == NULL) {
				GeeCollection* _tmp17_;
				GearyIterable* _tmp18_;
				GearyIterable* _tmp19_;
				gpointer _tmp20_;
				_tmp17_ = all;
				_tmp18_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp19_ = _tmp18_;
				_tmp20_ = geary_iterable_first (_tmp19_);
				_g_object_unref0 (_tmp14_);
				_tmp14_ = (GearyEmail*) _tmp20_;
				_g_object_unref0 (_tmp19_);
			}
			_tmp21_ = _tmp14_;
			_tmp14_ = NULL;
			result = _tmp21_;
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (found);
			_g_object_unref0 (all);
			return result;
		}
		case GEARY_APP_CONVERSATION_LOCATION_OUT_OF_FOLDER_IN_FOLDER:
		{
			GearyEmail* found = NULL;
			GeeCollection* _tmp22_;
			GearyIterable* _tmp23_;
			GearyIterable* _tmp24_;
			gpointer _tmp25_;
			GearyEmail* _tmp26_;
			GearyEmail* _tmp27_ = NULL;
			GearyEmail* _tmp28_;
			GearyEmail* _tmp29_;
			GearyEmail* _tmp34_;
			_tmp22_ = all;
			_tmp23_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp24_ = _tmp23_;
			_tmp25_ = geary_iterable_first_matching (_tmp24_, ____lambda162__gee_predicate, g_object_ref (self), g_object_unref);
			_tmp26_ = (GearyEmail*) _tmp25_;
			_g_object_unref0 (_tmp24_);
			found = _tmp26_;
			_tmp28_ = found;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			_tmp27_ = _tmp29_;
			if (_tmp27_ == NULL) {
				GeeCollection* _tmp30_;
				GearyIterable* _tmp31_;
				GearyIterable* _tmp32_;
				gpointer _tmp33_;
				_tmp30_ = all;
				_tmp31_ = geary_traverse (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp32_ = _tmp31_;
				_tmp33_ = geary_iterable_first (_tmp32_);
				_g_object_unref0 (_tmp27_);
				_tmp27_ = (GearyEmail*) _tmp33_;
				_g_object_unref0 (_tmp32_);
			}
			_tmp34_ = _tmp27_;
			_tmp27_ = NULL;
			result = _tmp34_;
			_g_object_unref0 (_tmp27_);
			_g_object_unref0 (found);
			_g_object_unref0 (all);
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static gboolean
geary_app_conversation_check_flag (GearyAppConversation* self,
                                   GearyNamedFlag* flag,
                                   gboolean contains)
{
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_NAMED_FLAG (flag), FALSE);
	{
		GeeList* _email_list = NULL;
		GeeList* _tmp0_;
		gint _email_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _email_index = 0;
		_tmp0_ = geary_app_conversation_get_emails (self, GEARY_APP_CONVERSATION_ORDERING_NONE, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, TRUE);
		_email_list = _tmp0_;
		_tmp1_ = _email_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_email_size = _tmp3_;
		_email_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GearyEmail* email = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			GearyEmail* _tmp9_;
			GearyEmailFlags* _tmp10_;
			GearyEmailFlags* _tmp11_;
			_email_index = _email_index + 1;
			_tmp4_ = _email_index;
			_tmp5_ = _email_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _email_list;
			_tmp7_ = gee_list_get (_tmp6_, _email_index);
			email = (GearyEmail*) _tmp7_;
			_tmp9_ = email;
			_tmp10_ = geary_email_get_email_flags (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				GearyEmail* _tmp12_;
				GearyEmailFlags* _tmp13_;
				GearyEmailFlags* _tmp14_;
				_tmp12_ = email;
				_tmp13_ = geary_email_get_email_flags (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = geary_named_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), flag) == contains;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (email);
				_g_object_unref0 (_email_list);
				return result;
			}
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_list);
	}
	result = FALSE;
	return result;
}

static gboolean
geary_app_conversation_has_flag (GearyAppConversation* self,
                                 GearyNamedFlag* flag)
{
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_NAMED_FLAG (flag), FALSE);
	result = geary_app_conversation_check_flag (self, flag, TRUE);
	return result;
}

static gboolean
geary_app_conversation_is_missing_flag (GearyAppConversation* self,
                                        GearyNamedFlag* flag)
{
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_NAMED_FLAG (flag), FALSE);
	result = geary_app_conversation_check_flag (self, flag, FALSE);
	return result;
}

static void
geary_app_conversation_class_init (GearyAppConversationClass * klass,
                                   gpointer klass_data)
{
	geary_app_conversation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppConversation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_conversation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_conversation_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_conversation_finalize;
	/** Folder from which the conversation originated. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY, geary_app_conversation_properties[GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY] = g_param_spec_object ("base-folder", "base-folder", "base-folder", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Cache of paths associated with each email */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY, geary_app_conversation_properties[GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY] = g_param_spec_object ("path-map", "path-map", "path-map", GEE_TYPE_HASH_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when email has been added to this conversation.
	     */
	geary_app_conversation_signals[GEARY_APP_CONVERSATION_APPENDED_SIGNAL] = g_signal_new ("appended", GEARY_APP_TYPE_CONVERSATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_EMAIL);
	/**
	     * Fired when email has been trimmed from this conversation.
	     */
	geary_app_conversation_signals[GEARY_APP_CONVERSATION_TRIMMED_SIGNAL] = g_signal_new ("trimmed", GEARY_APP_TYPE_CONVERSATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_EMAIL);
	/**
	     * Fired when the flags of an email in this conversation have changed.
	     */
	geary_app_conversation_signals[GEARY_APP_CONVERSATION_EMAIL_FLAGS_CHANGED_SIGNAL] = g_signal_new ("email-flags-changed", GEARY_APP_TYPE_CONVERSATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_EMAIL);
}

static void
geary_app_conversation_instance_init (GearyAppConversation * self,
                                      gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiSet* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeTreeSet* _tmp3_;
	GeeTreeSet* _tmp4_;
	GeeTreeSet* _tmp5_;
	GeeTreeSet* _tmp6_;
	self->priv = geary_app_conversation_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_path_map = _tmp0_;
	_tmp1_ = gee_hash_multi_set_new_fixed (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->message_ids = _tmp1_;
	_tmp2_ = gee_hash_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->emails = _tmp2_;
	_tmp3_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_sent_date_ascending_gcompare_data_func, NULL, NULL);
	self->priv->sent_date_ascending = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	_tmp4_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_sent_date_descending_gcompare_data_func, NULL, NULL);
	self->priv->sent_date_descending = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	_tmp5_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_recv_date_ascending_gcompare_data_func, NULL, NULL);
	self->priv->recv_date_ascending = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_SORTED_SET, GeeSortedSet);
	_tmp6_ = gee_tree_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_email_compare_recv_date_descending_gcompare_data_func, NULL, NULL);
	self->priv->recv_date_descending = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_SORTED_SET, GeeSortedSet);
}

static void
geary_app_conversation_finalize (GObject * obj)
{
	GearyAppConversation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_CONVERSATION, GearyAppConversation);
	_g_object_unref0 (self->priv->_base_folder);
	_g_object_unref0 (self->priv->_path_map);
	_g_object_unref0 (self->priv->message_ids);
	_g_object_unref0 (self->priv->emails);
	_g_object_unref0 (self->priv->sent_date_ascending);
	_g_object_unref0 (self->priv->sent_date_descending);
	_g_object_unref0 (self->priv->recv_date_ascending);
	_g_object_unref0 (self->priv->recv_date_descending);
	G_OBJECT_CLASS (geary_app_conversation_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_app_conversation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppConversationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_conversation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppConversation), 0, (GInstanceInitFunc) geary_app_conversation_instance_init, NULL };
	GType geary_app_conversation_type_id;
	geary_app_conversation_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppConversation", &g_define_type_info, 0);
	GearyAppConversation_private_offset = g_type_add_instance_private (geary_app_conversation_type_id, sizeof (GearyAppConversationPrivate));
	return geary_app_conversation_type_id;
}

GType
geary_app_conversation_get_type (void)
{
	static gsize geary_app_conversation_type_id__once = 0;
	if (g_once_init_enter (&geary_app_conversation_type_id__once)) {
		GType geary_app_conversation_type_id;
		geary_app_conversation_type_id = geary_app_conversation_get_type_once ();
		g_once_init_leave (&geary_app_conversation_type_id__once, geary_app_conversation_type_id);
	}
	return geary_app_conversation_type_id__once;
}

static void
_vala_geary_app_conversation_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyAppConversation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION, GearyAppConversation);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY:
		g_value_set_object (value, geary_app_conversation_get_base_folder (self));
		break;
		case GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY:
		g_value_set_object (value, geary_app_conversation_get_path_map (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_conversation_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyAppConversation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION, GearyAppConversation);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_BASE_FOLDER_PROPERTY:
		geary_app_conversation_set_base_folder (self, g_value_get_object (value));
		break;
		case GEARY_APP_CONVERSATION_PATH_MAP_PROPERTY:
		geary_app_conversation_set_path_map (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

