/* imap-namespace-response.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-namespace-response.vala, do not modify */

/*
 * Copyright 2016 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_NAMESPACE_RESPONSE_0_PROPERTY,
	GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY,
	GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY,
	GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY,
	GEARY_IMAP_NAMESPACE_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapNamespaceResponsePrivate {
	GeeList* _personal;
	GeeList* _user;
	GeeList* _shared;
};

static gint GearyImapNamespaceResponse_private_offset;
static gpointer geary_imap_namespace_response_parent_class = NULL;

static void geary_imap_namespace_response_set_personal (GearyImapNamespaceResponse* self,
                                                 GeeList* value);
static void geary_imap_namespace_response_set_user (GearyImapNamespaceResponse* self,
                                             GeeList* value);
static void geary_imap_namespace_response_set_shared (GearyImapNamespaceResponse* self,
                                               GeeList* value);
static GeeList* geary_imap_namespace_response_parse_namespaces (GearyImapListParameter* list,
                                                         GError** error);
static GearyImapNamespace* geary_imap_namespace_response_parse_namespace (GearyImapListParameter* list,
                                                                   GError** error);
static void geary_imap_namespace_response_finalize (GObject * obj);
static GType geary_imap_namespace_response_get_type_once (void);
static void _vala_geary_imap_namespace_response_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_geary_imap_namespace_response_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
geary_imap_namespace_response_get_instance_private (GearyImapNamespaceResponse* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapNamespaceResponse_private_offset);
}

GeeList*
geary_imap_namespace_response_get_personal (GearyImapNamespaceResponse* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_personal;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_namespace_response_set_personal (GearyImapNamespaceResponse* self,
                                            GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self));
	old_value = geary_imap_namespace_response_get_personal (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_personal);
		self->priv->_personal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY]);
	}
}

GeeList*
geary_imap_namespace_response_get_user (GearyImapNamespaceResponse* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
geary_imap_namespace_response_set_user (GearyImapNamespaceResponse* self,
                                        GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self));
	old_value = geary_imap_namespace_response_get_user (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY]);
	}
}

GeeList*
geary_imap_namespace_response_get_shared (GearyImapNamespaceResponse* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_shared;
	result = _tmp0_;
	return result;
}

static void
geary_imap_namespace_response_set_shared (GearyImapNamespaceResponse* self,
                                          GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (GEARY_IMAP_IS_NAMESPACE_RESPONSE (self));
	old_value = geary_imap_namespace_response_get_shared (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_shared);
		self->priv->_shared = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY]);
	}
}

/**
     * Decodes {@link ServerData} into a NamespaceResponse representation.
     *
     * The ServerData must be the response to a NAMESPACE command.
     *
     * @see ServerData.get_list
     */
GearyImapNamespaceResponse*
geary_imap_namespace_response_decode (GearyImapServerData* server_data,
                                      GError** error)
{
	GearyImapStringParameter* cmd = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapStringParameter* _tmp1_;
	gint _tmp6_;
	gint _tmp7_;
	GearyImapListParameter* personal = NULL;
	GearyImapListParameter* _tmp12_;
	GearyImapListParameter* user = NULL;
	gint _tmp13_;
	gint _tmp14_;
	GearyImapListParameter* shared = NULL;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp23_ = NULL;
	GearyImapListParameter* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_ = NULL;
	GearyImapListParameter* _tmp27_;
	GeeList* _tmp30_ = NULL;
	GearyImapListParameter* _tmp31_;
	GearyImapNamespaceResponse* _tmp34_;
	GError* _inner_error0_ = NULL;
	GearyImapNamespaceResponse* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (server_data), NULL);
	_tmp0_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	cmd = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = cmd;
	if (!geary_imap_string_parameter_equals_ci (_tmp1_, GEARY_IMAP_NAMESPACE_COMMAND_NAME)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Not NAMESPACE data: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp7_ = _tmp6_;
	if (_tmp7_ <= 2) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		_tmp8_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "No NAMESPACEs provided: %s", _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = geary_imap_list_parameter_get_as_nullable_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	personal = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	user = NULL;
	_tmp13_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp14_ = _tmp13_;
	if (_tmp14_ >= 4) {
		GearyImapListParameter* _tmp15_ = NULL;
		GearyImapListParameter* _tmp16_;
		GearyImapListParameter* _tmp17_;
		_tmp16_ = geary_imap_list_parameter_get_as_nullable_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 3, &_inner_error0_);
		_tmp15_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				return NULL;
			} else {
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp17_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (user);
		user = _tmp17_;
		_g_object_unref0 (_tmp15_);
	}
	shared = NULL;
	_tmp18_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp19_ = _tmp18_;
	if (_tmp19_ >= 5) {
		GearyImapListParameter* _tmp20_ = NULL;
		GearyImapListParameter* _tmp21_;
		GearyImapListParameter* _tmp22_;
		_tmp21_ = geary_imap_list_parameter_get_as_nullable_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 4, &_inner_error0_);
		_tmp20_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				return NULL;
			} else {
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp22_ = _tmp20_;
		_tmp20_ = NULL;
		_g_object_unref0 (shared);
		shared = _tmp22_;
		_g_object_unref0 (_tmp20_);
	}
	_tmp24_ = personal;
	_tmp25_ = geary_imap_namespace_response_parse_namespaces (_tmp24_, &_inner_error0_);
	_tmp23_ = _tmp25_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (shared);
			_g_object_unref0 (user);
			_g_object_unref0 (personal);
			_g_object_unref0 (cmd);
			return NULL;
		} else {
			_g_object_unref0 (shared);
			_g_object_unref0 (user);
			_g_object_unref0 (personal);
			_g_object_unref0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp27_ = user;
	if (_tmp27_ != NULL) {
		GearyImapListParameter* _tmp28_;
		GeeList* _tmp29_;
		_tmp28_ = user;
		_tmp29_ = geary_imap_namespace_response_parse_namespaces (_tmp28_, &_inner_error0_);
		_g_object_unref0 (_tmp26_);
		_tmp26_ = _tmp29_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				return NULL;
			} else {
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		_g_object_unref0 (_tmp26_);
		_tmp26_ = NULL;
	}
	_tmp31_ = shared;
	if (_tmp31_ != NULL) {
		GearyImapListParameter* _tmp32_;
		GeeList* _tmp33_;
		_tmp32_ = shared;
		_tmp33_ = geary_imap_namespace_response_parse_namespaces (_tmp32_, &_inner_error0_);
		_g_object_unref0 (_tmp30_);
		_tmp30_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp30_);
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				return NULL;
			} else {
				_g_object_unref0 (_tmp30_);
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (shared);
				_g_object_unref0 (user);
				_g_object_unref0 (personal);
				_g_object_unref0 (cmd);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		_g_object_unref0 (_tmp30_);
		_tmp30_ = NULL;
	}
	_tmp34_ = geary_imap_namespace_response_new (_tmp23_, _tmp26_, _tmp30_);
	result = _tmp34_;
	_g_object_unref0 (_tmp30_);
	_g_object_unref0 (_tmp26_);
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (shared);
	_g_object_unref0 (user);
	_g_object_unref0 (personal);
	_g_object_unref0 (cmd);
	return result;
}

static GeeList*
geary_imap_namespace_response_parse_namespaces (GearyImapListParameter* list,
                                                GError** error)
{
	GeeList* nss = NULL;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail ((list == NULL) || GEARY_IMAP_IS_LIST_PARAMETER (list), NULL);
	nss = NULL;
	if (list != NULL) {
		GeeArrayList* _tmp0_;
		_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (nss);
		nss = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					gint _tmp4_;
					GearyImapListParameter* _tmp5_ = NULL;
					GearyImapListParameter* _tmp6_;
					GearyImapNamespace* _tmp7_ = NULL;
					GearyImapNamespace* _tmp8_;
					GeeList* _tmp9_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = geary_imap_list_parameter_get_size (list);
					_tmp4_ = _tmp3_;
					if (!(i < _tmp4_)) {
						break;
					}
					_tmp6_ = geary_imap_list_parameter_get_as_list (list, i, &_inner_error0_);
					_tmp5_ = _tmp6_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (nss);
							return NULL;
						} else {
							_g_object_unref0 (nss);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp8_ = geary_imap_namespace_response_parse_namespace (_tmp5_, &_inner_error0_);
					_tmp7_ = _tmp8_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (_tmp5_);
							_g_object_unref0 (nss);
							return NULL;
						} else {
							_g_object_unref0 (_tmp5_);
							_g_object_unref0 (nss);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp9_ = nss;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp7_);
					_g_object_unref0 (_tmp7_);
					_g_object_unref0 (_tmp5_);
				}
			}
		}
	}
	result = nss;
	return result;
}

static GearyImapNamespace*
geary_imap_namespace_response_parse_namespace (GearyImapListParameter* list,
                                               GError** error)
{
	GearyImapNamespace* ns = NULL;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	GearyImapNamespace* result;
	g_return_val_if_fail ((list == NULL) || GEARY_IMAP_IS_LIST_PARAMETER (list), NULL);
	ns = NULL;
	if (list != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = geary_imap_list_parameter_get_size (list);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ >= 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyImapStringParameter* _tmp3_ = NULL;
		GearyImapStringParameter* _tmp4_;
		GearyImapStringParameter* _tmp5_ = NULL;
		GearyImapStringParameter* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GearyImapNamespace* _tmp11_;
		_tmp4_ = geary_imap_list_parameter_get_as_string (list, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (ns);
				return NULL;
			} else {
				_g_object_unref0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp6_ = geary_imap_list_parameter_get_as_nullable_string (list, 1, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (ns);
				return NULL;
			} else {
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp7_ = geary_imap_string_parameter_get_ascii (_tmp3_);
		_tmp8_ = _tmp7_;
		_tmp9_ = geary_imap_string_parameter_get_nullable_ascii (_tmp5_);
		_tmp10_ = _tmp9_;
		_tmp11_ = geary_imap_namespace_new (_tmp8_, _tmp10_);
		_g_object_unref0 (ns);
		ns = _tmp11_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
	}
	result = ns;
	return result;
}

GearyImapNamespaceResponse*
geary_imap_namespace_response_construct (GType object_type,
                                         GeeList* personal,
                                         GeeList* user,
                                         GeeList* shared)
{
	GearyImapNamespaceResponse * self = NULL;
	g_return_val_if_fail ((personal == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (personal, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((user == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (user, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((shared == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (shared, GEE_TYPE_LIST), NULL);
	self = (GearyImapNamespaceResponse*) geary_base_object_construct (object_type);
	geary_imap_namespace_response_set_personal (self, personal);
	geary_imap_namespace_response_set_user (self, user);
	geary_imap_namespace_response_set_shared (self, shared);
	return self;
}

GearyImapNamespaceResponse*
geary_imap_namespace_response_new (GeeList* personal,
                                   GeeList* user,
                                   GeeList* shared)
{
	return geary_imap_namespace_response_construct (GEARY_IMAP_TYPE_NAMESPACE_RESPONSE, personal, user, shared);
}

static void
geary_imap_namespace_response_class_init (GearyImapNamespaceResponseClass * klass,
                                          gpointer klass_data)
{
	geary_imap_namespace_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapNamespaceResponse_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_namespace_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_namespace_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_namespace_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY] = g_param_spec_object ("personal", "personal", "personal", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY, geary_imap_namespace_response_properties[GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY] = g_param_spec_object ("shared", "shared", "shared", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_namespace_response_instance_init (GearyImapNamespaceResponse * self,
                                             gpointer klass)
{
	self->priv = geary_imap_namespace_response_get_instance_private (self);
	self->priv->_personal = NULL;
	self->priv->_user = NULL;
	self->priv->_shared = NULL;
}

static void
geary_imap_namespace_response_finalize (GObject * obj)
{
	GearyImapNamespaceResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_NAMESPACE_RESPONSE, GearyImapNamespaceResponse);
	_g_object_unref0 (self->priv->_personal);
	_g_object_unref0 (self->priv->_user);
	_g_object_unref0 (self->priv->_shared);
	G_OBJECT_CLASS (geary_imap_namespace_response_parent_class)->finalize (obj);
}

/**
 * Response for a NAMESPACE command.
 *
 * @see Geary.Imap.NamespaceCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_namespace_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapNamespaceResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_namespace_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapNamespaceResponse), 0, (GInstanceInitFunc) geary_imap_namespace_response_instance_init, NULL };
	GType geary_imap_namespace_response_type_id;
	geary_imap_namespace_response_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapNamespaceResponse", &g_define_type_info, 0);
	GearyImapNamespaceResponse_private_offset = g_type_add_instance_private (geary_imap_namespace_response_type_id, sizeof (GearyImapNamespaceResponsePrivate));
	return geary_imap_namespace_response_type_id;
}

GType
geary_imap_namespace_response_get_type (void)
{
	static gsize geary_imap_namespace_response_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_namespace_response_type_id__once)) {
		GType geary_imap_namespace_response_type_id;
		geary_imap_namespace_response_type_id = geary_imap_namespace_response_get_type_once ();
		g_once_init_leave (&geary_imap_namespace_response_type_id__once, geary_imap_namespace_response_type_id);
	}
	return geary_imap_namespace_response_type_id__once;
}

static void
_vala_geary_imap_namespace_response_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapNamespaceResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_NAMESPACE_RESPONSE, GearyImapNamespaceResponse);
	switch (property_id) {
		case GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY:
		g_value_set_object (value, geary_imap_namespace_response_get_personal (self));
		break;
		case GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY:
		g_value_set_object (value, geary_imap_namespace_response_get_user (self));
		break;
		case GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY:
		g_value_set_object (value, geary_imap_namespace_response_get_shared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_namespace_response_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapNamespaceResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_NAMESPACE_RESPONSE, GearyImapNamespaceResponse);
	switch (property_id) {
		case GEARY_IMAP_NAMESPACE_RESPONSE_PERSONAL_PROPERTY:
		geary_imap_namespace_response_set_personal (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_NAMESPACE_RESPONSE_USER_PROPERTY:
		geary_imap_namespace_response_set_user (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_NAMESPACE_RESPONSE_SHARED_PROPERTY:
		geary_imap_namespace_response_set_shared (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

