/* state-machine-descriptor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from state-machine-descriptor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_STATE_MACHINE_DESCRIPTOR_0_PROPERTY,
	GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY,
	GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY,
	GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY,
	GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY,
	GEARY_STATE_MACHINE_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyStateMachineDescriptorPrivate {
	gchar* _name;
	guint _start_state;
	guint _state_count;
	guint _event_count;
	GearyStateStateEventToString state_to_string;
	gpointer state_to_string_target;
	GearyStateStateEventToString event_to_string;
	gpointer event_to_string_target;
};

static gint GearyStateMachineDescriptor_private_offset;
static gpointer geary_state_machine_descriptor_parent_class = NULL;

static void geary_state_machine_descriptor_set_name (GearyStateMachineDescriptor* self,
                                              const gchar* value);
static void geary_state_machine_descriptor_set_start_state (GearyStateMachineDescriptor* self,
                                                     guint value);
static void geary_state_machine_descriptor_set_state_count (GearyStateMachineDescriptor* self,
                                                     guint value);
static void geary_state_machine_descriptor_set_event_count (GearyStateMachineDescriptor* self,
                                                     guint value);
static void geary_state_machine_descriptor_finalize (GObject * obj);
static GType geary_state_machine_descriptor_get_type_once (void);
static void _vala_geary_state_machine_descriptor_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_state_machine_descriptor_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
geary_state_machine_descriptor_get_instance_private (GearyStateMachineDescriptor* self)
{
	return G_STRUCT_MEMBER_P (self, GearyStateMachineDescriptor_private_offset);
}

const gchar*
geary_state_machine_descriptor_get_name (GearyStateMachineDescriptor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
geary_state_machine_descriptor_set_name (GearyStateMachineDescriptor* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self));
	old_value = geary_state_machine_descriptor_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY]);
	}
}

guint
geary_state_machine_descriptor_get_start_state (GearyStateMachineDescriptor* self)
{
	guint result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), 0U);
	result = self->priv->_start_state;
	return result;
}

static void
geary_state_machine_descriptor_set_start_state (GearyStateMachineDescriptor* self,
                                                guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self));
	old_value = geary_state_machine_descriptor_get_start_state (self);
	if (old_value != value) {
		self->priv->_start_state = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY]);
	}
}

guint
geary_state_machine_descriptor_get_state_count (GearyStateMachineDescriptor* self)
{
	guint result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), 0U);
	result = self->priv->_state_count;
	return result;
}

static void
geary_state_machine_descriptor_set_state_count (GearyStateMachineDescriptor* self,
                                                guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self));
	old_value = geary_state_machine_descriptor_get_state_count (self);
	if (old_value != value) {
		self->priv->_state_count = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY]);
	}
}

guint
geary_state_machine_descriptor_get_event_count (GearyStateMachineDescriptor* self)
{
	guint result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), 0U);
	result = self->priv->_event_count;
	return result;
}

static void
geary_state_machine_descriptor_set_event_count (GearyStateMachineDescriptor* self,
                                                guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self));
	old_value = geary_state_machine_descriptor_get_event_count (self);
	if (old_value != value) {
		self->priv->_event_count = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY]);
	}
}

GearyStateMachineDescriptor*
geary_state_machine_descriptor_construct (GType object_type,
                                          const gchar* name,
                                          guint start_state,
                                          guint state_count,
                                          guint event_count,
                                          GearyStateStateEventToString state_to_string,
                                          gpointer state_to_string_target,
                                          GearyStateStateEventToString event_to_string,
                                          gpointer event_to_string_target)
{
	GearyStateMachineDescriptor * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyStateMachineDescriptor*) geary_base_object_construct (object_type);
	geary_state_machine_descriptor_set_name (self, name);
	geary_state_machine_descriptor_set_start_state (self, start_state);
	geary_state_machine_descriptor_set_state_count (self, state_count);
	geary_state_machine_descriptor_set_event_count (self, event_count);
	self->priv->state_to_string = state_to_string;
	self->priv->state_to_string_target = state_to_string_target;
	self->priv->event_to_string = event_to_string;
	self->priv->event_to_string_target = event_to_string_target;
	_vala_assert (start_state < state_count, "start_state < state_count");
	return self;
}

GearyStateMachineDescriptor*
geary_state_machine_descriptor_new (const gchar* name,
                                    guint start_state,
                                    guint state_count,
                                    guint event_count,
                                    GearyStateStateEventToString state_to_string,
                                    gpointer state_to_string_target,
                                    GearyStateStateEventToString event_to_string,
                                    gpointer event_to_string_target)
{
	return geary_state_machine_descriptor_construct (GEARY_STATE_TYPE_MACHINE_DESCRIPTOR, name, start_state, state_count, event_count, state_to_string, state_to_string_target, event_to_string, event_to_string_target);
}

gchar*
geary_state_machine_descriptor_get_state_string (GearyStateMachineDescriptor* self,
                                                 guint state)
{
	gchar* _tmp0_ = NULL;
	GearyStateStateEventToString _tmp1_;
	gpointer _tmp1__target;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), NULL);
	_tmp1_ = self->priv->state_to_string;
	_tmp1__target = self->priv->state_to_string_target;
	if (_tmp1_ != NULL) {
		GearyStateStateEventToString _tmp2_;
		gpointer _tmp2__target;
		gchar* _tmp3_;
		_tmp2_ = self->priv->state_to_string;
		_tmp2__target = self->priv->state_to_string_target;
		_tmp3_ = _tmp2_ (state, _tmp2__target);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_name;
		_tmp5_ = g_strdup_printf ("%s STATE %u", _tmp4_, state);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_state_machine_descriptor_get_event_string (GearyStateMachineDescriptor* self,
                                                 guint event)
{
	gchar* _tmp0_ = NULL;
	GearyStateStateEventToString _tmp1_;
	gpointer _tmp1__target;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (self), NULL);
	_tmp1_ = self->priv->event_to_string;
	_tmp1__target = self->priv->event_to_string_target;
	if (_tmp1_ != NULL) {
		GearyStateStateEventToString _tmp2_;
		gpointer _tmp2__target;
		gchar* _tmp3_;
		_tmp2_ = self->priv->event_to_string;
		_tmp2__target = self->priv->event_to_string_target;
		_tmp3_ = _tmp2_ (event, _tmp2__target);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_name;
		_tmp5_ = g_strdup_printf ("%s EVENT %u", _tmp4_, event);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static void
geary_state_machine_descriptor_class_init (GearyStateMachineDescriptorClass * klass,
                                           gpointer klass_data)
{
	geary_state_machine_descriptor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyStateMachineDescriptor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_state_machine_descriptor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_state_machine_descriptor_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_state_machine_descriptor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY] = g_param_spec_uint ("start-state", "start-state", "start-state", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY] = g_param_spec_uint ("state-count", "state-count", "state-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY, geary_state_machine_descriptor_properties[GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY] = g_param_spec_uint ("event-count", "event-count", "event-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_state_machine_descriptor_instance_init (GearyStateMachineDescriptor * self,
                                              gpointer klass)
{
	self->priv = geary_state_machine_descriptor_get_instance_private (self);
}

static void
geary_state_machine_descriptor_finalize (GObject * obj)
{
	GearyStateMachineDescriptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_STATE_TYPE_MACHINE_DESCRIPTOR, GearyStateMachineDescriptor);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (geary_state_machine_descriptor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_state_machine_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyStateMachineDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_state_machine_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyStateMachineDescriptor), 0, (GInstanceInitFunc) geary_state_machine_descriptor_instance_init, NULL };
	GType geary_state_machine_descriptor_type_id;
	geary_state_machine_descriptor_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyStateMachineDescriptor", &g_define_type_info, 0);
	GearyStateMachineDescriptor_private_offset = g_type_add_instance_private (geary_state_machine_descriptor_type_id, sizeof (GearyStateMachineDescriptorPrivate));
	return geary_state_machine_descriptor_type_id;
}

GType
geary_state_machine_descriptor_get_type (void)
{
	static gsize geary_state_machine_descriptor_type_id__once = 0;
	if (g_once_init_enter (&geary_state_machine_descriptor_type_id__once)) {
		GType geary_state_machine_descriptor_type_id;
		geary_state_machine_descriptor_type_id = geary_state_machine_descriptor_get_type_once ();
		g_once_init_leave (&geary_state_machine_descriptor_type_id__once, geary_state_machine_descriptor_type_id);
	}
	return geary_state_machine_descriptor_type_id__once;
}

static void
_vala_geary_state_machine_descriptor_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyStateMachineDescriptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_STATE_TYPE_MACHINE_DESCRIPTOR, GearyStateMachineDescriptor);
	switch (property_id) {
		case GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY:
		g_value_set_string (value, geary_state_machine_descriptor_get_name (self));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY:
		g_value_set_uint (value, geary_state_machine_descriptor_get_start_state (self));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY:
		g_value_set_uint (value, geary_state_machine_descriptor_get_state_count (self));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY:
		g_value_set_uint (value, geary_state_machine_descriptor_get_event_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_state_machine_descriptor_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyStateMachineDescriptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_STATE_TYPE_MACHINE_DESCRIPTOR, GearyStateMachineDescriptor);
	switch (property_id) {
		case GEARY_STATE_MACHINE_DESCRIPTOR_NAME_PROPERTY:
		geary_state_machine_descriptor_set_name (self, g_value_get_string (value));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_START_STATE_PROPERTY:
		geary_state_machine_descriptor_set_start_state (self, g_value_get_uint (value));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_STATE_COUNT_PROPERTY:
		geary_state_machine_descriptor_set_state_count (self, g_value_get_uint (value));
		break;
		case GEARY_STATE_MACHINE_DESCRIPTOR_EVENT_COUNT_PROPERTY:
		geary_state_machine_descriptor_set_event_count (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

