// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: cluster.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RaftService_SendMessage_FullMethodName  = "/gitaly.RaftService/SendMessage"
	RaftService_SendSnapshot_FullMethodName = "/gitaly.RaftService/SendSnapshot"
)

// RaftServiceClient is the client API for RaftService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// RaftService manages the sending of Raft messages to peers.
type RaftServiceClient interface {
	// SendMessage processes Raft messages and ensures they are handled by
	// the receiving node to update its Raft state machine.
	SendMessage(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse], error)
	// SendSnapshot sends raft snapshots from the leader to the follower node. Typically it
	// would be useful for nodes to catch up to the latest state.
	SendSnapshot(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse], error)
}

type raftServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRaftServiceClient(cc grpc.ClientConnInterface) RaftServiceClient {
	return &raftServiceClient{cc}
}

func (c *raftServiceClient) SendMessage(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RaftService_ServiceDesc.Streams[0], RaftService_SendMessage_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RaftMessageRequest, RaftMessageResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendMessageClient = grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse]

func (c *raftServiceClient) SendSnapshot(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RaftService_ServiceDesc.Streams[1], RaftService_SendSnapshot_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendSnapshotClient = grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]

// RaftServiceServer is the server API for RaftService service.
// All implementations must embed UnimplementedRaftServiceServer
// for forward compatibility.
//
// RaftService manages the sending of Raft messages to peers.
type RaftServiceServer interface {
	// SendMessage processes Raft messages and ensures they are handled by
	// the receiving node to update its Raft state machine.
	SendMessage(grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]) error
	// SendSnapshot sends raft snapshots from the leader to the follower node. Typically it
	// would be useful for nodes to catch up to the latest state.
	SendSnapshot(grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]) error
	mustEmbedUnimplementedRaftServiceServer()
}

// UnimplementedRaftServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRaftServiceServer struct{}

func (UnimplementedRaftServiceServer) SendMessage(grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SendMessage not implemented")
}
func (UnimplementedRaftServiceServer) SendSnapshot(grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SendSnapshot not implemented")
}
func (UnimplementedRaftServiceServer) mustEmbedUnimplementedRaftServiceServer() {}
func (UnimplementedRaftServiceServer) testEmbeddedByValue()                     {}

// UnsafeRaftServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RaftServiceServer will
// result in compilation errors.
type UnsafeRaftServiceServer interface {
	mustEmbedUnimplementedRaftServiceServer()
}

func RegisterRaftServiceServer(s grpc.ServiceRegistrar, srv RaftServiceServer) {
	// If the following call pancis, it indicates UnimplementedRaftServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RaftService_ServiceDesc, srv)
}

func _RaftService_SendMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RaftServiceServer).SendMessage(&grpc.GenericServerStream[RaftMessageRequest, RaftMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendMessageServer = grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]

func _RaftService_SendSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RaftServiceServer).SendSnapshot(&grpc.GenericServerStream[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendSnapshotServer = grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]

// RaftService_ServiceDesc is the grpc.ServiceDesc for RaftService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RaftService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RaftService",
	HandlerType: (*RaftServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SendMessage",
			Handler:       _RaftService_SendMessage_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "SendSnapshot",
			Handler:       _RaftService_SendSnapshot_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "cluster.proto",
}
