/* sudoku-saver.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libsudoku.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SUDOKU_SAVER_0_PROPERTY,
	SUDOKU_SAVER_NUM_PROPERTIES
};
static GParamSpec* sudoku_saver_properties[SUDOKU_SAVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SudokuSaverPrivate {
	GeeHashMap* highscores;
};

static gint SudokuSaver_private_offset;
static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;
static gchar* sudoku_saver__highscores_file;
static gchar* sudoku_saver__highscores_file = NULL;

static void sudoku_saver_set_finishgame_dir (const gchar* value);
static void sudoku_saver_set_savegame_file (const gchar* value);
static void sudoku_saver_set_highscores_file (const gchar* value);
static gdouble* _double_dup (gdouble* self);
static void sudoku_saver_get_highscores (SudokuSaver* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void sudoku_saver_read_difficulty (SudokuSaver* self,
                                   JsonReader* reader,
                                   DifficultyCategory diff);
static void _vala_JsonNode_free (JsonNode* self);
static void sudoku_saver_save_highscores (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self,
                                             const gchar* file_path);
static void sudoku_saver_create_file_for_game (SudokuSaver* self,
                                        SudokuGame* game,
                                        const gchar* file_name,
                                        gboolean save_timer);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self,
                                            SudokuGame* game,
                                            gboolean save_timer);
static void _vala_array_add1 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
static void sudoku_saver_finalize (GObject * obj);
static GType sudoku_saver_get_type_once (void);
static void _vala_sudoku_saver_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sudoku_saver_get_instance_private (SudokuSaver* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuSaver_private_offset);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

SudokuSaver*
sudoku_saver_construct (GType object_type)
{
	SudokuSaver * self = NULL;
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* sudoku_data_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GeeHashMap* _tmp16_;
	self = (SudokuSaver*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = config_dir;
	_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
	sudoku_data_dir = _tmp3_;
	_tmp4_ = sudoku_data_dir;
	_tmp5_ = g_build_path (G_DIR_SEPARATOR_S, _tmp4_, "finished", NULL);
	_tmp6_ = _tmp5_;
	sudoku_saver_set_finishgame_dir (_tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = sudoku_data_dir;
	_tmp8_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, "savefile", NULL);
	_tmp9_ = _tmp8_;
	sudoku_saver_set_savegame_file (_tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = sudoku_data_dir;
	_tmp11_ = g_build_path (G_DIR_SEPARATOR_S, _tmp10_, "highscores", NULL);
	_tmp12_ = _tmp11_;
	sudoku_saver_set_highscores_file (_tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = sudoku_saver_get_finishgame_dir ();
	_tmp14_ = _tmp13_;
	if (g_mkdir_with_parents (_tmp14_, 0755) == -1) {
		const gchar* _tmp15_;
		_tmp15_ = g_strerror (errno);
		g_warning ("sudoku-saver.vala:41: Failed to create saver directory: %s", _tmp15_);
	}
	_tmp16_ = gee_hash_map_new (TYPE_DIFFICULTY_CATEGORY, NULL, NULL, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp16_;
	sudoku_saver_get_highscores (self);
	_g_free0 (sudoku_data_dir);
	_g_free0 (config_dir);
	return self;
}

SudokuSaver*
sudoku_saver_new (void)
{
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
}

gdouble*
sudoku_saver_get_highscore (SudokuSaver* self,
                            DifficultyCategory difficulty)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gdouble* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->highscores;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) difficulty));
	result = (gdouble*) _tmp1_;
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
sudoku_saver_get_highscores (SudokuSaver* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	JsonNode* node = NULL;
	JsonParser* _tmp8_;
	JsonNode* _tmp9_;
	JsonNode* _tmp10_;
	JsonReader* reader = NULL;
	JsonNode* _tmp11_;
	JsonReader* _tmp12_;
	JsonReader* _tmp13_;
	JsonReader* _tmp14_;
	JsonReader* _tmp15_;
	JsonReader* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_saver_get_highscores_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		_g_object_unref0 (file);
		return;
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonParser* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = parser;
		_tmp6_ = sudoku_saver_get_highscores_file ();
		_tmp7_ = _tmp6_;
		json_parser_load_from_file (_tmp5_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (parser);
		_g_object_unref0 (file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = parser;
	_tmp9_ = json_parser_get_root (_tmp8_);
	_tmp10_ = __vala_JsonNode_copy0 (_tmp9_);
	node = _tmp10_;
	_tmp11_ = node;
	_tmp12_ = json_reader_new (_tmp11_);
	reader = _tmp12_;
	_tmp13_ = reader;
	sudoku_saver_read_difficulty (self, _tmp13_, DIFFICULTY_CATEGORY_EASY);
	_tmp14_ = reader;
	sudoku_saver_read_difficulty (self, _tmp14_, DIFFICULTY_CATEGORY_MEDIUM);
	_tmp15_ = reader;
	sudoku_saver_read_difficulty (self, _tmp15_, DIFFICULTY_CATEGORY_HARD);
	_tmp16_ = reader;
	sudoku_saver_read_difficulty (self, _tmp16_, DIFFICULTY_CATEGORY_VERY_HARD);
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (parser);
	_g_object_unref0 (file);
}

static void
sudoku_saver_read_difficulty (SudokuSaver* self,
                              JsonReader* reader,
                              DifficultyCategory diff)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reader != NULL);
	_tmp0_ = difficulty_category_to_untranslated_string (diff);
	_tmp1_ = _tmp0_;
	json_reader_read_member (reader, _tmp1_);
	_g_free0 (_tmp1_);
	if (json_reader_is_value (reader)) {
		GeeHashMap* _tmp2_;
		gdouble _tmp3_;
		_tmp2_ = self->priv->highscores;
		_tmp3_ = json_reader_get_double_value (reader);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) diff), &_tmp3_);
	}
	json_reader_end_member (reader);
}

void
sudoku_saver_save_highscore (SudokuSaver* self,
                             DifficultyCategory difficulty,
                             gdouble time_elapsed)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highscores;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) difficulty), &time_elapsed);
	sudoku_saver_save_highscores (self);
}

static void
sudoku_saver_save_highscores (SudokuSaver* self)
{
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp0_;
	JsonBuilder* _tmp1_;
	JsonBuilder* _tmp17_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp18_;
	JsonNode* root = NULL;
	JsonBuilder* _tmp19_;
	JsonNode* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = json_builder_new ();
	builder = _tmp0_;
	_tmp1_ = builder;
	json_builder_begin_object (_tmp1_);
	{
		GeeIterator* _highscore_it = NULL;
		GeeHashMap* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = self->priv->highscores;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_highscore_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GeeMapEntry* highscore = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			JsonBuilder* _tmp7_;
			GeeMapEntry* _tmp8_;
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			JsonBuilder* _tmp13_;
			GeeMapEntry* _tmp14_;
			gconstpointer _tmp15_;
			gconstpointer _tmp16_;
			_tmp4_ = _highscore_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _highscore_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			highscore = (GeeMapEntry*) _tmp6_;
			_tmp7_ = builder;
			_tmp8_ = highscore;
			_tmp9_ = gee_map_entry_get_key (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = difficulty_category_to_untranslated_string ((DifficultyCategory) ((gintptr) _tmp10_));
			_tmp12_ = _tmp11_;
			json_builder_set_member_name (_tmp7_, _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = builder;
			_tmp14_ = highscore;
			_tmp15_ = gee_map_entry_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			json_builder_add_double_value (_tmp13_, *((gdouble*) _tmp16_));
			_g_object_unref0 (highscore);
		}
		_g_object_unref0 (_highscore_it);
	}
	_tmp17_ = builder;
	json_builder_end_object (_tmp17_);
	_tmp18_ = json_generator_new ();
	generator = _tmp18_;
	json_generator_set_pretty (generator, TRUE);
	_tmp19_ = builder;
	_tmp20_ = json_builder_get_root (_tmp19_);
	root = _tmp20_;
	json_generator_set_root (generator, root);
	{
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = sudoku_saver_get_highscores_file ();
		_tmp22_ = _tmp21_;
		json_generator_to_file (generator, _tmp22_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("sudoku-saver.vala:114: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (generator);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
}

SudokuGame*
sudoku_saver_get_savedgame (SudokuSaver* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SudokuGame* _tmp6_;
	SudokuGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp4_ = sudoku_saver_get_savegame_file ();
	_tmp5_ = _tmp4_;
	_tmp6_ = sudoku_saver_parse_json_to_game (self, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (file);
	return result;
}

void
sudoku_saver_save_game (SudokuSaver* self,
                        SudokuGame* game)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	sudoku_saver_create_file_for_game (self, game, _tmp1_, TRUE);
}

void
sudoku_saver_delete_save (SudokuSaver* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (g_file_query_exists (_tmp3_, NULL)) {
		{
			GFile* _tmp4_;
			_tmp4_ = file;
			g_file_delete (_tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = file;
			_tmp6_ = g_file_get_uri (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("sudoku-saver.vala:143: Failed to delete %s: %s", _tmp7_, _tmp9_);
			_g_free0 (_tmp7_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (file);
}

void
sudoku_saver_add_game_to_finished (SudokuSaver* self,
                                   SudokuGame* game,
                                   gboolean delete_savegame,
                                   gboolean save_timer)
{
	gchar* file_name = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoard* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* file_path = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = sudoku_game_get_board (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = sudoku_board_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".save", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file_name = _tmp5_;
	_tmp6_ = sudoku_saver_get_finishgame_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = file_name;
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp7_, _tmp8_, NULL);
	file_path = _tmp9_;
	_tmp10_ = file_path;
	sudoku_saver_create_file_for_game (self, game, _tmp10_, save_timer);
	if (delete_savegame) {
		sudoku_saver_delete_save (self);
	}
	_g_free0 (file_path);
	_g_free0 (file_name);
}

static void
sudoku_saver_create_file_for_game (SudokuSaver* self,
                                   SudokuGame* game,
                                   const gchar* file_name,
                                   gboolean save_timer)
{
	gchar* json_str = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = sudoku_saver_serialize_game_to_json (self, game, save_timer);
	json_str = _tmp0_;
	{
		g_file_set_contents (file_name, json_str, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("sudoku-saver.vala:168: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (json_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (json_str);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gchar*
sudoku_saver_serialize_game_to_json (SudokuSaver* self,
                                     SudokuGame* game,
                                     gboolean save_timer)
{
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	gint* board_cells = NULL;
	SudokuBoard* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_;
	gint board_cells_length1;
	gint board_cells_length2;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp7_;
	JsonBuilder* _tmp8_;
	JsonBuilder* _tmp9_;
	JsonBuilder* _tmp10_;
	SudokuBoard* _tmp11_;
	DifficultyCategory _tmp12_;
	DifficultyCategory _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	JsonBuilder* _tmp16_;
	GameMode _tmp17_;
	GameMode _tmp18_;
	JsonBuilder* _tmp22_;
	JsonBuilder* _tmp23_;
	JsonBuilder* _tmp64_;
	JsonBuilder* _tmp65_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp66_;
	JsonNode* root = NULL;
	JsonBuilder* _tmp67_;
	JsonNode* _tmp68_;
	gchar* _tmp69_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = sudoku_game_get_board (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	board = _tmp2_;
	_tmp3_ = board;
	_tmp6_ = sudoku_board_get_cells (_tmp3_, &_tmp4_, &_tmp5_);
	board_cells = _tmp6_;
	board_cells_length1 = _tmp4_;
	board_cells_length2 = _tmp5_;
	_tmp7_ = json_builder_new ();
	builder = _tmp7_;
	_tmp8_ = builder;
	json_builder_begin_object (_tmp8_);
	_tmp9_ = builder;
	json_builder_set_member_name (_tmp9_, "difficulty_category");
	_tmp10_ = builder;
	_tmp11_ = board;
	_tmp12_ = sudoku_board_get_difficulty_category (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = difficulty_category_to_untranslated_string (_tmp13_);
	_tmp15_ = _tmp14_;
	json_builder_add_string_value (_tmp10_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = builder;
	json_builder_set_member_name (_tmp16_, "time_elapsed");
	_tmp17_ = sudoku_game_get_mode (game);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == GAME_MODE_CREATE) {
		JsonBuilder* _tmp19_;
		_tmp19_ = builder;
		json_builder_add_double_value (_tmp19_, (gdouble) 0);
	} else {
		if (save_timer) {
			JsonBuilder* _tmp20_;
			_tmp20_ = builder;
			json_builder_add_double_value (_tmp20_, sudoku_game_get_total_time_played (game));
		} else {
			JsonBuilder* _tmp21_;
			_tmp21_ = builder;
			json_builder_add_double_value (_tmp21_, (gdouble) -1);
		}
	}
	_tmp22_ = builder;
	json_builder_set_member_name (_tmp22_, "cells");
	_tmp23_ = builder;
	json_builder_begin_array (_tmp23_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = board;
				_tmp27_ = sudoku_board_get_rows (_tmp26_);
				_tmp28_ = _tmp27_;
				if (!(i < _tmp28_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp29_ = FALSE;
						_tmp29_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint* earmarks = NULL;
							gint* _tmp34_;
							gint earmarks_length1;
							gint _earmarks_size_;
							gboolean _tmp41_ = FALSE;
							gint* _tmp42_;
							gint _tmp42__length1;
							gint _tmp42__length2;
							gint _tmp43_;
							JsonBuilder* _tmp45_;
							JsonBuilder* _tmp46_;
							JsonBuilder* _tmp47_;
							JsonBuilder* _tmp48_;
							JsonBuilder* _tmp49_;
							JsonBuilder* _tmp50_;
							JsonBuilder* _tmp51_;
							JsonBuilder* _tmp52_;
							gint* _tmp53_;
							gint _tmp53__length1;
							gint _tmp53__length2;
							gint _tmp54_;
							JsonBuilder* _tmp55_;
							JsonBuilder* _tmp56_;
							SudokuBoard* _tmp57_;
							JsonBuilder* _tmp58_;
							JsonBuilder* _tmp59_;
							gint* _tmp60_;
							gint _tmp60__length1;
							JsonBuilder* _tmp62_;
							JsonBuilder* _tmp63_;
							if (!_tmp29_) {
								gint _tmp30_;
								_tmp30_ = j;
								j = _tmp30_ + 1;
							}
							_tmp29_ = FALSE;
							_tmp31_ = board;
							_tmp32_ = sudoku_board_get_cols (_tmp31_);
							_tmp33_ = _tmp32_;
							if (!(j < _tmp33_)) {
								break;
							}
							_tmp34_ = g_new0 (gint, 0);
							earmarks = _tmp34_;
							earmarks_length1 = 0;
							_earmarks_size_ = earmarks_length1;
							{
								gint k = 0;
								k = 1;
								{
									gboolean _tmp35_ = FALSE;
									_tmp35_ = TRUE;
									while (TRUE) {
										SudokuBoard* _tmp37_;
										gint _tmp38_;
										gint _tmp39_;
										SudokuBoard* _tmp40_;
										if (!_tmp35_) {
											gint _tmp36_;
											_tmp36_ = k;
											k = _tmp36_ + 1;
										}
										_tmp35_ = FALSE;
										_tmp37_ = board;
										_tmp38_ = sudoku_board_get_max_val (_tmp37_);
										_tmp39_ = _tmp38_;
										if (!(k <= _tmp39_)) {
											break;
										}
										_tmp40_ = board;
										if (sudoku_board_is_earmark_enabled (_tmp40_, i, j, k)) {
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, k);
										}
									}
								}
							}
							_tmp42_ = board_cells;
							_tmp42__length1 = board_cells_length1;
							_tmp42__length2 = board_cells_length2;
							_tmp43_ = _tmp42_[(i * _tmp42__length2) + j];
							if (_tmp43_ == 0) {
								gint* _tmp44_;
								gint _tmp44__length1;
								_tmp44_ = earmarks;
								_tmp44__length1 = earmarks_length1;
								_tmp41_ = _tmp44__length1 == 0;
							} else {
								_tmp41_ = FALSE;
							}
							if (_tmp41_) {
								earmarks = (g_free (earmarks), NULL);
								continue;
							}
							_tmp45_ = builder;
							json_builder_begin_object (_tmp45_);
							_tmp46_ = builder;
							json_builder_set_member_name (_tmp46_, "position");
							_tmp47_ = builder;
							json_builder_begin_array (_tmp47_);
							_tmp48_ = builder;
							json_builder_add_int_value (_tmp48_, (gint64) i);
							_tmp49_ = builder;
							json_builder_add_int_value (_tmp49_, (gint64) j);
							_tmp50_ = builder;
							json_builder_end_array (_tmp50_);
							_tmp51_ = builder;
							json_builder_set_member_name (_tmp51_, "value");
							_tmp52_ = builder;
							_tmp53_ = board_cells;
							_tmp53__length1 = board_cells_length1;
							_tmp53__length2 = board_cells_length2;
							_tmp54_ = _tmp53_[(i * _tmp53__length2) + j];
							json_builder_add_int_value (_tmp52_, (gint64) _tmp54_);
							_tmp55_ = builder;
							json_builder_set_member_name (_tmp55_, "fixed");
							_tmp56_ = builder;
							_tmp57_ = board;
							json_builder_add_boolean_value (_tmp56_, sudoku_board_get_is_fixed (_tmp57_, i, j));
							_tmp58_ = builder;
							json_builder_set_member_name (_tmp58_, "earmarks");
							_tmp59_ = builder;
							json_builder_begin_array (_tmp59_);
							_tmp60_ = earmarks;
							_tmp60__length1 = earmarks_length1;
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
								k_collection = _tmp60_;
								k_collection_length1 = _tmp60__length1;
								for (k_it = 0; k_it < k_collection_length1; k_it = k_it + 1) {
									gint k = 0;
									k = k_collection[k_it];
									{
										JsonBuilder* _tmp61_;
										_tmp61_ = builder;
										json_builder_add_int_value (_tmp61_, (gint64) k);
									}
								}
							}
							_tmp62_ = builder;
							json_builder_end_array (_tmp62_);
							_tmp63_ = builder;
							json_builder_end_object (_tmp63_);
							earmarks = (g_free (earmarks), NULL);
						}
					}
				}
			}
		}
	}
	_tmp64_ = builder;
	json_builder_end_array (_tmp64_);
	_tmp65_ = builder;
	json_builder_end_object (_tmp65_);
	_tmp66_ = json_generator_new ();
	generator = _tmp66_;
	json_generator_set_pretty (generator, TRUE);
	_tmp67_ = builder;
	_tmp68_ = json_builder_get_root (_tmp67_);
	root = _tmp68_;
	json_generator_set_root (generator, root);
	_tmp69_ = json_generator_to_data (generator, NULL);
	result = _tmp69_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	board_cells = (g_free (board_cells), NULL);
	_g_object_unref0 (board);
	return result;
}

static SudokuGame*
sudoku_saver_parse_json_to_game (SudokuSaver* self,
                                 const gchar* file_path)
{
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp2_;
	JsonNode* node = NULL;
	JsonParser* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonReader* reader = NULL;
	JsonNode* _tmp6_;
	JsonReader* _tmp7_;
	JsonReader* _tmp8_;
	JsonReader* _tmp9_;
	JsonReader* _tmp53_;
	JsonReader* _tmp54_;
	JsonReader* _tmp55_;
	SudokuBoard* _tmp56_;
	JsonReader* _tmp57_;
	SudokuBoard* _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	JsonReader* _tmp61_;
	JsonReader* _tmp62_;
	JsonReader* _tmp63_;
	SudokuBoard* _tmp64_;
	JsonReader* _tmp65_;
	const gchar* _tmp66_;
	SudokuBoard* _tmp67_;
	DifficultyCategory _tmp68_;
	DifficultyCategory _tmp69_;
	JsonReader* _tmp70_;
	SudokuBoard* _tmp71_;
	SudokuGame* _tmp72_;
	GError* _inner_error0_ = NULL;
	SudokuGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_;
		_tmp1_ = parser;
		json_parser_load_from_file (_tmp1_, file_path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (parser);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp2_ = sudoku_board_new ();
	board = _tmp2_;
	_tmp3_ = parser;
	_tmp4_ = json_parser_get_root (_tmp3_);
	_tmp5_ = __vala_JsonNode_copy0 (_tmp4_);
	node = _tmp5_;
	_tmp6_ = node;
	_tmp7_ = json_reader_new (_tmp6_);
	reader = _tmp7_;
	_tmp8_ = reader;
	json_reader_read_member (_tmp8_, "cells");
	_tmp9_ = reader;
	g_return_val_if_fail (json_reader_is_array (_tmp9_), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				JsonReader* _tmp12_;
				JsonReader* _tmp13_;
				JsonReader* _tmp14_;
				JsonReader* _tmp15_;
				JsonReader* _tmp16_;
				JsonReader* _tmp17_;
				JsonReader* _tmp18_;
				gint row = 0;
				JsonReader* _tmp19_;
				gboolean _tmp20_ = FALSE;
				JsonReader* _tmp21_;
				JsonReader* _tmp22_;
				JsonReader* _tmp23_;
				gint col = 0;
				JsonReader* _tmp24_;
				gboolean _tmp25_ = FALSE;
				JsonReader* _tmp26_;
				JsonReader* _tmp27_;
				JsonReader* _tmp28_;
				JsonReader* _tmp29_;
				gint val = 0;
				JsonReader* _tmp30_;
				gboolean _tmp31_ = FALSE;
				JsonReader* _tmp32_;
				JsonReader* _tmp33_;
				JsonReader* _tmp34_;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp35_;
				JsonReader* _tmp36_;
				JsonReader* _tmp38_;
				JsonReader* _tmp39_;
				JsonReader* _tmp51_;
				JsonReader* _tmp52_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = reader;
				if (!(i < json_reader_count_elements (_tmp12_))) {
					break;
				}
				_tmp13_ = reader;
				json_reader_read_element (_tmp13_, (guint) i);
				_tmp14_ = reader;
				json_reader_read_member (_tmp14_, "position");
				_tmp15_ = reader;
				g_return_val_if_fail (json_reader_is_array (_tmp15_), NULL);
				_tmp16_ = reader;
				g_return_val_if_fail (json_reader_count_elements (_tmp16_) == 2, NULL);
				_tmp17_ = reader;
				json_reader_read_element (_tmp17_, (guint) 0);
				_tmp18_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp18_), NULL);
				_tmp19_ = reader;
				row = (gint) json_reader_get_int_value (_tmp19_);
				if (row >= 0) {
					_tmp20_ = row < 9;
				} else {
					_tmp20_ = FALSE;
				}
				g_return_val_if_fail (_tmp20_, NULL);
				_tmp21_ = reader;
				json_reader_end_element (_tmp21_);
				_tmp22_ = reader;
				json_reader_read_element (_tmp22_, (guint) 1);
				_tmp23_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp23_), NULL);
				_tmp24_ = reader;
				col = (gint) json_reader_get_int_value (_tmp24_);
				if (col >= 0) {
					_tmp25_ = col < 9;
				} else {
					_tmp25_ = FALSE;
				}
				g_return_val_if_fail (_tmp25_, NULL);
				_tmp26_ = reader;
				json_reader_end_element (_tmp26_);
				_tmp27_ = reader;
				json_reader_end_member (_tmp27_);
				_tmp28_ = reader;
				json_reader_read_member (_tmp28_, "value");
				_tmp29_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp29_), NULL);
				_tmp30_ = reader;
				val = (gint) json_reader_get_int_value (_tmp30_);
				if (val >= 0) {
					_tmp31_ = val < 10;
				} else {
					_tmp31_ = FALSE;
				}
				g_return_val_if_fail (_tmp31_, NULL);
				_tmp32_ = reader;
				json_reader_end_member (_tmp32_);
				_tmp33_ = reader;
				json_reader_read_member (_tmp33_, "fixed");
				_tmp34_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp34_), NULL);
				_tmp35_ = reader;
				is_fixed = json_reader_get_boolean_value (_tmp35_);
				_tmp36_ = reader;
				json_reader_end_member (_tmp36_);
				if (val != 0) {
					SudokuBoard* _tmp37_;
					_tmp37_ = board;
					sudoku_board_insert (_tmp37_, row, col, val, is_fixed);
				}
				_tmp38_ = reader;
				json_reader_read_member (_tmp38_, "earmarks");
				_tmp39_ = reader;
				g_return_val_if_fail (json_reader_is_array (_tmp39_), NULL);
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp40_ = FALSE;
						_tmp40_ = TRUE;
						while (TRUE) {
							JsonReader* _tmp42_;
							JsonReader* _tmp43_;
							JsonReader* _tmp44_;
							gint earmark = 0;
							JsonReader* _tmp45_;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuBoard* _tmp49_;
							JsonReader* _tmp50_;
							if (!_tmp40_) {
								gint _tmp41_;
								_tmp41_ = k;
								k = _tmp41_ + 1;
							}
							_tmp40_ = FALSE;
							_tmp42_ = reader;
							if (!(k < json_reader_count_elements (_tmp42_))) {
								break;
							}
							_tmp43_ = reader;
							json_reader_read_element (_tmp43_, (guint) k);
							_tmp44_ = reader;
							g_return_val_if_fail (json_reader_is_value (_tmp44_), NULL);
							_tmp45_ = reader;
							earmark = (gint) json_reader_get_int_value (_tmp45_);
							if (earmark > 0) {
								_tmp47_ = earmark < 10;
							} else {
								_tmp47_ = FALSE;
							}
							if (_tmp47_) {
								SudokuBoard* _tmp48_;
								_tmp48_ = board;
								_tmp46_ = !sudoku_board_is_earmark_enabled (_tmp48_, row, col, earmark);
							} else {
								_tmp46_ = FALSE;
							}
							g_return_val_if_fail (_tmp46_, NULL);
							_tmp49_ = board;
							sudoku_board_enable_earmark (_tmp49_, row, col, earmark);
							_tmp50_ = reader;
							json_reader_end_element (_tmp50_);
						}
					}
				}
				_tmp51_ = reader;
				json_reader_end_member (_tmp51_);
				_tmp52_ = reader;
				json_reader_end_element (_tmp52_);
			}
		}
	}
	_tmp53_ = reader;
	json_reader_end_member (_tmp53_);
	_tmp54_ = reader;
	json_reader_read_member (_tmp54_, "time_elapsed");
	_tmp55_ = reader;
	g_return_val_if_fail (json_reader_is_value (_tmp55_), NULL);
	_tmp56_ = board;
	_tmp57_ = reader;
	sudoku_board_set_previous_played_time (_tmp56_, json_reader_get_double_value (_tmp57_));
	_tmp58_ = board;
	_tmp59_ = sudoku_board_get_previous_played_time (_tmp58_);
	_tmp60_ = _tmp59_;
	g_return_val_if_fail (_tmp60_ >= ((gdouble) 0), NULL);
	_tmp61_ = reader;
	json_reader_end_member (_tmp61_);
	_tmp62_ = reader;
	json_reader_read_member (_tmp62_, "difficulty_category");
	_tmp63_ = reader;
	g_return_val_if_fail (json_reader_is_value (_tmp63_), NULL);
	_tmp64_ = board;
	_tmp65_ = reader;
	_tmp66_ = json_reader_get_string_value (_tmp65_);
	sudoku_board_set_difficulty_category (_tmp64_, difficulty_category_from_string (_tmp66_));
	_tmp67_ = board;
	_tmp68_ = sudoku_board_get_difficulty_category (_tmp67_);
	_tmp69_ = _tmp68_;
	g_return_val_if_fail (_tmp69_ != DIFFICULTY_CATEGORY_UNKNOWN, NULL);
	_tmp70_ = reader;
	json_reader_end_member (_tmp70_);
	_tmp71_ = board;
	_tmp72_ = sudoku_game_new (_tmp71_);
	result = _tmp72_;
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (board);
	_g_object_unref0 (parser);
	return result;
}

const gchar*
sudoku_saver_get_savegame_file (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = sudoku_saver__savegame_file;
	result = _tmp0_;
	return result;
}

static void
sudoku_saver_set_savegame_file (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (sudoku_saver__savegame_file);
	sudoku_saver__savegame_file = _tmp0_;
}

const gchar*
sudoku_saver_get_finishgame_dir (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = sudoku_saver__finishgame_dir;
	result = _tmp0_;
	return result;
}

static void
sudoku_saver_set_finishgame_dir (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (sudoku_saver__finishgame_dir);
	sudoku_saver__finishgame_dir = _tmp0_;
}

const gchar*
sudoku_saver_get_highscores_file (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = sudoku_saver__highscores_file;
	result = _tmp0_;
	return result;
}

static void
sudoku_saver_set_highscores_file (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (sudoku_saver__highscores_file);
	sudoku_saver__highscores_file = _tmp0_;
}

static void
sudoku_saver_class_init (SudokuSaverClass * klass,
                         gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuSaver_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
	_tmp0_ = g_strdup ("");
	sudoku_saver__savegame_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	sudoku_saver__finishgame_dir = _tmp1_;
	_tmp2_ = g_strdup ("");
	sudoku_saver__highscores_file = _tmp2_;
}

static void
sudoku_saver_instance_init (SudokuSaver * self,
                            gpointer klass)
{
	self->priv = sudoku_saver_get_instance_private (self);
}

static void
sudoku_saver_finalize (GObject * obj)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
	_g_object_unref0 (self->priv->highscores);
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
}

static GType
sudoku_saver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
	GType sudoku_saver_type_id;
	sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
	SudokuSaver_private_offset = g_type_add_instance_private (sudoku_saver_type_id, sizeof (SudokuSaverPrivate));
	return sudoku_saver_type_id;
}

GType
sudoku_saver_get_type (void)
{
	static volatile gsize sudoku_saver_type_id__once = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__once)) {
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = sudoku_saver_get_type_once ();
		g_once_init_leave (&sudoku_saver_type_id__once, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__once;
}

static void
_vala_sudoku_saver_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_saver_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

