/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_quadrature_demod_cf = R"doc(quadrature demodulator: complex in, float out

This can be used to demod FM, FSK, GMSK, etc. The input is complex baseband, output is the signal frequency in relation to the sample rate, multiplied with the gain.


Mathematically, this block calculates the product of the one-sample delayed input and the conjugate undelayed signal, and then calculates the argument of the resulting complex number:


.


Let  be a complex sinusoid with amplitude , (absolute) frequency  and phase  sampled at  so, without loss of generality,





then

Constructor Specific Documentation:



Args:
    gain : )doc";


static const char* __doc_gr_analog_quadrature_demod_cf_quadrature_demod_cf_0 =
    R"doc()doc";


static const char* __doc_gr_analog_quadrature_demod_cf_quadrature_demod_cf_1 =
    R"doc()doc";


static const char* __doc_gr_analog_quadrature_demod_cf_make = R"doc(quadrature demodulator: complex in, float out

This can be used to demod FM, FSK, GMSK, etc. The input is complex baseband, output is the signal frequency in relation to the sample rate, multiplied with the gain.


Mathematically, this block calculates the product of the one-sample delayed input and the conjugate undelayed signal, and then calculates the argument of the resulting complex number:


.


Let  be a complex sinusoid with amplitude , (absolute) frequency  and phase  sampled at  so, without loss of generality,





then

Constructor Specific Documentation:



Args:
    gain : )doc";


static const char* __doc_gr_analog_quadrature_demod_cf_set_gain = R"doc()doc";


static const char* __doc_gr_analog_quadrature_demod_cf_gain = R"doc()doc";
