/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_header_format_base = R"doc(Base header formatter class.

Creates a base class that other packet formatters will inherit from. The child classes create and parse protocol-specific headers. To add a new protocol processing class, create a class that inherits from this and overload the necessary functions. The main functions to overload are:







Protected functions of this class that the child class should overload include:



These three function represent the different states of the parsing state machine. Expected behavior is that the protocol has some known word that we are first looking for the identify the start of the frame. The parsing FSM starts in a state to search for the beginning of the header, normally by looking for a known word (i.e., the access code). Then it changes state to read in the full header. We expect that the protocol provides the length of the header for processing, so the parsing looks pulls in the full length of the header. Then it changes state to the \"have header\" state for checking and processing. The base class provides the basic functionality for this state machine. However, most likely, each child class must manage these states for themselves.


This class is specifically designed to work with packets/frames in the asynchronous PDU architecture of GNU Radio. See the packet_format_async block for formatting the headers onto payloads and packet_parse_b block for parsing headers in a receiver.


The Packet Format block takes in a PDU and uses a formatter class derived from this class to add a header onto the packet. The Packet Format blocks takes in the PDU, unpacks the message, and passes it to a formatter class' format function, which builds a header based on the payload. The header is passed back and emitted from formatter block as a separate output. The async format block, packet_format_async, has two message output ports. The 'header' port passes the header out as a PDU and the 'payload' passes the payload out as a PDU. The flowgraph can then separately modulate and combine these two pieces in the follow-on processing.


The packet_sync_b block uses the formatter class by calling the 'parse' function to parse the received packet headers. This parser block is a sink for the data stream and emits a message from an 'info' port that contains an PMT dictionary of the information in the header. The formatter class determines the dictionary keys.


This is the base class for dealing with formatting headers for different protocols and purposes. For other header formatting behaviors, create a child class from here and overload the format, parse, and parsing state machine functions as necessary.)doc";


static const char* __doc_gr_digital_header_format_base_header_format_base_0 = R"doc()doc";


static const char* __doc_gr_digital_header_format_base_header_format_base_1 = R"doc()doc";


static const char* __doc_gr_digital_header_format_base_base = R"doc()doc";


static const char* __doc_gr_digital_header_format_base_formatter = R"doc()doc";


static const char* __doc_gr_digital_header_format_base_format = R"doc(Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



MUST be overloaded.)doc";


static const char* __doc_gr_digital_header_format_base_parse = R"doc(Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



MUST be overloaded.)doc";


static const char* __doc_gr_digital_header_format_base_header_nbits = R"doc(Returns the length of the formatted header in bits. MUST be overloaded.)doc";


static const char* __doc_gr_digital_header_format_base_header_nbytes = R"doc(Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().)doc";
