/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/sys_paths.h>
// pydoc.h is automatically generated in the build directory
#include <sys_paths_pydoc.h>

void bind_sys_paths(py::module& m)
{
    auto paths = m.def_submodule("paths", "GNU Radio default paths");
    /* would have loved to #include <pybind11/stl/filesystem.h> and return the paths
     * directly, but that requires a pybind11 too modern for Ubuntu20.04, so for now, just
     * return the string representation. Let's not return different types depending on the
     * version of a dependency.
     *
     * TODO: revisit 3.11

    paths.def("tmp", &::gr::paths::tmp);
    paths.def("appdata", &::gr::paths::appdata);
    paths.def("userconf", &::gr::paths::userconf);
    paths.def("cache", &::gr::paths::cache);
    */
    paths.def("tmp", []() { return gr::paths::tmp().u8string(); });
    paths.def("appdata", []() { return gr::paths::appdata().u8string(); });
    paths.def("userconf", []() { return gr::paths::userconf().u8string(); });
    paths.def("cache", []() { return gr::paths::cache().u8string(); });
    paths.def("persistent", []() { return gr::paths::persistent().u8string(); });

    // Legacy interfaces, deprecated
    m.def(
        "tmp_path", []() { return ::gr::paths::tmp().string(); }, D(tmp_path));
    m.def(
        "appdata_path",
        []() { return ::gr::paths::appdata().string(); },
        D(appdata_path));
    m.def(
        "userconf_path",
        []() { return ::gr::paths::userconf().string(); },
        D(userconf_path));
}
