/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_repack_bits_bb = R"doc(Repack  bits from the input stream onto  bits of the output stream.

No bits are lost here; any value for k and l (within [1, 8]) is allowed. On every fresh input byte, it starts reading on the LSB, and starts copying to the LSB as well.


When supplying a tag name, this block operates on tagged streams. In this case, it can happen that the input data or the output data becomes unaligned when k * input length is not equal to l * output length. In this case, the  parameter is used to decide which data packet to align.


Usually,  is false for unpacking (k=8, l < 8) and false for reversing that.



ExampleSay you're tx'ing 8-PSK and therefore set k=8, l=3 on the transmit side before the modulator. Now assume you're transmitting a single byte of data. Your incoming tagged stream has length 1, the outgoing has length 3. However, the third item is actually only carrying 2 bits of relevant data, the bits do not align with the boundaries. So you set  = false, because the output can be unaligned.


Now say you're doing the inverse: packing those three items into full bytes. How do you interpret those three bytes? Without this flag, you'd have to assume there's 9 relevant bits in there, so you'd end up with 2 bytes of output data. But in the packing case, you want the  to be aligned; all output bits must be useful. By asserting this flag, the packing algorithm tries to do this and in this case assumes that since we have alignment after 8 bits, the 9th can be discarded.

Constructor Specific Documentation:



Args:
    k : Number of relevant bits on the input stream
    l : Number of relevant bits on the output stream
    tsb_tag_key : If not empty, this is the key for the length tag.
    align_output : If tsb_tag_key is given, this controls if the input or the output is aligned.
    endianness : The endianness of the output data stream (LSB or MSB).)doc";


static const char* __doc_gr_blocks_repack_bits_bb_repack_bits_bb_0 = R"doc()doc";


static const char* __doc_gr_blocks_repack_bits_bb_repack_bits_bb_1 = R"doc()doc";


static const char* __doc_gr_blocks_repack_bits_bb_make = R"doc(Repack  bits from the input stream onto  bits of the output stream.

No bits are lost here; any value for k and l (within [1, 8]) is allowed. On every fresh input byte, it starts reading on the LSB, and starts copying to the LSB as well.


When supplying a tag name, this block operates on tagged streams. In this case, it can happen that the input data or the output data becomes unaligned when k * input length is not equal to l * output length. In this case, the  parameter is used to decide which data packet to align.


Usually,  is false for unpacking (k=8, l < 8) and false for reversing that.



ExampleSay you're tx'ing 8-PSK and therefore set k=8, l=3 on the transmit side before the modulator. Now assume you're transmitting a single byte of data. Your incoming tagged stream has length 1, the outgoing has length 3. However, the third item is actually only carrying 2 bits of relevant data, the bits do not align with the boundaries. So you set  = false, because the output can be unaligned.


Now say you're doing the inverse: packing those three items into full bytes. How do you interpret those three bytes? Without this flag, you'd have to assume there's 9 relevant bits in there, so you'd end up with 2 bytes of output data. But in the packing case, you want the  to be aligned; all output bits must be useful. By asserting this flag, the packing algorithm tries to do this and in this case assumes that since we have alignment after 8 bits, the 9th can be discarded.

Constructor Specific Documentation:



Args:
    k : Number of relevant bits on the input stream
    l : Number of relevant bits on the output stream
    tsb_tag_key : If not empty, this is the key for the length tag.
    align_output : If tsb_tag_key is given, this controls if the input or the output is aligned.
    endianness : The endianness of the output data stream (LSB or MSB).)doc";


static const char* __doc_gr_blocks_repack_bits_bb_set_k_and_l = R"doc()doc";
