package write

import (
	pyrometricsutil "github.com/grafana/alloy/internal/component/pyroscope/util/metrics"
	"github.com/prometheus/client_golang/prometheus"
)

type metrics struct {
	sentBytes       *prometheus.CounterVec
	droppedBytes    *prometheus.CounterVec
	sentProfiles    *prometheus.CounterVec
	droppedProfiles *prometheus.CounterVec
	retries         *prometheus.CounterVec
	latency         *prometheus.HistogramVec
}

func newMetrics(reg prometheus.Registerer) *metrics {
	m := &metrics{
		sentBytes: prometheus.NewCounterVec(prometheus.CounterOpts{
			Name: "pyroscope_write_sent_bytes_total",
			Help: "Total number of compressed bytes sent to Pyroscope.",
		}, []string{"endpoint"}),
		droppedBytes: prometheus.NewCounterVec(prometheus.CounterOpts{
			Name: "pyroscope_write_dropped_bytes_total",
			Help: "Total number of compressed bytes dropped by Pyroscope.",
		}, []string{"endpoint"}),
		sentProfiles: prometheus.NewCounterVec(prometheus.CounterOpts{
			Name: "pyroscope_write_sent_profiles_total",
			Help: "Total number of profiles sent to Pyroscope.",
		}, []string{"endpoint"}),
		droppedProfiles: prometheus.NewCounterVec(prometheus.CounterOpts{
			Name: "pyroscope_write_dropped_profiles_total",
			Help: "Total number of profiles dropped by Pyroscope.",
		}, []string{"endpoint"}),
		retries: prometheus.NewCounterVec(prometheus.CounterOpts{
			Name: "pyroscope_write_retries_total",
			Help: "Total number of retries to Pyroscope.",
		}, []string{"endpoint"}),
		latency: prometheus.NewHistogramVec(prometheus.HistogramOpts{
			Name: "pyroscope_write_latency",
			Help: "Write latency for sending profiles to pyroscope",
		}, []string{"endpoint", "type"}),
	}

	if reg != nil {
		m.sentBytes = pyrometricsutil.MustRegisterOrGet(reg, m.sentBytes).(*prometheus.CounterVec)
		m.droppedBytes = pyrometricsutil.MustRegisterOrGet(reg, m.droppedBytes).(*prometheus.CounterVec)
		m.sentProfiles = pyrometricsutil.MustRegisterOrGet(reg, m.sentProfiles).(*prometheus.CounterVec)
		m.droppedProfiles = pyrometricsutil.MustRegisterOrGet(reg, m.droppedProfiles).(*prometheus.CounterVec)
		m.retries = pyrometricsutil.MustRegisterOrGet(reg, m.retries).(*prometheus.CounterVec)
		m.latency = pyrometricsutil.MustRegisterOrGet(reg, m.latency).(*prometheus.HistogramVec)
	}

	return m
}
