/* application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/

#include "graphs.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include "config.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRAPHS_APPLICATION_0_PROPERTY,
	GRAPHS_APPLICATION_WINDOW_PROPERTY,
	GRAPHS_APPLICATION_SETTINGS_PROPERTY,
	GRAPHS_APPLICATION_DATA_PROPERTY,
	GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY,
	GRAPHS_APPLICATION_DEBUG_PROPERTY,
	GRAPHS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* graphs_application_properties[GRAPHS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRAPHS_APPLICATION_ACTION_INVOKED_SIGNAL,
	GRAPHS_APPLICATION_OPERATION_INVOKED_SIGNAL,
	GRAPHS_APPLICATION_NUM_SIGNALS
};
static guint graphs_application_signals[GRAPHS_APPLICATION_NUM_SIGNALS] = {0};

struct _GraphsApplicationPrivate {
	GraphsWindow* _window;
	GSettings* _settings;
	GraphsData* _data;
	GraphsStyleManager* _figure_style_manager;
	gboolean _debug;
};

static gint GraphsApplication_private_offset;
static gpointer graphs_application_parent_class = NULL;

static GObject * graphs_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void graphs_application_finalize (GObject * obj);
static GType graphs_application_get_type_once (void);
static void _vala_graphs_application_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_graphs_application_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
graphs_application_get_instance_private (GraphsApplication* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsApplication_private_offset);
}

/**
         * Retrieve a child of the applications settings.
         *
         * @param path a slash-separated path
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSettings*
graphs_application_get_settings_child (GraphsApplication* self,
                                       const gchar* path)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (path, "/", 0);
	{
		gchar** child_name_collection = NULL;
		gint child_name_collection_length1 = 0;
		gint _child_name_collection_size_ = 0;
		gint child_name_it = 0;
		child_name_collection = _tmp3_;
		child_name_collection_length1 = _vala_array_length (_tmp2_);
		for (child_name_it = 0; child_name_it < child_name_collection_length1; child_name_it = child_name_it + 1) {
			gchar* _tmp4_;
			gchar* child_name = NULL;
			_tmp4_ = g_strdup (child_name_collection[child_name_it]);
			child_name = _tmp4_;
			{
				GSettings* _tmp5_;
				const gchar* _tmp6_;
				GSettings* _tmp7_;
				_tmp5_ = settings;
				_tmp6_ = child_name;
				_tmp7_ = g_settings_get_child (_tmp5_, _tmp6_);
				_g_object_unref0 (settings);
				settings = _tmp7_;
				_g_free0 (child_name);
			}
		}
		child_name_collection = (_vala_array_free (child_name_collection, child_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = settings;
	return result;
}

GraphsApplication*
graphs_application_construct (GType object_type)
{
	GraphsApplication * self = NULL;
	self = (GraphsApplication*) g_object_new (object_type, NULL);
	return self;
}

GraphsApplication*
graphs_application_new (void)
{
	return graphs_application_construct (GRAPHS_TYPE_APPLICATION);
}

GraphsWindow*
graphs_application_get_window (GraphsApplication* self)
{
	GraphsWindow* result;
	GraphsWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

void
graphs_application_set_window (GraphsApplication* self,
                               GraphsWindow* value)
{
	GraphsWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_application_get_window (self);
	if (old_value != value) {
		GraphsWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_application_properties[GRAPHS_APPLICATION_WINDOW_PROPERTY]);
	}
}

GSettings*
graphs_application_get_settings (GraphsApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
graphs_application_set_settings (GraphsApplication* self,
                                 GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_application_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_application_properties[GRAPHS_APPLICATION_SETTINGS_PROPERTY]);
	}
}

GraphsData*
graphs_application_get_data (GraphsApplication* self)
{
	GraphsData* result;
	GraphsData* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data;
	result = _tmp0_;
	return result;
}

void
graphs_application_set_data (GraphsApplication* self,
                             GraphsData* value)
{
	GraphsData* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_application_get_data (self);
	if (old_value != value) {
		GraphsData* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data);
		self->priv->_data = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_application_properties[GRAPHS_APPLICATION_DATA_PROPERTY]);
	}
}

GraphsStyleManager*
graphs_application_get_figure_style_manager (GraphsApplication* self)
{
	GraphsStyleManager* result;
	GraphsStyleManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_figure_style_manager;
	result = _tmp0_;
	return result;
}

void
graphs_application_set_figure_style_manager (GraphsApplication* self,
                                             GraphsStyleManager* value)
{
	GraphsStyleManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_application_get_figure_style_manager (self);
	if (old_value != value) {
		GraphsStyleManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_figure_style_manager);
		self->priv->_figure_style_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_application_properties[GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY]);
	}
}

gboolean
graphs_application_get_debug (GraphsApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}

void
graphs_application_set_debug (GraphsApplication* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_application_get_debug (self);
	if (old_value != value) {
		self->priv->_debug = value;
		g_object_notify_by_pspec ((GObject *) self, graphs_application_properties[GRAPHS_APPLICATION_DEBUG_PROPERTY]);
	}
}

static GObject *
graphs_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraphsApplication * self;
	parent_class = G_OBJECT_CLASS (graphs_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_APPLICATION, GraphsApplication);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_application_set_version ((GApplication*) self, VERSION);
	return obj;
}

static void
graphs_application_class_init (GraphsApplicationClass * klass,
                               gpointer klass_data)
{
	graphs_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsApplication_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = graphs_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = graphs_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_APPLICATION_WINDOW_PROPERTY, graphs_application_properties[GRAPHS_APPLICATION_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", GRAPHS_TYPE_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_APPLICATION_SETTINGS_PROPERTY, graphs_application_properties[GRAPHS_APPLICATION_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_APPLICATION_DATA_PROPERTY, graphs_application_properties[GRAPHS_APPLICATION_DATA_PROPERTY] = g_param_spec_object ("data", "data", "data", GRAPHS_TYPE_DATA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY, graphs_application_properties[GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY] = g_param_spec_object ("figure-style-manager", "figure-style-manager", "figure-style-manager", GRAPHS_TYPE_STYLE_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_APPLICATION_DEBUG_PROPERTY, graphs_application_properties[GRAPHS_APPLICATION_DEBUG_PROPERTY] = g_param_spec_boolean ("debug", "debug", "debug", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	graphs_application_signals[GRAPHS_APPLICATION_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", GRAPHS_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	graphs_application_signals[GRAPHS_APPLICATION_OPERATION_INVOKED_SIGNAL] = g_signal_new ("operation-invoked", GRAPHS_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
graphs_application_instance_init (GraphsApplication * self,
                                  gpointer klass)
{
	self->priv = graphs_application_get_instance_private (self);
	self->priv->_debug = FALSE;
}

static void
graphs_application_finalize (GObject * obj)
{
	GraphsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_APPLICATION, GraphsApplication);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_data);
	_g_object_unref0 (self->priv->_figure_style_manager);
	G_OBJECT_CLASS (graphs_application_parent_class)->finalize (obj);
}

/**
     * Graphs application
     */
static GType
graphs_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsApplication), 0, (GInstanceInitFunc) graphs_application_instance_init, NULL };
	GType graphs_application_type_id;
	graphs_application_type_id = g_type_register_static (adw_application_get_type (), "GraphsApplication", &g_define_type_info, 0);
	GraphsApplication_private_offset = g_type_add_instance_private (graphs_application_type_id, sizeof (GraphsApplicationPrivate));
	return graphs_application_type_id;
}

GType
graphs_application_get_type (void)
{
	static volatile gsize graphs_application_type_id__once = 0;
	if (g_once_init_enter (&graphs_application_type_id__once)) {
		GType graphs_application_type_id;
		graphs_application_type_id = graphs_application_get_type_once ();
		g_once_init_leave (&graphs_application_type_id__once, graphs_application_type_id);
	}
	return graphs_application_type_id__once;
}

static void
_vala_graphs_application_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GraphsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_APPLICATION, GraphsApplication);
	switch (property_id) {
		case GRAPHS_APPLICATION_WINDOW_PROPERTY:
		g_value_set_object (value, graphs_application_get_window (self));
		break;
		case GRAPHS_APPLICATION_SETTINGS_PROPERTY:
		g_value_set_object (value, graphs_application_get_settings (self));
		break;
		case GRAPHS_APPLICATION_DATA_PROPERTY:
		g_value_set_object (value, graphs_application_get_data (self));
		break;
		case GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY:
		g_value_set_object (value, graphs_application_get_figure_style_manager (self));
		break;
		case GRAPHS_APPLICATION_DEBUG_PROPERTY:
		g_value_set_boolean (value, graphs_application_get_debug (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_application_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GraphsApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_APPLICATION, GraphsApplication);
	switch (property_id) {
		case GRAPHS_APPLICATION_WINDOW_PROPERTY:
		graphs_application_set_window (self, g_value_get_object (value));
		break;
		case GRAPHS_APPLICATION_SETTINGS_PROPERTY:
		graphs_application_set_settings (self, g_value_get_object (value));
		break;
		case GRAPHS_APPLICATION_DATA_PROPERTY:
		graphs_application_set_data (self, g_value_get_object (value));
		break;
		case GRAPHS_APPLICATION_FIGURE_STYLE_MANAGER_PROPERTY:
		graphs_application_set_figure_style_manager (self, g_value_get_object (value));
		break;
		case GRAPHS_APPLICATION_DEBUG_PROPERTY:
		graphs_application_set_debug (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

