#ifndef CRYPTOHASH_BLAKE2B_H
#define CRYPTOHASH_BLAKE2B_H

#include "blake2.h"

typedef blake2b_state blake2b_ctx;

void crypton_blake2b_init(blake2b_ctx *ctx, uint32_t hashlen);
void crypton_blake2b_init_key(blake2b_ctx *ctx, uint32_t hashlen, const uint8_t *key, size_t keylen);
void crypton_blake2b_update(blake2b_ctx *ctx, const uint8_t *data, uint32_t len);
void crypton_blake2b_finalize(blake2b_ctx *ctx, uint32_t hashlen, uint8_t *out);

#endif
