{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey' is an opaque data structure and can only be accessed
-- using the following functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.SettingsSchemaKey
    ( 

-- * Exported types
    SettingsSchemaKey(..)                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [rangeCheck]("GI.Gio.Structs.SettingsSchemaKey#g:method:rangeCheck"), [ref]("GI.Gio.Structs.SettingsSchemaKey#g:method:ref"), [unref]("GI.Gio.Structs.SettingsSchemaKey#g:method:unref").
-- 
-- ==== Getters
-- [getDefaultValue]("GI.Gio.Structs.SettingsSchemaKey#g:method:getDefaultValue"), [getDescription]("GI.Gio.Structs.SettingsSchemaKey#g:method:getDescription"), [getName]("GI.Gio.Structs.SettingsSchemaKey#g:method:getName"), [getRange]("GI.Gio.Structs.SettingsSchemaKey#g:method:getRange"), [getSummary]("GI.Gio.Structs.SettingsSchemaKey#g:method:getSummary"), [getValueType]("GI.Gio.Structs.SettingsSchemaKey#g:method:getValueType").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSettingsSchemaKeyMethod          ,
#endif

-- ** getDefaultValue #method:getDefaultValue#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetDefaultValueMethodInfo,
#endif
    settingsSchemaKeyGetDefaultValue        ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetDescriptionMethodInfo,
#endif
    settingsSchemaKeyGetDescription         ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetNameMethodInfo      ,
#endif
    settingsSchemaKeyGetName                ,


-- ** getRange #method:getRange#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetRangeMethodInfo     ,
#endif
    settingsSchemaKeyGetRange               ,


-- ** getSummary #method:getSummary#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetSummaryMethodInfo   ,
#endif
    settingsSchemaKeyGetSummary             ,


-- ** getValueType #method:getValueType#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyGetValueTypeMethodInfo ,
#endif
    settingsSchemaKeyGetValueType           ,


-- ** rangeCheck #method:rangeCheck#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyRangeCheckMethodInfo   ,
#endif
    settingsSchemaKeyRangeCheck             ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyRefMethodInfo          ,
#endif
    settingsSchemaKeyRef                    ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    SettingsSchemaKeyUnrefMethodInfo        ,
#endif
    settingsSchemaKeyUnref                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType

#else
import qualified GI.GLib.Structs.VariantType as GLib.VariantType

#endif

-- | Memory-managed wrapper type.
newtype SettingsSchemaKey = SettingsSchemaKey (SP.ManagedPtr SettingsSchemaKey)
    deriving (Eq)

instance SP.ManagedPtrNewtype SettingsSchemaKey where
    toManagedPtr (SettingsSchemaKey p) = p

foreign import ccall "g_settings_schema_key_get_type" c_g_settings_schema_key_get_type :: 
    IO GType

type instance O.ParentTypes SettingsSchemaKey = '[]
instance O.HasParentTypes SettingsSchemaKey

instance B.Types.TypedObject SettingsSchemaKey where
    glibType = c_g_settings_schema_key_get_type

instance B.Types.GBoxed SettingsSchemaKey

-- | Convert t'SettingsSchemaKey' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SettingsSchemaKey) where
    gvalueGType_ = c_g_settings_schema_key_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr SettingsSchemaKey)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr SettingsSchemaKey)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed SettingsSchemaKey ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SettingsSchemaKey
type instance O.AttributeList SettingsSchemaKey = SettingsSchemaKeyAttributeList
type SettingsSchemaKeyAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method SettingsSchemaKey::get_default_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_default_value" g_settings_schema_key_get_default_value :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO (Ptr GVariant)

-- | Gets the default value for /@key@/.
-- 
-- Note that this is the default value according to the schema.  System
-- administrator defaults and lockdown are not visible via this API.
-- 
-- /Since: 2.40/
settingsSchemaKeyGetDefaultValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m GVariant
    -- ^ __Returns:__ the default value for the key
settingsSchemaKeyGetDefaultValue key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_default_value key'
    checkUnexpectedReturnNULL "settingsSchemaKeyGetDefaultValue" result
    result' <- B.GVariant.wrapGVariantPtr result
    touchManagedPtr key
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetDefaultValueMethodInfo
instance (signature ~ (m GVariant), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetDefaultValueMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetDefaultValue

instance O.OverloadedMethodInfo SettingsSchemaKeyGetDefaultValueMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetDefaultValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetDefaultValue"
        })


#endif

-- method SettingsSchemaKey::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_description" g_settings_schema_key_get_description :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO CString

-- | Gets the description for /@key@/.
-- 
-- If no description has been provided in the schema for /@key@/, returns
-- 'P.Nothing'.
-- 
-- The description can be one sentence to several paragraphs in length.
-- Paragraphs are delimited with a double newline.  Descriptions can be
-- translated and the value returned from this function is is the
-- current locale.
-- 
-- This function is slow.  The summary and description information for
-- the schemas is not stored in the compiled schema database so this
-- function has to parse all of the source XML files in the schema
-- directory.
-- 
-- /Since: 2.34/
settingsSchemaKeyGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the description for /@key@/, or 'P.Nothing'
settingsSchemaKeyGetDescription key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_description key'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr key
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetDescriptionMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetDescriptionMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetDescription

instance O.OverloadedMethodInfo SettingsSchemaKeyGetDescriptionMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetDescription"
        })


#endif

-- method SettingsSchemaKey::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_name" g_settings_schema_key_get_name :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO CString

-- | Gets the name of /@key@/.
-- 
-- /Since: 2.44/
settingsSchemaKeyGetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m T.Text
    -- ^ __Returns:__ the name of /@key@/.
settingsSchemaKeyGetName key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_name key'
    checkUnexpectedReturnNULL "settingsSchemaKeyGetName" result
    result' <- cstringToText result
    touchManagedPtr key
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetNameMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetName

instance O.OverloadedMethodInfo SettingsSchemaKeyGetNameMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetName"
        })


#endif

-- method SettingsSchemaKey::get_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_range" g_settings_schema_key_get_range :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO (Ptr GVariant)

-- | Queries the range of a key.
-- 
-- This function will return a t'GVariant' that fully describes the range
-- of values that are valid for /@key@/.
-- 
-- The type of t'GVariant' returned is @(sv)@. The string describes
-- the type of range restriction in effect. The type and meaning of
-- the value contained in the variant depends on the string.
-- 
-- If the string is @\'type\'@ then the variant contains an empty array.
-- The element type of that empty array is the expected type of value
-- and all values of that type are valid.
-- 
-- If the string is @\'enum\'@ then the variant contains an array
-- enumerating the possible values. Each item in the array is
-- a possible valid value and no other values are valid.
-- 
-- If the string is @\'flags\'@ then the variant contains an array. Each
-- item in the array is a value that may appear zero or one times in an
-- array to be used as the value for this key. For example, if the
-- variant contained the array @[\'x\', \'y\']@ then the valid values for
-- the key would be @[]@, @[\'x\']@, @[\'y\']@, @[\'x\', \'y\']@ and
-- @[\'y\', \'x\']@.
-- 
-- Finally, if the string is @\'range\'@ then the variant contains a pair
-- of like-typed values -- the minimum and maximum permissible values
-- for this key.
-- 
-- This information should not be used by normal programs.  It is
-- considered to be a hint for introspection purposes.  Normal programs
-- should already know what is permitted by their own schema.  The
-- format may change in any way in the future -- but particularly, new
-- forms may be added to the possibilities described above.
-- 
-- You should free the returned value with 'GI.GLib.Structs.Variant.variantUnref' when it is
-- no longer needed.
-- 
-- /Since: 2.40/
settingsSchemaKeyGetRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m GVariant
    -- ^ __Returns:__ a t'GVariant' describing the range
settingsSchemaKeyGetRange key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_range key'
    checkUnexpectedReturnNULL "settingsSchemaKeyGetRange" result
    result' <- B.GVariant.wrapGVariantPtr result
    touchManagedPtr key
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetRangeMethodInfo
instance (signature ~ (m GVariant), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetRangeMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetRange

instance O.OverloadedMethodInfo SettingsSchemaKeyGetRangeMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetRange"
        })


#endif

-- method SettingsSchemaKey::get_summary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_summary" g_settings_schema_key_get_summary :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO CString

-- | Gets the summary for /@key@/.
-- 
-- If no summary has been provided in the schema for /@key@/, returns
-- 'P.Nothing'.
-- 
-- The summary is a short description of the purpose of the key; usually
-- one short sentence.  Summaries can be translated and the value
-- returned from this function is is the current locale.
-- 
-- This function is slow.  The summary and description information for
-- the schemas is not stored in the compiled schema database so this
-- function has to parse all of the source XML files in the schema
-- directory.
-- 
-- /Since: 2.34/
settingsSchemaKeyGetSummary ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the summary for /@key@/, or 'P.Nothing'
settingsSchemaKeyGetSummary key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_summary key'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr key
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetSummaryMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetSummaryMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetSummary

instance O.OverloadedMethodInfo SettingsSchemaKeyGetSummaryMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetSummary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetSummary"
        })


#endif

-- method SettingsSchemaKey::get_value_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "VariantType" })
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_get_value_type" g_settings_schema_key_get_value_type :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO (Ptr GLib.VariantType.VariantType)

-- | Gets the t'GI.GLib.Structs.VariantType.VariantType' of /@key@/.
-- 
-- /Since: 2.40/
settingsSchemaKeyGetValueType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m GLib.VariantType.VariantType
    -- ^ __Returns:__ the type of /@key@/
settingsSchemaKeyGetValueType key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_get_value_type key'
    checkUnexpectedReturnNULL "settingsSchemaKeyGetValueType" result
    result' <- (newBoxed GLib.VariantType.VariantType) result
    touchManagedPtr key
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyGetValueTypeMethodInfo
instance (signature ~ (m GLib.VariantType.VariantType), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyGetValueTypeMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyGetValueType

instance O.OverloadedMethodInfo SettingsSchemaKeyGetValueTypeMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyGetValueType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyGetValueType"
        })


#endif

-- method SettingsSchemaKey::range_check
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to check" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_range_check" g_settings_schema_key_range_check :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    Ptr GVariant ->                         -- value : TVariant
    IO CInt

-- | Checks if the given /@value@/ is within the
-- permitted range for /@key@/.
-- 
-- It is a programmer error if /@value@/ is not of the correct type — you
-- must check for this first.
-- 
-- /Since: 2.40/
settingsSchemaKeyRangeCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> GVariant
    -- ^ /@value@/: the value to check
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@value@/ is valid for /@key@/
settingsSchemaKeyRangeCheck key value = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    value' <- unsafeManagedPtrGetPtr value
    result <- g_settings_schema_key_range_check key' value'
    let result' = (/= 0) result
    touchManagedPtr key
    touchManagedPtr value
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyRangeCheckMethodInfo
instance (signature ~ (GVariant -> m Bool), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyRangeCheckMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyRangeCheck

instance O.OverloadedMethodInfo SettingsSchemaKeyRangeCheckMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyRangeCheck",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyRangeCheck"
        })


#endif

-- method SettingsSchemaKey::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SettingsSchemaKey" })
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_ref" g_settings_schema_key_ref :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO (Ptr SettingsSchemaKey)

-- | Increase the reference count of /@key@/, returning a new reference.
-- 
-- /Since: 2.40/
settingsSchemaKeyRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m SettingsSchemaKey
    -- ^ __Returns:__ a new reference to /@key@/
settingsSchemaKeyRef key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    result <- g_settings_schema_key_ref key'
    checkUnexpectedReturnNULL "settingsSchemaKeyRef" result
    result' <- (wrapBoxed SettingsSchemaKey) result
    touchManagedPtr key
    return result'

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyRefMethodInfo
instance (signature ~ (m SettingsSchemaKey), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyRefMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyRef

instance O.OverloadedMethodInfo SettingsSchemaKeyRefMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyRef"
        })


#endif

-- method SettingsSchemaKey::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsSchemaKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsSchemaKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_schema_key_unref" g_settings_schema_key_unref :: 
    Ptr SettingsSchemaKey ->                -- key : TInterface (Name {namespace = "Gio", name = "SettingsSchemaKey"})
    IO ()

-- | Decrease the reference count of /@key@/, possibly freeing it.
-- 
-- /Since: 2.40/
settingsSchemaKeyUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SettingsSchemaKey
    -- ^ /@key@/: a t'GI.Gio.Structs.SettingsSchemaKey.SettingsSchemaKey'
    -> m ()
settingsSchemaKeyUnref key = liftIO $ do
    key' <- unsafeManagedPtrGetPtr key
    g_settings_schema_key_unref key'
    touchManagedPtr key
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsSchemaKeyUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SettingsSchemaKeyUnrefMethodInfo SettingsSchemaKey signature where
    overloadedMethod = settingsSchemaKeyUnref

instance O.OverloadedMethodInfo SettingsSchemaKeyUnrefMethodInfo SettingsSchemaKey where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SettingsSchemaKey.settingsSchemaKeyUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-SettingsSchemaKey.html#v:settingsSchemaKeyUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSettingsSchemaKeyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSettingsSchemaKeyMethod "rangeCheck" o = SettingsSchemaKeyRangeCheckMethodInfo
    ResolveSettingsSchemaKeyMethod "ref" o = SettingsSchemaKeyRefMethodInfo
    ResolveSettingsSchemaKeyMethod "unref" o = SettingsSchemaKeyUnrefMethodInfo
    ResolveSettingsSchemaKeyMethod "getDefaultValue" o = SettingsSchemaKeyGetDefaultValueMethodInfo
    ResolveSettingsSchemaKeyMethod "getDescription" o = SettingsSchemaKeyGetDescriptionMethodInfo
    ResolveSettingsSchemaKeyMethod "getName" o = SettingsSchemaKeyGetNameMethodInfo
    ResolveSettingsSchemaKeyMethod "getRange" o = SettingsSchemaKeyGetRangeMethodInfo
    ResolveSettingsSchemaKeyMethod "getSummary" o = SettingsSchemaKeyGetSummaryMethodInfo
    ResolveSettingsSchemaKeyMethod "getValueType" o = SettingsSchemaKeyGetValueTypeMethodInfo
    ResolveSettingsSchemaKeyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSettingsSchemaKeyMethod t SettingsSchemaKey, O.OverloadedMethod info SettingsSchemaKey p) => OL.IsLabel t (SettingsSchemaKey -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSettingsSchemaKeyMethod t SettingsSchemaKey, O.OverloadedMethod info SettingsSchemaKey p, R.HasField t SettingsSchemaKey p) => R.HasField t SettingsSchemaKey p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSettingsSchemaKeyMethod t SettingsSchemaKey, O.OverloadedMethodInfo info SettingsSchemaKey) => OL.IsLabel t (O.MethodProxy info SettingsSchemaKey) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


