{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.GObject.Structs.CClosure.CClosure' is a specialization of t'GI.GObject.Structs.Closure.Closure' for C function callbacks.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.CClosure
    ( 

-- * Exported types
    CClosure(..)                            ,
    newZeroCClosure                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveCClosureMethod                   ,
#endif

-- ** marshalBOOLEAN_BOXEDBOXED #method:marshalBOOLEAN_BOXEDBOXED#

    cClosureMarshalBOOLEAN_BOXEDBOXED       ,


-- ** marshalBOOLEAN_FLAGS #method:marshalBOOLEAN_FLAGS#

    cClosureMarshalBOOLEAN_FLAGS            ,


-- ** marshalGeneric #method:marshalGeneric#

    cClosureMarshalGeneric                  ,


-- ** marshalSTRING_OBJECTPOINTER #method:marshalSTRING_OBJECTPOINTER#

    cClosureMarshalSTRING_OBJECTPOINTER     ,


-- ** marshalVOID_BOOLEAN #method:marshalVOID_BOOLEAN#

    cClosureMarshalVOID_BOOLEAN             ,


-- ** marshalVOID_BOXED #method:marshalVOID_BOXED#

    cClosureMarshalVOID_BOXED               ,


-- ** marshalVOID_CHAR #method:marshalVOID_CHAR#

    cClosureMarshalVOID_CHAR                ,


-- ** marshalVOID_DOUBLE #method:marshalVOID_DOUBLE#

    cClosureMarshalVOID_DOUBLE              ,


-- ** marshalVOID_ENUM #method:marshalVOID_ENUM#

    cClosureMarshalVOID_ENUM                ,


-- ** marshalVOID_FLAGS #method:marshalVOID_FLAGS#

    cClosureMarshalVOID_FLAGS               ,


-- ** marshalVOID_FLOAT #method:marshalVOID_FLOAT#

    cClosureMarshalVOID_FLOAT               ,


-- ** marshalVOID_INT #method:marshalVOID_INT#

    cClosureMarshalVOID_INT                 ,


-- ** marshalVOID_LONG #method:marshalVOID_LONG#

    cClosureMarshalVOID_LONG                ,


-- ** marshalVOID_OBJECT #method:marshalVOID_OBJECT#

    cClosureMarshalVOID_OBJECT              ,


-- ** marshalVOID_PARAM #method:marshalVOID_PARAM#

    cClosureMarshalVOID_PARAM               ,


-- ** marshalVOID_POINTER #method:marshalVOID_POINTER#

    cClosureMarshalVOID_POINTER             ,


-- ** marshalVOID_STRING #method:marshalVOID_STRING#

    cClosureMarshalVOID_STRING              ,


-- ** marshalVOID_UCHAR #method:marshalVOID_UCHAR#

    cClosureMarshalVOID_UCHAR               ,


-- ** marshalVOID_UINT #method:marshalVOID_UINT#

    cClosureMarshalVOID_UINT                ,


-- ** marshalVOID_UINTPOINTER #method:marshalVOID_UINTPOINTER#

    cClosureMarshalVOID_UINTPOINTER         ,


-- ** marshalVOID_ULONG #method:marshalVOID_ULONG#

    cClosureMarshalVOID_ULONG               ,


-- ** marshalVOID_VARIANT #method:marshalVOID_VARIANT#

    cClosureMarshalVOID_VARIANT             ,


-- ** marshalVOID_VOID #method:marshalVOID_VOID#

    cClosureMarshalVOID_VOID                ,




 -- * Properties


-- ** callback #attr:callback#
-- | the callback function

#if defined(ENABLE_OVERLOADING)
    cClosure_callback                       ,
#endif
    clearCClosureCallback                   ,
    getCClosureCallback                     ,
    setCClosureCallback                     ,


-- ** closure #attr:closure#
-- | the t'GI.GObject.Structs.Closure.Closure'

#if defined(ENABLE_OVERLOADING)
    cClosure_closure                        ,
#endif
    clearCClosureClosure                    ,
    getCClosureClosure                      ,
    setCClosureClosure                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype CClosure = CClosure (SP.ManagedPtr CClosure)
    deriving (Eq)

instance SP.ManagedPtrNewtype CClosure where
    toManagedPtr (CClosure p) = p

instance BoxedPtr CClosure where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 72 >=> B.ManagedPtr.wrapPtr CClosure)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr CClosure where
    boxedPtrCalloc = callocBytes 72


-- | Construct a t'CClosure' struct initialized to zero.
newZeroCClosure :: MonadIO m => m CClosure
newZeroCClosure = liftIO $ boxedPtrCalloc >>= wrapPtr CClosure

instance tag ~ 'AttrSet => Constructible CClosure tag where
    new _ attrs = do
        o <- newZeroCClosure
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@closure@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cClosure #closure
-- @
getCClosureClosure :: MonadIO m => CClosure -> m (Maybe (GClosure ()))
getCClosureClosure s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr (GClosure ()))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (B.GClosure.newGClosureFromPtr . FP.castPtr) val'
        return val''
    return result

-- | Set the value of the “@closure@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cClosure [ #closure 'Data.GI.Base.Attributes.:=' value ]
-- @
setCClosureClosure :: MonadIO m => CClosure -> Ptr (GClosure ()) -> m ()
setCClosureClosure s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr (GClosure ()))

-- | Set the value of the “@closure@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #closure
-- @
clearCClosureClosure :: MonadIO m => CClosure -> m ()
clearCClosureClosure s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr (GClosure ()))

#if defined(ENABLE_OVERLOADING)
data CClosureClosureFieldInfo
instance AttrInfo CClosureClosureFieldInfo where
    type AttrBaseTypeConstraint CClosureClosureFieldInfo = (~) CClosure
    type AttrAllowedOps CClosureClosureFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CClosureClosureFieldInfo = (~) (Ptr (GClosure ()))
    type AttrTransferTypeConstraint CClosureClosureFieldInfo = (~)(Ptr (GClosure ()))
    type AttrTransferType CClosureClosureFieldInfo = (Ptr (GClosure ()))
    type AttrGetType CClosureClosureFieldInfo = Maybe (GClosure ())
    type AttrLabel CClosureClosureFieldInfo = "closure"
    type AttrOrigin CClosureClosureFieldInfo = CClosure
    attrGet = getCClosureClosure
    attrSet = setCClosureClosure
    attrConstruct = undefined
    attrClear = clearCClosureClosure
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.CClosure.closure"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-CClosure.html#g:attr:closure"
        })

cClosure_closure :: AttrLabelProxy "closure"
cClosure_closure = AttrLabelProxy

#endif


-- | Get the value of the “@callback@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cClosure #callback
-- @
getCClosureCallback :: MonadIO m => CClosure -> m (Ptr ())
getCClosureCallback s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO (Ptr ())
    return val

-- | Set the value of the “@callback@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cClosure [ #callback 'Data.GI.Base.Attributes.:=' value ]
-- @
setCClosureCallback :: MonadIO m => CClosure -> Ptr () -> m ()
setCClosureCallback s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: Ptr ())

-- | Set the value of the “@callback@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #callback
-- @
clearCClosureCallback :: MonadIO m => CClosure -> m ()
clearCClosureCallback s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data CClosureCallbackFieldInfo
instance AttrInfo CClosureCallbackFieldInfo where
    type AttrBaseTypeConstraint CClosureCallbackFieldInfo = (~) CClosure
    type AttrAllowedOps CClosureCallbackFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CClosureCallbackFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint CClosureCallbackFieldInfo = (~)(Ptr ())
    type AttrTransferType CClosureCallbackFieldInfo = (Ptr ())
    type AttrGetType CClosureCallbackFieldInfo = Ptr ()
    type AttrLabel CClosureCallbackFieldInfo = "callback"
    type AttrOrigin CClosureCallbackFieldInfo = CClosure
    attrGet = getCClosureCallback
    attrSet = setCClosureCallback
    attrConstruct = undefined
    attrClear = clearCClosureCallback
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.CClosure.callback"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-CClosure.html#g:attr:callback"
        })

cClosure_callback :: AttrLabelProxy "callback"
cClosure_callback = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CClosure
type instance O.AttributeList CClosure = CClosureAttributeList
type CClosureAttributeList = ('[ '("closure", CClosureClosureFieldInfo), '("callback", CClosureCallbackFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method CClosure::marshal_BOOLEAN__BOXED_BOXED
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_BOOLEAN__BOXED_BOXED" g_cclosure_marshal_BOOLEAN__BOXED_BOXED :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with handlers that
-- take two boxed pointers as arguments and return a boolean.  If you
-- have such a signal, you will probably also need to use an
-- accumulator, such as 'GI.GObject.Functions.signalAccumulatorTrueHandled'.
cClosureMarshalBOOLEAN_BOXEDBOXED ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalBOOLEAN_BOXEDBOXED closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_BOOLEAN__BOXED_BOXED closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_BOOLEAN__FLAGS
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_BOOLEAN__FLAGS" g_cclosure_marshal_BOOLEAN__FLAGS :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with handlers that
-- take a flags type as an argument and return a boolean.  If you have
-- such a signal, you will probably also need to use an accumulator,
-- such as 'GI.GObject.Functions.signalAccumulatorTrueHandled'.
cClosureMarshalBOOLEAN_FLAGS ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalBOOLEAN_FLAGS closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_BOOLEAN__FLAGS closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_STRING__OBJECT_POINTER
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_STRING__OBJECT_POINTER" g_cclosure_marshal_STRING__OBJECT_POINTER :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with handlers that
-- take a t'GI.GObject.Objects.Object.Object' and a pointer and produce a string.  It is highly
-- unlikely that your signal handler fits this description.
cClosureMarshalSTRING_OBJECTPOINTER ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalSTRING_OBJECTPOINTER closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_STRING__OBJECT_POINTER closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__BOOLEAN
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__BOOLEAN" g_cclosure_marshal_VOID__BOOLEAN :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- boolean argument.
cClosureMarshalVOID_BOOLEAN ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_BOOLEAN closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__BOOLEAN closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__BOXED
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__BOXED" g_cclosure_marshal_VOID__BOXED :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- argument which is any boxed pointer type.
cClosureMarshalVOID_BOXED ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_BOXED closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__BOXED closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__CHAR
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__CHAR" g_cclosure_marshal_VOID__CHAR :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- character argument.
cClosureMarshalVOID_CHAR ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_CHAR closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__CHAR closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__DOUBLE
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__DOUBLE" g_cclosure_marshal_VOID__DOUBLE :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with one
-- double-precision floating point argument.
cClosureMarshalVOID_DOUBLE ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_DOUBLE closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__DOUBLE closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__ENUM
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__ENUM" g_cclosure_marshal_VOID__ENUM :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- argument with an enumerated type.
cClosureMarshalVOID_ENUM ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_ENUM closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__ENUM closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__FLAGS
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__FLAGS" g_cclosure_marshal_VOID__FLAGS :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- argument with a flags types.
cClosureMarshalVOID_FLAGS ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_FLAGS closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__FLAGS closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__FLOAT
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__FLOAT" g_cclosure_marshal_VOID__FLOAT :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with one
-- single-precision floating point argument.
cClosureMarshalVOID_FLOAT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_FLOAT closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__FLOAT closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__INT
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__INT" g_cclosure_marshal_VOID__INT :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- integer argument.
cClosureMarshalVOID_INT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_INT closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__INT closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__LONG
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__LONG" g_cclosure_marshal_VOID__LONG :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with with a single
-- long integer argument.
cClosureMarshalVOID_LONG ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_LONG closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__LONG closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__OBJECT
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__OBJECT" g_cclosure_marshal_VOID__OBJECT :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- t'GI.GObject.Objects.Object.Object' argument.
cClosureMarshalVOID_OBJECT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_OBJECT closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__OBJECT closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__PARAM
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__PARAM" g_cclosure_marshal_VOID__PARAM :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- argument of type t'GI.GObject.Objects.ParamSpec.ParamSpec'.
cClosureMarshalVOID_PARAM ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_PARAM closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__PARAM closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__POINTER
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__POINTER" g_cclosure_marshal_VOID__POINTER :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single raw
-- pointer argument type.
-- 
-- If it is possible, it is better to use one of the more specific
-- functions such as 'GI.GObject.Functions.cclosureMarshalVOID_OBJECT' or
-- 'GI.GObject.Functions.cclosureMarshalVOID_OBJECT'.
cClosureMarshalVOID_POINTER ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_POINTER closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__POINTER closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__STRING
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__STRING" g_cclosure_marshal_VOID__STRING :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single string
-- argument.
cClosureMarshalVOID_STRING ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_STRING closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__STRING closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__UCHAR
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__UCHAR" g_cclosure_marshal_VOID__UCHAR :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- unsigned character argument.
cClosureMarshalVOID_UCHAR ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_UCHAR closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__UCHAR closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__UINT
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__UINT" g_cclosure_marshal_VOID__UINT :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with with a single
-- unsigned integer argument.
cClosureMarshalVOID_UINT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_UINT closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__UINT closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__UINT_POINTER
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__UINT_POINTER" g_cclosure_marshal_VOID__UINT_POINTER :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with an unsigned int
-- and a pointer as arguments.
cClosureMarshalVOID_UINTPOINTER ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_UINTPOINTER closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__UINT_POINTER closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__ULONG
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__ULONG" g_cclosure_marshal_VOID__ULONG :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- unsigned long integer argument.
cClosureMarshalVOID_ULONG ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_ULONG closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__ULONG closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__VARIANT
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__VARIANT" g_cclosure_marshal_VOID__VARIANT :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with a single
-- t'GVariant' argument.
cClosureMarshalVOID_VARIANT ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_VARIANT closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__VARIANT closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_VOID__VOID
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_VOID__VOID" g_cclosure_marshal_VOID__VOID :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_value : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A t'GI.GObject.Callbacks.ClosureMarshal' function for use with signals with no arguments.
cClosureMarshalVOID_VOID ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnValue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalVOID_VOID closure returnValue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_VOID__VOID closure' returnValue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnValue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method CClosure::marshal_generic
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GClosure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_gvalue"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GValue to store the return value. May be %NULL\n  if the callback of closure doesn't return a value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_param_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The length of the @param_values array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_values"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GValues holding the arguments\n  on which to invoke the callback of closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation_hint"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The invocation hint given as the last argument to\n  g_closure_invoke()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Additional data specified when registering the\n  marshaller, see g_closure_set_marshal() and\n  g_closure_set_meta_marshal()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_cclosure_marshal_generic" g_cclosure_marshal_generic :: 
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr GValue ->                           -- return_gvalue : TGValue
    Word32 ->                               -- n_param_values : TBasicType TUInt
    Ptr GValue ->                           -- param_values : TGValue
    Ptr () ->                               -- invocation_hint : TBasicType TPtr
    Ptr () ->                               -- marshal_data : TBasicType TPtr
    IO ()

-- | A generic marshaller function implemented via
-- <http://sourceware.org/libffi/ libffi>.
-- 
-- Normally this function is not passed explicitly to @/g_signal_new()/@,
-- but used automatically by GLib when specifying a 'P.Nothing' marshaller.
-- 
-- /Since: 2.30/
cClosureMarshalGeneric ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GClosure a
    -- ^ /@closure@/: A t'GI.GObject.Structs.Closure.Closure'.
    -> GValue
    -- ^ /@returnGvalue@/: A t'GI.GObject.Structs.Value.Value' to store the return value. May be 'P.Nothing'
    --   if the callback of closure doesn\'t return a value.
    -> Word32
    -- ^ /@nParamValues@/: The length of the /@paramValues@/ array.
    -> GValue
    -- ^ /@paramValues@/: An array of @/GValues/@ holding the arguments
    --   on which to invoke the callback of closure.
    -> Ptr ()
    -- ^ /@invocationHint@/: The invocation hint given as the last argument to
    --   'GI.GObject.Structs.Closure.closureInvoke'.
    -> Ptr ()
    -- ^ /@marshalData@/: Additional data specified when registering the
    --   marshaller, see @/g_closure_set_marshal()/@ and
    --   @/g_closure_set_meta_marshal()/@
    -> m ()
cClosureMarshalGeneric closure returnGvalue nParamValues paramValues invocationHint marshalData = liftIO $ do
    closure' <- unsafeManagedPtrCastPtr closure
    returnGvalue' <- unsafeManagedPtrGetPtr returnGvalue
    paramValues' <- unsafeManagedPtrGetPtr paramValues
    g_cclosure_marshal_generic closure' returnGvalue' nParamValues paramValues' invocationHint marshalData
    touchManagedPtr closure
    touchManagedPtr returnGvalue
    touchManagedPtr paramValues
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveCClosureMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCClosureMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCClosureMethod t CClosure, O.OverloadedMethod info CClosure p) => OL.IsLabel t (CClosure -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCClosureMethod t CClosure, O.OverloadedMethod info CClosure p, R.HasField t CClosure p) => R.HasField t CClosure p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCClosureMethod t CClosure, O.OverloadedMethodInfo info CClosure) => OL.IsLabel t (O.MethodProxy info CClosure) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


