{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Renders a scene graph defined via a tree of t'GI.Gsk.Objects.RenderNode.RenderNode' instances.
-- 
-- Typically you will use a @GskRenderer@ instance to repeatedly call
-- 'GI.Gsk.Objects.Renderer.rendererRender' to update the contents of its associated
-- t'GI.Gdk.Objects.Surface.Surface'.
-- 
-- It is necessary to realize a @GskRenderer@ instance using
-- 'GI.Gsk.Objects.Renderer.rendererRealize' before calling 'GI.Gsk.Objects.Renderer.rendererRender',
-- in order to create the appropriate windowing system resources needed
-- to render the scene.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.Renderer
    ( 

-- * Exported types
    Renderer(..)                            ,
    IsRenderer                              ,
    toRenderer                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRealized]("GI.Gsk.Objects.Renderer#g:method:isRealized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gsk.Objects.Renderer#g:method:realize"), [realizeForDisplay]("GI.Gsk.Objects.Renderer#g:method:realizeForDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [render]("GI.Gsk.Objects.Renderer#g:method:render"), [renderTexture]("GI.Gsk.Objects.Renderer#g:method:renderTexture"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gsk.Objects.Renderer#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gsk.Objects.Renderer#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveRendererMethod                   ,
#endif

-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    RendererGetSurfaceMethodInfo            ,
#endif
    rendererGetSurface                      ,


-- ** isRealized #method:isRealized#

#if defined(ENABLE_OVERLOADING)
    RendererIsRealizedMethodInfo            ,
#endif
    rendererIsRealized                      ,


-- ** newForSurface #method:newForSurface#

    rendererNewForSurface                   ,


-- ** realize #method:realize#

#if defined(ENABLE_OVERLOADING)
    RendererRealizeMethodInfo               ,
#endif
    rendererRealize                         ,


-- ** realizeForDisplay #method:realizeForDisplay#

#if defined(ENABLE_OVERLOADING)
    RendererRealizeForDisplayMethodInfo     ,
#endif
    rendererRealizeForDisplay               ,


-- ** render #method:render#

#if defined(ENABLE_OVERLOADING)
    RendererRenderMethodInfo                ,
#endif
    rendererRender                          ,


-- ** renderTexture #method:renderTexture#

#if defined(ENABLE_OVERLOADING)
    RendererRenderTextureMethodInfo         ,
#endif
    rendererRenderTexture                   ,


-- ** unrealize #method:unrealize#

#if defined(ENABLE_OVERLOADING)
    RendererUnrealizeMethodInfo             ,
#endif
    rendererUnrealize                       ,




 -- * Properties


-- ** realized #attr:realized#
-- | Whether the renderer has been associated with a surface or draw context.

#if defined(ENABLE_OVERLOADING)
    RendererRealizedPropertyInfo            ,
#endif
    getRendererRealized                     ,
#if defined(ENABLE_OVERLOADING)
    rendererRealized                        ,
#endif


-- ** surface #attr:surface#
-- | The surface associated with renderer.

#if defined(ENABLE_OVERLOADING)
    RendererSurfacePropertyInfo             ,
#endif
    getRendererSurface                      ,
#if defined(ENABLE_OVERLOADING)
    rendererSurface                         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype Renderer = Renderer (SP.ManagedPtr Renderer)
    deriving (Eq)

instance SP.ManagedPtrNewtype Renderer where
    toManagedPtr (Renderer p) = p

foreign import ccall "gsk_renderer_get_type"
    c_gsk_renderer_get_type :: IO B.Types.GType

instance B.Types.TypedObject Renderer where
    glibType = c_gsk_renderer_get_type

instance B.Types.GObject Renderer

-- | Type class for types which can be safely cast to t'Renderer', for instance with `toRenderer`.
class (SP.GObject o, O.IsDescendantOf Renderer o) => IsRenderer o
instance (SP.GObject o, O.IsDescendantOf Renderer o) => IsRenderer o

instance O.HasParentTypes Renderer
type instance O.ParentTypes Renderer = '[GObject.Object.Object]

-- | Cast to t'Renderer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRenderer :: (MIO.MonadIO m, IsRenderer o) => o -> m Renderer
toRenderer = MIO.liftIO . B.ManagedPtr.unsafeCastTo Renderer

-- | Convert t'Renderer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Renderer) where
    gvalueGType_ = c_gsk_renderer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Renderer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Renderer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Renderer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveRendererMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRendererMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveRendererMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveRendererMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveRendererMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveRendererMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveRendererMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveRendererMethod "isRealized" o = RendererIsRealizedMethodInfo
    ResolveRendererMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveRendererMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveRendererMethod "realize" o = RendererRealizeMethodInfo
    ResolveRendererMethod "realizeForDisplay" o = RendererRealizeForDisplayMethodInfo
    ResolveRendererMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveRendererMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveRendererMethod "render" o = RendererRenderMethodInfo
    ResolveRendererMethod "renderTexture" o = RendererRenderTextureMethodInfo
    ResolveRendererMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveRendererMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveRendererMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveRendererMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveRendererMethod "unrealize" o = RendererUnrealizeMethodInfo
    ResolveRendererMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveRendererMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveRendererMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveRendererMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveRendererMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveRendererMethod "getSurface" o = RendererGetSurfaceMethodInfo
    ResolveRendererMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveRendererMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveRendererMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveRendererMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRendererMethod t Renderer, O.OverloadedMethod info Renderer p) => OL.IsLabel t (Renderer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRendererMethod t Renderer, O.OverloadedMethod info Renderer p, R.HasField t Renderer p) => R.HasField t Renderer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRendererMethod t Renderer, O.OverloadedMethodInfo info Renderer) => OL.IsLabel t (O.MethodProxy info Renderer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "realized"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@realized@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' renderer #realized
-- @
getRendererRealized :: (MonadIO m, IsRenderer o) => o -> m Bool
getRendererRealized obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "realized"

#if defined(ENABLE_OVERLOADING)
data RendererRealizedPropertyInfo
instance AttrInfo RendererRealizedPropertyInfo where
    type AttrAllowedOps RendererRealizedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint RendererRealizedPropertyInfo = IsRenderer
    type AttrSetTypeConstraint RendererRealizedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint RendererRealizedPropertyInfo = (~) ()
    type AttrTransferType RendererRealizedPropertyInfo = ()
    type AttrGetType RendererRealizedPropertyInfo = Bool
    type AttrLabel RendererRealizedPropertyInfo = "realized"
    type AttrOrigin RendererRealizedPropertyInfo = Renderer
    attrGet = getRendererRealized
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.realized"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#g:attr:realized"
        })
#endif

-- VVV Prop "surface"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Surface"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@surface@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' renderer #surface
-- @
getRendererSurface :: (MonadIO m, IsRenderer o) => o -> m (Maybe Gdk.Surface.Surface)
getRendererSurface obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "surface" Gdk.Surface.Surface

#if defined(ENABLE_OVERLOADING)
data RendererSurfacePropertyInfo
instance AttrInfo RendererSurfacePropertyInfo where
    type AttrAllowedOps RendererSurfacePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint RendererSurfacePropertyInfo = IsRenderer
    type AttrSetTypeConstraint RendererSurfacePropertyInfo = (~) ()
    type AttrTransferTypeConstraint RendererSurfacePropertyInfo = (~) ()
    type AttrTransferType RendererSurfacePropertyInfo = ()
    type AttrGetType RendererSurfacePropertyInfo = (Maybe Gdk.Surface.Surface)
    type AttrLabel RendererSurfacePropertyInfo = "surface"
    type AttrOrigin RendererSurfacePropertyInfo = Renderer
    attrGet = getRendererSurface
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.surface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#g:attr:surface"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Renderer
type instance O.AttributeList Renderer = RendererAttributeList
type RendererAttributeList = ('[ '("realized", RendererRealizedPropertyInfo), '("surface", RendererSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
rendererRealized :: AttrLabelProxy "realized"
rendererRealized = AttrLabelProxy

rendererSurface :: AttrLabelProxy "surface"
rendererSurface = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Renderer = RendererSignalList
type RendererSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Renderer::new_for_surface
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a surface" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Renderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_new_for_surface" gsk_renderer_new_for_surface :: 
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO (Ptr Renderer)

-- | Creates an appropriate @GskRenderer@ instance for the given surface.
-- 
-- If the @GSK_RENDERER@ environment variable is set, GSK will
-- try that renderer first, before trying the backend-specific
-- default. The ultimate fallback is the cairo renderer.
-- 
-- The renderer will be realized before it is returned.
rendererNewForSurface ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Surface.IsSurface a) =>
    a
    -- ^ /@surface@/: a surface
    -> m (Maybe Renderer)
    -- ^ __Returns:__ the realized renderer
rendererNewForSurface surface = liftIO $ do
    surface' <- unsafeManagedPtrCastPtr surface
    result <- gsk_renderer_new_for_surface surface'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Renderer) result'
        return result''
    touchManagedPtr surface
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Renderer::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a renderer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_get_surface" gsk_renderer_get_surface :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    IO (Ptr Gdk.Surface.Surface)

-- | Retrieves the surface that the renderer is associated with.
-- 
-- If the renderer has not been realized yet, @NULL@ will be returned.
rendererGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a) =>
    a
    -- ^ /@renderer@/: a renderer
    -> m (Maybe Gdk.Surface.Surface)
    -- ^ __Returns:__ the surface
rendererGetSurface renderer = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    result <- gsk_renderer_get_surface renderer'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Surface.Surface) result'
        return result''
    touchManagedPtr renderer
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data RendererGetSurfaceMethodInfo
instance (signature ~ (m (Maybe Gdk.Surface.Surface)), MonadIO m, IsRenderer a) => O.OverloadedMethod RendererGetSurfaceMethodInfo a signature where
    overloadedMethod = rendererGetSurface

instance O.OverloadedMethodInfo RendererGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererGetSurface"
        })


#endif

-- method Renderer::is_realized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a renderer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_is_realized" gsk_renderer_is_realized :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    IO CInt

-- | Checks whether the renderer is realized or not.
rendererIsRealized ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a) =>
    a
    -- ^ /@renderer@/: a renderer
    -> m Bool
    -- ^ __Returns:__ true if the renderer was realized, false otherwise
rendererIsRealized renderer = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    result <- gsk_renderer_is_realized renderer'
    let result' = (/= 0) result
    touchManagedPtr renderer
    return result'

#if defined(ENABLE_OVERLOADING)
data RendererIsRealizedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsRenderer a) => O.OverloadedMethod RendererIsRealizedMethodInfo a signature where
    overloadedMethod = rendererIsRealized

instance O.OverloadedMethodInfo RendererIsRealizedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererIsRealized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererIsRealized"
        })


#endif

-- method Renderer::realize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a renderer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the surface that renderer will be used on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gsk_renderer_realize" gsk_renderer_realize :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Creates the resources needed by the renderer.
-- 
-- Since GTK 4.6, the surface may be @NULL@, which allows using
-- renderers without having to create a surface. Since GTK 4.14,
-- it is recommended to use 'GI.Gsk.Objects.Renderer.rendererRealizeForDisplay'
-- for this case.
-- 
-- Note that it is mandatory to call 'GI.Gsk.Objects.Renderer.rendererUnrealize'
-- before destroying the renderer.
rendererRealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a, Gdk.Surface.IsSurface b) =>
    a
    -- ^ /@renderer@/: a renderer
    -> Maybe (b)
    -- ^ /@surface@/: the surface that renderer will be used on
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
rendererRealize renderer surface = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    maybeSurface <- case surface of
        Nothing -> return FP.nullPtr
        Just jSurface -> do
            jSurface' <- unsafeManagedPtrCastPtr jSurface
            return jSurface'
    onException (do
        _ <- propagateGError $ gsk_renderer_realize renderer' maybeSurface
        touchManagedPtr renderer
        whenJust surface touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data RendererRealizeMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsRenderer a, Gdk.Surface.IsSurface b) => O.OverloadedMethod RendererRealizeMethodInfo a signature where
    overloadedMethod = rendererRealize

instance O.OverloadedMethodInfo RendererRealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererRealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererRealize"
        })


#endif

-- method Renderer::realize_for_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a renderer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the display that the renderer will be used on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gsk_renderer_realize_for_display" gsk_renderer_realize_for_display :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Creates the resources needed by the renderer.
-- 
-- Note that it is mandatory to call 'GI.Gsk.Objects.Renderer.rendererUnrealize'
-- before destroying the renderer.
-- 
-- /Since: 4.14/
rendererRealizeForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a, Gdk.Display.IsDisplay b) =>
    a
    -- ^ /@renderer@/: a renderer
    -> b
    -- ^ /@display@/: the display that the renderer will be used on
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
rendererRealizeForDisplay renderer display = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    display' <- unsafeManagedPtrCastPtr display
    onException (do
        _ <- propagateGError $ gsk_renderer_realize_for_display renderer' display'
        touchManagedPtr renderer
        touchManagedPtr display
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data RendererRealizeForDisplayMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsRenderer a, Gdk.Display.IsDisplay b) => O.OverloadedMethod RendererRealizeForDisplayMethodInfo a signature where
    overloadedMethod = rendererRealizeForDisplay

instance O.OverloadedMethodInfo RendererRealizeForDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererRealizeForDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererRealizeForDisplay"
        })


#endif

-- method Renderer::render
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a realized renderer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the render node to render"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `cairo_region_t` that must be redrawn or `NULL`\n  for the whole surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_render" gsk_renderer_render :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    Ptr Gsk.RenderNode.RenderNode ->        -- root : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | Renders the scene graph, described by a tree of @GskRenderNode@ instances
-- to the renderer\'s surface, ensuring that the given region gets redrawn.
-- 
-- If the renderer has no associated surface, this function does nothing.
-- 
-- Renderers must ensure that changes of the contents given by the /@root@/
-- node as well as the area given by /@region@/ are redrawn. They are however
-- free to not redraw any pixel outside of /@region@/ if they can guarantee that
-- it didn\'t change.
-- 
-- The renderer will acquire a reference on the @GskRenderNode@ tree while
-- the rendering is in progress.
rendererRender ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a, Gsk.RenderNode.IsRenderNode b) =>
    a
    -- ^ /@renderer@/: a realized renderer
    -> b
    -- ^ /@root@/: the render node to render
    -> Maybe (Cairo.Region.Region)
    -- ^ /@region@/: the @cairo_region_t@ that must be redrawn or @NULL@
    --   for the whole surface
    -> m ()
rendererRender renderer root region = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    root' <- unsafeManagedPtrCastPtr root
    maybeRegion <- case region of
        Nothing -> return FP.nullPtr
        Just jRegion -> do
            jRegion' <- unsafeManagedPtrGetPtr jRegion
            return jRegion'
    gsk_renderer_render renderer' root' maybeRegion
    touchManagedPtr renderer
    touchManagedPtr root
    whenJust region touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data RendererRenderMethodInfo
instance (signature ~ (b -> Maybe (Cairo.Region.Region) -> m ()), MonadIO m, IsRenderer a, Gsk.RenderNode.IsRenderNode b) => O.OverloadedMethod RendererRenderMethodInfo a signature where
    overloadedMethod = rendererRender

instance O.OverloadedMethodInfo RendererRenderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererRender",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererRender"
        })


#endif

-- method Renderer::render_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a realized renderer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the render node to render"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "viewport"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the section to draw or `NULL` to use @root's bounds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_render_texture" gsk_renderer_render_texture :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    Ptr Gsk.RenderNode.RenderNode ->        -- root : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Graphene.Rect.Rect ->               -- viewport : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr Gdk.Texture.Texture)

-- | Renders a scene graph, described by a tree of @GskRenderNode@ instances,
-- to a texture.
-- 
-- The renderer will acquire a reference on the @GskRenderNode@ tree while
-- the rendering is in progress.
-- 
-- If you want to apply any transformations to /@root@/, you should put it into a
-- transform node and pass that node instead.
rendererRenderTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a, Gsk.RenderNode.IsRenderNode b) =>
    a
    -- ^ /@renderer@/: a realized renderer
    -> b
    -- ^ /@root@/: the render node to render
    -> Maybe (Graphene.Rect.Rect)
    -- ^ /@viewport@/: the section to draw or @NULL@ to use /@root@/\'s bounds
    -> m Gdk.Texture.Texture
    -- ^ __Returns:__ a texture with the rendered contents of /@root@/
rendererRenderTexture renderer root viewport = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    root' <- unsafeManagedPtrCastPtr root
    maybeViewport <- case viewport of
        Nothing -> return FP.nullPtr
        Just jViewport -> do
            jViewport' <- unsafeManagedPtrGetPtr jViewport
            return jViewport'
    result <- gsk_renderer_render_texture renderer' root' maybeViewport
    checkUnexpectedReturnNULL "rendererRenderTexture" result
    result' <- (wrapObject Gdk.Texture.Texture) result
    touchManagedPtr renderer
    touchManagedPtr root
    whenJust viewport touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data RendererRenderTextureMethodInfo
instance (signature ~ (b -> Maybe (Graphene.Rect.Rect) -> m Gdk.Texture.Texture), MonadIO m, IsRenderer a, Gsk.RenderNode.IsRenderNode b) => O.OverloadedMethod RendererRenderTextureMethodInfo a signature where
    overloadedMethod = rendererRenderTexture

instance O.OverloadedMethodInfo RendererRenderTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererRenderTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererRenderTexture"
        })


#endif

-- method Renderer::unrealize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "renderer"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "Renderer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a renderer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_renderer_unrealize" gsk_renderer_unrealize :: 
    Ptr Renderer ->                         -- renderer : TInterface (Name {namespace = "Gsk", name = "Renderer"})
    IO ()

-- | Releases all the resources created by 'GI.Gsk.Objects.Renderer.rendererRealize'.
rendererUnrealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsRenderer a) =>
    a
    -- ^ /@renderer@/: a renderer
    -> m ()
rendererUnrealize renderer = liftIO $ do
    renderer' <- unsafeManagedPtrCastPtr renderer
    gsk_renderer_unrealize renderer'
    touchManagedPtr renderer
    return ()

#if defined(ENABLE_OVERLOADING)
data RendererUnrealizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsRenderer a) => O.OverloadedMethod RendererUnrealizeMethodInfo a signature where
    overloadedMethod = rendererUnrealize

instance O.OverloadedMethodInfo RendererUnrealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.Renderer.rendererUnrealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-Renderer.html#v:rendererUnrealize"
        })


#endif


