{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node applying a rounded rectangle clip to its single child.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.RoundedClipNode
    ( 

-- * Exported types
    RoundedClipNode(..)                     ,
    IsRoundedClipNode                       ,
    toRoundedClipNode                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.RoundedClipNode#g:method:getChild"), [getClip]("GI.Gsk.Objects.RoundedClipNode#g:method:getClip"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRoundedClipNodeMethod            ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    RoundedClipNodeGetChildMethodInfo       ,
#endif
    roundedClipNodeGetChild                 ,


-- ** getClip #method:getClip#

#if defined(ENABLE_OVERLOADING)
    RoundedClipNodeGetClipMethodInfo        ,
#endif
    roundedClipNodeGetClip                  ,


-- ** new #method:new#

    roundedClipNodeNew                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect

#endif

-- | Memory-managed wrapper type.
newtype RoundedClipNode = RoundedClipNode (SP.ManagedPtr RoundedClipNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype RoundedClipNode where
    toManagedPtr (RoundedClipNode p) = p

foreign import ccall "gsk_rounded_clip_node_get_type"
    c_gsk_rounded_clip_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject RoundedClipNode where
    glibType = c_gsk_rounded_clip_node_get_type

-- | Type class for types which can be safely cast to t'RoundedClipNode', for instance with `toRoundedClipNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RoundedClipNode o) => IsRoundedClipNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RoundedClipNode o) => IsRoundedClipNode o

instance O.HasParentTypes RoundedClipNode
type instance O.ParentTypes RoundedClipNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'RoundedClipNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRoundedClipNode :: (MIO.MonadIO m, IsRoundedClipNode o) => o -> m RoundedClipNode
toRoundedClipNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo RoundedClipNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveRoundedClipNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRoundedClipNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveRoundedClipNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveRoundedClipNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveRoundedClipNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveRoundedClipNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveRoundedClipNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveRoundedClipNodeMethod "getChild" o = RoundedClipNodeGetChildMethodInfo
    ResolveRoundedClipNodeMethod "getClip" o = RoundedClipNodeGetClipMethodInfo
    ResolveRoundedClipNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveRoundedClipNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveRoundedClipNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRoundedClipNodeMethod t RoundedClipNode, O.OverloadedMethod info RoundedClipNode p) => OL.IsLabel t (RoundedClipNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRoundedClipNodeMethod t RoundedClipNode, O.OverloadedMethod info RoundedClipNode p, R.HasField t RoundedClipNode p) => R.HasField t RoundedClipNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRoundedClipNodeMethod t RoundedClipNode, O.OverloadedMethodInfo info RoundedClipNode) => OL.IsLabel t (O.MethodProxy info RoundedClipNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr RoundedClipNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method RoundedClipNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to draw" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clip"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RoundedRect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The clip to apply" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "RoundedClipNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_rounded_clip_node_new" gsk_rounded_clip_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.RoundedRect.RoundedRect ->      -- clip : TInterface (Name {namespace = "Gsk", name = "RoundedRect"})
    IO (Ptr RoundedClipNode)

-- | Creates a @GskRenderNode@ that will clip the /@child@/ to the area
-- given by /@clip@/.
roundedClipNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to draw
    -> Gsk.RoundedRect.RoundedRect
    -- ^ /@clip@/: The clip to apply
    -> m RoundedClipNode
    -- ^ __Returns:__ A new @GskRenderNode@
roundedClipNodeNew child clip = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    clip' <- unsafeManagedPtrGetPtr clip
    result <- gsk_rounded_clip_node_new child' clip'
    checkUnexpectedReturnNULL "roundedClipNodeNew" result
    result' <- (wrapPtr RoundedClipNode) result
    touchManagedPtr child
    touchManagedPtr clip
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method RoundedClipNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RoundedClipNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a rounded clip `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_rounded_clip_node_get_child" gsk_rounded_clip_node_get_child :: 
    Ptr RoundedClipNode ->                  -- node : TInterface (Name {namespace = "Gsk", name = "RoundedClipNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting clipped by the given /@node@/.
roundedClipNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsRoundedClipNode a) =>
    a
    -- ^ /@node@/: a rounded clip @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ The child that is getting clipped
roundedClipNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_rounded_clip_node_get_child node'
    checkUnexpectedReturnNULL "roundedClipNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RoundedClipNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsRoundedClipNode a) => O.OverloadedMethod RoundedClipNodeGetChildMethodInfo a signature where
    overloadedMethod = roundedClipNodeGetChild

instance O.OverloadedMethodInfo RoundedClipNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RoundedClipNode.roundedClipNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RoundedClipNode.html#v:roundedClipNodeGetChild"
        })


#endif

-- method RoundedClipNode::get_clip
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RoundedClipNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a rounded clip `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RoundedRect" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_rounded_clip_node_get_clip" gsk_rounded_clip_node_get_clip :: 
    Ptr RoundedClipNode ->                  -- node : TInterface (Name {namespace = "Gsk", name = "RoundedClipNode"})
    IO (Ptr Gsk.RoundedRect.RoundedRect)

-- | Retrieves the rounded rectangle used to clip the contents of the /@node@/.
roundedClipNodeGetClip ::
    (B.CallStack.HasCallStack, MonadIO m, IsRoundedClipNode a) =>
    a
    -- ^ /@node@/: a rounded clip @GskRenderNode@
    -> m Gsk.RoundedRect.RoundedRect
    -- ^ __Returns:__ a rounded rectangle
roundedClipNodeGetClip node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_rounded_clip_node_get_clip node'
    checkUnexpectedReturnNULL "roundedClipNodeGetClip" result
    result' <- (newPtr Gsk.RoundedRect.RoundedRect) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data RoundedClipNodeGetClipMethodInfo
instance (signature ~ (m Gsk.RoundedRect.RoundedRect), MonadIO m, IsRoundedClipNode a) => O.OverloadedMethod RoundedClipNodeGetClipMethodInfo a signature where
    overloadedMethod = roundedClipNodeGetClip

instance O.OverloadedMethodInfo RoundedClipNodeGetClipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.RoundedClipNode.roundedClipNodeGetClip",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-RoundedClipNode.html#v:roundedClipNodeGetClip"
        })


#endif


