{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node drawing one or more shadows behind its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ShadowNode
    ( 

-- * Exported types
    ShadowNode(..)                          ,
    IsShadowNode                            ,
    toShadowNode                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.ShadowNode#g:method:getChild"), [getNShadows]("GI.Gsk.Objects.ShadowNode#g:method:getNShadows"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getShadow]("GI.Gsk.Objects.ShadowNode#g:method:getShadow").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveShadowNodeMethod                 ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ShadowNodeGetChildMethodInfo            ,
#endif
    shadowNodeGetChild                      ,


-- ** getNShadows #method:getNShadows#

#if defined(ENABLE_OVERLOADING)
    ShadowNodeGetNShadowsMethodInfo         ,
#endif
    shadowNodeGetNShadows                   ,


-- ** getShadow #method:getShadow#

#if defined(ENABLE_OVERLOADING)
    ShadowNodeGetShadowMethodInfo           ,
#endif
    shadowNodeGetShadow                     ,


-- ** new #method:new#

    shadowNodeNew                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.Shadow as Gsk.Shadow

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.Shadow as Gsk.Shadow

#endif

-- | Memory-managed wrapper type.
newtype ShadowNode = ShadowNode (SP.ManagedPtr ShadowNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShadowNode where
    toManagedPtr (ShadowNode p) = p

foreign import ccall "gsk_shadow_node_get_type"
    c_gsk_shadow_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ShadowNode where
    glibType = c_gsk_shadow_node_get_type

-- | Type class for types which can be safely cast to t'ShadowNode', for instance with `toShadowNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ShadowNode o) => IsShadowNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ShadowNode o) => IsShadowNode o

instance O.HasParentTypes ShadowNode
type instance O.ParentTypes ShadowNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ShadowNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toShadowNode :: (MIO.MonadIO m, IsShadowNode o) => o -> m ShadowNode
toShadowNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ShadowNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveShadowNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShadowNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveShadowNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveShadowNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveShadowNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveShadowNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveShadowNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveShadowNodeMethod "getChild" o = ShadowNodeGetChildMethodInfo
    ResolveShadowNodeMethod "getNShadows" o = ShadowNodeGetNShadowsMethodInfo
    ResolveShadowNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveShadowNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveShadowNodeMethod "getShadow" o = ShadowNodeGetShadowMethodInfo
    ResolveShadowNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShadowNodeMethod t ShadowNode, O.OverloadedMethod info ShadowNode p) => OL.IsLabel t (ShadowNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShadowNodeMethod t ShadowNode, O.OverloadedMethod info ShadowNode p, R.HasField t ShadowNode p) => R.HasField t ShadowNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShadowNodeMethod t ShadowNode, O.OverloadedMethodInfo info ShadowNode) => OL.IsLabel t (O.MethodProxy info ShadowNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ShadowNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ShadowNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to draw" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shadows"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gsk" , name = "Shadow" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The shadows to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_shadows"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of entries in the @shadows array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_shadows"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of entries in the @shadows array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "ShadowNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shadow_node_new" gsk_shadow_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.Shadow.Shadow ->                -- shadows : TCArray False (-1) 2 (TInterface (Name {namespace = "Gsk", name = "Shadow"}))
    FCT.CSize ->                            -- n_shadows : TBasicType TSize
    IO (Ptr ShadowNode)

-- | Creates a @GskRenderNode@ that will draw a /@child@/ with the given
-- /@shadows@/ below it.
shadowNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to draw
    -> [Gsk.Shadow.Shadow]
    -- ^ /@shadows@/: The shadows to apply
    -> m ShadowNode
    -- ^ __Returns:__ A new @GskRenderNode@
shadowNodeNew child shadows = liftIO $ do
    let nShadows = fromIntegral $ P.length shadows
    child' <- unsafeManagedPtrCastPtr child
    shadows' <- mapM unsafeManagedPtrGetPtr shadows
    shadows'' <- packBlockArray 28 shadows'
    result <- gsk_shadow_node_new child' shadows'' nShadows
    checkUnexpectedReturnNULL "shadowNodeNew" result
    result' <- (wrapPtr ShadowNode) result
    touchManagedPtr child
    mapM_ touchManagedPtr shadows
    freeMem shadows''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ShadowNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a shadow `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shadow_node_get_child" gsk_shadow_node_get_child :: 
    Ptr ShadowNode ->                       -- node : TInterface (Name {namespace = "Gsk", name = "ShadowNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the child @GskRenderNode@ of the shadow /@node@/.
shadowNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsShadowNode a) =>
    a
    -- ^ /@node@/: a shadow @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the child render node
shadowNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_shadow_node_get_child node'
    checkUnexpectedReturnNULL "shadowNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ShadowNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsShadowNode a) => O.OverloadedMethod ShadowNodeGetChildMethodInfo a signature where
    overloadedMethod = shadowNodeGetChild

instance O.OverloadedMethodInfo ShadowNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ShadowNode.shadowNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ShadowNode.html#v:shadowNodeGetChild"
        })


#endif

-- method ShadowNode::get_n_shadows
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a shadow `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shadow_node_get_n_shadows" gsk_shadow_node_get_n_shadows :: 
    Ptr ShadowNode ->                       -- node : TInterface (Name {namespace = "Gsk", name = "ShadowNode"})
    IO FCT.CSize

-- | Retrieves the number of shadows in the /@node@/.
shadowNodeGetNShadows ::
    (B.CallStack.HasCallStack, MonadIO m, IsShadowNode a) =>
    a
    -- ^ /@node@/: a shadow @GskRenderNode@
    -> m FCT.CSize
    -- ^ __Returns:__ the number of shadows.
shadowNodeGetNShadows node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_shadow_node_get_n_shadows node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data ShadowNodeGetNShadowsMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsShadowNode a) => O.OverloadedMethod ShadowNodeGetNShadowsMethodInfo a signature where
    overloadedMethod = shadowNodeGetNShadows

instance O.OverloadedMethodInfo ShadowNodeGetNShadowsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ShadowNode.shadowNodeGetNShadows",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ShadowNode.html#v:shadowNodeGetNShadows"
        })


#endif

-- method ShadowNode::get_shadow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShadowNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a shadow `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the given index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "Shadow" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shadow_node_get_shadow" gsk_shadow_node_get_shadow :: 
    Ptr ShadowNode ->                       -- node : TInterface (Name {namespace = "Gsk", name = "ShadowNode"})
    FCT.CSize ->                            -- i : TBasicType TSize
    IO (Ptr Gsk.Shadow.Shadow)

-- | Retrieves the shadow data at the given index /@i@/.
shadowNodeGetShadow ::
    (B.CallStack.HasCallStack, MonadIO m, IsShadowNode a) =>
    a
    -- ^ /@node@/: a shadow @GskRenderNode@
    -> FCT.CSize
    -- ^ /@i@/: the given index
    -> m Gsk.Shadow.Shadow
    -- ^ __Returns:__ the shadow data
shadowNodeGetShadow node i = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_shadow_node_get_shadow node' i
    checkUnexpectedReturnNULL "shadowNodeGetShadow" result
    result' <- (newPtr Gsk.Shadow.Shadow) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ShadowNodeGetShadowMethodInfo
instance (signature ~ (FCT.CSize -> m Gsk.Shadow.Shadow), MonadIO m, IsShadowNode a) => O.OverloadedMethod ShadowNodeGetShadowMethodInfo a signature where
    overloadedMethod = shadowNodeGetShadow

instance O.OverloadedMethodInfo ShadowNodeGetShadowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ShadowNode.shadowNodeGetShadow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ShadowNode.html#v:shadowNodeGetShadow"
        })


#endif


