{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a repeating linear gradient.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.RepeatingLinearGradientNode
    ( 

-- * Exported types
    RepeatingLinearGradientNode(..)         ,
    IsRepeatingLinearGradientNode           ,
    toRepeatingLinearGradientNode           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRepeatingLinearGradientNodeMethod,
#endif

-- ** new #method:new#

    repeatingLinearGradientNodeNew          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#else
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#endif

-- | Memory-managed wrapper type.
newtype RepeatingLinearGradientNode = RepeatingLinearGradientNode (SP.ManagedPtr RepeatingLinearGradientNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype RepeatingLinearGradientNode where
    toManagedPtr (RepeatingLinearGradientNode p) = p

foreign import ccall "gsk_repeating_linear_gradient_node_get_type"
    c_gsk_repeating_linear_gradient_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject RepeatingLinearGradientNode where
    glibType = c_gsk_repeating_linear_gradient_node_get_type

-- | Type class for types which can be safely cast to t'RepeatingLinearGradientNode', for instance with `toRepeatingLinearGradientNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatingLinearGradientNode o) => IsRepeatingLinearGradientNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatingLinearGradientNode o) => IsRepeatingLinearGradientNode o

instance O.HasParentTypes RepeatingLinearGradientNode
type instance O.ParentTypes RepeatingLinearGradientNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'RepeatingLinearGradientNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRepeatingLinearGradientNode :: (MIO.MonadIO m, IsRepeatingLinearGradientNode o) => o -> m RepeatingLinearGradientNode
toRepeatingLinearGradientNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo RepeatingLinearGradientNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveRepeatingLinearGradientNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRepeatingLinearGradientNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveRepeatingLinearGradientNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveRepeatingLinearGradientNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRepeatingLinearGradientNodeMethod t RepeatingLinearGradientNode, O.OverloadedMethod info RepeatingLinearGradientNode p) => OL.IsLabel t (RepeatingLinearGradientNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRepeatingLinearGradientNodeMethod t RepeatingLinearGradientNode, O.OverloadedMethod info RepeatingLinearGradientNode p, R.HasField t RepeatingLinearGradientNode p) => R.HasField t RepeatingLinearGradientNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRepeatingLinearGradientNodeMethod t RepeatingLinearGradientNode, O.OverloadedMethodInfo info RepeatingLinearGradientNode) => OL.IsLabel t (O.MethodProxy info RepeatingLinearGradientNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr RepeatingLinearGradientNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method RepeatingLinearGradientNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the rectangle to render the linear gradient into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point at which the linear gradient will begin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point at which the linear gradient will finish"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_stops"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gsk" , name = "ColorStop" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to an array of\n`GskColorStop` defining the gradient. The offsets of all color stops\n  must be increasing. The first stop's offset must be >= 0 and the last\n  stop's offset must be <= 1."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_color_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of elements in @color_stops"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_color_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of elements in @color_stops"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "RepeatingLinearGradientNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_repeating_linear_gradient_node_new" gsk_repeating_linear_gradient_node_new :: 
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- start : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Point.Point ->             -- end : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Gsk.ColorStop.ColorStop ->          -- color_stops : TCArray False (-1) 4 (TInterface (Name {namespace = "Gsk", name = "ColorStop"}))
    FCT.CSize ->                            -- n_color_stops : TBasicType TSize
    IO (Ptr RepeatingLinearGradientNode)

-- | Creates a @GskRenderNode@ that will create a repeating linear gradient
-- from the given points and color stops, and render that into the area
-- given by /@bounds@/.
repeatingLinearGradientNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Graphene.Rect.Rect
    -- ^ /@bounds@/: the rectangle to render the linear gradient into
    -> Graphene.Point.Point
    -- ^ /@start@/: the point at which the linear gradient will begin
    -> Graphene.Point.Point
    -- ^ /@end@/: the point at which the linear gradient will finish
    -> [Gsk.ColorStop.ColorStop]
    -- ^ /@colorStops@/: a pointer to an array of
    -- @GskColorStop@ defining the gradient. The offsets of all color stops
    --   must be increasing. The first stop\'s offset must be >= 0 and the last
    --   stop\'s offset must be \<= 1.
    -> m RepeatingLinearGradientNode
    -- ^ __Returns:__ A new @GskRenderNode@
repeatingLinearGradientNodeNew bounds start end colorStops = liftIO $ do
    let nColorStops = fromIntegral $ P.length colorStops
    bounds' <- unsafeManagedPtrGetPtr bounds
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    colorStops' <- mapM unsafeManagedPtrGetPtr colorStops
    colorStops'' <- packBlockArray 20 colorStops'
    result <- gsk_repeating_linear_gradient_node_new bounds' start' end' colorStops'' nColorStops
    checkUnexpectedReturnNULL "repeatingLinearGradientNodeNew" result
    result' <- (wrapPtr RepeatingLinearGradientNode) result
    touchManagedPtr bounds
    touchManagedPtr start
    touchManagedPtr end
    mapM_ touchManagedPtr colorStops
    freeMem colorStops''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


