{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A location in a parse buffer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Structs.ParseLocation
    ( 

-- * Exported types
    ParseLocation(..)                       ,
    newZeroParseLocation                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveParseLocationMethod              ,
#endif



 -- * Properties


-- ** bytes #attr:bytes#
-- | the offset of the location in the parse buffer, as bytes

    getParseLocationBytes                   ,
#if defined(ENABLE_OVERLOADING)
    parseLocation_bytes                     ,
#endif
    setParseLocationBytes                   ,


-- ** chars #attr:chars#
-- | the offset of the location in the parse buffer, as characters

    getParseLocationChars                   ,
#if defined(ENABLE_OVERLOADING)
    parseLocation_chars                     ,
#endif
    setParseLocationChars                   ,


-- ** lineBytes #attr:lineBytes#
-- | the position in the line, as bytes

    getParseLocationLineBytes               ,
#if defined(ENABLE_OVERLOADING)
    parseLocation_lineBytes                 ,
#endif
    setParseLocationLineBytes               ,


-- ** lineChars #attr:lineChars#
-- | the position in the line, as characters

    getParseLocationLineChars               ,
#if defined(ENABLE_OVERLOADING)
    parseLocation_lineChars                 ,
#endif
    setParseLocationLineChars               ,


-- ** lines #attr:lines#
-- | the line of the location in the parse buffer

    getParseLocationLines                   ,
#if defined(ENABLE_OVERLOADING)
    parseLocation_lines                     ,
#endif
    setParseLocationLines                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ParseLocation = ParseLocation (SP.ManagedPtr ParseLocation)
    deriving (Eq)

instance SP.ManagedPtrNewtype ParseLocation where
    toManagedPtr (ParseLocation p) = p

instance BoxedPtr ParseLocation where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr ParseLocation)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ParseLocation where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'ParseLocation' struct initialized to zero.
newZeroParseLocation :: MonadIO m => m ParseLocation
newZeroParseLocation = liftIO $ boxedPtrCalloc >>= wrapPtr ParseLocation

instance tag ~ 'AttrSet => Constructible ParseLocation tag where
    new _ attrs = do
        o <- newZeroParseLocation
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parseLocation #bytes
-- @
getParseLocationBytes :: MonadIO m => ParseLocation -> m FCT.CSize
getParseLocationBytes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CSize
    return val

-- | Set the value of the “@bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parseLocation [ #bytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setParseLocationBytes :: MonadIO m => ParseLocation -> FCT.CSize -> m ()
setParseLocationBytes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data ParseLocationBytesFieldInfo
instance AttrInfo ParseLocationBytesFieldInfo where
    type AttrBaseTypeConstraint ParseLocationBytesFieldInfo = (~) ParseLocation
    type AttrAllowedOps ParseLocationBytesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParseLocationBytesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint ParseLocationBytesFieldInfo = (~)FCT.CSize
    type AttrTransferType ParseLocationBytesFieldInfo = FCT.CSize
    type AttrGetType ParseLocationBytesFieldInfo = FCT.CSize
    type AttrLabel ParseLocationBytesFieldInfo = "bytes"
    type AttrOrigin ParseLocationBytesFieldInfo = ParseLocation
    attrGet = getParseLocationBytes
    attrSet = setParseLocationBytes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ParseLocation.bytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ParseLocation.html#g:attr:bytes"
        })

parseLocation_bytes :: AttrLabelProxy "bytes"
parseLocation_bytes = AttrLabelProxy

#endif


-- | Get the value of the “@chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parseLocation #chars
-- @
getParseLocationChars :: MonadIO m => ParseLocation -> m FCT.CSize
getParseLocationChars s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO FCT.CSize
    return val

-- | Set the value of the “@chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parseLocation [ #chars 'Data.GI.Base.Attributes.:=' value ]
-- @
setParseLocationChars :: MonadIO m => ParseLocation -> FCT.CSize -> m ()
setParseLocationChars s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data ParseLocationCharsFieldInfo
instance AttrInfo ParseLocationCharsFieldInfo where
    type AttrBaseTypeConstraint ParseLocationCharsFieldInfo = (~) ParseLocation
    type AttrAllowedOps ParseLocationCharsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParseLocationCharsFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint ParseLocationCharsFieldInfo = (~)FCT.CSize
    type AttrTransferType ParseLocationCharsFieldInfo = FCT.CSize
    type AttrGetType ParseLocationCharsFieldInfo = FCT.CSize
    type AttrLabel ParseLocationCharsFieldInfo = "chars"
    type AttrOrigin ParseLocationCharsFieldInfo = ParseLocation
    attrGet = getParseLocationChars
    attrSet = setParseLocationChars
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ParseLocation.chars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ParseLocation.html#g:attr:chars"
        })

parseLocation_chars :: AttrLabelProxy "chars"
parseLocation_chars = AttrLabelProxy

#endif


-- | Get the value of the “@lines@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parseLocation #lines
-- @
getParseLocationLines :: MonadIO m => ParseLocation -> m FCT.CSize
getParseLocationLines s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO FCT.CSize
    return val

-- | Set the value of the “@lines@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parseLocation [ #lines 'Data.GI.Base.Attributes.:=' value ]
-- @
setParseLocationLines :: MonadIO m => ParseLocation -> FCT.CSize -> m ()
setParseLocationLines s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data ParseLocationLinesFieldInfo
instance AttrInfo ParseLocationLinesFieldInfo where
    type AttrBaseTypeConstraint ParseLocationLinesFieldInfo = (~) ParseLocation
    type AttrAllowedOps ParseLocationLinesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParseLocationLinesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint ParseLocationLinesFieldInfo = (~)FCT.CSize
    type AttrTransferType ParseLocationLinesFieldInfo = FCT.CSize
    type AttrGetType ParseLocationLinesFieldInfo = FCT.CSize
    type AttrLabel ParseLocationLinesFieldInfo = "lines"
    type AttrOrigin ParseLocationLinesFieldInfo = ParseLocation
    attrGet = getParseLocationLines
    attrSet = setParseLocationLines
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ParseLocation.lines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ParseLocation.html#g:attr:lines"
        })

parseLocation_lines :: AttrLabelProxy "lines"
parseLocation_lines = AttrLabelProxy

#endif


-- | Get the value of the “@line_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parseLocation #lineBytes
-- @
getParseLocationLineBytes :: MonadIO m => ParseLocation -> m FCT.CSize
getParseLocationLineBytes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO FCT.CSize
    return val

-- | Set the value of the “@line_bytes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parseLocation [ #lineBytes 'Data.GI.Base.Attributes.:=' value ]
-- @
setParseLocationLineBytes :: MonadIO m => ParseLocation -> FCT.CSize -> m ()
setParseLocationLineBytes s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data ParseLocationLineBytesFieldInfo
instance AttrInfo ParseLocationLineBytesFieldInfo where
    type AttrBaseTypeConstraint ParseLocationLineBytesFieldInfo = (~) ParseLocation
    type AttrAllowedOps ParseLocationLineBytesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParseLocationLineBytesFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint ParseLocationLineBytesFieldInfo = (~)FCT.CSize
    type AttrTransferType ParseLocationLineBytesFieldInfo = FCT.CSize
    type AttrGetType ParseLocationLineBytesFieldInfo = FCT.CSize
    type AttrLabel ParseLocationLineBytesFieldInfo = "line_bytes"
    type AttrOrigin ParseLocationLineBytesFieldInfo = ParseLocation
    attrGet = getParseLocationLineBytes
    attrSet = setParseLocationLineBytes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ParseLocation.lineBytes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ParseLocation.html#g:attr:lineBytes"
        })

parseLocation_lineBytes :: AttrLabelProxy "lineBytes"
parseLocation_lineBytes = AttrLabelProxy

#endif


-- | Get the value of the “@line_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parseLocation #lineChars
-- @
getParseLocationLineChars :: MonadIO m => ParseLocation -> m FCT.CSize
getParseLocationLineChars s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO FCT.CSize
    return val

-- | Set the value of the “@line_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parseLocation [ #lineChars 'Data.GI.Base.Attributes.:=' value ]
-- @
setParseLocationLineChars :: MonadIO m => ParseLocation -> FCT.CSize -> m ()
setParseLocationLineChars s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data ParseLocationLineCharsFieldInfo
instance AttrInfo ParseLocationLineCharsFieldInfo where
    type AttrBaseTypeConstraint ParseLocationLineCharsFieldInfo = (~) ParseLocation
    type AttrAllowedOps ParseLocationLineCharsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ParseLocationLineCharsFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint ParseLocationLineCharsFieldInfo = (~)FCT.CSize
    type AttrTransferType ParseLocationLineCharsFieldInfo = FCT.CSize
    type AttrGetType ParseLocationLineCharsFieldInfo = FCT.CSize
    type AttrLabel ParseLocationLineCharsFieldInfo = "line_chars"
    type AttrOrigin ParseLocationLineCharsFieldInfo = ParseLocation
    attrGet = getParseLocationLineChars
    attrSet = setParseLocationLineChars
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ParseLocation.lineChars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ParseLocation.html#g:attr:lineChars"
        })

parseLocation_lineChars :: AttrLabelProxy "lineChars"
parseLocation_lineChars = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ParseLocation
type instance O.AttributeList ParseLocation = ParseLocationAttributeList
type ParseLocationAttributeList = ('[ '("bytes", ParseLocationBytesFieldInfo), '("chars", ParseLocationCharsFieldInfo), '("lines", ParseLocationLinesFieldInfo), '("lineBytes", ParseLocationLineBytesFieldInfo), '("lineChars", ParseLocationLineCharsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveParseLocationMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveParseLocationMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveParseLocationMethod t ParseLocation, O.OverloadedMethod info ParseLocation p) => OL.IsLabel t (ParseLocation -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveParseLocationMethod t ParseLocation, O.OverloadedMethod info ParseLocation p, R.HasField t ParseLocation p) => R.HasField t ParseLocation p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveParseLocationMethod t ParseLocation, O.OverloadedMethodInfo info ParseLocation) => OL.IsLabel t (O.MethodProxy info ParseLocation) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


