{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkMessageDialog@ presents a dialog with some message text.
-- 
-- \<picture>
--   \<source srcset=\"messagedialog-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkMessageDialog\" src=\"messagedialog.png\">
-- \<\/picture>
-- 
-- It’s simply a convenience widget; you could construct the equivalent of
-- @GtkMessageDialog@ from @GtkDialog@ without too much effort, but
-- @GtkMessageDialog@ saves typing.
-- 
-- The easiest way to do a modal message dialog is to use the 'GI.Gtk.Flags.DialogFlagsModal'
-- flag, which will call 'GI.Gtk.Objects.Window.windowSetModal' internally. The dialog will
-- prevent interaction with the parent window until it\'s hidden or destroyed.
-- You can use the [Dialog::response]("GI.Gtk.Objects.Dialog#g:signal:response") signal to know when the user
-- dismissed the dialog.
-- 
-- An example for using a modal dialog:
-- 
-- === /c code/
-- >GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL;
-- >dialog = gtk_message_dialog_new (parent_window,
-- >                                 flags,
-- >                                 GTK_MESSAGE_ERROR,
-- >                                 GTK_BUTTONS_CLOSE,
-- >                                 "Error reading “%s”: %s",
-- >                                 filename,
-- >                                 g_strerror (errno));
-- >// Destroy the dialog when the user responds to it
-- >// (e.g. clicks a button)
-- >
-- >g_signal_connect (dialog, "response",
-- >                  G_CALLBACK (gtk_window_destroy),
-- >                  NULL);
-- 
-- 
-- You might do a non-modal @GtkMessageDialog@ simply by omitting the
-- 'GI.Gtk.Flags.DialogFlagsModal' flag:
-- 
-- 
-- === /c code/
-- >GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT;
-- >dialog = gtk_message_dialog_new (parent_window,
-- >                                 flags,
-- >                                 GTK_MESSAGE_ERROR,
-- >                                 GTK_BUTTONS_CLOSE,
-- >                                 "Error reading “%s”: %s",
-- >                                 filename,
-- >                                 g_strerror (errno));
-- >
-- >// Destroy the dialog when the user responds to it
-- >// (e.g. clicks a button)
-- >g_signal_connect (dialog, "response",
-- >                  G_CALLBACK (gtk_window_destroy),
-- >                  NULL);
-- 
-- 
-- = GtkMessageDialog as GtkBuildable
-- 
-- The @GtkMessageDialog@ implementation of the @GtkBuildable@ interface exposes
-- the message area as an internal child with the name “message_area”.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MessageDialog
    ( 

-- * Exported types
    MessageDialog(..)                       ,
    IsMessageDialog                         ,
    toMessageDialog                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addActionWidget]("GI.Gtk.Objects.Dialog#g:method:addActionWidget"), [addButton]("GI.Gtk.Objects.Dialog#g:method:addButton"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [response]("GI.Gtk.Objects.Dialog#g:method:response"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentArea]("GI.Gtk.Objects.Dialog#g:method:getContentArea"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGravity]("GI.Gtk.Objects.Window#g:method:getGravity"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderBar]("GI.Gtk.Objects.Dialog#g:method:getHeaderBar"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMessageArea]("GI.Gtk.Objects.MessageDialog#g:method:getMessageArea"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getResponseForWidget]("GI.Gtk.Objects.Dialog#g:method:getResponseForWidget"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidgetForResponse]("GI.Gtk.Objects.Dialog#g:method:getWidgetForResponse"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultResponse]("GI.Gtk.Objects.Dialog#g:method:setDefaultResponse"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGravity]("GI.Gtk.Objects.Window#g:method:setGravity"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMarkup]("GI.Gtk.Objects.MessageDialog#g:method:setMarkup"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setResponseSensitive]("GI.Gtk.Objects.Dialog#g:method:setResponseSensitive"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveMessageDialogMethod              ,
#endif

-- ** getMessageArea #method:getMessageArea#

#if defined(ENABLE_OVERLOADING)
    MessageDialogGetMessageAreaMethodInfo   ,
#endif
    messageDialogGetMessageArea             ,


-- ** setMarkup #method:setMarkup#

#if defined(ENABLE_OVERLOADING)
    MessageDialogSetMarkupMethodInfo        ,
#endif
    messageDialogSetMarkup                  ,




 -- * Properties


-- ** buttons #attr:buttons#
-- | Set of buttons to display on the dialog.

#if defined(ENABLE_OVERLOADING)
    MessageDialogButtonsPropertyInfo        ,
#endif
    constructMessageDialogButtons           ,
#if defined(ENABLE_OVERLOADING)
    messageDialogButtons                    ,
#endif


-- ** messageArea #attr:messageArea#
-- | The @GtkBox@ that corresponds to the message area of this dialog.
-- 
-- See 'GI.Gtk.Objects.MessageDialog.messageDialogGetMessageArea' for a detailed
-- description of this area.

#if defined(ENABLE_OVERLOADING)
    MessageDialogMessageAreaPropertyInfo    ,
#endif
    getMessageDialogMessageArea             ,
#if defined(ENABLE_OVERLOADING)
    messageDialogMessageArea                ,
#endif


-- ** messageType #attr:messageType#
-- | The type of the message.

#if defined(ENABLE_OVERLOADING)
    MessageDialogMessageTypePropertyInfo    ,
#endif
    constructMessageDialogMessageType       ,
    getMessageDialogMessageType             ,
#if defined(ENABLE_OVERLOADING)
    messageDialogMessageType                ,
#endif
    setMessageDialogMessageType             ,


-- ** secondaryText #attr:secondaryText#
-- | The secondary text of the message dialog.

#if defined(ENABLE_OVERLOADING)
    MessageDialogSecondaryTextPropertyInfo  ,
#endif
    clearMessageDialogSecondaryText         ,
    constructMessageDialogSecondaryText     ,
    getMessageDialogSecondaryText           ,
#if defined(ENABLE_OVERLOADING)
    messageDialogSecondaryText              ,
#endif
    setMessageDialogSecondaryText           ,


-- ** secondaryUseMarkup #attr:secondaryUseMarkup#
-- | 'P.True' if the secondary text of the dialog includes Pango markup.
-- 
-- See 'GI.Pango.Functions.parseMarkup'.

#if defined(ENABLE_OVERLOADING)
    MessageDialogSecondaryUseMarkupPropertyInfo,
#endif
    constructMessageDialogSecondaryUseMarkup,
    getMessageDialogSecondaryUseMarkup      ,
#if defined(ENABLE_OVERLOADING)
    messageDialogSecondaryUseMarkup         ,
#endif
    setMessageDialogSecondaryUseMarkup      ,


-- ** text #attr:text#
-- | The primary text of the message dialog.
-- 
-- If the dialog has a secondary text, this will appear as the title.

#if defined(ENABLE_OVERLOADING)
    MessageDialogTextPropertyInfo           ,
#endif
    clearMessageDialogText                  ,
    constructMessageDialogText              ,
    getMessageDialogText                    ,
#if defined(ENABLE_OVERLOADING)
    messageDialogText                       ,
#endif
    setMessageDialogText                    ,


-- ** useMarkup #attr:useMarkup#
-- | 'P.True' if the primary text of the dialog includes Pango markup.
-- 
-- See 'GI.Pango.Functions.parseMarkup'.

#if defined(ENABLE_OVERLOADING)
    MessageDialogUseMarkupPropertyInfo      ,
#endif
    constructMessageDialogUseMarkup         ,
    getMessageDialogUseMarkup               ,
#if defined(ENABLE_OVERLOADING)
    messageDialogUseMarkup                  ,
#endif
    setMessageDialogUseMarkup               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.HeaderBar as Gtk.HeaderBar
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype MessageDialog = MessageDialog (SP.ManagedPtr MessageDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype MessageDialog where
    toManagedPtr (MessageDialog p) = p

foreign import ccall "gtk_message_dialog_get_type"
    c_gtk_message_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject MessageDialog where
    glibType = c_gtk_message_dialog_get_type

instance B.Types.GObject MessageDialog

-- | Type class for types which can be safely cast to t'MessageDialog', for instance with `toMessageDialog`.
class (SP.GObject o, O.IsDescendantOf MessageDialog o) => IsMessageDialog o
instance (SP.GObject o, O.IsDescendantOf MessageDialog o) => IsMessageDialog o

instance O.HasParentTypes MessageDialog
type instance O.ParentTypes MessageDialog = '[Gtk.Dialog.Dialog, Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to t'MessageDialog', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMessageDialog :: (MIO.MonadIO m, IsMessageDialog o) => o -> m MessageDialog
toMessageDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo MessageDialog

-- | Convert t'MessageDialog' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MessageDialog) where
    gvalueGType_ = c_gtk_message_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MessageDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MessageDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MessageDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMessageDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMessageDialogMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveMessageDialogMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveMessageDialogMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveMessageDialogMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveMessageDialogMethod "addActionWidget" o = Gtk.Dialog.DialogAddActionWidgetMethodInfo
    ResolveMessageDialogMethod "addButton" o = Gtk.Dialog.DialogAddButtonMethodInfo
    ResolveMessageDialogMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveMessageDialogMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveMessageDialogMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveMessageDialogMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveMessageDialogMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveMessageDialogMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveMessageDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMessageDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMessageDialogMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveMessageDialogMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolveMessageDialogMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveMessageDialogMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveMessageDialogMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveMessageDialogMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveMessageDialogMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveMessageDialogMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveMessageDialogMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveMessageDialogMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolveMessageDialogMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveMessageDialogMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveMessageDialogMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveMessageDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMessageDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMessageDialogMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolveMessageDialogMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolveMessageDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMessageDialogMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveMessageDialogMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveMessageDialogMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveMessageDialogMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveMessageDialogMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolveMessageDialogMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveMessageDialogMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveMessageDialogMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveMessageDialogMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveMessageDialogMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveMessageDialogMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveMessageDialogMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveMessageDialogMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolveMessageDialogMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveMessageDialogMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveMessageDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMessageDialogMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveMessageDialogMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolveMessageDialogMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolveMessageDialogMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveMessageDialogMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolveMessageDialogMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveMessageDialogMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveMessageDialogMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveMessageDialogMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveMessageDialogMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolveMessageDialogMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveMessageDialogMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolveMessageDialogMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveMessageDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMessageDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMessageDialogMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveMessageDialogMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveMessageDialogMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveMessageDialogMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolveMessageDialogMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolveMessageDialogMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveMessageDialogMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveMessageDialogMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveMessageDialogMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveMessageDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMessageDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMessageDialogMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveMessageDialogMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveMessageDialogMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveMessageDialogMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveMessageDialogMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveMessageDialogMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveMessageDialogMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveMessageDialogMethod "response" o = Gtk.Dialog.DialogResponseMethodInfo
    ResolveMessageDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMessageDialogMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveMessageDialogMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveMessageDialogMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveMessageDialogMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveMessageDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMessageDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMessageDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMessageDialogMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveMessageDialogMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveMessageDialogMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolveMessageDialogMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveMessageDialogMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolveMessageDialogMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolveMessageDialogMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveMessageDialogMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveMessageDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMessageDialogMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveMessageDialogMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveMessageDialogMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveMessageDialogMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveMessageDialogMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveMessageDialogMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveMessageDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMessageDialogMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveMessageDialogMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveMessageDialogMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveMessageDialogMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveMessageDialogMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveMessageDialogMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveMessageDialogMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveMessageDialogMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolveMessageDialogMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveMessageDialogMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveMessageDialogMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveMessageDialogMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveMessageDialogMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveMessageDialogMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveMessageDialogMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolveMessageDialogMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveMessageDialogMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveMessageDialogMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveMessageDialogMethod "getContentArea" o = Gtk.Dialog.DialogGetContentAreaMethodInfo
    ResolveMessageDialogMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveMessageDialogMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveMessageDialogMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveMessageDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMessageDialogMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolveMessageDialogMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolveMessageDialogMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolveMessageDialogMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolveMessageDialogMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolveMessageDialogMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveMessageDialogMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveMessageDialogMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveMessageDialogMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveMessageDialogMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolveMessageDialogMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveMessageDialogMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveMessageDialogMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolveMessageDialogMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveMessageDialogMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveMessageDialogMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveMessageDialogMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveMessageDialogMethod "getGravity" o = Gtk.Window.WindowGetGravityMethodInfo
    ResolveMessageDialogMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolveMessageDialogMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveMessageDialogMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolveMessageDialogMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveMessageDialogMethod "getHeaderBar" o = Gtk.Dialog.DialogGetHeaderBarMethodInfo
    ResolveMessageDialogMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveMessageDialogMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveMessageDialogMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveMessageDialogMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolveMessageDialogMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolveMessageDialogMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveMessageDialogMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveMessageDialogMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveMessageDialogMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveMessageDialogMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveMessageDialogMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveMessageDialogMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveMessageDialogMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveMessageDialogMethod "getMessageArea" o = MessageDialogGetMessageAreaMethodInfo
    ResolveMessageDialogMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolveMessageDialogMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolveMessageDialogMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveMessageDialogMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveMessageDialogMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveMessageDialogMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveMessageDialogMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveMessageDialogMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveMessageDialogMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveMessageDialogMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveMessageDialogMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveMessageDialogMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveMessageDialogMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveMessageDialogMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveMessageDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMessageDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMessageDialogMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveMessageDialogMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveMessageDialogMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveMessageDialogMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveMessageDialogMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolveMessageDialogMethod "getResponseForWidget" o = Gtk.Dialog.DialogGetResponseForWidgetMethodInfo
    ResolveMessageDialogMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveMessageDialogMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveMessageDialogMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveMessageDialogMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveMessageDialogMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveMessageDialogMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveMessageDialogMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveMessageDialogMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveMessageDialogMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveMessageDialogMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveMessageDialogMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveMessageDialogMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolveMessageDialogMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolveMessageDialogMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveMessageDialogMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveMessageDialogMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolveMessageDialogMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveMessageDialogMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveMessageDialogMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveMessageDialogMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveMessageDialogMethod "getWidgetForResponse" o = Gtk.Dialog.DialogGetWidgetForResponseMethodInfo
    ResolveMessageDialogMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveMessageDialogMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveMessageDialogMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolveMessageDialogMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveMessageDialogMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveMessageDialogMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolveMessageDialogMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveMessageDialogMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveMessageDialogMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveMessageDialogMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveMessageDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMessageDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMessageDialogMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolveMessageDialogMethod "setDefaultResponse" o = Gtk.Dialog.DialogSetDefaultResponseMethodInfo
    ResolveMessageDialogMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolveMessageDialogMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolveMessageDialogMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolveMessageDialogMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolveMessageDialogMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveMessageDialogMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolveMessageDialogMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolveMessageDialogMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveMessageDialogMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveMessageDialogMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolveMessageDialogMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveMessageDialogMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveMessageDialogMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveMessageDialogMethod "setGravity" o = Gtk.Window.WindowSetGravityMethodInfo
    ResolveMessageDialogMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveMessageDialogMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolveMessageDialogMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveMessageDialogMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveMessageDialogMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveMessageDialogMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolveMessageDialogMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolveMessageDialogMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveMessageDialogMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveMessageDialogMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveMessageDialogMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveMessageDialogMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveMessageDialogMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveMessageDialogMethod "setMarkup" o = MessageDialogSetMarkupMethodInfo
    ResolveMessageDialogMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolveMessageDialogMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolveMessageDialogMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveMessageDialogMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveMessageDialogMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveMessageDialogMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveMessageDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMessageDialogMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveMessageDialogMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolveMessageDialogMethod "setResponseSensitive" o = Gtk.Dialog.DialogSetResponseSensitiveMethodInfo
    ResolveMessageDialogMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveMessageDialogMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveMessageDialogMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolveMessageDialogMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveMessageDialogMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolveMessageDialogMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolveMessageDialogMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveMessageDialogMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveMessageDialogMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolveMessageDialogMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveMessageDialogMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveMessageDialogMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveMessageDialogMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveMessageDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMessageDialogMethod t MessageDialog, O.OverloadedMethod info MessageDialog p) => OL.IsLabel t (MessageDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMessageDialogMethod t MessageDialog, O.OverloadedMethod info MessageDialog p, R.HasField t MessageDialog p) => R.HasField t MessageDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMessageDialogMethod t MessageDialog, O.OverloadedMethodInfo info MessageDialog) => OL.IsLabel t (O.MethodProxy info MessageDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "buttons"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ButtonsType"})
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Construct a t'GValueConstruct' with valid value for the “@buttons@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogButtons :: (IsMessageDialog o, MIO.MonadIO m) => Gtk.Enums.ButtonsType -> m (GValueConstruct o)
constructMessageDialogButtons val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "buttons" val

#if defined(ENABLE_OVERLOADING)
data MessageDialogButtonsPropertyInfo
instance AttrInfo MessageDialogButtonsPropertyInfo where
    type AttrAllowedOps MessageDialogButtonsPropertyInfo = '[ 'AttrConstruct]
    type AttrBaseTypeConstraint MessageDialogButtonsPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogButtonsPropertyInfo = (~) Gtk.Enums.ButtonsType
    type AttrTransferTypeConstraint MessageDialogButtonsPropertyInfo = (~) Gtk.Enums.ButtonsType
    type AttrTransferType MessageDialogButtonsPropertyInfo = Gtk.Enums.ButtonsType
    type AttrGetType MessageDialogButtonsPropertyInfo = ()
    type AttrLabel MessageDialogButtonsPropertyInfo = "buttons"
    type AttrOrigin MessageDialogButtonsPropertyInfo = MessageDialog
    attrGet = undefined
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogButtons
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.buttons"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:buttons"
        })
#endif

-- VVV Prop "message-area"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@message-area@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #messageArea
-- @
getMessageDialogMessageArea :: (MonadIO m, IsMessageDialog o) => o -> m Gtk.Widget.Widget
getMessageDialogMessageArea obj = MIO.liftIO $ checkUnexpectedNothing "getMessageDialogMessageArea" $ B.Properties.getObjectPropertyObject obj "message-area" Gtk.Widget.Widget

#if defined(ENABLE_OVERLOADING)
data MessageDialogMessageAreaPropertyInfo
instance AttrInfo MessageDialogMessageAreaPropertyInfo where
    type AttrAllowedOps MessageDialogMessageAreaPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MessageDialogMessageAreaPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogMessageAreaPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MessageDialogMessageAreaPropertyInfo = (~) ()
    type AttrTransferType MessageDialogMessageAreaPropertyInfo = ()
    type AttrGetType MessageDialogMessageAreaPropertyInfo = Gtk.Widget.Widget
    type AttrLabel MessageDialogMessageAreaPropertyInfo = "message-area"
    type AttrOrigin MessageDialogMessageAreaPropertyInfo = MessageDialog
    attrGet = getMessageDialogMessageArea
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.messageArea"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:messageArea"
        })
#endif

-- VVV Prop "message-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "MessageType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@message-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #messageType
-- @
getMessageDialogMessageType :: (MonadIO m, IsMessageDialog o) => o -> m Gtk.Enums.MessageType
getMessageDialogMessageType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "message-type"

-- | Set the value of the “@message-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' messageDialog [ #messageType 'Data.GI.Base.Attributes.:=' value ]
-- @
setMessageDialogMessageType :: (MonadIO m, IsMessageDialog o) => o -> Gtk.Enums.MessageType -> m ()
setMessageDialogMessageType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "message-type" val

-- | Construct a t'GValueConstruct' with valid value for the “@message-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogMessageType :: (IsMessageDialog o, MIO.MonadIO m) => Gtk.Enums.MessageType -> m (GValueConstruct o)
constructMessageDialogMessageType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "message-type" val

#if defined(ENABLE_OVERLOADING)
data MessageDialogMessageTypePropertyInfo
instance AttrInfo MessageDialogMessageTypePropertyInfo where
    type AttrAllowedOps MessageDialogMessageTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MessageDialogMessageTypePropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogMessageTypePropertyInfo = (~) Gtk.Enums.MessageType
    type AttrTransferTypeConstraint MessageDialogMessageTypePropertyInfo = (~) Gtk.Enums.MessageType
    type AttrTransferType MessageDialogMessageTypePropertyInfo = Gtk.Enums.MessageType
    type AttrGetType MessageDialogMessageTypePropertyInfo = Gtk.Enums.MessageType
    type AttrLabel MessageDialogMessageTypePropertyInfo = "message-type"
    type AttrOrigin MessageDialogMessageTypePropertyInfo = MessageDialog
    attrGet = getMessageDialogMessageType
    attrSet = setMessageDialogMessageType
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogMessageType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.messageType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:messageType"
        })
#endif

-- VVV Prop "secondary-text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@secondary-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #secondaryText
-- @
getMessageDialogSecondaryText :: (MonadIO m, IsMessageDialog o) => o -> m (Maybe T.Text)
getMessageDialogSecondaryText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "secondary-text"

-- | Set the value of the “@secondary-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' messageDialog [ #secondaryText 'Data.GI.Base.Attributes.:=' value ]
-- @
setMessageDialogSecondaryText :: (MonadIO m, IsMessageDialog o) => o -> T.Text -> m ()
setMessageDialogSecondaryText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "secondary-text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@secondary-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogSecondaryText :: (IsMessageDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructMessageDialogSecondaryText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "secondary-text" (P.Just val)

-- | Set the value of the “@secondary-text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #secondaryText
-- @
clearMessageDialogSecondaryText :: (MonadIO m, IsMessageDialog o) => o -> m ()
clearMessageDialogSecondaryText obj = liftIO $ B.Properties.setObjectPropertyString obj "secondary-text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data MessageDialogSecondaryTextPropertyInfo
instance AttrInfo MessageDialogSecondaryTextPropertyInfo where
    type AttrAllowedOps MessageDialogSecondaryTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MessageDialogSecondaryTextPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogSecondaryTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint MessageDialogSecondaryTextPropertyInfo = (~) T.Text
    type AttrTransferType MessageDialogSecondaryTextPropertyInfo = T.Text
    type AttrGetType MessageDialogSecondaryTextPropertyInfo = (Maybe T.Text)
    type AttrLabel MessageDialogSecondaryTextPropertyInfo = "secondary-text"
    type AttrOrigin MessageDialogSecondaryTextPropertyInfo = MessageDialog
    attrGet = getMessageDialogSecondaryText
    attrSet = setMessageDialogSecondaryText
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogSecondaryText
    attrClear = clearMessageDialogSecondaryText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.secondaryText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:secondaryText"
        })
#endif

-- VVV Prop "secondary-use-markup"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@secondary-use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #secondaryUseMarkup
-- @
getMessageDialogSecondaryUseMarkup :: (MonadIO m, IsMessageDialog o) => o -> m Bool
getMessageDialogSecondaryUseMarkup obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "secondary-use-markup"

-- | Set the value of the “@secondary-use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' messageDialog [ #secondaryUseMarkup 'Data.GI.Base.Attributes.:=' value ]
-- @
setMessageDialogSecondaryUseMarkup :: (MonadIO m, IsMessageDialog o) => o -> Bool -> m ()
setMessageDialogSecondaryUseMarkup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "secondary-use-markup" val

-- | Construct a t'GValueConstruct' with valid value for the “@secondary-use-markup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogSecondaryUseMarkup :: (IsMessageDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMessageDialogSecondaryUseMarkup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "secondary-use-markup" val

#if defined(ENABLE_OVERLOADING)
data MessageDialogSecondaryUseMarkupPropertyInfo
instance AttrInfo MessageDialogSecondaryUseMarkupPropertyInfo where
    type AttrAllowedOps MessageDialogSecondaryUseMarkupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MessageDialogSecondaryUseMarkupPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogSecondaryUseMarkupPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MessageDialogSecondaryUseMarkupPropertyInfo = (~) Bool
    type AttrTransferType MessageDialogSecondaryUseMarkupPropertyInfo = Bool
    type AttrGetType MessageDialogSecondaryUseMarkupPropertyInfo = Bool
    type AttrLabel MessageDialogSecondaryUseMarkupPropertyInfo = "secondary-use-markup"
    type AttrOrigin MessageDialogSecondaryUseMarkupPropertyInfo = MessageDialog
    attrGet = getMessageDialogSecondaryUseMarkup
    attrSet = setMessageDialogSecondaryUseMarkup
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogSecondaryUseMarkup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.secondaryUseMarkup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:secondaryUseMarkup"
        })
#endif

-- VVV Prop "text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #text
-- @
getMessageDialogText :: (MonadIO m, IsMessageDialog o) => o -> m (Maybe T.Text)
getMessageDialogText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "text"

-- | Set the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' messageDialog [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setMessageDialogText :: (MonadIO m, IsMessageDialog o) => o -> T.Text -> m ()
setMessageDialogText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogText :: (IsMessageDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructMessageDialogText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "text" (P.Just val)

-- | Set the value of the “@text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearMessageDialogText :: (MonadIO m, IsMessageDialog o) => o -> m ()
clearMessageDialogText obj = liftIO $ B.Properties.setObjectPropertyString obj "text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data MessageDialogTextPropertyInfo
instance AttrInfo MessageDialogTextPropertyInfo where
    type AttrAllowedOps MessageDialogTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint MessageDialogTextPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint MessageDialogTextPropertyInfo = (~) T.Text
    type AttrTransferType MessageDialogTextPropertyInfo = T.Text
    type AttrGetType MessageDialogTextPropertyInfo = (Maybe T.Text)
    type AttrLabel MessageDialogTextPropertyInfo = "text"
    type AttrOrigin MessageDialogTextPropertyInfo = MessageDialog
    attrGet = getMessageDialogText
    attrSet = setMessageDialogText
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogText
    attrClear = clearMessageDialogText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:text"
        })
#endif

-- VVV Prop "use-markup"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' messageDialog #useMarkup
-- @
getMessageDialogUseMarkup :: (MonadIO m, IsMessageDialog o) => o -> m Bool
getMessageDialogUseMarkup obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-markup"

-- | Set the value of the “@use-markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' messageDialog [ #useMarkup 'Data.GI.Base.Attributes.:=' value ]
-- @
setMessageDialogUseMarkup :: (MonadIO m, IsMessageDialog o) => o -> Bool -> m ()
setMessageDialogUseMarkup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-markup" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-markup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMessageDialogUseMarkup :: (IsMessageDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructMessageDialogUseMarkup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-markup" val

#if defined(ENABLE_OVERLOADING)
data MessageDialogUseMarkupPropertyInfo
instance AttrInfo MessageDialogUseMarkupPropertyInfo where
    type AttrAllowedOps MessageDialogUseMarkupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MessageDialogUseMarkupPropertyInfo = IsMessageDialog
    type AttrSetTypeConstraint MessageDialogUseMarkupPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint MessageDialogUseMarkupPropertyInfo = (~) Bool
    type AttrTransferType MessageDialogUseMarkupPropertyInfo = Bool
    type AttrGetType MessageDialogUseMarkupPropertyInfo = Bool
    type AttrLabel MessageDialogUseMarkupPropertyInfo = "use-markup"
    type AttrOrigin MessageDialogUseMarkupPropertyInfo = MessageDialog
    attrGet = getMessageDialogUseMarkup
    attrSet = setMessageDialogUseMarkup
    attrTransfer _ v = do
        return v
    attrConstruct = constructMessageDialogUseMarkup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.useMarkup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#g:attr:useMarkup"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MessageDialog
type instance O.AttributeList MessageDialog = MessageDialogAttributeList
type MessageDialogAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("buttons", MessageDialogButtonsPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("gravity", Gtk.Window.WindowGravityPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("messageArea", MessageDialogMessageAreaPropertyInfo), '("messageType", MessageDialogMessageTypePropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("secondaryText", MessageDialogSecondaryTextPropertyInfo), '("secondaryUseMarkup", MessageDialogSecondaryUseMarkupPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("text", MessageDialogTextPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("useHeaderBar", Gtk.Dialog.DialogUseHeaderBarPropertyInfo), '("useMarkup", MessageDialogUseMarkupPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
messageDialogButtons :: AttrLabelProxy "buttons"
messageDialogButtons = AttrLabelProxy

messageDialogMessageArea :: AttrLabelProxy "messageArea"
messageDialogMessageArea = AttrLabelProxy

messageDialogMessageType :: AttrLabelProxy "messageType"
messageDialogMessageType = AttrLabelProxy

messageDialogSecondaryText :: AttrLabelProxy "secondaryText"
messageDialogSecondaryText = AttrLabelProxy

messageDialogSecondaryUseMarkup :: AttrLabelProxy "secondaryUseMarkup"
messageDialogSecondaryUseMarkup = AttrLabelProxy

messageDialogText :: AttrLabelProxy "text"
messageDialogText = AttrLabelProxy

messageDialogUseMarkup :: AttrLabelProxy "useMarkup"
messageDialogUseMarkup = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MessageDialog = MessageDialogSignalList
type MessageDialogSignalList = ('[ '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("close", Gtk.Dialog.DialogCloseSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("response", Gtk.Dialog.DialogResponseSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MessageDialog::get_message_area
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message_dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MessageDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMessageDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_message_dialog_get_message_area" gtk_message_dialog_get_message_area :: 
    Ptr MessageDialog ->                    -- message_dialog : TInterface (Name {namespace = "Gtk", name = "MessageDialog"})
    IO (Ptr Gtk.Widget.Widget)

{-# DEPRECATED messageDialogGetMessageArea ["(Since version 4.10)","Use t'GI.Gtk.Objects.AlertDialog.AlertDialog' instead"] #-}
-- | Returns the message area of the dialog.
-- 
-- This is the box where the dialog’s primary and secondary labels
-- are packed. You can add your own extra content to that box and it
-- will appear below those labels. See 'GI.Gtk.Objects.Dialog.dialogGetContentArea'
-- for the corresponding function in the parent t'GI.Gtk.Objects.Dialog.Dialog'.
messageDialogGetMessageArea ::
    (B.CallStack.HasCallStack, MonadIO m, IsMessageDialog a) =>
    a
    -- ^ /@messageDialog@/: a @GtkMessageDialog@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ A @GtkBox@ corresponding to the
    --   “message area” in the /@messageDialog@/
messageDialogGetMessageArea messageDialog = liftIO $ do
    messageDialog' <- unsafeManagedPtrCastPtr messageDialog
    result <- gtk_message_dialog_get_message_area messageDialog'
    checkUnexpectedReturnNULL "messageDialogGetMessageArea" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr messageDialog
    return result'

#if defined(ENABLE_OVERLOADING)
data MessageDialogGetMessageAreaMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsMessageDialog a) => O.OverloadedMethod MessageDialogGetMessageAreaMethodInfo a signature where
    overloadedMethod = messageDialogGetMessageArea

instance O.OverloadedMethodInfo MessageDialogGetMessageAreaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.messageDialogGetMessageArea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#v:messageDialogGetMessageArea"
        })


#endif

-- method MessageDialog::set_markup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message_dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MessageDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMessageDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string with Pango markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_message_dialog_set_markup" gtk_message_dialog_set_markup :: 
    Ptr MessageDialog ->                    -- message_dialog : TInterface (Name {namespace = "Gtk", name = "MessageDialog"})
    CString ->                              -- str : TBasicType TUTF8
    IO ()

{-# DEPRECATED messageDialogSetMarkup ["(Since version 4.10)","Use t'GI.Gtk.Objects.AlertDialog.AlertDialog' instead"] #-}
-- | Sets the text of the message dialog.
messageDialogSetMarkup ::
    (B.CallStack.HasCallStack, MonadIO m, IsMessageDialog a) =>
    a
    -- ^ /@messageDialog@/: a @GtkMessageDialog@
    -> T.Text
    -- ^ /@str@/: string with Pango markup
    -> m ()
messageDialogSetMarkup messageDialog str = liftIO $ do
    messageDialog' <- unsafeManagedPtrCastPtr messageDialog
    str' <- textToCString str
    gtk_message_dialog_set_markup messageDialog' str'
    touchManagedPtr messageDialog
    freeMem str'
    return ()

#if defined(ENABLE_OVERLOADING)
data MessageDialogSetMarkupMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsMessageDialog a) => O.OverloadedMethod MessageDialogSetMarkupMethodInfo a signature where
    overloadedMethod = messageDialogSetMarkup

instance O.OverloadedMethodInfo MessageDialogSetMarkupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MessageDialog.messageDialogSetMarkup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MessageDialog.html#v:messageDialogSetMarkup"
        })


#endif


