{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base class for filters that combine multiple filters.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.MultiFilter
    ( 

-- * Exported types
    MultiFilter(..)                         ,
    IsMultiFilter                           ,
    toMultiFilter                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gtk.Objects.MultiFilter#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.MultiFilter#g:method:remove"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMultiFilterMethod                ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    MultiFilterAppendMethodInfo             ,
#endif
    multiFilterAppend                       ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    MultiFilterRemoveMethodInfo             ,
#endif
    multiFilterRemove                       ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items.
-- 
-- See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiFilterItemTypePropertyInfo         ,
#endif
    getMultiFilterItemType                  ,
#if defined(ENABLE_OVERLOADING)
    multiFilterItemType                     ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items.
-- 
-- See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    MultiFilterNItemsPropertyInfo           ,
#endif
    getMultiFilterNItems                    ,
#if defined(ENABLE_OVERLOADING)
    multiFilterNItems                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Filter as Gtk.Filter

#endif

-- | Memory-managed wrapper type.
newtype MultiFilter = MultiFilter (SP.ManagedPtr MultiFilter)
    deriving (Eq)

instance SP.ManagedPtrNewtype MultiFilter where
    toManagedPtr (MultiFilter p) = p

foreign import ccall "gtk_multi_filter_get_type"
    c_gtk_multi_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject MultiFilter where
    glibType = c_gtk_multi_filter_get_type

instance B.Types.GObject MultiFilter

-- | Type class for types which can be safely cast to t'MultiFilter', for instance with `toMultiFilter`.
class (SP.GObject o, O.IsDescendantOf MultiFilter o) => IsMultiFilter o
instance (SP.GObject o, O.IsDescendantOf MultiFilter o) => IsMultiFilter o

instance O.HasParentTypes MultiFilter
type instance O.ParentTypes MultiFilter = '[Gtk.Filter.Filter, GObject.Object.Object, Gio.ListModel.ListModel, Gtk.Buildable.Buildable]

-- | Cast to t'MultiFilter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMultiFilter :: (MIO.MonadIO m, IsMultiFilter o) => o -> m MultiFilter
toMultiFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo MultiFilter

-- | Convert t'MultiFilter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MultiFilter) where
    gvalueGType_ = c_gtk_multi_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MultiFilter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MultiFilter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MultiFilter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMultiFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMultiFilterMethod "append" o = MultiFilterAppendMethodInfo
    ResolveMultiFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMultiFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMultiFilterMethod "changed" o = Gtk.Filter.FilterChangedMethodInfo
    ResolveMultiFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMultiFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMultiFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMultiFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMultiFilterMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveMultiFilterMethod "match" o = Gtk.Filter.FilterMatchMethodInfo
    ResolveMultiFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMultiFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMultiFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMultiFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMultiFilterMethod "remove" o = MultiFilterRemoveMethodInfo
    ResolveMultiFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMultiFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMultiFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMultiFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMultiFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMultiFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMultiFilterMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveMultiFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMultiFilterMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveMultiFilterMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveMultiFilterMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveMultiFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMultiFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMultiFilterMethod "getStrictness" o = Gtk.Filter.FilterGetStrictnessMethodInfo
    ResolveMultiFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMultiFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMultiFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMultiFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMultiFilterMethod t MultiFilter, O.OverloadedMethod info MultiFilter p) => OL.IsLabel t (MultiFilter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMultiFilterMethod t MultiFilter, O.OverloadedMethod info MultiFilter p, R.HasField t MultiFilter p) => R.HasField t MultiFilter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMultiFilterMethod t MultiFilter, O.OverloadedMethodInfo info MultiFilter) => OL.IsLabel t (O.MethodProxy info MultiFilter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiFilter #itemType
-- @
getMultiFilterItemType :: (MonadIO m, IsMultiFilter o) => o -> m GType
getMultiFilterItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data MultiFilterItemTypePropertyInfo
instance AttrInfo MultiFilterItemTypePropertyInfo where
    type AttrAllowedOps MultiFilterItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiFilterItemTypePropertyInfo = IsMultiFilter
    type AttrSetTypeConstraint MultiFilterItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiFilterItemTypePropertyInfo = (~) ()
    type AttrTransferType MultiFilterItemTypePropertyInfo = ()
    type AttrGetType MultiFilterItemTypePropertyInfo = GType
    type AttrLabel MultiFilterItemTypePropertyInfo = "item-type"
    type AttrOrigin MultiFilterItemTypePropertyInfo = MultiFilter
    attrGet = getMultiFilterItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiFilter.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiFilter.html#g:attr:itemType"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' multiFilter #nItems
-- @
getMultiFilterNItems :: (MonadIO m, IsMultiFilter o) => o -> m Word32
getMultiFilterNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data MultiFilterNItemsPropertyInfo
instance AttrInfo MultiFilterNItemsPropertyInfo where
    type AttrAllowedOps MultiFilterNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MultiFilterNItemsPropertyInfo = IsMultiFilter
    type AttrSetTypeConstraint MultiFilterNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint MultiFilterNItemsPropertyInfo = (~) ()
    type AttrTransferType MultiFilterNItemsPropertyInfo = ()
    type AttrGetType MultiFilterNItemsPropertyInfo = Word32
    type AttrLabel MultiFilterNItemsPropertyInfo = "n-items"
    type AttrOrigin MultiFilterNItemsPropertyInfo = MultiFilter
    attrGet = getMultiFilterNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiFilter.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiFilter.html#g:attr:nItems"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MultiFilter
type instance O.AttributeList MultiFilter = MultiFilterAttributeList
type MultiFilterAttributeList = ('[ '("itemType", MultiFilterItemTypePropertyInfo), '("nItems", MultiFilterNItemsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
multiFilterItemType :: AttrLabelProxy "itemType"
multiFilterItemType = AttrLabelProxy

multiFilterNItems :: AttrLabelProxy "nItems"
multiFilterNItems = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MultiFilter = MultiFilterSignalList
type MultiFilterSignalList = ('[ '("changed", Gtk.Filter.FilterChangedSignalInfo), '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MultiFilter::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a multi filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filter"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Filter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filter to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_filter_append" gtk_multi_filter_append :: 
    Ptr MultiFilter ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MultiFilter"})
    Ptr Gtk.Filter.Filter ->                -- filter : TInterface (Name {namespace = "Gtk", name = "Filter"})
    IO ()

-- | Adds a filter.
multiFilterAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiFilter a, Gtk.Filter.IsFilter b) =>
    a
    -- ^ /@self@/: a multi filter
    -> b
    -- ^ /@filter@/: a filter to add
    -> m ()
multiFilterAppend self filter = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    filter' <- B.ManagedPtr.disownObject filter
    gtk_multi_filter_append self' filter'
    touchManagedPtr self
    touchManagedPtr filter
    return ()

#if defined(ENABLE_OVERLOADING)
data MultiFilterAppendMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMultiFilter a, Gtk.Filter.IsFilter b) => O.OverloadedMethod MultiFilterAppendMethodInfo a signature where
    overloadedMethod = multiFilterAppend

instance O.OverloadedMethodInfo MultiFilterAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiFilter.multiFilterAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiFilter.html#v:multiFilterAppend"
        })


#endif

-- method MultiFilter::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MultiFilter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a multi filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position of filter to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_multi_filter_remove" gtk_multi_filter_remove :: 
    Ptr MultiFilter ->                      -- self : TInterface (Name {namespace = "Gtk", name = "MultiFilter"})
    Word32 ->                               -- position : TBasicType TUInt
    IO ()

-- | Removes a filter.
-- 
-- If /@position@/ is larger than the number of filters,
-- nothing happens.
multiFilterRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsMultiFilter a) =>
    a
    -- ^ /@self@/: a multi filter
    -> Word32
    -- ^ /@position@/: position of filter to remove
    -> m ()
multiFilterRemove self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_multi_filter_remove self' position
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data MultiFilterRemoveMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsMultiFilter a) => O.OverloadedMethod MultiFilterRemoveMethodInfo a signature where
    overloadedMethod = multiFilterRemove

instance O.OverloadedMethodInfo MultiFilterRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.MultiFilter.multiFilterRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-MultiFilter.html#v:multiFilterRemove"
        })


#endif


