{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrLanguage@ structure is used to represent attributes that
-- are languages.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrLanguage
    ( 

-- * Exported types
    AttrLanguage(..)                        ,
    newZeroAttrLanguage                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrLanguageMethod               ,
#endif

-- ** new #method:new#

    attrLanguageNew                         ,




 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrLanguage_attr                       ,
#endif
    getAttrLanguageAttr                     ,


-- ** value #attr:value#
-- | the @PangoLanguage@ which is the value of the attribute

#if defined(ENABLE_OVERLOADING)
    attrLanguage_value                      ,
#endif
    clearAttrLanguageValue                  ,
    getAttrLanguageValue                    ,
    setAttrLanguageValue                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language

#endif

-- | Memory-managed wrapper type.
newtype AttrLanguage = AttrLanguage (SP.ManagedPtr AttrLanguage)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrLanguage where
    toManagedPtr (AttrLanguage p) = p

instance BoxedPtr AttrLanguage where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrLanguage)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrLanguage where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrLanguage' struct initialized to zero.
newZeroAttrLanguage :: MonadIO m => m AttrLanguage
newZeroAttrLanguage = liftIO $ boxedPtrCalloc >>= wrapPtr AttrLanguage

instance tag ~ 'AttrSet => Constructible AttrLanguage tag where
    new _ attrs = do
        o <- newZeroAttrLanguage
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrLanguage #attr
-- @
getAttrLanguageAttr :: MonadIO m => AttrLanguage -> m Pango.Attribute.Attribute
getAttrLanguageAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrLanguageAttrFieldInfo
instance AttrInfo AttrLanguageAttrFieldInfo where
    type AttrBaseTypeConstraint AttrLanguageAttrFieldInfo = (~) AttrLanguage
    type AttrAllowedOps AttrLanguageAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrLanguageAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrLanguageAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrLanguageAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrLanguageAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrLanguageAttrFieldInfo = "attr"
    type AttrOrigin AttrLanguageAttrFieldInfo = AttrLanguage
    attrGet = getAttrLanguageAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrLanguage.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrLanguage.html#g:attr:attr"
        })

attrLanguage_attr :: AttrLabelProxy "attr"
attrLanguage_attr = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrLanguage #value
-- @
getAttrLanguageValue :: MonadIO m => AttrLanguage -> m (Maybe Pango.Language.Language)
getAttrLanguageValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr Pango.Language.Language)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Pango.Language.Language) val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrLanguage [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrLanguageValue :: MonadIO m => AttrLanguage -> Ptr Pango.Language.Language -> m ()
setAttrLanguageValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr Pango.Language.Language)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearAttrLanguageValue :: MonadIO m => AttrLanguage -> m ()
clearAttrLanguageValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr Pango.Language.Language)

#if defined(ENABLE_OVERLOADING)
data AttrLanguageValueFieldInfo
instance AttrInfo AttrLanguageValueFieldInfo where
    type AttrBaseTypeConstraint AttrLanguageValueFieldInfo = (~) AttrLanguage
    type AttrAllowedOps AttrLanguageValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrLanguageValueFieldInfo = (~) (Ptr Pango.Language.Language)
    type AttrTransferTypeConstraint AttrLanguageValueFieldInfo = (~)(Ptr Pango.Language.Language)
    type AttrTransferType AttrLanguageValueFieldInfo = (Ptr Pango.Language.Language)
    type AttrGetType AttrLanguageValueFieldInfo = Maybe Pango.Language.Language
    type AttrLabel AttrLanguageValueFieldInfo = "value"
    type AttrOrigin AttrLanguageValueFieldInfo = AttrLanguage
    attrGet = getAttrLanguageValue
    attrSet = setAttrLanguageValue
    attrConstruct = undefined
    attrClear = clearAttrLanguageValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrLanguage.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrLanguage.html#g:attr:value"
        })

attrLanguage_value :: AttrLabelProxy "value"
attrLanguage_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrLanguage
type instance O.AttributeList AttrLanguage = AttrLanguageAttributeList
type AttrLanguageAttributeList = ('[ '("attr", AttrLanguageAttrFieldInfo), '("value", AttrLanguageValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method AttrLanguage::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "language"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Language" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "language tag" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_language_new" pango_attr_language_new :: 
    Ptr Pango.Language.Language ->          -- language : TInterface (Name {namespace = "Pango", name = "Language"})
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new language tag attribute.
attrLanguageNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Pango.Language.Language
    -- ^ /@language@/: language tag
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrLanguageNew language = liftIO $ do
    language' <- unsafeManagedPtrGetPtr language
    result <- pango_attr_language_new language'
    checkUnexpectedReturnNULL "attrLanguageNew" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    touchManagedPtr language
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrLanguageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrLanguageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrLanguageMethod t AttrLanguage, O.OverloadedMethod info AttrLanguage p) => OL.IsLabel t (AttrLanguage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrLanguageMethod t AttrLanguage, O.OverloadedMethod info AttrLanguage p, R.HasField t AttrLanguage p) => R.HasField t AttrLanguage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrLanguageMethod t AttrLanguage, O.OverloadedMethodInfo info AttrLanguage) => OL.IsLabel t (O.MethodProxy info AttrLanguage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


