# 12 "save.mll"
 
open Lexing
open Misc
open SaveUtils


let rec peek_next_char lb =
  let pos = lb.lex_curr_pos
  and len = lb.lex_buffer_len in
  if pos >= len then begin
    if lb.lex_eof_reached then
      raise Not_found
    else begin
      lb.refill_buff lb ;
      peek_next_char lb
    end
  end else
    Bytes.unsafe_get lb.lex_buffer pos

let if_next_char  c lb =
  try
     peek_next_char lb = c
  with
  | Not_found -> false


let rec if_next_string s lb =
  if s = "" then
    true
  else
    let pos = lb.lex_curr_pos
    and len = lb.lex_buffer_len
    and slen = String.length s in
    if pos + slen - 1 >= len then begin
      if lb.lex_eof_reached then begin
          false
      end else begin
          lb.refill_buff lb ;
        if_next_string s lb
      end
    end else
      let b = lb.lex_buffer in
      let rec do_rec k =
        if k >= slen then true
        else
          Bytes.get b (pos+k) = String.get s k &&
          do_rec (k+1) in
      do_rec 0
  

type kmp_t = Continue of int | Stop of string

let rec kmp_char delim next i c =
  if i < 0 then begin
    Out.put_char arg_buff c ;
    Continue 0
  end else if c = delim.[i] then begin
    if i >= String.length delim - 1 then
      Stop (Out.to_string arg_buff)
    else
      Continue (i+1)
  end else begin
    if next.(i) >= 0 then
      Out.put arg_buff (String.sub delim 0 (i-next.(i))) ;
    kmp_char delim next next.(i) c
  end


# 71 "save.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\253\255\000\000\255\255\000\000\255\255\001\000\254\255\
    \255\255\002\000\255\255\002\000\255\255\007\000\009\000\012\000\
    \014\000\003\000\004\000\252\255\000\000\254\255\255\255\253\255\
    \020\000\000\000\001\000\038\000\000\000\000\000\000\000\000\000\
    \000\000\022\000\002\000\080\000\254\255\000\000\164\000\245\000\
    \070\001\151\001\232\001\057\002\171\002\027\000\032\000\253\255\
    \254\255\001\000\001\000\000\000\004\000\001\000\003\000\001\000\
    \005\000\003\000\005\000\255\255\048\000\254\255\255\255\051\000\
    \172\002\251\255\040\000\253\255\033\000\178\002\254\255\029\003\
    \039\000\039\003\036\000\084\000\194\000\160\000\062\003\249\255\
    \167\000\034\000\251\255\250\255\173\002\176\002\035\000\035\000\
    \255\255\041\003\251\255\012\000\049\000\008\000\008\000\000\000\
    \012\000\001\000\026\000\058\000\254\255\000\000\002\000\066\000\
    \071\000\089\000\110\000\253\255\111\000\147\000\187\000\184\000\
    \189\000\180\000\182\000\252\255\040\003\254\255\255\255\088\003\
    \089\003\254\255\255\255\090\003\031\003\254\255\175\000\064\001\
    \255\255\032\003\254\255\008\001\255\255\214\000\151\002\249\255\
    \250\255\197\000\203\000\188\000\001\000\255\255\187\000\190\000\
    \210\000\223\000\227\000\006\000\253\255\007\000\252\255\009\000\
    \251\255\156\002\252\255\253\255\254\255\255\255\228\002\252\255\
    \253\255\004\000\255\255\254\255\248\000\014\001\230\000\018\001\
    \016\001\021\001\011\001\013\001\255\255\021\001\025\001\023\001\
    \028\001\045\001\047\001\254\255\071\001\254\255\255\255\072\001\
    \252\255\253\255\254\255\040\001\255\255\185\002\255\255\165\000\
    \254\255\255\255\008\000\255\255\119\001\254\255\255\255\166\000\
    \254\255\255\255\196\000\255\255";
  Lexing.lex_backtrk =
   "\255\255\255\255\001\000\255\255\001\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\001\000\255\255\001\000\000\000\000\000\
    \000\000\255\255\004\000\255\255\005\000\255\255\255\255\255\255\
    \002\000\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \255\255\001\000\001\000\255\255\255\255\001\000\001\000\001\000\
    \001\000\001\000\001\000\001\000\000\000\000\000\255\255\255\255\
    \255\255\001\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\255\255\002\000\255\255\255\255\255\255\
    \005\000\255\255\003\000\255\255\255\255\000\000\255\255\007\000\
    \255\255\255\255\255\255\001\000\000\000\002\000\003\000\255\255\
    \006\000\006\000\255\255\255\255\002\000\001\000\000\000\255\255\
    \255\255\005\000\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\255\255\255\255\255\255\
    \002\000\255\255\255\255\255\255\002\000\255\255\001\000\001\000\
    \255\255\002\000\255\255\001\000\255\255\000\000\255\255\255\255\
    \255\255\005\000\001\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\002\000\255\255\255\255\002\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\002\000\255\255\001\000\255\255\255\255\
    \255\255\255\255\001\000\255\255\002\000\255\255\255\255\255\255\
    \255\255\255\255\001\000\255\255";
  Lexing.lex_default =
   "\001\000\000\000\255\255\000\000\255\255\000\000\008\000\000\000\
    \000\000\009\000\000\000\255\255\000\000\255\255\255\255\255\255\
    \255\255\018\000\018\000\000\000\255\255\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\036\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\048\000\000\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\000\000\000\000\255\255\
    \069\000\000\000\255\255\000\000\068\000\069\000\000\000\255\255\
    \079\000\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\082\000\000\000\000\000\085\000\085\000\255\255\087\000\
    \000\000\255\255\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\000\000\000\000\255\255\
    \255\255\000\000\000\000\255\255\125\000\000\000\255\255\255\255\
    \000\000\130\000\000\000\255\255\000\000\133\000\136\000\000\000\
    \000\000\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\000\000\255\255\
    \000\000\155\000\000\000\000\000\000\000\000\000\160\000\000\000\
    \000\000\255\255\000\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\000\000\000\000\185\000\
    \000\000\000\000\000\000\255\255\000\000\255\255\000\000\193\000\
    \000\000\000\000\255\255\000\000\198\000\000\000\000\000\201\000\
    \000\000\000\000\203\000\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\002\000\002\000\011\000\012\000\002\000\000\000\011\000\
    \013\000\014\000\014\000\014\000\013\000\015\000\014\000\016\000\
    \000\000\015\000\000\000\016\000\000\000\027\000\027\000\033\000\
    \002\000\027\000\011\000\033\000\045\000\005\000\163\000\013\000\
    \045\000\014\000\036\000\070\000\015\000\086\000\016\000\027\000\
    \027\000\066\000\066\000\027\000\027\000\066\000\033\000\000\000\
    \000\000\063\000\092\000\045\000\063\000\063\000\092\000\141\000\
    \063\000\148\000\150\000\086\000\152\000\195\000\027\000\000\000\
    \066\000\016\000\080\000\000\000\000\000\000\000\000\000\000\000\
    \063\000\092\000\000\000\063\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\077\000\023\000\025\000\035\000\020\000\
    \255\255\031\000\056\000\028\000\052\000\033\000\050\000\053\000\
    \058\000\096\000\098\000\103\000\102\000\032\000\030\000\051\000\
    \025\000\055\000\057\000\029\000\054\000\093\000\108\000\101\000\
    \095\000\097\000\094\000\023\000\049\000\023\000\022\000\255\255\
    \021\000\255\255\059\000\081\000\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\099\000\026\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\062\000\037\000\100\000\062\000\104\000\
    \105\000\038\000\038\000\039\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\076\000\076\000\106\000\036\000\076\000\
    \077\000\077\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\107\000\076\000\109\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\110\000\
    \003\000\007\000\010\000\019\000\255\255\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\036\000\
    \047\000\255\255\255\255\088\000\111\000\112\000\113\000\255\255\
    \114\000\115\000\125\000\132\000\143\000\139\000\140\000\151\000\
    \061\000\142\000\149\000\144\000\145\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \255\255\255\255\146\000\147\000\165\000\173\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \040\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \036\000\128\000\128\000\128\000\128\000\128\000\128\000\128\000\
    \128\000\128\000\167\000\168\000\166\000\169\000\170\000\171\000\
    \172\000\174\000\175\000\132\000\176\000\177\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\178\000\179\000\188\000\187\000\192\000\200\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\041\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\036\000\181\000\186\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \042\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\036\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\000\000\000\000\000\000\000\000\182\000\
    \184\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\043\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\036\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\197\000\
    \000\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\038\000\038\000\038\000\038\000\044\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\045\000\066\000\066\000\086\000\
    \045\000\066\000\255\255\255\255\255\255\137\000\156\000\255\255\
    \000\000\000\000\190\000\190\000\000\000\000\000\190\000\000\000\
    \000\000\000\000\000\000\045\000\066\000\086\000\000\000\000\000\
    \255\255\068\000\255\255\138\000\000\000\036\000\000\000\255\255\
    \067\000\190\000\157\000\000\000\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\162\000\000\000\
    \000\000\000\000\000\000\000\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\076\000\076\000\
    \255\255\065\000\076\000\255\255\000\000\000\000\000\000\255\255\
    \000\000\119\000\092\000\000\000\000\000\119\000\092\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\076\000\000\000\073\000\
    \161\000\000\000\127\000\255\255\074\000\000\000\000\000\000\000\
    \119\000\092\000\000\000\000\000\000\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\119\000\123\000\123\000\000\000\119\000\123\000\123\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \119\000\123\000\123\000\126\000\131\000\072\000\000\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\091\000\118\000\000\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\135\000\
    \000\000\000\000\255\255\255\255\154\000\000\000\000\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\255\255\000\000\000\000\
    \255\255\000\000\255\255\000\000\000\000\000\000\118\000\000\000\
    \122\000\122\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\159\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \117\000\090\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\121\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\002\000\000\000\011\000\011\000\002\000\255\255\011\000\
    \013\000\013\000\014\000\014\000\013\000\015\000\014\000\016\000\
    \255\255\015\000\255\255\016\000\255\255\024\000\024\000\033\000\
    \002\000\024\000\011\000\033\000\045\000\004\000\161\000\013\000\
    \045\000\014\000\037\000\068\000\015\000\086\000\016\000\027\000\
    \027\000\066\000\066\000\027\000\024\000\066\000\033\000\255\255\
    \255\255\060\000\092\000\045\000\063\000\060\000\092\000\140\000\
    \063\000\147\000\149\000\086\000\151\000\194\000\027\000\255\255\
    \066\000\015\000\072\000\255\255\255\255\255\255\255\255\255\255\
    \060\000\092\000\255\255\063\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\020\000\026\000\034\000\017\000\
    \018\000\030\000\055\000\025\000\051\000\032\000\049\000\052\000\
    \057\000\095\000\097\000\102\000\101\000\031\000\029\000\050\000\
    \024\000\054\000\056\000\028\000\053\000\091\000\093\000\094\000\
    \091\000\096\000\091\000\020\000\046\000\020\000\017\000\018\000\
    \017\000\018\000\058\000\072\000\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\098\000\024\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\060\000\035\000\099\000\063\000\103\000\
    \104\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\035\000\035\000\035\000\035\000\035\000\
    \035\000\035\000\035\000\076\000\076\000\105\000\038\000\076\000\
    \077\000\077\000\077\000\077\000\077\000\077\000\077\000\077\000\
    \080\000\080\000\080\000\080\000\080\000\080\000\080\000\080\000\
    \080\000\106\000\076\000\108\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\109\000\
    \000\000\006\000\009\000\017\000\018\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\038\000\
    \038\000\038\000\038\000\038\000\038\000\038\000\038\000\039\000\
    \046\000\068\000\081\000\087\000\110\000\111\000\112\000\072\000\
    \113\000\114\000\126\000\131\000\137\000\138\000\139\000\142\000\
    \060\000\137\000\143\000\137\000\144\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \035\000\133\000\145\000\146\000\164\000\166\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \039\000\039\000\039\000\039\000\039\000\039\000\039\000\039\000\
    \040\000\127\000\127\000\127\000\127\000\127\000\127\000\127\000\
    \127\000\127\000\165\000\167\000\165\000\168\000\169\000\170\000\
    \171\000\173\000\174\000\131\000\175\000\176\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\177\000\178\000\187\000\183\000\191\000\199\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\040\000\040\000\
    \040\000\041\000\180\000\183\000\202\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\133\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\196\000\255\255\255\255\255\255\255\255\255\255\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\042\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\255\255\255\255\255\255\255\255\180\000\
    \183\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\043\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\196\000\
    \255\255\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\044\000\064\000\064\000\084\000\
    \044\000\064\000\085\000\069\000\069\000\134\000\153\000\069\000\
    \255\255\255\255\189\000\189\000\255\255\255\255\189\000\255\255\
    \255\255\255\255\255\255\044\000\064\000\084\000\255\255\255\255\
    \085\000\064\000\069\000\134\000\255\255\044\000\255\255\069\000\
    \064\000\189\000\153\000\255\255\255\255\255\255\069\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\044\000\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\158\000\255\255\
    \255\255\255\255\255\255\255\255\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
    \044\000\044\000\044\000\044\000\044\000\044\000\071\000\071\000\
    \084\000\064\000\071\000\085\000\255\255\255\255\255\255\069\000\
    \255\255\116\000\089\000\255\255\255\255\116\000\089\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\071\000\255\255\071\000\
    \158\000\255\255\124\000\129\000\071\000\255\255\255\255\255\255\
    \116\000\089\000\255\255\255\255\255\255\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\073\000\
    \073\000\073\000\073\000\073\000\073\000\073\000\073\000\073\000\
    \073\000\119\000\120\000\123\000\255\255\119\000\120\000\123\000\
    \073\000\073\000\073\000\073\000\073\000\073\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \119\000\120\000\123\000\124\000\129\000\071\000\255\255\078\000\
    \078\000\078\000\078\000\078\000\078\000\089\000\116\000\255\255\
    \073\000\073\000\073\000\073\000\073\000\073\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\134\000\
    \255\255\255\255\124\000\129\000\153\000\255\255\255\255\078\000\
    \078\000\078\000\078\000\078\000\078\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\064\000\084\000\255\255\255\255\
    \085\000\255\255\069\000\255\255\255\255\255\255\119\000\255\255\
    \120\000\123\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\158\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\124\000\
    \129\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \116\000\089\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\120\000\255\255";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec skip_comment lexbuf =
   __ocaml_lex_skip_comment_rec lexbuf 0
and __ocaml_lex_skip_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 85 "save.mll"
              (())
# 457 "save.ml"

  | 1 ->
# 86 "save.mll"
                (check_comment lexbuf)
# 462 "save.ml"

  | 2 ->
# 87 "save.mll"
              (skip_comment lexbuf)
# 467 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_comment_rec lexbuf __ocaml_lex_state

and check_comment lexbuf =
   __ocaml_lex_check_comment_rec lexbuf 4
and __ocaml_lex_check_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 90 "save.mll"
        (skip_comment lexbuf)
# 479 "save.ml"

  | 1 ->
# 91 "save.mll"
        (())
# 484 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_check_comment_rec lexbuf __ocaml_lex_state

and first_char lexbuf =
   __ocaml_lex_first_char_rec lexbuf 6
and __ocaml_lex_first_char_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 95 "save.mll"
      (let lxm = lexeme_char lexbuf 0 in
      put_echo_char lxm ;
      lxm)
# 498 "save.ml"

  | 1 ->
# 98 "save.mll"
        (raise Eof)
# 503 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_first_char_rec lexbuf __ocaml_lex_state

and rest lexbuf =
   __ocaml_lex_rest_rec lexbuf 9
and __ocaml_lex_rest_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 102 "save.mll"
      (let lxm = lexeme lexbuf in
      put_echo lxm ;
      lxm)
# 517 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_rest_rec lexbuf __ocaml_lex_state

and skip_blanks lexbuf =
   __ocaml_lex_skip_blanks_rec lexbuf 11
and __ocaml_lex_skip_blanks_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 107 "save.mll"
                 lxm
# 530 "save.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 108 "save.mll"
    (seen_par := false ;
    put_echo lxm ;
    more_skip lexbuf)
# 536 "save.ml"

  | 1 ->
let
# 111 "save.mll"
             lxm
# 542 "save.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 112 "save.mll"
    (put_echo lxm ; Out.to_string arg_buff)
# 546 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_blanks_rec lexbuf __ocaml_lex_state

and more_skip lexbuf =
   __ocaml_lex_more_skip_rec lexbuf 13
and __ocaml_lex_more_skip_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 115 "save.mll"
                           lxm
# 559 "save.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 116 "save.mll"
   (seen_par := true ;
   put_echo lxm ;
   more_skip lexbuf)
# 565 "save.ml"

  | 1 ->
let
# 119 "save.mll"
            lxm
# 571 "save.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 120 "save.mll"
  ( put_echo lxm ; Out.to_string arg_buff)
# 575 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_more_skip_rec lexbuf __ocaml_lex_state

and skip_equal lexbuf =
   __ocaml_lex_skip_equal_rec lexbuf 15
and __ocaml_lex_skip_equal_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 123 "save.mll"
                       (())
# 587 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_equal_rec lexbuf __ocaml_lex_state

and arg2 lexbuf =
   __ocaml_lex_arg2_rec lexbuf 17
and __ocaml_lex_arg2_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 127 "save.mll"
     (incr brace_nesting;
     put_both_char '{' ;
     arg2 lexbuf)
# 601 "save.ml"

  | 1 ->
# 131 "save.mll"
     (decr brace_nesting;
     if !brace_nesting > 0 then begin
       put_both_char '}' ; arg2 lexbuf
     end else begin
       put_echo_char '}' ;
       Out.to_string arg_buff
     end)
# 612 "save.ml"

  | 2 ->
# 139 "save.mll"
      (blit_both lexbuf ; arg2 lexbuf )
# 617 "save.ml"

  | 3 ->
# 141 "save.mll"
    (error "End of file in argument")
# 622 "save.ml"

  | 4 ->
# 144 "save.mll"
      (blit_both lexbuf ; arg2 lexbuf )
# 627 "save.ml"

  | 5 ->
# 147 "save.mll"
    (let c = lexeme_char lexbuf 0 in
    put_both_char c ; arg2 lexbuf)
# 633 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_arg2_rec lexbuf __ocaml_lex_state

and csname get_prim subst lexbuf =
   __ocaml_lex_csname_rec get_prim subst lexbuf 24
and __ocaml_lex_csname_rec get_prim subst lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 152 "save.mll"
    ( blit_echo lexbuf ; csname get_prim subst lexbuf )
# 645 "save.ml"

  | 1 ->
# 154 "save.mll"
      (blit_echo lexbuf ;
       let r = incsname lexbuf in
       "\\"^get_prim r)
# 652 "save.ml"

  | 2 ->
# 158 "save.mll"
   (let r = Saver.String.arg lexbuf in
   let r = subst r in
   try
     check_csname get_prim (MyLexing.from_string r)
   with
   | Exit -> r )
# 662 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_csname_rec get_prim subst lexbuf __ocaml_lex_state

and check_csname get_prim lexbuf =
   __ocaml_lex_check_csname_rec get_prim lexbuf 34
and __ocaml_lex_check_csname_rec get_prim lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 167 "save.mll"
  ( let r = incsname lexbuf in
   "\\"^get_prim r)
# 675 "save.ml"

  | 1 ->
# 171 "save.mll"
   ( raise Exit )
# 680 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_check_csname_rec get_prim lexbuf __ocaml_lex_state

and incsname lexbuf =
   __ocaml_lex_incsname_rec lexbuf 46
and __ocaml_lex_incsname_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 175 "save.mll"
    (let lxm = lexeme lexbuf in
    put_echo lxm ; Out.to_string arg_buff)
# 693 "save.ml"

  | 1 ->
# 178 "save.mll"
    (put_both_char (lexeme_char lexbuf 0) ;
    incsname lexbuf)
# 699 "save.ml"

  | 2 ->
# 180 "save.mll"
                (error "End of file in command name")
# 704 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_incsname_rec lexbuf __ocaml_lex_state

and cite_arg lexbuf =
   __ocaml_lex_cite_arg_rec lexbuf 60
and __ocaml_lex_cite_arg_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 183 "save.mll"
             (cite_args_bis lexbuf)
# 716 "save.ml"

  | 1 ->
# 184 "save.mll"
             (raise Eof)
# 721 "save.ml"

  | 2 ->
# 185 "save.mll"
             (error "No opening ``{'' in citation argument")
# 726 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_cite_arg_rec lexbuf __ocaml_lex_state

and cite_args_bis lexbuf =
   __ocaml_lex_cite_args_bis_rec lexbuf 64
and __ocaml_lex_cite_args_bis_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 189 "save.mll"
  (let lxm = lexeme lexbuf in lxm::cite_args_bis lexbuf)
# 738 "save.ml"

  | 1 ->
# 190 "save.mll"
                     (cite_args_bis lexbuf)
# 743 "save.ml"

  | 2 ->
# 191 "save.mll"
                (cite_args_bis lexbuf)
# 748 "save.ml"

  | 3 ->
# 192 "save.mll"
                (cite_args_bis lexbuf)
# 753 "save.ml"

  | 4 ->
# 193 "save.mll"
              ([])
# 758 "save.ml"

  | 5 ->
# 194 "save.mll"
              (error "Bad syntax for \\cite argument")
# 763 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_cite_args_bis_rec lexbuf __ocaml_lex_state

and num_arg lexbuf =
   __ocaml_lex_num_arg_rec lexbuf 71
and __ocaml_lex_num_arg_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 197 "save.mll"
                ((fun get_int -> num_arg lexbuf get_int))
# 775 "save.ml"

  | 1 ->
# 199 "save.mll"
    (fun _get_int ->
      let lxm = lexeme lexbuf in
      my_int_of_string lxm)
# 782 "save.ml"

  | 2 ->
# 203 "save.mll"
    (fun _get_int ->let lxm = lexeme  lexbuf in
    my_int_of_string ("0o"^String.sub lxm 1 (String.length lxm-1)))
# 788 "save.ml"

  | 3 ->
# 206 "save.mll"
    (fun _get_int ->let lxm = lexeme  lexbuf in
    my_int_of_string ("0x"^String.sub lxm 1 (String.length lxm-1)))
# 794 "save.ml"

  | 4 ->
# 209 "save.mll"
    (fun _get_int ->let c = lexeme_char lexbuf 2 in
    Char.code c)
# 800 "save.ml"

  | 5 ->
# 212 "save.mll"
    (fun get_int ->
      let lxm = lexeme lexbuf in
      get_int (String.sub lxm 1 2))
# 807 "save.ml"

  | 6 ->
# 216 "save.mll"
    (fun _get_int ->let c = lexeme_char lexbuf 1 in
    Char.code c)
# 813 "save.ml"

  | 7 ->
# 219 "save.mll"
    (fun get_int ->
      let s = Saver.String.arg lexbuf in
      get_int s)
# 820 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_num_arg_rec lexbuf __ocaml_lex_state

and filename lexbuf =
   __ocaml_lex_filename_rec lexbuf 84
and __ocaml_lex_filename_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 225 "save.mll"
                 (put_echo (lexeme lexbuf) ; filename lexbuf)
# 832 "save.ml"

  | 1 ->
# 226 "save.mll"
                 (let lxm = lexeme lexbuf in put_echo lxm ; lxm)
# 837 "save.ml"

  | 2 ->
# 227 "save.mll"
                 (Saver.String.arg lexbuf)
# 842 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_filename_rec lexbuf __ocaml_lex_state

and remain lexbuf =
   __ocaml_lex_remain_rec lexbuf 87
and __ocaml_lex_remain_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 230 "save.mll"
         (Lexing.lexeme lexbuf)
# 854 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_remain_rec lexbuf __ocaml_lex_state

and get_limits r some_space lexbuf =
   __ocaml_lex_get_limits_rec r some_space lexbuf 89
and __ocaml_lex_get_limits_rec r some_space lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 233 "save.mll"
                (get_limits r true lexbuf)
# 866 "save.ml"

  | 1 ->
# 234 "save.mll"
                (get_limits (Some Limits) some_space lexbuf)
# 871 "save.ml"

  | 2 ->
# 235 "save.mll"
                (get_limits (Some NoLimits) some_space lexbuf)
# 876 "save.ml"

  | 3 ->
# 236 "save.mll"
                (get_limits (Some IntLimits) some_space lexbuf)
# 881 "save.ml"

  | 4 ->
# 237 "save.mll"
                (raise (LimitEof (r,some_space)))
# 886 "save.ml"

  | 5 ->
# 238 "save.mll"
                (r,some_space)
# 891 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_get_limits_rec r some_space lexbuf __ocaml_lex_state

and get_sup lexbuf =
   __ocaml_lex_get_sup_rec lexbuf 116
and __ocaml_lex_get_sup_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 241 "save.mll"
              (try Some (Saver.String.arg lexbuf) with Eof -> error "End of file after ^")
# 903 "save.ml"

  | 1 ->
# 242 "save.mll"
            (raise Eof)
# 908 "save.ml"

  | 2 ->
# 243 "save.mll"
            (None)
# 913 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_get_sup_rec lexbuf __ocaml_lex_state

and get_sub lexbuf =
   __ocaml_lex_get_sub_rec lexbuf 120
and __ocaml_lex_get_sub_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 247 "save.mll"
              (try Some (Saver.String.arg lexbuf) with Eof -> error "End of file after _")
# 925 "save.ml"

  | 1 ->
# 248 "save.mll"
            (raise Eof)
# 930 "save.ml"

  | 2 ->
# 249 "save.mll"
            (None)
# 935 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_get_sub_rec lexbuf __ocaml_lex_state

and defargs lexbuf =
   __ocaml_lex_defargs_rec lexbuf 124
and __ocaml_lex_defargs_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 253 "save.mll"
    (let lxm = lexeme lexbuf in
    put_echo lxm ;
    lxm::defargs lexbuf)
# 949 "save.ml"

  | 1 ->
# 257 "save.mll"
    (blit_both lexbuf ;
    let r = in_defargs lexbuf in
    r :: defargs lexbuf)
# 956 "save.ml"

  | 2 ->
# 260 "save.mll"
     ([])
# 961 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_defargs_rec lexbuf __ocaml_lex_state

and in_defargs lexbuf =
   __ocaml_lex_in_defargs_rec lexbuf 129
and __ocaml_lex_in_defargs_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 263 "save.mll"
                (blit_both lexbuf ; in_defargs lexbuf)
# 973 "save.ml"

  | 1 ->
# 264 "save.mll"
                (put_both_char (lexeme_char lexbuf 0) ; in_defargs lexbuf)
# 978 "save.ml"

  | 2 ->
# 265 "save.mll"
                (Out.to_string arg_buff)
# 983 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_in_defargs_rec lexbuf __ocaml_lex_state

and get_defargs lexbuf =
   __ocaml_lex_get_defargs_rec lexbuf 133
and __ocaml_lex_get_defargs_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 268 "save.mll"
          (let r = lexeme lexbuf in r)
# 995 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_get_defargs_rec lexbuf __ocaml_lex_state

and tagout lexbuf =
   __ocaml_lex_tagout_rec lexbuf 134
and __ocaml_lex_tagout_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 271 "save.mll"
         (Out.put_char tag_buff ' ' ; tagout lexbuf)
# 1007 "save.ml"

  | 1 ->
# 272 "save.mll"
        (intag lexbuf)
# 1012 "save.ml"

  | 2 ->
# 273 "save.mll"
           (Out.put tag_buff " " ; tagout lexbuf)
# 1017 "save.ml"

  | 3 ->
# 274 "save.mll"
         (Out.put tag_buff ">" ; tagout lexbuf)
# 1022 "save.ml"

  | 4 ->
# 275 "save.mll"
         (Out.put tag_buff "<" ; tagout lexbuf)
# 1027 "save.ml"

  | 5 ->
# 276 "save.mll"
       (Out.blit tag_buff lexbuf ; tagout lexbuf)
# 1032 "save.ml"

  | 6 ->
# 277 "save.mll"
       (Out.to_string tag_buff)
# 1037 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_tagout_rec lexbuf __ocaml_lex_state

and intag lexbuf =
   __ocaml_lex_intag_rec lexbuf 153
and __ocaml_lex_intag_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 280 "save.mll"
       (tagout lexbuf)
# 1049 "save.ml"

  | 1 ->
# 281 "save.mll"
       (instring lexbuf)
# 1054 "save.ml"

  | 2 ->
# 282 "save.mll"
       (intag lexbuf)
# 1059 "save.ml"

  | 3 ->
# 283 "save.mll"
       (Out.to_string tag_buff)
# 1064 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_intag_rec lexbuf __ocaml_lex_state

and instring lexbuf =
   __ocaml_lex_instring_rec lexbuf 158
and __ocaml_lex_instring_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 286 "save.mll"
       (intag lexbuf)
# 1076 "save.ml"

  | 1 ->
# 287 "save.mll"
           (instring lexbuf)
# 1081 "save.ml"

  | 2 ->
# 288 "save.mll"
       (instring lexbuf)
# 1086 "save.ml"

  | 3 ->
# 289 "save.mll"
       (Out.to_string tag_buff)
# 1091 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_instring_rec lexbuf __ocaml_lex_state

and checklimits lexbuf =
   __ocaml_lex_checklimits_rec lexbuf 164
and __ocaml_lex_checklimits_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 293 "save.mll"
               (true)
# 1103 "save.ml"

  | 1 ->
# 294 "save.mll"
               (false)
# 1108 "save.ml"

  | 2 ->
# 295 "save.mll"
               (false)
# 1113 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_checklimits_rec lexbuf __ocaml_lex_state

and eat_delim_init delim next i lexbuf =
   __ocaml_lex_eat_delim_init_rec delim next i lexbuf 180
and __ocaml_lex_eat_delim_init_rec delim next i lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 298 "save.mll"
      (raise Eof)
# 1125 "save.ml"

  | 1 ->
# 300 "save.mll"
    ( put_echo_char '{' ;
      incr brace_nesting ;
      let r = arg2 lexbuf in
      check_comment lexbuf ;
      if if_next_string delim lexbuf then begin
        skip_delim_rec  delim 0 lexbuf ;
        r
      end else begin
        Out.put_char arg_buff '{' ;
        Out.put arg_buff r ;
        Out.put_char arg_buff '}' ;
        eat_delim_rec delim next 0 lexbuf
      end)
# 1142 "save.ml"

  | 2 ->
# 313 "save.mll"
      (eat_delim_rec  delim next i lexbuf)
# 1147 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_eat_delim_init_rec delim next i lexbuf __ocaml_lex_state

and eat_delim_rec delim next i lexbuf =
   __ocaml_lex_eat_delim_rec_rec delim next i lexbuf 183
and __ocaml_lex_eat_delim_rec_rec delim next i lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 317 "save.mll"
  (
    put_echo "\\{" ;
    match kmp_char delim next i '\\' with
    | Stop _ ->
        error "Delimitors cannot end with ``\\''"
    | Continue i -> match  kmp_char delim next i '{' with
      | Stop s -> s
      | Continue i ->  eat_delim_rec delim next i lexbuf)
# 1166 "save.ml"

  | 1 ->
# 327 "save.mll"
  (
    put_echo_char '{' ;
    Out.put arg_buff (if i > 0 then String.sub delim 0 i else "") ;
    Out.put_char arg_buff '{' ;
    incr brace_nesting ;
    let r = arg2 lexbuf in
    Out.put arg_buff r ;
    Out.put_char arg_buff '}' ;
    eat_delim_rec delim next 0 lexbuf
   )
# 1180 "save.ml"

  | 2 ->
# 338 "save.mll"
  (
    let c = lexeme_char lexbuf 0 in
    put_echo_char c ;
    match kmp_char delim next i c with
    | Stop s -> s
    | Continue i -> eat_delim_rec delim next i lexbuf)
# 1190 "save.ml"

  | 3 ->
# 345 "save.mll"
    (error
       ("End of file in delimited argument, read:\n" ^
        Out.to_string echo_buff))
# 1197 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_eat_delim_rec_rec delim next i lexbuf __ocaml_lex_state

and skip_delim_init delim i lexbuf =
   __ocaml_lex_skip_delim_init_rec delim i lexbuf 189
and __ocaml_lex_skip_delim_init_rec delim i lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 350 "save.mll"
             (skip_delim_init delim i lexbuf)
# 1209 "save.ml"

  | 1 ->
# 351 "save.mll"
           (skip_delim_rec delim i lexbuf)
# 1214 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_delim_init_rec delim i lexbuf __ocaml_lex_state

and skip_delim_rec delim i lexbuf =
   __ocaml_lex_skip_delim_rec_rec delim i lexbuf 191
and __ocaml_lex_skip_delim_rec_rec delim i lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 355 "save.mll"
  (
    let c = lexeme_char lexbuf 0 in
    put_echo_char c ;
    if c <> delim.[i] then
      raise (Delim delim) ;
    if i+1 < String.length delim then
      skip_delim_rec delim (i+1) lexbuf)
# 1232 "save.ml"

  | 1 ->
# 363 "save.mll"
    ( error ("End of file checking delimiter ``"^delim^"''"))
# 1237 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_delim_rec_rec delim i lexbuf __ocaml_lex_state

and check_equal lexbuf =
   __ocaml_lex_check_equal_rec lexbuf 194
and __ocaml_lex_check_equal_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 365 "save.mll"
      (true)
# 1249 "save.ml"

  | 1 ->
# 366 "save.mll"
      (false)
# 1254 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_check_equal_rec lexbuf __ocaml_lex_state

and do_xyarg lexbuf =
   __ocaml_lex_do_xyarg_rec lexbuf 196
and __ocaml_lex_do_xyarg_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 370 "save.mll"
    (let lxm = Lexing.lexeme_char lexbuf 0 in
    put_both_char lxm ;
    do_xyarg lexbuf)
# 1268 "save.ml"

  | 1 ->
# 373 "save.mll"
      (raise Eof)
# 1273 "save.ml"

  | 2 ->
# 374 "save.mll"
      (Out.to_string arg_buff)
# 1278 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_do_xyarg_rec lexbuf __ocaml_lex_state

and simple_delim c lexbuf =
   __ocaml_lex_simple_delim_rec c lexbuf 199
and __ocaml_lex_simple_delim_rec c lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 377 "save.mll"
       x
# 1291 "save.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 378 "save.mll"
  (if c = x then begin
    put_echo_char x ;
    Out.to_string arg_buff
  end else begin
    put_both_char x ;
    simple_delim c lexbuf
  end
  )
# 1302 "save.ml"

  | 1 ->
# 387 "save.mll"
  (error (Printf.sprintf "End of file in simple delim '%c'" c))
# 1307 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_simple_delim_rec c lexbuf __ocaml_lex_state

and gobble_one_char lexbuf =
   __ocaml_lex_gobble_one_char_rec lexbuf 202
and __ocaml_lex_gobble_one_char_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 390 "save.mll"
      (())
# 1319 "save.ml"

  | 1 ->
# 391 "save.mll"
      (fatal ("Gobble at end of file"))
# 1324 "save.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_gobble_one_char_rec lexbuf __ocaml_lex_state

;;

# 394 "save.mll"
 

let arg = Saver.String.arg
let arg_list = Saver.List.arg
let opt = Saver.String.opt
let opt_list = Saver.List.opt
let start_echo = SaveUtils.start_echo
let get_echo = SaveUtils.get_echo
exception NoOpt =  SaveUtils.NoOpt
exception LimitEof = SaveUtils.LimitEof
exception Eof =  SaveUtils.Eof
let seen_par = SaveUtils.seen_par
let set_verbose = SaveUtils.set_verbose
let empty_buffs = SaveUtils.empty_buffs
exception Delim = SaveUtils.Delim
exception Error = SaveUtils.Error

let init_kmp s =
  let l = String.length s in
  let r = Array.make l (-1) in  
  let rec init_rec i j =

    if i+1 < l then begin
      if j = -1 || s.[i]=s.[j] then begin
        r.(i+1) <- j+1 ;
        init_rec (i+1) (j+1)
      end else
        init_rec i r.(j)
    end in
  init_rec 0 (-1) ;
  r

let with_delim delim lexbuf =
  let next = init_kmp delim  in
  check_comment lexbuf ;
  let r = eat_delim_init delim next 0 lexbuf in
  r

and skip_delim delim lexbuf =
  check_comment lexbuf ;
  skip_delim_init delim 0 lexbuf

let skip_blanks_init lexbuf =
  let _ = skip_blanks lexbuf in
  ()

let arg_verbatim lexbuf =
  ignore (skip_blanks lexbuf) ;
  match first_char lexbuf with
  | '{' ->
       incr brace_nesting ;
       arg2 lexbuf
  | c -> simple_delim c lexbuf


let xy_arg lexbuf = do_xyarg lexbuf

# 1389 "save.ml"
