/* Autogenerated file, DO NOT EDIT manually! generated by oa-metricset-codegen.py */
// SPDX-License-Identifier: MIT
/*
 * Copyright © 2024 Intel Corporation
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "xe_oa_metrics_pvc.h"
#include "xe_oa_equations.h"
#include "xe_oa_registers_pvc.h"


static void
pvc_add_compute_basic_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "8d637649-e8f5-4f80-83a4-6575b05d52d8";
    metric_set->counters = calloc(33, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    pvc_compute_basic_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = pvc__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = pvc__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = pvc__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EU_ACTIVE_CYCLES",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_active_cycles__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU Pipe Active",
                .symbol_name = "EU_INST_EXECUTED_ALU0_ALL",
                .desc = "The percentage of time in which EU FPU INT64 pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_inst_executed_alu0_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EU_INST_EXECUTED_ALU1_ALL",
                .desc = "The percentage of time in which EU EM INT pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_inst_executed_alu1_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EM JEU Instruction",
                .symbol_name = "EU_INST_EXECUTED_CONTROL_ALL",
                .desc = "The percentage of time in which JEU instruction were processed actively on EM INT pipeline.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_inst_executed_control_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "Send Pipe Active",
                .symbol_name = "EU_INST_EXECUTED_SEND_ALL",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_inst_executed_send_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "SYS Pipe Active",
                .symbol_name = "EU_INST_EXECUTED_SYSTOLIC_ALL",
                .desc = "The percentage of time in which EU SYS pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_inst_executed_systolic_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "EU_PIPE_ALU0_AND_ALU1_ACTIVE_CYCLES",
                .desc = "The percentage of time in which EU EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_pipe_alu0_and_alu1_active_cycles__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "SYS And FPU Pipes Active",
                .symbol_name = "EU_PIPE_ALU0_AND_SYSTOLIC_ACTIVE_CYCLES",
                .desc = "The percentage of time in which EU Systolic and FPU INT64 pipelines were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_pipe_alu0_and_systolic_active_cycles__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EU_STALL_CYCLES",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_stall_cycles__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EU_THREADS_OCCUPANCY_ALL",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__eu_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI0",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0",
                .desc = "The The percentage of time in which SQ 0 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI1",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1",
                .desc = "The The percentage of time in which SQ 1 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI12",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI12",
                .desc = "The The percentage of time in which SQ 12 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi12__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI2",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI2",
                .desc = "The The percentage of time in which SQ 2 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI3",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI3",
                .desc = "The The percentage of time in which SQ 3 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI4",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI4",
                .desc = "The The percentage of time in which SQ 4 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi4__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI8",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI8",
                .desc = "The The percentage of time in which SQ 8 is filled above a threshold (usually 48 entries)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_memory_request_queue_full_sqidi8__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = pvc__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = pvc__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = pvc__compute_basic__gti_read_throughput__read,
                .max_uint64 = pvc__compute_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = pvc__compute_basic__gti_write_throughput__read,
                .max_uint64 = pvc__compute_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .desc = "Host reads to GPU local (HBM) memory (downstream)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__host_to_gpumem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .desc = "Host writes to GPU local (HBM) memory (downstream)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__host_to_gpumem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SYSMEM_TRANSACTION_READ",
                .symbol_name = "SYSMEM_TRANSACTION_READ",
                .desc = "The number of system memory reads (upstream)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__sysmem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SYSMEM_TRANSACTION_WRITE",
                .symbol_name = "SYSMEM_TRANSACTION_WRITE",
                .desc = "The number of system memory writes  (upstream)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__sysmem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = pvc__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = pvc__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = pvc__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Reads",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__slm_reads__read,
                .max_uint64 = pvc__compute_basic__slm_reads__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes to shared local memory.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__compute_basic__slm_writes__read,
                .max_uint64 = pvc__compute_basic__slm_writes__max,
                .group = "L3/Data Port/SLM",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 33);
}

static bool pvc_test_oa_L3_BANK_INPUT_AVAILABLE_L3BANK0_availability(const struct intel_xe_perf *perf) {
    if (1) {
        return true;
    }
    return false;
}
static bool pvc_test_oa_L3_OUTPUT_READY_L3BANK0_availability(const struct intel_xe_perf *perf) {
    if (1) {
        return true;
    }
    return false;
}
static bool pvc_test_oa_L3_READ_L3BANK0_availability(const struct intel_xe_perf *perf) {
    if (1) {
        return true;
    }
    return false;
}
static bool pvc_test_oa_L3_WRITE_L3BANK0_availability(const struct intel_xe_perf *perf) {
    if (1) {
        return true;
    }
    return false;
}
static bool pvc_test_oa_THREADGROUP_DISPATCH_QUEUE0_ACTIVE_CYCLES_DUALSUBSLICE0_availability(const struct intel_xe_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool pvc_test_oa_THREADGROUP_DISPATCH_QUEUE1_ACTIVE_CYCLES_DUALSUBSLICE0_availability(const struct intel_xe_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}

static void
pvc_add_test_oa_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "339a376a-4696-4e0d-812a-5fd13b0e1aa8";
    metric_set->counters = calloc(26, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    pvc_test_oa_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = pvc__test_oa__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which EU EM INT pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "EmFpuActive",
                .desc = "The percentage of time in which EU EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__em_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which EU FPU INT64 pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = pvc__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = pvc__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Gti Read Transactions",
                .symbol_name = "GtiReadTransactions",
                .desc = "The total number of read transactions sent to GTI interfaces",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = pvc__test_oa__gti_read_transactions__read,
                .max_uint64 = pvc__test_oa__gti_read_transactions__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Transactions",
                .symbol_name = "GtiWriteTransactions",
                .desc = "The total number of write transactions sent to GTI interfaces",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = pvc__test_oa__gti_write_transactions__read,
                .max_uint64 = pvc__test_oa__gti_write_transactions__max,
                .group = "GTI",
            },

            {
                .name = "L3_BANK_INPUT_AVAILABLE _L3BANK0",
                .symbol_name = "L3_BANK_INPUT_AVAILABLE_L3BANK0",
                .desc = "The percentage of time in which l3 bank 0 input is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__l3_bank_input_available_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = pvc_test_oa_L3_BANK_INPUT_AVAILABLE_L3BANK0_availability,
            },

            {
                .name = "L3_OUTPUT_READY _L3BANK0",
                .symbol_name = "L3_OUTPUT_READY_L3BANK0",
                .desc = "The percentage of time in which l3 bank 0 output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__l3_output_ready_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = pvc_test_oa_L3_OUTPUT_READY_L3BANK0_availability,
            },

            {
                .name = "L3_READ _L3BANK0",
                .symbol_name = "L3_READ_L3BANK0",
                .desc = "The number of L3 bank 0 read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = pvc_test_oa_L3_READ_L3BANK0_availability,
            },

            {
                .name = "L3_WRITE _L3BANK0",
                .symbol_name = "L3_WRITE_L3BANK0",
                .desc = "The number of L3 Bank 0 write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = pvc__test_oa__l3_write_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GTI/L3",
                .availability = pvc_test_oa_L3_WRITE_L3BANK0_availability,
            },

            {
                .name = "SYS Pipe Active",
                .symbol_name = "SysActive",
                .desc = "The percentage of time in which EU SYS pipeline was actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__sys_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "SYS And FPU Pipes Active",
                .symbol_name = "SysFpuActive",
                .desc = "The percentage of time in which EU Systolic and FPU INT64 pipelines were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__sys_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "THREADGROUP_DISPATCH_QUEUE0_ACTIVE_CYCLES _DUALSUBSLICE0",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE0_ACTIVE_CYCLES_DUALSUBSLICE0",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch in thread dispatcher 0 queue 0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__threadgroup_dispatch_queue0_active_cycles_dualsubslice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = pvc_test_oa_THREADGROUP_DISPATCH_QUEUE0_ACTIVE_CYCLES_DUALSUBSLICE0_availability,
            },

            {
                .name = "THREADGROUP_DISPATCH_QUEUE1_ACTIVE_CYCLES _DUALSUBSLICE0",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE1_ACTIVE_CYCLES_DUALSUBSLICE0",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch in thread dispatcher 0 queue 1",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = pvc__test_oa__threadgroup_dispatch_queue1_active_cycles_dualsubslice0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
                .availability = pvc_test_oa_THREADGROUP_DISPATCH_QUEUE1_ACTIVE_CYCLES_DUALSUBSLICE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 26);
}

void
intel_xe_perf_load_metrics_pvc(struct intel_xe_perf *perf)
{
    pvc_add_compute_basic_metric_set(perf);
    pvc_add_test_oa_metric_set(perf);
}
