//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/json_to_metadata/v3/json_to_metadata.proto

package json_to_metadatav3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on JsonToMetadata with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JsonToMetadata) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JsonToMetadata with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JsonToMetadataMultiError,
// or nil if none found.
func (m *JsonToMetadata) ValidateAll() error {
	return m.validate(true)
}

func (m *JsonToMetadata) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRequestRules()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadataValidationError{
					field:  "RequestRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadataValidationError{
					field:  "RequestRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequestRules()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadataValidationError{
				field:  "RequestRules",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetResponseRules()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadataValidationError{
					field:  "ResponseRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadataValidationError{
					field:  "ResponseRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponseRules()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadataValidationError{
				field:  "ResponseRules",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return JsonToMetadataMultiError(errors)
	}

	return nil
}

// JsonToMetadataMultiError is an error wrapping multiple validation errors
// returned by JsonToMetadata.ValidateAll() if the designated constraints
// aren't met.
type JsonToMetadataMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JsonToMetadataMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JsonToMetadataMultiError) AllErrors() []error { return m }

// JsonToMetadataValidationError is the validation error returned by
// JsonToMetadata.Validate if the designated constraints aren't met.
type JsonToMetadataValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JsonToMetadataValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JsonToMetadataValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JsonToMetadataValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JsonToMetadataValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JsonToMetadataValidationError) ErrorName() string { return "JsonToMetadataValidationError" }

// Error satisfies the builtin error interface
func (e JsonToMetadataValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJsonToMetadata.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JsonToMetadataValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JsonToMetadataValidationError{}

// Validate checks the field values on JsonToMetadata_KeyValuePair with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JsonToMetadata_KeyValuePair) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JsonToMetadata_KeyValuePair with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JsonToMetadata_KeyValuePairMultiError, or nil if none found.
func (m *JsonToMetadata_KeyValuePair) ValidateAll() error {
	return m.validate(true)
}

func (m *JsonToMetadata_KeyValuePair) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for MetadataNamespace

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := JsonToMetadata_KeyValuePairValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := JsonToMetadata_ValueType_name[int32(m.GetType())]; !ok {
		err := JsonToMetadata_KeyValuePairValidationError{
			field:  "Type",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for PreserveExistingMetadataValue

	switch v := m.ValueType.(type) {
	case *JsonToMetadata_KeyValuePair_Value:
		if v == nil {
			err := JsonToMetadata_KeyValuePairValidationError{
				field:  "ValueType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetValue()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JsonToMetadata_KeyValuePairValidationError{
						field:  "Value",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JsonToMetadata_KeyValuePairValidationError{
						field:  "Value",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetValue()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JsonToMetadata_KeyValuePairValidationError{
					field:  "Value",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return JsonToMetadata_KeyValuePairMultiError(errors)
	}

	return nil
}

// JsonToMetadata_KeyValuePairMultiError is an error wrapping multiple
// validation errors returned by JsonToMetadata_KeyValuePair.ValidateAll() if
// the designated constraints aren't met.
type JsonToMetadata_KeyValuePairMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JsonToMetadata_KeyValuePairMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JsonToMetadata_KeyValuePairMultiError) AllErrors() []error { return m }

// JsonToMetadata_KeyValuePairValidationError is the validation error returned
// by JsonToMetadata_KeyValuePair.Validate if the designated constraints
// aren't met.
type JsonToMetadata_KeyValuePairValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JsonToMetadata_KeyValuePairValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JsonToMetadata_KeyValuePairValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JsonToMetadata_KeyValuePairValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JsonToMetadata_KeyValuePairValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JsonToMetadata_KeyValuePairValidationError) ErrorName() string {
	return "JsonToMetadata_KeyValuePairValidationError"
}

// Error satisfies the builtin error interface
func (e JsonToMetadata_KeyValuePairValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJsonToMetadata_KeyValuePair.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JsonToMetadata_KeyValuePairValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JsonToMetadata_KeyValuePairValidationError{}

// Validate checks the field values on JsonToMetadata_Selector with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JsonToMetadata_Selector) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JsonToMetadata_Selector with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JsonToMetadata_SelectorMultiError, or nil if none found.
func (m *JsonToMetadata_Selector) ValidateAll() error {
	return m.validate(true)
}

func (m *JsonToMetadata_Selector) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Selector.(type) {
	case *JsonToMetadata_Selector_Key:
		if v == nil {
			err := JsonToMetadata_SelectorValidationError{
				field:  "Selector",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if utf8.RuneCountInString(m.GetKey()) < 1 {
			err := JsonToMetadata_SelectorValidationError{
				field:  "Key",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return JsonToMetadata_SelectorMultiError(errors)
	}

	return nil
}

// JsonToMetadata_SelectorMultiError is an error wrapping multiple validation
// errors returned by JsonToMetadata_Selector.ValidateAll() if the designated
// constraints aren't met.
type JsonToMetadata_SelectorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JsonToMetadata_SelectorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JsonToMetadata_SelectorMultiError) AllErrors() []error { return m }

// JsonToMetadata_SelectorValidationError is the validation error returned by
// JsonToMetadata_Selector.Validate if the designated constraints aren't met.
type JsonToMetadata_SelectorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JsonToMetadata_SelectorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JsonToMetadata_SelectorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JsonToMetadata_SelectorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JsonToMetadata_SelectorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JsonToMetadata_SelectorValidationError) ErrorName() string {
	return "JsonToMetadata_SelectorValidationError"
}

// Error satisfies the builtin error interface
func (e JsonToMetadata_SelectorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJsonToMetadata_Selector.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JsonToMetadata_SelectorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JsonToMetadata_SelectorValidationError{}

// Validate checks the field values on JsonToMetadata_Rule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JsonToMetadata_Rule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JsonToMetadata_Rule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JsonToMetadata_RuleMultiError, or nil if none found.
func (m *JsonToMetadata_Rule) ValidateAll() error {
	return m.validate(true)
}

func (m *JsonToMetadata_Rule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetSelectors()) < 1 {
		err := JsonToMetadata_RuleValidationError{
			field:  "Selectors",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetSelectors() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JsonToMetadata_RuleValidationError{
						field:  fmt.Sprintf("Selectors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JsonToMetadata_RuleValidationError{
						field:  fmt.Sprintf("Selectors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JsonToMetadata_RuleValidationError{
					field:  fmt.Sprintf("Selectors[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetOnPresent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnPresent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnPresent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadata_RuleValidationError{
				field:  "OnPresent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOnMissing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnMissing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnMissing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadata_RuleValidationError{
				field:  "OnMissing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOnError()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnError",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadata_RuleValidationError{
					field:  "OnError",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOnError()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadata_RuleValidationError{
				field:  "OnError",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return JsonToMetadata_RuleMultiError(errors)
	}

	return nil
}

// JsonToMetadata_RuleMultiError is an error wrapping multiple validation
// errors returned by JsonToMetadata_Rule.ValidateAll() if the designated
// constraints aren't met.
type JsonToMetadata_RuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JsonToMetadata_RuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JsonToMetadata_RuleMultiError) AllErrors() []error { return m }

// JsonToMetadata_RuleValidationError is the validation error returned by
// JsonToMetadata_Rule.Validate if the designated constraints aren't met.
type JsonToMetadata_RuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JsonToMetadata_RuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JsonToMetadata_RuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JsonToMetadata_RuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JsonToMetadata_RuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JsonToMetadata_RuleValidationError) ErrorName() string {
	return "JsonToMetadata_RuleValidationError"
}

// Error satisfies the builtin error interface
func (e JsonToMetadata_RuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJsonToMetadata_Rule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JsonToMetadata_RuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JsonToMetadata_RuleValidationError{}

// Validate checks the field values on JsonToMetadata_MatchRules with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JsonToMetadata_MatchRules) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JsonToMetadata_MatchRules with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JsonToMetadata_MatchRulesMultiError, or nil if none found.
func (m *JsonToMetadata_MatchRules) ValidateAll() error {
	return m.validate(true)
}

func (m *JsonToMetadata_MatchRules) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRules()) < 1 {
		err := JsonToMetadata_MatchRulesValidationError{
			field:  "Rules",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JsonToMetadata_MatchRulesValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JsonToMetadata_MatchRulesValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JsonToMetadata_MatchRulesValidationError{
					field:  fmt.Sprintf("Rules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetAllowContentTypes() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 1 {
			err := JsonToMetadata_MatchRulesValidationError{
				field:  fmt.Sprintf("AllowContentTypes[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for AllowEmptyContentType

	if all {
		switch v := interface{}(m.GetAllowContentTypesRegex()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JsonToMetadata_MatchRulesValidationError{
					field:  "AllowContentTypesRegex",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JsonToMetadata_MatchRulesValidationError{
					field:  "AllowContentTypesRegex",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAllowContentTypesRegex()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JsonToMetadata_MatchRulesValidationError{
				field:  "AllowContentTypesRegex",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return JsonToMetadata_MatchRulesMultiError(errors)
	}

	return nil
}

// JsonToMetadata_MatchRulesMultiError is an error wrapping multiple validation
// errors returned by JsonToMetadata_MatchRules.ValidateAll() if the
// designated constraints aren't met.
type JsonToMetadata_MatchRulesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JsonToMetadata_MatchRulesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JsonToMetadata_MatchRulesMultiError) AllErrors() []error { return m }

// JsonToMetadata_MatchRulesValidationError is the validation error returned by
// JsonToMetadata_MatchRules.Validate if the designated constraints aren't met.
type JsonToMetadata_MatchRulesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JsonToMetadata_MatchRulesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JsonToMetadata_MatchRulesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JsonToMetadata_MatchRulesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JsonToMetadata_MatchRulesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JsonToMetadata_MatchRulesValidationError) ErrorName() string {
	return "JsonToMetadata_MatchRulesValidationError"
}

// Error satisfies the builtin error interface
func (e JsonToMetadata_MatchRulesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJsonToMetadata_MatchRules.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JsonToMetadata_MatchRulesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JsonToMetadata_MatchRulesValidationError{}
