// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "istio.io/client-go/pkg/apis/telemetry/v1alpha1"
	telemetryv1alpha1 "istio.io/client-go/pkg/applyconfiguration/telemetry/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTelemetries implements TelemetryInterface
type FakeTelemetries struct {
	Fake *FakeTelemetryV1alpha1
	ns   string
}

var telemetriesResource = v1alpha1.SchemeGroupVersion.WithResource("telemetries")

var telemetriesKind = v1alpha1.SchemeGroupVersion.WithKind("Telemetry")

// Get takes name of the telemetry, and returns the corresponding telemetry object, and an error if there is any.
func (c *FakeTelemetries) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Telemetry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(telemetriesResource, c.ns, name), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// List takes label and field selectors, and returns the list of Telemetries that match those selectors.
func (c *FakeTelemetries) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TelemetryList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(telemetriesResource, telemetriesKind, c.ns, opts), &v1alpha1.TelemetryList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.TelemetryList{ListMeta: obj.(*v1alpha1.TelemetryList).ListMeta}
	for _, item := range obj.(*v1alpha1.TelemetryList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested telemetries.
func (c *FakeTelemetries) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(telemetriesResource, c.ns, opts))

}

// Create takes the representation of a telemetry and creates it.  Returns the server's representation of the telemetry, and an error, if there is any.
func (c *FakeTelemetries) Create(ctx context.Context, telemetry *v1alpha1.Telemetry, opts v1.CreateOptions) (result *v1alpha1.Telemetry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(telemetriesResource, c.ns, telemetry), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// Update takes the representation of a telemetry and updates it. Returns the server's representation of the telemetry, and an error, if there is any.
func (c *FakeTelemetries) Update(ctx context.Context, telemetry *v1alpha1.Telemetry, opts v1.UpdateOptions) (result *v1alpha1.Telemetry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(telemetriesResource, c.ns, telemetry), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTelemetries) UpdateStatus(ctx context.Context, telemetry *v1alpha1.Telemetry, opts v1.UpdateOptions) (*v1alpha1.Telemetry, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(telemetriesResource, "status", c.ns, telemetry), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// Delete takes name of the telemetry and deletes it. Returns an error if one occurs.
func (c *FakeTelemetries) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(telemetriesResource, c.ns, name, opts), &v1alpha1.Telemetry{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTelemetries) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(telemetriesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.TelemetryList{})
	return err
}

// Patch applies the patch and returns the patched telemetry.
func (c *FakeTelemetries) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Telemetry, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(telemetriesResource, c.ns, name, pt, data, subresources...), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied telemetry.
func (c *FakeTelemetries) Apply(ctx context.Context, telemetry *telemetryv1alpha1.TelemetryApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.Telemetry, err error) {
	if telemetry == nil {
		return nil, fmt.Errorf("telemetry provided to Apply must not be nil")
	}
	data, err := json.Marshal(telemetry)
	if err != nil {
		return nil, err
	}
	name := telemetry.Name
	if name == nil {
		return nil, fmt.Errorf("telemetry.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(telemetriesResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeTelemetries) ApplyStatus(ctx context.Context, telemetry *telemetryv1alpha1.TelemetryApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.Telemetry, err error) {
	if telemetry == nil {
		return nil, fmt.Errorf("telemetry provided to Apply must not be nil")
	}
	data, err := json.Marshal(telemetry)
	if err != nil {
		return nil, err
	}
	name := telemetry.Name
	if name == nil {
		return nil, fmt.Errorf("telemetry.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(telemetriesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.Telemetry{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Telemetry), err
}
