/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// HTTPRouteFilterApplyConfiguration represents a declarative configuration of the HTTPRouteFilter type for use
// with apply.
type HTTPRouteFilterApplyConfiguration struct {
	Type                   *apisv1.HTTPRouteFilterType                  `json:"type,omitempty"`
	RequestHeaderModifier  *HTTPHeaderFilterApplyConfiguration          `json:"requestHeaderModifier,omitempty"`
	ResponseHeaderModifier *HTTPHeaderFilterApplyConfiguration          `json:"responseHeaderModifier,omitempty"`
	RequestMirror          *HTTPRequestMirrorFilterApplyConfiguration   `json:"requestMirror,omitempty"`
	RequestRedirect        *HTTPRequestRedirectFilterApplyConfiguration `json:"requestRedirect,omitempty"`
	URLRewrite             *HTTPURLRewriteFilterApplyConfiguration      `json:"urlRewrite,omitempty"`
	CORS                   *HTTPCORSFilterApplyConfiguration            `json:"cors,omitempty"`
	ExternalAuth           *HTTPExternalAuthFilterApplyConfiguration    `json:"externalAuth,omitempty"`
	ExtensionRef           *LocalObjectReferenceApplyConfiguration      `json:"extensionRef,omitempty"`
}

// HTTPRouteFilterApplyConfiguration constructs a declarative configuration of the HTTPRouteFilter type for use with
// apply.
func HTTPRouteFilter() *HTTPRouteFilterApplyConfiguration {
	return &HTTPRouteFilterApplyConfiguration{}
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithType(value apisv1.HTTPRouteFilterType) *HTTPRouteFilterApplyConfiguration {
	b.Type = &value
	return b
}

// WithRequestHeaderModifier sets the RequestHeaderModifier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestHeaderModifier field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithRequestHeaderModifier(value *HTTPHeaderFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.RequestHeaderModifier = value
	return b
}

// WithResponseHeaderModifier sets the ResponseHeaderModifier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResponseHeaderModifier field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithResponseHeaderModifier(value *HTTPHeaderFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.ResponseHeaderModifier = value
	return b
}

// WithRequestMirror sets the RequestMirror field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestMirror field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithRequestMirror(value *HTTPRequestMirrorFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.RequestMirror = value
	return b
}

// WithRequestRedirect sets the RequestRedirect field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestRedirect field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithRequestRedirect(value *HTTPRequestRedirectFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.RequestRedirect = value
	return b
}

// WithURLRewrite sets the URLRewrite field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URLRewrite field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithURLRewrite(value *HTTPURLRewriteFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.URLRewrite = value
	return b
}

// WithCORS sets the CORS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CORS field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithCORS(value *HTTPCORSFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.CORS = value
	return b
}

// WithExternalAuth sets the ExternalAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExternalAuth field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithExternalAuth(value *HTTPExternalAuthFilterApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.ExternalAuth = value
	return b
}

// WithExtensionRef sets the ExtensionRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExtensionRef field is set to the value of the last call.
func (b *HTTPRouteFilterApplyConfiguration) WithExtensionRef(value *LocalObjectReferenceApplyConfiguration) *HTTPRouteFilterApplyConfiguration {
	b.ExtensionRef = value
	return b
}
