package spdxlicenses

// licenseRanges returns a list of license ranges.
//
// Ranges are organized into groups (referred to as license groups) of the same base license (e.g. GPL).
// Groups have sub-groups of license versions (referred to as the range) where each member is considered
// to be the same version (e.g. {GPL-2.0, GPL-2.0-only}). The sub-groups are in ascending order within
// the license group, such that the first sub-group is considered to be less than the second sub-group,
// and so on. (e.g. {{GPL-1.0}, {GPL-2.0, GPL-2.0-only}} implies {GPL-1.0} < {GPL-2.0, GPL-2.0-only}).
func LicenseRanges() [][][]string {
	return [][][]string{
		{
			{
				"AFL-1.1",
			},
			{
				"AFL-1.2",
			},
			{
				"AFL-2.0",
			},
			{
				"AFL-2.1",
			},
			{
				"AFL-3.0",
			},
		},
		{
			{
				"AGPL-1.0",
			},
			{
				"AGPL-3.0",
				"AGPL-3.0-only",
			},
		},
		{
			{
				"Apache-1.0",
			},
			{
				"Apache-1.1",
			},
			{
				"Apache-2.0",
			},
		},
		{
			{
				"APSL-1.0",
			},
			{
				"APSL-1.1",
			},
			{
				"APSL-1.2",
			},
			{
				"APSL-2.0",
			},
		},
		{
			{
				"Artistic-1.0",
			},
			{
				"Artistic-2.0",
			},
		},
		{
			{
				"ASWF-Digital-Assets-1.0",
			},
			{
				"ASWF-Digital-Assets-1.1",
			},
		},
		{
			{
				"BitTorrent-1.0",
			},
			{
				"BitTorrent-1.1",
			},
		},
		{
			{
				"Brian-Gladman-2-Clause",
			},
			{
				"Brian-Gladman-3-Clause",
			},
		},
		{
			{
				"CC-BY-1.0",
			},
			{
				"CC-BY-2.0",
			},
			{
				"CC-BY-2.5",
			},
			{
				"CC-BY-3.0",
			},
			{
				"CC-BY-4.0",
			},
		},
		{
			{
				"CC-BY-NC-1.0",
			},
			{
				"CC-BY-NC-2.0",
			},
			{
				"CC-BY-NC-2.5",
			},
			{
				"CC-BY-NC-3.0",
			},
			{
				"CC-BY-NC-4.0",
			},
		},
		{
			{
				"CC-BY-NC-ND-1.0",
			},
			{
				"CC-BY-NC-ND-2.0",
			},
			{
				"CC-BY-NC-ND-2.5",
			},
			{
				"CC-BY-NC-ND-3.0",
			},
			{
				"CC-BY-NC-ND-4.0",
			},
		},
		{
			{
				"CC-BY-NC-SA-1.0",
			},
			{
				"CC-BY-NC-SA-2.0",
			},
			{
				"CC-BY-NC-SA-2.5",
			},
			{
				"CC-BY-NC-SA-3.0",
			},
			{
				"CC-BY-NC-SA-4.0",
			},
		},
		{
			{
				"CC-BY-ND-1.0",
			},
			{
				"CC-BY-ND-2.0",
			},
			{
				"CC-BY-ND-2.5",
			},
			{
				"CC-BY-ND-3.0",
			},
			{
				"CC-BY-ND-4.0",
			},
		},
		{
			{
				"CC-BY-SA-1.0",
			},
			{
				"CC-BY-SA-2.0",
			},
			{
				"CC-BY-SA-2.5",
			},
			{
				"CC-BY-SA-3.0",
			},
			{
				"CC-BY-SA-4.0",
			},
		},
		{
			{
				"CDDL-1.0",
			},
			{
				"CDDL-1.1",
			},
		},
		{
			{
				"CECILL-1.0",
			},
			{
				"CECILL-1.1",
			},
			{
				"CECILL-2.0",
			},
		},
		{
			{
				"DRL-1.0",
			},
			{
				"DRL-1.1",
			},
		},
		{
			{
				"ECL-1.0",
			},
			{
				"ECL-2.0",
			},
		},
		{
			{
				"EFL-1.0",
			},
			{
				"EFL-2.0",
			},
		},
		{
			{
				"EPL-1.0",
			},
			{
				"EPL-2.0",
			},
		},
		{
			{
				"EUPL-1.0",
			},
			{
				"EUPL-1.1",
			},
		},
		{
			{
				"GFDL-1.1",
				"GFDL-1.1-only",
			},
			{
				"GFDL-1.2",
				"GFDL-1.2-only",
			},
			{
				"GFDL-1.1-or-later",
				"GFDL-1.2-or-later",
				"GFDL-1.3",
				"GFDL-1.3-only",
				"GFDL-1.3-or-later",
			},
		},
		{
			{
				"GPL-1.0",
				"GPL-1.0-only",
			},
			{
				"GPL-2.0",
				"GPL-2.0-only",
			},
			{
				"GPL-1.0-or-later",
				"GPL-2.0-or-later",
				"GPL-3.0",
				"GPL-3.0-only",
				"GPL-3.0-or-later",
			},
		},
		{
			{
				"HP-1986",
			},
			{
				"HP-1989",
			},
		},
		{
			{
				"LGPL-2.0",
				"LGPL-2.0-only",
			},
			{
				"LGPL-2.1",
				"LGPL-2.1-only",
			},
			{
				"LGPL-2.0-or-later",
				"LGPL-2.1-or-later",
				"LGPL-3.0",
				"LGPL-3.0-only",
				"LGPL-3.0-or-later",
			},
		},
		{
			{
				"LPL-1.0",
			},
			{
				"LPL-1.02",
			},
		},
		{
			{
				"LPPL-1.0",
			},
			{
				"LPPL-1.1",
			},
			{
				"LPPL-1.2",
			},
			{
				"LPPL-1.3a",
			},
			{
				"LPPL-1.3c",
			},
		},
		{
			{
				"MPL-1.0",
			},
			{
				"MPL-1.1",
			},
			{
				"MPL-2.0",
			},
		},
		{
			{
				"MPL-1.0",
			},
			{
				"MPL-1.1",
			},
			{
				"MPL-2.0-no-copyleft-exception",
			},
		},
		{
			{
				"NPL-1.0",
			},
			{
				"NPL-1.1",
			},
		},
		{
			{
				"OFL-1.0",
			},
			{
				"OFL-1.1",
			},
		},
		{
			{
				"OLDAP-1.1",
			},
			{
				"OLDAP-1.2",
			},
			{
				"OLDAP-1.3",
			},
			{
				"OLDAP-1.4",
			},
			{
				"OLDAP-2.0",
			},
			{
				"OLDAP-2.0.1",
			},
			{
				"OLDAP-2.1",
			},
			{
				"OLDAP-2.2",
			},
			{
				"OLDAP-2.2.1",
			},
			{
				"OLDAP-2.2.2",
			},
			{
				"OLDAP-2.3",
			},
			{
				"OLDAP-2.4",
			},
			{
				"OLDAP-2.5",
			},
			{
				"OLDAP-2.6",
			},
			{
				"OLDAP-2.7",
			},
			{
				"OLDAP-2.8",
			},
		},
		{
			{
				"OSL-1.0",
			},
			{
				"OSL-1.1",
			},
			{
				"OSL-2.0",
			},
			{
				"OSL-2.1",
			},
			{
				"OSL-3.0",
			},
		},
		{
			{
				"PHP-3.0",
			},
			{
				"PHP-3.01",
			},
		},
		{
			{
				"RPL-1.1",
			},
			{
				"RPL-1.5",
			},
		},
		{
			{
				"SGI-B-1.0",
			},
			{
				"SGI-B-1.1",
			},
			{
				"SGI-B-2.0",
			},
		},
		{
			{
				"YPL-1.0",
			},
			{
				"YPL-1.1",
			},
		},
		{
			{
				"ZPL-1.1",
			},
			{
				"ZPL-2.0",
			},
			{
				"ZPL-2.1",
			},
		},
		{
			{
				"Zimbra-1.3",
			},
			{
				"Zimbra-1.4",
			},
		},
		{
			{
				"bzip2-1.0.5",
			},
			{
				"bzip2-1.0.6",
			},
		},
	}
}
