#ifndef SBK_KCOMPOSITEJOBWRAPPER_H
#define SBK_KCOMPOSITEJOBWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kcompositejob.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KCompositeJobWrapper : public KCompositeJob
{
public:
    KCompositeJobWrapper(::QObject * parent = nullptr);
    KCompositeJobWrapper(const KCompositeJobWrapper &) = delete;
    KCompositeJobWrapper& operator=(const KCompositeJobWrapper &) = delete;
    KCompositeJobWrapper(KCompositeJobWrapper &&) = delete;
    KCompositeJobWrapper& operator=(KCompositeJobWrapper &&) = delete;
    ~KCompositeJobWrapper() override;

    bool addSubjob(::KJob * job) override;
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool doKill() override;
    bool doResume() override;
    bool doSuspend() override;
    ::QString errorString() const override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool removeSubjob(::KJob * job) override;
    void slotInfoMessage(::KJob * job, const ::QString & message) override;
    void slotResult(::KJob * job) override;
    void start() override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 16> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KCOMPOSITEJOBWRAPPER_H
