
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <QtCore/QBuffer>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kdirwatch_wrapper.h"

// Wrappers providing overrides
#include "ksignalhandler_wrapper.h"

// Argument includes
#include <QString>
#include <kdirwatch.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDirWatch_Type = nullptr;
static PyTypeObject *Sbk_KDirWatch_TypeF(void)
{
    return _Sbk_KDirWatch_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDirWatchWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDirWatchWrapper::KDirWatchWrapper(::QObject * parent) : KDirWatch(parent)
{
}

void KDirWatchWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KDirWatch", funcName, gil, pyOverride, event);
}

void KDirWatchWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KDirWatch", funcName, gil, pyOverride, signal);
}

void KDirWatchWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KDirWatch", funcName, gil, pyOverride, event);
}

void KDirWatchWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KDirWatch", funcName, gil, pyOverride, signal);
}

bool KDirWatchWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDirWatch::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KDirWatch", funcName, gil, pyOverride, event);
}

bool KDirWatchWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KDirWatch", funcName, gil, pyOverride, watched, event);
}

void KDirWatchWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDirWatch_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KDirWatch", funcName, gil, pyOverride, event);
}

const QMetaObject *KDirWatchWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDirWatch::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDirWatchWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDirWatch::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDirWatchWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDirWatchWrapper *>(this));
    }
    return KDirWatch::qt_metacast(_clname);
}

KDirWatchWrapper::~KDirWatchWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDirWatch_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDirWatch_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDirWatch >()))
        return -1;

    KDirWatchWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KDirWatch", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDirWatch::KDirWatch(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KDirWatch(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDirWatch(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDirWatch(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDirWatchWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDirWatchWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDirWatch >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDirWatchFunc_addDir(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addDir", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addDir", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDirWatch::addDir(QString,QFlags<KDirWatch::WatchMode>=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addDir(QString,QFlags<KDirWatch::WatchMode>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KDirWatch_WatchMode_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 0; // addDir(QString,QFlags<KDirWatch::WatchMode>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addDir", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"watchModes", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KDirWatch_WatchMode_IDX])))->flagsConverter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addDir", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<KDirWatch::WatchMode> cppArg1(KDirWatch::WatchMode::WatchDirOnly);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addDir(QString,QFlags<KDirWatch::WatchMode>)
            cppSelf->addDir(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_addFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::addFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addFile(QString)
            cppSelf->addFile(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::contains(QString)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contains", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // contains(QString)const
            bool cppResult = const_cast<const ::KDirWatch *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_ctime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::ctime(QString)const->QDateTime
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // ctime(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "ctime", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ctime(QString)const
            QDateTime cppResult = const_cast<const ::KDirWatch *>(cppSelf)->ctime(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDirWatch::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_exists(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // exists()
        bool cppResult = ::KDirWatch::exists();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_internalMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalMethod()const
        KDirWatch::Method cppResult = const_cast<const ::KDirWatch *>(cppSelf)->internalMethod();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_Method_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_isStopped(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isStopped()
        bool cppResult = cppSelf->isStopped();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_removeDir(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::removeDir(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeDir(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeDir", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeDir(QString)
            cppSelf->removeDir(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_removeFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::removeFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeFile(QString)
            cppSelf->removeFile(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_restartDirScan(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::restartDirScan(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // restartDirScan(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "restartDirScan", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // restartDirScan(QString)
            bool cppResult = cppSelf->restartDirScan(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_self(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // self()
        KDirWatch * cppResult = ::KDirWatch::self();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_setCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::setCreated(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setCreated(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCreated", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCreated(QString)
            cppSelf->setCreated(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_setDeleted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::setDeleted(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDeleted(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDeleted", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDeleted(QString)
            cppSelf->setDeleted(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_setDirty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::setDirty(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDirty(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDirty", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDirty(QString)
            cppSelf->setDirty(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_startScan(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "startScan", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    if (PyArg_ParseTuple(args, "|OO:startScan", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDirWatch::startScan(bool=,bool=)
    if (numArgs == 0) {
        overloadId = 0; // startScan(bool,bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startScan(bool,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // startScan(bool,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "startScan", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"notify", 0}, {"skippedToo", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "startScan", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // startScan(bool,bool)
            cppSelf->startScan(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDirWatchFunc_stopDirScan(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDirWatch::stopDirScan(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // stopDirScan(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "stopDirScan", errInfo, SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // stopDirScan(QString)
            bool cppResult = cppSelf->stopDirScan(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDirWatchFunc_stopScan(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stopScan()
        cppSelf->stopScan();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDirWatch_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KDirWatch_EnumFlagInfo[] = {
    "Method:IntEnum",
    "WatchMode:IntFlag:WatchModes",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDirWatch_methods[] = {
    {"addDir", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_addDir), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addFile", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_addFile), METH_O, nullptr},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_contains), METH_O, nullptr},
    {"ctime", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_ctime), METH_O, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_event), METH_O, nullptr},
    {"exists", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_exists), METH_NOARGS|METH_STATIC, nullptr},
    {"internalMethod", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_internalMethod), METH_NOARGS, nullptr},
    {"isStopped", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_isStopped), METH_NOARGS, nullptr},
    {"removeDir", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_removeDir), METH_O, nullptr},
    {"removeFile", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_removeFile), METH_O, nullptr},
    {"restartDirScan", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_restartDirScan), METH_O, nullptr},
    {"self", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_self), METH_NOARGS|METH_STATIC, nullptr},
    {"setCreated", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_setCreated), METH_O, nullptr},
    {"setDeleted", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_setDeleted), METH_O, nullptr},
    {"setDirty", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_setDirty), METH_O, nullptr},
    {"startScan", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_startScan), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"stopDirScan", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_stopDirScan), METH_O, nullptr},
    {"stopScan", reinterpret_cast<PyCFunction>(Sbk_KDirWatchFunc_stopScan), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDirWatch_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDirWatchWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDirWatch_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDirWatch_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
extern "C"
{
static PyObject *Sbk_KDirWatch__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDirWatch *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    const auto idx = str.indexOf('(');
    auto *typeName = Py_TYPE(self)->tp_name;
    if (idx >= 0)
        str.replace(0, idx, typeName);
    str = str.trimmed();
    Shiboken::AutoDecRef tpDict(PepType_GetDict(Py_TYPE(self)));
    PyObject *mod = PyDict_GetItem(tpDict.object(), Shiboken::PyMagicName::module());
    if (mod != nullptr && std::strchr(typeName, '.') == nullptr)
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C


// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDirWatch_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_KDirWatch__repr__)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDirWatch_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDirWatch_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDirWatch_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDirWatch_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDirWatch_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDirWatch_spec = {
    "1:KCoreAddons.KDirWatch",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDirWatch_slots
};

} //extern "C"

static void *Sbk_KDirWatch_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDirWatch *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KDirWatch_WatchMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KDirWatch::WatchMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KDirWatch::WatchMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KDirWatch_WatchMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_WatchMode_IDX])))
        return Enum_PythonToCpp_KDirWatch_WatchMode;
    return {};
}

static PyObject *KDirWatch_WatchMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KDirWatch::WatchMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KDirWatch::WatchMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KDirWatch_WatchMode(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KDirWatch::WatchMode>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KDirWatch::WatchMode> *>(cppOut) = value;

}

static PyObject *KDirWatch_WatchMode_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KDirWatch::WatchMode> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_WatchMode_IDX]), flags.toInt());

}

static void Enum_PythonToCpp_KDirWatch_Method(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KDirWatch::Method>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KDirWatch::Method *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KDirWatch_Method_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KDirWatch_Method_IDX])))
        return Enum_PythonToCpp_KDirWatch_Method;
    return {};
}

static PyObject *KDirWatch_Method_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KDirWatch::Method>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KDirWatch::Method *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDirWatch_PythonToCpp_KDirWatch_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDirWatch_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDirWatch_PythonToCpp_KDirWatch_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDirWatch_TypeF()))
        return KDirWatch_PythonToCpp_KDirWatch_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDirWatch_PTR_CppToPython_KDirWatch(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDirWatch *>(const_cast<void *>(cppIn)), Sbk_KDirWatch_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDirWatch_SignatureStrings[] = {
    "KCoreAddons.KDirWatch(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KCoreAddons.KDirWatch.addDir(self,path:QString,watchModes:KCoreAddons.KDirWatch.WatchMode=KDirWatch.WatchMode.WatchDirOnly)",
    "KCoreAddons.KDirWatch.addFile(self,file:QString)",
    "KCoreAddons.KDirWatch.contains(self,path:QString)->bool",
    "KCoreAddons.KDirWatch.ctime(self,path:QString)->PySide6.QtCore.QDateTime",
    "KCoreAddons.KDirWatch.event(self,event:PySide6.QtCore.QEvent)->bool",
    "KCoreAddons.KDirWatch.exists()->bool",
    "KCoreAddons.KDirWatch.internalMethod(self)->KCoreAddons.KDirWatch.Method",
    "KCoreAddons.KDirWatch.isStopped(self)->bool",
    "KCoreAddons.KDirWatch.removeDir(self,path:QString)",
    "KCoreAddons.KDirWatch.removeFile(self,file:QString)",
    "KCoreAddons.KDirWatch.restartDirScan(self,path:QString)->bool",
    "KCoreAddons.KDirWatch.self()->KCoreAddons.KDirWatch",
    "KCoreAddons.KDirWatch.setCreated(self,path:QString)",
    "KCoreAddons.KDirWatch.setDeleted(self,path:QString)",
    "KCoreAddons.KDirWatch.setDirty(self,path:QString)",
    "KCoreAddons.KDirWatch.startScan(self,notify:bool=false,skippedToo:bool=false)",
    "KCoreAddons.KDirWatch.stopDirScan(self,path:QString)->bool",
    "KCoreAddons.KDirWatch.stopScan(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDirWatch_SignatureByteSize = 302;
static constexpr uint8_t KDirWatch_SignatureBytes[302] = {
    0x78, 0xda, 0x9d, 0x92, 0x41, 0x6f, 0x83, 0x30, 0x0c, 0x85, 0xef, 0xfd, 0x25, 0x20, 0x31, 0x8e,
    0x3b, 0x20, 0x31, 0x69, 0x2a, 0xdb, 0x05, 0x55, 0x1d, 0xa2, 0x52, 0xcf, 0x29, 0x31, 0x23, 0x5b,
    0x1a, 0xa3, 0xc4, 0xeb, 0xc6, 0xbf, 0x5f, 0x52, 0x44, 0x37, 0xad, 0x09, 0x1a, 0xbd, 0x19, 0xe7,
    0x7d, 0xcf, 0xc9, 0x33, 0xe5, 0x1a, 0x35, 0x3c, 0x72, 0x8e, 0xca, 0xa4, 0x65, 0x21, 0xf4, 0x9e,
    0x51, 0xd3, 0x45, 0x06, 0x64, 0x9b, 0xf4, 0x4c, 0x83, 0xa2, 0xec, 0x65, 0xa8, 0x05, 0x87, 0xfb,
    0xb4, 0x22, 0x27, 0x4d, 0xab, 0xed, 0xe1, 0x0d, 0x1a, 0xca, 0xd5, 0x87, 0x94, 0x3d, 0xe9, 0x78,
    0x55, 0xfa, 0x1c, 0x52, 0xc6, 0xb9, 0xad, 0x27, 0x23, 0xea, 0xb2, 0xaa, 0x26, 0x2d, 0xd4, 0x6b,
    0xf2, 0xe9, 0x8e, 0x37, 0xc8, 0xc1, 0x64, 0x7e, 0x72, 0x3f, 0x09, 0x72, 0x4f, 0x6f, 0xac, 0x6c,
    0x7f, 0xab, 0xe4, 0x30, 0x33, 0xfb, 0x59, 0x48, 0x18, 0x87, 0xb7, 0xb6, 0x9a, 0x86, 0x87, 0x80,
    0x06, 0x15, 0x31, 0xa1, 0xcc, 0xf5, 0x75, 0xe3, 0xbb, 0x87, 0x03, 0xa2, 0x0c, 0x71, 0x24, 0x8e,
    0xe0, 0x85, 0xfe, 0x86, 0x56, 0x30, 0x82, 0x9d, 0x15, 0x07, 0x8c, 0xe0, 0x64, 0x93, 0x1e, 0x8d,
    0xce, 0xe5, 0x55, 0xe8, 0x4f, 0xae, 0x3b, 0x7f, 0x19, 0xf8, 0x12, 0x86, 0x4c, 0x34, 0x2f, 0x12,
    0x8a, 0x40, 0x2b, 0x26, 0x37, 0x40, 0x1d, 0xf2, 0xf3, 0x44, 0x0b, 0xf8, 0xb5, 0xa3, 0x26, 0x64,
    0x64, 0x6a, 0xc2, 0xbe, 0x87, 0x8b, 0xc7, 0xcc, 0x50, 0x0d, 0x47, 0x3c, 0x81, 0xf7, 0x77, 0x88,
    0x67, 0x91, 0x65, 0x5b, 0xd4, 0x60, 0x88, 0x69, 0xb2, 0xdf, 0x75, 0xc3, 0xd4, 0xd2, 0x5d, 0x3a,
    0x79, 0x14, 0xca, 0x22, 0xc8, 0xd0, 0x5a, 0x83, 0x5d, 0x2d, 0xff, 0xff, 0xcb, 0x2c, 0x53, 0x80,
    0x84, 0xc5, 0x8c, 0xd0, 0x34, 0x2c, 0x20, 0x5c, 0x12, 0x3f, 0x31, 0x28, 0x24, 0xd1, 0x0e, 0x99,
    0x7b, 0x7e, 0xde, 0x32, 0x69, 0x20, 0x31, 0xef, 0xc2, 0x6d, 0x6f, 0x87, 0xf8, 0xab, 0x1b, 0x76,
    0xc3, 0xfe, 0xd6, 0x58, 0x2d, 0x7a, 0xe1, 0xe2, 0xd5, 0x37, 0xa6, 0x01, 0x98, 0xff
};
#endif

PyTypeObject *init_KDirWatch(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX].type;

    Shiboken::AutoDecRef Sbk_KDirWatch_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KDirWatch_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDirWatch",
        "KDirWatch*",
        &Sbk_KDirWatch_spec,
        &Shiboken::callCppDestructor< KDirWatch >,
        Sbk_KDirWatch_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KDirWatch_Type; // references _Sbk_KDirWatch_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDirWatch_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDirWatch_SignatureBytes, KDirWatch_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDirWatch_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KDirWatch_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDirWatch_PythonToCpp_KDirWatch_PTR,
        is_KDirWatch_PythonToCpp_KDirWatch_PTR_Convertible,
        KDirWatch_PTR_CppToPython_KDirWatch);

    Shiboken::Conversions::registerConverterName(converter, "KDirWatch");
    Shiboken::Conversions::registerConverterName(converter, "KDirWatch*");
    Shiboken::Conversions::registerConverterName(converter, "KDirWatch&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDirWatch).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDirWatchWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDirWatch_TypeF(), &Sbk_KDirWatch_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KDirWatch_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'WatchMode'.
    const char *WatchMode_Initializer[] = {
        "WatchDirOnly",
        "WatchFiles",
        "WatchSubDirs",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t WatchMode_InitializerValues[] = {
        uint8_t(KDirWatch::WatchMode::WatchDirOnly), //  0x00  0
        uint8_t(KDirWatch::WatchMode::WatchFiles),   //  0x01  1
        uint8_t(KDirWatch::WatchMode::WatchSubDirs)  //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KDirWatch_TypeF(),
        "1:KCoreAddons.KDirWatch.WatchMode",
        WatchMode_Initializer, WatchMode_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KDirWatch_WatchMode_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKCoreAddonsTypeStructs[SBK_QFlags_KDirWatch_WatchMode_IDX].type =
        EType;
    // Register converter for enum 'KDirWatch::WatchMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KDirWatch_WatchMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KDirWatch_WatchMode,
            is_Enum_PythonToCpp_KDirWatch_WatchMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KDirWatch::WatchMode");
        Shiboken::Conversions::registerConverterAlias(converter, "WatchMode");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KDirWatch_WatchMode_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KDirWatch_WatchMode,
            is_Enum_PythonToCpp_KDirWatch_WatchMode_Convertible);
        // Register converter for flag 'QFlags<KDirWatch::WatchMode>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KDirWatch::WatchMode>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KDirWatch::WatchModes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'WatchMode' enum/flags.

    // Initialization of enum 'Method'.
    const char *Method_Initializer[] = {
        "INotify",
        "Stat",
        "QFSWatch",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Method_InitializerValues[] = {
        uint8_t(KDirWatch::Method::INotify), //  0x00  0
        uint8_t(KDirWatch::Method::Stat),    //  0x01  1
        uint8_t(KDirWatch::Method::QFSWatch) //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KDirWatch_TypeF(),
        "1:KCoreAddons.KDirWatch.Method",
        Method_Initializer, Method_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KDirWatch_Method_IDX].type = EType;
    // Register converter for enum 'KDirWatch::Method'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KDirWatch_Method_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KDirWatch_Method,
            is_Enum_PythonToCpp_KDirWatch_Method_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KDirWatch::Method");
        Shiboken::Conversions::registerConverterAlias(converter, "Method");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Method' enum.

    PySide::Signal::registerSignals(pyType, &::KDirWatch::staticMetaObject);
    qRegisterMetaType< ::KDirWatch::WatchMode >("KDirWatch::WatchMode");
    qRegisterMetaType< ::KDirWatch::Method >("KDirWatch::Method");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDirWatch::staticMetaObject, sizeof(KDirWatchWrapper));

    return pyType;
}
