/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "autogenerateconfigureaskmenu.h"
#include "autogenerateconfigureaskdialog.h"
#include "autogenerateconfigureaskmanager.h"
#include <TextAutoGenerateText/TextAutoGenerateDialog>

#include <KLocalizedString>
#include <QMenu>

AutogenerateConfigureAskMenu::AutogenerateConfigureAskMenu(AutogenerateConfigureAskManager *manager, QObject *parent)
    : KActionMenu{parent}
    , mManager(manager)
{
    mManager->load();
    setText(i18n("Ask AI…"));
    // mMenu->setIcon(QIcon::fromTheme(QStringLiteral("document-share")));
    initializeMenu();
}

AutogenerateConfigureAskMenu::~AutogenerateConfigureAskMenu() = default;

void AutogenerateConfigureAskMenu::initializeMenu()
{
    const auto infos = mManager->askInfos();
    for (const AutogenerateConfigureAskInfo &info : infos) {
        if (info.enabled()) {
            const QString requestText = info.title();
            auto action = new QAction(requestText, this);
            connect(action, &QAction::triggered, this, [requestText, this]() {
                TextAutoGenerateText::TextAutoGenerateDialog *dlg = new TextAutoGenerateText::TextAutoGenerateDialog;
                dlg->setAttribute(Qt::WA_DeleteOnClose);
                dlg->show();
                dlg->ask(QStringLiteral("%1 %2").arg(requestText, mSelectedText));
            });
            addAction(action);
        }
    }
    auto configureAction = new QAction(QIcon::fromTheme(QStringLiteral("configure")), i18nc("@action", "Configure…"), this);
    connect(configureAction, &QAction::triggered, this, &AutogenerateConfigureAskMenu::slotConfigure);
    addSeparator();
    addAction(configureAction);
}

void AutogenerateConfigureAskMenu::slotConfigure()
{
    AutogenerateConfigureAskDialog dlg(mParentWidget);
    dlg.setAskInfos(mManager->askInfos());
    if (dlg.exec()) {
        mManager->setInfos(dlg.askInfos());
        mManager->save();
        slotRefreshMenu();
    }
}

QString AutogenerateConfigureAskMenu::selectedText() const
{
    return mSelectedText;
}

void AutogenerateConfigureAskMenu::setSelectedText(const QString &newSelectedText)
{
    mSelectedText = newSelectedText;
}

void AutogenerateConfigureAskMenu::slotRefreshMenu()
{
    menu()->clear();
    initializeMenu();
}

QWidget *AutogenerateConfigureAskMenu::parentWidget() const
{
    return mParentWidget;
}

void AutogenerateConfigureAskMenu::setParentWidget(QWidget *newParentWidget)
{
    mParentWidget = newParentWidget;
}

#include "moc_autogenerateconfigureaskmenu.cpp"
