
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmessagewidget_wrapper.h"

// Wrappers providing overrides
#include "kurllabel_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kmessagewidget.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMessageWidget_Type = nullptr;
static PyTypeObject *Sbk_KMessageWidget_TypeF(void)
{
    return _Sbk_KMessageWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMessageWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMessageWidgetWrapper::KMessageWidgetWrapper(::QWidget * parent) : KMessageWidget(parent)
{
}

KMessageWidgetWrapper::KMessageWidgetWrapper(const ::QString & text, ::QWidget * parent) : KMessageWidget(text, parent)
{
}

void KMessageWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMessageWidget", funcName, gil, pyOverride, arg__1);
}

void KMessageWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMessageWidget", funcName, gil, pyOverride, signal);
}

void KMessageWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

int KMessageWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMessageWidget", funcName, gil, pyOverride);
}

void KMessageWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMessageWidget", funcName, gil, pyOverride, signal);
}

void KMessageWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

bool KMessageWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KMessageWidget", funcName, gil, pyOverride, event);
}

bool KMessageWidgetWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMessageWidget", funcName, gil, pyOverride, watched, event);
}

void KMessageWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

bool KMessageWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMessageWidget", funcName, gil, pyOverride, next);
}

void KMessageWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

bool KMessageWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMessageWidget", funcName, gil, pyOverride);
}

int KMessageWidgetWrapper::heightForWidth(int width) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::heightForWidth(width);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMessageWidget", funcName, gil, pyOverride, width);
}

void KMessageWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMessageWidget", funcName, gil, pyOverride, painter);
}

void KMessageWidgetWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    KUrlLabelWrapper::sbk_o_initStyleOption("KMessageWidget", funcName, gil, pyOverride, option);
}

void KMessageWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

::QVariant KMessageWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMessageWidget", funcName, gil, pyOverride, arg__1);
}

void KMessageWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

int KMessageWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMessageWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KMessageWidgetWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMessageWidget", funcName, gil, pyOverride);
}

void KMessageWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

bool KMessageWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMessageWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KMessageWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMessageWidget", funcName, gil, pyOverride);
}

void KMessageWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KMessageWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMessageWidget", funcName, gil, pyOverride, offset);
}

void KMessageWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMessageWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KMessageWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMessageWidget", funcName, gil, pyOverride);
}

void KMessageWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

::QSize KMessageWidgetWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMessageWidget", funcName, gil, pyOverride);
}

void KMessageWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

void KMessageWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageWidget_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMessageWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KMessageWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMessageWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMessageWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMessageWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMessageWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMessageWidgetWrapper *>(this));
    }
    return KMessageWidget::qt_metacast(_clname);
}

KMessageWidgetWrapper::~KMessageWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMessageWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMessageWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMessageWidget >()))
        return -1;

    KMessageWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KMessageWidget", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMessageWidget::KMessageWidget(QWidget*=)
    // 1: KMessageWidget::KMessageWidget(QString,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KMessageWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KMessageWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KMessageWidget(QString,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KMessageWidget(QString,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KMessageWidget(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMessageWidget(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMessageWidgetWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMessageWidgetWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KMessageWidget(const QString &text, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMessageWidget(QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMessageWidgetWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMessageWidgetWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMessageWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMessageWidgetFunc_addAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::addAction(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // addAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addAction(QAction*)
            cppSelf->addAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_animatedHide(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // animatedHide()
        cppSelf->animatedHide();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_animatedShow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // animatedShow()
        cppSelf->animatedShow();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_clearActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearActions()
        cppSelf->clearActions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMessageWidget::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_heightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::heightForWidth(int)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // heightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "heightForWidth", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // heightForWidth(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::KMessageWidget *>(cppSelf)->::KMessageWidget::heightForWidth(cppArg0)
                : const_cast<const ::KMessageWidget *>(cppSelf)->heightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_isCloseButtonVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isCloseButtonVisible()const
        bool cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->isCloseButtonVisible();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_isHideAnimationRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isHideAnimationRunning()const
        bool cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->isHideAnimationRunning();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_isShowAnimationRunning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isShowAnimationRunning()const
        bool cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->isShowAnimationRunning();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_messageType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // messageType()const
        KMessageWidget::MessageType cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->messageType();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_MessageType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KMessageWidget *>(cppSelf)->::KMessageWidget::minimumSizeHint()
            : const_cast<const ::KMessageWidget *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMessageWidget::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // position()const
        KMessageWidget::Position cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->position();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_Position_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_removeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::removeAction(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // removeAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAction(QAction*)
            cppSelf->removeAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMessageWidget::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setCloseButtonVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setCloseButtonVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCloseButtonVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCloseButtonVisible", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCloseButtonVisible(bool)
            cppSelf->setCloseButtonVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setMessageType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setMessageType(KMessageWidget::MessageType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_MessageType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setMessageType(KMessageWidget::MessageType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMessageType", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        ::KMessageWidget::MessageType cppArg0{KMessageWidget::Positive};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMessageType(KMessageWidget::MessageType)
            cppSelf->setMessageType(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setPosition(KMessageWidget::Position)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_Position_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setPosition(KMessageWidget::Position)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPosition", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        ::KMessageWidget::Position cppArg0{KMessageWidget::Inline};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPosition(KMessageWidget::Position)
            cppSelf->setPosition(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setTextFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setTextFormat(Qt::TextFormat)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextFormat_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setTextFormat(Qt::TextFormat)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTextFormat", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        ::Qt::TextFormat cppArg0{Qt::PlainText};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTextFormat(Qt::TextFormat)
            cppSelf->setTextFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_setWordWrap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageWidget::setWordWrap(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWordWrap(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWordWrap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWordWrap(bool)
            cppSelf->setWordWrap(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageWidgetFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KMessageWidget *>(cppSelf)->::KMessageWidget::sizeHint()
            : const_cast<const ::KMessageWidget *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_textFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // textFormat()const
        Qt::TextFormat cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->textFormat();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextFormat_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageWidgetFunc_wordWrap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // wordWrap()const
        bool cppResult = const_cast<const ::KMessageWidget *>(cppSelf)->wordWrap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMessageWidget_PropertyStrings[] = {
    "closeButtonVisible:isCloseButtonVisible:",
    "icon::",
    "messageType::",
    "position::",
    "text::",
    "textFormat::",
    "wordWrap::",
    nullptr // Sentinel
};

static const char *Sbk_KMessageWidget_EnumFlagInfo[] = {
    "MessageType:IntEnum",
    "Position:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMessageWidget_methods[] = {
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_addAction), METH_O, nullptr},
    {"animatedHide", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_animatedHide), METH_NOARGS, nullptr},
    {"animatedShow", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_animatedShow), METH_NOARGS, nullptr},
    {"clearActions", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_clearActions), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_event), METH_O, nullptr},
    {"heightForWidth", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_heightForWidth), METH_O, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_icon), METH_NOARGS, nullptr},
    {"isCloseButtonVisible", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_isCloseButtonVisible), METH_NOARGS, nullptr},
    {"isHideAnimationRunning", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_isHideAnimationRunning), METH_NOARGS, nullptr},
    {"isShowAnimationRunning", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_isShowAnimationRunning), METH_NOARGS, nullptr},
    {"messageType", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_messageType), METH_NOARGS, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_paintEvent), METH_O, nullptr},
    {"position", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_position), METH_NOARGS, nullptr},
    {"removeAction", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_removeAction), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_resizeEvent), METH_O, nullptr},
    {"setCloseButtonVisible", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setCloseButtonVisible), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setIcon), METH_O, nullptr},
    {"setMessageType", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setMessageType), METH_O, nullptr},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setPosition), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setText), METH_O, nullptr},
    {"setTextFormat", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setTextFormat), METH_O, nullptr},
    {"setWordWrap", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_setWordWrap), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_sizeHint), METH_NOARGS, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_text), METH_NOARGS, nullptr},
    {"textFormat", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_textFormat), METH_NOARGS, nullptr},
    {"wordWrap", reinterpret_cast<PyCFunction>(Sbk_KMessageWidgetFunc_wordWrap), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMessageWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMessageWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMessageWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMessageWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMessageWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMessageWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMessageWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMessageWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMessageWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMessageWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMessageWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMessageWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMessageWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMessageWidget_spec = {
    "1:KWidgetsAddons.KMessageWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMessageWidget_slots
};

} //extern "C"

static void *Sbk_KMessageWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMessageWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMessageWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMessageWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KMessageWidget_MessageType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageWidget::MessageType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageWidget::MessageType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageWidget_MessageType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_MessageType_IDX])))
        return Enum_PythonToCpp_KMessageWidget_MessageType;
    return {};
}

static PyObject *KMessageWidget_MessageType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageWidget::MessageType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageWidget::MessageType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KMessageWidget_Position(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageWidget::Position>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageWidget::Position *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageWidget_Position_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_Position_IDX])))
        return Enum_PythonToCpp_KMessageWidget_Position;
    return {};
}

static PyObject *KMessageWidget_Position_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageWidget::Position>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageWidget::Position *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMessageWidget_PythonToCpp_KMessageWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMessageWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMessageWidget_PythonToCpp_KMessageWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMessageWidget_TypeF()))
        return KMessageWidget_PythonToCpp_KMessageWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMessageWidget_PTR_CppToPython_KMessageWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMessageWidget *>(const_cast<void *>(cppIn)), Sbk_KMessageWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMessageWidget_SignatureStrings[] = {
    "1:KWidgetsAddons.KMessageWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,text:QString=None,textFormat:PySide6.QtCore.Qt.TextFormat=None,wordWrap:bool=None,closeButtonVisible:bool=None,messageType:KWidgetsAddons.KMessageWidget.MessageType=None,icon:QIcon=None,position:KWidgetsAddons.KMessageWidget.Position=None)",
    "0:KWidgetsAddons.KMessageWidget(self,text:QString,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,text:QString=None,textFormat:PySide6.QtCore.Qt.TextFormat=None,wordWrap:bool=None,closeButtonVisible:bool=None,messageType:KWidgetsAddons.KMessageWidget.MessageType=None,icon:QIcon=None,position:KWidgetsAddons.KMessageWidget.Position=None)",
    "KWidgetsAddons.KMessageWidget.addAction(self,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KMessageWidget.animatedHide(self)",
    "KWidgetsAddons.KMessageWidget.animatedShow(self)",
    "KWidgetsAddons.KMessageWidget.clearActions(self)",
    "KWidgetsAddons.KMessageWidget.event(self,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KMessageWidget.heightForWidth(self,width:int)->int",
    "KWidgetsAddons.KMessageWidget.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KMessageWidget.isCloseButtonVisible(self)->bool",
    "KWidgetsAddons.KMessageWidget.isHideAnimationRunning(self)->bool",
    "KWidgetsAddons.KMessageWidget.isShowAnimationRunning(self)->bool",
    "KWidgetsAddons.KMessageWidget.messageType(self)->KWidgetsAddons.KMessageWidget.MessageType",
    "KWidgetsAddons.KMessageWidget.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KMessageWidget.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KMessageWidget.position(self)->KWidgetsAddons.KMessageWidget.Position",
    "KWidgetsAddons.KMessageWidget.removeAction(self,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KMessageWidget.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KMessageWidget.setCloseButtonVisible(self,visible:bool)",
    "KWidgetsAddons.KMessageWidget.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KMessageWidget.setMessageType(self,type:KWidgetsAddons.KMessageWidget.MessageType)",
    "KWidgetsAddons.KMessageWidget.setPosition(self,position:KWidgetsAddons.KMessageWidget.Position)",
    "KWidgetsAddons.KMessageWidget.setText(self,text:QString)",
    "KWidgetsAddons.KMessageWidget.setTextFormat(self,textFormat:PySide6.QtCore.Qt.TextFormat)",
    "KWidgetsAddons.KMessageWidget.setWordWrap(self,wordWrap:bool)",
    "KWidgetsAddons.KMessageWidget.sizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KMessageWidget.text(self)->QString",
    "KWidgetsAddons.KMessageWidget.textFormat(self)->PySide6.QtCore.Qt.TextFormat",
    "KWidgetsAddons.KMessageWidget.wordWrap(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KMessageWidget_SignatureByteSize = 514;
static constexpr uint8_t KMessageWidget_SignatureBytes[514] = {
    0x78, 0xda, 0xed, 0x55, 0xcf, 0x4f, 0xc2, 0x30, 0x14, 0xbe, 0xfb, 0x57, 0x78, 0x14, 0x33, 0x17,
    0xbd, 0x78, 0x58, 0x82, 0x09, 0x1a, 0x7f, 0x85, 0xa0, 0x4c, 0x54, 0x0e, 0xc6, 0x43, 0x61, 0x4f,
    0x78, 0xc9, 0xd6, 0x2e, 0x6d, 0x07, 0xcc, 0xbf, 0xde, 0x76, 0xdd, 0xa4, 0x82, 0xd0, 0x12, 0x3c,
    0x7a, 0xd9, 0xba, 0xee, 0x7d, 0x5f, 0xfb, 0xbe, 0xf7, 0xeb, 0x2c, 0xea, 0x0e, 0x31, 0x99, 0x80,
    0x14, 0x9d, 0x24, 0x61, 0x54, 0x84, 0xdd, 0x1e, 0x08, 0x41, 0x26, 0x60, 0x76, 0x8f, 0x04, 0xa4,
    0x1f, 0x41, 0x4e, 0x38, 0x50, 0x19, 0xf5, 0xcb, 0x01, 0x26, 0x70, 0x1e, 0xc6, 0xb2, 0x86, 0x84,
    0xb1, 0x59, 0xb4, 0x69, 0x91, 0xa6, 0xb9, 0xe4, 0xc1, 0x71, 0xd4, 0x85, 0x72, 0xce, 0x78, 0xf2,
    0x48, 0xd3, 0xb2, 0xfd, 0xc0, 0x28, 0x04, 0x12, 0x16, 0x32, 0x8a, 0x07, 0x92, 0x23, 0x9d, 0x2c,
    0x77, 0x6e, 0x18, 0xcf, 0x88, 0xcd, 0x78, 0xc5, 0x38, 0xa8, 0x57, 0xf8, 0xfc, 0xfd, 0xd3, 0x18,
    0x6b, 0xb2, 0x21, 0x27, 0x79, 0x34, 0x62, 0x2c, 0x35, 0x5b, 0xe3, 0x94, 0x09, 0xb8, 0x2c, 0xa4,
    0x64, 0xf4, 0x15, 0x05, 0x8e, 0x52, 0xb0, 0x7e, 0x66, 0xe6, 0xf6, 0xcf, 0x65, 0x0e, 0xdb, 0x3d,
    0x0b, 0x7b, 0x4b, 0x4b, 0x03, 0xc5, 0x31, 0xa3, 0x51, 0x7c, 0xaf, 0x9e, 0xe6, 0x3b, 0x67, 0x02,
    0x25, 0xaa, 0xbd, 0xed, 0x3c, 0xfd, 0xda, 0xac, 0x02, 0xb5, 0x0e, 0x4e, 0x7d, 0x04, 0xb5, 0x45,
    0xf9, 0x57, 0x77, 0x07, 0x75, 0xb7, 0x1b, 0x93, 0x24, 0xe9, 0x8c, 0xb5, 0xb5, 0x51, 0x99, 0x54,
    0x6b, 0x4b, 0x86, 0xdb, 0x02, 0xc3, 0xd8, 0x58, 0x38, 0xa9, 0x28, 0x2a, 0x95, 0x20, 0xb9, 0x53,
    0xd0, 0x8a, 0xcd, 0x17, 0x30, 0x98, 0xb2, 0xb9, 0x17, 0x60, 0x9c, 0x02, 0xe1, 0xe6, 0x32, 0xc2,
    0x0b, 0x00, 0x33, 0x95, 0x26, 0xc6, 0xb3, 0x6a, 0xb9, 0x16, 0xdf, 0x6b, 0xbd, 0xdb, 0x3a, 0xb9,
    0xd0, 0xf1, 0x72, 0x70, 0x4d, 0x01, 0x27, 0x53, 0x9d, 0x0a, 0xea, 0x5b, 0x4e, 0x0d, 0xe9, 0x5c,
    0x2f, 0x23, 0xac, 0x28, 0xd4, 0xd3, 0xc1, 0xa0, 0xe3, 0x69, 0xae, 0x7d, 0x72, 0xb1, 0xa2, 0xb0,
    0x0e, 0xb2, 0x0b, 0x2d, 0xae, 0xd6, 0xf2, 0xac, 0x61, 0xf3, 0xb8, 0x3e, 0x0a, 0x1d, 0x97, 0x4e,
    0x25, 0xb9, 0xd2, 0xef, 0xa9, 0xa0, 0x54, 0x15, 0xc0, 0x4e, 0x04, 0x3a, 0x4e, 0x7b, 0x10, 0x58,
    0x95, 0xd0, 0xa0, 0xbc, 0x0b, 0xc2, 0x45, 0x8d, 0xea, 0x5a, 0x45, 0x36, 0xc0, 0x4f, 0xb8, 0xc3,
    0x3a, 0xe2, 0x3f, 0x44, 0x36, 0xd1, 0xd6, 0xff, 0x1d, 0x4c, 0x39, 0x51, 0xf8, 0xeb, 0xcd, 0x69,
    0x53, 0x45, 0xab, 0xff, 0x6d, 0xe4, 0x4a, 0xc0, 0xa6, 0x64, 0xfd, 0x1c, 0x6e, 0x2a, 0xd7, 0x41,
    0xca, 0x21, 0x63, 0x33, 0xf8, 0xab, 0xb2, 0xe5, 0x20, 0x94, 0x2c, 0x2e, 0x97, 0x9f, 0x96, 0x56,
    0x2e, 0x42, 0x01, 0x72, 0x43, 0xa6, 0x06, 0x33, 0xab, 0x3d, 0x7a, 0xd0, 0xdc, 0x37, 0x05, 0x63,
    0x5a, 0xa1, 0x2c, 0x73, 0x95, 0x71, 0xe1, 0x0b, 0x55, 0x5e, 0xbd, 0xfd, 0x52, 0x40, 0xc1, 0xe1,
    0x6a, 0x9c, 0x70, 0x91, 0x91, 0xfc, 0xdd, 0xe3, 0xa4, 0xde, 0x4a, 0x6e, 0x06, 0x72, 0xa7, 0x7e,
    0xed, 0x71, 0x42, 0xdf, 0xce, 0x84, 0x5d, 0x5b, 0xb9, 0x07, 0xbf, 0x9e, 0x53, 0xeb, 0x93, 0xd2,
    0x13, 0x68, 0x06, 0xdc, 0x12, 0xee, 0x31, 0x0d, 0x3d, 0x98, 0x87, 0xf5, 0xa8, 0xac, 0x7b, 0xa5,
    0x3d, 0x38, 0x9d, 0xe8, 0xfd, 0x2b, 0x59, 0x36, 0x82, 0x28, 0x78, 0xad, 0x86, 0x07, 0xc2, 0x52,
    0xe2, 0x97, 0x63, 0x6d, 0x01, 0x1c, 0x64, 0x73, 0xdb, 0xf9, 0xa6, 0x41, 0x7e, 0x01, 0x19, 0x31,
    0xca, 0xee
};
#endif

PyTypeObject *init_KMessageWidget(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KMessageWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))));

    _Sbk_KMessageWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMessageWidget",
        "KMessageWidget*",
        &Sbk_KMessageWidget_spec,
        &Shiboken::callCppDestructor< KMessageWidget >,
        Sbk_KMessageWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KMessageWidget_TypeF(); // references _Sbk_KMessageWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMessageWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMessageWidget_SignatureBytes, KMessageWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMessageWidget_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMessageWidget_PythonToCpp_KMessageWidget_PTR,
        is_KMessageWidget_PythonToCpp_KMessageWidget_PTR_Convertible,
        KMessageWidget_PTR_CppToPython_KMessageWidget);

    Shiboken::Conversions::registerConverterName(converter, "KMessageWidget");
    Shiboken::Conversions::registerConverterName(converter, "KMessageWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KMessageWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMessageWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMessageWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMessageWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMessageWidget_TypeF(), &Sbk_KMessageWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMessageWidget_TypeF(), &Sbk_KMessageWidget_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KMessageWidget_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'MessageType'.
    const char *MessageType_Initializer[] = {
        "Positive",
        "Information",
        "Warning",
        "Error",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t MessageType_InitializerValues[] = {
        uint8_t(KMessageWidget::MessageType::Positive),    //  0x00  0
        uint8_t(KMessageWidget::MessageType::Information), //  0x01  1
        uint8_t(KMessageWidget::MessageType::Warning),     //  0x02  2
        uint8_t(KMessageWidget::MessageType::Error)        //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageWidget_TypeF(),
        "1:KWidgetsAddons.KMessageWidget.MessageType",
        MessageType_Initializer, MessageType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_MessageType_IDX].type = EType;
    // Register converter for enum 'KMessageWidget::MessageType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageWidget_MessageType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageWidget_MessageType,
            is_Enum_PythonToCpp_KMessageWidget_MessageType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageWidget::MessageType");
        Shiboken::Conversions::registerConverterAlias(converter, "MessageType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'MessageType' enum.

    // Initialization of enum 'Position'.
    const char *Position_Initializer[] = {
        "Inline",
        "Header",
        "Footer",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Position_InitializerValues[] = {
        uint8_t(KMessageWidget::Position::Inline), //  0x00  0
        uint8_t(KMessageWidget::Position::Header), //  0x01  1
        uint8_t(KMessageWidget::Position::Footer)  //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageWidget_TypeF(),
        "1:KWidgetsAddons.KMessageWidget.Position",
        Position_Initializer, Position_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_Position_IDX].type = EType;
    // Register converter for enum 'KMessageWidget::Position'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageWidget_Position_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageWidget_Position,
            is_Enum_PythonToCpp_KMessageWidget_Position_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageWidget::Position");
        Shiboken::Conversions::registerConverterAlias(converter, "Position");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Position' enum.

    PySide::Signal::registerSignals(pyType, &::KMessageWidget::staticMetaObject);
    qRegisterMetaType< ::KMessageWidget::MessageType >("KMessageWidget::MessageType");
    qRegisterMetaType< ::KMessageWidget::Position >("KMessageWidget::Position");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMessageWidget::staticMetaObject, sizeof(KMessageWidgetWrapper));

    return pyType;
}
