#ifndef SBK_KSEPARATORWRAPPER_H
#define SBK_KSEPARATORWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kseparator.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KSeparatorWrapper : public KSeparator
{
public:
    KSeparatorWrapper(::QWidget * parent = nullptr, ::QFlags<Qt::WindowType> f = Qt::WindowFlags());
    KSeparatorWrapper(::Qt::Orientation orientation, ::QWidget * parent = nullptr, ::QFlags<Qt::WindowType> f = Qt::WindowFlags());
    KSeparatorWrapper(const KSeparatorWrapper &) = delete;
    KSeparatorWrapper& operator=(const KSeparatorWrapper &) = delete;
    KSeparatorWrapper(KSeparatorWrapper &&) = delete;
    KSeparatorWrapper& operator=(KSeparatorWrapper &&) = delete;
    ~KSeparatorWrapper() override;

    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * arg__1) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * event) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEnterEvent * event) override;
    bool event(::QEvent * e) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void initPainter(::QPainter * painter) const override;
    void initStyleOption(::QStyleOptionFrame * option) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * event) override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * arg__1) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * event) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent(::QWheelEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 48> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KSEPARATORWRAPPER_H
