
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kurllabel_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUrlLabel_Type = nullptr;
static PyTypeObject *Sbk_KUrlLabel_TypeF(void)
{
    return _Sbk_KUrlLabel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KUrlLabelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KUrlLabelWrapper::KUrlLabelWrapper(::QWidget * parent) : KUrlLabel(parent)
{
}

KUrlLabelWrapper::KUrlLabelWrapper(const ::QString & url, const ::QString & text, ::QWidget * parent) : KUrlLabel(url, text, parent)
{
}

void KUrlLabelWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

void KUrlLabelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KUrlLabel", funcName, gil, pyOverride, signal);
}

void KUrlLabelWrapper::contextMenuEvent(::QContextMenuEvent * ev)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::contextMenuEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

void KUrlLabelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

int KUrlLabelWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KUrlLabel", funcName, gil, pyOverride);
}

void KUrlLabelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KUrlLabel", funcName, gil, pyOverride, signal);
}

void KUrlLabelWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUrlLabel::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

bool KUrlLabelWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUrlLabel::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

bool KUrlLabelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KUrlLabel", funcName, gil, pyOverride, watched, event);
}

void KUrlLabelWrapper::focusInEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusInEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

bool KUrlLabelWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KUrlLabel", funcName, gil, pyOverride, next);
}

void KUrlLabelWrapper::focusOutEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusOutEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

bool KUrlLabelWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KUrlLabel", funcName, gil, pyOverride);
}

int KUrlLabelWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

void KUrlLabelWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KUrlLabel", funcName, gil, pyOverride, painter);
}

void KUrlLabelWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    sbk_o_initStyleOption("KUrlLabel", funcName, gil, pyOverride, option);
}

void KUrlLabelWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionFrame * option)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionFrame_IDX]), option)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionFrame_IDX]), option)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUrlLabelWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

::QVariant KUrlLabelWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

void KUrlLabelWrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::keyPressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

void KUrlLabelWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUrlLabel::leaveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

int KUrlLabelWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

::QSize KUrlLabelWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KUrlLabel", funcName, gil, pyOverride);
}

void KUrlLabelWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::mouseMoveEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mouseMoveEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

void KUrlLabelWrapper::mousePressEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mousePressEvent(ev);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KUrlLabel", funcName, gil, pyOverride, ev);
}

void KUrlLabelWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUrlLabel::mouseReleaseEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

void KUrlLabelWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

bool KUrlLabelWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KUrlLabel", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KUrlLabelWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KUrlLabel", funcName, gil, pyOverride);
}

void KUrlLabelWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KUrlLabel", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KUrlLabelWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KUrlLabel", funcName, gil, pyOverride, offset);
}

void KUrlLabelWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::setFont(const ::QFont & font)
{
    static const char *funcName = "setFont";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUrlLabel::setFont(font);
    }
    sbk_o_setFont("KUrlLabel", funcName, gil, pyOverride, font);
}

void KUrlLabelWrapper::sbk_o_setFont(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QFont & font)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &font)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &font)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KUrlLabelWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KUrlLabel", funcName, gil, pyOverride, visible);
}

::QPainter * KUrlLabelWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KUrlLabel", funcName, gil, pyOverride);
}

void KUrlLabelWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

::QSize KUrlLabelWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KUrlLabel", funcName, gil, pyOverride);
}

void KUrlLabelWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

void KUrlLabelWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUrlLabel_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KUrlLabel", funcName, gil, pyOverride, event);
}

const QMetaObject *KUrlLabelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KUrlLabel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KUrlLabelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KUrlLabel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KUrlLabelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KUrlLabelWrapper *>(this));
    }
    return KUrlLabel::qt_metacast(_clname);
}

KUrlLabelWrapper::~KUrlLabelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KUrlLabel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUrlLabel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUrlLabel >()))
        return -1;

    KUrlLabelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KUrlLabel", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUrlLabel::KUrlLabel(QWidget*=)
    // 1: KUrlLabel::KUrlLabel(QString,const QString&=,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KUrlLabel(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KUrlLabel(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KUrlLabel(QString,QString,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KUrlLabel(QString,QString,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                overloadId = 1; // KUrlLabel(QString,QString,QWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KUrlLabel(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUrlLabel(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KUrlLabelWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KUrlLabelWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KUrlLabel(const QString &url, const QString &text, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"text", 1}, {"parent", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QWidget *cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUrlLabel(QString,QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KUrlLabelWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KUrlLabelWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KUrlLabel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KUrlLabelFunc_alternatePixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // alternatePixmap()const
        const QPixmap * cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->alternatePixmap();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_enterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::enterEvent(QEnterEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QEnterEvent_IDX]), (pyArg)))) {
        overloadId = 0; // enterEvent(QEnterEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "enterEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEnterEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // enterEvent(QEnterEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUrlLabel::enterEvent(cppArg0)
                : cppSelf->enterEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUrlLabel::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_isFloatEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFloatEnabled()const
        bool cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->isFloatEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_isGlowEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isGlowEnabled()const
        bool cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->isGlowEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_leaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::leaveEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // leaveEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "leaveEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // leaveEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUrlLabel::leaveEvent(cppArg0)
                : cppSelf->leaveEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUrlLabel::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setAlternatePixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setAlternatePixmap(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // setAlternatePixmap(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAlternatePixmap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setAlternatePixmap(QPixmap)
            cppSelf->setAlternatePixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setFloatEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setFloatEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    if (PyArg_ParseTuple(args, "|O:setFloatEnabled", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUrlLabel::setFloatEnabled(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setFloatEnabled(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setFloatEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setFloatEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"do_float", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setFloatEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFloatEnabled(bool)
            cppSelf->setFloatEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFont", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setFont(QFont)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUrlLabel::setFont(*cppArg0)
                : cppSelf->setFont(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setGlowEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setGlowEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    if (PyArg_ParseTuple(args, "|O:setGlowEnabled", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUrlLabel::setGlowEnabled(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setGlowEnabled(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setGlowEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setGlowEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"glow", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setGlowEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGlowEnabled(bool)
            cppSelf->setGlowEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setHighlightedColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setHighlightedColor(QColor)
    // 1: KUrlLabel::setHighlightedColor(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 1; // setHighlightedColor(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setHighlightedColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHighlightedColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setHighlightedColor(const QColor &highcolor)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (pythonToCpp.isValue())
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // setHighlightedColor(QColor)
                cppSelf->setHighlightedColor(*cppArg0);
            }
            break;
        }
        case 1: // setHighlightedColor(const QString &highcolor)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setHighlightedColor(QString)
                cppSelf->setHighlightedColor(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setSelectedColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setSelectedColor(QColor)
    // 1: KUrlLabel::setSelectedColor(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 1; // setSelectedColor(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setSelectedColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setSelectedColor(const QColor &color)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (pythonToCpp.isValue())
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // setSelectedColor(QColor)
                cppSelf->setSelectedColor(*cppArg0);
            }
            break;
        }
        case 1: // setSelectedColor(const QString &color)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setSelectedColor(QString)
                cppSelf->setSelectedColor(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setTipText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setTipText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTipText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTipText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTipText(QString)
            cppSelf->setTipText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setUnderline(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setUnderline", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    if (PyArg_ParseTuple(args, "|O:setUnderline", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUrlLabel::setUnderline(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setUnderline(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setUnderline(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setUnderline", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"on", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setUnderline", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUnderline(bool)
            cppSelf->setUnderline(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KUrlLabel::setUrl(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setUrl(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUrl", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrl(QString)
            cppSelf->setUrl(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setUseCursor(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setUseCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setUseCursor", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUrlLabel::setUseCursor(bool,QCursor*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setUseCursor(bool,QCursor*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QCursor_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setUseCursor(bool,QCursor*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setUseCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"cursor", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QCursor_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setUseCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
            }
        }
        bool cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QCursor *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUseCursor(bool,QCursor*)
            cppSelf->setUseCursor(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_setUseTips(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setUseTips", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    if (PyArg_ParseTuple(args, "|O:setUseTips", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KUrlLabel::setUseTips(bool=)
    if (numArgs == 0) {
        overloadId = 0; // setUseTips(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setUseTips(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setUseTips", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"on", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setUseTips", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUseTips(bool)
            cppSelf->setUseTips(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUrlLabelFunc_tipText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tipText()const
        QString cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->tipText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // url()const
        QString cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->url();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_useCursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // useCursor()const
        bool cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->useCursor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUrlLabelFunc_useTips(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // useTips()const
        bool cppResult = const_cast<const ::KUrlLabel *>(cppSelf)->useTips();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUrlLabel_PropertyStrings[] = {
    "alternatePixmap::",
    "floatEnabled:isFloatEnabled:",
    "glowEnabled:isGlowEnabled:",
    "tipText::",
    "url::",
    "useCursor::",
    "useTips::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUrlLabel_methods[] = {
    {"alternatePixmap", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_alternatePixmap), METH_NOARGS, nullptr},
    {"enterEvent", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_enterEvent), METH_O, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_event), METH_O, nullptr},
    {"isFloatEnabled", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_isFloatEnabled), METH_NOARGS, nullptr},
    {"isGlowEnabled", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_isGlowEnabled), METH_NOARGS, nullptr},
    {"leaveEvent", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_leaveEvent), METH_O, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_mouseReleaseEvent), METH_O, nullptr},
    {"setAlternatePixmap", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setAlternatePixmap), METH_O, nullptr},
    {"setFloatEnabled", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setFloatEnabled), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setFont), METH_O, nullptr},
    {"setGlowEnabled", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setGlowEnabled), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setHighlightedColor", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setHighlightedColor), METH_O, nullptr},
    {"setSelectedColor", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setSelectedColor), METH_O, nullptr},
    {"setTipText", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setTipText), METH_O, nullptr},
    {"setUnderline", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setUnderline), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setUrl), METH_O, nullptr},
    {"setUseCursor", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setUseCursor), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setUseTips", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_setUseTips), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"tipText", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_tipText), METH_NOARGS, nullptr},
    {"url", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_url), METH_NOARGS, nullptr},
    {"useCursor", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_useCursor), METH_NOARGS, nullptr},
    {"useTips", reinterpret_cast<PyCFunction>(Sbk_KUrlLabelFunc_useTips), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KUrlLabel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KUrlLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KUrlLabelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KUrlLabel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUrlLabel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KUrlLabelSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KUrlLabel *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))
        return static_cast< ::QLabel *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUrlLabel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KUrlLabel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUrlLabel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUrlLabel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUrlLabel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUrlLabel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUrlLabel_spec = {
    "1:KWidgetsAddons.KUrlLabel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUrlLabel_slots
};

} //extern "C"

static void *Sbk_KUrlLabel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KUrlLabel *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KUrlLabel *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KUrlLabel *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUrlLabel_PythonToCpp_KUrlLabel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUrlLabel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUrlLabel_PythonToCpp_KUrlLabel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUrlLabel_TypeF()))
        return KUrlLabel_PythonToCpp_KUrlLabel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUrlLabel_PTR_CppToPython_KUrlLabel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KUrlLabel *>(const_cast<void *>(cppIn)), Sbk_KUrlLabel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUrlLabel_SignatureStrings[] = {
    "1:KWidgetsAddons.KUrlLabel(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,url:QString=None,tipText:QString=None,alternatePixmap:QPixmap=None,glowEnabled:bool=None,floatEnabled:bool=None,useTips:bool=None,useCursor:bool=None)",
    "0:KWidgetsAddons.KUrlLabel(self,url:QString,text:QString=QString(),parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,url:QString=None,tipText:QString=None,alternatePixmap:QPixmap=None,glowEnabled:bool=None,floatEnabled:bool=None,useTips:bool=None,useCursor:bool=None)",
    "KWidgetsAddons.KUrlLabel.alternatePixmap(self)->PySide6.QtGui.QPixmap",
    "KWidgetsAddons.KUrlLabel.enterEvent(self,event:PySide6.QtGui.QEnterEvent)",
    "KWidgetsAddons.KUrlLabel.event(self,arg__1:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KUrlLabel.isFloatEnabled(self)->bool",
    "KWidgetsAddons.KUrlLabel.isGlowEnabled(self)->bool",
    "KWidgetsAddons.KUrlLabel.leaveEvent(self,arg__1:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KUrlLabel.mouseReleaseEvent(self,arg__1:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KUrlLabel.setAlternatePixmap(self,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])",
    "KWidgetsAddons.KUrlLabel.setFloatEnabled(self,do_float:bool=true)",
    "KWidgetsAddons.KUrlLabel.setFont(self,font:typing.Union[PySide6.QtGui.QFont, QString, QStringList])",
    "KWidgetsAddons.KUrlLabel.setGlowEnabled(self,glow:bool=true)",
    "1:KWidgetsAddons.KUrlLabel.setHighlightedColor(self,highcolor:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "0:KWidgetsAddons.KUrlLabel.setHighlightedColor(self,highcolor:QString)",
    "1:KWidgetsAddons.KUrlLabel.setSelectedColor(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "0:KWidgetsAddons.KUrlLabel.setSelectedColor(self,color:QString)",
    "KWidgetsAddons.KUrlLabel.setTipText(self,tip:QString)",
    "KWidgetsAddons.KUrlLabel.setUnderline(self,on:bool=true)",
    "KWidgetsAddons.KUrlLabel.setUrl(self,url:QString)",
    "KWidgetsAddons.KUrlLabel.setUseCursor(self,on:bool,cursor:typing.Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]=nullptr)",
    "KWidgetsAddons.KUrlLabel.setUseTips(self,on:bool=true)",
    "KWidgetsAddons.KUrlLabel.tipText(self)->QString",
    "KWidgetsAddons.KUrlLabel.url(self)->QString",
    "KWidgetsAddons.KUrlLabel.useCursor(self)->bool",
    "KWidgetsAddons.KUrlLabel.useTips(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUrlLabel_SignatureByteSize = 548;
static constexpr uint8_t KUrlLabel_SignatureBytes[548] = {
    0x78, 0xda, 0xdd, 0x55, 0x4d, 0x6f, 0xe2, 0x30, 0x10, 0xbd, 0xef, 0xaf, 0xe0, 0x58, 0x56, 0x69,
    0x54, 0xa4, 0x55, 0x0f, 0x91, 0x5a, 0xa9, 0x42, 0xf4, 0x43, 0xd0, 0xdd, 0x52, 0xa0, 0x7b, 0x58,
    0x55, 0xc8, 0xc1, 0x43, 0xb0, 0x64, 0xec, 0xc8, 0x9e, 0xd0, 0xf2, 0xef, 0xd7, 0x89, 0xe3, 0x92,
    0x04, 0xf2, 0x51, 0xf5, 0xb4, 0x7b, 0x88, 0xec, 0x4c, 0x66, 0x5e, 0xde, 0xbc, 0x19, 0x8f, 0x07,
    0xc1, 0xf8, 0x37, 0xa3, 0x11, 0xa0, 0xbe, 0xa1, 0x54, 0x0a, 0xed, 0x8f, 0x17, 0x8a, 0x4f, 0x48,
    0x08, 0xfc, 0x4c, 0x03, 0x5f, 0x7b, 0x31, 0x51, 0x20, 0x30, 0x78, 0xda, 0xcf, 0x18, 0x85, 0x4b,
    0x7f, 0x8a, 0xb9, 0xb7, 0x3f, 0xb5, 0x9b, 0x2b, 0x91, 0x70, 0x1e, 0xa3, 0xf2, 0xbe, 0x07, 0x63,
    0xd8, 0xbf, 0x49, 0x45, 0x7f, 0x09, 0xbe, 0xbf, 0xfa, 0x29, 0x05, 0x78, 0x89, 0xe2, 0xc1, 0x74,
    0x86, 0x8a, 0x89, 0xc8, 0x1a, 0x90, 0xc5, 0x73, 0x78, 0xc7, 0xb2, 0x91, 0x70, 0x04, 0x25, 0x08,
    0xc2, 0x13, 0x7b, 0xdf, 0x92, 0x38, 0x98, 0xda, 0xd5, 0x7e, 0x8c, 0xb8, 0x7c, 0x1b, 0x09, 0x12,
    0x72, 0xa0, 0x41, 0x28, 0x25, 0xb7, 0xd6, 0x35, 0x97, 0x04, 0x8f, 0xcd, 0x89, 0x86, 0x39, 0x8b,
    0x75, 0xd9, 0x32, 0x4c, 0x94, 0x96, 0xea, 0x60, 0xeb, 0x7f, 0xbb, 0x68, 0x49, 0xb9, 0x40, 0xdb,
    0xc3, 0x22, 0xdd, 0x7c, 0x3d, 0xeb, 0xff, 0x8f, 0xaa, 0xd4, 0x69, 0xe2, 0x57, 0x98, 0x64, 0x1a,
    0xf5, 0xcf, 0xaf, 0x0f, 0xb9, 0xdf, 0x25, 0xcc, 0xcf, 0xe9, 0xd5, 0xa3, 0x18, 0xb9, 0x40, 0x8d,
    0x76, 0x66, 0xb1, 0x22, 0xc3, 0xae, 0x2c, 0x60, 0x06, 0x32, 0xfa, 0x70, 0x6a, 0xe0, 0x03, 0x07,
    0x10, 0xa2, 0xa2, 0xe5, 0x72, 0x50, 0x40, 0x19, 0x4a, 0x05, 0x06, 0x26, 0x43, 0x38, 0xbf, 0x4e,
    0xb3, 0xab, 0xc7, 0x61, 0xfa, 0xb6, 0x20, 0x98, 0x4b, 0xab, 0x2d, 0xe6, 0xee, 0x20, 0x7d, 0xb7,
    0x10, 0x0e, 0x64, 0x07, 0xa3, 0x8e, 0x9c, 0xeb, 0x61, 0xb6, 0xd2, 0x54, 0xed, 0x19, 0x0c, 0x9a,
    0x6e, 0x44, 0xcb, 0x74, 0x7c, 0x4c, 0x9d, 0xdb, 0x10, 0x35, 0xe0, 0xcd, 0x89, 0xd2, 0x7a, 0xb1,
    0x6d, 0x38, 0xdc, 0xc7, 0xa6, 0x19, 0xfd, 0x85, 0x60, 0x52, 0xfc, 0x39, 0x59, 0x6c, 0xaf, 0x57,
    0x31, 0x3f, 0x6c, 0x49, 0x04, 0xaf, 0xcd, 0xbf, 0x3c, 0xd2, 0xdc, 0xa3, 0x72, 0x99, 0x75, 0xae,
    0x6d, 0x46, 0x54, 0x09, 0xb4, 0x20, 0x48, 0x97, 0xfc, 0xda, 0xec, 0x1a, 0x79, 0xa6, 0xae, 0x5e,
    0xcf, 0x9d, 0x65, 0xb7, 0x99, 0x30, 0x8d, 0x2d, 0x2c, 0xab, 0x55, 0xce, 0x4e, 0x5c, 0x91, 0xe0,
    0x20, 0x68, 0x0a, 0xbf, 0x67, 0xd1, 0x86, 0x9b, 0x07, 0x81, 0x0e, 0x25, 0x97, 0xca, 0x62, 0x6c,
    0x8c, 0x65, 0x95, 0xbe, 0x36, 0x72, 0xce, 0x02, 0x0c, 0xd7, 0x09, 0x41, 0x26, 0x06, 0x8e, 0x7a,
    0xc5, 0xe9, 0x39, 0x0a, 0xc9, 0xe5, 0x0f, 0xe3, 0xf5, 0x42, 0x14, 0x23, 0x69, 0x92, 0xd5, 0x7e,
    0x42, 0xdf, 0xe4, 0x10, 0x12, 0xee, 0xe0, 0x1c, 0x50, 0x22, 0x34, 0x8b, 0x04, 0xd0, 0x1e, 0x13,
    0xa9, 0x08, 0x17, 0x5f, 0xca, 0x23, 0x47, 0x6d, 0x93, 0x63, 0x66, 0xda, 0x76, 0x55, 0xc6, 0xf8,
    0xb7, 0x74, 0xa8, 0x4d, 0xe0, 0x43, 0x80, 0xa6, 0xe8, 0xb9, 0x9d, 0xef, 0x36, 0xce, 0x0c, 0xfb,
    0x6e, 0x51, 0x0b, 0x41, 0x41, 0x71, 0x26, 0xc0, 0xc6, 0x49, 0xd1, 0xf5, 0x7c, 0x98, 0xfd, 0xd1,
    0x3d, 0xd6, 0x12, 0xe1, 0xee, 0x83, 0xd2, 0xaf, 0xbc, 0x95, 0xbd, 0x23, 0x1a, 0x8b, 0x94, 0xb9,
    0x9c, 0x52, 0xdd, 0x7e, 0x99, 0x6d, 0x48, 0x0c, 0x47, 0x55, 0xb3, 0xe3, 0xe3, 0xd5, 0x5d, 0x92,
    0xad, 0xe4, 0xd2, 0xeb, 0xeb, 0x53, 0x2a, 0x60, 0x41, 0x71, 0x33, 0xa0, 0x73, 0x11, 0xea, 0xfd,
    0x93, 0x5c, 0xb2, 0x4e, 0xbe, 0x25, 0xb1, 0x5a, 0xc7, 0x7f, 0x52, 0xa0, 0xef, 0x9c, 0xff, 0x02,
    0x6f, 0x17, 0x71, 0x5e
};
#endif

PyTypeObject *init_KUrlLabel(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX].type;

    Shiboken::AutoDecRef Sbk_KUrlLabel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))));

    _Sbk_KUrlLabel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUrlLabel",
        "KUrlLabel*",
        &Sbk_KUrlLabel_spec,
        &Shiboken::callCppDestructor< KUrlLabel >,
        Sbk_KUrlLabel_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KUrlLabel_TypeF(); // references _Sbk_KUrlLabel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUrlLabel_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUrlLabel_SignatureBytes, KUrlLabel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUrlLabel_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUrlLabel_PythonToCpp_KUrlLabel_PTR,
        is_KUrlLabel_PythonToCpp_KUrlLabel_PTR_Convertible,
        KUrlLabel_PTR_CppToPython_KUrlLabel);

    Shiboken::Conversions::registerConverterName(converter, "KUrlLabel");
    Shiboken::Conversions::registerConverterName(converter, "KUrlLabel*");
    Shiboken::Conversions::registerConverterName(converter, "KUrlLabel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUrlLabel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KUrlLabelWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KUrlLabel_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KUrlLabel_TypeF(), &Sbk_KUrlLabelSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KUrlLabel_TypeF(), &Sbk_KUrlLabel_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KUrlLabel::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KUrlLabel::staticMetaObject, sizeof(KUrlLabelWrapper));

    return pyType;
}
