
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcollapsiblegroupbox_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCollapsibleGroupBox_Type = nullptr;
static PyTypeObject *Sbk_KCollapsibleGroupBox_TypeF(void)
{
    return _Sbk_KCollapsibleGroupBox_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KCollapsibleGroupBoxWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KCollapsibleGroupBoxWrapper::KCollapsibleGroupBoxWrapper(::QWidget * parent) : KCollapsibleGroupBox(parent)
{
}

void KCollapsibleGroupBoxWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCollapsibleGroupBox", funcName, gil, pyOverride, signal);
}

void KCollapsibleGroupBoxWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

int KCollapsibleGroupBoxWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

void KCollapsibleGroupBoxWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCollapsibleGroupBox", funcName, gil, pyOverride, signal);
}

void KCollapsibleGroupBoxWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

bool KCollapsibleGroupBoxWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

bool KCollapsibleGroupBoxWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KCollapsibleGroupBox", funcName, gil, pyOverride, watched, event);
}

void KCollapsibleGroupBoxWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

bool KCollapsibleGroupBoxWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KCollapsibleGroupBox", funcName, gil, pyOverride, next);
}

void KCollapsibleGroupBoxWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

bool KCollapsibleGroupBoxWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

int KCollapsibleGroupBoxWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KCollapsibleGroupBox", funcName, gil, pyOverride, painter);
}

void KCollapsibleGroupBoxWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

::QVariant KCollapsibleGroupBoxWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::leaveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

int KCollapsibleGroupBoxWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

::QSize KCollapsibleGroupBoxWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

void KCollapsibleGroupBoxWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::mouseMoveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::mousePressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

bool KCollapsibleGroupBoxWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KCollapsibleGroupBoxWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

void KCollapsibleGroupBoxWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KCollapsibleGroupBoxWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KCollapsibleGroupBox", funcName, gil, pyOverride, offset);
}

void KCollapsibleGroupBoxWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, arg__1);
}

void KCollapsibleGroupBoxWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KCollapsibleGroupBox", funcName, gil, pyOverride, visible);
}

::QPainter * KCollapsibleGroupBoxWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

void KCollapsibleGroupBoxWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

::QSize KCollapsibleGroupBoxWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCollapsibleGroupBox::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCollapsibleGroupBox", funcName, gil, pyOverride);
}

void KCollapsibleGroupBoxWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

void KCollapsibleGroupBoxWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCollapsibleGroupBox_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KCollapsibleGroupBox", funcName, gil, pyOverride, event);
}

const QMetaObject *KCollapsibleGroupBoxWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KCollapsibleGroupBox::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KCollapsibleGroupBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KCollapsibleGroupBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KCollapsibleGroupBoxWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KCollapsibleGroupBoxWrapper *>(this));
    }
    return KCollapsibleGroupBox::qt_metacast(_clname);
}

KCollapsibleGroupBoxWrapper::~KCollapsibleGroupBoxWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KCollapsibleGroupBox_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCollapsibleGroupBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCollapsibleGroupBox >()))
        return -1;

    KCollapsibleGroupBoxWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KCollapsibleGroupBox", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCollapsibleGroupBox::KCollapsibleGroupBox(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KCollapsibleGroupBox(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KCollapsibleGroupBox(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KCollapsibleGroupBox(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KCollapsibleGroupBoxWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KCollapsibleGroupBoxWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KCollapsibleGroupBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_collapse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // collapse()
        cppSelf->collapse();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_expand(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // expand()
        cppSelf->expand();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_isExpanded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isExpanded()const
        bool cppResult = const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->isExpanded();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_leaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::leaveEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // leaveEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "leaveEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // leaveEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::leaveEvent(cppArg0)
                : cppSelf->leaveEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->::KCollapsibleGroupBox::minimumSizeHint()
            : const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseMoveEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCollapsibleGroupBox::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_setExpanded(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCollapsibleGroupBox::setExpanded(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setExpanded(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setExpanded", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setExpanded(bool)
            cppSelf->setExpanded(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCollapsibleGroupBox::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTitle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->::KCollapsibleGroupBox::sizeHint()
            : const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        QString cppResult = const_cast<const ::KCollapsibleGroupBox *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCollapsibleGroupBoxFunc_toggle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toggle()
        cppSelf->toggle();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KCollapsibleGroupBox_PropertyStrings[] = {
    "expanded:isExpanded:",
    "title::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCollapsibleGroupBox_methods[] = {
    {"collapse", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_collapse), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_event), METH_O, nullptr},
    {"expand", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_expand), METH_NOARGS, nullptr},
    {"isExpanded", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_isExpanded), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_keyPressEvent), METH_O, nullptr},
    {"leaveEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_leaveEvent), METH_O, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_mouseMoveEvent), METH_O, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_mousePressEvent), METH_O, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_paintEvent), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_resizeEvent), METH_O, nullptr},
    {"setExpanded", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_setExpanded), METH_O, nullptr},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_setTitle), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_sizeHint), METH_NOARGS, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_title), METH_NOARGS, nullptr},
    {"toggle", reinterpret_cast<PyCFunction>(Sbk_KCollapsibleGroupBoxFunc_toggle), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KCollapsibleGroupBox_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KCollapsibleGroupBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KCollapsibleGroupBoxWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KCollapsibleGroupBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCollapsibleGroupBox_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KCollapsibleGroupBoxSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KCollapsibleGroupBox *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCollapsibleGroupBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KCollapsibleGroupBox_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCollapsibleGroupBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCollapsibleGroupBox_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCollapsibleGroupBox_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCollapsibleGroupBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCollapsibleGroupBox_spec = {
    "1:KWidgetsAddons.KCollapsibleGroupBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCollapsibleGroupBox_slots
};

} //extern "C"

static void *Sbk_KCollapsibleGroupBox_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KCollapsibleGroupBox *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KCollapsibleGroupBox *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KCollapsibleGroupBox *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCollapsibleGroupBox_PythonToCpp_KCollapsibleGroupBox_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCollapsibleGroupBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCollapsibleGroupBox_PythonToCpp_KCollapsibleGroupBox_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCollapsibleGroupBox_TypeF()))
        return KCollapsibleGroupBox_PythonToCpp_KCollapsibleGroupBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCollapsibleGroupBox_PTR_CppToPython_KCollapsibleGroupBox(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KCollapsibleGroupBox *>(const_cast<void *>(cppIn)), Sbk_KCollapsibleGroupBox_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCollapsibleGroupBox_SignatureStrings[] = {
    "KWidgetsAddons.KCollapsibleGroupBox(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,title:QString=None,expanded:bool=None)",
    "KWidgetsAddons.KCollapsibleGroupBox.collapse(self)",
    "KWidgetsAddons.KCollapsibleGroupBox.event(self,arg__1:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KCollapsibleGroupBox.expand(self)",
    "KWidgetsAddons.KCollapsibleGroupBox.isExpanded(self)->bool",
    "KWidgetsAddons.KCollapsibleGroupBox.keyPressEvent(self,arg__1:PySide6.QtGui.QKeyEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.leaveEvent(self,arg__1:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KCollapsibleGroupBox.mouseMoveEvent(self,arg__1:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.mousePressEvent(self,arg__1:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.paintEvent(self,arg__1:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.resizeEvent(self,arg__1:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KCollapsibleGroupBox.setExpanded(self,expanded:bool)",
    "KWidgetsAddons.KCollapsibleGroupBox.setTitle(self,title:QString)",
    "KWidgetsAddons.KCollapsibleGroupBox.sizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KCollapsibleGroupBox.title(self)->QString",
    "KWidgetsAddons.KCollapsibleGroupBox.toggle(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KCollapsibleGroupBox_SignatureByteSize = 308;
static constexpr uint8_t KCollapsibleGroupBox_SignatureBytes[308] = {
    0x78, 0xda, 0xad, 0x93, 0x51, 0x4b, 0xc3, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x49, 0x9c, 0xd4, 0x80,
    0x2f, 0x3e, 0x14, 0x26, 0xe8, 0x28, 0x13, 0xca, 0xb4, 0x75, 0x82, 0x8f, 0x23, 0x33, 0x67, 0x09,
    0xa6, 0x49, 0x48, 0xd2, 0xb9, 0xfa, 0xe9, 0x4d, 0x9a, 0x3a, 0xed, 0x1e, 0xd6, 0x2b, 0xf8, 0x56,
    0xae, 0x77, 0xbf, 0xfc, 0xfe, 0x47, 0x92, 0xbf, 0x72, 0x56, 0x81, 0xb3, 0x77, 0x8c, 0x29, 0x69,
    0x49, 0xbe, 0x54, 0x42, 0x50, 0x6d, 0xf9, 0x4e, 0xc0, 0xca, 0xa8, 0x46, 0xdf, 0xab, 0xc3, 0x85,
    0x05, 0xf1, 0x9e, 0x68, 0x6a, 0x40, 0xba, 0xb4, 0x68, 0x37, 0x9c, 0xc1, 0x0d, 0x29, 0x5d, 0x3f,
    0x48, 0xca, 0xf8, 0xb1, 0x90, 0x8d, 0x10, 0xda, 0x99, 0xe4, 0x32, 0xcd, 0xa1, 0xfd, 0x54, 0x86,
    0x3d, 0x49, 0xd1, 0x2e, 0x1e, 0x95, 0x84, 0xc4, 0x71, 0x27, 0x20, 0x2d, 0x37, 0xce, 0x70, 0x59,
    0xc5, 0x12, 0x1c, 0x34, 0x95, 0x0c, 0x58, 0xba, 0x53, 0x4a, 0x74, 0xa5, 0xf9, 0x2c, 0x1f, 0x77,
    0x21, 0x6f, 0xb1, 0x06, 0x9d, 0x14, 0x6e, 0x04, 0xf6, 0x5e, 0x3c, 0x86, 0xa0, 0xa6, 0xda, 0x6e,
    0xaf, 0xff, 0x84, 0x58, 0x2a, 0x03, 0xa4, 0xcc, 0x42, 0xc7, 0xfc, 0xea, 0x36, 0xb8, 0xe0, 0x90,
    0x9d, 0xfd, 0x04, 0x07, 0x6e, 0xb3, 0x3e, 0x70, 0x1c, 0x9a, 0x70, 0xd6, 0x07, 0xb4, 0x85, 0x01,
    0x6b, 0xb3, 0x33, 0x31, 0x56, 0x0d, 0x27, 0xa5, 0x5f, 0x7b, 0x0c, 0x82, 0xc2, 0x0a, 0xa0, 0x7b,
    0xc8, 0x90, 0xab, 0x41, 0x11, 0x6b, 0x2e, 0x79, 0xdd, 0xd4, 0x1b, 0xfe, 0x05, 0x0f, 0xbc, 0xc7,
    0xfa, 0xa0, 0xa7, 0xc4, 0xf0, 0x1f, 0xc7, 0x53, 0x8d, 0x85, 0xb5, 0x3a, 0x6f, 0xd9, 0x25, 0x5f,
    0x87, 0xce, 0x29, 0xa6, 0xa1, 0x1f, 0xb7, 0xd4, 0xa9, 0x68, 0x4d, 0x7d, 0xf4, 0x51, 0x6a, 0x71,
    0xec, 0xc2, 0x51, 0xbd, 0xaa, 0xdf, 0xda, 0x28, 0xf6, 0xf9, 0xb7, 0x0d, 0xc7, 0xb5, 0xe0, 0x06,
    0xf7, 0x72, 0xf8, 0x2c, 0xd1, 0x8c, 0x97, 0xf0, 0xbe, 0x23, 0x60, 0xf0, 0xd4, 0x91, 0x80, 0xff,
    0xba, 0x30, 0xee, 0xa8, 0xe1, 0x29, 0xbd, 0x02, 0x6e, 0x50, 0x55, 0xd5, 0xcf, 0xe4, 0xec, 0x1b,
    0x07, 0xd0, 0xdf, 0xd8
};
#endif

PyTypeObject *init_KCollapsibleGroupBox(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX].type;

    Shiboken::AutoDecRef Sbk_KCollapsibleGroupBox_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KCollapsibleGroupBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCollapsibleGroupBox",
        "KCollapsibleGroupBox*",
        &Sbk_KCollapsibleGroupBox_spec,
        &Shiboken::callCppDestructor< KCollapsibleGroupBox >,
        Sbk_KCollapsibleGroupBox_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KCollapsibleGroupBox_Type; // references _Sbk_KCollapsibleGroupBox_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCollapsibleGroupBox_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCollapsibleGroupBox_SignatureBytes, KCollapsibleGroupBox_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCollapsibleGroupBox_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCollapsibleGroupBox_PythonToCpp_KCollapsibleGroupBox_PTR,
        is_KCollapsibleGroupBox_PythonToCpp_KCollapsibleGroupBox_PTR_Convertible,
        KCollapsibleGroupBox_PTR_CppToPython_KCollapsibleGroupBox);

    Shiboken::Conversions::registerConverterName(converter, "KCollapsibleGroupBox");
    Shiboken::Conversions::registerConverterName(converter, "KCollapsibleGroupBox*");
    Shiboken::Conversions::registerConverterName(converter, "KCollapsibleGroupBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCollapsibleGroupBox).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KCollapsibleGroupBoxWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KCollapsibleGroupBox_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KCollapsibleGroupBox_TypeF(), &Sbk_KCollapsibleGroupBoxSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KCollapsibleGroupBox_TypeF(), &Sbk_KCollapsibleGroupBox_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KCollapsibleGroupBox::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KCollapsibleGroupBox::staticMetaObject, sizeof(KCollapsibleGroupBoxWrapper));

    return pyType;
}
