
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "khelpmenu_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"

// Argument includes
#include <QString>
#include <khelpmenu.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KHelpMenu_Type = nullptr;
static PyTypeObject *Sbk_KHelpMenu_TypeF(void)
{
    return _Sbk_KHelpMenu_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KHelpMenuWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KHelpMenuWrapper::KHelpMenuWrapper(::QWidget * parent) : KHelpMenu(parent)
{
}

KHelpMenuWrapper::KHelpMenuWrapper(::QWidget * parent, const ::QString & unused, bool showWhatsThis) : KHelpMenu(parent, unused, showWhatsThis)
{
}

void KHelpMenuWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KHelpMenu", funcName, gil, pyOverride, event);
}

void KHelpMenuWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KHelpMenu", funcName, gil, pyOverride, signal);
}

void KHelpMenuWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KHelpMenu", funcName, gil, pyOverride, event);
}

void KHelpMenuWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KHelpMenu", funcName, gil, pyOverride, signal);
}

bool KHelpMenuWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KHelpMenu", funcName, gil, pyOverride, event);
}

bool KHelpMenuWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KHelpMenu", funcName, gil, pyOverride, watched, event);
}

void KHelpMenuWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KHelpMenu_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KHelpMenu", funcName, gil, pyOverride, event);
}

const QMetaObject *KHelpMenuWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KHelpMenu::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KHelpMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KHelpMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KHelpMenuWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KHelpMenuWrapper *>(this));
    }
    return KHelpMenu::qt_metacast(_clname);
}

KHelpMenuWrapper::~KHelpMenuWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KHelpMenu_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KHelpMenu_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KHelpMenu >()))
        return -1;

    KHelpMenuWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KHelpMenu", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KHelpMenu::KHelpMenu(QWidget*=)
    // 1: KHelpMenu::KHelpMenu(QWidget*,QString,bool=)
    if (numArgs == 0) {
        overloadId = 0; // KHelpMenu(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KHelpMenu(QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KHelpMenu(QWidget*,QString,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 1; // KHelpMenu(QWidget*,QString,bool)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KHelpMenu(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KHelpMenu(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KHelpMenuWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KHelpMenuWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KHelpMenu(QWidget *parent, const QString &unused, bool showWhatsThis)
        {
            Shiboken::Warnings::warnDeprecated("KHelpMenu", "KHelpMenu(QWidget *parent, const QString &unused, bool showWhatsThis)");
            if (Shiboken::Errors::occurred() != nullptr)
                return -1;
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"showWhatsThis", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            bool cppArg2 = true;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KHelpMenu(QWidget*,QString,bool)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KHelpMenuWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KHelpMenuWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KHelpMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KHelpMenuFunc_aboutApplication(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // aboutApplication()
        cppSelf->aboutApplication();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_aboutKDE(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // aboutKDE()
        cppSelf->aboutKDE();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KHelpMenu::action(KHelpMenu::MenuId)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_MenuId_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // action(KHelpMenu::MenuId)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "action", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);

    // Call function/method
    {
        ::KHelpMenu::MenuId cppArg0{KHelpMenu::menuHelpContents};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // action(KHelpMenu::MenuId)const
            QAction * cppResult = const_cast<const ::KHelpMenu *>(cppSelf)->action(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KHelpMenuFunc_appHelpActivated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // appHelpActivated()
        cppSelf->appHelpActivated();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_contextHelpActivated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // contextHelpActivated()
        cppSelf->contextHelpActivated();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_donate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // donate()
        cppSelf->donate();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_menu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // menu()
        QMenu * cppResult = cppSelf->menu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KHelpMenuFunc_reportBug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reportBug()
        cppSelf->reportBug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_setShowWhatsThis(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KHelpMenu::setShowWhatsThis(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowWhatsThis(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowWhatsThis", errInfo, SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowWhatsThis(bool)
            cppSelf->setShowWhatsThis(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KHelpMenuFunc_switchApplicationLanguage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // switchApplicationLanguage()
        cppSelf->switchApplicationLanguage();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KHelpMenu_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KHelpMenu_EnumFlagInfo[] = {
    "MenuId:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KHelpMenu_methods[] = {
    {"aboutApplication", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_aboutApplication), METH_NOARGS, nullptr},
    {"aboutKDE", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_aboutKDE), METH_NOARGS, nullptr},
    {"action", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_action), METH_O, nullptr},
    {"appHelpActivated", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_appHelpActivated), METH_NOARGS, nullptr},
    {"contextHelpActivated", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_contextHelpActivated), METH_NOARGS, nullptr},
    {"donate", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_donate), METH_NOARGS, nullptr},
    {"menu", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_menu), METH_NOARGS, nullptr},
    {"reportBug", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_reportBug), METH_NOARGS, nullptr},
    {"setShowWhatsThis", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_setShowWhatsThis), METH_O, nullptr},
    {"switchApplicationLanguage", reinterpret_cast<PyCFunction>(Sbk_KHelpMenuFunc_switchApplicationLanguage), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KHelpMenu_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KHelpMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KHelpMenuWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KHelpMenu_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KHelpMenu_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KHelpMenu_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KHelpMenu_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KHelpMenu_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KHelpMenu_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KHelpMenu_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KHelpMenu_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KHelpMenu_spec = {
    "1:KXmlGui.KHelpMenu",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KHelpMenu_slots
};

} //extern "C"

static void *Sbk_KHelpMenu_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KHelpMenu *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KHelpMenu_MenuId(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KHelpMenu::MenuId>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KHelpMenu::MenuId *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KHelpMenu_MenuId_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KHelpMenu_MenuId_IDX])))
        return Enum_PythonToCpp_KHelpMenu_MenuId;
    return {};
}

static PyObject *KHelpMenu_MenuId_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KHelpMenu::MenuId>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KHelpMenu::MenuId *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KHelpMenu_PythonToCpp_KHelpMenu_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KHelpMenu_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KHelpMenu_PythonToCpp_KHelpMenu_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KHelpMenu_TypeF()))
        return KHelpMenu_PythonToCpp_KHelpMenu_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KHelpMenu_PTR_CppToPython_KHelpMenu(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KHelpMenu *>(const_cast<void *>(cppIn)), Sbk_KHelpMenu_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KHelpMenu_SignatureStrings[] = {
    "1:KXmlGui.KHelpMenu(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:KXmlGui.KHelpMenu(self,parent:PySide6.QtWidgets.QWidget,unused:QString,showWhatsThis:bool=true)",
    "KXmlGui.KHelpMenu.aboutApplication(self)",
    "KXmlGui.KHelpMenu.aboutKDE(self)",
    "KXmlGui.KHelpMenu.action(self,id:KXmlGui.KHelpMenu.MenuId)->PySide6.QtGui.QAction",
    "KXmlGui.KHelpMenu.appHelpActivated(self)",
    "KXmlGui.KHelpMenu.contextHelpActivated(self)",
    "KXmlGui.KHelpMenu.donate(self)",
    "KXmlGui.KHelpMenu.menu(self)->PySide6.QtWidgets.QMenu",
    "KXmlGui.KHelpMenu.reportBug(self)",
    "KXmlGui.KHelpMenu.setShowWhatsThis(self,showWhatsThis:bool)",
    "KXmlGui.KHelpMenu.switchApplicationLanguage(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KHelpMenu_SignatureByteSize = 237;
static constexpr uint8_t KHelpMenu_SignatureBytes[237] = {
    0x78, 0xda, 0x9d, 0x51, 0xd1, 0x4a, 0x03, 0x31, 0x10, 0x7c, 0xef, 0x97, 0x78, 0x70, 0x0d, 0xfa,
    0xe2, 0xc3, 0x41, 0x85, 0x8a, 0xa2, 0x72, 0x16, 0x7a, 0x9c, 0x50, 0x5f, 0xd3, 0xcb, 0x9a, 0x5b,
    0x48, 0x37, 0x21, 0xd9, 0xb4, 0xfa, 0xf7, 0x9a, 0x96, 0xd6, 0xca, 0x5d, 0x40, 0xfa, 0x12, 0x16,
    0x76, 0x66, 0x36, 0x33, 0x73, 0x53, 0xd5, 0xef, 0x1b, 0xf3, 0x14, 0x51, 0xd4, 0xcf, 0x60, 0xdc,
    0x02, 0x28, 0x5e, 0x05, 0x30, 0x1f, 0xa5, 0x93, 0x1e, 0x88, 0xab, 0xe5, 0x57, 0x8b, 0x0a, 0x6e,
    0x45, 0xc3, 0x2b, 0x54, 0x1a, 0x38, 0x88, 0xe6, 0x30, 0xcc, 0x28, 0x1a, 0xe3, 0xd8, 0x17, 0x93,
    0xeb, 0x4b, 0x25, 0xca, 0x48, 0x31, 0x80, 0xaa, 0x9a, 0x96, 0x3d, 0x92, 0x2e, 0x43, 0x6f, 0x77,
    0xab, 0x5e, 0x72, 0x78, 0xeb, 0x31, 0x54, 0x6b, 0x6b, 0xcd, 0x8c, 0x7d, 0x84, 0x62, 0x32, 0xd0,
    0x17, 0x72, 0x6d, 0x23, 0xcf, 0x9d, 0x33, 0xd8, 0x49, 0x46, 0x4b, 0xfb, 0x83, 0x59, 0x60, 0xfd,
    0xf0, 0x98, 0x07, 0x74, 0x27, 0x7e, 0x89, 0x6a, 0x68, 0x45, 0xa4, 0xe7, 0x45, 0x15, 0xd3, 0xbb,
    0x5f, 0x1f, 0x09, 0xd0, 0xcc, 0xf7, 0xc4, 0x31, 0x45, 0xe7, 0xd2, 0x9c, 0xf6, 0x5b, 0xc9, 0xa0,
    0xb2, 0xa7, 0x3b, 0x4b, 0x0c, 0x9f, 0xfc, 0x3f, 0xb0, 0xb2, 0xf4, 0xb3, 0xcf, 0xae, 0x37, 0xc7,
    0xd4, 0xff, 0x7c, 0xf4, 0x14, 0x78, 0xc2, 0x8c, 0xb0, 0x3c, 0x38, 0xeb, 0xf9, 0x3e, 0xea, 0xac,
    0x6e, 0x00, 0x6e, 0xcf, 0x6b, 0x39, 0x04, 0x35, 0x6c, 0x6a, 0x94, 0xbb, 0x43, 0xee, 0xfa, 0xb3,
    0x96, 0x5e, 0x25, 0xe9, 0x28, 0xf5, 0xd1, 0xc5, 0x37, 0xcd, 0x32, 0xe5, 0x5b
};
#endif

PyTypeObject *init_KHelpMenu(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX].type;

    Shiboken::AutoDecRef Sbk_KHelpMenu_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KHelpMenu_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KHelpMenu",
        "KHelpMenu*",
        &Sbk_KHelpMenu_spec,
        &Shiboken::callCppDestructor< KHelpMenu >,
        Sbk_KHelpMenu_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KHelpMenu_Type; // references _Sbk_KHelpMenu_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KHelpMenu_SignatureStrings);
#else
    InitSignatureBytes(pyType, KHelpMenu_SignatureBytes, KHelpMenu_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KHelpMenu_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KHelpMenu_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KHelpMenu_PythonToCpp_KHelpMenu_PTR,
        is_KHelpMenu_PythonToCpp_KHelpMenu_PTR_Convertible,
        KHelpMenu_PTR_CppToPython_KHelpMenu);

    Shiboken::Conversions::registerConverterName(converter, "KHelpMenu");
    Shiboken::Conversions::registerConverterName(converter, "KHelpMenu*");
    Shiboken::Conversions::registerConverterName(converter, "KHelpMenu&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KHelpMenu).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KHelpMenuWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KHelpMenu_TypeF(), &Sbk_KHelpMenu_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KHelpMenu_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'MenuId'.
    const char *MenuId_Initializer[] = {
        "menuHelpContents",
        "menuWhatsThis",
        "menuAboutApp",
        "menuAboutKDE",
        "menuReportBug",
        "menuSwitchLanguage",
        "menuDonate",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t MenuId_InitializerValues[] = {
        uint8_t(KHelpMenu::MenuId::menuHelpContents),   //  0x00  0
        uint8_t(KHelpMenu::MenuId::menuWhatsThis),      //  0x01  1
        uint8_t(KHelpMenu::MenuId::menuAboutApp),       //  0x02  2
        uint8_t(KHelpMenu::MenuId::menuAboutKDE),       //  0x03  3
        uint8_t(KHelpMenu::MenuId::menuReportBug),      //  0x04  4
        uint8_t(KHelpMenu::MenuId::menuSwitchLanguage), //  0x05  5
        uint8_t(KHelpMenu::MenuId::menuDonate)          //  0x06  6
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KHelpMenu_TypeF(),
        "1:KXmlGui.KHelpMenu.MenuId",
        MenuId_Initializer, MenuId_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KHelpMenu_MenuId_IDX].type = EType;
    // Register converter for enum 'KHelpMenu::MenuId'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KHelpMenu_MenuId_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KHelpMenu_MenuId,
            is_Enum_PythonToCpp_KHelpMenu_MenuId_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KHelpMenu::MenuId");
        Shiboken::Conversions::registerConverterAlias(converter, "MenuId");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'MenuId' enum.

    PySide::Signal::registerSignals(pyType, &::KHelpMenu::staticMetaObject);
    qRegisterMetaType< ::KHelpMenu::MenuId >("KHelpMenu::MenuId");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KHelpMenu::staticMetaObject, sizeof(KHelpMenuWrapper));

    return pyType;
}
