
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "ktooltiphelper_wrapper.h"

// Argument includes
#include <QString>
#include <ktooltiphelper.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KToolTipHelper_Type = nullptr;
static PyTypeObject *Sbk_KToolTipHelper_TypeF(void)
{
    return _Sbk_KToolTipHelper_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KToolTipHelper_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("KToolTipHelper");
    return -1;
}

static PyObject *Sbk_KToolTipHelperFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KToolTipHelper *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KToolTipHelper::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolTipHelperFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        KToolTipHelper * cppResult = ::KToolTipHelper::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KToolTipHelperFunc_whatsThisHintOnly(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // whatsThisHintOnly()
        const QString cppResult = ::KToolTipHelper::whatsThisHintOnly();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KToolTipHelper_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KToolTipHelper_methods[] = {
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KToolTipHelperFunc_eventFilter), METH_VARARGS, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_KToolTipHelperFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"whatsThisHintOnly", reinterpret_cast<PyCFunction>(Sbk_KToolTipHelperFunc_whatsThisHintOnly), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KToolTipHelper_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KToolTipHelper_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KToolTipHelper_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KToolTipHelper_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KToolTipHelper_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KToolTipHelper_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KToolTipHelper_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KToolTipHelper_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KToolTipHelper_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KToolTipHelper_spec = {
    "1:KXmlGui.KToolTipHelper",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KToolTipHelper_slots
};

} //extern "C"

static void *Sbk_KToolTipHelper_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KToolTipHelper *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KToolTipHelper_PythonToCpp_KToolTipHelper_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KToolTipHelper_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KToolTipHelper_PythonToCpp_KToolTipHelper_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KToolTipHelper_TypeF()))
        return KToolTipHelper_PythonToCpp_KToolTipHelper_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KToolTipHelper_PTR_CppToPython_KToolTipHelper(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KToolTipHelper *>(const_cast<void *>(cppIn)), Sbk_KToolTipHelper_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KToolTipHelper_SignatureStrings[] = {
    "KXmlGui.KToolTipHelper.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KXmlGui.KToolTipHelper.instance()->KXmlGui.KToolTipHelper",
    "KXmlGui.KToolTipHelper.whatsThisHintOnly()->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KToolTipHelper_SignatureByteSize = 136;
static constexpr uint8_t KToolTipHelper_SignatureBytes[136] = {
    0x78, 0xda, 0x75, 0x8d, 0x31, 0x0f, 0x82, 0x30, 0x10, 0x85, 0x77, 0x7e, 0x09, 0x26, 0xd8, 0xd1,
    0xc1, 0xc1, 0xc5, 0xa8, 0x24, 0x0c, 0xd8, 0xd0, 0xc1, 0xb5, 0x94, 0xd3, 0x9e, 0x39, 0xae, 0xa4,
    0x3d, 0x25, 0xfc, 0x7b, 0xc1, 0x55, 0x5c, 0xdf, 0xfb, 0xde, 0xf7, 0xaa, 0x5b, 0x4f, 0x97, 0x17,
    0xaa, 0xca, 0x84, 0x40, 0x06, 0x87, 0x12, 0x68, 0x80, 0xa8, 0xe0, 0x0d, 0x2c, 0x67, 0x24, 0x81,
    0x98, 0x27, 0xa0, 0x7b, 0x31, 0x5a, 0x71, 0x1e, 0xba, 0xfd, 0x75, 0x6a, 0xb0, 0x83, 0x9d, 0xd2,
    0x72, 0x0c, 0x11, 0x94, 0xae, 0xdb, 0x27, 0x38, 0x29, 0xbe, 0xfc, 0x4f, 0x79, 0x5a, 0xd2, 0xcd,
    0xf6, 0xd0, 0xce, 0xee, 0xac, 0x5a, 0x7f, 0x42, 0x4e, 0x62, 0xd9, 0x41, 0x3e, 0x73, 0xeb, 0xc8,
    0xbf, 0xe5, 0xe8, 0xad, 0x24, 0xe3, 0x31, 0x95, 0xc8, 0x52, 0x33, 0x4d, 0x8b, 0x42, 0x37, 0x12,
    0x91, 0x1f, 0xd9, 0x07, 0x45, 0x38, 0x4e, 0x05
};
#endif

PyTypeObject *init_KToolTipHelper(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX].type;

    Shiboken::AutoDecRef Sbk_KToolTipHelper_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KToolTipHelper_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KToolTipHelper",
        "KToolTipHelper*",
        &Sbk_KToolTipHelper_spec,
        nullptr,
        Sbk_KToolTipHelper_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KToolTipHelper_Type; // references _Sbk_KToolTipHelper_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KToolTipHelper_SignatureStrings);
#else
    InitSignatureBytes(pyType, KToolTipHelper_SignatureBytes, KToolTipHelper_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KToolTipHelper_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KToolTipHelper_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KToolTipHelper_PythonToCpp_KToolTipHelper_PTR,
        is_KToolTipHelper_PythonToCpp_KToolTipHelper_PTR_Convertible,
        KToolTipHelper_PTR_CppToPython_KToolTipHelper);

    Shiboken::Conversions::registerConverterName(converter, "KToolTipHelper");
    Shiboken::Conversions::registerConverterName(converter, "KToolTipHelper*");
    Shiboken::Conversions::registerConverterName(converter, "KToolTipHelper&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KToolTipHelper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KToolTipHelper_TypeF(), &Sbk_KToolTipHelper_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KToolTipHelper::staticMetaObject, sizeof(::KToolTipHelper));

    return pyType;
}
