// This file is auto-generated, don't edit it. Thanks.
package client

import (
	openapi "github.com/alibabacloud-go/darabonba-openapi/v2/client"
	openapiutil "github.com/alibabacloud-go/darabonba-openapi/v2/utils"
	"github.com/alibabacloud-go/tea/dara"
)

type Client struct {
	openapi.Client
	DisableSDKError *bool
}

func NewClient(config *openapiutil.Config) (*Client, error) {
	client := new(Client)
	err := client.Init(config)
	return client, err
}

func (client *Client) Init(config *openapiutil.Config) (_err error) {
	_err = client.Client.Init(config)
	if _err != nil {
		return _err
	}
	client.EndpointRule = dara.String("central")
	_err = client.CheckConfig(config)
	if _err != nil {
		return _err
	}
	client.Endpoint, _err = GetEndpoint(client,dara.String("alidns"), client.RegionId, client.EndpointRule, client.Network, client.Suffix, client.EndpointMap, client.Endpoint)
	if _err != nil {
		return _err
	}

	return nil
}

func GetEndpoint(client *Client, productId *string, regionId *string, endpointRule *string, network *string, suffix *string, endpointMap map[string]*string, endpoint *string) (_result *string, _err error) {
	if !dara.IsNil(endpoint) {
		_result = endpoint
		return _result, _err
	}

	if !dara.IsNil(endpointMap) && !dara.IsNil(endpointMap[dara.StringValue(regionId)]) {
		_result = endpointMap[dara.StringValue(regionId)]
		return _result, _err
	}

	_body, _err := openapiutil.GetEndpointRules(productId, regionId, endpointRule, network, suffix)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds a custom line to the domain name.
//
// Description:
//
// In each CIDR block, the end IP address must be greater than or equal to the start IP address.\\
//
// The CIDR blocks that are specified for all custom lines of a domain name cannot be overlapped.
//
// @param request - AddCustomLineRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddCustomLineResponse
func AddCustomLineWithOptions(client *Client, request *AddCustomLineRequest, runtime *dara.RuntimeOptions) (_result *AddCustomLineResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.IpSegment) {
		query["IpSegment"] = request.IpSegment
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LineName) {
		query["LineName"] = request.LineName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddCustomLine"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddCustomLineResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds a custom line to the domain name.
//
// Description:
//
// In each CIDR block, the end IP address must be greater than or equal to the start IP address.\\
//
// The CIDR blocks that are specified for all custom lines of a domain name cannot be overlapped.
//
// @param request - AddCustomLineRequest
//
// @return AddCustomLineResponse
func AddCustomLine(client *Client, request *AddCustomLineRequest) (_result *AddCustomLineResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddCustomLineResponse{}
	_body, _err := AddCustomLineWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds a cache-accelerated domain name based on the specified parameters.
//
// @param request - AddDnsCacheDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDnsCacheDomainResponse
func AddDnsCacheDomainWithOptions(client *Client, request *AddDnsCacheDomainRequest, runtime *dara.RuntimeOptions) (_result *AddDnsCacheDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.CacheTtlMax) {
		query["CacheTtlMax"] = request.CacheTtlMax
	}

	if !dara.IsNil(request.CacheTtlMin) {
		query["CacheTtlMin"] = request.CacheTtlMin
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.SourceDnsServer) {
		query["SourceDnsServer"] = request.SourceDnsServer
	}

	if !dara.IsNil(request.SourceEdns) {
		query["SourceEdns"] = request.SourceEdns
	}

	if !dara.IsNil(request.SourceProtocol) {
		query["SourceProtocol"] = request.SourceProtocol
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDnsCacheDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDnsCacheDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds a cache-accelerated domain name based on the specified parameters.
//
// @param request - AddDnsCacheDomainRequest
//
// @return AddDnsCacheDomainResponse
func AddDnsCacheDomain(client *Client, request *AddDnsCacheDomainRequest) (_result *AddDnsCacheDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDnsCacheDomainResponse{}
	_body, _err := AddDnsCacheDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates an access policy.
//
// @param request - AddDnsGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDnsGtmAccessStrategyResponse
func AddDnsGtmAccessStrategyWithOptions(client *Client, request *AddDnsGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *AddDnsGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DefaultAddrPool) {
		query["DefaultAddrPool"] = request.DefaultAddrPool
	}

	if !dara.IsNil(request.DefaultAddrPoolType) {
		query["DefaultAddrPoolType"] = request.DefaultAddrPoolType
	}

	if !dara.IsNil(request.DefaultLatencyOptimization) {
		query["DefaultLatencyOptimization"] = request.DefaultLatencyOptimization
	}

	if !dara.IsNil(request.DefaultLbaStrategy) {
		query["DefaultLbaStrategy"] = request.DefaultLbaStrategy
	}

	if !dara.IsNil(request.DefaultMaxReturnAddrNum) {
		query["DefaultMaxReturnAddrNum"] = request.DefaultMaxReturnAddrNum
	}

	if !dara.IsNil(request.DefaultMinAvailableAddrNum) {
		query["DefaultMinAvailableAddrNum"] = request.DefaultMinAvailableAddrNum
	}

	if !dara.IsNil(request.FailoverAddrPool) {
		query["FailoverAddrPool"] = request.FailoverAddrPool
	}

	if !dara.IsNil(request.FailoverAddrPoolType) {
		query["FailoverAddrPoolType"] = request.FailoverAddrPoolType
	}

	if !dara.IsNil(request.FailoverLatencyOptimization) {
		query["FailoverLatencyOptimization"] = request.FailoverLatencyOptimization
	}

	if !dara.IsNil(request.FailoverLbaStrategy) {
		query["FailoverLbaStrategy"] = request.FailoverLbaStrategy
	}

	if !dara.IsNil(request.FailoverMaxReturnAddrNum) {
		query["FailoverMaxReturnAddrNum"] = request.FailoverMaxReturnAddrNum
	}

	if !dara.IsNil(request.FailoverMinAvailableAddrNum) {
		query["FailoverMinAvailableAddrNum"] = request.FailoverMinAvailableAddrNum
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Lines) {
		query["Lines"] = request.Lines
	}

	if !dara.IsNil(request.StrategyMode) {
		query["StrategyMode"] = request.StrategyMode
	}

	if !dara.IsNil(request.StrategyName) {
		query["StrategyName"] = request.StrategyName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDnsGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDnsGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates an access policy.
//
// @param request - AddDnsGtmAccessStrategyRequest
//
// @return AddDnsGtmAccessStrategyResponse
func AddDnsGtmAccessStrategy(client *Client, request *AddDnsGtmAccessStrategyRequest) (_result *AddDnsGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDnsGtmAccessStrategyResponse{}
	_body, _err := AddDnsGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - AddDnsGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDnsGtmAddressPoolResponse
func AddDnsGtmAddressPoolWithOptions(client *Client, request *AddDnsGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *AddDnsGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Addr) {
		query["Addr"] = request.Addr
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LbaStrategy) {
		query["LbaStrategy"] = request.LbaStrategy
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.MonitorStatus) {
		query["MonitorStatus"] = request.MonitorStatus
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDnsGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDnsGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - AddDnsGtmAddressPoolRequest
//
// @return AddDnsGtmAddressPoolResponse
func AddDnsGtmAddressPool(client *Client, request *AddDnsGtmAddressPoolRequest) (_result *AddDnsGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDnsGtmAddressPoolResponse{}
	_body, _err := AddDnsGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a health check task.
//
// Description:
//
// **
//
// @param request - AddDnsGtmMonitorRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDnsGtmMonitorResponse
func AddDnsGtmMonitorWithOptions(client *Client, request *AddDnsGtmMonitorRequest, runtime *dara.RuntimeOptions) (_result *AddDnsGtmMonitorResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDnsGtmMonitor"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDnsGtmMonitorResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a health check task.
//
// Description:
//
// **
//
// @param request - AddDnsGtmMonitorRequest
//
// @return AddDnsGtmMonitorResponse
func AddDnsGtmMonitor(client *Client, request *AddDnsGtmMonitorRequest) (_result *AddDnsGtmMonitorResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDnsGtmMonitorResponse{}
	_body, _err := AddDnsGtmMonitorWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds a domain name based on the specified parameters.
//
// Description:
//
// # For more information about how to check whether a domain name is valid, see
//
// [Domain name validity](https://www.alibabacloud.com/help/zh/doc-detail/67788.htm).
//
// @param request - AddDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDomainResponse
func AddDomainWithOptions(client *Client, request *AddDomainRequest, runtime *dara.RuntimeOptions) (_result *AddDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.ResourceGroupId) {
		query["ResourceGroupId"] = request.ResourceGroupId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds a domain name based on the specified parameters.
//
// Description:
//
// # For more information about how to check whether a domain name is valid, see
//
// [Domain name validity](https://www.alibabacloud.com/help/zh/doc-detail/67788.htm).
//
// @param request - AddDomainRequest
//
// @return AddDomainResponse
func AddDomain(client *Client, request *AddDomainRequest) (_result *AddDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDomainResponse{}
	_body, _err := AddDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a backup task for a domain name.
//
// @param request - AddDomainBackupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDomainBackupResponse
func AddDomainBackupWithOptions(client *Client, request *AddDomainBackupRequest, runtime *dara.RuntimeOptions) (_result *AddDomainBackupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PeriodType) {
		query["PeriodType"] = request.PeriodType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDomainBackup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDomainBackupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a backup task for a domain name.
//
// @param request - AddDomainBackupRequest
//
// @return AddDomainBackupResponse
func AddDomainBackup(client *Client, request *AddDomainBackupRequest) (_result *AddDomainBackupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDomainBackupResponse{}
	_body, _err := AddDomainBackupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a domain name group based on the specified parameters.
//
// @param request - AddDomainGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDomainGroupResponse
func AddDomainGroupWithOptions(client *Client, request *AddDomainGroupRequest, runtime *dara.RuntimeOptions) (_result *AddDomainGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.GroupName) {
		query["GroupName"] = request.GroupName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDomainGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDomainGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a domain name group based on the specified parameters.
//
// @param request - AddDomainGroupRequest
//
// @return AddDomainGroupResponse
func AddDomainGroup(client *Client, request *AddDomainGroupRequest) (_result *AddDomainGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDomainGroupResponse{}
	_body, _err := AddDomainGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - AddDomainRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddDomainRecordResponse
func AddDomainRecordWithOptions(client *Client, request *AddDomainRecordRequest, runtime *dara.RuntimeOptions) (_result *AddDomainRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Line) {
		query["Line"] = request.Line
	}

	if !dara.IsNil(request.Priority) {
		query["Priority"] = request.Priority
	}

	if !dara.IsNil(request.RR) {
		query["RR"] = request.RR
	}

	if !dara.IsNil(request.TTL) {
		query["TTL"] = request.TTL
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.Value) {
		query["Value"] = request.Value
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddDomainRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddDomainRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - AddDomainRecordRequest
//
// @return AddDomainRecordResponse
func AddDomainRecord(client *Client, request *AddDomainRecordRequest) (_result *AddDomainRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddDomainRecordResponse{}
	_body, _err := AddDomainRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - AddGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddGtmAccessStrategyResponse
func AddGtmAccessStrategyWithOptions(client *Client, request *AddGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *AddGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccessLines) {
		query["AccessLines"] = request.AccessLines
	}

	if !dara.IsNil(request.DefaultAddrPoolId) {
		query["DefaultAddrPoolId"] = request.DefaultAddrPoolId
	}

	if !dara.IsNil(request.FailoverAddrPoolId) {
		query["FailoverAddrPoolId"] = request.FailoverAddrPoolId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyName) {
		query["StrategyName"] = request.StrategyName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - AddGtmAccessStrategyRequest
//
// @return AddGtmAccessStrategyResponse
func AddGtmAccessStrategy(client *Client, request *AddGtmAccessStrategyRequest) (_result *AddGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddGtmAccessStrategyResponse{}
	_body, _err := AddGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - AddGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddGtmAddressPoolResponse
func AddGtmAddressPoolWithOptions(client *Client, request *AddGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *AddGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Addr) {
		query["Addr"] = request.Addr
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MinAvailableAddrNum) {
		query["MinAvailableAddrNum"] = request.MinAvailableAddrNum
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.MonitorStatus) {
		query["MonitorStatus"] = request.MonitorStatus
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - AddGtmAddressPoolRequest
//
// @return AddGtmAddressPoolResponse
func AddGtmAddressPool(client *Client, request *AddGtmAddressPoolRequest) (_result *AddGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddGtmAddressPoolResponse{}
	_body, _err := AddGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a health check task.
//
// @param request - AddGtmMonitorRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddGtmMonitorResponse
func AddGtmMonitorWithOptions(client *Client, request *AddGtmMonitorRequest, runtime *dara.RuntimeOptions) (_result *AddGtmMonitorResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddGtmMonitor"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddGtmMonitorResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a health check task.
//
// @param request - AddGtmMonitorRequest
//
// @return AddGtmMonitorResponse
func AddGtmMonitor(client *Client, request *AddGtmMonitorRequest) (_result *AddGtmMonitorResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddGtmMonitorResponse{}
	_body, _err := AddGtmMonitorWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a disaster recovery plan.
//
// @param request - AddGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddGtmRecoveryPlanResponse
func AddGtmRecoveryPlanWithOptions(client *Client, request *AddGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *AddGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.FaultAddrPool) {
		query["FaultAddrPool"] = request.FaultAddrPool
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a disaster recovery plan.
//
// @param request - AddGtmRecoveryPlanRequest
//
// @return AddGtmRecoveryPlanResponse
func AddGtmRecoveryPlan(client *Client, request *AddGtmRecoveryPlanRequest) (_result *AddGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddGtmRecoveryPlanResponse{}
	_body, _err := AddGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 新增递归解析内置权威解析记录
//
// @param request - AddRecursionRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddRecursionRecordResponse
func AddRecursionRecordWithOptions(client *Client, request *AddRecursionRecordRequest, runtime *dara.RuntimeOptions) (_result *AddRecursionRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Priority) {
		query["Priority"] = request.Priority
	}

	if !dara.IsNil(request.RequestSource) {
		query["RequestSource"] = request.RequestSource
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.Value) {
		query["Value"] = request.Value
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddRecursionRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddRecursionRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 新增递归解析内置权威解析记录
//
// @param request - AddRecursionRecordRequest
//
// @return AddRecursionRecordResponse
func AddRecursionRecord(client *Client, request *AddRecursionRecordRequest) (_result *AddRecursionRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddRecursionRecordResponse{}
	_body, _err := AddRecursionRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 新增递归解析内置权威域名zone
//
// @param request - AddRecursionZoneRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return AddRecursionZoneResponse
func AddRecursionZoneWithOptions(client *Client, request *AddRecursionZoneRequest, runtime *dara.RuntimeOptions) (_result *AddRecursionZoneResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ProxyPattern) {
		query["ProxyPattern"] = request.ProxyPattern
	}

	if !dara.IsNil(request.ZoneName) {
		query["ZoneName"] = request.ZoneName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("AddRecursionZone"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &AddRecursionZoneResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 新增递归解析内置权威域名zone
//
// @param request - AddRecursionZoneRequest
//
// @return AddRecursionZoneResponse
func AddRecursionZone(client *Client, request *AddRecursionZoneRequest) (_result *AddRecursionZoneResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &AddRecursionZoneResponse{}
	_body, _err := AddRecursionZoneWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Binds one or more domain names to a paid Alibaba Cloud DNS instance.
//
// Description:
//
// A paid Alibaba Cloud DNS instance whose ID starts with dns is an instance of the new version. You can call this API operation to bind multiple domain names to the instance. If the upper limit is exceeded, an error message is returned.\\
//
// A paid Alibaba Cloud DNS instance whose ID does not start with dns is an instance of the old version. You can call this API operation to bind only one domain name to the instance. However, if the instance is already bound to a domain name, you must unbind the original domain name from the instance and bind the desired domain name to the instance.
//
// @param request - BindInstanceDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return BindInstanceDomainsResponse
func BindInstanceDomainsWithOptions(client *Client, request *BindInstanceDomainsRequest, runtime *dara.RuntimeOptions) (_result *BindInstanceDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainNames) {
		query["DomainNames"] = request.DomainNames
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("BindInstanceDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &BindInstanceDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Binds one or more domain names to a paid Alibaba Cloud DNS instance.
//
// Description:
//
// A paid Alibaba Cloud DNS instance whose ID starts with dns is an instance of the new version. You can call this API operation to bind multiple domain names to the instance. If the upper limit is exceeded, an error message is returned.\\
//
// A paid Alibaba Cloud DNS instance whose ID does not start with dns is an instance of the old version. You can call this API operation to bind only one domain name to the instance. However, if the instance is already bound to a domain name, you must unbind the original domain name from the instance and bind the desired domain name to the instance.
//
// @param request - BindInstanceDomainsRequest
//
// @return BindInstanceDomainsResponse
func BindInstanceDomains(client *Client, request *BindInstanceDomainsRequest) (_result *BindInstanceDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &BindInstanceDomainsResponse{}
	_body, _err := BindInstanceDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Moves a domain name from the original group to the new group based on the specified parameters.
//
// Description:
//
// You can specify GroupId to move a domain name to a specific domain name group. You can move the domain name to the group that contains all domain names or the default group.
//
// @param request - ChangeDomainGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ChangeDomainGroupResponse
func ChangeDomainGroupWithOptions(client *Client, request *ChangeDomainGroupRequest, runtime *dara.RuntimeOptions) (_result *ChangeDomainGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ChangeDomainGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ChangeDomainGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Moves a domain name from the original group to the new group based on the specified parameters.
//
// Description:
//
// You can specify GroupId to move a domain name to a specific domain name group. You can move the domain name to the group that contains all domain names or the default group.
//
// @param request - ChangeDomainGroupRequest
//
// @return ChangeDomainGroupResponse
func ChangeDomainGroup(client *Client, request *ChangeDomainGroupRequest) (_result *ChangeDomainGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ChangeDomainGroupResponse{}
	_body, _err := ChangeDomainGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Changes the domain name that is bound to an Alibaba Cloud DNS instance.
//
// Description:
//
//	  **You can call this operation regardless of whether the Alibaba Cloud DNS instance is bound to a domain name. You can also call this operation to unbind the domain name from the Alibaba Cloud DNS instance by leaving the NewDomain parameter empty.**
//
//		- **This operation applies to instances of the custom edition. To change the domain name that is bound to an Alibaba Cloud DNS instance of Personal Edition, Enterprise Standard Edition, or Enterprise Ultimate Edition, call the BindInstanceDomains operation.
//
// @param request - ChangeDomainOfDnsProductRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ChangeDomainOfDnsProductResponse
func ChangeDomainOfDnsProductWithOptions(client *Client, request *ChangeDomainOfDnsProductRequest, runtime *dara.RuntimeOptions) (_result *ChangeDomainOfDnsProductResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Force) {
		query["Force"] = request.Force
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NewDomain) {
		query["NewDomain"] = request.NewDomain
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ChangeDomainOfDnsProduct"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ChangeDomainOfDnsProductResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Changes the domain name that is bound to an Alibaba Cloud DNS instance.
//
// Description:
//
//	  **You can call this operation regardless of whether the Alibaba Cloud DNS instance is bound to a domain name. You can also call this operation to unbind the domain name from the Alibaba Cloud DNS instance by leaving the NewDomain parameter empty.**
//
//		- **This operation applies to instances of the custom edition. To change the domain name that is bound to an Alibaba Cloud DNS instance of Personal Edition, Enterprise Standard Edition, or Enterprise Ultimate Edition, call the BindInstanceDomains operation.
//
// @param request - ChangeDomainOfDnsProductRequest
//
// @return ChangeDomainOfDnsProductResponse
func ChangeDomainOfDnsProduct(client *Client, request *ChangeDomainOfDnsProductRequest) (_result *ChangeDomainOfDnsProductResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ChangeDomainOfDnsProductResponse{}
	_body, _err := ChangeDomainOfDnsProductWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Copies the configurations of a Global Traffic Manager (GTM) instance.
//
// @param request - CopyGtmConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CopyGtmConfigResponse
func CopyGtmConfigWithOptions(client *Client, request *CopyGtmConfigRequest, runtime *dara.RuntimeOptions) (_result *CopyGtmConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.CopyType) {
		query["CopyType"] = request.CopyType
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.SourceId) {
		query["SourceId"] = request.SourceId
	}

	if !dara.IsNil(request.TargetId) {
		query["TargetId"] = request.TargetId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CopyGtmConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CopyGtmConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Copies the configurations of a Global Traffic Manager (GTM) instance.
//
// @param request - CopyGtmConfigRequest
//
// @return CopyGtmConfigResponse
func CopyGtmConfig(client *Client, request *CopyGtmConfigRequest) (_result *CopyGtmConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CopyGtmConfigResponse{}
	_body, _err := CopyGtmConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates an address.
//
// @param tmpReq - CreateCloudGtmAddressRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreateCloudGtmAddressResponse
func CreateCloudGtmAddressWithOptions(client *Client, tmpReq *CreateCloudGtmAddressRequest, runtime *dara.RuntimeOptions) (_result *CreateCloudGtmAddressResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &CreateCloudGtmAddressShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.HealthTasks) {
		request.HealthTasksShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.HealthTasks, dara.String("HealthTasks"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.Address) {
		query["Address"] = request.Address
	}

	if !dara.IsNil(request.AttributeInfo) {
		query["AttributeInfo"] = request.AttributeInfo
	}

	if !dara.IsNil(request.AvailableMode) {
		query["AvailableMode"] = request.AvailableMode
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthJudgement) {
		query["HealthJudgement"] = request.HealthJudgement
	}

	if !dara.IsNil(request.HealthTasksShrink) {
		query["HealthTasks"] = request.HealthTasksShrink
	}

	if !dara.IsNil(request.ManualAvailableStatus) {
		query["ManualAvailableStatus"] = request.ManualAvailableStatus
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreateCloudGtmAddress"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreateCloudGtmAddressResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates an address.
//
// @param request - CreateCloudGtmAddressRequest
//
// @return CreateCloudGtmAddressResponse
func CreateCloudGtmAddress(client *Client, request *CreateCloudGtmAddressRequest) (_result *CreateCloudGtmAddressResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreateCloudGtmAddressResponse{}
	_body, _err := CreateCloudGtmAddressWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - CreateCloudGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreateCloudGtmAddressPoolResponse
func CreateCloudGtmAddressPoolWithOptions(client *Client, request *CreateCloudGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *CreateCloudGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolName) {
		query["AddressPoolName"] = request.AddressPoolName
	}

	if !dara.IsNil(request.AddressPoolType) {
		query["AddressPoolType"] = request.AddressPoolType
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthJudgement) {
		query["HealthJudgement"] = request.HealthJudgement
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreateCloudGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreateCloudGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates an address pool.
//
// @param request - CreateCloudGtmAddressPoolRequest
//
// @return CreateCloudGtmAddressPoolResponse
func CreateCloudGtmAddressPool(client *Client, request *CreateCloudGtmAddressPoolRequest) (_result *CreateCloudGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreateCloudGtmAddressPoolResponse{}
	_body, _err := CreateCloudGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - CreateCloudGtmInstanceConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreateCloudGtmInstanceConfigResponse
func CreateCloudGtmInstanceConfigWithOptions(client *Client, request *CreateCloudGtmInstanceConfigRequest, runtime *dara.RuntimeOptions) (_result *CreateCloudGtmInstanceConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ScheduleHostname) {
		query["ScheduleHostname"] = request.ScheduleHostname
	}

	if !dara.IsNil(request.ScheduleRrType) {
		query["ScheduleRrType"] = request.ScheduleRrType
	}

	if !dara.IsNil(request.ScheduleZoneMode) {
		query["ScheduleZoneMode"] = request.ScheduleZoneMode
	}

	if !dara.IsNil(request.ScheduleZoneName) {
		query["ScheduleZoneName"] = request.ScheduleZoneName
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreateCloudGtmInstanceConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreateCloudGtmInstanceConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - CreateCloudGtmInstanceConfigRequest
//
// @return CreateCloudGtmInstanceConfigResponse
func CreateCloudGtmInstanceConfig(client *Client, request *CreateCloudGtmInstanceConfigRequest) (_result *CreateCloudGtmInstanceConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreateCloudGtmInstanceConfigResponse{}
	_body, _err := CreateCloudGtmInstanceConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Creates a health check template.
//
// @param tmpReq - CreateCloudGtmMonitorTemplateRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreateCloudGtmMonitorTemplateResponse
func CreateCloudGtmMonitorTemplateWithOptions(client *Client, tmpReq *CreateCloudGtmMonitorTemplateRequest, runtime *dara.RuntimeOptions) (_result *CreateCloudGtmMonitorTemplateResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &CreateCloudGtmMonitorTemplateShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.IspCityNodes) {
		request.IspCityNodesShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.IspCityNodes, dara.String("IspCityNodes"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.ExtendInfo) {
		query["ExtendInfo"] = request.ExtendInfo
	}

	if !dara.IsNil(request.FailureRate) {
		query["FailureRate"] = request.FailureRate
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IpVersion) {
		query["IpVersion"] = request.IpVersion
	}

	if !dara.IsNil(request.IspCityNodesShrink) {
		query["IspCityNodes"] = request.IspCityNodesShrink
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.Protocol) {
		query["Protocol"] = request.Protocol
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreateCloudGtmMonitorTemplate"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreateCloudGtmMonitorTemplateResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Creates a health check template.
//
// @param request - CreateCloudGtmMonitorTemplateRequest
//
// @return CreateCloudGtmMonitorTemplateResponse
func CreateCloudGtmMonitorTemplate(client *Client, request *CreateCloudGtmMonitorTemplateRequest) (_result *CreateCloudGtmMonitorTemplateResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreateCloudGtmMonitorTemplateResponse{}
	_body, _err := CreateCloudGtmMonitorTemplateWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 创建公共DNS AppKey
//
// @param request - CreatePdnsAppKeyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreatePdnsAppKeyResponse
func CreatePdnsAppKeyWithOptions(client *Client, request *CreatePdnsAppKeyRequest, runtime *dara.RuntimeOptions) (_result *CreatePdnsAppKeyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreatePdnsAppKey"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreatePdnsAppKeyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 创建公共DNS AppKey
//
// @param request - CreatePdnsAppKeyRequest
//
// @return CreatePdnsAppKeyResponse
func CreatePdnsAppKey(client *Client, request *CreatePdnsAppKeyRequest) (_result *CreatePdnsAppKeyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreatePdnsAppKeyResponse{}
	_body, _err := CreatePdnsAppKeyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 创建公共DNS Udp Ip地址段
//
// @param request - CreatePdnsUdpIpSegmentRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return CreatePdnsUdpIpSegmentResponse
func CreatePdnsUdpIpSegmentWithOptions(client *Client, request *CreatePdnsUdpIpSegmentRequest, runtime *dara.RuntimeOptions) (_result *CreatePdnsUdpIpSegmentResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Ip) {
		query["Ip"] = request.Ip
	}

	if !dara.IsNil(request.IpToken) {
		query["IpToken"] = request.IpToken
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("CreatePdnsUdpIpSegment"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &CreatePdnsUdpIpSegmentResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 创建公共DNS Udp Ip地址段
//
// @param request - CreatePdnsUdpIpSegmentRequest
//
// @return CreatePdnsUdpIpSegmentResponse
func CreatePdnsUdpIpSegment(client *Client, request *CreatePdnsUdpIpSegmentRequest) (_result *CreatePdnsUdpIpSegmentResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &CreatePdnsUdpIpSegmentResponse{}
	_body, _err := CreatePdnsUdpIpSegmentWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes an address.
//
// @param request - DeleteCloudGtmAddressRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteCloudGtmAddressResponse
func DeleteCloudGtmAddressWithOptions(client *Client, request *DeleteCloudGtmAddressRequest, runtime *dara.RuntimeOptions) (_result *DeleteCloudGtmAddressResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteCloudGtmAddress"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteCloudGtmAddressResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes an address.
//
// @param request - DeleteCloudGtmAddressRequest
//
// @return DeleteCloudGtmAddressResponse
func DeleteCloudGtmAddress(client *Client, request *DeleteCloudGtmAddressRequest) (_result *DeleteCloudGtmAddressResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteCloudGtmAddressResponse{}
	_body, _err := DeleteCloudGtmAddressWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes an address pool.
//
// @param request - DeleteCloudGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteCloudGtmAddressPoolResponse
func DeleteCloudGtmAddressPoolWithOptions(client *Client, request *DeleteCloudGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DeleteCloudGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteCloudGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteCloudGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes an address pool.
//
// @param request - DeleteCloudGtmAddressPoolRequest
//
// @return DeleteCloudGtmAddressPoolResponse
func DeleteCloudGtmAddressPool(client *Client, request *DeleteCloudGtmAddressPoolRequest) (_result *DeleteCloudGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteCloudGtmAddressPoolResponse{}
	_body, _err := DeleteCloudGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes an access domain name that is configured for a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - DeleteCloudGtmInstanceConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteCloudGtmInstanceConfigResponse
func DeleteCloudGtmInstanceConfigWithOptions(client *Client, request *DeleteCloudGtmInstanceConfigRequest, runtime *dara.RuntimeOptions) (_result *DeleteCloudGtmInstanceConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteCloudGtmInstanceConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteCloudGtmInstanceConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes an access domain name that is configured for a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - DeleteCloudGtmInstanceConfigRequest
//
// @return DeleteCloudGtmInstanceConfigResponse
func DeleteCloudGtmInstanceConfig(client *Client, request *DeleteCloudGtmInstanceConfigRequest) (_result *DeleteCloudGtmInstanceConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteCloudGtmInstanceConfigResponse{}
	_body, _err := DeleteCloudGtmInstanceConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes a health check template.
//
// @param request - DeleteCloudGtmMonitorTemplateRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteCloudGtmMonitorTemplateResponse
func DeleteCloudGtmMonitorTemplateWithOptions(client *Client, request *DeleteCloudGtmMonitorTemplateRequest, runtime *dara.RuntimeOptions) (_result *DeleteCloudGtmMonitorTemplateResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.TemplateId) {
		query["TemplateId"] = request.TemplateId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteCloudGtmMonitorTemplate"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteCloudGtmMonitorTemplateResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes a health check template.
//
// @param request - DeleteCloudGtmMonitorTemplateRequest
//
// @return DeleteCloudGtmMonitorTemplateResponse
func DeleteCloudGtmMonitorTemplate(client *Client, request *DeleteCloudGtmMonitorTemplateRequest) (_result *DeleteCloudGtmMonitorTemplateResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteCloudGtmMonitorTemplateResponse{}
	_body, _err := DeleteCloudGtmMonitorTemplateWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes custom lines at a time by using the unique IDs.
//
// @param request - DeleteCustomLinesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteCustomLinesResponse
func DeleteCustomLinesWithOptions(client *Client, request *DeleteCustomLinesRequest, runtime *dara.RuntimeOptions) (_result *DeleteCustomLinesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LineIds) {
		query["LineIds"] = request.LineIds
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteCustomLines"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteCustomLinesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes custom lines at a time by using the unique IDs.
//
// @param request - DeleteCustomLinesRequest
//
// @return DeleteCustomLinesResponse
func DeleteCustomLines(client *Client, request *DeleteCustomLinesRequest) (_result *DeleteCustomLinesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteCustomLinesResponse{}
	_body, _err := DeleteCustomLinesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes a specified cache-accelerated domain name.
//
// @param request - DeleteDnsCacheDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDnsCacheDomainResponse
func DeleteDnsCacheDomainWithOptions(client *Client, request *DeleteDnsCacheDomainRequest, runtime *dara.RuntimeOptions) (_result *DeleteDnsCacheDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDnsCacheDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDnsCacheDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes a specified cache-accelerated domain name.
//
// @param request - DeleteDnsCacheDomainRequest
//
// @return DeleteDnsCacheDomainResponse
func DeleteDnsCacheDomain(client *Client, request *DeleteDnsCacheDomainRequest) (_result *DeleteDnsCacheDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDnsCacheDomainResponse{}
	_body, _err := DeleteDnsCacheDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DeleteDnsGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDnsGtmAccessStrategyResponse
func DeleteDnsGtmAccessStrategyWithOptions(client *Client, request *DeleteDnsGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *DeleteDnsGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDnsGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDnsGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DeleteDnsGtmAccessStrategyRequest
//
// @return DeleteDnsGtmAccessStrategyResponse
func DeleteDnsGtmAccessStrategy(client *Client, request *DeleteDnsGtmAccessStrategyRequest) (_result *DeleteDnsGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDnsGtmAccessStrategyResponse{}
	_body, _err := DeleteDnsGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DeleteDnsGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDnsGtmAddressPoolResponse
func DeleteDnsGtmAddressPoolWithOptions(client *Client, request *DeleteDnsGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DeleteDnsGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDnsGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDnsGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DeleteDnsGtmAddressPoolRequest
//
// @return DeleteDnsGtmAddressPoolResponse
func DeleteDnsGtmAddressPool(client *Client, request *DeleteDnsGtmAddressPoolRequest) (_result *DeleteDnsGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDnsGtmAddressPoolResponse{}
	_body, _err := DeleteDnsGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes a domain name based on the specified parameters.
//
// @param request - DeleteDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDomainResponse
func DeleteDomainWithOptions(client *Client, request *DeleteDomainRequest, runtime *dara.RuntimeOptions) (_result *DeleteDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes a domain name based on the specified parameters.
//
// @param request - DeleteDomainRequest
//
// @return DeleteDomainResponse
func DeleteDomain(client *Client, request *DeleteDomainRequest) (_result *DeleteDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDomainResponse{}
	_body, _err := DeleteDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes a domain name group. After you delete the domain name group, the domain names in the group are moved to the default group.
//
// Description:
//
// >  The default group cannot be deleted.
//
// @param request - DeleteDomainGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDomainGroupResponse
func DeleteDomainGroupWithOptions(client *Client, request *DeleteDomainGroupRequest, runtime *dara.RuntimeOptions) (_result *DeleteDomainGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDomainGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDomainGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes a domain name group. After you delete the domain name group, the domain names in the group are moved to the default group.
//
// Description:
//
// >  The default group cannot be deleted.
//
// @param request - DeleteDomainGroupRequest
//
// @return DeleteDomainGroupResponse
func DeleteDomainGroup(client *Client, request *DeleteDomainGroupRequest) (_result *DeleteDomainGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDomainGroupResponse{}
	_body, _err := DeleteDomainGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes an Alibaba Cloud DNS (DNS) record based on the specified parameters.
//
// @param request - DeleteDomainRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteDomainRecordResponse
func DeleteDomainRecordWithOptions(client *Client, request *DeleteDomainRecordRequest, runtime *dara.RuntimeOptions) (_result *DeleteDomainRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteDomainRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteDomainRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes an Alibaba Cloud DNS (DNS) record based on the specified parameters.
//
// @param request - DeleteDomainRecordRequest
//
// @return DeleteDomainRecordResponse
func DeleteDomainRecord(client *Client, request *DeleteDomainRecordRequest) (_result *DeleteDomainRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteDomainRecordResponse{}
	_body, _err := DeleteDomainRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DeleteGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteGtmAccessStrategyResponse
func DeleteGtmAccessStrategyWithOptions(client *Client, request *DeleteGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *DeleteGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DeleteGtmAccessStrategyRequest
//
// @return DeleteGtmAccessStrategyResponse
func DeleteGtmAccessStrategy(client *Client, request *DeleteGtmAccessStrategyRequest) (_result *DeleteGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteGtmAccessStrategyResponse{}
	_body, _err := DeleteGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DeleteGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteGtmAddressPoolResponse
func DeleteGtmAddressPoolWithOptions(client *Client, request *DeleteGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DeleteGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DeleteGtmAddressPoolRequest
//
// @return DeleteGtmAddressPoolResponse
func DeleteGtmAddressPool(client *Client, request *DeleteGtmAddressPoolRequest) (_result *DeleteGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteGtmAddressPoolResponse{}
	_body, _err := DeleteGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DeleteGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteGtmRecoveryPlanResponse
func DeleteGtmRecoveryPlanWithOptions(client *Client, request *DeleteGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *DeleteGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DeleteGtmRecoveryPlanRequest
//
// @return DeleteGtmRecoveryPlanResponse
func DeleteGtmRecoveryPlan(client *Client, request *DeleteGtmRecoveryPlanRequest) (_result *DeleteGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteGtmRecoveryPlanResponse{}
	_body, _err := DeleteGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 删除递归解析内置权威解析记录
//
// @param request - DeleteRecursionRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteRecursionRecordResponse
func DeleteRecursionRecordWithOptions(client *Client, request *DeleteRecursionRecordRequest, runtime *dara.RuntimeOptions) (_result *DeleteRecursionRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteRecursionRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteRecursionRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 删除递归解析内置权威解析记录
//
// @param request - DeleteRecursionRecordRequest
//
// @return DeleteRecursionRecordResponse
func DeleteRecursionRecord(client *Client, request *DeleteRecursionRecordRequest) (_result *DeleteRecursionRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteRecursionRecordResponse{}
	_body, _err := DeleteRecursionRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 删除递归解析内置权威域名zone
//
// @param request - DeleteRecursionZoneRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteRecursionZoneResponse
func DeleteRecursionZoneWithOptions(client *Client, request *DeleteRecursionZoneRequest, runtime *dara.RuntimeOptions) (_result *DeleteRecursionZoneResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteRecursionZone"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteRecursionZoneResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 删除递归解析内置权威域名zone
//
// @param request - DeleteRecursionZoneRequest
//
// @return DeleteRecursionZoneResponse
func DeleteRecursionZone(client *Client, request *DeleteRecursionZoneRequest) (_result *DeleteRecursionZoneResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteRecursionZoneResponse{}
	_body, _err := DeleteRecursionZoneWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Deletes the DNS records that are corresponding to a hostname based on the specified parameters.
//
// Description:
//
// If the DNS records to be deleted contain locked DNS records, the locked DNS records will not be deleted.
//
// @param request - DeleteSubDomainRecordsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DeleteSubDomainRecordsResponse
func DeleteSubDomainRecordsWithOptions(client *Client, request *DeleteSubDomainRecordsRequest, runtime *dara.RuntimeOptions) (_result *DeleteSubDomainRecordsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RR) {
		query["RR"] = request.RR
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DeleteSubDomainRecords"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DeleteSubDomainRecordsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Deletes the DNS records that are corresponding to a hostname based on the specified parameters.
//
// Description:
//
// If the DNS records to be deleted contain locked DNS records, the locked DNS records will not be deleted.
//
// @param request - DeleteSubDomainRecordsRequest
//
// @return DeleteSubDomainRecordsResponse
func DeleteSubDomainRecords(client *Client, request *DeleteSubDomainRecordsRequest) (_result *DeleteSubDomainRecordsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DeleteSubDomainRecordsResponse{}
	_body, _err := DeleteSubDomainRecordsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the execution result of a batch operation task based on the task ID. If you do not specify task ID, the execution result of the last batch operation task is returned.
//
// @param request - DescribeBatchResultCountRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeBatchResultCountResponse
func DescribeBatchResultCountWithOptions(client *Client, request *DescribeBatchResultCountRequest, runtime *dara.RuntimeOptions) (_result *DescribeBatchResultCountResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.BatchType) {
		query["BatchType"] = request.BatchType
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.TaskId) {
		query["TaskId"] = request.TaskId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeBatchResultCount"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeBatchResultCountResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the execution result of a batch operation task based on the task ID. If you do not specify task ID, the execution result of the last batch operation task is returned.
//
// @param request - DescribeBatchResultCountRequest
//
// @return DescribeBatchResultCountResponse
func DescribeBatchResultCount(client *Client, request *DescribeBatchResultCountRequest) (_result *DescribeBatchResultCountResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeBatchResultCountResponse{}
	_body, _err := DescribeBatchResultCountWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the detailed results of a batch operation task.
//
// Description:
//
// Before you call this operation, make sure that the batch operation task is complete.
//
// @param request - DescribeBatchResultDetailRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeBatchResultDetailResponse
func DescribeBatchResultDetailWithOptions(client *Client, request *DescribeBatchResultDetailRequest, runtime *dara.RuntimeOptions) (_result *DescribeBatchResultDetailResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.BatchType) {
		query["BatchType"] = request.BatchType
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	if !dara.IsNil(request.TaskId) {
		query["TaskId"] = request.TaskId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeBatchResultDetail"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeBatchResultDetailResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the detailed results of a batch operation task.
//
// Description:
//
// Before you call this operation, make sure that the batch operation task is complete.
//
// @param request - DescribeBatchResultDetailRequest
//
// @return DescribeBatchResultDetailResponse
func DescribeBatchResultDetail(client *Client, request *DescribeBatchResultDetailRequest) (_result *DescribeBatchResultDetailResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeBatchResultDetailResponse{}
	_body, _err := DescribeBatchResultDetailWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configurations of an address.
//
// @param request - DescribeCloudGtmAddressRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmAddressResponse
func DescribeCloudGtmAddressWithOptions(client *Client, request *DescribeCloudGtmAddressRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmAddressResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmAddress"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmAddressResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configurations of an address.
//
// @param request - DescribeCloudGtmAddressRequest
//
// @return DescribeCloudGtmAddressResponse
func DescribeCloudGtmAddress(client *Client, request *DescribeCloudGtmAddressRequest) (_result *DescribeCloudGtmAddressResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmAddressResponse{}
	_body, _err := DescribeCloudGtmAddressWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configurations of an address pool.
//
// @param request - DescribeCloudGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmAddressPoolResponse
func DescribeCloudGtmAddressPoolWithOptions(client *Client, request *DescribeCloudGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configurations of an address pool.
//
// @param request - DescribeCloudGtmAddressPoolRequest
//
// @return DescribeCloudGtmAddressPoolResponse
func DescribeCloudGtmAddressPool(client *Client, request *DescribeCloudGtmAddressPoolRequest) (_result *DescribeCloudGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmAddressPoolResponse{}
	_body, _err := DescribeCloudGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the information about the access domain names that reference an address pool.
//
// @param request - DescribeCloudGtmAddressPoolReferenceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmAddressPoolReferenceResponse
func DescribeCloudGtmAddressPoolReferenceWithOptions(client *Client, request *DescribeCloudGtmAddressPoolReferenceRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmAddressPoolReferenceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmAddressPoolReference"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmAddressPoolReferenceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the information about the access domain names that reference an address pool.
//
// @param request - DescribeCloudGtmAddressPoolReferenceRequest
//
// @return DescribeCloudGtmAddressPoolReferenceResponse
func DescribeCloudGtmAddressPoolReference(client *Client, request *DescribeCloudGtmAddressPoolReferenceRequest) (_result *DescribeCloudGtmAddressPoolReferenceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmAddressPoolReferenceResponse{}
	_body, _err := DescribeCloudGtmAddressPoolReferenceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the information about the address pools and Global Traffic Manager (GTM) 3.0 instances that reference an address.
//
// @param request - DescribeCloudGtmAddressReferenceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmAddressReferenceResponse
func DescribeCloudGtmAddressReferenceWithOptions(client *Client, request *DescribeCloudGtmAddressReferenceRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmAddressReferenceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmAddressReference"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmAddressReferenceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the information about the address pools and Global Traffic Manager (GTM) 3.0 instances that reference an address.
//
// @param request - DescribeCloudGtmAddressReferenceRequest
//
// @return DescribeCloudGtmAddressReferenceResponse
func DescribeCloudGtmAddressReference(client *Client, request *DescribeCloudGtmAddressReferenceRequest) (_result *DescribeCloudGtmAddressReferenceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmAddressReferenceResponse{}
	_body, _err := DescribeCloudGtmAddressReferenceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeCloudGtmGlobalAlertRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmGlobalAlertResponse
func DescribeCloudGtmGlobalAlertWithOptions(client *Client, request *DescribeCloudGtmGlobalAlertRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmGlobalAlertResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmGlobalAlert"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmGlobalAlertResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeCloudGtmGlobalAlertRequest
//
// @return DescribeCloudGtmGlobalAlertResponse
func DescribeCloudGtmGlobalAlert(client *Client, request *DescribeCloudGtmGlobalAlertRequest) (_result *DescribeCloudGtmGlobalAlertResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmGlobalAlertResponse{}
	_body, _err := DescribeCloudGtmGlobalAlertWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeCloudGtmInstanceConfigAlertRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmInstanceConfigAlertResponse
func DescribeCloudGtmInstanceConfigAlertWithOptions(client *Client, request *DescribeCloudGtmInstanceConfigAlertRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmInstanceConfigAlertResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmInstanceConfigAlert"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmInstanceConfigAlertResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeCloudGtmInstanceConfigAlertRequest
//
// @return DescribeCloudGtmInstanceConfigAlertResponse
func DescribeCloudGtmInstanceConfigAlert(client *Client, request *DescribeCloudGtmInstanceConfigAlertRequest) (_result *DescribeCloudGtmInstanceConfigAlertResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmInstanceConfigAlertResponse{}
	_body, _err := DescribeCloudGtmInstanceConfigAlertWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the complete configuration information about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeCloudGtmInstanceConfigFullInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmInstanceConfigFullInfoResponse
func DescribeCloudGtmInstanceConfigFullInfoWithOptions(client *Client, request *DescribeCloudGtmInstanceConfigFullInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmInstanceConfigFullInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmInstanceConfigFullInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmInstanceConfigFullInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the complete configuration information about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeCloudGtmInstanceConfigFullInfoRequest
//
// @return DescribeCloudGtmInstanceConfigFullInfoResponse
func DescribeCloudGtmInstanceConfigFullInfo(client *Client, request *DescribeCloudGtmInstanceConfigFullInfoRequest) (_result *DescribeCloudGtmInstanceConfigFullInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmInstanceConfigFullInfoResponse{}
	_body, _err := DescribeCloudGtmInstanceConfigFullInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configurations of a health check template.
//
// @param request - DescribeCloudGtmMonitorTemplateRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmMonitorTemplateResponse
func DescribeCloudGtmMonitorTemplateWithOptions(client *Client, request *DescribeCloudGtmMonitorTemplateRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmMonitorTemplateResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.TemplateId) {
		query["TemplateId"] = request.TemplateId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmMonitorTemplate"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmMonitorTemplateResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configurations of a health check template.
//
// @param request - DescribeCloudGtmMonitorTemplateRequest
//
// @return DescribeCloudGtmMonitorTemplateResponse
func DescribeCloudGtmMonitorTemplate(client *Client, request *DescribeCloudGtmMonitorTemplateRequest) (_result *DescribeCloudGtmMonitorTemplateResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmMonitorTemplateResponse{}
	_body, _err := DescribeCloudGtmMonitorTemplateWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeCloudGtmSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmSummaryResponse
func DescribeCloudGtmSummaryWithOptions(client *Client, request *DescribeCloudGtmSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeCloudGtmSummaryRequest
//
// @return DescribeCloudGtmSummaryResponse
func DescribeCloudGtmSummary(client *Client, request *DescribeCloudGtmSummaryRequest) (_result *DescribeCloudGtmSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmSummaryResponse{}
	_body, _err := DescribeCloudGtmSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeCloudGtmSystemLinesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCloudGtmSystemLinesResponse
func DescribeCloudGtmSystemLinesWithOptions(client *Client, runtime *dara.RuntimeOptions) (_result *DescribeCloudGtmSystemLinesResponse, _err error) {
	req := &openapiutil.OpenApiRequest{}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCloudGtmSystemLines"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCloudGtmSystemLinesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @return DescribeCloudGtmSystemLinesResponse
func DescribeCloudGtmSystemLines(client *Client, ) (_result *DescribeCloudGtmSystemLinesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCloudGtmSystemLinesResponse{}
	_body, _err := DescribeCloudGtmSystemLinesWithOptions(client,runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the details of a custom line by its unique ID.
//
// @param request - DescribeCustomLineRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCustomLineResponse
func DescribeCustomLineWithOptions(client *Client, request *DescribeCustomLineRequest, runtime *dara.RuntimeOptions) (_result *DescribeCustomLineResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LineId) {
		query["LineId"] = request.LineId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCustomLine"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCustomLineResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the details of a custom line by its unique ID.
//
// @param request - DescribeCustomLineRequest
//
// @return DescribeCustomLineResponse
func DescribeCustomLine(client *Client, request *DescribeCustomLineRequest) (_result *DescribeCustomLineResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCustomLineResponse{}
	_body, _err := DescribeCustomLineWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries custom lines by domain name.
//
// @param request - DescribeCustomLinesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeCustomLinesResponse
func DescribeCustomLinesWithOptions(client *Client, request *DescribeCustomLinesRequest, runtime *dara.RuntimeOptions) (_result *DescribeCustomLinesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeCustomLines"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeCustomLinesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries custom lines by domain name.
//
// @param request - DescribeCustomLinesRequest
//
// @return DescribeCustomLinesResponse
func DescribeCustomLines(client *Client, request *DescribeCustomLinesRequest) (_result *DescribeCustomLinesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeCustomLinesResponse{}
	_body, _err := DescribeCustomLinesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the subdomains for which weighted round-robin is enabled based on the specified parameters.
//
// @param request - DescribeDNSSLBSubDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDNSSLBSubDomainsResponse
func DescribeDNSSLBSubDomainsWithOptions(client *Client, request *DescribeDNSSLBSubDomainsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDNSSLBSubDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDNSSLBSubDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDNSSLBSubDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the subdomains for which weighted round-robin is enabled based on the specified parameters.
//
// @param request - DescribeDNSSLBSubDomainsRequest
//
// @return DescribeDNSSLBSubDomainsResponse
func DescribeDNSSLBSubDomains(client *Client, request *DescribeDNSSLBSubDomainsRequest) (_result *DescribeDNSSLBSubDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDNSSLBSubDomainsResponse{}
	_body, _err := DescribeDNSSLBSubDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询代理域名
//
// @param request - DescribeDnsCacheDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsCacheDomainsResponse
func DescribeDnsCacheDomainsWithOptions(client *Client, request *DescribeDnsCacheDomainsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsCacheDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsCacheDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsCacheDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询代理域名
//
// @param request - DescribeDnsCacheDomainsRequest
//
// @return DescribeDnsCacheDomainsResponse
func DescribeDnsCacheDomains(client *Client, request *DescribeDnsCacheDomainsRequest) (_result *DescribeDnsCacheDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsCacheDomainsResponse{}
	_body, _err := DescribeDnsCacheDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries access policies of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategiesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAccessStrategiesResponse
func DescribeDnsGtmAccessStrategiesWithOptions(client *Client, request *DescribeDnsGtmAccessStrategiesRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAccessStrategiesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StrategyMode) {
		query["StrategyMode"] = request.StrategyMode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAccessStrategies"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAccessStrategiesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries access policies of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategiesRequest
//
// @return DescribeDnsGtmAccessStrategiesResponse
func DescribeDnsGtmAccessStrategies(client *Client, request *DescribeDnsGtmAccessStrategiesRequest) (_result *DescribeDnsGtmAccessStrategiesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAccessStrategiesResponse{}
	_body, _err := DescribeDnsGtmAccessStrategiesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries detailed information about an access policy of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAccessStrategyResponse
func DescribeDnsGtmAccessStrategyWithOptions(client *Client, request *DescribeDnsGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries detailed information about an access policy of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategyRequest
//
// @return DescribeDnsGtmAccessStrategyResponse
func DescribeDnsGtmAccessStrategy(client *Client, request *DescribeDnsGtmAccessStrategyRequest) (_result *DescribeDnsGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAccessStrategyResponse{}
	_body, _err := DescribeDnsGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the available configurations of an access policy of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategyAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAccessStrategyAvailableConfigResponse
func DescribeDnsGtmAccessStrategyAvailableConfigWithOptions(client *Client, request *DescribeDnsGtmAccessStrategyAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAccessStrategyAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyMode) {
		query["StrategyMode"] = request.StrategyMode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAccessStrategyAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAccessStrategyAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the available configurations of an access policy of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAccessStrategyAvailableConfigRequest
//
// @return DescribeDnsGtmAccessStrategyAvailableConfigResponse
func DescribeDnsGtmAccessStrategyAvailableConfig(client *Client, request *DescribeDnsGtmAccessStrategyAvailableConfigRequest) (_result *DescribeDnsGtmAccessStrategyAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAccessStrategyAvailableConfigResponse{}
	_body, _err := DescribeDnsGtmAccessStrategyAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the source regions of addresses.
//
// @param request - DescribeDnsGtmAddrAttributeInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAddrAttributeInfoResponse
func DescribeDnsGtmAddrAttributeInfoWithOptions(client *Client, request *DescribeDnsGtmAddrAttributeInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAddrAttributeInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Addrs) {
		query["Addrs"] = request.Addrs
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAddrAttributeInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAddrAttributeInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the source regions of addresses.
//
// @param request - DescribeDnsGtmAddrAttributeInfoRequest
//
// @return DescribeDnsGtmAddrAttributeInfoResponse
func DescribeDnsGtmAddrAttributeInfo(client *Client, request *DescribeDnsGtmAddrAttributeInfoRequest) (_result *DescribeDnsGtmAddrAttributeInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAddrAttributeInfoResponse{}
	_body, _err := DescribeDnsGtmAddrAttributeInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the available configurations of an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAddressPoolAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAddressPoolAvailableConfigResponse
func DescribeDnsGtmAddressPoolAvailableConfigWithOptions(client *Client, request *DescribeDnsGtmAddressPoolAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAddressPoolAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAddressPoolAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAddressPoolAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the available configurations of an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmAddressPoolAvailableConfigRequest
//
// @return DescribeDnsGtmAddressPoolAvailableConfigResponse
func DescribeDnsGtmAddressPoolAvailableConfig(client *Client, request *DescribeDnsGtmAddressPoolAvailableConfigRequest) (_result *DescribeDnsGtmAddressPoolAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAddressPoolAvailableConfigResponse{}
	_body, _err := DescribeDnsGtmAddressPoolAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeDnsGtmAvailableAlertGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmAvailableAlertGroupResponse
func DescribeDnsGtmAvailableAlertGroupWithOptions(client *Client, request *DescribeDnsGtmAvailableAlertGroupRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmAvailableAlertGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmAvailableAlertGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmAvailableAlertGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeDnsGtmAvailableAlertGroupRequest
//
// @return DescribeDnsGtmAvailableAlertGroupResponse
func DescribeDnsGtmAvailableAlertGroup(client *Client, request *DescribeDnsGtmAvailableAlertGroupRequest) (_result *DescribeDnsGtmAvailableAlertGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmAvailableAlertGroupResponse{}
	_body, _err := DescribeDnsGtmAvailableAlertGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries detailed information about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstanceResponse
func DescribeDnsGtmInstanceWithOptions(client *Client, request *DescribeDnsGtmInstanceRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstanceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstance"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstanceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries detailed information about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceRequest
//
// @return DescribeDnsGtmInstanceResponse
func DescribeDnsGtmInstance(client *Client, request *DescribeDnsGtmInstanceRequest) (_result *DescribeDnsGtmInstanceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstanceResponse{}
	_body, _err := DescribeDnsGtmInstanceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries detailed information about an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstanceAddressPoolResponse
func DescribeDnsGtmInstanceAddressPoolWithOptions(client *Client, request *DescribeDnsGtmInstanceAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstanceAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstanceAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstanceAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries detailed information about an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceAddressPoolRequest
//
// @return DescribeDnsGtmInstanceAddressPoolResponse
func DescribeDnsGtmInstanceAddressPool(client *Client, request *DescribeDnsGtmInstanceAddressPoolRequest) (_result *DescribeDnsGtmInstanceAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstanceAddressPoolResponse{}
	_body, _err := DescribeDnsGtmInstanceAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the address pools of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceAddressPoolsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstanceAddressPoolsResponse
func DescribeDnsGtmInstanceAddressPoolsWithOptions(client *Client, request *DescribeDnsGtmInstanceAddressPoolsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstanceAddressPoolsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstanceAddressPools"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstanceAddressPoolsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the address pools of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceAddressPoolsRequest
//
// @return DescribeDnsGtmInstanceAddressPoolsResponse
func DescribeDnsGtmInstanceAddressPools(client *Client, request *DescribeDnsGtmInstanceAddressPoolsRequest) (_result *DescribeDnsGtmInstanceAddressPoolsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstanceAddressPoolsResponse{}
	_body, _err := DescribeDnsGtmInstanceAddressPoolsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the status of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstanceStatusResponse
func DescribeDnsGtmInstanceStatusWithOptions(client *Client, request *DescribeDnsGtmInstanceStatusRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstanceStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstanceStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstanceStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the status of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceStatusRequest
//
// @return DescribeDnsGtmInstanceStatusResponse
func DescribeDnsGtmInstanceStatus(client *Client, request *DescribeDnsGtmInstanceStatusRequest) (_result *DescribeDnsGtmInstanceStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstanceStatusResponse{}
	_body, _err := DescribeDnsGtmInstanceStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the CNAME domain name assigned by the system for a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceSystemCnameRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstanceSystemCnameResponse
func DescribeDnsGtmInstanceSystemCnameWithOptions(client *Client, request *DescribeDnsGtmInstanceSystemCnameRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstanceSystemCnameResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstanceSystemCname"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstanceSystemCnameResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the CNAME domain name assigned by the system for a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmInstanceSystemCnameRequest
//
// @return DescribeDnsGtmInstanceSystemCnameResponse
func DescribeDnsGtmInstanceSystemCname(client *Client, request *DescribeDnsGtmInstanceSystemCnameRequest) (_result *DescribeDnsGtmInstanceSystemCnameResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstanceSystemCnameResponse{}
	_body, _err := DescribeDnsGtmInstanceSystemCnameWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of instances.
//
// @param request - DescribeDnsGtmInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmInstancesResponse
func DescribeDnsGtmInstancesWithOptions(client *Client, request *DescribeDnsGtmInstancesRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.ResourceGroupId) {
		query["ResourceGroupId"] = request.ResourceGroupId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of instances.
//
// @param request - DescribeDnsGtmInstancesRequest
//
// @return DescribeDnsGtmInstancesResponse
func DescribeDnsGtmInstances(client *Client, request *DescribeDnsGtmInstancesRequest) (_result *DescribeDnsGtmInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmInstancesResponse{}
	_body, _err := DescribeDnsGtmInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries operation logs of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmLogsResponse
func DescribeDnsGtmLogsWithOptions(client *Client, request *DescribeDnsGtmLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndTimestamp) {
		query["EndTimestamp"] = request.EndTimestamp
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartTimestamp) {
		query["StartTimestamp"] = request.StartTimestamp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries operation logs of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeDnsGtmLogsRequest
//
// @return DescribeDnsGtmLogsResponse
func DescribeDnsGtmLogs(client *Client, request *DescribeDnsGtmLogsRequest) (_result *DescribeDnsGtmLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmLogsResponse{}
	_body, _err := DescribeDnsGtmLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for a health check task.
//
// @param request - DescribeDnsGtmMonitorAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmMonitorAvailableConfigResponse
func DescribeDnsGtmMonitorAvailableConfigWithOptions(client *Client, request *DescribeDnsGtmMonitorAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmMonitorAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmMonitorAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmMonitorAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for a health check task.
//
// @param request - DescribeDnsGtmMonitorAvailableConfigRequest
//
// @return DescribeDnsGtmMonitorAvailableConfigResponse
func DescribeDnsGtmMonitorAvailableConfig(client *Client, request *DescribeDnsGtmMonitorAvailableConfigRequest) (_result *DescribeDnsGtmMonitorAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmMonitorAvailableConfigResponse{}
	_body, _err := DescribeDnsGtmMonitorAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the health check configuration of an address pool.
//
// @param request - DescribeDnsGtmMonitorConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsGtmMonitorConfigResponse
func DescribeDnsGtmMonitorConfigWithOptions(client *Client, request *DescribeDnsGtmMonitorConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsGtmMonitorConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsGtmMonitorConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsGtmMonitorConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the health check configuration of an address pool.
//
// @param request - DescribeDnsGtmMonitorConfigRequest
//
// @return DescribeDnsGtmMonitorConfigResponse
func DescribeDnsGtmMonitorConfig(client *Client, request *DescribeDnsGtmMonitorConfigRequest) (_result *DescribeDnsGtmMonitorConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsGtmMonitorConfigResponse{}
	_body, _err := DescribeDnsGtmMonitorConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the details about a paid Alibaba Cloud DNS instance based on the instance ID.
//
// @param request - DescribeDnsProductInstanceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsProductInstanceResponse
func DescribeDnsProductInstanceWithOptions(client *Client, request *DescribeDnsProductInstanceRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsProductInstanceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsProductInstance"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsProductInstanceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the details about a paid Alibaba Cloud DNS instance based on the instance ID.
//
// @param request - DescribeDnsProductInstanceRequest
//
// @return DescribeDnsProductInstanceResponse
func DescribeDnsProductInstance(client *Client, request *DescribeDnsProductInstanceRequest) (_result *DescribeDnsProductInstanceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsProductInstanceResponse{}
	_body, _err := DescribeDnsProductInstanceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Calls the DescribeDnsProductInstances operation to query the list of paid Alibaba Cloud DNS instances based on input parameters.
//
// Description:
//
// >  If the response parameters of an Alibaba Cloud DNS instance do not contain domain names, no domain names are bound to the instance.
//
// @param request - DescribeDnsProductInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDnsProductInstancesResponse
func DescribeDnsProductInstancesWithOptions(client *Client, request *DescribeDnsProductInstancesRequest, runtime *dara.RuntimeOptions) (_result *DescribeDnsProductInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.DomainType) {
		query["DomainType"] = request.DomainType
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.VersionCode) {
		query["VersionCode"] = request.VersionCode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDnsProductInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDnsProductInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Calls the DescribeDnsProductInstances operation to query the list of paid Alibaba Cloud DNS instances based on input parameters.
//
// Description:
//
// >  If the response parameters of an Alibaba Cloud DNS instance do not contain domain names, no domain names are bound to the instance.
//
// @param request - DescribeDnsProductInstancesRequest
//
// @return DescribeDnsProductInstancesResponse
func DescribeDnsProductInstances(client *Client, request *DescribeDnsProductInstancesRequest) (_result *DescribeDnsProductInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDnsProductInstancesResponse{}
	_body, _err := DescribeDnsProductInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeDohAccountStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohAccountStatisticsResponse
func DescribeDohAccountStatisticsWithOptions(client *Client, request *DescribeDohAccountStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohAccountStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohAccountStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohAccountStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeDohAccountStatisticsRequest
//
// @return DescribeDohAccountStatisticsResponse
func DescribeDohAccountStatistics(client *Client, request *DescribeDohAccountStatisticsRequest) (_result *DescribeDohAccountStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohAccountStatisticsResponse{}
	_body, _err := DescribeDohAccountStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询DOH域名请求量数据
//
// @param request - DescribeDohDomainStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohDomainStatisticsResponse
func DescribeDohDomainStatisticsWithOptions(client *Client, request *DescribeDohDomainStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohDomainStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohDomainStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohDomainStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询DOH域名请求量数据
//
// @param request - DescribeDohDomainStatisticsRequest
//
// @return DescribeDohDomainStatisticsResponse
func DescribeDohDomainStatistics(client *Client, request *DescribeDohDomainStatisticsRequest) (_result *DescribeDohDomainStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohDomainStatisticsResponse{}
	_body, _err := DescribeDohDomainStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeDohDomainStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohDomainStatisticsSummaryResponse
func DescribeDohDomainStatisticsSummaryWithOptions(client *Client, request *DescribeDohDomainStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohDomainStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohDomainStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohDomainStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeDohDomainStatisticsSummaryRequest
//
// @return DescribeDohDomainStatisticsSummaryResponse
func DescribeDohDomainStatisticsSummary(client *Client, request *DescribeDohDomainStatisticsSummaryRequest) (_result *DescribeDohDomainStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohDomainStatisticsSummaryResponse{}
	_body, _err := DescribeDohDomainStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeDohSubDomainStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohSubDomainStatisticsResponse
func DescribeDohSubDomainStatisticsWithOptions(client *Client, request *DescribeDohSubDomainStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohSubDomainStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohSubDomainStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohSubDomainStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeDohSubDomainStatisticsRequest
//
// @return DescribeDohSubDomainStatisticsResponse
func DescribeDohSubDomainStatistics(client *Client, request *DescribeDohSubDomainStatisticsRequest) (_result *DescribeDohSubDomainStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohSubDomainStatisticsResponse{}
	_body, _err := DescribeDohSubDomainStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeDohSubDomainStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohSubDomainStatisticsSummaryResponse
func DescribeDohSubDomainStatisticsSummaryWithOptions(client *Client, request *DescribeDohSubDomainStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohSubDomainStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohSubDomainStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohSubDomainStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeDohSubDomainStatisticsSummaryRequest
//
// @return DescribeDohSubDomainStatisticsSummaryResponse
func DescribeDohSubDomainStatisticsSummary(client *Client, request *DescribeDohSubDomainStatisticsSummaryRequest) (_result *DescribeDohSubDomainStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohSubDomainStatisticsSummaryResponse{}
	_body, _err := DescribeDohSubDomainStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the numbers of accessed domains and subdomains by using DNS over HTTPS (DoH).
//
// @param request - DescribeDohUserInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDohUserInfoResponse
func DescribeDohUserInfoWithOptions(client *Client, request *DescribeDohUserInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeDohUserInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDohUserInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDohUserInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the numbers of accessed domains and subdomains by using DNS over HTTPS (DoH).
//
// @param request - DescribeDohUserInfoRequest
//
// @return DescribeDohUserInfoResponse
func DescribeDohUserInfo(client *Client, request *DescribeDohUserInfoRequest) (_result *DescribeDohUserInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDohUserInfoResponse{}
	_body, _err := DescribeDohUserInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the Domain Name System Security Extensions (DNSSEC) configurations of a domain name based on the specified parameters.
//
// @param request - DescribeDomainDnssecInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainDnssecInfoResponse
func DescribeDomainDnssecInfoWithOptions(client *Client, request *DescribeDomainDnssecInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainDnssecInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainDnssecInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainDnssecInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the Domain Name System Security Extensions (DNSSEC) configurations of a domain name based on the specified parameters.
//
// @param request - DescribeDomainDnssecInfoRequest
//
// @return DescribeDomainDnssecInfoResponse
func DescribeDomainDnssecInfo(client *Client, request *DescribeDomainDnssecInfoRequest) (_result *DescribeDomainDnssecInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainDnssecInfoResponse{}
	_body, _err := DescribeDomainDnssecInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries all domain name groups based on the specified parameters.
//
// @param request - DescribeDomainGroupsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainGroupsResponse
func DescribeDomainGroupsWithOptions(client *Client, request *DescribeDomainGroupsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainGroupsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.KeyWord) {
		query["KeyWord"] = request.KeyWord
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainGroups"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainGroupsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries all domain name groups based on the specified parameters.
//
// @param request - DescribeDomainGroupsRequest
//
// @return DescribeDomainGroupsResponse
func DescribeDomainGroups(client *Client, request *DescribeDomainGroupsRequest) (_result *DescribeDomainGroupsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainGroupsResponse{}
	_body, _err := DescribeDomainGroupsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the information about a domain name based on specified parameters.
//
// Description:
//
// In this example, the domain name is bound to an instance of Alibaba Cloud DNS Enterprise Ultimate Edition. For more information about valid Domain Name System (DNS) request lines, see the return values of the RecordLines parameter.
//
// @param request - DescribeDomainInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainInfoResponse
func DescribeDomainInfoWithOptions(client *Client, request *DescribeDomainInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NeedDetailAttributes) {
		query["NeedDetailAttributes"] = request.NeedDetailAttributes
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the information about a domain name based on specified parameters.
//
// Description:
//
// In this example, the domain name is bound to an instance of Alibaba Cloud DNS Enterprise Ultimate Edition. For more information about valid Domain Name System (DNS) request lines, see the return values of the RecordLines parameter.
//
// @param request - DescribeDomainInfoRequest
//
// @return DescribeDomainInfoResponse
func DescribeDomainInfo(client *Client, request *DescribeDomainInfoRequest) (_result *DescribeDomainInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainInfoResponse{}
	_body, _err := DescribeDomainInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the operation logs of domain names based on the specified parameters.
//
// @param request - DescribeDomainLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainLogsResponse
func DescribeDomainLogsWithOptions(client *Client, request *DescribeDomainLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.KeyWord) {
		query["KeyWord"] = request.KeyWord
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.EndDate) {
		query["endDate"] = request.EndDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the operation logs of domain names based on the specified parameters.
//
// @param request - DescribeDomainLogsRequest
//
// @return DescribeDomainLogsResponse
func DescribeDomainLogs(client *Client, request *DescribeDomainLogsRequest) (_result *DescribeDomainLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainLogsResponse{}
	_body, _err := DescribeDomainLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the name servers configured for a specified domain name and checks whether all the name servers are Alibaba Cloud Domain Name System (DNS) servers.
//
// Description:
//
// >  You can call this operation to query the authoritative servers of a domain name registry to obtain the name servers for a domain name. If the domain name is in an invalid state, such as serverHold or clientHold, an error may be returned.
//
// @param request - DescribeDomainNsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainNsResponse
func DescribeDomainNsWithOptions(client *Client, request *DescribeDomainNsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainNsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainNs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainNsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the name servers configured for a specified domain name and checks whether all the name servers are Alibaba Cloud Domain Name System (DNS) servers.
//
// Description:
//
// >  You can call this operation to query the authoritative servers of a domain name registry to obtain the name servers for a domain name. If the domain name is in an invalid state, such as serverHold or clientHold, an error may be returned.
//
// @param request - DescribeDomainNsRequest
//
// @return DescribeDomainNsResponse
func DescribeDomainNs(client *Client, request *DescribeDomainNsRequest) (_result *DescribeDomainNsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainNsResponse{}
	_body, _err := DescribeDomainNsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the information about a Domain Name System (DNS) record by the ID of the DNS record.
//
// Description:
//
// ## Debugging
//
// [OpenAPI Explorer automatically calculates the signature value. For your convenience, we recommend that you call this operation in OpenAPI Explorer. OpenAPI Explorer dynamically generates the sample code of the operation for different SDKs.](https://api.aliyun.com/#product=Alidns\\&api=DescribeDomainRecordInfo\\&type=RPC\\&version=2015-01-09)
//
// @param request - DescribeDomainRecordInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainRecordInfoResponse
func DescribeDomainRecordInfoWithOptions(client *Client, request *DescribeDomainRecordInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainRecordInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainRecordInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainRecordInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the information about a Domain Name System (DNS) record by the ID of the DNS record.
//
// Description:
//
// ## Debugging
//
// [OpenAPI Explorer automatically calculates the signature value. For your convenience, we recommend that you call this operation in OpenAPI Explorer. OpenAPI Explorer dynamically generates the sample code of the operation for different SDKs.](https://api.aliyun.com/#product=Alidns\\&api=DescribeDomainRecordInfo\\&type=RPC\\&version=2015-01-09)
//
// @param request - DescribeDomainRecordInfoRequest
//
// @return DescribeDomainRecordInfoResponse
func DescribeDomainRecordInfo(client *Client, request *DescribeDomainRecordInfoRequest) (_result *DescribeDomainRecordInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainRecordInfoResponse{}
	_body, _err := DescribeDomainRecordInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries all Domain Name System (DNS) records of the specified primary domain names based on the specified parameters.
//
// Description:
//
//	  You can specify DomainName, PageNumber, and PageSize to query the DNS records of the specified domain names.
//
//		- You can also specify RRKeyWord, TypeKeyWord, or ValueKeyWord to query the DNS records that contain the specified keyword.
//
//		- By default, the DNS records are sorted in reverse chronological order based on the time when they were added.
//
//		- You can specify GroupId to query the DNS records of the specified domain names based on the group ID. You can query the DNS records of all domain names and the domain names in the default group.
//
// @param request - DescribeDomainRecordsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainRecordsResponse
func DescribeDomainRecordsWithOptions(client *Client, request *DescribeDomainRecordsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainRecordsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.KeyWord) {
		query["KeyWord"] = request.KeyWord
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Line) {
		query["Line"] = request.Line
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.RRKeyWord) {
		query["RRKeyWord"] = request.RRKeyWord
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.TypeKeyWord) {
		query["TypeKeyWord"] = request.TypeKeyWord
	}

	if !dara.IsNil(request.ValueKeyWord) {
		query["ValueKeyWord"] = request.ValueKeyWord
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainRecords"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainRecordsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries all Domain Name System (DNS) records of the specified primary domain names based on the specified parameters.
//
// Description:
//
//	  You can specify DomainName, PageNumber, and PageSize to query the DNS records of the specified domain names.
//
//		- You can also specify RRKeyWord, TypeKeyWord, or ValueKeyWord to query the DNS records that contain the specified keyword.
//
//		- By default, the DNS records are sorted in reverse chronological order based on the time when they were added.
//
//		- You can specify GroupId to query the DNS records of the specified domain names based on the group ID. You can query the DNS records of all domain names and the domain names in the default group.
//
// @param request - DescribeDomainRecordsRequest
//
// @return DescribeDomainRecordsResponse
func DescribeDomainRecords(client *Client, request *DescribeDomainRecordsRequest) (_result *DescribeDomainRecordsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainRecordsResponse{}
	_body, _err := DescribeDomainRecordsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the resolution requests of all paid domain names within your account.
//
// @param request - DescribeDomainResolveStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainResolveStatisticsSummaryResponse
func DescribeDomainResolveStatisticsSummaryWithOptions(client *Client, request *DescribeDomainResolveStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainResolveStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.Threshold) {
		query["Threshold"] = request.Threshold
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainResolveStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainResolveStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the resolution requests of all paid domain names within your account.
//
// @param request - DescribeDomainResolveStatisticsSummaryRequest
//
// @return DescribeDomainResolveStatisticsSummaryResponse
func DescribeDomainResolveStatisticsSummary(client *Client, request *DescribeDomainResolveStatisticsSummaryRequest) (_result *DescribeDomainResolveStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainResolveStatisticsSummaryResponse{}
	_body, _err := DescribeDomainResolveStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the real-time statistics on the Domain Name System (DNS) requests for a primary domain name.
//
// Description:
//
// Real-time data is collected per hour.
//
// @param request - DescribeDomainStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainStatisticsResponse
func DescribeDomainStatisticsWithOptions(client *Client, request *DescribeDomainStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.DomainType) {
		query["DomainType"] = request.DomainType
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the real-time statistics on the Domain Name System (DNS) requests for a primary domain name.
//
// Description:
//
// Real-time data is collected per hour.
//
// @param request - DescribeDomainStatisticsRequest
//
// @return DescribeDomainStatisticsResponse
func DescribeDomainStatistics(client *Client, request *DescribeDomainStatisticsRequest) (_result *DescribeDomainStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainStatisticsResponse{}
	_body, _err := DescribeDomainStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Calls the DescribeDomainStatisticsSummary operation to obtain the query volume of all paid domain names under your account.
//
// @param request - DescribeDomainStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainStatisticsSummaryResponse
func DescribeDomainStatisticsSummaryWithOptions(client *Client, request *DescribeDomainStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.Threshold) {
		query["Threshold"] = request.Threshold
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomainStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Calls the DescribeDomainStatisticsSummary operation to obtain the query volume of all paid domain names under your account.
//
// @param request - DescribeDomainStatisticsSummaryRequest
//
// @return DescribeDomainStatisticsSummaryResponse
func DescribeDomainStatisticsSummary(client *Client, request *DescribeDomainStatisticsSummaryRequest) (_result *DescribeDomainStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainStatisticsSummaryResponse{}
	_body, _err := DescribeDomainStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Calls the DescribeDomains operation to query domain names of a user based on input parameters.
//
// Description:
//
//	  You can specify the PageNumber and PageSize parameters to query domain names.
//
//		- You can specify the KeyWord parameter to query domain names that contain the specified keyword.
//
//		- By default, the domain names in a list are sorted in descending order of the time they were added.
//
//		- You can specify the GroupId parameter. If you do not specify this parameter, all domain names are queried by default.
//
// @param request - DescribeDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeDomainsResponse
func DescribeDomainsWithOptions(client *Client, request *DescribeDomainsRequest, runtime *dara.RuntimeOptions) (_result *DescribeDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.KeyWord) {
		query["KeyWord"] = request.KeyWord
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.ResourceGroupId) {
		query["ResourceGroupId"] = request.ResourceGroupId
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.Starmark) {
		query["Starmark"] = request.Starmark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Calls the DescribeDomains operation to query domain names of a user based on input parameters.
//
// Description:
//
//	  You can specify the PageNumber and PageSize parameters to query domain names.
//
//		- You can specify the KeyWord parameter to query domain names that contain the specified keyword.
//
//		- By default, the domain names in a list are sorted in descending order of the time they were added.
//
//		- You can specify the GroupId parameter. If you do not specify this parameter, all domain names are queried by default.
//
// @param request - DescribeDomainsRequest
//
// @return DescribeDomainsResponse
func DescribeDomains(client *Client, request *DescribeDomainsRequest) (_result *DescribeDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeDomainsResponse{}
	_body, _err := DescribeDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to query the access policies of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmAccessStrategiesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmAccessStrategiesResponse
func DescribeGtmAccessStrategiesWithOptions(client *Client, request *DescribeGtmAccessStrategiesRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmAccessStrategiesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmAccessStrategies"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmAccessStrategiesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to query the access policies of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmAccessStrategiesRequest
//
// @return DescribeGtmAccessStrategiesResponse
func DescribeGtmAccessStrategies(client *Client, request *DescribeGtmAccessStrategiesRequest) (_result *DescribeGtmAccessStrategiesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmAccessStrategiesResponse{}
	_body, _err := DescribeGtmAccessStrategiesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to query the details about an access policy of a Global Traffic Manager (GTM) instance based on the policy ID.
//
// @param request - DescribeGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmAccessStrategyResponse
func DescribeGtmAccessStrategyWithOptions(client *Client, request *DescribeGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to query the details about an access policy of a Global Traffic Manager (GTM) instance based on the policy ID.
//
// @param request - DescribeGtmAccessStrategyRequest
//
// @return DescribeGtmAccessStrategyResponse
func DescribeGtmAccessStrategy(client *Client, request *DescribeGtmAccessStrategyRequest) (_result *DescribeGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmAccessStrategyResponse{}
	_body, _err := DescribeGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for an access policy.
//
// @param request - DescribeGtmAccessStrategyAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmAccessStrategyAvailableConfigResponse
func DescribeGtmAccessStrategyAvailableConfigWithOptions(client *Client, request *DescribeGtmAccessStrategyAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmAccessStrategyAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmAccessStrategyAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmAccessStrategyAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for an access policy.
//
// @param request - DescribeGtmAccessStrategyAvailableConfigRequest
//
// @return DescribeGtmAccessStrategyAvailableConfigResponse
func DescribeGtmAccessStrategyAvailableConfig(client *Client, request *DescribeGtmAccessStrategyAvailableConfigRequest) (_result *DescribeGtmAccessStrategyAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmAccessStrategyAvailableConfigResponse{}
	_body, _err := DescribeGtmAccessStrategyAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeGtmAvailableAlertGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmAvailableAlertGroupResponse
func DescribeGtmAvailableAlertGroupWithOptions(client *Client, request *DescribeGtmAvailableAlertGroupRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmAvailableAlertGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmAvailableAlertGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmAvailableAlertGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeGtmAvailableAlertGroupRequest
//
// @return DescribeGtmAvailableAlertGroupResponse
func DescribeGtmAvailableAlertGroup(client *Client, request *DescribeGtmAvailableAlertGroupRequest) (_result *DescribeGtmAvailableAlertGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmAvailableAlertGroupResponse{}
	_body, _err := DescribeGtmAvailableAlertGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the details about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstanceResponse
func DescribeGtmInstanceWithOptions(client *Client, request *DescribeGtmInstanceRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstanceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NeedDetailAttributes) {
		query["NeedDetailAttributes"] = request.NeedDetailAttributes
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstance"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstanceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the details about a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceRequest
//
// @return DescribeGtmInstanceResponse
func DescribeGtmInstance(client *Client, request *DescribeGtmInstanceRequest) (_result *DescribeGtmInstanceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstanceResponse{}
	_body, _err := DescribeGtmInstanceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to query the details about an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstanceAddressPoolResponse
func DescribeGtmInstanceAddressPoolWithOptions(client *Client, request *DescribeGtmInstanceAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstanceAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstanceAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstanceAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to query the details about an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceAddressPoolRequest
//
// @return DescribeGtmInstanceAddressPoolResponse
func DescribeGtmInstanceAddressPool(client *Client, request *DescribeGtmInstanceAddressPoolRequest) (_result *DescribeGtmInstanceAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstanceAddressPoolResponse{}
	_body, _err := DescribeGtmInstanceAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to query the address pools of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceAddressPoolsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstanceAddressPoolsResponse
func DescribeGtmInstanceAddressPoolsWithOptions(client *Client, request *DescribeGtmInstanceAddressPoolsRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstanceAddressPoolsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstanceAddressPools"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstanceAddressPoolsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to query the address pools of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceAddressPoolsRequest
//
// @return DescribeGtmInstanceAddressPoolsResponse
func DescribeGtmInstanceAddressPools(client *Client, request *DescribeGtmInstanceAddressPoolsRequest) (_result *DescribeGtmInstanceAddressPoolsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstanceAddressPoolsResponse{}
	_body, _err := DescribeGtmInstanceAddressPoolsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the status of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstanceStatusResponse
func DescribeGtmInstanceStatusWithOptions(client *Client, request *DescribeGtmInstanceStatusRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstanceStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstanceStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstanceStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the status of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmInstanceStatusRequest
//
// @return DescribeGtmInstanceStatusResponse
func DescribeGtmInstanceStatus(client *Client, request *DescribeGtmInstanceStatusRequest) (_result *DescribeGtmInstanceStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstanceStatusResponse{}
	_body, _err := DescribeGtmInstanceStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - DescribeGtmInstanceSystemCnameRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstanceSystemCnameResponse
func DescribeGtmInstanceSystemCnameWithOptions(client *Client, request *DescribeGtmInstanceSystemCnameRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstanceSystemCnameResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstanceSystemCname"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstanceSystemCnameResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - DescribeGtmInstanceSystemCnameRequest
//
// @return DescribeGtmInstanceSystemCnameResponse
func DescribeGtmInstanceSystemCname(client *Client, request *DescribeGtmInstanceSystemCnameRequest) (_result *DescribeGtmInstanceSystemCnameResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstanceSystemCnameResponse{}
	_body, _err := DescribeGtmInstanceSystemCnameWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the Global Traffic Manager (GTM) instances under your account.
//
// @param request - DescribeGtmInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmInstancesResponse
func DescribeGtmInstancesWithOptions(client *Client, request *DescribeGtmInstancesRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NeedDetailAttributes) {
		query["NeedDetailAttributes"] = request.NeedDetailAttributes
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.ResourceGroupId) {
		query["ResourceGroupId"] = request.ResourceGroupId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the Global Traffic Manager (GTM) instances under your account.
//
// @param request - DescribeGtmInstancesRequest
//
// @return DescribeGtmInstancesResponse
func DescribeGtmInstances(client *Client, request *DescribeGtmInstancesRequest) (_result *DescribeGtmInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmInstancesResponse{}
	_body, _err := DescribeGtmInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to query logs of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmLogsResponse
func DescribeGtmLogsWithOptions(client *Client, request *DescribeGtmLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndTimestamp) {
		query["EndTimestamp"] = request.EndTimestamp
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartTimestamp) {
		query["StartTimestamp"] = request.StartTimestamp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to query logs of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmLogsRequest
//
// @return DescribeGtmLogsResponse
func DescribeGtmLogs(client *Client, request *DescribeGtmLogsRequest) (_result *DescribeGtmLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmLogsResponse{}
	_body, _err := DescribeGtmLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries available monitored nodes.
//
// @param request - DescribeGtmMonitorAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmMonitorAvailableConfigResponse
func DescribeGtmMonitorAvailableConfigWithOptions(client *Client, request *DescribeGtmMonitorAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmMonitorAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmMonitorAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmMonitorAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries available monitored nodes.
//
// @param request - DescribeGtmMonitorAvailableConfigRequest
//
// @return DescribeGtmMonitorAvailableConfigResponse
func DescribeGtmMonitorAvailableConfig(client *Client, request *DescribeGtmMonitorAvailableConfigRequest) (_result *DescribeGtmMonitorAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmMonitorAvailableConfigResponse{}
	_body, _err := DescribeGtmMonitorAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the health check configuration of an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmMonitorConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmMonitorConfigResponse
func DescribeGtmMonitorConfigWithOptions(client *Client, request *DescribeGtmMonitorConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmMonitorConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmMonitorConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmMonitorConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the health check configuration of an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmMonitorConfigRequest
//
// @return DescribeGtmMonitorConfigResponse
func DescribeGtmMonitorConfig(client *Client, request *DescribeGtmMonitorConfigRequest) (_result *DescribeGtmMonitorConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmMonitorConfigResponse{}
	_body, _err := DescribeGtmMonitorConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the details of a disaster recovery plan.
//
// @param request - DescribeGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmRecoveryPlanResponse
func DescribeGtmRecoveryPlanWithOptions(client *Client, request *DescribeGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the details of a disaster recovery plan.
//
// @param request - DescribeGtmRecoveryPlanRequest
//
// @return DescribeGtmRecoveryPlanResponse
func DescribeGtmRecoveryPlan(client *Client, request *DescribeGtmRecoveryPlanRequest) (_result *DescribeGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmRecoveryPlanResponse{}
	_body, _err := DescribeGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for a disaster recovery plan.
//
// @param request - DescribeGtmRecoveryPlanAvailableConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmRecoveryPlanAvailableConfigResponse
func DescribeGtmRecoveryPlanAvailableConfigWithOptions(client *Client, request *DescribeGtmRecoveryPlanAvailableConfigRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmRecoveryPlanAvailableConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmRecoveryPlanAvailableConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmRecoveryPlanAvailableConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configuration items that can be set for a disaster recovery plan.
//
// @param request - DescribeGtmRecoveryPlanAvailableConfigRequest
//
// @return DescribeGtmRecoveryPlanAvailableConfigResponse
func DescribeGtmRecoveryPlanAvailableConfig(client *Client, request *DescribeGtmRecoveryPlanAvailableConfigRequest) (_result *DescribeGtmRecoveryPlanAvailableConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmRecoveryPlanAvailableConfigResponse{}
	_body, _err := DescribeGtmRecoveryPlanAvailableConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the disaster recovery plans for a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmRecoveryPlansRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeGtmRecoveryPlansResponse
func DescribeGtmRecoveryPlansWithOptions(client *Client, request *DescribeGtmRecoveryPlansRequest, runtime *dara.RuntimeOptions) (_result *DescribeGtmRecoveryPlansResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeGtmRecoveryPlans"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeGtmRecoveryPlansResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the disaster recovery plans for a Global Traffic Manager (GTM) instance.
//
// @param request - DescribeGtmRecoveryPlansRequest
//
// @return DescribeGtmRecoveryPlansResponse
func DescribeGtmRecoveryPlans(client *Client, request *DescribeGtmRecoveryPlansRequest) (_result *DescribeGtmRecoveryPlansResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeGtmRecoveryPlansResponse{}
	_body, _err := DescribeGtmRecoveryPlansWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the domain names that are bound to an Alibaba Cloud DNS instance.
//
// @param request - DescribeInstanceDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeInstanceDomainsResponse
func DescribeInstanceDomainsWithOptions(client *Client, request *DescribeInstanceDomainsRequest, runtime *dara.RuntimeOptions) (_result *DescribeInstanceDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeInstanceDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeInstanceDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the domain names that are bound to an Alibaba Cloud DNS instance.
//
// @param request - DescribeInstanceDomainsRequest
//
// @return DescribeInstanceDomainsResponse
func DescribeInstanceDomains(client *Client, request *DescribeInstanceDomainsRequest) (_result *DescribeInstanceDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeInstanceDomainsResponse{}
	_body, _err := DescribeInstanceDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询解析日志
//
// @param request - DescribeInternetDnsLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeInternetDnsLogsResponse
func DescribeInternetDnsLogsWithOptions(client *Client, request *DescribeInternetDnsLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribeInternetDnsLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccountId) {
		query["AccountId"] = request.AccountId
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndTimestamp) {
		query["EndTimestamp"] = request.EndTimestamp
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Module) {
		query["Module"] = request.Module
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.QueryCondition) {
		query["QueryCondition"] = request.QueryCondition
	}

	if !dara.IsNil(request.RecursionProtocolType) {
		query["RecursionProtocolType"] = request.RecursionProtocolType
	}

	if !dara.IsNil(request.StartTimestamp) {
		query["StartTimestamp"] = request.StartTimestamp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeInternetDnsLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeInternetDnsLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询解析日志
//
// @param request - DescribeInternetDnsLogsRequest
//
// @return DescribeInternetDnsLogsResponse
func DescribeInternetDnsLogs(client *Client, request *DescribeInternetDnsLogsRequest) (_result *DescribeInternetDnsLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeInternetDnsLogsResponse{}
	_body, _err := DescribeInternetDnsLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取缓存刷新套餐包列表
//
// @param request - DescribeIspFlushCacheInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeIspFlushCacheInstancesResponse
func DescribeIspFlushCacheInstancesWithOptions(client *Client, request *DescribeIspFlushCacheInstancesRequest, runtime *dara.RuntimeOptions) (_result *DescribeIspFlushCacheInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.Isp) {
		query["Isp"] = request.Isp
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeIspFlushCacheInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeIspFlushCacheInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取缓存刷新套餐包列表
//
// @param request - DescribeIspFlushCacheInstancesRequest
//
// @return DescribeIspFlushCacheInstancesResponse
func DescribeIspFlushCacheInstances(client *Client, request *DescribeIspFlushCacheInstancesRequest) (_result *DescribeIspFlushCacheInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeIspFlushCacheInstancesResponse{}
	_body, _err := DescribeIspFlushCacheInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取剩余可缓存刷新次数
//
// @param request - DescribeIspFlushCacheRemainQuotaRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeIspFlushCacheRemainQuotaResponse
func DescribeIspFlushCacheRemainQuotaWithOptions(client *Client, request *DescribeIspFlushCacheRemainQuotaRequest, runtime *dara.RuntimeOptions) (_result *DescribeIspFlushCacheRemainQuotaResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeIspFlushCacheRemainQuota"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeIspFlushCacheRemainQuotaResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取剩余可缓存刷新次数
//
// @param request - DescribeIspFlushCacheRemainQuotaRequest
//
// @return DescribeIspFlushCacheRemainQuotaResponse
func DescribeIspFlushCacheRemainQuota(client *Client, request *DescribeIspFlushCacheRemainQuotaRequest) (_result *DescribeIspFlushCacheRemainQuotaResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeIspFlushCacheRemainQuotaResponse{}
	_body, _err := DescribeIspFlushCacheRemainQuotaWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取缓存刷新任务详情
//
// @param request - DescribeIspFlushCacheTaskRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeIspFlushCacheTaskResponse
func DescribeIspFlushCacheTaskWithOptions(client *Client, request *DescribeIspFlushCacheTaskRequest, runtime *dara.RuntimeOptions) (_result *DescribeIspFlushCacheTaskResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.TaskId) {
		query["TaskId"] = request.TaskId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeIspFlushCacheTask"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeIspFlushCacheTaskResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取缓存刷新任务详情
//
// @param request - DescribeIspFlushCacheTaskRequest
//
// @return DescribeIspFlushCacheTaskResponse
func DescribeIspFlushCacheTask(client *Client, request *DescribeIspFlushCacheTaskRequest) (_result *DescribeIspFlushCacheTaskResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeIspFlushCacheTaskResponse{}
	_body, _err := DescribeIspFlushCacheTaskWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取缓存刷新任务列表
//
// @param request - DescribeIspFlushCacheTasksRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeIspFlushCacheTasksResponse
func DescribeIspFlushCacheTasksWithOptions(client *Client, request *DescribeIspFlushCacheTasksRequest, runtime *dara.RuntimeOptions) (_result *DescribeIspFlushCacheTasksResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Isp) {
		query["Isp"] = request.Isp
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeIspFlushCacheTasks"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeIspFlushCacheTasksResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取缓存刷新任务列表
//
// @param request - DescribeIspFlushCacheTasksRequest
//
// @return DescribeIspFlushCacheTasksResponse
func DescribeIspFlushCacheTasks(client *Client, request *DescribeIspFlushCacheTasksRequest) (_result *DescribeIspFlushCacheTasksResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeIspFlushCacheTasksResponse{}
	_body, _err := DescribeIspFlushCacheTasksWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS用户数据概览
//
// @param request - DescribePdnsAccountSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsAccountSummaryResponse
func DescribePdnsAccountSummaryWithOptions(client *Client, request *DescribePdnsAccountSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsAccountSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsAccountSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsAccountSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS用户数据概览
//
// @param request - DescribePdnsAccountSummaryRequest
//
// @return DescribePdnsAccountSummaryResponse
func DescribePdnsAccountSummary(client *Client, request *DescribePdnsAccountSummaryRequest) (_result *DescribePdnsAccountSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsAccountSummaryResponse{}
	_body, _err := DescribePdnsAccountSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS AppKey 详情
//
// @param request - DescribePdnsAppKeyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsAppKeyResponse
func DescribePdnsAppKeyWithOptions(client *Client, request *DescribePdnsAppKeyRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsAppKeyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AppKeyId) {
		query["AppKeyId"] = request.AppKeyId
	}

	if !dara.IsNil(request.AuthCode) {
		query["AuthCode"] = request.AuthCode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsAppKey"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsAppKeyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS AppKey 详情
//
// @param request - DescribePdnsAppKeyRequest
//
// @return DescribePdnsAppKeyResponse
func DescribePdnsAppKey(client *Client, request *DescribePdnsAppKeyRequest) (_result *DescribePdnsAppKeyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsAppKeyResponse{}
	_body, _err := DescribePdnsAppKeyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS AppKey 列表
//
// @param request - DescribePdnsAppKeysRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsAppKeysResponse
func DescribePdnsAppKeysWithOptions(client *Client, request *DescribePdnsAppKeysRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsAppKeysResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsAppKeys"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsAppKeysResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS AppKey 列表
//
// @param request - DescribePdnsAppKeysRequest
//
// @return DescribePdnsAppKeysResponse
func DescribePdnsAppKeys(client *Client, request *DescribePdnsAppKeysRequest) (_result *DescribePdnsAppKeysResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsAppKeysResponse{}
	_body, _err := DescribePdnsAppKeysWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS 操作日志列表
//
// @param request - DescribePdnsOperateLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsOperateLogsResponse
func DescribePdnsOperateLogsWithOptions(client *Client, request *DescribePdnsOperateLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsOperateLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ActionType) {
		query["ActionType"] = request.ActionType
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.ResourceType) {
		query["ResourceType"] = request.ResourceType
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsOperateLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsOperateLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS 操作日志列表
//
// @param request - DescribePdnsOperateLogsRequest
//
// @return DescribePdnsOperateLogsResponse
func DescribePdnsOperateLogs(client *Client, request *DescribePdnsOperateLogsRequest) (_result *DescribePdnsOperateLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsOperateLogsResponse{}
	_body, _err := DescribePdnsOperateLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the statistics on requests for Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsRequestStatisticRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsRequestStatisticResponse
func DescribePdnsRequestStatisticWithOptions(client *Client, request *DescribePdnsRequestStatisticRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsRequestStatisticResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsRequestStatistic"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsRequestStatisticResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the statistics on requests for Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsRequestStatisticRequest
//
// @return DescribePdnsRequestStatisticResponse
func DescribePdnsRequestStatistic(client *Client, request *DescribePdnsRequestStatisticRequest) (_result *DescribePdnsRequestStatisticResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsRequestStatisticResponse{}
	_body, _err := DescribePdnsRequestStatisticWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of statistics on requests for Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsRequestStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsRequestStatisticsResponse
func DescribePdnsRequestStatisticsWithOptions(client *Client, request *DescribePdnsRequestStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsRequestStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsRequestStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsRequestStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of statistics on requests for Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsRequestStatisticsRequest
//
// @return DescribePdnsRequestStatisticsResponse
func DescribePdnsRequestStatistics(client *Client, request *DescribePdnsRequestStatisticsRequest) (_result *DescribePdnsRequestStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsRequestStatisticsResponse{}
	_body, _err := DescribePdnsRequestStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁日志列表
//
// @param request - DescribePdnsThreatLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsThreatLogsResponse
func DescribePdnsThreatLogsWithOptions(client *Client, request *DescribePdnsThreatLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsThreatLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.ThreatLevel) {
		query["ThreatLevel"] = request.ThreatLevel
	}

	if !dara.IsNil(request.ThreatSourceIp) {
		query["ThreatSourceIp"] = request.ThreatSourceIp
	}

	if !dara.IsNil(request.ThreatType) {
		query["ThreatType"] = request.ThreatType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsThreatLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsThreatLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁日志列表
//
// @param request - DescribePdnsThreatLogsRequest
//
// @return DescribePdnsThreatLogsResponse
func DescribePdnsThreatLogs(client *Client, request *DescribePdnsThreatLogsRequest) (_result *DescribePdnsThreatLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsThreatLogsResponse{}
	_body, _err := DescribePdnsThreatLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁统计
//
// @param request - DescribePdnsThreatStatisticRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsThreatStatisticResponse
func DescribePdnsThreatStatisticWithOptions(client *Client, request *DescribePdnsThreatStatisticRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsThreatStatisticResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.ThreatSourceIp) {
		query["ThreatSourceIp"] = request.ThreatSourceIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsThreatStatistic"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsThreatStatisticResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁统计
//
// @param request - DescribePdnsThreatStatisticRequest
//
// @return DescribePdnsThreatStatisticResponse
func DescribePdnsThreatStatistic(client *Client, request *DescribePdnsThreatStatisticRequest) (_result *DescribePdnsThreatStatisticResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsThreatStatisticResponse{}
	_body, _err := DescribePdnsThreatStatisticWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁统计列表
//
// @param request - DescribePdnsThreatStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsThreatStatisticsResponse
func DescribePdnsThreatStatisticsWithOptions(client *Client, request *DescribePdnsThreatStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsThreatStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	if !dara.IsNil(request.ThreatLevel) {
		query["ThreatLevel"] = request.ThreatLevel
	}

	if !dara.IsNil(request.ThreatSourceIp) {
		query["ThreatSourceIp"] = request.ThreatSourceIp
	}

	if !dara.IsNil(request.ThreatType) {
		query["ThreatType"] = request.ThreatType
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsThreatStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsThreatStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS 威胁统计列表
//
// @param request - DescribePdnsThreatStatisticsRequest
//
// @return DescribePdnsThreatStatisticsResponse
func DescribePdnsThreatStatistics(client *Client, request *DescribePdnsThreatStatisticsRequest) (_result *DescribePdnsThreatStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsThreatStatisticsResponse{}
	_body, _err := DescribePdnsThreatStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 获取公共DNS Udp IP段列表
//
// @param request - DescribePdnsUdpIpSegmentsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsUdpIpSegmentsResponse
func DescribePdnsUdpIpSegmentsWithOptions(client *Client, request *DescribePdnsUdpIpSegmentsRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsUdpIpSegmentsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsUdpIpSegments"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsUdpIpSegmentsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 获取公共DNS Udp IP段列表
//
// @param request - DescribePdnsUdpIpSegmentsRequest
//
// @return DescribePdnsUdpIpSegmentsResponse
func DescribePdnsUdpIpSegments(client *Client, request *DescribePdnsUdpIpSegmentsRequest) (_result *DescribePdnsUdpIpSegmentsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsUdpIpSegmentsResponse{}
	_body, _err := DescribePdnsUdpIpSegmentsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the information about users in Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsUserInfoRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribePdnsUserInfoResponse
func DescribePdnsUserInfoWithOptions(client *Client, request *DescribePdnsUserInfoRequest, runtime *dara.RuntimeOptions) (_result *DescribePdnsUserInfoResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribePdnsUserInfo"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribePdnsUserInfoResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the information about users in Alibaba Cloud Public DNS.
//
// @param request - DescribePdnsUserInfoRequest
//
// @return DescribePdnsUserInfoResponse
func DescribePdnsUserInfo(client *Client, request *DescribePdnsUserInfoRequest) (_result *DescribePdnsUserInfoResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribePdnsUserInfoResponse{}
	_body, _err := DescribePdnsUserInfoWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the operation logs of a domain name based on the specified parameters.
//
// @param request - DescribeRecordLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecordLogsResponse
func DescribeRecordLogsWithOptions(client *Client, request *DescribeRecordLogsRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecordLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.KeyWord) {
		query["KeyWord"] = request.KeyWord
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.EndDate) {
		query["endDate"] = request.EndDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecordLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecordLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the operation logs of a domain name based on the specified parameters.
//
// @param request - DescribeRecordLogsRequest
//
// @return DescribeRecordLogsResponse
func DescribeRecordLogs(client *Client, request *DescribeRecordLogsRequest) (_result *DescribeRecordLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecordLogsResponse{}
	_body, _err := DescribeRecordLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the number of resolution requests for all subdomain names of a specified domain name.
//
// @param request - DescribeRecordResolveStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecordResolveStatisticsSummaryResponse
func DescribeRecordResolveStatisticsSummaryWithOptions(client *Client, request *DescribeRecordResolveStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecordResolveStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.DomainType) {
		query["DomainType"] = request.DomainType
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.Threshold) {
		query["Threshold"] = request.Threshold
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecordResolveStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecordResolveStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the number of resolution requests for all subdomain names of a specified domain name.
//
// @param request - DescribeRecordResolveStatisticsSummaryRequest
//
// @return DescribeRecordResolveStatisticsSummaryResponse
func DescribeRecordResolveStatisticsSummary(client *Client, request *DescribeRecordResolveStatisticsSummaryRequest) (_result *DescribeRecordResolveStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecordResolveStatisticsSummaryResponse{}
	_body, _err := DescribeRecordResolveStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the real-time statistics on the Domain Name System (DNS) requests for a subdomain name.
//
// Description:
//
// Real-time data is collected per hour.
//
// @param request - DescribeRecordStatisticsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecordStatisticsResponse
func DescribeRecordStatisticsWithOptions(client *Client, request *DescribeRecordStatisticsRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecordStatisticsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.DomainType) {
		query["DomainType"] = request.DomainType
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecordStatistics"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecordStatisticsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the real-time statistics on the Domain Name System (DNS) requests for a subdomain name.
//
// Description:
//
// Real-time data is collected per hour.
//
// @param request - DescribeRecordStatisticsRequest
//
// @return DescribeRecordStatisticsResponse
func DescribeRecordStatistics(client *Client, request *DescribeRecordStatisticsRequest) (_result *DescribeRecordStatisticsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecordStatisticsResponse{}
	_body, _err := DescribeRecordStatisticsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the number of Domain Name System (DNS) requests for all subdomain names of a specified domain name.
//
// @param request - DescribeRecordStatisticsSummaryRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecordStatisticsSummaryResponse
func DescribeRecordStatisticsSummaryWithOptions(client *Client, request *DescribeRecordStatisticsSummaryRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecordStatisticsSummaryResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.DomainType) {
		query["DomainType"] = request.DomainType
	}

	if !dara.IsNil(request.EndDate) {
		query["EndDate"] = request.EndDate
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.SearchMode) {
		query["SearchMode"] = request.SearchMode
	}

	if !dara.IsNil(request.StartDate) {
		query["StartDate"] = request.StartDate
	}

	if !dara.IsNil(request.Threshold) {
		query["Threshold"] = request.Threshold
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecordStatisticsSummary"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecordStatisticsSummaryResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the number of Domain Name System (DNS) requests for all subdomain names of a specified domain name.
//
// @param request - DescribeRecordStatisticsSummaryRequest
//
// @return DescribeRecordStatisticsSummaryResponse
func DescribeRecordStatisticsSummary(client *Client, request *DescribeRecordStatisticsSummaryRequest) (_result *DescribeRecordStatisticsSummaryResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecordStatisticsSummaryResponse{}
	_body, _err := DescribeRecordStatisticsSummaryWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威解析记录详情
//
// @param request - DescribeRecursionRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecursionRecordResponse
func DescribeRecursionRecordWithOptions(client *Client, request *DescribeRecursionRecordRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecursionRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecursionRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecursionRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威解析记录详情
//
// @param request - DescribeRecursionRecordRequest
//
// @return DescribeRecursionRecordResponse
func DescribeRecursionRecord(client *Client, request *DescribeRecursionRecordRequest) (_result *DescribeRecursionRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecursionRecordResponse{}
	_body, _err := DescribeRecursionRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威域名zone详情
//
// @param request - DescribeRecursionZoneRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeRecursionZoneResponse
func DescribeRecursionZoneWithOptions(client *Client, request *DescribeRecursionZoneRequest, runtime *dara.RuntimeOptions) (_result *DescribeRecursionZoneResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeRecursionZone"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeRecursionZoneResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威域名zone详情
//
// @param request - DescribeRecursionZoneRequest
//
// @return DescribeRecursionZoneResponse
func DescribeRecursionZone(client *Client, request *DescribeRecursionZoneRequest) (_result *DescribeRecursionZoneResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeRecursionZoneResponse{}
	_body, _err := DescribeRecursionZoneWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries all Domain Name System (DNS) records of a subdomain name based on the specified parameters.
//
// @param request - DescribeSubDomainRecordsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeSubDomainRecordsResponse
func DescribeSubDomainRecordsWithOptions(client *Client, request *DescribeSubDomainRecordsRequest, runtime *dara.RuntimeOptions) (_result *DescribeSubDomainRecordsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Line) {
		query["Line"] = request.Line
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeSubDomainRecords"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeSubDomainRecordsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries all Domain Name System (DNS) records of a subdomain name based on the specified parameters.
//
// @param request - DescribeSubDomainRecordsRequest
//
// @return DescribeSubDomainRecordsResponse
func DescribeSubDomainRecords(client *Client, request *DescribeSubDomainRecordsRequest) (_result *DescribeSubDomainRecordsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeSubDomainRecordsResponse{}
	_body, _err := DescribeSubDomainRecordsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询支持的所有线路
//
// @param request - DescribeSupportLinesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeSupportLinesResponse
func DescribeSupportLinesWithOptions(client *Client, request *DescribeSupportLinesRequest, runtime *dara.RuntimeOptions) (_result *DescribeSupportLinesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeSupportLines"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeSupportLinesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询支持的所有线路
//
// @param request - DescribeSupportLinesRequest
//
// @return DescribeSupportLinesResponse
func DescribeSupportLines(client *Client, request *DescribeSupportLinesRequest) (_result *DescribeSupportLinesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeSupportLinesResponse{}
	_body, _err := DescribeSupportLinesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries existing tags.
//
// @param request - DescribeTagsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeTagsResponse
func DescribeTagsWithOptions(client *Client, request *DescribeTagsRequest, runtime *dara.RuntimeOptions) (_result *DescribeTagsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.ResourceType) {
		query["ResourceType"] = request.ResourceType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeTags"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeTagsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries existing tags.
//
// @param request - DescribeTagsRequest
//
// @return DescribeTagsResponse
func DescribeTags(client *Client, request *DescribeTagsRequest) (_result *DescribeTagsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeTagsResponse{}
	_body, _err := DescribeTagsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the domain names that were transferred between the current account and another account based on the specified parameters.
//
// @param request - DescribeTransferDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return DescribeTransferDomainsResponse
func DescribeTransferDomainsWithOptions(client *Client, request *DescribeTransferDomainsRequest, runtime *dara.RuntimeOptions) (_result *DescribeTransferDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.FromUserId) {
		query["FromUserId"] = request.FromUserId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.TargetUserId) {
		query["TargetUserId"] = request.TargetUserId
	}

	if !dara.IsNil(request.TransferType) {
		query["TransferType"] = request.TransferType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("DescribeTransferDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &DescribeTransferDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the domain names that were transferred between the current account and another account based on the specified parameters.
//
// @param request - DescribeTransferDomainsRequest
//
// @return DescribeTransferDomainsResponse
func DescribeTransferDomains(client *Client, request *DescribeTransferDomainsRequest) (_result *DescribeTransferDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &DescribeTransferDomainsResponse{}
	_body, _err := DescribeTransferDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Executes a disaster recovery plan.
//
// @param request - ExecuteGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ExecuteGtmRecoveryPlanResponse
func ExecuteGtmRecoveryPlanWithOptions(client *Client, request *ExecuteGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *ExecuteGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ExecuteGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ExecuteGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Executes a disaster recovery plan.
//
// @param request - ExecuteGtmRecoveryPlanRequest
//
// @return ExecuteGtmRecoveryPlanResponse
func ExecuteGtmRecoveryPlan(client *Client, request *ExecuteGtmRecoveryPlanRequest) (_result *ExecuteGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ExecuteGtmRecoveryPlanResponse{}
	_body, _err := ExecuteGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a primary domain name based on the specified parameters.
//
// Description:
//
// # For more information about the difference between primary domain names and subdomain names, see
//
// [Subdomain levels](https://www.alibabacloud.com/help/zh/faq-detail/39803.htm). For example, if you enter `www.abc.com`, abc.com is obtained.
//
// @param request - GetMainDomainNameRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return GetMainDomainNameResponse
func GetMainDomainNameWithOptions(client *Client, request *GetMainDomainNameRequest, runtime *dara.RuntimeOptions) (_result *GetMainDomainNameResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InputString) {
		query["InputString"] = request.InputString
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("GetMainDomainName"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &GetMainDomainNameResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a primary domain name based on the specified parameters.
//
// Description:
//
// # For more information about the difference between primary domain names and subdomain names, see
//
// [Subdomain levels](https://www.alibabacloud.com/help/zh/faq-detail/39803.htm). For example, if you enter `www.abc.com`, abc.com is obtained.
//
// @param request - GetMainDomainNameRequest
//
// @return GetMainDomainNameResponse
func GetMainDomainName(client *Client, request *GetMainDomainNameRequest) (_result *GetMainDomainNameResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &GetMainDomainNameResponse{}
	_body, _err := GetMainDomainNameWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Generates a text (TXT) record. TXT records are used to retrieve domain names and subdomain names, enable the subdomain name verification feature, and perform batch retrievals.
//
// @param request - GetTxtRecordForVerifyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return GetTxtRecordForVerifyResponse
func GetTxtRecordForVerifyWithOptions(client *Client, request *GetTxtRecordForVerifyRequest, runtime *dara.RuntimeOptions) (_result *GetTxtRecordForVerifyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("GetTxtRecordForVerify"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &GetTxtRecordForVerifyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Generates a text (TXT) record. TXT records are used to retrieve domain names and subdomain names, enable the subdomain name verification feature, and perform batch retrievals.
//
// @param request - GetTxtRecordForVerifyRequest
//
// @return GetTxtRecordForVerifyResponse
func GetTxtRecordForVerify(client *Client, request *GetTxtRecordForVerifyRequest) (_result *GetTxtRecordForVerifyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &GetTxtRecordForVerifyResponse{}
	_body, _err := GetTxtRecordForVerifyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of address pools.
//
// @param request - ListCloudGtmAddressPoolsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmAddressPoolsResponse
func ListCloudGtmAddressPoolsWithOptions(client *Client, request *ListCloudGtmAddressPoolsRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmAddressPoolsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolName) {
		query["AddressPoolName"] = request.AddressPoolName
	}

	if !dara.IsNil(request.AddressPoolType) {
		query["AddressPoolType"] = request.AddressPoolType
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmAddressPools"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmAddressPoolsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of address pools.
//
// @param request - ListCloudGtmAddressPoolsRequest
//
// @return ListCloudGtmAddressPoolsResponse
func ListCloudGtmAddressPools(client *Client, request *ListCloudGtmAddressPoolsRequest) (_result *ListCloudGtmAddressPoolsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmAddressPoolsResponse{}
	_body, _err := ListCloudGtmAddressPoolsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of addresses.
//
// @param request - ListCloudGtmAddressesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmAddressesResponse
func ListCloudGtmAddressesWithOptions(client *Client, request *ListCloudGtmAddressesRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmAddressesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.Address) {
		query["Address"] = request.Address
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthStatus) {
		query["HealthStatus"] = request.HealthStatus
	}

	if !dara.IsNil(request.MonitorTemplateId) {
		query["MonitorTemplateId"] = request.MonitorTemplateId
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmAddresses"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmAddressesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of addresses.
//
// @param request - ListCloudGtmAddressesRequest
//
// @return ListCloudGtmAddressesResponse
func ListCloudGtmAddresses(client *Client, request *ListCloudGtmAddressesRequest) (_result *ListCloudGtmAddressesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmAddressesResponse{}
	_body, _err := ListCloudGtmAddressesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - ListCloudGtmAlertLogsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmAlertLogsResponse
func ListCloudGtmAlertLogsWithOptions(client *Client, request *ListCloudGtmAlertLogsRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmAlertLogsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ActionType) {
		query["ActionType"] = request.ActionType
	}

	if !dara.IsNil(request.EndTimestamp) {
		query["EndTimestamp"] = request.EndTimestamp
	}

	if !dara.IsNil(request.EntityType) {
		query["EntityType"] = request.EntityType
	}

	if !dara.IsNil(request.Keyword) {
		query["Keyword"] = request.Keyword
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.StartTimestamp) {
		query["StartTimestamp"] = request.StartTimestamp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmAlertLogs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmAlertLogsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - ListCloudGtmAlertLogsRequest
//
// @return ListCloudGtmAlertLogsResponse
func ListCloudGtmAlertLogs(client *Client, request *ListCloudGtmAlertLogsRequest) (_result *ListCloudGtmAlertLogsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmAlertLogsResponse{}
	_body, _err := ListCloudGtmAlertLogsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - ListCloudGtmAvailableAlertGroupsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmAvailableAlertGroupsResponse
func ListCloudGtmAvailableAlertGroupsWithOptions(client *Client, request *ListCloudGtmAvailableAlertGroupsRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmAvailableAlertGroupsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmAvailableAlertGroups"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmAvailableAlertGroupsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - ListCloudGtmAvailableAlertGroupsRequest
//
// @return ListCloudGtmAvailableAlertGroupsResponse
func ListCloudGtmAvailableAlertGroups(client *Client, request *ListCloudGtmAvailableAlertGroupsRequest) (_result *ListCloudGtmAvailableAlertGroupsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmAvailableAlertGroupsResponse{}
	_body, _err := ListCloudGtmAvailableAlertGroupsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configurations of a Global Traffic Manager (GTM) instance, including the information about access domain names and address pools.
//
// @param request - ListCloudGtmInstanceConfigsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmInstanceConfigsResponse
func ListCloudGtmInstanceConfigsWithOptions(client *Client, request *ListCloudGtmInstanceConfigsRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmInstanceConfigsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ScheduleDomainName) {
		query["ScheduleDomainName"] = request.ScheduleDomainName
	}

	if !dara.IsNil(request.ScheduleZoneName) {
		query["ScheduleZoneName"] = request.ScheduleZoneName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmInstanceConfigs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmInstanceConfigsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configurations of a Global Traffic Manager (GTM) instance, including the information about access domain names and address pools.
//
// @param request - ListCloudGtmInstanceConfigsRequest
//
// @return ListCloudGtmInstanceConfigsResponse
func ListCloudGtmInstanceConfigs(client *Client, request *ListCloudGtmInstanceConfigsRequest) (_result *ListCloudGtmInstanceConfigsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmInstanceConfigsResponse{}
	_body, _err := ListCloudGtmInstanceConfigsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of Global Traffic Manager (GTM) 3.0 instances.
//
// @param request - ListCloudGtmInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmInstancesResponse
func ListCloudGtmInstancesWithOptions(client *Client, request *ListCloudGtmInstancesRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of Global Traffic Manager (GTM) 3.0 instances.
//
// @param request - ListCloudGtmInstancesRequest
//
// @return ListCloudGtmInstancesResponse
func ListCloudGtmInstances(client *Client, request *ListCloudGtmInstancesRequest) (_result *ListCloudGtmInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmInstancesResponse{}
	_body, _err := ListCloudGtmInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of health check nodes.
//
// @param request - ListCloudGtmMonitorNodesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmMonitorNodesResponse
func ListCloudGtmMonitorNodesWithOptions(client *Client, request *ListCloudGtmMonitorNodesRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmMonitorNodesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmMonitorNodes"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmMonitorNodesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of health check nodes.
//
// @param request - ListCloudGtmMonitorNodesRequest
//
// @return ListCloudGtmMonitorNodesResponse
func ListCloudGtmMonitorNodes(client *Client, request *ListCloudGtmMonitorNodesRequest) (_result *ListCloudGtmMonitorNodesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmMonitorNodesResponse{}
	_body, _err := ListCloudGtmMonitorNodesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of health check templates.
//
// @param request - ListCloudGtmMonitorTemplatesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListCloudGtmMonitorTemplatesResponse
func ListCloudGtmMonitorTemplatesWithOptions(client *Client, request *ListCloudGtmMonitorTemplatesRequest, runtime *dara.RuntimeOptions) (_result *ListCloudGtmMonitorTemplatesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.IpVersion) {
		query["IpVersion"] = request.IpVersion
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Protocol) {
		query["Protocol"] = request.Protocol
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListCloudGtmMonitorTemplates"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListCloudGtmMonitorTemplatesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of health check templates.
//
// @param request - ListCloudGtmMonitorTemplatesRequest
//
// @return ListCloudGtmMonitorTemplatesResponse
func ListCloudGtmMonitorTemplates(client *Client, request *ListCloudGtmMonitorTemplatesRequest) (_result *ListCloudGtmMonitorTemplatesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListCloudGtmMonitorTemplatesResponse{}
	_body, _err := ListCloudGtmMonitorTemplatesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威解析记录
//
// @param request - ListRecursionRecordsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListRecursionRecordsResponse
func ListRecursionRecordsWithOptions(client *Client, request *ListRecursionRecordsRequest, runtime *dara.RuntimeOptions) (_result *ListRecursionRecordsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Enable) {
		query["Enable"] = request.Enable
	}

	if !dara.IsNil(request.MaxResults) {
		query["MaxResults"] = request.MaxResults
	}

	if !dara.IsNil(request.NextToken) {
		query["NextToken"] = request.NextToken
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.RequestSource) {
		query["RequestSource"] = request.RequestSource
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListRecursionRecords"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListRecursionRecordsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威解析记录
//
// @param request - ListRecursionRecordsRequest
//
// @return ListRecursionRecordsResponse
func ListRecursionRecords(client *Client, request *ListRecursionRecordsRequest) (_result *ListRecursionRecordsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListRecursionRecordsResponse{}
	_body, _err := ListRecursionRecordsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威域名zone
//
// @param request - ListRecursionZonesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListRecursionZonesResponse
func ListRecursionZonesWithOptions(client *Client, request *ListRecursionZonesRequest, runtime *dara.RuntimeOptions) (_result *ListRecursionZonesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.MaxResults) {
		query["MaxResults"] = request.MaxResults
	}

	if !dara.IsNil(request.NextToken) {
		query["NextToken"] = request.NextToken
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ZoneName) {
		query["ZoneName"] = request.ZoneName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListRecursionZones"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListRecursionZonesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 查询递归解析内置权威域名zone
//
// @param request - ListRecursionZonesRequest
//
// @return ListRecursionZonesResponse
func ListRecursionZones(client *Client, request *ListRecursionZonesRequest) (_result *ListRecursionZonesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListRecursionZonesResponse{}
	_body, _err := ListRecursionZonesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries resources by tag.
//
// Description:
//
//	  Set ResourceId.N or Tag.N that consists of Tag.N.Key and Tag.N.Value in the request to specify the object to be queried.
//
//		- Tag.N is a resource tag that consists of a key-value pair. If you set only Tag.N.Key, all tag values that are assigned to the specified key are returned. If you set only Tag.N.Value, an error message is returned.
//
//		- If you set both Tag.N and ResourceId.N to filter tags, ResourceId.N must match all specified key-value pairs.
//
//		- If you specify multiple key-value pairs, resources that contain these key-value pairs are returned.
//
// @param request - ListTagResourcesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ListTagResourcesResponse
func ListTagResourcesWithOptions(client *Client, request *ListTagResourcesRequest, runtime *dara.RuntimeOptions) (_result *ListTagResourcesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NextToken) {
		query["NextToken"] = request.NextToken
	}

	if !dara.IsNil(request.ResourceId) {
		query["ResourceId"] = request.ResourceId
	}

	if !dara.IsNil(request.ResourceType) {
		query["ResourceType"] = request.ResourceType
	}

	if !dara.IsNil(request.Tag) {
		query["Tag"] = request.Tag
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ListTagResources"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ListTagResourcesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries resources by tag.
//
// Description:
//
//	  Set ResourceId.N or Tag.N that consists of Tag.N.Key and Tag.N.Value in the request to specify the object to be queried.
//
//		- Tag.N is a resource tag that consists of a key-value pair. If you set only Tag.N.Key, all tag values that are assigned to the specified key are returned. If you set only Tag.N.Value, an error message is returned.
//
//		- If you set both Tag.N and ResourceId.N to filter tags, ResourceId.N must match all specified key-value pairs.
//
//		- If you specify multiple key-value pairs, resources that contain these key-value pairs are returned.
//
// @param request - ListTagResourcesRequest
//
// @return ListTagResourcesResponse
func ListTagResources(client *Client, request *ListTagResourcesRequest) (_result *ListTagResourcesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ListTagResourcesResponse{}
	_body, _err := ListTagResourcesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Changes the names of DNS servers bound to a domain name from DNS server names provided by a third-party service provider to DNS server names provided by Alibaba Cloud DNS.
//
// Description:
//
// If the operation succeeds, the names of DNS servers change to those of Alibaba Cloud DNS servers (ending with hichina.com).
//
// >  **Before you call this operation, make sure that your domain name has been registered with Alibaba Cloud and the DNS servers in use are not Alibaba Cloud DNS servers.
//
// @param request - ModifyHichinaDomainDNSRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ModifyHichinaDomainDNSResponse
func ModifyHichinaDomainDNSWithOptions(client *Client, request *ModifyHichinaDomainDNSRequest, runtime *dara.RuntimeOptions) (_result *ModifyHichinaDomainDNSResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ModifyHichinaDomainDNS"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ModifyHichinaDomainDNSResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Changes the names of DNS servers bound to a domain name from DNS server names provided by a third-party service provider to DNS server names provided by Alibaba Cloud DNS.
//
// Description:
//
// If the operation succeeds, the names of DNS servers change to those of Alibaba Cloud DNS servers (ending with hichina.com).
//
// >  **Before you call this operation, make sure that your domain name has been registered with Alibaba Cloud and the DNS servers in use are not Alibaba Cloud DNS servers.
//
// @param request - ModifyHichinaDomainDNSRequest
//
// @return ModifyHichinaDomainDNSResponse
func ModifyHichinaDomainDNS(client *Client, request *ModifyHichinaDomainDNSRequest) (_result *ModifyHichinaDomainDNSResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ModifyHichinaDomainDNSResponse{}
	_body, _err := ModifyHichinaDomainDNSWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Moves a domain name to another resource group.
//
// @param request - MoveDomainResourceGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return MoveDomainResourceGroupResponse
func MoveDomainResourceGroupWithOptions(client *Client, request *MoveDomainResourceGroupRequest, runtime *dara.RuntimeOptions) (_result *MoveDomainResourceGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NewResourceGroupId) {
		query["NewResourceGroupId"] = request.NewResourceGroupId
	}

	if !dara.IsNil(request.ResourceId) {
		query["ResourceId"] = request.ResourceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("MoveDomainResourceGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &MoveDomainResourceGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Moves a domain name to another resource group.
//
// @param request - MoveDomainResourceGroupRequest
//
// @return MoveDomainResourceGroupResponse
func MoveDomainResourceGroup(client *Client, request *MoveDomainResourceGroupRequest) (_result *MoveDomainResourceGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &MoveDomainResourceGroupResponse{}
	_body, _err := MoveDomainResourceGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - MoveGtmResourceGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return MoveGtmResourceGroupResponse
func MoveGtmResourceGroupWithOptions(client *Client, request *MoveGtmResourceGroupRequest, runtime *dara.RuntimeOptions) (_result *MoveGtmResourceGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.NewResourceGroupId) {
		query["NewResourceGroupId"] = request.NewResourceGroupId
	}

	if !dara.IsNil(request.ResourceId) {
		query["ResourceId"] = request.ResourceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("MoveGtmResourceGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &MoveGtmResourceGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - MoveGtmResourceGroupRequest
//
// @return MoveGtmResourceGroupResponse
func MoveGtmResourceGroup(client *Client, request *MoveGtmResourceGroupRequest) (_result *MoveGtmResourceGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &MoveGtmResourceGroupResponse{}
	_body, _err := MoveGtmResourceGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds or deletes domain names and Domain Name System (DNS) records in batches.
//
// Description:
//
// Scenario: You need to execute a large number of tasks related to DNS resolution and you do not have high requirements for efficiency.
//
// @param request - OperateBatchDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return OperateBatchDomainResponse
func OperateBatchDomainWithOptions(client *Client, request *OperateBatchDomainRequest, runtime *dara.RuntimeOptions) (_result *OperateBatchDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainRecordInfo) {
		query["DomainRecordInfo"] = request.DomainRecordInfo
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("OperateBatchDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &OperateBatchDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds or deletes domain names and Domain Name System (DNS) records in batches.
//
// Description:
//
// Scenario: You need to execute a large number of tasks related to DNS resolution and you do not have high requirements for efficiency.
//
// @param request - OperateBatchDomainRequest
//
// @return OperateBatchDomainResponse
func OperateBatchDomain(client *Client, request *OperateBatchDomainRequest) (_result *OperateBatchDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &OperateBatchDomainResponse{}
	_body, _err := OperateBatchDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 暂停公共DNS服务
//
// @param request - PausePdnsServiceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return PausePdnsServiceResponse
func PausePdnsServiceWithOptions(client *Client, request *PausePdnsServiceRequest, runtime *dara.RuntimeOptions) (_result *PausePdnsServiceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.ServiceType) {
		query["ServiceType"] = request.ServiceType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("PausePdnsService"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &PausePdnsServiceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 暂停公共DNS服务
//
// @param request - PausePdnsServiceRequest
//
// @return PausePdnsServiceResponse
func PausePdnsService(client *Client, request *PausePdnsServiceRequest) (_result *PausePdnsServiceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &PausePdnsServiceResponse{}
	_body, _err := PausePdnsServiceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// You can call this operation to preview a disaster recovery plan of a Global Traffic Manager (GTM) instance.
//
// @param request - PreviewGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return PreviewGtmRecoveryPlanResponse
func PreviewGtmRecoveryPlanWithOptions(client *Client, request *PreviewGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *PreviewGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("PreviewGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &PreviewGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// You can call this operation to preview a disaster recovery plan of a Global Traffic Manager (GTM) instance.
//
// @param request - PreviewGtmRecoveryPlanRequest
//
// @return PreviewGtmRecoveryPlanResponse
func PreviewGtmRecoveryPlan(client *Client, request *PreviewGtmRecoveryPlanRequest) (_result *PreviewGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &PreviewGtmRecoveryPlanResponse{}
	_body, _err := PreviewGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 删除公共DNS AppKey
//
// @param request - RemovePdnsAppKeyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return RemovePdnsAppKeyResponse
func RemovePdnsAppKeyWithOptions(client *Client, request *RemovePdnsAppKeyRequest, runtime *dara.RuntimeOptions) (_result *RemovePdnsAppKeyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AppKeyId) {
		query["AppKeyId"] = request.AppKeyId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("RemovePdnsAppKey"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &RemovePdnsAppKeyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 删除公共DNS AppKey
//
// @param request - RemovePdnsAppKeyRequest
//
// @return RemovePdnsAppKeyResponse
func RemovePdnsAppKey(client *Client, request *RemovePdnsAppKeyRequest) (_result *RemovePdnsAppKeyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &RemovePdnsAppKeyResponse{}
	_body, _err := RemovePdnsAppKeyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 删除公共DNS Udp Ip地址段
//
// @param request - RemovePdnsUdpIpSegmentRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return RemovePdnsUdpIpSegmentResponse
func RemovePdnsUdpIpSegmentWithOptions(client *Client, request *RemovePdnsUdpIpSegmentRequest, runtime *dara.RuntimeOptions) (_result *RemovePdnsUdpIpSegmentResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Ip) {
		query["Ip"] = request.Ip
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("RemovePdnsUdpIpSegment"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &RemovePdnsUdpIpSegmentResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 删除公共DNS Udp Ip地址段
//
// @param request - RemovePdnsUdpIpSegmentRequest
//
// @return RemovePdnsUdpIpSegmentResponse
func RemovePdnsUdpIpSegment(client *Client, request *RemovePdnsUdpIpSegmentRequest) (_result *RemovePdnsUdpIpSegmentResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &RemovePdnsUdpIpSegmentResponse{}
	_body, _err := RemovePdnsUdpIpSegmentWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Replaces the addresses referenced by an address pool.
//
// @param tmpReq - ReplaceCloudGtmAddressPoolAddressRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ReplaceCloudGtmAddressPoolAddressResponse
func ReplaceCloudGtmAddressPoolAddressWithOptions(client *Client, tmpReq *ReplaceCloudGtmAddressPoolAddressRequest, runtime *dara.RuntimeOptions) (_result *ReplaceCloudGtmAddressPoolAddressResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &ReplaceCloudGtmAddressPoolAddressShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.Addresses) {
		request.AddressesShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.Addresses, dara.String("Addresses"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.AddressesShrink) {
		query["Addresses"] = request.AddressesShrink
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ReplaceCloudGtmAddressPoolAddress"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ReplaceCloudGtmAddressPoolAddressResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Replaces the addresses referenced by an address pool.
//
// @param request - ReplaceCloudGtmAddressPoolAddressRequest
//
// @return ReplaceCloudGtmAddressPoolAddressResponse
func ReplaceCloudGtmAddressPoolAddress(client *Client, request *ReplaceCloudGtmAddressPoolAddressRequest) (_result *ReplaceCloudGtmAddressPoolAddressResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ReplaceCloudGtmAddressPoolAddressResponse{}
	_body, _err := ReplaceCloudGtmAddressPoolAddressWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Replaces address pools that are associated with a Global Traffic Manager (GTM) 3.0 instance with new address pools.
//
// @param tmpReq - ReplaceCloudGtmInstanceConfigAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ReplaceCloudGtmInstanceConfigAddressPoolResponse
func ReplaceCloudGtmInstanceConfigAddressPoolWithOptions(client *Client, tmpReq *ReplaceCloudGtmInstanceConfigAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *ReplaceCloudGtmInstanceConfigAddressPoolResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &ReplaceCloudGtmInstanceConfigAddressPoolShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.AddressPools) {
		request.AddressPoolsShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.AddressPools, dara.String("AddressPools"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolsShrink) {
		query["AddressPools"] = request.AddressPoolsShrink
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ReplaceCloudGtmInstanceConfigAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ReplaceCloudGtmInstanceConfigAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Replaces address pools that are associated with a Global Traffic Manager (GTM) 3.0 instance with new address pools.
//
// @param request - ReplaceCloudGtmInstanceConfigAddressPoolRequest
//
// @return ReplaceCloudGtmInstanceConfigAddressPoolResponse
func ReplaceCloudGtmInstanceConfigAddressPool(client *Client, request *ReplaceCloudGtmInstanceConfigAddressPoolRequest) (_result *ReplaceCloudGtmInstanceConfigAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ReplaceCloudGtmInstanceConfigAddressPoolResponse{}
	_body, _err := ReplaceCloudGtmInstanceConfigAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 恢复公共DNS服务
//
// @param request - ResumePdnsServiceRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ResumePdnsServiceResponse
func ResumePdnsServiceWithOptions(client *Client, request *ResumePdnsServiceRequest, runtime *dara.RuntimeOptions) (_result *ResumePdnsServiceResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.ServiceType) {
		query["ServiceType"] = request.ServiceType
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ResumePdnsService"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ResumePdnsServiceResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 恢复公共DNS服务
//
// @param request - ResumePdnsServiceRequest
//
// @return ResumePdnsServiceResponse
func ResumePdnsService(client *Client, request *ResumePdnsServiceRequest) (_result *ResumePdnsServiceResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ResumePdnsServiceResponse{}
	_body, _err := ResumePdnsServiceWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Retrieves a domain name.
//
// Description:
//
// To retrieve a domain name, you must verify a text (TXT) record. Therefore, before you call this API operation to retrieve a domain name, call the [GetTxtRecordForVerify](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/generating-a-txt-record) operation to generate a TXT record.
//
// @param request - RetrieveDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return RetrieveDomainResponse
func RetrieveDomainWithOptions(client *Client, request *RetrieveDomainRequest, runtime *dara.RuntimeOptions) (_result *RetrieveDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("RetrieveDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &RetrieveDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Retrieves a domain name.
//
// Description:
//
// To retrieve a domain name, you must verify a text (TXT) record. Therefore, before you call this API operation to retrieve a domain name, call the [GetTxtRecordForVerify](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/generating-a-txt-record) operation to generate a TXT record.
//
// @param request - RetrieveDomainRequest
//
// @return RetrieveDomainResponse
func RetrieveDomain(client *Client, request *RetrieveDomainRequest) (_result *RetrieveDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &RetrieveDomainResponse{}
	_body, _err := RetrieveDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Rolls back a disaster recovery plan.
//
// @param request - RollbackGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return RollbackGtmRecoveryPlanResponse
func RollbackGtmRecoveryPlanWithOptions(client *Client, request *RollbackGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *RollbackGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("RollbackGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &RollbackGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Rolls back a disaster recovery plan.
//
// @param request - RollbackGtmRecoveryPlanRequest
//
// @return RollbackGtmRecoveryPlanResponse
func RollbackGtmRecoveryPlan(client *Client, request *RollbackGtmRecoveryPlanRequest) (_result *RollbackGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &RollbackGtmRecoveryPlanResponse{}
	_body, _err := RollbackGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of address pools.
//
// @param request - SearchCloudGtmAddressPoolsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchCloudGtmAddressPoolsResponse
func SearchCloudGtmAddressPoolsWithOptions(client *Client, request *SearchCloudGtmAddressPoolsRequest, runtime *dara.RuntimeOptions) (_result *SearchCloudGtmAddressPoolsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolName) {
		query["AddressPoolName"] = request.AddressPoolName
	}

	if !dara.IsNil(request.AddressPoolType) {
		query["AddressPoolType"] = request.AddressPoolType
	}

	if !dara.IsNil(request.AvailableStatus) {
		query["AvailableStatus"] = request.AvailableStatus
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthStatus) {
		query["HealthStatus"] = request.HealthStatus
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchCloudGtmAddressPools"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchCloudGtmAddressPoolsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of address pools.
//
// @param request - SearchCloudGtmAddressPoolsRequest
//
// @return SearchCloudGtmAddressPoolsResponse
func SearchCloudGtmAddressPools(client *Client, request *SearchCloudGtmAddressPoolsRequest) (_result *SearchCloudGtmAddressPoolsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchCloudGtmAddressPoolsResponse{}
	_body, _err := SearchCloudGtmAddressPoolsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of addresses based on address names, descriptions, health check templates referenced by the addresses, or address IDs.
//
// @param request - SearchCloudGtmAddressesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchCloudGtmAddressesResponse
func SearchCloudGtmAddressesWithOptions(client *Client, request *SearchCloudGtmAddressesRequest, runtime *dara.RuntimeOptions) (_result *SearchCloudGtmAddressesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.Address) {
		query["Address"] = request.Address
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.AvailableStatus) {
		query["AvailableStatus"] = request.AvailableStatus
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthStatus) {
		query["HealthStatus"] = request.HealthStatus
	}

	if !dara.IsNil(request.MonitorTemplateName) {
		query["MonitorTemplateName"] = request.MonitorTemplateName
	}

	if !dara.IsNil(request.NameSearchCondition) {
		query["NameSearchCondition"] = request.NameSearchCondition
	}

	if !dara.IsNil(request.Names) {
		query["Names"] = request.Names
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.RemarkSearchCondition) {
		query["RemarkSearchCondition"] = request.RemarkSearchCondition
	}

	if !dara.IsNil(request.Remarks) {
		query["Remarks"] = request.Remarks
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchCloudGtmAddresses"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchCloudGtmAddressesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of addresses based on address names, descriptions, health check templates referenced by the addresses, or address IDs.
//
// @param request - SearchCloudGtmAddressesRequest
//
// @return SearchCloudGtmAddressesResponse
func SearchCloudGtmAddresses(client *Client, request *SearchCloudGtmAddressesRequest) (_result *SearchCloudGtmAddressesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchCloudGtmAddressesResponse{}
	_body, _err := SearchCloudGtmAddressesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the configurations of an access domain name.
//
// @param request - SearchCloudGtmInstanceConfigsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchCloudGtmInstanceConfigsResponse
func SearchCloudGtmInstanceConfigsWithOptions(client *Client, request *SearchCloudGtmInstanceConfigsRequest, runtime *dara.RuntimeOptions) (_result *SearchCloudGtmInstanceConfigsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AvailableStatus) {
		query["AvailableStatus"] = request.AvailableStatus
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.HealthStatus) {
		query["HealthStatus"] = request.HealthStatus
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ScheduleDomainName) {
		query["ScheduleDomainName"] = request.ScheduleDomainName
	}

	if !dara.IsNil(request.ScheduleZoneName) {
		query["ScheduleZoneName"] = request.ScheduleZoneName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchCloudGtmInstanceConfigs"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchCloudGtmInstanceConfigsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the configurations of an access domain name.
//
// @param request - SearchCloudGtmInstanceConfigsRequest
//
// @return SearchCloudGtmInstanceConfigsResponse
func SearchCloudGtmInstanceConfigs(client *Client, request *SearchCloudGtmInstanceConfigsRequest) (_result *SearchCloudGtmInstanceConfigsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchCloudGtmInstanceConfigsResponse{}
	_body, _err := SearchCloudGtmInstanceConfigsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries a list of instances.
//
// @param request - SearchCloudGtmInstancesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchCloudGtmInstancesResponse
func SearchCloudGtmInstancesWithOptions(client *Client, request *SearchCloudGtmInstancesRequest, runtime *dara.RuntimeOptions) (_result *SearchCloudGtmInstancesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchCloudGtmInstances"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchCloudGtmInstancesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries a list of instances.
//
// @param request - SearchCloudGtmInstancesRequest
//
// @return SearchCloudGtmInstancesResponse
func SearchCloudGtmInstances(client *Client, request *SearchCloudGtmInstancesRequest) (_result *SearchCloudGtmInstancesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchCloudGtmInstancesResponse{}
	_body, _err := SearchCloudGtmInstancesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Queries the list of health check templates.
//
// @param request - SearchCloudGtmMonitorTemplatesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchCloudGtmMonitorTemplatesResponse
func SearchCloudGtmMonitorTemplatesWithOptions(client *Client, request *SearchCloudGtmMonitorTemplatesRequest, runtime *dara.RuntimeOptions) (_result *SearchCloudGtmMonitorTemplatesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.IpVersion) {
		query["IpVersion"] = request.IpVersion
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Protocol) {
		query["Protocol"] = request.Protocol
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchCloudGtmMonitorTemplates"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchCloudGtmMonitorTemplatesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Queries the list of health check templates.
//
// @param request - SearchCloudGtmMonitorTemplatesRequest
//
// @return SearchCloudGtmMonitorTemplatesResponse
func SearchCloudGtmMonitorTemplates(client *Client, request *SearchCloudGtmMonitorTemplatesRequest) (_result *SearchCloudGtmMonitorTemplatesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchCloudGtmMonitorTemplatesResponse{}
	_body, _err := SearchCloudGtmMonitorTemplatesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 搜索递归解析内置权威解析记录
//
// @param request - SearchRecursionRecordsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchRecursionRecordsResponse
func SearchRecursionRecordsWithOptions(client *Client, request *SearchRecursionRecordsRequest, runtime *dara.RuntimeOptions) (_result *SearchRecursionRecordsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.MaxResults) {
		query["MaxResults"] = request.MaxResults
	}

	if !dara.IsNil(request.NextToken) {
		query["NextToken"] = request.NextToken
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.RequestSource) {
		query["RequestSource"] = request.RequestSource
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.Value) {
		query["Value"] = request.Value
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchRecursionRecords"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchRecursionRecordsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 搜索递归解析内置权威解析记录
//
// @param request - SearchRecursionRecordsRequest
//
// @return SearchRecursionRecordsResponse
func SearchRecursionRecords(client *Client, request *SearchRecursionRecordsRequest) (_result *SearchRecursionRecordsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchRecursionRecordsResponse{}
	_body, _err := SearchRecursionRecordsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 搜索递归解析内置权威域名zone
//
// @param tmpReq - SearchRecursionZonesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SearchRecursionZonesResponse
func SearchRecursionZonesWithOptions(client *Client, tmpReq *SearchRecursionZonesRequest, runtime *dara.RuntimeOptions) (_result *SearchRecursionZonesResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &SearchRecursionZonesShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.EffectiveScopes) {
		request.EffectiveScopesShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.EffectiveScopes, dara.String("EffectiveScopes"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.Direction) {
		query["Direction"] = request.Direction
	}

	if !dara.IsNil(request.EffectiveScopesShrink) {
		query["EffectiveScopes"] = request.EffectiveScopesShrink
	}

	if !dara.IsNil(request.MaxResults) {
		query["MaxResults"] = request.MaxResults
	}

	if !dara.IsNil(request.NextToken) {
		query["NextToken"] = request.NextToken
	}

	if !dara.IsNil(request.OrderBy) {
		query["OrderBy"] = request.OrderBy
	}

	if !dara.IsNil(request.PageNumber) {
		query["PageNumber"] = request.PageNumber
	}

	if !dara.IsNil(request.PageSize) {
		query["PageSize"] = request.PageSize
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ZoneName) {
		query["ZoneName"] = request.ZoneName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SearchRecursionZones"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SearchRecursionZonesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 搜索递归解析内置权威域名zone
//
// @param request - SearchRecursionZonesRequest
//
// @return SearchRecursionZonesResponse
func SearchRecursionZones(client *Client, request *SearchRecursionZonesRequest) (_result *SearchRecursionZonesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SearchRecursionZonesResponse{}
	_body, _err := SearchRecursionZonesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Enables or disables weighted round-robin based on the specified parameters.
//
// @param request - SetDNSSLBStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetDNSSLBStatusResponse
func SetDNSSLBStatusWithOptions(client *Client, request *SetDNSSLBStatusRequest, runtime *dara.RuntimeOptions) (_result *SetDNSSLBStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Line) {
		query["Line"] = request.Line
	}

	if !dara.IsNil(request.Open) {
		query["Open"] = request.Open
	}

	if !dara.IsNil(request.SubDomain) {
		query["SubDomain"] = request.SubDomain
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetDNSSLBStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetDNSSLBStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Enables or disables weighted round-robin based on the specified parameters.
//
// @param request - SetDNSSLBStatusRequest
//
// @return SetDNSSLBStatusResponse
func SetDNSSLBStatus(client *Client, request *SetDNSSLBStatusRequest) (_result *SetDNSSLBStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetDNSSLBStatusResponse{}
	_body, _err := SetDNSSLBStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies an access policy.
//
// Description:
//
// ***
//
// @param request - SetDnsGtmAccessModeRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetDnsGtmAccessModeResponse
func SetDnsGtmAccessModeWithOptions(client *Client, request *SetDnsGtmAccessModeRequest, runtime *dara.RuntimeOptions) (_result *SetDnsGtmAccessModeResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccessMode) {
		query["AccessMode"] = request.AccessMode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetDnsGtmAccessMode"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetDnsGtmAccessModeResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies an access policy.
//
// Description:
//
// ***
//
// @param request - SetDnsGtmAccessModeRequest
//
// @return SetDnsGtmAccessModeResponse
func SetDnsGtmAccessMode(client *Client, request *SetDnsGtmAccessModeRequest) (_result *SetDnsGtmAccessModeResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetDnsGtmAccessModeResponse{}
	_body, _err := SetDnsGtmAccessModeWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Specifies the health check status of an address pool.
//
// @param request - SetDnsGtmMonitorStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetDnsGtmMonitorStatusResponse
func SetDnsGtmMonitorStatusWithOptions(client *Client, request *SetDnsGtmMonitorStatusRequest, runtime *dara.RuntimeOptions) (_result *SetDnsGtmMonitorStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetDnsGtmMonitorStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetDnsGtmMonitorStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Specifies the health check status of an address pool.
//
// @param request - SetDnsGtmMonitorStatusRequest
//
// @return SetDnsGtmMonitorStatusResponse
func SetDnsGtmMonitorStatus(client *Client, request *SetDnsGtmMonitorStatusRequest) (_result *SetDnsGtmMonitorStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetDnsGtmMonitorStatusResponse{}
	_body, _err := SetDnsGtmMonitorStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Enables or disables the Domain Name System Security Extensions (DNSSEC) for a domain name. This feature is available only for the users of the paid editions of Alibaba Cloud DNS.
//
// @param request - SetDomainDnssecStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetDomainDnssecStatusResponse
func SetDomainDnssecStatusWithOptions(client *Client, request *SetDomainDnssecStatusRequest, runtime *dara.RuntimeOptions) (_result *SetDomainDnssecStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetDomainDnssecStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetDomainDnssecStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Enables or disables the Domain Name System Security Extensions (DNSSEC) for a domain name. This feature is available only for the users of the paid editions of Alibaba Cloud DNS.
//
// @param request - SetDomainDnssecStatusRequest
//
// @return SetDomainDnssecStatusResponse
func SetDomainDnssecStatus(client *Client, request *SetDomainDnssecStatusRequest) (_result *SetDomainDnssecStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetDomainDnssecStatusResponse{}
	_body, _err := SetDomainDnssecStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Specifies the status of an Alibaba Cloud DNS (DNS) record based on the specified parameters.
//
// @param request - SetDomainRecordStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetDomainRecordStatusResponse
func SetDomainRecordStatusWithOptions(client *Client, request *SetDomainRecordStatusRequest, runtime *dara.RuntimeOptions) (_result *SetDomainRecordStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetDomainRecordStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetDomainRecordStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Specifies the status of an Alibaba Cloud DNS (DNS) record based on the specified parameters.
//
// @param request - SetDomainRecordStatusRequest
//
// @return SetDomainRecordStatusResponse
func SetDomainRecordStatus(client *Client, request *SetDomainRecordStatusRequest) (_result *SetDomainRecordStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetDomainRecordStatusResponse{}
	_body, _err := SetDomainRecordStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies a policy for switchover between address pool sets.
//
// @param request - SetGtmAccessModeRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetGtmAccessModeResponse
func SetGtmAccessModeWithOptions(client *Client, request *SetGtmAccessModeRequest, runtime *dara.RuntimeOptions) (_result *SetGtmAccessModeResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccessMode) {
		query["AccessMode"] = request.AccessMode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetGtmAccessMode"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetGtmAccessModeResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies a policy for switchover between address pool sets.
//
// @param request - SetGtmAccessModeRequest
//
// @return SetGtmAccessModeResponse
func SetGtmAccessMode(client *Client, request *SetGtmAccessModeRequest) (_result *SetGtmAccessModeResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetGtmAccessModeResponse{}
	_body, _err := SetGtmAccessModeWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - SetGtmMonitorStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SetGtmMonitorStatusResponse
func SetGtmMonitorStatusWithOptions(client *Client, request *SetGtmMonitorStatusRequest, runtime *dara.RuntimeOptions) (_result *SetGtmMonitorStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	if !dara.IsNil(request.Status) {
		query["Status"] = request.Status
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SetGtmMonitorStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SetGtmMonitorStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - SetGtmMonitorStatusRequest
//
// @return SetGtmMonitorStatusResponse
func SetGtmMonitorStatus(client *Client, request *SetGtmMonitorStatusRequest) (_result *SetGtmMonitorStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SetGtmMonitorStatusResponse{}
	_body, _err := SetGtmMonitorStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 提交缓存刷新任务
//
// @param request - SubmitIspFlushCacheTaskRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SubmitIspFlushCacheTaskResponse
func SubmitIspFlushCacheTaskWithOptions(client *Client, request *SubmitIspFlushCacheTaskRequest, runtime *dara.RuntimeOptions) (_result *SubmitIspFlushCacheTaskResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Isp) {
		query["Isp"] = request.Isp
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SubmitIspFlushCacheTask"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SubmitIspFlushCacheTaskResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 提交缓存刷新任务
//
// @param request - SubmitIspFlushCacheTaskRequest
//
// @return SubmitIspFlushCacheTaskResponse
func SubmitIspFlushCacheTask(client *Client, request *SubmitIspFlushCacheTaskRequest) (_result *SubmitIspFlushCacheTaskResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SubmitIspFlushCacheTaskResponse{}
	_body, _err := SubmitIspFlushCacheTaskWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Changes the access policy type for a Global Traffic Manager (GTM) instance.
//
// @param request - SwitchDnsGtmInstanceStrategyModeRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return SwitchDnsGtmInstanceStrategyModeResponse
func SwitchDnsGtmInstanceStrategyModeWithOptions(client *Client, request *SwitchDnsGtmInstanceStrategyModeRequest, runtime *dara.RuntimeOptions) (_result *SwitchDnsGtmInstanceStrategyModeResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyMode) {
		query["StrategyMode"] = request.StrategyMode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("SwitchDnsGtmInstanceStrategyMode"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &SwitchDnsGtmInstanceStrategyModeResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Changes the access policy type for a Global Traffic Manager (GTM) instance.
//
// @param request - SwitchDnsGtmInstanceStrategyModeRequest
//
// @return SwitchDnsGtmInstanceStrategyModeResponse
func SwitchDnsGtmInstanceStrategyMode(client *Client, request *SwitchDnsGtmInstanceStrategyModeRequest) (_result *SwitchDnsGtmInstanceStrategyModeResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &SwitchDnsGtmInstanceStrategyModeResponse{}
	_body, _err := SwitchDnsGtmInstanceStrategyModeWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Adds and modifies a tag for a resource.
//
// @param request - TagResourcesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return TagResourcesResponse
func TagResourcesWithOptions(client *Client, request *TagResourcesRequest, runtime *dara.RuntimeOptions) (_result *TagResourcesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.ResourceId) {
		query["ResourceId"] = request.ResourceId
	}

	if !dara.IsNil(request.ResourceType) {
		query["ResourceType"] = request.ResourceType
	}

	if !dara.IsNil(request.Tag) {
		query["Tag"] = request.Tag
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("TagResources"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &TagResourcesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Adds and modifies a tag for a resource.
//
// @param request - TagResourcesRequest
//
// @return TagResourcesResponse
func TagResources(client *Client, request *TagResourcesRequest) (_result *TagResourcesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &TagResourcesResponse{}
	_body, _err := TagResourcesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Transfers multiple domain names from the current account to another account at a time.
//
// @param request - TransferDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return TransferDomainResponse
func TransferDomainWithOptions(client *Client, request *TransferDomainRequest, runtime *dara.RuntimeOptions) (_result *TransferDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainNames) {
		query["DomainNames"] = request.DomainNames
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.TargetUserId) {
		query["TargetUserId"] = request.TargetUserId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("TransferDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &TransferDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Transfers multiple domain names from the current account to another account at a time.
//
// @param request - TransferDomainRequest
//
// @return TransferDomainResponse
func TransferDomain(client *Client, request *TransferDomainRequest) (_result *TransferDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &TransferDomainResponse{}
	_body, _err := TransferDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Unbinds one or more domain names from a paid Alibaba Cloud DNS instance based on the instance ID.
//
// Description:
//
// A paid Alibaba Cloud DNS instance whose ID starts with dns is an instance of the new version. You can call an API operation to bind multiple domain names to the instance. If the upper limit is exceeded, an error message is returned.\\
//
// A paid Alibaba Cloud DNS instance whose ID does not start with dns is an instance of the old version. You can call an API operation to bind only one domain name to the instance. However, if the instance that you want to bind to the desired domain name is already bound to a domain name, you can call this operation to unbind the original domain name from the instance and then bind the desired domain name to the instance.
//
// @param request - UnbindInstanceDomainsRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UnbindInstanceDomainsResponse
func UnbindInstanceDomainsWithOptions(client *Client, request *UnbindInstanceDomainsRequest, runtime *dara.RuntimeOptions) (_result *UnbindInstanceDomainsResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainNames) {
		query["DomainNames"] = request.DomainNames
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UnbindInstanceDomains"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UnbindInstanceDomainsResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Unbinds one or more domain names from a paid Alibaba Cloud DNS instance based on the instance ID.
//
// Description:
//
// A paid Alibaba Cloud DNS instance whose ID starts with dns is an instance of the new version. You can call an API operation to bind multiple domain names to the instance. If the upper limit is exceeded, an error message is returned.\\
//
// A paid Alibaba Cloud DNS instance whose ID does not start with dns is an instance of the old version. You can call an API operation to bind only one domain name to the instance. However, if the instance that you want to bind to the desired domain name is already bound to a domain name, you can call this operation to unbind the original domain name from the instance and then bind the desired domain name to the instance.
//
// @param request - UnbindInstanceDomainsRequest
//
// @return UnbindInstanceDomainsResponse
func UnbindInstanceDomains(client *Client, request *UnbindInstanceDomainsRequest) (_result *UnbindInstanceDomainsResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UnbindInstanceDomainsResponse{}
	_body, _err := UnbindInstanceDomainsWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Removes tags from resources.
//
// @param request - UntagResourcesRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UntagResourcesResponse
func UntagResourcesWithOptions(client *Client, request *UntagResourcesRequest, runtime *dara.RuntimeOptions) (_result *UntagResourcesResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.All) {
		query["All"] = request.All
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.ResourceId) {
		query["ResourceId"] = request.ResourceId
	}

	if !dara.IsNil(request.ResourceType) {
		query["ResourceType"] = request.ResourceType
	}

	if !dara.IsNil(request.TagKey) {
		query["TagKey"] = request.TagKey
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UntagResources"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UntagResourcesResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Removes tags from resources.
//
// @param request - UntagResourcesRequest
//
// @return UntagResourcesResponse
func UntagResources(client *Client, request *UntagResourcesRequest) (_result *UntagResourcesResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UntagResourcesResponse{}
	_body, _err := UntagResourcesWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改 AppKey 状态
//
// @param request - UpdateAppKeyStateRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateAppKeyStateResponse
func UpdateAppKeyStateWithOptions(client *Client, request *UpdateAppKeyStateRequest, runtime *dara.RuntimeOptions) (_result *UpdateAppKeyStateResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AppKeyId) {
		query["AppKeyId"] = request.AppKeyId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.State) {
		query["State"] = request.State
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateAppKeyState"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateAppKeyStateResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改 AppKey 状态
//
// @param request - UpdateAppKeyStateRequest
//
// @return UpdateAppKeyStateResponse
func UpdateAppKeyState(client *Client, request *UpdateAppKeyStateRequest) (_result *UpdateAppKeyStateResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateAppKeyStateResponse{}
	_body, _err := UpdateAppKeyStateWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the condition for determining the health status of a specified address.
//
// @param tmpReq - UpdateCloudGtmAddressRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressResponse
func UpdateCloudGtmAddressWithOptions(client *Client, tmpReq *UpdateCloudGtmAddressRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &UpdateCloudGtmAddressShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.HealthTasks) {
		request.HealthTasksShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.HealthTasks, dara.String("HealthTasks"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.Address) {
		query["Address"] = request.Address
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.AttributeInfo) {
		query["AttributeInfo"] = request.AttributeInfo
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.HealthJudgement) {
		query["HealthJudgement"] = request.HealthJudgement
	}

	if !dara.IsNil(request.HealthTasksShrink) {
		query["HealthTasks"] = request.HealthTasksShrink
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddress"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the condition for determining the health status of a specified address.
//
// @param request - UpdateCloudGtmAddressRequest
//
// @return UpdateCloudGtmAddressResponse
func UpdateCloudGtmAddress(client *Client, request *UpdateCloudGtmAddressRequest) (_result *UpdateCloudGtmAddressResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressResponse{}
	_body, _err := UpdateCloudGtmAddressWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an address.
//
// Description:
//
//	  If an address is **enabled*	- and the health status of the address is **Normal**, the availability status of the address is **Available**.
//
//		- If an address is **disabled*	- or the health status of the address is **Abnormal**, the availability status of the address is **Unavailable**.
//
// @param request - UpdateCloudGtmAddressEnableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressEnableStatusResponse
func UpdateCloudGtmAddressEnableStatusWithOptions(client *Client, request *UpdateCloudGtmAddressEnableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressEnableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressEnableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressEnableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an address.
//
// Description:
//
//	  If an address is **enabled*	- and the health status of the address is **Normal**, the availability status of the address is **Available**.
//
//		- If an address is **disabled*	- or the health status of the address is **Abnormal**, the availability status of the address is **Unavailable**.
//
// @param request - UpdateCloudGtmAddressEnableStatusRequest
//
// @return UpdateCloudGtmAddressEnableStatusResponse
func UpdateCloudGtmAddressEnableStatus(client *Client, request *UpdateCloudGtmAddressEnableStatusRequest) (_result *UpdateCloudGtmAddressEnableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressEnableStatusResponse{}
	_body, _err := UpdateCloudGtmAddressEnableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the failover mode that is used when address exceptions are identified.
//
// @param request - UpdateCloudGtmAddressManualAvailableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressManualAvailableStatusResponse
func UpdateCloudGtmAddressManualAvailableStatusWithOptions(client *Client, request *UpdateCloudGtmAddressManualAvailableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressManualAvailableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.AvailableMode) {
		query["AvailableMode"] = request.AvailableMode
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ManualAvailableStatus) {
		query["ManualAvailableStatus"] = request.ManualAvailableStatus
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressManualAvailableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressManualAvailableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the failover mode that is used when address exceptions are identified.
//
// @param request - UpdateCloudGtmAddressManualAvailableStatusRequest
//
// @return UpdateCloudGtmAddressManualAvailableStatusResponse
func UpdateCloudGtmAddressManualAvailableStatus(client *Client, request *UpdateCloudGtmAddressManualAvailableStatusRequest) (_result *UpdateCloudGtmAddressManualAvailableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressManualAvailableStatusResponse{}
	_body, _err := UpdateCloudGtmAddressManualAvailableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the basic configurations of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolBasicConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressPoolBasicConfigResponse
func UpdateCloudGtmAddressPoolBasicConfigWithOptions(client *Client, request *UpdateCloudGtmAddressPoolBasicConfigRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressPoolBasicConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.AddressPoolName) {
		query["AddressPoolName"] = request.AddressPoolName
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.HealthJudgement) {
		query["HealthJudgement"] = request.HealthJudgement
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressPoolBasicConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressPoolBasicConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the basic configurations of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolBasicConfigRequest
//
// @return UpdateCloudGtmAddressPoolBasicConfigResponse
func UpdateCloudGtmAddressPoolBasicConfig(client *Client, request *UpdateCloudGtmAddressPoolBasicConfigRequest) (_result *UpdateCloudGtmAddressPoolBasicConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressPoolBasicConfigResponse{}
	_body, _err := UpdateCloudGtmAddressPoolBasicConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an address pool.
//
// Description:
//
//	  If an address pool is **enabled*	- and the health status of the address pool is **Normal**, the availability status of the address pool is **Available**.
//
//		- If an address pool is **disabled*	- or the health status of the address pool is **Abnormal**, the availability status of the address pool is **unavailable**.
//
// @param request - UpdateCloudGtmAddressPoolEnableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressPoolEnableStatusResponse
func UpdateCloudGtmAddressPoolEnableStatusWithOptions(client *Client, request *UpdateCloudGtmAddressPoolEnableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressPoolEnableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressPoolEnableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressPoolEnableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an address pool.
//
// Description:
//
//	  If an address pool is **enabled*	- and the health status of the address pool is **Normal**, the availability status of the address pool is **Available**.
//
//		- If an address pool is **disabled*	- or the health status of the address pool is **Abnormal**, the availability status of the address pool is **unavailable**.
//
// @param request - UpdateCloudGtmAddressPoolEnableStatusRequest
//
// @return UpdateCloudGtmAddressPoolEnableStatusResponse
func UpdateCloudGtmAddressPoolEnableStatus(client *Client, request *UpdateCloudGtmAddressPoolEnableStatusRequest) (_result *UpdateCloudGtmAddressPoolEnableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressPoolEnableStatusResponse{}
	_body, _err := UpdateCloudGtmAddressPoolEnableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the load balancing policy of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolLbStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressPoolLbStrategyResponse
func UpdateCloudGtmAddressPoolLbStrategyWithOptions(client *Client, request *UpdateCloudGtmAddressPoolLbStrategyRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressPoolLbStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressLbStrategy) {
		query["AddressLbStrategy"] = request.AddressLbStrategy
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.SequenceLbStrategyMode) {
		query["SequenceLbStrategyMode"] = request.SequenceLbStrategyMode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressPoolLbStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressPoolLbStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the load balancing policy of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolLbStrategyRequest
//
// @return UpdateCloudGtmAddressPoolLbStrategyResponse
func UpdateCloudGtmAddressPoolLbStrategy(client *Client, request *UpdateCloudGtmAddressPoolLbStrategyRequest) (_result *UpdateCloudGtmAddressPoolLbStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressPoolLbStrategyResponse{}
	_body, _err := UpdateCloudGtmAddressPoolLbStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the remarks of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressPoolRemarkResponse
func UpdateCloudGtmAddressPoolRemarkWithOptions(client *Client, request *UpdateCloudGtmAddressPoolRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressPoolRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolId) {
		query["AddressPoolId"] = request.AddressPoolId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressPoolRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressPoolRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the remarks of an address pool.
//
// @param request - UpdateCloudGtmAddressPoolRemarkRequest
//
// @return UpdateCloudGtmAddressPoolRemarkResponse
func UpdateCloudGtmAddressPoolRemark(client *Client, request *UpdateCloudGtmAddressPoolRemarkRequest) (_result *UpdateCloudGtmAddressPoolRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressPoolRemarkResponse{}
	_body, _err := UpdateCloudGtmAddressPoolRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the remarks of an address.
//
// @param request - UpdateCloudGtmAddressRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmAddressRemarkResponse
func UpdateCloudGtmAddressRemarkWithOptions(client *Client, request *UpdateCloudGtmAddressRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmAddressRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressId) {
		query["AddressId"] = request.AddressId
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmAddressRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmAddressRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the remarks of an address.
//
// @param request - UpdateCloudGtmAddressRemarkRequest
//
// @return UpdateCloudGtmAddressRemarkResponse
func UpdateCloudGtmAddressRemark(client *Client, request *UpdateCloudGtmAddressRemarkRequest) (_result *UpdateCloudGtmAddressRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmAddressRemarkResponse{}
	_body, _err := UpdateCloudGtmAddressRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param tmpReq - UpdateCloudGtmGlobalAlertRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmGlobalAlertResponse
func UpdateCloudGtmGlobalAlertWithOptions(client *Client, tmpReq *UpdateCloudGtmGlobalAlertRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmGlobalAlertResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &UpdateCloudGtmGlobalAlertShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.AlertConfig) {
		request.AlertConfigShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.AlertConfig, dara.String("AlertConfig"), dara.String("json"))
	}

	if !dara.IsNil(tmpReq.AlertGroup) {
		request.AlertGroupShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.AlertGroup, dara.String("AlertGroup"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AlertConfigShrink) {
		query["AlertConfig"] = request.AlertConfigShrink
	}

	if !dara.IsNil(request.AlertGroupShrink) {
		query["AlertGroup"] = request.AlertGroupShrink
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmGlobalAlert"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmGlobalAlertResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateCloudGtmGlobalAlertRequest
//
// @return UpdateCloudGtmGlobalAlertResponse
func UpdateCloudGtmGlobalAlert(client *Client, request *UpdateCloudGtmGlobalAlertRequest) (_result *UpdateCloudGtmGlobalAlertResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmGlobalAlertResponse{}
	_body, _err := UpdateCloudGtmGlobalAlertWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param tmpReq - UpdateCloudGtmInstanceConfigAlertRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceConfigAlertResponse
func UpdateCloudGtmInstanceConfigAlertWithOptions(client *Client, tmpReq *UpdateCloudGtmInstanceConfigAlertRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceConfigAlertResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &UpdateCloudGtmInstanceConfigAlertShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.AlertConfig) {
		request.AlertConfigShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.AlertConfig, dara.String("AlertConfig"), dara.String("json"))
	}

	if !dara.IsNil(tmpReq.AlertGroup) {
		request.AlertGroupShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.AlertGroup, dara.String("AlertGroup"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AlertConfigShrink) {
		query["AlertConfig"] = request.AlertConfigShrink
	}

	if !dara.IsNil(request.AlertGroupShrink) {
		query["AlertGroup"] = request.AlertGroupShrink
	}

	if !dara.IsNil(request.AlertMode) {
		query["AlertMode"] = request.AlertMode
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceConfigAlert"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceConfigAlertResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateCloudGtmInstanceConfigAlertRequest
//
// @return UpdateCloudGtmInstanceConfigAlertResponse
func UpdateCloudGtmInstanceConfigAlert(client *Client, request *UpdateCloudGtmInstanceConfigAlertRequest) (_result *UpdateCloudGtmInstanceConfigAlertResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceConfigAlertResponse{}
	_body, _err := UpdateCloudGtmInstanceConfigAlertWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Updates the global time-to-live (TTL) configuration of a GTM 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigBasicRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceConfigBasicResponse
func UpdateCloudGtmInstanceConfigBasicWithOptions(client *Client, request *UpdateCloudGtmInstanceConfigBasicRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceConfigBasicResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.ScheduleHostname) {
		query["ScheduleHostname"] = request.ScheduleHostname
	}

	if !dara.IsNil(request.ScheduleZoneName) {
		query["ScheduleZoneName"] = request.ScheduleZoneName
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceConfigBasic"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceConfigBasicResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Updates the global time-to-live (TTL) configuration of a GTM 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigBasicRequest
//
// @return UpdateCloudGtmInstanceConfigBasicResponse
func UpdateCloudGtmInstanceConfigBasic(client *Client, request *UpdateCloudGtmInstanceConfigBasicRequest) (_result *UpdateCloudGtmInstanceConfigBasicResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceConfigBasicResponse{}
	_body, _err := UpdateCloudGtmInstanceConfigBasicWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an access domain name.
//
// Description:
//
//	  If an access domain name is **enabled*	- and the health state is **normal**, the access domain name is deemed **available**.
//
//		- If an access domain name is **disabled*	- or the health state is **abnormal**, the access domain name is deemed **unavailable**.
//
// @param request - UpdateCloudGtmInstanceConfigEnableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceConfigEnableStatusResponse
func UpdateCloudGtmInstanceConfigEnableStatusWithOptions(client *Client, request *UpdateCloudGtmInstanceConfigEnableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceConfigEnableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceConfigEnableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceConfigEnableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the enabling status of an access domain name.
//
// Description:
//
//	  If an access domain name is **enabled*	- and the health state is **normal**, the access domain name is deemed **available**.
//
//		- If an access domain name is **disabled*	- or the health state is **abnormal**, the access domain name is deemed **unavailable**.
//
// @param request - UpdateCloudGtmInstanceConfigEnableStatusRequest
//
// @return UpdateCloudGtmInstanceConfigEnableStatusResponse
func UpdateCloudGtmInstanceConfigEnableStatus(client *Client, request *UpdateCloudGtmInstanceConfigEnableStatusRequest) (_result *UpdateCloudGtmInstanceConfigEnableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceConfigEnableStatusResponse{}
	_body, _err := UpdateCloudGtmInstanceConfigEnableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the load balancing policy of a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigLbStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceConfigLbStrategyResponse
func UpdateCloudGtmInstanceConfigLbStrategyWithOptions(client *Client, request *UpdateCloudGtmInstanceConfigLbStrategyRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceConfigLbStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.AddressPoolLbStrategy) {
		query["AddressPoolLbStrategy"] = request.AddressPoolLbStrategy
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.SequenceLbStrategyMode) {
		query["SequenceLbStrategyMode"] = request.SequenceLbStrategyMode
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceConfigLbStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceConfigLbStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the load balancing policy of a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigLbStrategyRequest
//
// @return UpdateCloudGtmInstanceConfigLbStrategyResponse
func UpdateCloudGtmInstanceConfigLbStrategy(client *Client, request *UpdateCloudGtmInstanceConfigLbStrategyRequest) (_result *UpdateCloudGtmInstanceConfigLbStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceConfigLbStrategyResponse{}
	_body, _err := UpdateCloudGtmInstanceConfigLbStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the description of a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceConfigRemarkResponse
func UpdateCloudGtmInstanceConfigRemarkWithOptions(client *Client, request *UpdateCloudGtmInstanceConfigRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceConfigRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ConfigId) {
		query["ConfigId"] = request.ConfigId
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceConfigRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceConfigRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the description of a Global Traffic Manager (GTM) 3.0 instance.
//
// @param request - UpdateCloudGtmInstanceConfigRemarkRequest
//
// @return UpdateCloudGtmInstanceConfigRemarkResponse
func UpdateCloudGtmInstanceConfigRemark(client *Client, request *UpdateCloudGtmInstanceConfigRemarkRequest) (_result *UpdateCloudGtmInstanceConfigRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceConfigRemarkResponse{}
	_body, _err := UpdateCloudGtmInstanceConfigRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - UpdateCloudGtmInstanceNameRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmInstanceNameResponse
func UpdateCloudGtmInstanceNameWithOptions(client *Client, request *UpdateCloudGtmInstanceNameRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmInstanceNameResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmInstanceName"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmInstanceNameResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateCloudGtmInstanceNameRequest
//
// @return UpdateCloudGtmInstanceNameResponse
func UpdateCloudGtmInstanceName(client *Client, request *UpdateCloudGtmInstanceNameRequest) (_result *UpdateCloudGtmInstanceNameResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmInstanceNameResponse{}
	_body, _err := UpdateCloudGtmInstanceNameWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the information about a health check template.
//
// @param tmpReq - UpdateCloudGtmMonitorTemplateRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmMonitorTemplateResponse
func UpdateCloudGtmMonitorTemplateWithOptions(client *Client, tmpReq *UpdateCloudGtmMonitorTemplateRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmMonitorTemplateResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &UpdateCloudGtmMonitorTemplateShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.IspCityNodes) {
		request.IspCityNodesShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.IspCityNodes, dara.String("IspCityNodes"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.ExtendInfo) {
		query["ExtendInfo"] = request.ExtendInfo
	}

	if !dara.IsNil(request.FailureRate) {
		query["FailureRate"] = request.FailureRate
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNodesShrink) {
		query["IspCityNodes"] = request.IspCityNodesShrink
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.TemplateId) {
		query["TemplateId"] = request.TemplateId
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmMonitorTemplate"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmMonitorTemplateResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the information about a health check template.
//
// @param request - UpdateCloudGtmMonitorTemplateRequest
//
// @return UpdateCloudGtmMonitorTemplateResponse
func UpdateCloudGtmMonitorTemplate(client *Client, request *UpdateCloudGtmMonitorTemplateRequest) (_result *UpdateCloudGtmMonitorTemplateResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmMonitorTemplateResponse{}
	_body, _err := UpdateCloudGtmMonitorTemplateWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - UpdateCloudGtmMonitorTemplateRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCloudGtmMonitorTemplateRemarkResponse
func UpdateCloudGtmMonitorTemplateRemarkWithOptions(client *Client, request *UpdateCloudGtmMonitorTemplateRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateCloudGtmMonitorTemplateRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AcceptLanguage) {
		query["AcceptLanguage"] = request.AcceptLanguage
	}

	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.TemplateId) {
		query["TemplateId"] = request.TemplateId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCloudGtmMonitorTemplateRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCloudGtmMonitorTemplateRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateCloudGtmMonitorTemplateRemarkRequest
//
// @return UpdateCloudGtmMonitorTemplateRemarkResponse
func UpdateCloudGtmMonitorTemplateRemark(client *Client, request *UpdateCloudGtmMonitorTemplateRemarkRequest) (_result *UpdateCloudGtmMonitorTemplateRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCloudGtmMonitorTemplateRemarkResponse{}
	_body, _err := UpdateCloudGtmMonitorTemplateRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies a custom line with its unique ID.
//
// Description:
//
// In each CIDR block, the end IP address must be greater than or equal to the start IP address.\\
//
// The CIDR blocks that are specified for all custom lines of a domain name cannot be overlapped.
//
// @param request - UpdateCustomLineRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateCustomLineResponse
func UpdateCustomLineWithOptions(client *Client, request *UpdateCustomLineRequest, runtime *dara.RuntimeOptions) (_result *UpdateCustomLineResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.IpSegment) {
		query["IpSegment"] = request.IpSegment
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LineId) {
		query["LineId"] = request.LineId
	}

	if !dara.IsNil(request.LineName) {
		query["LineName"] = request.LineName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateCustomLine"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateCustomLineResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies a custom line with its unique ID.
//
// Description:
//
// In each CIDR block, the end IP address must be greater than or equal to the start IP address.\\
//
// The CIDR blocks that are specified for all custom lines of a domain name cannot be overlapped.
//
// @param request - UpdateCustomLineRequest
//
// @return UpdateCustomLineResponse
func UpdateCustomLine(client *Client, request *UpdateCustomLineRequest) (_result *UpdateCustomLineResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateCustomLineResponse{}
	_body, _err := UpdateCustomLineWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the weight of a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDNSSLBWeightRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDNSSLBWeightResponse
func UpdateDNSSLBWeightWithOptions(client *Client, request *UpdateDNSSLBWeightRequest, runtime *dara.RuntimeOptions) (_result *UpdateDNSSLBWeightResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDNSSLBWeight"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDNSSLBWeightResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the weight of a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDNSSLBWeightRequest
//
// @return UpdateDNSSLBWeightResponse
func UpdateDNSSLBWeight(client *Client, request *UpdateDNSSLBWeightRequest) (_result *UpdateDNSSLBWeightResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDNSSLBWeightResponse{}
	_body, _err := UpdateDNSSLBWeightWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Updates the cache-accelerated domain name based on the specified parameters.
//
// @param request - UpdateDnsCacheDomainRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsCacheDomainResponse
func UpdateDnsCacheDomainWithOptions(client *Client, request *UpdateDnsCacheDomainRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsCacheDomainResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.CacheTtlMax) {
		query["CacheTtlMax"] = request.CacheTtlMax
	}

	if !dara.IsNil(request.CacheTtlMin) {
		query["CacheTtlMin"] = request.CacheTtlMin
	}

	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.SourceDnsServer) {
		query["SourceDnsServer"] = request.SourceDnsServer
	}

	if !dara.IsNil(request.SourceEdns) {
		query["SourceEdns"] = request.SourceEdns
	}

	if !dara.IsNil(request.SourceProtocol) {
		query["SourceProtocol"] = request.SourceProtocol
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsCacheDomain"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsCacheDomainResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Updates the cache-accelerated domain name based on the specified parameters.
//
// @param request - UpdateDnsCacheDomainRequest
//
// @return UpdateDnsCacheDomainResponse
func UpdateDnsCacheDomain(client *Client, request *UpdateDnsCacheDomainRequest) (_result *UpdateDnsCacheDomainResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsCacheDomainResponse{}
	_body, _err := UpdateDnsCacheDomainWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Updates the remarks for the cache-accelerated domain name of the destination domain name.
//
// @param request - UpdateDnsCacheDomainRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsCacheDomainRemarkResponse
func UpdateDnsCacheDomainRemarkWithOptions(client *Client, request *UpdateDnsCacheDomainRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsCacheDomainRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsCacheDomainRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsCacheDomainRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Updates the remarks for the cache-accelerated domain name of the destination domain name.
//
// @param request - UpdateDnsCacheDomainRemarkRequest
//
// @return UpdateDnsCacheDomainRemarkResponse
func UpdateDnsCacheDomainRemark(client *Client, request *UpdateDnsCacheDomainRemarkRequest) (_result *UpdateDnsCacheDomainRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsCacheDomainRemarkResponse{}
	_body, _err := UpdateDnsCacheDomainRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies an access policy.
//
// @param request - UpdateDnsGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsGtmAccessStrategyResponse
func UpdateDnsGtmAccessStrategyWithOptions(client *Client, request *UpdateDnsGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccessMode) {
		query["AccessMode"] = request.AccessMode
	}

	if !dara.IsNil(request.DefaultAddrPool) {
		query["DefaultAddrPool"] = request.DefaultAddrPool
	}

	if !dara.IsNil(request.DefaultAddrPoolType) {
		query["DefaultAddrPoolType"] = request.DefaultAddrPoolType
	}

	if !dara.IsNil(request.DefaultLatencyOptimization) {
		query["DefaultLatencyOptimization"] = request.DefaultLatencyOptimization
	}

	if !dara.IsNil(request.DefaultLbaStrategy) {
		query["DefaultLbaStrategy"] = request.DefaultLbaStrategy
	}

	if !dara.IsNil(request.DefaultMaxReturnAddrNum) {
		query["DefaultMaxReturnAddrNum"] = request.DefaultMaxReturnAddrNum
	}

	if !dara.IsNil(request.DefaultMinAvailableAddrNum) {
		query["DefaultMinAvailableAddrNum"] = request.DefaultMinAvailableAddrNum
	}

	if !dara.IsNil(request.FailoverAddrPool) {
		query["FailoverAddrPool"] = request.FailoverAddrPool
	}

	if !dara.IsNil(request.FailoverAddrPoolType) {
		query["FailoverAddrPoolType"] = request.FailoverAddrPoolType
	}

	if !dara.IsNil(request.FailoverLatencyOptimization) {
		query["FailoverLatencyOptimization"] = request.FailoverLatencyOptimization
	}

	if !dara.IsNil(request.FailoverLbaStrategy) {
		query["FailoverLbaStrategy"] = request.FailoverLbaStrategy
	}

	if !dara.IsNil(request.FailoverMaxReturnAddrNum) {
		query["FailoverMaxReturnAddrNum"] = request.FailoverMaxReturnAddrNum
	}

	if !dara.IsNil(request.FailoverMinAvailableAddrNum) {
		query["FailoverMinAvailableAddrNum"] = request.FailoverMinAvailableAddrNum
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Lines) {
		query["Lines"] = request.Lines
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	if !dara.IsNil(request.StrategyName) {
		query["StrategyName"] = request.StrategyName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies an access policy.
//
// @param request - UpdateDnsGtmAccessStrategyRequest
//
// @return UpdateDnsGtmAccessStrategyResponse
func UpdateDnsGtmAccessStrategy(client *Client, request *UpdateDnsGtmAccessStrategyRequest) (_result *UpdateDnsGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsGtmAccessStrategyResponse{}
	_body, _err := UpdateDnsGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies an address pool.
//
// @param request - UpdateDnsGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsGtmAddressPoolResponse
func UpdateDnsGtmAddressPoolWithOptions(client *Client, request *UpdateDnsGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Addr) {
		query["Addr"] = request.Addr
	}

	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LbaStrategy) {
		query["LbaStrategy"] = request.LbaStrategy
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies an address pool.
//
// @param request - UpdateDnsGtmAddressPoolRequest
//
// @return UpdateDnsGtmAddressPoolResponse
func UpdateDnsGtmAddressPool(client *Client, request *UpdateDnsGtmAddressPoolRequest) (_result *UpdateDnsGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsGtmAddressPoolResponse{}
	_body, _err := UpdateDnsGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the configurations of a Global Traffic Manager (GTM) instance.
//
// @param request - UpdateDnsGtmInstanceGlobalConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsGtmInstanceGlobalConfigResponse
func UpdateDnsGtmInstanceGlobalConfigWithOptions(client *Client, request *UpdateDnsGtmInstanceGlobalConfigRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsGtmInstanceGlobalConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AlertConfig) {
		query["AlertConfig"] = request.AlertConfig
	}

	if !dara.IsNil(request.AlertGroup) {
		query["AlertGroup"] = request.AlertGroup
	}

	if !dara.IsNil(request.CnameType) {
		query["CnameType"] = request.CnameType
	}

	if !dara.IsNil(request.ForceUpdate) {
		query["ForceUpdate"] = request.ForceUpdate
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.PublicCnameMode) {
		query["PublicCnameMode"] = request.PublicCnameMode
	}

	if !dara.IsNil(request.PublicRr) {
		query["PublicRr"] = request.PublicRr
	}

	if !dara.IsNil(request.PublicUserDomainName) {
		query["PublicUserDomainName"] = request.PublicUserDomainName
	}

	if !dara.IsNil(request.PublicZoneName) {
		query["PublicZoneName"] = request.PublicZoneName
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsGtmInstanceGlobalConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsGtmInstanceGlobalConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the configurations of a Global Traffic Manager (GTM) instance.
//
// @param request - UpdateDnsGtmInstanceGlobalConfigRequest
//
// @return UpdateDnsGtmInstanceGlobalConfigResponse
func UpdateDnsGtmInstanceGlobalConfig(client *Client, request *UpdateDnsGtmInstanceGlobalConfigRequest) (_result *UpdateDnsGtmInstanceGlobalConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsGtmInstanceGlobalConfigResponse{}
	_body, _err := UpdateDnsGtmInstanceGlobalConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies a health check task.
//
// @param request - UpdateDnsGtmMonitorRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDnsGtmMonitorResponse
func UpdateDnsGtmMonitorWithOptions(client *Client, request *UpdateDnsGtmMonitorRequest, runtime *dara.RuntimeOptions) (_result *UpdateDnsGtmMonitorResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDnsGtmMonitor"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDnsGtmMonitorResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies a health check task.
//
// @param request - UpdateDnsGtmMonitorRequest
//
// @return UpdateDnsGtmMonitorResponse
func UpdateDnsGtmMonitor(client *Client, request *UpdateDnsGtmMonitorRequest) (_result *UpdateDnsGtmMonitorResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDnsGtmMonitorResponse{}
	_body, _err := UpdateDnsGtmMonitorWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the name of a domain name group based on the specified parameters.
//
// Description:
//
// Modifies the name of an existing domain name group.
//
// @param request - UpdateDomainGroupRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDomainGroupResponse
func UpdateDomainGroupWithOptions(client *Client, request *UpdateDomainGroupRequest, runtime *dara.RuntimeOptions) (_result *UpdateDomainGroupResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.GroupId) {
		query["GroupId"] = request.GroupId
	}

	if !dara.IsNil(request.GroupName) {
		query["GroupName"] = request.GroupName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDomainGroup"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDomainGroupResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the name of a domain name group based on the specified parameters.
//
// Description:
//
// Modifies the name of an existing domain name group.
//
// @param request - UpdateDomainGroupRequest
//
// @return UpdateDomainGroupResponse
func UpdateDomainGroup(client *Client, request *UpdateDomainGroupRequest) (_result *UpdateDomainGroupResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDomainGroupResponse{}
	_body, _err := UpdateDomainGroupWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDomainRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDomainRecordResponse
func UpdateDomainRecordWithOptions(client *Client, request *UpdateDomainRecordRequest, runtime *dara.RuntimeOptions) (_result *UpdateDomainRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Line) {
		query["Line"] = request.Line
	}

	if !dara.IsNil(request.Priority) {
		query["Priority"] = request.Priority
	}

	if !dara.IsNil(request.RR) {
		query["RR"] = request.RR
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.TTL) {
		query["TTL"] = request.TTL
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	if !dara.IsNil(request.Value) {
		query["Value"] = request.Value
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDomainRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDomainRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDomainRecordRequest
//
// @return UpdateDomainRecordResponse
func UpdateDomainRecord(client *Client, request *UpdateDomainRecordRequest) (_result *UpdateDomainRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDomainRecordResponse{}
	_body, _err := UpdateDomainRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the description of a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDomainRecordRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDomainRecordRemarkResponse
func UpdateDomainRecordRemarkWithOptions(client *Client, request *UpdateDomainRecordRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateDomainRecordRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.UserClientIp) {
		query["UserClientIp"] = request.UserClientIp
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDomainRecordRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDomainRecordRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the description of a Domain Name System (DNS) record based on the specified parameters.
//
// @param request - UpdateDomainRecordRemarkRequest
//
// @return UpdateDomainRecordRemarkResponse
func UpdateDomainRecordRemark(client *Client, request *UpdateDomainRecordRemarkRequest) (_result *UpdateDomainRecordRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDomainRecordRemarkResponse{}
	_body, _err := UpdateDomainRecordRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the description of a domain name based on the specified parameters.
//
// @param request - UpdateDomainRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateDomainRemarkResponse
func UpdateDomainRemarkWithOptions(client *Client, request *UpdateDomainRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateDomainRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.DomainName) {
		query["DomainName"] = request.DomainName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateDomainRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateDomainRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the description of a domain name based on the specified parameters.
//
// @param request - UpdateDomainRemarkRequest
//
// @return UpdateDomainRemarkResponse
func UpdateDomainRemark(client *Client, request *UpdateDomainRemarkRequest) (_result *UpdateDomainRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateDomainRemarkResponse{}
	_body, _err := UpdateDomainRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - UpdateGtmAccessStrategyRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateGtmAccessStrategyResponse
func UpdateGtmAccessStrategyWithOptions(client *Client, request *UpdateGtmAccessStrategyRequest, runtime *dara.RuntimeOptions) (_result *UpdateGtmAccessStrategyResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AccessLines) {
		query["AccessLines"] = request.AccessLines
	}

	if !dara.IsNil(request.DefaultAddrPoolId) {
		query["DefaultAddrPoolId"] = request.DefaultAddrPoolId
	}

	if !dara.IsNil(request.FailoverAddrPoolId) {
		query["FailoverAddrPoolId"] = request.FailoverAddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.StrategyId) {
		query["StrategyId"] = request.StrategyId
	}

	if !dara.IsNil(request.StrategyName) {
		query["StrategyName"] = request.StrategyName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateGtmAccessStrategy"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateGtmAccessStrategyResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateGtmAccessStrategyRequest
//
// @return UpdateGtmAccessStrategyResponse
func UpdateGtmAccessStrategy(client *Client, request *UpdateGtmAccessStrategyRequest) (_result *UpdateGtmAccessStrategyResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateGtmAccessStrategyResponse{}
	_body, _err := UpdateGtmAccessStrategyWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// @param request - UpdateGtmAddressPoolRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateGtmAddressPoolResponse
func UpdateGtmAddressPoolWithOptions(client *Client, request *UpdateGtmAddressPoolRequest, runtime *dara.RuntimeOptions) (_result *UpdateGtmAddressPoolResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Addr) {
		query["Addr"] = request.Addr
	}

	if !dara.IsNil(request.AddrPoolId) {
		query["AddrPoolId"] = request.AddrPoolId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MinAvailableAddrNum) {
		query["MinAvailableAddrNum"] = request.MinAvailableAddrNum
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateGtmAddressPool"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateGtmAddressPoolResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// @param request - UpdateGtmAddressPoolRequest
//
// @return UpdateGtmAddressPoolResponse
func UpdateGtmAddressPool(client *Client, request *UpdateGtmAddressPoolRequest) (_result *UpdateGtmAddressPoolResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateGtmAddressPoolResponse{}
	_body, _err := UpdateGtmAddressPoolWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the configurations of a Global Traffic Manager (GTM) instance based on the specified parameters.
//
// @param request - UpdateGtmInstanceGlobalConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateGtmInstanceGlobalConfigResponse
func UpdateGtmInstanceGlobalConfigWithOptions(client *Client, request *UpdateGtmInstanceGlobalConfigRequest, runtime *dara.RuntimeOptions) (_result *UpdateGtmInstanceGlobalConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.AlertGroup) {
		query["AlertGroup"] = request.AlertGroup
	}

	if !dara.IsNil(request.CnameCustomDomainName) {
		query["CnameCustomDomainName"] = request.CnameCustomDomainName
	}

	if !dara.IsNil(request.CnameMode) {
		query["CnameMode"] = request.CnameMode
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.LbaStrategy) {
		query["LbaStrategy"] = request.LbaStrategy
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	if !dara.IsNil(request.UserDomainName) {
		query["UserDomainName"] = request.UserDomainName
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateGtmInstanceGlobalConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateGtmInstanceGlobalConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the configurations of a Global Traffic Manager (GTM) instance based on the specified parameters.
//
// @param request - UpdateGtmInstanceGlobalConfigRequest
//
// @return UpdateGtmInstanceGlobalConfigResponse
func UpdateGtmInstanceGlobalConfig(client *Client, request *UpdateGtmInstanceGlobalConfigRequest) (_result *UpdateGtmInstanceGlobalConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateGtmInstanceGlobalConfigResponse{}
	_body, _err := UpdateGtmInstanceGlobalConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies the health check configuration for an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - UpdateGtmMonitorRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateGtmMonitorResponse
func UpdateGtmMonitorWithOptions(client *Client, request *UpdateGtmMonitorRequest, runtime *dara.RuntimeOptions) (_result *UpdateGtmMonitorResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.EvaluationCount) {
		query["EvaluationCount"] = request.EvaluationCount
	}

	if !dara.IsNil(request.Interval) {
		query["Interval"] = request.Interval
	}

	if !dara.IsNil(request.IspCityNode) {
		query["IspCityNode"] = request.IspCityNode
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.MonitorConfigId) {
		query["MonitorConfigId"] = request.MonitorConfigId
	}

	if !dara.IsNil(request.MonitorExtendInfo) {
		query["MonitorExtendInfo"] = request.MonitorExtendInfo
	}

	if !dara.IsNil(request.ProtocolType) {
		query["ProtocolType"] = request.ProtocolType
	}

	if !dara.IsNil(request.Timeout) {
		query["Timeout"] = request.Timeout
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateGtmMonitor"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateGtmMonitorResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies the health check configuration for an address pool of a Global Traffic Manager (GTM) instance.
//
// @param request - UpdateGtmMonitorRequest
//
// @return UpdateGtmMonitorResponse
func UpdateGtmMonitor(client *Client, request *UpdateGtmMonitorRequest) (_result *UpdateGtmMonitorResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateGtmMonitorResponse{}
	_body, _err := UpdateGtmMonitorWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// Modifies a disaster recovery plan.
//
// @param request - UpdateGtmRecoveryPlanRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateGtmRecoveryPlanResponse
func UpdateGtmRecoveryPlanWithOptions(client *Client, request *UpdateGtmRecoveryPlanRequest, runtime *dara.RuntimeOptions) (_result *UpdateGtmRecoveryPlanResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.FaultAddrPool) {
		query["FaultAddrPool"] = request.FaultAddrPool
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	if !dara.IsNil(request.Name) {
		query["Name"] = request.Name
	}

	if !dara.IsNil(request.RecoveryPlanId) {
		query["RecoveryPlanId"] = request.RecoveryPlanId
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateGtmRecoveryPlan"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateGtmRecoveryPlanResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// Modifies a disaster recovery plan.
//
// @param request - UpdateGtmRecoveryPlanRequest
//
// @return UpdateGtmRecoveryPlanResponse
func UpdateGtmRecoveryPlan(client *Client, request *UpdateGtmRecoveryPlanRequest) (_result *UpdateGtmRecoveryPlanResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateGtmRecoveryPlanResponse{}
	_body, _err := UpdateGtmRecoveryPlanWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改缓存刷新套餐包配置
//
// @param request - UpdateIspFlushCacheInstanceConfigRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateIspFlushCacheInstanceConfigResponse
func UpdateIspFlushCacheInstanceConfigWithOptions(client *Client, request *UpdateIspFlushCacheInstanceConfigRequest, runtime *dara.RuntimeOptions) (_result *UpdateIspFlushCacheInstanceConfigResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.InstanceName) {
		query["InstanceName"] = request.InstanceName
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateIspFlushCacheInstanceConfig"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateIspFlushCacheInstanceConfigResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改缓存刷新套餐包配置
//
// @param request - UpdateIspFlushCacheInstanceConfigRequest
//
// @return UpdateIspFlushCacheInstanceConfigResponse
func UpdateIspFlushCacheInstanceConfig(client *Client, request *UpdateIspFlushCacheInstanceConfigRequest) (_result *UpdateIspFlushCacheInstanceConfigResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateIspFlushCacheInstanceConfigResponse{}
	_body, _err := UpdateIspFlushCacheInstanceConfigWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录
//
// @param request - UpdateRecursionRecordRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionRecordResponse
func UpdateRecursionRecordWithOptions(client *Client, request *UpdateRecursionRecordRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionRecordResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Priority) {
		query["Priority"] = request.Priority
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.RequestSource) {
		query["RequestSource"] = request.RequestSource
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.Ttl) {
		query["Ttl"] = request.Ttl
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.Value) {
		query["Value"] = request.Value
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionRecord"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionRecordResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录
//
// @param request - UpdateRecursionRecordRequest
//
// @return UpdateRecursionRecordResponse
func UpdateRecursionRecord(client *Client, request *UpdateRecursionRecordRequest) (_result *UpdateRecursionRecordResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionRecordResponse{}
	_body, _err := UpdateRecursionRecordWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改内置权威解析记录启用状态
//
// @param request - UpdateRecursionRecordEnableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionRecordEnableStatusResponse
func UpdateRecursionRecordEnableStatusWithOptions(client *Client, request *UpdateRecursionRecordEnableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionRecordEnableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionRecordEnableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionRecordEnableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改内置权威解析记录启用状态
//
// @param request - UpdateRecursionRecordEnableStatusRequest
//
// @return UpdateRecursionRecordEnableStatusResponse
func UpdateRecursionRecordEnableStatus(client *Client, request *UpdateRecursionRecordEnableStatusRequest) (_result *UpdateRecursionRecordEnableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionRecordEnableStatusResponse{}
	_body, _err := UpdateRecursionRecordEnableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录备注
//
// @param request - UpdateRecursionRecordRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionRecordRemarkResponse
func UpdateRecursionRecordRemarkWithOptions(client *Client, request *UpdateRecursionRecordRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionRecordRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionRecordRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionRecordRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录备注
//
// @param request - UpdateRecursionRecordRemarkRequest
//
// @return UpdateRecursionRecordRemarkResponse
func UpdateRecursionRecordRemark(client *Client, request *UpdateRecursionRecordRemarkRequest) (_result *UpdateRecursionRecordRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionRecordRemarkResponse{}
	_body, _err := UpdateRecursionRecordRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录权重
//
// @param request - UpdateRecursionRecordWeightRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionRecordWeightResponse
func UpdateRecursionRecordWeightWithOptions(client *Client, request *UpdateRecursionRecordWeightRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionRecordWeightResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.RecordId) {
		query["RecordId"] = request.RecordId
	}

	if !dara.IsNil(request.Weight) {
		query["Weight"] = request.Weight
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionRecordWeight"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionRecordWeightResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录权重
//
// @param request - UpdateRecursionRecordWeightRequest
//
// @return UpdateRecursionRecordWeightResponse
func UpdateRecursionRecordWeight(client *Client, request *UpdateRecursionRecordWeightRequest) (_result *UpdateRecursionRecordWeightResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionRecordWeightResponse{}
	_body, _err := UpdateRecursionRecordWeightWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录权重算法启用状态
//
// @param request - UpdateRecursionRecordWeightEnableStatusRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionRecordWeightEnableStatusResponse
func UpdateRecursionRecordWeightEnableStatusWithOptions(client *Client, request *UpdateRecursionRecordWeightEnableStatusRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionRecordWeightEnableStatusResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EnableStatus) {
		query["EnableStatus"] = request.EnableStatus
	}

	if !dara.IsNil(request.RequestSource) {
		query["RequestSource"] = request.RequestSource
	}

	if !dara.IsNil(request.Rr) {
		query["Rr"] = request.Rr
	}

	if !dara.IsNil(request.Type) {
		query["Type"] = request.Type
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionRecordWeightEnableStatus"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionRecordWeightEnableStatusResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威解析记录权重算法启用状态
//
// @param request - UpdateRecursionRecordWeightEnableStatusRequest
//
// @return UpdateRecursionRecordWeightEnableStatusResponse
func UpdateRecursionRecordWeightEnableStatus(client *Client, request *UpdateRecursionRecordWeightEnableStatusRequest) (_result *UpdateRecursionRecordWeightEnableStatusResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionRecordWeightEnableStatusResponse{}
	_body, _err := UpdateRecursionRecordWeightEnableStatusWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone生效范围
//
// @param tmpReq - UpdateRecursionZoneEffectiveScopeRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionZoneEffectiveScopeResponse
func UpdateRecursionZoneEffectiveScopeWithOptions(client *Client, tmpReq *UpdateRecursionZoneEffectiveScopeRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionZoneEffectiveScopeResponse, _err error) {
	_err = tmpReq.Validate()
	if _err != nil {
		return _result, _err
	}
	request := &UpdateRecursionZoneEffectiveScopeShrinkRequest{}
	openapiutil.Convert(tmpReq, request)
	if !dara.IsNil(tmpReq.EffectiveScopes) {
		request.EffectiveScopesShrink = openapiutil.ArrayToStringWithSpecifiedStyle(tmpReq.EffectiveScopes, dara.String("EffectiveScopes"), dara.String("json"))
	}

	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.EffectiveScopesShrink) {
		query["EffectiveScopes"] = request.EffectiveScopesShrink
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionZoneEffectiveScope"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionZoneEffectiveScopeResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone生效范围
//
// @param request - UpdateRecursionZoneEffectiveScopeRequest
//
// @return UpdateRecursionZoneEffectiveScopeResponse
func UpdateRecursionZoneEffectiveScope(client *Client, request *UpdateRecursionZoneEffectiveScopeRequest) (_result *UpdateRecursionZoneEffectiveScopeResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionZoneEffectiveScopeResponse{}
	_body, _err := UpdateRecursionZoneEffectiveScopeWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone递归代理模式
//
// @param request - UpdateRecursionZoneProxyPatternRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionZoneProxyPatternResponse
func UpdateRecursionZoneProxyPatternWithOptions(client *Client, request *UpdateRecursionZoneProxyPatternRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionZoneProxyPatternResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.ProxyPattern) {
		query["ProxyPattern"] = request.ProxyPattern
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionZoneProxyPattern"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionZoneProxyPatternResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone递归代理模式
//
// @param request - UpdateRecursionZoneProxyPatternRequest
//
// @return UpdateRecursionZoneProxyPatternResponse
func UpdateRecursionZoneProxyPattern(client *Client, request *UpdateRecursionZoneProxyPatternRequest) (_result *UpdateRecursionZoneProxyPatternResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionZoneProxyPatternResponse{}
	_body, _err := UpdateRecursionZoneProxyPatternWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone备注
//
// @param request - UpdateRecursionZoneRemarkRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return UpdateRecursionZoneRemarkResponse
func UpdateRecursionZoneRemarkWithOptions(client *Client, request *UpdateRecursionZoneRemarkRequest, runtime *dara.RuntimeOptions) (_result *UpdateRecursionZoneRemarkResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.ClientToken) {
		query["ClientToken"] = request.ClientToken
	}

	if !dara.IsNil(request.Remark) {
		query["Remark"] = request.Remark
	}

	if !dara.IsNil(request.ZoneId) {
		query["ZoneId"] = request.ZoneId
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("UpdateRecursionZoneRemark"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &UpdateRecursionZoneRemarkResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 修改递归解析内置权威域名zone备注
//
// @param request - UpdateRecursionZoneRemarkRequest
//
// @return UpdateRecursionZoneRemarkResponse
func UpdateRecursionZoneRemark(client *Client, request *UpdateRecursionZoneRemarkRequest) (_result *UpdateRecursionZoneRemarkResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &UpdateRecursionZoneRemarkResponse{}
	_body, _err := UpdateRecursionZoneRemarkWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 检查实例主机名是否可添加
//
// @param request - ValidateDnsGtmCnameRrCanUseRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ValidateDnsGtmCnameRrCanUseResponse
func ValidateDnsGtmCnameRrCanUseWithOptions(client *Client, request *ValidateDnsGtmCnameRrCanUseRequest, runtime *dara.RuntimeOptions) (_result *ValidateDnsGtmCnameRrCanUseResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.CnameMode) {
		query["CnameMode"] = request.CnameMode
	}

	if !dara.IsNil(request.CnameRr) {
		query["CnameRr"] = request.CnameRr
	}

	if !dara.IsNil(request.CnameType) {
		query["CnameType"] = request.CnameType
	}

	if !dara.IsNil(request.CnameZone) {
		query["CnameZone"] = request.CnameZone
	}

	if !dara.IsNil(request.InstanceId) {
		query["InstanceId"] = request.InstanceId
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ValidateDnsGtmCnameRrCanUse"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ValidateDnsGtmCnameRrCanUseResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 检查实例主机名是否可添加
//
// @param request - ValidateDnsGtmCnameRrCanUseRequest
//
// @return ValidateDnsGtmCnameRrCanUseResponse
func ValidateDnsGtmCnameRrCanUse(client *Client, request *ValidateDnsGtmCnameRrCanUseRequest) (_result *ValidateDnsGtmCnameRrCanUseResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ValidateDnsGtmCnameRrCanUseResponse{}
	_body, _err := ValidateDnsGtmCnameRrCanUseWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}

// Summary:
//
// 验证公共DNS Udp Ip地址段
//
// @param request - ValidatePdnsUdpIpSegmentRequest
//
// @param runtime - runtime options for this request RuntimeOptions
//
// @return ValidatePdnsUdpIpSegmentResponse
func ValidatePdnsUdpIpSegmentWithOptions(client *Client, request *ValidatePdnsUdpIpSegmentRequest, runtime *dara.RuntimeOptions) (_result *ValidatePdnsUdpIpSegmentResponse, _err error) {
	_err = request.Validate()
	if _err != nil {
		return _result, _err
	}
	query := map[string]interface{}{}
	if !dara.IsNil(request.Ip) {
		query["Ip"] = request.Ip
	}

	if !dara.IsNil(request.IpToken) {
		query["IpToken"] = request.IpToken
	}

	if !dara.IsNil(request.Lang) {
		query["Lang"] = request.Lang
	}

	req := &openapiutil.OpenApiRequest{
		Query: openapiutil.Query(query),
	}
	params := &openapiutil.Params{
		Action:      dara.String("ValidatePdnsUdpIpSegment"),
		Version:     dara.String("2015-01-09"),
		Protocol:    dara.String("HTTPS"),
		Pathname:    dara.String("/"),
		Method:      dara.String("POST"),
		AuthType:    dara.String("AK"),
		Style:       dara.String("RPC"),
		ReqBodyType: dara.String("formData"),
		BodyType:    dara.String("json"),
	}
	_result = &ValidatePdnsUdpIpSegmentResponse{}
	_body, _err := client.CallApi(params, req, runtime)
	if _err != nil {
		return _result, _err
	}
	_err = dara.Convert(_body, &_result)
	return _result, _err
}

// Summary:
//
// 验证公共DNS Udp Ip地址段
//
// @param request - ValidatePdnsUdpIpSegmentRequest
//
// @return ValidatePdnsUdpIpSegmentResponse
func ValidatePdnsUdpIpSegment(client *Client, request *ValidatePdnsUdpIpSegmentRequest) (_result *ValidatePdnsUdpIpSegmentResponse, _err error) {
	runtime := &dara.RuntimeOptions{}
	_result = &ValidatePdnsUdpIpSegmentResponse{}
	_body, _err := ValidatePdnsUdpIpSegmentWithOptions(client,request, runtime)
	if _err != nil {
		return _result, _err
	}
	_result = _body
	return _result, _err
}
