// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-transformer'; DO NOT EDIT

package iaas

import (
	"encoding/json"

	"github.com/sacloud/iaas-api-go/mapconv"
	"github.com/sacloud/iaas-api-go/types"
)

func (o *ArchiveOp) transformFindArgs(conditions *FindCondition) (*archiveFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &archiveFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformFindResults(data []byte) (*ArchiveFindResult, error) {
	nakedResponse := &archiveFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ArchiveFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformCreateArgs(param *ArchiveCreateRequest) (*archiveCreateRequestEnvelope, error) {
	if param == nil {
		param = &ArchiveCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Archive,recursive"`
	}{
		Arg0: arg0,
	}

	v := &archiveCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformCreateResults(data []byte) (*archiveCreateResult, error) {
	nakedResponse := &archiveCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformCreateBlankArgs(param *ArchiveCreateBlankRequest) (*archiveCreateBlankRequestEnvelope, error) {
	if param == nil {
		param = &ArchiveCreateBlankRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Archive,recursive"`
	}{
		Arg0: arg0,
	}

	v := &archiveCreateBlankRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformCreateBlankResults(data []byte) (*archiveCreateBlankResult, error) {
	nakedResponse := &archiveCreateBlankResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveCreateBlankResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformReadResults(data []byte) (*archiveReadResult, error) {
	nakedResponse := &archiveReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformUpdateArgs(id types.ID, param *ArchiveUpdateRequest) (*archiveUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ArchiveUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Archive,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &archiveUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformUpdateResults(data []byte) (*archiveUpdateResult, error) {
	nakedResponse := &archiveUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformOpenFTPArgs(id types.ID, openOption *OpenFTPRequest) (*archiveOpenFTPRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if openOption == nil {
		openOption = &OpenFTPRequest{}
	}
	var arg1 interface{} = openOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &archiveOpenFTPRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformOpenFTPResults(data []byte) (*archiveOpenFTPResult, error) {
	nakedResponse := &archiveOpenFTPResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveOpenFTPResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformShareArgs(id types.ID) (*archiveShareRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
	}{
		Arg0: arg0,
	}

	v := &archiveShareRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformShareResults(data []byte) (*archiveShareResult, error) {
	nakedResponse := &archiveShareResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveShareResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformCreateFromSharedArgs(sourceArchiveID types.ID, destZoneID types.ID, param *ArchiveCreateRequestFromShared) (*archiveCreateFromSharedRequestEnvelope, error) {
	if sourceArchiveID == types.ID(int64(0)) {
		sourceArchiveID = types.ID(int64(0))
	}
	var arg0 interface{} = sourceArchiveID
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if destZoneID == types.ID(int64(0)) {
		destZoneID = types.ID(int64(0))
	}
	var arg1 interface{} = destZoneID
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if param == nil {
		param = &ArchiveCreateRequestFromShared{}
	}
	var arg2 interface{} = param
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:"Archive,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &archiveCreateFromSharedRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformCreateFromSharedResults(data []byte) (*archiveCreateFromSharedResult, error) {
	nakedResponse := &archiveCreateFromSharedResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveCreateFromSharedResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ArchiveOp) transformTransferArgs(sourceArchiveID types.ID, destZoneID types.ID, param *ArchiveTransferRequest) (*archiveTransferRequestEnvelope, error) {
	if sourceArchiveID == types.ID(int64(0)) {
		sourceArchiveID = types.ID(int64(0))
	}
	var arg0 interface{} = sourceArchiveID
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if destZoneID == types.ID(int64(0)) {
		destZoneID = types.ID(int64(0))
	}
	var arg1 interface{} = destZoneID
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if param == nil {
		param = &ArchiveTransferRequest{}
	}
	var arg2 interface{} = param
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:"Archive,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &archiveTransferRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ArchiveOp) transformTransferResults(data []byte) (*archiveTransferResult, error) {
	nakedResponse := &archiveTransferResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &archiveTransferResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AuthStatusOp) transformReadResults(data []byte) (*authStatusReadResult, error) {
	nakedResponse := &authStatusReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &authStatusReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoBackupOp) transformFindArgs(conditions *FindCondition) (*autoBackupFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &autoBackupFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoBackupOp) transformFindResults(data []byte) (*AutoBackupFindResult, error) {
	nakedResponse := &autoBackupFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &AutoBackupFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoBackupOp) transformCreateArgs(param *AutoBackupCreateRequest) (*autoBackupCreateRequestEnvelope, error) {
	if param == nil {
		param = &AutoBackupCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &autoBackupCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoBackupOp) transformCreateResults(data []byte) (*autoBackupCreateResult, error) {
	nakedResponse := &autoBackupCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoBackupCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoBackupOp) transformReadResults(data []byte) (*autoBackupReadResult, error) {
	nakedResponse := &autoBackupReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoBackupReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoBackupOp) transformUpdateArgs(id types.ID, param *AutoBackupUpdateRequest) (*autoBackupUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &AutoBackupUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &autoBackupUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoBackupOp) transformUpdateResults(data []byte) (*autoBackupUpdateResult, error) {
	nakedResponse := &autoBackupUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoBackupUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoBackupOp) transformUpdateSettingsArgs(id types.ID, param *AutoBackupUpdateSettingsRequest) (*autoBackupUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &AutoBackupUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &autoBackupUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoBackupOp) transformUpdateSettingsResults(data []byte) (*autoBackupUpdateSettingsResult, error) {
	nakedResponse := &autoBackupUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoBackupUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformFindArgs(conditions *FindCondition) (*autoScaleFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &autoScaleFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoScaleOp) transformFindResults(data []byte) (*AutoScaleFindResult, error) {
	nakedResponse := &autoScaleFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &AutoScaleFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformCreateArgs(param *AutoScaleCreateRequest) (*autoScaleCreateRequestEnvelope, error) {
	if param == nil {
		param = &AutoScaleCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &autoScaleCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoScaleOp) transformCreateResults(data []byte) (*autoScaleCreateResult, error) {
	nakedResponse := &autoScaleCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoScaleCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformReadResults(data []byte) (*autoScaleReadResult, error) {
	nakedResponse := &autoScaleReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoScaleReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformUpdateArgs(id types.ID, param *AutoScaleUpdateRequest) (*autoScaleUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &AutoScaleUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &autoScaleUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoScaleOp) transformUpdateResults(data []byte) (*autoScaleUpdateResult, error) {
	nakedResponse := &autoScaleUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoScaleUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformUpdateSettingsArgs(id types.ID, param *AutoScaleUpdateSettingsRequest) (*autoScaleUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &AutoScaleUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &autoScaleUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *AutoScaleOp) transformUpdateSettingsResults(data []byte) (*autoScaleUpdateSettingsResult, error) {
	nakedResponse := &autoScaleUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoScaleUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *AutoScaleOp) transformStatusResults(data []byte) (*autoScaleStatusResult, error) {
	nakedResponse := &autoScaleStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &autoScaleStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformByContractResults(data []byte) (*BillByContractResult, error) {
	nakedResponse := &billByContractResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BillByContractResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformByContractYearResults(data []byte) (*BillByContractYearResult, error) {
	nakedResponse := &billByContractYearResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BillByContractYearResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformByContractYearMonthResults(data []byte) (*BillByContractYearMonthResult, error) {
	nakedResponse := &billByContractYearMonthResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BillByContractYearMonthResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformReadResults(data []byte) (*BillReadResult, error) {
	nakedResponse := &billReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BillReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformDetailsResults(data []byte) (*BillDetailsResult, error) {
	nakedResponse := &billDetailsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BillDetailsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BillOp) transformDetailsCSVResults(data []byte) (*billDetailsCSVResult, error) {
	nakedResponse := &billDetailsCSVResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &billDetailsCSVResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BridgeOp) transformFindArgs(conditions *FindCondition) (*bridgeFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &bridgeFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *BridgeOp) transformFindResults(data []byte) (*BridgeFindResult, error) {
	nakedResponse := &bridgeFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &BridgeFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BridgeOp) transformCreateArgs(param *BridgeCreateRequest) (*bridgeCreateRequestEnvelope, error) {
	if param == nil {
		param = &BridgeCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Bridge,recursive"`
	}{
		Arg0: arg0,
	}

	v := &bridgeCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *BridgeOp) transformCreateResults(data []byte) (*bridgeCreateResult, error) {
	nakedResponse := &bridgeCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &bridgeCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BridgeOp) transformReadResults(data []byte) (*bridgeReadResult, error) {
	nakedResponse := &bridgeReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &bridgeReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *BridgeOp) transformUpdateArgs(id types.ID, param *BridgeUpdateRequest) (*bridgeUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &BridgeUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Bridge,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &bridgeUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *BridgeOp) transformUpdateResults(data []byte) (*bridgeUpdateResult, error) {
	nakedResponse := &bridgeUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &bridgeUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CDROMOp) transformFindArgs(conditions *FindCondition) (*cDROMFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &cDROMFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CDROMOp) transformFindResults(data []byte) (*CDROMFindResult, error) {
	nakedResponse := &cDROMFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &CDROMFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CDROMOp) transformCreateArgs(param *CDROMCreateRequest) (*cDROMCreateRequestEnvelope, error) {
	if param == nil {
		param = &CDROMCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CDROM,recursive"`
	}{
		Arg0: arg0,
	}

	v := &cDROMCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CDROMOp) transformCreateResults(data []byte) (*cDROMCreateResult, error) {
	nakedResponse := &cDROMCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &cDROMCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CDROMOp) transformReadResults(data []byte) (*cDROMReadResult, error) {
	nakedResponse := &cDROMReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &cDROMReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CDROMOp) transformUpdateArgs(id types.ID, param *CDROMUpdateRequest) (*cDROMUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &CDROMUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CDROM,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &cDROMUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CDROMOp) transformUpdateResults(data []byte) (*cDROMUpdateResult, error) {
	nakedResponse := &cDROMUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &cDROMUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CDROMOp) transformOpenFTPArgs(id types.ID, openOption *OpenFTPRequest) (*cDROMOpenFTPRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if openOption == nil {
		openOption = &OpenFTPRequest{}
	}
	var arg1 interface{} = openOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &cDROMOpenFTPRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CDROMOp) transformOpenFTPResults(data []byte) (*cDROMOpenFTPResult, error) {
	nakedResponse := &cDROMOpenFTPResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &cDROMOpenFTPResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformFindArgs(conditions *FindCondition) (*certificateAuthorityFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &certificateAuthorityFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CertificateAuthorityOp) transformFindResults(data []byte) (*CertificateAuthorityFindResult, error) {
	nakedResponse := &certificateAuthorityFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &CertificateAuthorityFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformCreateArgs(param *CertificateAuthorityCreateRequest) (*certificateAuthorityCreateRequestEnvelope, error) {
	if param == nil {
		param = &CertificateAuthorityCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &certificateAuthorityCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CertificateAuthorityOp) transformCreateResults(data []byte) (*certificateAuthorityCreateResult, error) {
	nakedResponse := &certificateAuthorityCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformReadResults(data []byte) (*certificateAuthorityReadResult, error) {
	nakedResponse := &certificateAuthorityReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformUpdateArgs(id types.ID, param *CertificateAuthorityUpdateRequest) (*certificateAuthorityUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &CertificateAuthorityUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &certificateAuthorityUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CertificateAuthorityOp) transformUpdateResults(data []byte) (*certificateAuthorityUpdateResult, error) {
	nakedResponse := &certificateAuthorityUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformDetailResults(data []byte) (*certificateAuthorityDetailResult, error) {
	nakedResponse := &certificateAuthorityDetailResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityDetailResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformAddClientArgs(id types.ID, param *CertificateAuthorityAddClientParam) (*certificateAuthorityAddClientRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &CertificateAuthorityAddClientParam{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CertificateAuthority.Status,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &certificateAuthorityAddClientRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CertificateAuthorityOp) transformAddClientResults(data []byte) (*certificateAuthorityAddClientResult, error) {
	nakedResponse := &certificateAuthorityAddClientResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityAddClientResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformListClientsResults(data []byte) (*CertificateAuthorityListClientsResult, error) {
	nakedResponse := &certificateAuthorityListClientsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &CertificateAuthorityListClientsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformReadClientResults(data []byte) (*certificateAuthorityReadClientResult, error) {
	nakedResponse := &certificateAuthorityReadClientResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityReadClientResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformAddServerArgs(id types.ID, param *CertificateAuthorityAddServerParam) (*certificateAuthorityAddServerRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &CertificateAuthorityAddServerParam{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CertificateAuthority.Status,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &certificateAuthorityAddServerRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CertificateAuthorityOp) transformAddServerResults(data []byte) (*certificateAuthorityAddServerResult, error) {
	nakedResponse := &certificateAuthorityAddServerResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityAddServerResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformListServersResults(data []byte) (*CertificateAuthorityListServersResult, error) {
	nakedResponse := &certificateAuthorityListServersResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &CertificateAuthorityListServersResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *CertificateAuthorityOp) transformReadServerResults(data []byte) (*certificateAuthorityReadServerResult, error) {
	nakedResponse := &certificateAuthorityReadServerResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &certificateAuthorityReadServerResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformFindArgs(conditions *FindCondition) (*containerRegistryFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &containerRegistryFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ContainerRegistryOp) transformFindResults(data []byte) (*ContainerRegistryFindResult, error) {
	nakedResponse := &containerRegistryFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ContainerRegistryFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformCreateArgs(param *ContainerRegistryCreateRequest) (*containerRegistryCreateRequestEnvelope, error) {
	if param == nil {
		param = &ContainerRegistryCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &containerRegistryCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ContainerRegistryOp) transformCreateResults(data []byte) (*containerRegistryCreateResult, error) {
	nakedResponse := &containerRegistryCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &containerRegistryCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformReadResults(data []byte) (*containerRegistryReadResult, error) {
	nakedResponse := &containerRegistryReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &containerRegistryReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformUpdateArgs(id types.ID, param *ContainerRegistryUpdateRequest) (*containerRegistryUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ContainerRegistryUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &containerRegistryUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ContainerRegistryOp) transformUpdateResults(data []byte) (*containerRegistryUpdateResult, error) {
	nakedResponse := &containerRegistryUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &containerRegistryUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformUpdateSettingsArgs(id types.ID, param *ContainerRegistryUpdateSettingsRequest) (*containerRegistryUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ContainerRegistryUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &containerRegistryUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ContainerRegistryOp) transformUpdateSettingsResults(data []byte) (*containerRegistryUpdateSettingsResult, error) {
	nakedResponse := &containerRegistryUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &containerRegistryUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformListUsersResults(data []byte) (*containerRegistryListUsersResult, error) {
	nakedResponse := &containerRegistryListUsersResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &containerRegistryListUsersResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ContainerRegistryOp) transformAddUserArgs(id types.ID, param *ContainerRegistryUserCreateRequest) (*containerRegistryAddUserRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ContainerRegistryUserCreateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"ContainerRegistry,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &containerRegistryAddUserRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ContainerRegistryOp) transformUpdateUserArgs(id types.ID, username string, param *ContainerRegistryUserUpdateRequest) (*containerRegistryUpdateUserRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if username == "" {
		username = ""
	}
	var arg1 interface{} = username
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if param == nil {
		param = &ContainerRegistryUserUpdateRequest{}
	}
	var arg2 interface{} = param
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:"ContainerRegistry,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &containerRegistryUpdateUserRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *CouponOp) transformFindResults(data []byte) (*CouponFindResult, error) {
	nakedResponse := &couponFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &CouponFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformFindArgs(conditions *FindCondition) (*databaseFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &databaseFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformFindResults(data []byte) (*DatabaseFindResult, error) {
	nakedResponse := &databaseFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &DatabaseFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformCreateArgs(param *DatabaseCreateRequest) (*databaseCreateRequestEnvelope, error) {
	if param == nil {
		param = &DatabaseCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
	}

	v := &databaseCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformCreateResults(data []byte) (*databaseCreateResult, error) {
	nakedResponse := &databaseCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformReadResults(data []byte) (*databaseReadResult, error) {
	nakedResponse := &databaseReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformUpdateArgs(id types.ID, param *DatabaseUpdateRequest) (*databaseUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DatabaseUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformUpdateResults(data []byte) (*databaseUpdateResult, error) {
	nakedResponse := &databaseUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformUpdateSettingsArgs(id types.ID, param *DatabaseUpdateSettingsRequest) (*databaseUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DatabaseUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformUpdateSettingsResults(data []byte) (*databaseUpdateSettingsResult, error) {
	nakedResponse := &databaseUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*databaseShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformMonitorCPUArgs(id types.ID, condition *MonitorCondition) (*databaseMonitorCPURequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseMonitorCPURequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformMonitorCPUResults(data []byte) (*databaseMonitorCPUResult, error) {
	nakedResponse := &databaseMonitorCPUResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseMonitorCPUResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformMonitorDiskArgs(id types.ID, condition *MonitorCondition) (*databaseMonitorDiskRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseMonitorDiskRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformMonitorDiskResults(data []byte) (*databaseMonitorDiskResult, error) {
	nakedResponse := &databaseMonitorDiskResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseMonitorDiskResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformMonitorInterfaceArgs(id types.ID, condition *MonitorCondition) (*databaseMonitorInterfaceRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseMonitorInterfaceRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformMonitorInterfaceResults(data []byte) (*databaseMonitorInterfaceResult, error) {
	nakedResponse := &databaseMonitorInterfaceResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseMonitorInterfaceResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformMonitorDatabaseArgs(id types.ID, condition *MonitorCondition) (*databaseMonitorDatabaseRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseMonitorDatabaseRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DatabaseOp) transformMonitorDatabaseResults(data []byte) (*databaseMonitorDatabaseResult, error) {
	nakedResponse := &databaseMonitorDatabaseResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseMonitorDatabaseResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformStatusResults(data []byte) (*databaseStatusResult, error) {
	nakedResponse := &databaseStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformGetParameterResults(data []byte) (*databaseGetParameterResult, error) {
	nakedResponse := &databaseGetParameterResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &databaseGetParameterResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DatabaseOp) transformSetParameterArgs(id types.ID, param map[string]interface{}) (*databaseSetParameterRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = map[string]interface{}{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Parameter.Attr"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &databaseSetParameterRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformFindArgs(conditions *FindCondition) (*diskFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &diskFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformFindResults(data []byte) (*DiskFindResult, error) {
	nakedResponse := &diskFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &DiskFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformCreateArgs(createParam *DiskCreateRequest, distantFrom []types.ID) (*diskCreateRequestEnvelope, error) {
	if createParam == nil {
		createParam = &DiskCreateRequest{}
	}
	var arg0 interface{} = createParam
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if distantFrom == nil {
		distantFrom = []types.ID{}
	}
	var arg1 interface{} = distantFrom
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Disk,recursive"`
		Arg1 interface{} `mapconv:"DistantFrom"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformCreateResults(data []byte) (*diskCreateResult, error) {
	nakedResponse := &diskCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformConfigArgs(id types.ID, edit *DiskEditRequest) (*diskConfigRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if edit == nil {
		edit = &DiskEditRequest{}
	}
	var arg1 interface{} = edit
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskConfigRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformCreateWithConfigArgs(createParam *DiskCreateRequest, editParam *DiskEditRequest, bootAtAvailable bool, distantFrom []types.ID) (*diskCreateWithConfigRequestEnvelope, error) {
	if createParam == nil {
		createParam = &DiskCreateRequest{}
	}
	var arg0 interface{} = createParam
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if editParam == nil {
		editParam = &DiskEditRequest{}
	}
	var arg1 interface{} = editParam
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if bootAtAvailable == false {
		bootAtAvailable = false
	}
	var arg2 interface{} = bootAtAvailable
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	if distantFrom == nil {
		distantFrom = []types.ID{}
	}
	var arg3 interface{} = distantFrom
	if v, ok := arg3.(argumentDefaulter); ok {
		arg3 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Disk,recursive"`
		Arg1 interface{} `mapconv:"Config,recursive"`
		Arg2 interface{} `mapconv:"BootAtAvailable"`
		Arg3 interface{} `mapconv:"DistantFrom"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
		Arg3: arg3,
	}

	v := &diskCreateWithConfigRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformCreateWithConfigResults(data []byte) (*diskCreateWithConfigResult, error) {
	nakedResponse := &diskCreateWithConfigResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskCreateWithConfigResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformResizePartitionArgs(id types.ID, param *DiskResizePartitionRequest) (*diskResizePartitionRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DiskResizePartitionRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskResizePartitionRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformReadResults(data []byte) (*diskReadResult, error) {
	nakedResponse := &diskReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformUpdateArgs(id types.ID, param *DiskUpdateRequest) (*diskUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DiskUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Disk,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformUpdateResults(data []byte) (*diskUpdateResult, error) {
	nakedResponse := &diskUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformMonitorArgs(id types.ID, condition *MonitorCondition) (*diskMonitorRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskMonitorRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformMonitorResults(data []byte) (*diskMonitorResult, error) {
	nakedResponse := &diskMonitorResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskMonitorResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskOp) transformMonitorDiskArgs(id types.ID, condition *MonitorCondition) (*diskMonitorDiskRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &diskMonitorDiskRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskOp) transformMonitorDiskResults(data []byte) (*diskMonitorDiskResult, error) {
	nakedResponse := &diskMonitorDiskResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskMonitorDiskResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskPlanOp) transformFindArgs(conditions *FindCondition) (*diskPlanFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &diskPlanFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DiskPlanOp) transformFindResults(data []byte) (*DiskPlanFindResult, error) {
	nakedResponse := &diskPlanFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &DiskPlanFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DiskPlanOp) transformReadResults(data []byte) (*diskPlanReadResult, error) {
	nakedResponse := &diskPlanReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &diskPlanReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DNSOp) transformFindArgs(conditions *FindCondition) (*dNSFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &dNSFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DNSOp) transformFindResults(data []byte) (*DNSFindResult, error) {
	nakedResponse := &dNSFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &DNSFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DNSOp) transformCreateArgs(param *DNSCreateRequest) (*dNSCreateRequestEnvelope, error) {
	if param == nil {
		param = &DNSCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &dNSCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DNSOp) transformCreateResults(data []byte) (*dNSCreateResult, error) {
	nakedResponse := &dNSCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &dNSCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DNSOp) transformReadResults(data []byte) (*dNSReadResult, error) {
	nakedResponse := &dNSReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &dNSReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DNSOp) transformUpdateArgs(id types.ID, param *DNSUpdateRequest) (*dNSUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DNSUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &dNSUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DNSOp) transformUpdateResults(data []byte) (*dNSUpdateResult, error) {
	nakedResponse := &dNSUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &dNSUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *DNSOp) transformUpdateSettingsArgs(id types.ID, param *DNSUpdateSettingsRequest) (*dNSUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &DNSUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &dNSUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *DNSOp) transformUpdateSettingsResults(data []byte) (*dNSUpdateSettingsResult, error) {
	nakedResponse := &dNSUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &dNSUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformFindArgs(conditions *FindCondition) (*enhancedDBFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &enhancedDBFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *EnhancedDBOp) transformFindResults(data []byte) (*EnhancedDBFindResult, error) {
	nakedResponse := &enhancedDBFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &EnhancedDBFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformCreateArgs(param *EnhancedDBCreateRequest) (*enhancedDBCreateRequestEnvelope, error) {
	if param == nil {
		param = &EnhancedDBCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &enhancedDBCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *EnhancedDBOp) transformCreateResults(data []byte) (*enhancedDBCreateResult, error) {
	nakedResponse := &enhancedDBCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &enhancedDBCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformReadResults(data []byte) (*enhancedDBReadResult, error) {
	nakedResponse := &enhancedDBReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &enhancedDBReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformUpdateArgs(id types.ID, param *EnhancedDBUpdateRequest) (*enhancedDBUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &EnhancedDBUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &enhancedDBUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *EnhancedDBOp) transformUpdateResults(data []byte) (*enhancedDBUpdateResult, error) {
	nakedResponse := &enhancedDBUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &enhancedDBUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformSetPasswordArgs(id types.ID, param *EnhancedDBSetPasswordRequest) (*enhancedDBSetPasswordRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &EnhancedDBSetPasswordRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &enhancedDBSetPasswordRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *EnhancedDBOp) transformGetConfigResults(data []byte) (*enhancedDBGetConfigResult, error) {
	nakedResponse := &enhancedDBGetConfigResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &enhancedDBGetConfigResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *EnhancedDBOp) transformSetConfigArgs(id types.ID, param *EnhancedDBSetConfigRequest) (*enhancedDBSetConfigRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &EnhancedDBSetConfigRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &enhancedDBSetConfigRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformFindArgs(conditions *FindCondition) (*eSMEFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &eSMEFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformFindResults(data []byte) (*ESMEFindResult, error) {
	nakedResponse := &eSMEFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ESMEFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformCreateArgs(param *ESMECreateRequest) (*eSMECreateRequestEnvelope, error) {
	if param == nil {
		param = &ESMECreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &eSMECreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformCreateResults(data []byte) (*eSMECreateResult, error) {
	nakedResponse := &eSMECreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMECreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformReadResults(data []byte) (*eSMEReadResult, error) {
	nakedResponse := &eSMEReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMEReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformUpdateArgs(id types.ID, param *ESMEUpdateRequest) (*eSMEUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ESMEUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &eSMEUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformUpdateResults(data []byte) (*eSMEUpdateResult, error) {
	nakedResponse := &eSMEUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMEUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformSendMessageWithGeneratedOTPArgs(id types.ID, param *ESMESendMessageWithGeneratedOTPRequest) (*eSMESendMessageWithGeneratedOTPRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ESMESendMessageWithGeneratedOTPRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"ESME,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &eSMESendMessageWithGeneratedOTPRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformSendMessageWithGeneratedOTPResults(data []byte) (*eSMESendMessageWithGeneratedOTPResult, error) {
	nakedResponse := &eSMESendMessageWithGeneratedOTPResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMESendMessageWithGeneratedOTPResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformSendMessageWithInputtedOTPArgs(id types.ID, param *ESMESendMessageWithInputtedOTPRequest) (*eSMESendMessageWithInputtedOTPRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ESMESendMessageWithInputtedOTPRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"ESME,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &eSMESendMessageWithInputtedOTPRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ESMEOp) transformSendMessageWithInputtedOTPResults(data []byte) (*eSMESendMessageWithInputtedOTPResult, error) {
	nakedResponse := &eSMESendMessageWithInputtedOTPResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMESendMessageWithInputtedOTPResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ESMEOp) transformLogsResults(data []byte) (*eSMELogsResult, error) {
	nakedResponse := &eSMELogsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &eSMELogsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *GSLBOp) transformFindArgs(conditions *FindCondition) (*gSLBFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &gSLBFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *GSLBOp) transformFindResults(data []byte) (*GSLBFindResult, error) {
	nakedResponse := &gSLBFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &GSLBFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *GSLBOp) transformCreateArgs(param *GSLBCreateRequest) (*gSLBCreateRequestEnvelope, error) {
	if param == nil {
		param = &GSLBCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &gSLBCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *GSLBOp) transformCreateResults(data []byte) (*gSLBCreateResult, error) {
	nakedResponse := &gSLBCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &gSLBCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *GSLBOp) transformReadResults(data []byte) (*gSLBReadResult, error) {
	nakedResponse := &gSLBReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &gSLBReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *GSLBOp) transformUpdateArgs(id types.ID, param *GSLBUpdateRequest) (*gSLBUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &GSLBUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &gSLBUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *GSLBOp) transformUpdateResults(data []byte) (*gSLBUpdateResult, error) {
	nakedResponse := &gSLBUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &gSLBUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *GSLBOp) transformUpdateSettingsArgs(id types.ID, param *GSLBUpdateSettingsRequest) (*gSLBUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &GSLBUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &gSLBUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *GSLBOp) transformUpdateSettingsResults(data []byte) (*gSLBUpdateSettingsResult, error) {
	nakedResponse := &gSLBUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &gSLBUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IconOp) transformFindArgs(conditions *FindCondition) (*iconFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &iconFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IconOp) transformFindResults(data []byte) (*IconFindResult, error) {
	nakedResponse := &iconFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &IconFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IconOp) transformCreateArgs(param *IconCreateRequest) (*iconCreateRequestEnvelope, error) {
	if param == nil {
		param = &IconCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Icon,recursive"`
	}{
		Arg0: arg0,
	}

	v := &iconCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IconOp) transformCreateResults(data []byte) (*iconCreateResult, error) {
	nakedResponse := &iconCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iconCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IconOp) transformReadResults(data []byte) (*iconReadResult, error) {
	nakedResponse := &iconReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iconReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IconOp) transformUpdateArgs(id types.ID, param *IconUpdateRequest) (*iconUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &IconUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Icon,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &iconUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IconOp) transformUpdateResults(data []byte) (*iconUpdateResult, error) {
	nakedResponse := &iconUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iconUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InterfaceOp) transformFindArgs(conditions *FindCondition) (*interfaceFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &interfaceFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InterfaceOp) transformFindResults(data []byte) (*InterfaceFindResult, error) {
	nakedResponse := &interfaceFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &InterfaceFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InterfaceOp) transformCreateArgs(param *InterfaceCreateRequest) (*interfaceCreateRequestEnvelope, error) {
	if param == nil {
		param = &InterfaceCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Interface,recursive"`
	}{
		Arg0: arg0,
	}

	v := &interfaceCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InterfaceOp) transformCreateResults(data []byte) (*interfaceCreateResult, error) {
	nakedResponse := &interfaceCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &interfaceCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InterfaceOp) transformReadResults(data []byte) (*interfaceReadResult, error) {
	nakedResponse := &interfaceReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &interfaceReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InterfaceOp) transformUpdateArgs(id types.ID, param *InterfaceUpdateRequest) (*interfaceUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &InterfaceUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Interface,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &interfaceUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InterfaceOp) transformUpdateResults(data []byte) (*interfaceUpdateResult, error) {
	nakedResponse := &interfaceUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &interfaceUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InterfaceOp) transformMonitorArgs(id types.ID, condition *MonitorCondition) (*interfaceMonitorRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &interfaceMonitorRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InterfaceOp) transformMonitorResults(data []byte) (*interfaceMonitorResult, error) {
	nakedResponse := &interfaceMonitorResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &interfaceMonitorResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformFindArgs(conditions *FindCondition) (*internetFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &internetFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformFindResults(data []byte) (*InternetFindResult, error) {
	nakedResponse := &internetFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &InternetFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformCreateArgs(param *InternetCreateRequest) (*internetCreateRequestEnvelope, error) {
	if param == nil {
		param = &InternetCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Internet,recursive"`
	}{
		Arg0: arg0,
	}

	v := &internetCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformCreateResults(data []byte) (*internetCreateResult, error) {
	nakedResponse := &internetCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformReadResults(data []byte) (*internetReadResult, error) {
	nakedResponse := &internetReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformUpdateArgs(id types.ID, param *InternetUpdateRequest) (*internetUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &InternetUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Internet,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &internetUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformUpdateResults(data []byte) (*internetUpdateResult, error) {
	nakedResponse := &internetUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformUpdateBandWidthArgs(id types.ID, param *InternetUpdateBandWidthRequest) (*internetUpdateBandWidthRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &InternetUpdateBandWidthRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Internet,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &internetUpdateBandWidthRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformUpdateBandWidthResults(data []byte) (*internetUpdateBandWidthResult, error) {
	nakedResponse := &internetUpdateBandWidthResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetUpdateBandWidthResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformAddSubnetArgs(id types.ID, param *InternetAddSubnetRequest) (*internetAddSubnetRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &InternetAddSubnetRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &internetAddSubnetRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformAddSubnetResults(data []byte) (*internetAddSubnetResult, error) {
	nakedResponse := &internetAddSubnetResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetAddSubnetResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformUpdateSubnetArgs(id types.ID, subnetID types.ID, param *InternetUpdateSubnetRequest) (*internetUpdateSubnetRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if subnetID == types.ID(int64(0)) {
		subnetID = types.ID(int64(0))
	}
	var arg1 interface{} = subnetID
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if param == nil {
		param = &InternetUpdateSubnetRequest{}
	}
	var arg2 interface{} = param
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &internetUpdateSubnetRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformUpdateSubnetResults(data []byte) (*internetUpdateSubnetResult, error) {
	nakedResponse := &internetUpdateSubnetResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetUpdateSubnetResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformMonitorArgs(id types.ID, condition *MonitorCondition) (*internetMonitorRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &internetMonitorRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformMonitorResults(data []byte) (*internetMonitorResult, error) {
	nakedResponse := &internetMonitorResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetMonitorResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformMonitorRouterArgs(id types.ID, condition *MonitorCondition) (*internetMonitorRouterRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &internetMonitorRouterRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetOp) transformMonitorRouterResults(data []byte) (*internetMonitorRouterResult, error) {
	nakedResponse := &internetMonitorRouterResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetMonitorRouterResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetOp) transformEnableIPv6Results(data []byte) (*internetEnableIPv6Result, error) {
	nakedResponse := &internetEnableIPv6ResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetEnableIPv6Result{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetPlanOp) transformFindArgs(conditions *FindCondition) (*internetPlanFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &internetPlanFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *InternetPlanOp) transformFindResults(data []byte) (*InternetPlanFindResult, error) {
	nakedResponse := &internetPlanFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &InternetPlanFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *InternetPlanOp) transformReadResults(data []byte) (*internetPlanReadResult, error) {
	nakedResponse := &internetPlanReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &internetPlanReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPAddressOp) transformListResults(data []byte) (*IPAddressListResult, error) {
	nakedResponse := &iPAddressListResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &IPAddressListResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPAddressOp) transformReadResults(data []byte) (*iPAddressReadResult, error) {
	nakedResponse := &iPAddressReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPAddressReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPAddressOp) transformUpdateHostNameArgs(ipAddress string, hostName string) (*iPAddressUpdateHostNameRequestEnvelope, error) {
	if ipAddress == "" {
		ipAddress = ""
	}
	var arg0 interface{} = ipAddress
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if hostName == "" {
		hostName = ""
	}
	var arg1 interface{} = hostName
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"IPAddress.HostName"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &iPAddressUpdateHostNameRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IPAddressOp) transformUpdateHostNameResults(data []byte) (*iPAddressUpdateHostNameResult, error) {
	nakedResponse := &iPAddressUpdateHostNameResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPAddressUpdateHostNameResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6NetOp) transformListResults(data []byte) (*IPv6NetListResult, error) {
	nakedResponse := &iPv6NetListResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &IPv6NetListResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6NetOp) transformFindArgs(conditions *FindCondition) (*iPv6NetFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &iPv6NetFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IPv6NetOp) transformFindResults(data []byte) (*IPv6NetFindResult, error) {
	nakedResponse := &iPv6NetFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &IPv6NetFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6NetOp) transformReadResults(data []byte) (*iPv6NetReadResult, error) {
	nakedResponse := &iPv6NetReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPv6NetReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6AddrOp) transformFindArgs(conditions *FindCondition) (*iPv6AddrFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &iPv6AddrFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IPv6AddrOp) transformFindResults(data []byte) (*IPv6AddrFindResult, error) {
	nakedResponse := &iPv6AddrFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &IPv6AddrFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6AddrOp) transformCreateArgs(param *IPv6AddrCreateRequest) (*iPv6AddrCreateRequestEnvelope, error) {
	if param == nil {
		param = &IPv6AddrCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"IPv6Addr,recursive"`
	}{
		Arg0: arg0,
	}

	v := &iPv6AddrCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IPv6AddrOp) transformCreateResults(data []byte) (*iPv6AddrCreateResult, error) {
	nakedResponse := &iPv6AddrCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPv6AddrCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6AddrOp) transformReadResults(data []byte) (*iPv6AddrReadResult, error) {
	nakedResponse := &iPv6AddrReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPv6AddrReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *IPv6AddrOp) transformUpdateArgs(ipv6addr string, param *IPv6AddrUpdateRequest) (*iPv6AddrUpdateRequestEnvelope, error) {
	if ipv6addr == "" {
		ipv6addr = ""
	}
	var arg0 interface{} = ipv6addr
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &IPv6AddrUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"IPv6Addr,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &iPv6AddrUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *IPv6AddrOp) transformUpdateResults(data []byte) (*iPv6AddrUpdateResult, error) {
	nakedResponse := &iPv6AddrUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &iPv6AddrUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseOp) transformFindArgs(conditions *FindCondition) (*licenseFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &licenseFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LicenseOp) transformFindResults(data []byte) (*LicenseFindResult, error) {
	nakedResponse := &licenseFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &LicenseFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseOp) transformCreateArgs(param *LicenseCreateRequest) (*licenseCreateRequestEnvelope, error) {
	if param == nil {
		param = &LicenseCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"License,recursive"`
	}{
		Arg0: arg0,
	}

	v := &licenseCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LicenseOp) transformCreateResults(data []byte) (*licenseCreateResult, error) {
	nakedResponse := &licenseCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &licenseCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseOp) transformReadResults(data []byte) (*licenseReadResult, error) {
	nakedResponse := &licenseReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &licenseReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseOp) transformUpdateArgs(id types.ID, param *LicenseUpdateRequest) (*licenseUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &LicenseUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"License,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &licenseUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LicenseOp) transformUpdateResults(data []byte) (*licenseUpdateResult, error) {
	nakedResponse := &licenseUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &licenseUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseInfoOp) transformFindArgs(conditions *FindCondition) (*licenseInfoFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &licenseInfoFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LicenseInfoOp) transformFindResults(data []byte) (*LicenseInfoFindResult, error) {
	nakedResponse := &licenseInfoFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &LicenseInfoFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LicenseInfoOp) transformReadResults(data []byte) (*licenseInfoReadResult, error) {
	nakedResponse := &licenseInfoReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &licenseInfoReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformFindArgs(conditions *FindCondition) (*loadBalancerFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &loadBalancerFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformFindResults(data []byte) (*LoadBalancerFindResult, error) {
	nakedResponse := &loadBalancerFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &LoadBalancerFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformCreateArgs(param *LoadBalancerCreateRequest) (*loadBalancerCreateRequestEnvelope, error) {
	if param == nil {
		param = &LoadBalancerCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
	}

	v := &loadBalancerCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformCreateResults(data []byte) (*loadBalancerCreateResult, error) {
	nakedResponse := &loadBalancerCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformReadResults(data []byte) (*loadBalancerReadResult, error) {
	nakedResponse := &loadBalancerReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformUpdateArgs(id types.ID, param *LoadBalancerUpdateRequest) (*loadBalancerUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &LoadBalancerUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &loadBalancerUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformUpdateResults(data []byte) (*loadBalancerUpdateResult, error) {
	nakedResponse := &loadBalancerUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformUpdateSettingsArgs(id types.ID, param *LoadBalancerUpdateSettingsRequest) (*loadBalancerUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &LoadBalancerUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &loadBalancerUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformUpdateSettingsResults(data []byte) (*loadBalancerUpdateSettingsResult, error) {
	nakedResponse := &loadBalancerUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*loadBalancerShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &loadBalancerShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformMonitorCPUArgs(id types.ID, condition *MonitorCondition) (*loadBalancerMonitorCPURequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &loadBalancerMonitorCPURequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformMonitorCPUResults(data []byte) (*loadBalancerMonitorCPUResult, error) {
	nakedResponse := &loadBalancerMonitorCPUResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerMonitorCPUResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformMonitorInterfaceArgs(id types.ID, condition *MonitorCondition) (*loadBalancerMonitorInterfaceRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &loadBalancerMonitorInterfaceRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LoadBalancerOp) transformMonitorInterfaceResults(data []byte) (*loadBalancerMonitorInterfaceResult, error) {
	nakedResponse := &loadBalancerMonitorInterfaceResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &loadBalancerMonitorInterfaceResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LoadBalancerOp) transformStatusResults(data []byte) (*LoadBalancerStatusResult, error) {
	nakedResponse := &loadBalancerStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &LoadBalancerStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformFindArgs(conditions *FindCondition) (*localRouterFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &localRouterFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LocalRouterOp) transformFindResults(data []byte) (*LocalRouterFindResult, error) {
	nakedResponse := &localRouterFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &LocalRouterFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformCreateArgs(param *LocalRouterCreateRequest) (*localRouterCreateRequestEnvelope, error) {
	if param == nil {
		param = &LocalRouterCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &localRouterCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LocalRouterOp) transformCreateResults(data []byte) (*localRouterCreateResult, error) {
	nakedResponse := &localRouterCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformReadResults(data []byte) (*localRouterReadResult, error) {
	nakedResponse := &localRouterReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformUpdateArgs(id types.ID, param *LocalRouterUpdateRequest) (*localRouterUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &LocalRouterUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &localRouterUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LocalRouterOp) transformUpdateResults(data []byte) (*localRouterUpdateResult, error) {
	nakedResponse := &localRouterUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformUpdateSettingsArgs(id types.ID, param *LocalRouterUpdateSettingsRequest) (*localRouterUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &LocalRouterUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &localRouterUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LocalRouterOp) transformUpdateSettingsResults(data []byte) (*localRouterUpdateSettingsResult, error) {
	nakedResponse := &localRouterUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformHealthStatusResults(data []byte) (*localRouterHealthStatusResult, error) {
	nakedResponse := &localRouterHealthStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterHealthStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *LocalRouterOp) transformMonitorLocalRouterArgs(id types.ID, condition *MonitorCondition) (*localRouterMonitorLocalRouterRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &localRouterMonitorLocalRouterRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *LocalRouterOp) transformMonitorLocalRouterResults(data []byte) (*localRouterMonitorLocalRouterResult, error) {
	nakedResponse := &localRouterMonitorLocalRouterResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &localRouterMonitorLocalRouterResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformFindArgs(conditions *FindCondition) (*mobileGatewayFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &mobileGatewayFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformFindResults(data []byte) (*MobileGatewayFindResult, error) {
	nakedResponse := &mobileGatewayFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &MobileGatewayFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformCreateArgs(param *MobileGatewayCreateRequest) (*mobileGatewayCreateRequestEnvelope, error) {
	if param == nil {
		param = &MobileGatewayCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
	}

	v := &mobileGatewayCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformCreateResults(data []byte) (*mobileGatewayCreateResult, error) {
	nakedResponse := &mobileGatewayCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformReadResults(data []byte) (*mobileGatewayReadResult, error) {
	nakedResponse := &mobileGatewayReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformUpdateArgs(id types.ID, param *MobileGatewayUpdateRequest) (*mobileGatewayUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &MobileGatewayUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewayUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformUpdateResults(data []byte) (*mobileGatewayUpdateResult, error) {
	nakedResponse := &mobileGatewayUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformUpdateSettingsArgs(id types.ID, param *MobileGatewayUpdateSettingsRequest) (*mobileGatewayUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &MobileGatewayUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewayUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformUpdateSettingsResults(data []byte) (*mobileGatewayUpdateSettingsResult, error) {
	nakedResponse := &mobileGatewayUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*mobileGatewayShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewayShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformGetDNSResults(data []byte) (*mobileGatewayGetDNSResult, error) {
	nakedResponse := &mobileGatewayGetDNSResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayGetDNSResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformSetDNSArgs(id types.ID, param *MobileGatewayDNSSetting) (*mobileGatewaySetDNSRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &MobileGatewayDNSSetting{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"SIMGroup,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewaySetDNSRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformGetSIMRoutesResults(data []byte) (*mobileGatewayGetSIMRoutesResult, error) {
	nakedResponse := &mobileGatewayGetSIMRoutesResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayGetSIMRoutesResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformSetSIMRoutesArgs(id types.ID, param []*MobileGatewaySIMRouteParam) (*mobileGatewaySetSIMRoutesRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = []*MobileGatewaySIMRouteParam{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"[]SIMRoutes,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewaySetSIMRoutesRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformListSIMResults(data []byte) (*mobileGatewayListSIMResult, error) {
	nakedResponse := &mobileGatewayListSIMResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayListSIMResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformAddSIMArgs(id types.ID, param *MobileGatewayAddSIMRequest) (*mobileGatewayAddSIMRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &MobileGatewayAddSIMRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"SIM,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewayAddSIMRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformLogsResults(data []byte) (*mobileGatewayLogsResult, error) {
	nakedResponse := &mobileGatewayLogsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayLogsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformGetTrafficConfigResults(data []byte) (*mobileGatewayGetTrafficConfigResult, error) {
	nakedResponse := &mobileGatewayGetTrafficConfigResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayGetTrafficConfigResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformSetTrafficConfigArgs(id types.ID, param *MobileGatewayTrafficControl) (*mobileGatewaySetTrafficConfigRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &MobileGatewayTrafficControl{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"TrafficMonitoring,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &mobileGatewaySetTrafficConfigRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformTrafficStatusResults(data []byte) (*mobileGatewayTrafficStatusResult, error) {
	nakedResponse := &mobileGatewayTrafficStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayTrafficStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *MobileGatewayOp) transformMonitorInterfaceArgs(id types.ID, index int, condition *MonitorCondition) (*mobileGatewayMonitorInterfaceRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if index == 0 {
		index = 0
	}
	var arg1 interface{} = index
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg2 interface{} = condition
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &mobileGatewayMonitorInterfaceRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *MobileGatewayOp) transformMonitorInterfaceResults(data []byte) (*mobileGatewayMonitorInterfaceResult, error) {
	nakedResponse := &mobileGatewayMonitorInterfaceResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &mobileGatewayMonitorInterfaceResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformFindArgs(conditions *FindCondition) (*nFSFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &nFSFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformFindResults(data []byte) (*NFSFindResult, error) {
	nakedResponse := &nFSFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &NFSFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformCreateArgs(param *NFSCreateRequest) (*nFSCreateRequestEnvelope, error) {
	if param == nil {
		param = &NFSCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
	}

	v := &nFSCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformCreateResults(data []byte) (*nFSCreateResult, error) {
	nakedResponse := &nFSCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformReadResults(data []byte) (*nFSReadResult, error) {
	nakedResponse := &nFSReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformUpdateArgs(id types.ID, param *NFSUpdateRequest) (*nFSUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &NFSUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &nFSUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformUpdateResults(data []byte) (*nFSUpdateResult, error) {
	nakedResponse := &nFSUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*nFSShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &nFSShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformMonitorCPUArgs(id types.ID, condition *MonitorCondition) (*nFSMonitorCPURequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &nFSMonitorCPURequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformMonitorCPUResults(data []byte) (*nFSMonitorCPUResult, error) {
	nakedResponse := &nFSMonitorCPUResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSMonitorCPUResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformMonitorFreeDiskSizeArgs(id types.ID, condition *MonitorCondition) (*nFSMonitorFreeDiskSizeRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &nFSMonitorFreeDiskSizeRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformMonitorFreeDiskSizeResults(data []byte) (*nFSMonitorFreeDiskSizeResult, error) {
	nakedResponse := &nFSMonitorFreeDiskSizeResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSMonitorFreeDiskSizeResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NFSOp) transformMonitorInterfaceArgs(id types.ID, condition *MonitorCondition) (*nFSMonitorInterfaceRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &nFSMonitorInterfaceRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NFSOp) transformMonitorInterfaceResults(data []byte) (*nFSMonitorInterfaceResult, error) {
	nakedResponse := &nFSMonitorInterfaceResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &nFSMonitorInterfaceResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NoteOp) transformFindArgs(conditions *FindCondition) (*noteFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &noteFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NoteOp) transformFindResults(data []byte) (*NoteFindResult, error) {
	nakedResponse := &noteFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &NoteFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NoteOp) transformCreateArgs(param *NoteCreateRequest) (*noteCreateRequestEnvelope, error) {
	if param == nil {
		param = &NoteCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Note,recursive"`
	}{
		Arg0: arg0,
	}

	v := &noteCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NoteOp) transformCreateResults(data []byte) (*noteCreateResult, error) {
	nakedResponse := &noteCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &noteCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NoteOp) transformReadResults(data []byte) (*noteReadResult, error) {
	nakedResponse := &noteReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &noteReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *NoteOp) transformUpdateArgs(id types.ID, param *NoteUpdateRequest) (*noteUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &NoteUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Note,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &noteUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *NoteOp) transformUpdateResults(data []byte) (*noteUpdateResult, error) {
	nakedResponse := &noteUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &noteUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PacketFilterOp) transformFindArgs(conditions *FindCondition) (*packetFilterFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &packetFilterFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PacketFilterOp) transformFindResults(data []byte) (*PacketFilterFindResult, error) {
	nakedResponse := &packetFilterFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &PacketFilterFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PacketFilterOp) transformCreateArgs(param *PacketFilterCreateRequest) (*packetFilterCreateRequestEnvelope, error) {
	if param == nil {
		param = &PacketFilterCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"PacketFilter,recursive"`
	}{
		Arg0: arg0,
	}

	v := &packetFilterCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PacketFilterOp) transformCreateResults(data []byte) (*packetFilterCreateResult, error) {
	nakedResponse := &packetFilterCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &packetFilterCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PacketFilterOp) transformReadResults(data []byte) (*packetFilterReadResult, error) {
	nakedResponse := &packetFilterReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &packetFilterReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PacketFilterOp) transformUpdateArgs(id types.ID, updateParam *PacketFilterUpdateRequest, originalExpressionHash string) (*packetFilterUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if updateParam == nil {
		updateParam = &PacketFilterUpdateRequest{}
	}
	var arg1 interface{} = updateParam
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if originalExpressionHash == "" {
		originalExpressionHash = ""
	}
	var arg2 interface{} = originalExpressionHash
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"PacketFilter,recursive"`
		Arg2 interface{} `mapconv:"OriginalExpressionHash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &packetFilterUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PacketFilterOp) transformUpdateResults(data []byte) (*packetFilterUpdateResult, error) {
	nakedResponse := &packetFilterUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &packetFilterUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostOp) transformFindArgs(conditions *FindCondition) (*privateHostFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &privateHostFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PrivateHostOp) transformFindResults(data []byte) (*PrivateHostFindResult, error) {
	nakedResponse := &privateHostFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &PrivateHostFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostOp) transformCreateArgs(param *PrivateHostCreateRequest) (*privateHostCreateRequestEnvelope, error) {
	if param == nil {
		param = &PrivateHostCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"PrivateHost,recursive"`
	}{
		Arg0: arg0,
	}

	v := &privateHostCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PrivateHostOp) transformCreateResults(data []byte) (*privateHostCreateResult, error) {
	nakedResponse := &privateHostCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &privateHostCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostOp) transformReadResults(data []byte) (*privateHostReadResult, error) {
	nakedResponse := &privateHostReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &privateHostReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostOp) transformUpdateArgs(id types.ID, param *PrivateHostUpdateRequest) (*privateHostUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &PrivateHostUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"PrivateHost,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &privateHostUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PrivateHostOp) transformUpdateResults(data []byte) (*privateHostUpdateResult, error) {
	nakedResponse := &privateHostUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &privateHostUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostPlanOp) transformFindArgs(conditions *FindCondition) (*privateHostPlanFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &privateHostPlanFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *PrivateHostPlanOp) transformFindResults(data []byte) (*PrivateHostPlanFindResult, error) {
	nakedResponse := &privateHostPlanFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &PrivateHostPlanFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *PrivateHostPlanOp) transformReadResults(data []byte) (*privateHostPlanReadResult, error) {
	nakedResponse := &privateHostPlanReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &privateHostPlanReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformFindArgs(conditions *FindCondition) (*proxyLBFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &proxyLBFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformFindResults(data []byte) (*ProxyLBFindResult, error) {
	nakedResponse := &proxyLBFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ProxyLBFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformCreateArgs(param *ProxyLBCreateRequest) (*proxyLBCreateRequestEnvelope, error) {
	if param == nil {
		param = &ProxyLBCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &proxyLBCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformCreateResults(data []byte) (*proxyLBCreateResult, error) {
	nakedResponse := &proxyLBCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformReadResults(data []byte) (*proxyLBReadResult, error) {
	nakedResponse := &proxyLBReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformUpdateArgs(id types.ID, param *ProxyLBUpdateRequest) (*proxyLBUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ProxyLBUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &proxyLBUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformUpdateResults(data []byte) (*proxyLBUpdateResult, error) {
	nakedResponse := &proxyLBUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformUpdateSettingsArgs(id types.ID, param *ProxyLBUpdateSettingsRequest) (*proxyLBUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ProxyLBUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &proxyLBUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformUpdateSettingsResults(data []byte) (*proxyLBUpdateSettingsResult, error) {
	nakedResponse := &proxyLBUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformChangePlanArgs(id types.ID, param *ProxyLBChangePlanRequest) (*proxyLBChangePlanRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ProxyLBChangePlanRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &proxyLBChangePlanRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformChangePlanResults(data []byte) (*proxyLBChangePlanResult, error) {
	nakedResponse := &proxyLBChangePlanResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBChangePlanResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformGetCertificatesResults(data []byte) (*proxyLBGetCertificatesResult, error) {
	nakedResponse := &proxyLBGetCertificatesResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBGetCertificatesResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformSetCertificatesArgs(id types.ID, param *ProxyLBSetCertificatesRequest) (*proxyLBSetCertificatesRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ProxyLBSetCertificatesRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"ProxyLB,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &proxyLBSetCertificatesRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformSetCertificatesResults(data []byte) (*proxyLBSetCertificatesResult, error) {
	nakedResponse := &proxyLBSetCertificatesResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBSetCertificatesResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformHealthStatusResults(data []byte) (*proxyLBHealthStatusResult, error) {
	nakedResponse := &proxyLBHealthStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBHealthStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ProxyLBOp) transformMonitorConnectionArgs(id types.ID, condition *MonitorCondition) (*proxyLBMonitorConnectionRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &proxyLBMonitorConnectionRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ProxyLBOp) transformMonitorConnectionResults(data []byte) (*proxyLBMonitorConnectionResult, error) {
	nakedResponse := &proxyLBMonitorConnectionResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &proxyLBMonitorConnectionResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *RegionOp) transformFindArgs(conditions *FindCondition) (*regionFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &regionFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *RegionOp) transformFindResults(data []byte) (*RegionFindResult, error) {
	nakedResponse := &regionFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &RegionFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *RegionOp) transformReadResults(data []byte) (*regionReadResult, error) {
	nakedResponse := &regionReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &regionReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformFindArgs(conditions *FindCondition) (*serverFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &serverFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformFindResults(data []byte) (*ServerFindResult, error) {
	nakedResponse := &serverFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ServerFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformCreateArgs(param *ServerCreateRequest) (*serverCreateRequestEnvelope, error) {
	if param == nil {
		param = &ServerCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Server,recursive"`
	}{
		Arg0: arg0,
	}

	v := &serverCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformCreateResults(data []byte) (*serverCreateResult, error) {
	nakedResponse := &serverCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformReadResults(data []byte) (*serverReadResult, error) {
	nakedResponse := &serverReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformUpdateArgs(id types.ID, param *ServerUpdateRequest) (*serverUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ServerUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Server,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformUpdateResults(data []byte) (*serverUpdateResult, error) {
	nakedResponse := &serverUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformDeleteWithDisksArgs(id types.ID, disks *ServerDeleteWithDisksRequest) (*serverDeleteWithDisksRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if disks == nil {
		disks = &ServerDeleteWithDisksRequest{}
	}
	var arg1 interface{} = disks
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverDeleteWithDisksRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformChangePlanArgs(id types.ID, plan *ServerChangePlanRequest) (*serverChangePlanRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if plan == nil {
		plan = &ServerChangePlanRequest{}
	}
	var arg1 interface{} = plan
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverChangePlanRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformChangePlanResults(data []byte) (*serverChangePlanResult, error) {
	nakedResponse := &serverChangePlanResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverChangePlanResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformInsertCDROMArgs(id types.ID, insertParam *InsertCDROMRequest) (*serverInsertCDROMRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if insertParam == nil {
		insertParam = &InsertCDROMRequest{}
	}
	var arg1 interface{} = insertParam
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CDROM"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverInsertCDROMRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformEjectCDROMArgs(id types.ID, ejectParam *EjectCDROMRequest) (*serverEjectCDROMRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if ejectParam == nil {
		ejectParam = &EjectCDROMRequest{}
	}
	var arg1 interface{} = ejectParam
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CDROM"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverEjectCDROMRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*serverShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformBootWithVariablesArgs(id types.ID, param *ServerBootVariables) (*serverBootWithVariablesRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &ServerBootVariables{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"UserBootVariables,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverBootWithVariablesRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformSendKeyArgs(id types.ID, keyboardParam *SendKeyRequest) (*serverSendKeyRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if keyboardParam == nil {
		keyboardParam = &SendKeyRequest{}
	}
	var arg1 interface{} = keyboardParam
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverSendKeyRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformGetVNCProxyResults(data []byte) (*serverGetVNCProxyResult, error) {
	nakedResponse := &serverGetVNCProxyResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverGetVNCProxyResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformMonitorArgs(id types.ID, condition *MonitorCondition) (*serverMonitorRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverMonitorRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformMonitorResults(data []byte) (*serverMonitorResult, error) {
	nakedResponse := &serverMonitorResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverMonitorResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerOp) transformMonitorCPUArgs(id types.ID, condition *MonitorCondition) (*serverMonitorCPURequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &serverMonitorCPURequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerOp) transformMonitorCPUResults(data []byte) (*serverMonitorCPUResult, error) {
	nakedResponse := &serverMonitorCPUResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverMonitorCPUResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerPlanOp) transformFindArgs(conditions *FindCondition) (*serverPlanFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &serverPlanFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServerPlanOp) transformFindResults(data []byte) (*ServerPlanFindResult, error) {
	nakedResponse := &serverPlanFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ServerPlanFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServerPlanOp) transformReadResults(data []byte) (*serverPlanReadResult, error) {
	nakedResponse := &serverPlanReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &serverPlanReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ServiceClassOp) transformFindArgs(conditions *FindCondition) (*serviceClassFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &serviceClassFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ServiceClassOp) transformFindResults(data []byte) (*ServiceClassFindResult, error) {
	nakedResponse := &serviceClassFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ServiceClassFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformFindArgs(conditions *FindCondition) (*sIMFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &sIMFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformFindResults(data []byte) (*SIMFindResult, error) {
	nakedResponse := &sIMFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SIMFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformCreateArgs(param *SIMCreateRequest) (*sIMCreateRequestEnvelope, error) {
	if param == nil {
		param = &SIMCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &sIMCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformCreateResults(data []byte) (*sIMCreateResult, error) {
	nakedResponse := &sIMCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformReadResults(data []byte) (*sIMReadResult, error) {
	nakedResponse := &sIMReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformUpdateArgs(id types.ID, param *SIMUpdateRequest) (*sIMUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SIMUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sIMUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformUpdateResults(data []byte) (*sIMUpdateResult, error) {
	nakedResponse := &sIMUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformAssignIPArgs(id types.ID, param *SIMAssignIPRequest) (*sIMAssignIPRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SIMAssignIPRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"SIM,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sIMAssignIPRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformIMEILockArgs(id types.ID, param *SIMIMEILockRequest) (*sIMIMEILockRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SIMIMEILockRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"SIM,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sIMIMEILockRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformLogsResults(data []byte) (*SIMLogsResult, error) {
	nakedResponse := &sIMLogsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SIMLogsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformGetNetworkOperatorResults(data []byte) (*sIMGetNetworkOperatorResult, error) {
	nakedResponse := &sIMGetNetworkOperatorResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMGetNetworkOperatorResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformSetNetworkOperatorArgs(id types.ID, configs []*SIMNetworkOperatorConfig) (*sIMSetNetworkOperatorRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if configs == nil {
		configs = []*SIMNetworkOperatorConfig{}
	}
	var arg1 interface{} = configs
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"[]NetworkOperatorConfigs,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sIMSetNetworkOperatorRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformMonitorSIMArgs(id types.ID, condition *MonitorCondition) (*sIMMonitorSIMRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sIMMonitorSIMRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SIMOp) transformMonitorSIMResults(data []byte) (*sIMMonitorSIMResult, error) {
	nakedResponse := &sIMMonitorSIMResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMMonitorSIMResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SIMOp) transformStatusResults(data []byte) (*sIMStatusResult, error) {
	nakedResponse := &sIMStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sIMStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformFindArgs(conditions *FindCondition) (*simpleMonitorFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &simpleMonitorFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleMonitorOp) transformFindResults(data []byte) (*SimpleMonitorFindResult, error) {
	nakedResponse := &simpleMonitorFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SimpleMonitorFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformCreateArgs(param *SimpleMonitorCreateRequest) (*simpleMonitorCreateRequestEnvelope, error) {
	if param == nil {
		param = &SimpleMonitorCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &simpleMonitorCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleMonitorOp) transformCreateResults(data []byte) (*simpleMonitorCreateResult, error) {
	nakedResponse := &simpleMonitorCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformReadResults(data []byte) (*simpleMonitorReadResult, error) {
	nakedResponse := &simpleMonitorReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformUpdateArgs(id types.ID, param *SimpleMonitorUpdateRequest) (*simpleMonitorUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleMonitorUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleMonitorUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleMonitorOp) transformUpdateResults(data []byte) (*simpleMonitorUpdateResult, error) {
	nakedResponse := &simpleMonitorUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformUpdateSettingsArgs(id types.ID, param *SimpleMonitorUpdateSettingsRequest) (*simpleMonitorUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleMonitorUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleMonitorUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleMonitorOp) transformUpdateSettingsResults(data []byte) (*simpleMonitorUpdateSettingsResult, error) {
	nakedResponse := &simpleMonitorUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformMonitorResponseTimeArgs(id types.ID, condition *MonitorCondition) (*simpleMonitorMonitorResponseTimeRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleMonitorMonitorResponseTimeRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleMonitorOp) transformMonitorResponseTimeResults(data []byte) (*simpleMonitorMonitorResponseTimeResult, error) {
	nakedResponse := &simpleMonitorMonitorResponseTimeResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorMonitorResponseTimeResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleMonitorOp) transformHealthStatusResults(data []byte) (*simpleMonitorHealthStatusResult, error) {
	nakedResponse := &simpleMonitorHealthStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleMonitorHealthStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformFindArgs(conditions *FindCondition) (*simpleNotificationDestinationFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &simpleNotificationDestinationFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationDestinationOp) transformFindResults(data []byte) (*SimpleNotificationDestinationFindResult, error) {
	nakedResponse := &simpleNotificationDestinationFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SimpleNotificationDestinationFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformCreateArgs(param *SimpleNotificationDestinationCreateRequest) (*simpleNotificationDestinationCreateRequestEnvelope, error) {
	if param == nil {
		param = &SimpleNotificationDestinationCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &simpleNotificationDestinationCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationDestinationOp) transformCreateResults(data []byte) (*simpleNotificationDestinationCreateResult, error) {
	nakedResponse := &simpleNotificationDestinationCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationDestinationCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformReadResults(data []byte) (*simpleNotificationDestinationReadResult, error) {
	nakedResponse := &simpleNotificationDestinationReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationDestinationReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformUpdateArgs(id types.ID, param *SimpleNotificationDestinationUpdateRequest) (*simpleNotificationDestinationUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleNotificationDestinationUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleNotificationDestinationUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationDestinationOp) transformUpdateResults(data []byte) (*simpleNotificationDestinationUpdateResult, error) {
	nakedResponse := &simpleNotificationDestinationUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationDestinationUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformUpdateSettingsArgs(id types.ID, param *SimpleNotificationDestinationUpdateSettingsRequest) (*simpleNotificationDestinationUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleNotificationDestinationUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleNotificationDestinationUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationDestinationOp) transformUpdateSettingsResults(data []byte) (*simpleNotificationDestinationUpdateSettingsResult, error) {
	nakedResponse := &simpleNotificationDestinationUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationDestinationUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationDestinationOp) transformStatusResults(data []byte) (*simpleNotificationDestinationStatusResult, error) {
	nakedResponse := &simpleNotificationDestinationStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationDestinationStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformFindArgs(conditions *FindCondition) (*simpleNotificationGroupFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &simpleNotificationGroupFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationGroupOp) transformFindResults(data []byte) (*SimpleNotificationGroupFindResult, error) {
	nakedResponse := &simpleNotificationGroupFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SimpleNotificationGroupFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformCreateArgs(param *SimpleNotificationGroupCreateRequest) (*simpleNotificationGroupCreateRequestEnvelope, error) {
	if param == nil {
		param = &SimpleNotificationGroupCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
	}

	v := &simpleNotificationGroupCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationGroupOp) transformCreateResults(data []byte) (*simpleNotificationGroupCreateResult, error) {
	nakedResponse := &simpleNotificationGroupCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationGroupCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformReadResults(data []byte) (*simpleNotificationGroupReadResult, error) {
	nakedResponse := &simpleNotificationGroupReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationGroupReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformUpdateArgs(id types.ID, param *SimpleNotificationGroupUpdateRequest) (*simpleNotificationGroupUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleNotificationGroupUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleNotificationGroupUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationGroupOp) transformUpdateResults(data []byte) (*simpleNotificationGroupUpdateResult, error) {
	nakedResponse := &simpleNotificationGroupUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationGroupUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformUpdateSettingsArgs(id types.ID, param *SimpleNotificationGroupUpdateSettingsRequest) (*simpleNotificationGroupUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SimpleNotificationGroupUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"CommonServiceItem,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleNotificationGroupUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationGroupOp) transformUpdateSettingsResults(data []byte) (*simpleNotificationGroupUpdateSettingsResult, error) {
	nakedResponse := &simpleNotificationGroupUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationGroupUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SimpleNotificationGroupOp) transformPostMessageArgs(id types.ID, message string) (*simpleNotificationGroupPostMessageRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if message == "" {
		message = ""
	}
	var arg1 interface{} = message
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Message"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &simpleNotificationGroupPostMessageRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SimpleNotificationGroupOp) transformHistoryResults(data []byte) (*simpleNotificationGroupHistoryResult, error) {
	nakedResponse := &simpleNotificationGroupHistoryResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &simpleNotificationGroupHistoryResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SSHKeyOp) transformFindArgs(conditions *FindCondition) (*sSHKeyFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &sSHKeyFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SSHKeyOp) transformFindResults(data []byte) (*SSHKeyFindResult, error) {
	nakedResponse := &sSHKeyFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SSHKeyFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SSHKeyOp) transformCreateArgs(param *SSHKeyCreateRequest) (*sSHKeyCreateRequestEnvelope, error) {
	if param == nil {
		param = &SSHKeyCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"SSHKey,recursive"`
	}{
		Arg0: arg0,
	}

	v := &sSHKeyCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SSHKeyOp) transformCreateResults(data []byte) (*sSHKeyCreateResult, error) {
	nakedResponse := &sSHKeyCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sSHKeyCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SSHKeyOp) transformReadResults(data []byte) (*sSHKeyReadResult, error) {
	nakedResponse := &sSHKeyReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sSHKeyReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SSHKeyOp) transformUpdateArgs(id types.ID, param *SSHKeyUpdateRequest) (*sSHKeyUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SSHKeyUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"SSHKey,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &sSHKeyUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SSHKeyOp) transformUpdateResults(data []byte) (*sSHKeyUpdateResult, error) {
	nakedResponse := &sSHKeyUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &sSHKeyUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SubnetOp) transformFindArgs(conditions *FindCondition) (*subnetFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &subnetFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SubnetOp) transformFindResults(data []byte) (*SubnetFindResult, error) {
	nakedResponse := &subnetFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SubnetFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SubnetOp) transformReadResults(data []byte) (*subnetReadResult, error) {
	nakedResponse := &subnetReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &subnetReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SwitchOp) transformFindArgs(conditions *FindCondition) (*switchFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &switchFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SwitchOp) transformFindResults(data []byte) (*SwitchFindResult, error) {
	nakedResponse := &switchFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SwitchFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SwitchOp) transformCreateArgs(param *SwitchCreateRequest) (*switchCreateRequestEnvelope, error) {
	if param == nil {
		param = &SwitchCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Switch,recursive"`
	}{
		Arg0: arg0,
	}

	v := &switchCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SwitchOp) transformCreateResults(data []byte) (*switchCreateResult, error) {
	nakedResponse := &switchCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &switchCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SwitchOp) transformReadResults(data []byte) (*switchReadResult, error) {
	nakedResponse := &switchReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &switchReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SwitchOp) transformUpdateArgs(id types.ID, param *SwitchUpdateRequest) (*switchUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &SwitchUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Switch,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &switchUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *SwitchOp) transformUpdateResults(data []byte) (*switchUpdateResult, error) {
	nakedResponse := &switchUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &switchUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *SwitchOp) transformGetServersResults(data []byte) (*SwitchGetServersResult, error) {
	nakedResponse := &switchGetServersResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &SwitchGetServersResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformFindArgs(conditions *FindCondition) (*vPCRouterFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &vPCRouterFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformFindResults(data []byte) (*VPCRouterFindResult, error) {
	nakedResponse := &vPCRouterFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &VPCRouterFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformCreateArgs(param *VPCRouterCreateRequest) (*vPCRouterCreateRequestEnvelope, error) {
	if param == nil {
		param = &VPCRouterCreateRequest{}
	}
	var arg0 interface{} = param
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
	}

	v := &vPCRouterCreateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformCreateResults(data []byte) (*vPCRouterCreateResult, error) {
	nakedResponse := &vPCRouterCreateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterCreateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformReadResults(data []byte) (*vPCRouterReadResult, error) {
	nakedResponse := &vPCRouterReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformUpdateArgs(id types.ID, param *VPCRouterUpdateRequest) (*vPCRouterUpdateRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &VPCRouterUpdateRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &vPCRouterUpdateRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformUpdateResults(data []byte) (*vPCRouterUpdateResult, error) {
	nakedResponse := &vPCRouterUpdateResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterUpdateResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformUpdateSettingsArgs(id types.ID, param *VPCRouterUpdateSettingsRequest) (*vPCRouterUpdateSettingsRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if param == nil {
		param = &VPCRouterUpdateSettingsRequest{}
	}
	var arg1 interface{} = param
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:"Appliance,recursive"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &vPCRouterUpdateSettingsRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformUpdateSettingsResults(data []byte) (*vPCRouterUpdateSettingsResult, error) {
	nakedResponse := &vPCRouterUpdateSettingsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterUpdateSettingsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformShutdownArgs(id types.ID, shutdownOption *ShutdownOption) (*vPCRouterShutdownRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if shutdownOption == nil {
		shutdownOption = &ShutdownOption{}
	}
	var arg1 interface{} = shutdownOption
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &vPCRouterShutdownRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformMonitorCPUArgs(id types.ID, condition *MonitorCondition) (*vPCRouterMonitorCPURequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg1 interface{} = condition
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
	}

	v := &vPCRouterMonitorCPURequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformMonitorCPUResults(data []byte) (*vPCRouterMonitorCPUResult, error) {
	nakedResponse := &vPCRouterMonitorCPUResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterMonitorCPUResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformMonitorInterfaceArgs(id types.ID, index int, condition *MonitorCondition) (*vPCRouterMonitorInterfaceRequestEnvelope, error) {
	if id == types.ID(int64(0)) {
		id = types.ID(int64(0))
	}
	var arg0 interface{} = id
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	if index == 0 {
		index = 0
	}
	var arg1 interface{} = index
	if v, ok := arg1.(argumentDefaulter); ok {
		arg1 = v.setDefaults()
	}
	if condition == nil {
		condition = &MonitorCondition{}
	}
	var arg2 interface{} = condition
	if v, ok := arg2.(argumentDefaulter); ok {
		arg2 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{}
		Arg1 interface{}
		Arg2 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
		Arg1: arg1,
		Arg2: arg2,
	}

	v := &vPCRouterMonitorInterfaceRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *VPCRouterOp) transformMonitorInterfaceResults(data []byte) (*vPCRouterMonitorInterfaceResult, error) {
	nakedResponse := &vPCRouterMonitorInterfaceResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterMonitorInterfaceResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformStatusResults(data []byte) (*vPCRouterStatusResult, error) {
	nakedResponse := &vPCRouterStatusResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterStatusResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformLogsResults(data []byte) (*vPCRouterLogsResult, error) {
	nakedResponse := &vPCRouterLogsResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterLogsResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *VPCRouterOp) transformPingResults(data []byte) (*vPCRouterPingResult, error) {
	nakedResponse := &vPCRouterPingResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &vPCRouterPingResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ZoneOp) transformFindArgs(conditions *FindCondition) (*zoneFindRequestEnvelope, error) {
	if conditions == nil {
		conditions = &FindCondition{}
	}
	var arg0 interface{} = conditions
	if v, ok := arg0.(argumentDefaulter); ok {
		arg0 = v.setDefaults()
	}
	args := &struct {
		Arg0 interface{} `mapconv:",squash"`
	}{
		Arg0: arg0,
	}

	v := &zoneFindRequestEnvelope{}
	if err := mapconv.ConvertTo(args, v); err != nil {
		return nil, err
	}
	return v, nil
}

func (o *ZoneOp) transformFindResults(data []byte) (*ZoneFindResult, error) {
	nakedResponse := &zoneFindResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &ZoneFindResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}

func (o *ZoneOp) transformReadResults(data []byte) (*zoneReadResult, error) {
	nakedResponse := &zoneReadResponseEnvelope{}
	if err := json.Unmarshal(data, nakedResponse); err != nil {
		return nil, err
	}

	results := &zoneReadResult{}
	if err := mapconv.ConvertFrom(nakedResponse, results); err != nil {
		return nil, err
	}
	return results, nil
}
