#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0062\x006e";
static constexpr OUStringLiteral langDefaultName = u"\x0042\x0065\x006e\x0067\x0061\x006c\x0069";
static constexpr OUStringLiteral countryID = u"\x0042\x0044";
static constexpr OUStringLiteral countryDefaultName = u"\x0042\x0061\x006e\x0067\x006c\x0061\x0064\x0065\x0073\x0068";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_bn_BD(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_bn_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_bn_BD(sal_Int16& count)
{
	return getLocaleItem_bn_IN(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x9f3, 0x2d, 0x38, 0x34, 0x35, 0x5d, 0x0};
extern OUString const * getAllFormats0_bn_IN(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_bn_BD(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_bn_IN(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_bn_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_bn_BD(sal_Int16& count)
{
	return getDateAcceptancePatterns_bn_IN(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_bn_BD(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_bn_BD(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_bn_BD(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
static constexpr OUStringLiteral IndexID0 = u"\x0061\x006c\x0070\x0068\x0061\x006e\x0075\x006d\x0065\x0072\x0069\x0063";
static constexpr OUStringLiteral IndexModule0 = u"";
static constexpr OUStringLiteral IndexKey0 = u"\x0995\x002d\x09a8\x0020\x09aa\x002d\x09b0\x0020\x09b2\x0020\x09b6\x002d\x09b9";
static constexpr OUStringLiteral defaultIndex0 = u"\x1";
static constexpr OUStringLiteral defaultPhonetic0 = u"\x0";

static constexpr OUStringLiteral unicodeScript0 = u"\x0031\x0035";
static constexpr OUStringLiteral followPageWord0 = u"\x09aa\x09b0\x09ac\x09b0\x09cd\x09a4\x09c0\x0020\x09aa\x09c3\x09b7\x09cd\x09a0\x09be";
static constexpr OUStringLiteral followPageWord1 = u"\x09b6\x09c7\x09b7\x0020\x09aa\x09c3\x09b7\x09cd\x09a0\x09be";
static const sal_Int16 nbOfIndexs = 1;


static constexpr OUString IndexArray[] = {
	IndexID0,
	IndexModule0,
	IndexKey0,
	defaultIndex0,
	defaultPhonetic0,
};

static const sal_Int16 nbOfUnicodeScripts = 1;

static constexpr OUString UnicodeScriptArray[] = {unicodeScript0 };

static const sal_Int16 nbOfPageWords = 2;

static constexpr OUString FollowPageWordArray[] = {
	followPageWord0,
	followPageWord1	
};

SAL_DLLPUBLIC_EXPORT OUString const *  getIndexAlgorithm_bn_BD(sal_Int16& count)
{
	count = nbOfIndexs;
	return (OUString const *)IndexArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getUnicodeScripts_bn_BD(sal_Int16& count)
{
	count = nbOfUnicodeScripts;
	return (OUString const *)UnicodeScriptArray;
}
SAL_DLLPUBLIC_EXPORT OUString const *  getFollowPageWords_bn_BD(sal_Int16& count)
{
	count = nbOfPageWords;
	return (OUString const *)FollowPageWordArray;
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x09b0\x09ac\x09bf";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x09b0\x09ac\x09bf\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x09b0";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x09b8\x09cb\x09ae";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x09b8\x09cb\x09ae\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x09b8";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x09ae\x0999\x09cd\x0997\x09b2";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x09ae\x0999\x09cd\x0997\x09b2\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x09ae";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x09ac\x09c1\x09a7";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x09ac\x09c1\x09a7\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x09ac";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x09ac\x09c3\x09b9\x0983";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x09ac\x09c3\x09b9\x09b8\x09cd\x09aa\x09a4\x09bf\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x09ac";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x09b6\x09c1\x0995\x09cd\x09b0";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x09b6\x09c1\x0995\x09cd\x09b0\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x09b6";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x09b6\x09a8\x09bf";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x09b6\x09a8\x09bf\x09ac\x09be\x09b0";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x09b6";
static constexpr OUStringLiteral monthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName00 = u"\x099c\x09be\x09a8\x09c1";
static constexpr OUStringLiteral monthDefaultFullName00 = u"\x099c\x09be\x09a8\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral monthDefaultNarrowName00 = u"\x099c";
static constexpr OUStringLiteral monthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral monthDefaultAbbrvName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1";
static constexpr OUStringLiteral monthDefaultFullName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral monthDefaultNarrowName01 = u"\x09ab";
static constexpr OUStringLiteral monthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral monthDefaultFullName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral monthDefaultNarrowName02 = u"\x09ae";
static constexpr OUStringLiteral monthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral monthDefaultAbbrvName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf";
static constexpr OUStringLiteral monthDefaultFullName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf\x09b2";
static constexpr OUStringLiteral monthDefaultNarrowName03 = u"\x098f";
static constexpr OUStringLiteral monthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral monthDefaultAbbrvName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral monthDefaultFullName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral monthDefaultNarrowName04 = u"\x09ae";
static constexpr OUStringLiteral monthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral monthDefaultAbbrvName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral monthDefaultFullName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral monthDefaultNarrowName05 = u"\x099c";
static constexpr OUStringLiteral monthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral monthDefaultAbbrvName06 = u"\x099c\x09c1\x09b2";
static constexpr OUStringLiteral monthDefaultFullName06 = u"\x099c\x09c1\x09b2\x09be\x0987";
static constexpr OUStringLiteral monthDefaultNarrowName06 = u"\x099c";
static constexpr OUStringLiteral monthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral monthDefaultAbbrvName07 = u"\x0986\x0997";
static constexpr OUStringLiteral monthDefaultFullName07 = u"\x0986\x0997\x09b8\x09cd\x099f";
static constexpr OUStringLiteral monthDefaultNarrowName07 = u"\x0986";
static constexpr OUStringLiteral monthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral monthDefaultAbbrvName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7";
static constexpr OUStringLiteral monthDefaultFullName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral monthDefaultNarrowName08 = u"\x09b8";
static constexpr OUStringLiteral monthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral monthDefaultAbbrvName09 = u"\x0985\x0995\x09cd\x099f\x09cb";
static constexpr OUStringLiteral monthDefaultFullName09 = u"\x0985\x0995\x09cd\x099f\x09cb\x09ac\x09b0";
static constexpr OUStringLiteral monthDefaultNarrowName09 = u"\x0985";
static constexpr OUStringLiteral monthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral monthDefaultAbbrvName010 = u"\x09a8\x09ad\x09c7";
static constexpr OUStringLiteral monthDefaultFullName010 = u"\x09a8\x09ad\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral monthDefaultNarrowName010 = u"\x09a8";
static constexpr OUStringLiteral monthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral monthDefaultAbbrvName011 = u"\x09a1\x09bf\x09b8\x09c7";
static constexpr OUStringLiteral monthDefaultFullName011 = u"\x09a1\x09bf\x09b8\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral monthDefaultNarrowName011 = u"\x09a1";
static constexpr OUStringLiteral genitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName00 = u"\x099c\x09be\x09a8\x09c1";
static constexpr OUStringLiteral genitiveMonthDefaultFullName00 = u"\x099c\x09be\x09a8\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName00 = u"\x099c";
static constexpr OUStringLiteral genitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1";
static constexpr OUStringLiteral genitiveMonthDefaultFullName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName01 = u"\x09ab";
static constexpr OUStringLiteral genitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral genitiveMonthDefaultFullName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName02 = u"\x09ae";
static constexpr OUStringLiteral genitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf";
static constexpr OUStringLiteral genitiveMonthDefaultFullName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf\x09b2";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName03 = u"\x098f";
static constexpr OUStringLiteral genitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral genitiveMonthDefaultFullName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName04 = u"\x09ae";
static constexpr OUStringLiteral genitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral genitiveMonthDefaultFullName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName05 = u"\x099c";
static constexpr OUStringLiteral genitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName06 = u"\x099c\x09c1\x09b2";
static constexpr OUStringLiteral genitiveMonthDefaultFullName06 = u"\x099c\x09c1\x09b2\x09be\x0987";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName06 = u"\x099c";
static constexpr OUStringLiteral genitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName07 = u"\x0986\x0997";
static constexpr OUStringLiteral genitiveMonthDefaultFullName07 = u"\x0986\x0997\x09b8\x09cd\x099f";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName07 = u"\x0986";
static constexpr OUStringLiteral genitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7";
static constexpr OUStringLiteral genitiveMonthDefaultFullName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName08 = u"\x09b8";
static constexpr OUStringLiteral genitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName09 = u"\x0985\x0995\x09cd\x099f\x09cb";
static constexpr OUStringLiteral genitiveMonthDefaultFullName09 = u"\x0985\x0995\x09cd\x099f\x09cb\x09ac\x09b0";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName09 = u"\x0985";
static constexpr OUStringLiteral genitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName010 = u"\x09a8\x09ad\x09c7";
static constexpr OUStringLiteral genitiveMonthDefaultFullName010 = u"\x09a8\x09ad\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName010 = u"\x09a8";
static constexpr OUStringLiteral genitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral genitiveMonthDefaultAbbrvName011 = u"\x09a1\x09bf\x09b8\x09c7";
static constexpr OUStringLiteral genitiveMonthDefaultFullName011 = u"\x09a1\x09bf\x09b8\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral genitiveMonthDefaultNarrowName011 = u"\x09a1";
static constexpr OUStringLiteral partitiveMonthID00 = u"\x006a\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName00 = u"\x099c\x09be\x09a8\x09c1";
static constexpr OUStringLiteral partitiveMonthDefaultFullName00 = u"\x099c\x09be\x09a8\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName00 = u"\x099c";
static constexpr OUStringLiteral partitiveMonthID01 = u"\x0066\x0065\x0062";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1";
static constexpr OUStringLiteral partitiveMonthDefaultFullName01 = u"\x09ab\x09c7\x09ac\x09cd\x09b0\x09c1\x09df\x09be\x09b0\x09bf";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName01 = u"\x09ab";
static constexpr OUStringLiteral partitiveMonthID02 = u"\x006d\x0061\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral partitiveMonthDefaultFullName02 = u"\x09ae\x09be\x09b0\x09cd\x099a";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName02 = u"\x09ae";
static constexpr OUStringLiteral partitiveMonthID03 = u"\x0061\x0070\x0072";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf";
static constexpr OUStringLiteral partitiveMonthDefaultFullName03 = u"\x098f\x09aa\x09cd\x09b0\x09bf\x09b2";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName03 = u"\x098f";
static constexpr OUStringLiteral partitiveMonthID04 = u"\x006d\x0061\x0079";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral partitiveMonthDefaultFullName04 = u"\x09ae\x09c7";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName04 = u"\x09ae";
static constexpr OUStringLiteral partitiveMonthID05 = u"\x006a\x0075\x006e";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral partitiveMonthDefaultFullName05 = u"\x099c\x09c1\x09a8";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName05 = u"\x099c";
static constexpr OUStringLiteral partitiveMonthID06 = u"\x006a\x0075\x006c";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName06 = u"\x099c\x09c1\x09b2";
static constexpr OUStringLiteral partitiveMonthDefaultFullName06 = u"\x099c\x09c1\x09b2\x09be\x0987";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName06 = u"\x099c";
static constexpr OUStringLiteral partitiveMonthID07 = u"\x0061\x0075\x0067";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName07 = u"\x0986\x0997";
static constexpr OUStringLiteral partitiveMonthDefaultFullName07 = u"\x0986\x0997\x09b8\x09cd\x099f";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName07 = u"\x0986";
static constexpr OUStringLiteral partitiveMonthID08 = u"\x0073\x0065\x0070";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7";
static constexpr OUStringLiteral partitiveMonthDefaultFullName08 = u"\x09b8\x09c7\x09aa\x09cd\x099f\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName08 = u"\x09b8";
static constexpr OUStringLiteral partitiveMonthID09 = u"\x006f\x0063\x0074";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName09 = u"\x0985\x0995\x09cd\x099f\x09cb";
static constexpr OUStringLiteral partitiveMonthDefaultFullName09 = u"\x0985\x0995\x09cd\x099f\x09cb\x09ac\x09b0";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName09 = u"\x0985";
static constexpr OUStringLiteral partitiveMonthID010 = u"\x006e\x006f\x0076";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName010 = u"\x09a8\x09ad\x09c7";
static constexpr OUStringLiteral partitiveMonthDefaultFullName010 = u"\x09a8\x09ad\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName010 = u"\x09a8";
static constexpr OUStringLiteral partitiveMonthID011 = u"\x0064\x0065\x0063";
static constexpr OUStringLiteral partitiveMonthDefaultAbbrvName011 = u"\x09a1\x09bf\x09b8\x09c7";
static constexpr OUStringLiteral partitiveMonthDefaultFullName011 = u"\x09a1\x09bf\x09b8\x09c7\x09ae\x09cd\x09ac\x09b0";
static constexpr OUStringLiteral partitiveMonthDefaultNarrowName011 = u"\x09a1";
static constexpr OUStringLiteral eraID00 = u"\x0062\x0063";

static constexpr OUStringLiteral eraDefaultAbbrvName00 = u"\x0996\x09c3\x0983";
static constexpr OUStringLiteral eraDefaultFullName00 = u"\x0996\x09c3\x09b8\x09cd\x099f\x002d\x09aa\x09c2\x09b0\x09cd\x09ac";
static constexpr OUStringLiteral eraID01 = u"\x0061\x0064";

static constexpr OUStringLiteral eraDefaultAbbrvName01 = u"\x0996\x09cd\x09b0\x09bf\x0983";
static constexpr OUStringLiteral eraDefaultFullName01 = u"\x0996\x09cd\x09b0\x09bf\x09b8\x09cd\x099f\x09be\x09ac\x09cd\x09a6";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\xc";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\xc";
static constexpr OUStringLiteral nbOfEras = u"\x2";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthID00,
	monthDefaultAbbrvName00,
	monthDefaultFullName00,
	monthDefaultNarrowName00,
	monthID01,
	monthDefaultAbbrvName01,
	monthDefaultFullName01,
	monthDefaultNarrowName01,
	monthID02,
	monthDefaultAbbrvName02,
	monthDefaultFullName02,
	monthDefaultNarrowName02,
	monthID03,
	monthDefaultAbbrvName03,
	monthDefaultFullName03,
	monthDefaultNarrowName03,
	monthID04,
	monthDefaultAbbrvName04,
	monthDefaultFullName04,
	monthDefaultNarrowName04,
	monthID05,
	monthDefaultAbbrvName05,
	monthDefaultFullName05,
	monthDefaultNarrowName05,
	monthID06,
	monthDefaultAbbrvName06,
	monthDefaultFullName06,
	monthDefaultNarrowName06,
	monthID07,
	monthDefaultAbbrvName07,
	monthDefaultFullName07,
	monthDefaultNarrowName07,
	monthID08,
	monthDefaultAbbrvName08,
	monthDefaultFullName08,
	monthDefaultNarrowName08,
	monthID09,
	monthDefaultAbbrvName09,
	monthDefaultFullName09,
	monthDefaultNarrowName09,
	monthID010,
	monthDefaultAbbrvName010,
	monthDefaultFullName010,
	monthDefaultNarrowName010,
	monthID011,
	monthDefaultAbbrvName011,
	monthDefaultFullName011,
	monthDefaultNarrowName011,
	genitiveMonthID00,
	genitiveMonthDefaultAbbrvName00,
	genitiveMonthDefaultFullName00,
	genitiveMonthDefaultNarrowName00,
	genitiveMonthID01,
	genitiveMonthDefaultAbbrvName01,
	genitiveMonthDefaultFullName01,
	genitiveMonthDefaultNarrowName01,
	genitiveMonthID02,
	genitiveMonthDefaultAbbrvName02,
	genitiveMonthDefaultFullName02,
	genitiveMonthDefaultNarrowName02,
	genitiveMonthID03,
	genitiveMonthDefaultAbbrvName03,
	genitiveMonthDefaultFullName03,
	genitiveMonthDefaultNarrowName03,
	genitiveMonthID04,
	genitiveMonthDefaultAbbrvName04,
	genitiveMonthDefaultFullName04,
	genitiveMonthDefaultNarrowName04,
	genitiveMonthID05,
	genitiveMonthDefaultAbbrvName05,
	genitiveMonthDefaultFullName05,
	genitiveMonthDefaultNarrowName05,
	genitiveMonthID06,
	genitiveMonthDefaultAbbrvName06,
	genitiveMonthDefaultFullName06,
	genitiveMonthDefaultNarrowName06,
	genitiveMonthID07,
	genitiveMonthDefaultAbbrvName07,
	genitiveMonthDefaultFullName07,
	genitiveMonthDefaultNarrowName07,
	genitiveMonthID08,
	genitiveMonthDefaultAbbrvName08,
	genitiveMonthDefaultFullName08,
	genitiveMonthDefaultNarrowName08,
	genitiveMonthID09,
	genitiveMonthDefaultAbbrvName09,
	genitiveMonthDefaultFullName09,
	genitiveMonthDefaultNarrowName09,
	genitiveMonthID010,
	genitiveMonthDefaultAbbrvName010,
	genitiveMonthDefaultFullName010,
	genitiveMonthDefaultNarrowName010,
	genitiveMonthID011,
	genitiveMonthDefaultAbbrvName011,
	genitiveMonthDefaultFullName011,
	genitiveMonthDefaultNarrowName011,
	partitiveMonthID00,
	partitiveMonthDefaultAbbrvName00,
	partitiveMonthDefaultFullName00,
	partitiveMonthDefaultNarrowName00,
	partitiveMonthID01,
	partitiveMonthDefaultAbbrvName01,
	partitiveMonthDefaultFullName01,
	partitiveMonthDefaultNarrowName01,
	partitiveMonthID02,
	partitiveMonthDefaultAbbrvName02,
	partitiveMonthDefaultFullName02,
	partitiveMonthDefaultNarrowName02,
	partitiveMonthID03,
	partitiveMonthDefaultAbbrvName03,
	partitiveMonthDefaultFullName03,
	partitiveMonthDefaultNarrowName03,
	partitiveMonthID04,
	partitiveMonthDefaultAbbrvName04,
	partitiveMonthDefaultFullName04,
	partitiveMonthDefaultNarrowName04,
	partitiveMonthID05,
	partitiveMonthDefaultAbbrvName05,
	partitiveMonthDefaultFullName05,
	partitiveMonthDefaultNarrowName05,
	partitiveMonthID06,
	partitiveMonthDefaultAbbrvName06,
	partitiveMonthDefaultFullName06,
	partitiveMonthDefaultNarrowName06,
	partitiveMonthID07,
	partitiveMonthDefaultAbbrvName07,
	partitiveMonthDefaultFullName07,
	partitiveMonthDefaultNarrowName07,
	partitiveMonthID08,
	partitiveMonthDefaultAbbrvName08,
	partitiveMonthDefaultFullName08,
	partitiveMonthDefaultNarrowName08,
	partitiveMonthID09,
	partitiveMonthDefaultAbbrvName09,
	partitiveMonthDefaultFullName09,
	partitiveMonthDefaultNarrowName09,
	partitiveMonthID010,
	partitiveMonthDefaultAbbrvName010,
	partitiveMonthDefaultFullName010,
	partitiveMonthDefaultNarrowName010,
	partitiveMonthID011,
	partitiveMonthDefaultAbbrvName011,
	partitiveMonthDefaultFullName011,
	partitiveMonthDefaultNarrowName011,
	eraID00,
	eraDefaultAbbrvName00,
	eraDefaultFullName00,
	eraID01,
	eraDefaultAbbrvName01,
	eraDefaultFullName01,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_bn_BD(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0042\x0044\x0054";
static constexpr OUStringLiteral currencySymbol0 = u"\x09f3";
static constexpr OUStringLiteral bankSymbol0 = u"\x0042\x0044\x0054";
static constexpr OUStringLiteral currencyName0 = u"\x0042\x0061\x006e\x0067\x006c\x0061\x0064\x0065\x0073\x0068\x0069\x0020\x0054\x0061\x006b\x0061";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_bn_BD(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_bn_BD(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
static constexpr OUStringLiteral ReservedWord0 = u"\x09b8\x09a4\x09cd\x09af";
static constexpr OUStringLiteral ReservedWord1 = u"\x09ae\x09bf\x09a5\x09cd\x09af\x09be";
static constexpr OUStringLiteral ReservedWord2 = u"\x09aa\x09cd\x09b0\x09a5\x09ae\x0020\x09a4\x09bf\x09a8\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord3 = u"\x09a6\x09cd\x09ac\x09bf\x09a4\x09c0\x09df\x0020\x09a4\x09bf\x09a8\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord4 = u"\x09a4\x09c3\x09a4\x09c0\x09df\x0020\x09a4\x09bf\x09a8\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord5 = u"\x099a\x09a4\x09c1\x09b0\x09cd\x09a5\x0020\x09a4\x09bf\x09a8\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord6 = u"\x0989\x09aa\x09b0";
static constexpr OUStringLiteral ReservedWord7 = u"\x09a8\x09bf\x099a";
static constexpr OUStringLiteral ReservedWord8 = u"\x09e7\x09ae\x0020\x09e9\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord9 = u"\x09e8\x09df\x0020\x09e9\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord10 = u"\x09e9\x09df\x0020\x09e9\x0020\x09ae\x09be\x09b8";
static constexpr OUStringLiteral ReservedWord11 = u"\x09ea\x09b0\x09cd\x09a5\x0020\x09e9\x0020\x09ae\x09be\x09b8";
static const sal_Int16 nbOfReservedWords = 12;


static constexpr OUString LCReservedWordsArray[] = {
	ReservedWord0,
	ReservedWord1,
	ReservedWord2,
	ReservedWord3,
	ReservedWord4,
	ReservedWord5,
	ReservedWord6,
	ReservedWord7,
	ReservedWord8,
	ReservedWord9,
	ReservedWord10,
	ReservedWord11,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getReservedWords_bn_BD(sal_Int16& count)
{
	count = nbOfReservedWords;
	return (OUString const *)LCReservedWordsArray;
}
static constexpr OUStringLiteral forbiddenBegin = u"";
static constexpr OUStringLiteral forbiddenEnd = u"";
static constexpr OUStringLiteral hangingChars = u"";

static constexpr OUString LCForbiddenCharactersArray[] = {
	forbiddenBegin,
	forbiddenEnd,
	hangingChars
};

SAL_DLLPUBLIC_EXPORT OUString const *  getForbiddenCharacters_bn_BD(sal_Int16& count)
{
	count = 3;
	return (OUString const *)LCForbiddenCharactersArray;
}
static constexpr OUStringLiteral EditMode = u"";
static constexpr OUStringLiteral DictionaryMode = u"";
static constexpr OUStringLiteral WordCountMode = u"";
static constexpr OUStringLiteral CharacterMode = u"";
static constexpr OUStringLiteral LineMode = u"";

static constexpr OUString LCBreakIteratorRulesArray[] = {
	EditMode,
	DictionaryMode,
	WordCountMode,
	CharacterMode,
	LineMode
};

SAL_DLLPUBLIC_EXPORT OUString const *  getBreakIteratorRules_bn_BD(sal_Int16& count)
{
	count = 5;
	return (OUString const *)LCBreakIteratorRulesArray;
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_bn_IN(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_bn_BD(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_bn_IN(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_bn_BD(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

