/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_max2112_regs.py on Sat Dec 13 19:39:22 2025
 **********************************************************************/

#ifndef INCLUDED_MAX2112_WRITE_REGS_HPP
#define INCLUDED_MAX2112_WRITE_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class max2112_write_regs_t{
public:
    enum frac_t{
        FRAC_INVALID = 0,
        FRAC_FRAC = 1
    };
    frac_t frac;
    uint8_t n_divider_msb;
    uint8_t n_divider_lsb;
    uint8_t cpmp;
    uint8_t cplin;
    uint8_t f_divider_mmsb;
    uint8_t f_divider_msb;
    uint8_t f_divider_lsb;
    enum xtal_divider_t{
        XTAL_DIVIDER_DIV1 = 0,
        XTAL_DIVIDER_DIV2 = 1,
        XTAL_DIVIDER_DIV3 = 2,
        XTAL_DIVIDER_DIV4 = 3,
        XTAL_DIVIDER_DIV5 = 4,
        XTAL_DIVIDER_DIV6 = 5,
        XTAL_DIVIDER_DIV7 = 6,
        XTAL_DIVIDER_DIV8 = 7
    };
    xtal_divider_t xtal_divider;
    uint8_t r_divider;
    enum d24_t{
        D24_DIV2 = 0,
        D24_DIV4 = 1
    };
    d24_t d24;
    enum cps_t{
        CPS_I_CP_FROM_ICP = 0,
        CPS_I_CP_FROM_VAS = 1
    };
    cps_t cps;
    enum icp_t{
        ICP_I_CP_600UA = 0,
        ICP_I_CP_1200UA = 1
    };
    icp_t icp;
    uint8_t vco;
    enum vas_t{
        VAS_DISABLED = 0,
        VAS_ENABLED = 1
    };
    vas_t vas;
    enum adl_t{
        ADL_DISABLED = 0,
        ADL_ENABLED = 1
    };
    adl_t adl;
    enum ade_t{
        ADE_DISABLED = 0,
        ADE_ENABLED = 1
    };
    ade_t ade;
    uint8_t lp;
    enum stby_t{
        STBY_NORMAL = 0,
        STBY_DISABLE_SIG_AND_SYNTH = 1
    };
    stby_t stby;
    enum pwdn_t{
        PWDN_NORMAL = 0,
        PWDN_INVALID = 1
    };
    pwdn_t pwdn;
    uint8_t bbg;
    enum pll_shutdown_t{
        PLL_SHUTDOWN_NORMAL = 0,
        PLL_SHUTDOWN_SHUTDOWN = 1
    };
    pll_shutdown_t pll_shutdown;
    enum div_shutdown_t{
        DIV_SHUTDOWN_NORMAL = 0,
        DIV_SHUTDOWN_SHUTDOWN = 1
    };
    div_shutdown_t div_shutdown;
    enum vco_shutdown_t{
        VCO_SHUTDOWN_NORMAL = 0,
        VCO_SHUTDOWN_SHUTDOWN = 1
    };
    vco_shutdown_t vco_shutdown;
    enum bb_shutdown_t{
        BB_SHUTDOWN_NORMAL = 0,
        BB_SHUTDOWN_SHUTDOWN = 1
    };
    bb_shutdown_t bb_shutdown;
    enum rfmix_shutdown_t{
        RFMIX_SHUTDOWN_NORMAL = 0,
        RFMIX_SHUTDOWN_SHUTDOWN = 1
    };
    rfmix_shutdown_t rfmix_shutdown;
    enum rfvga_shutdown_t{
        RFVGA_SHUTDOWN_NORMAL = 0,
        RFVGA_SHUTDOWN_SHUTDOWN = 1
    };
    rfvga_shutdown_t rfvga_shutdown;
    enum fe_shutdown_t{
        FE_SHUTDOWN_NORMAL = 0,
        FE_SHUTDOWN_SHUTDOWN = 1
    };
    fe_shutdown_t fe_shutdown;
    uint8_t cptst;
    uint8_t turbo;
    enum ld_mux_t{
        LD_MUX_REFOUT = 0,
        LD_MUX_INVALID = 1
    };
    ld_mux_t ld_mux;

    max2112_write_regs_t(void){
        _state = NULL;
        frac = FRAC_FRAC;
        n_divider_msb = 0;
        n_divider_lsb = 35;
        cpmp = 0;
        cplin = 1;
        f_divider_mmsb = 2;
        f_divider_msb = 246;
        f_divider_lsb = 132;
        xtal_divider = XTAL_DIVIDER_DIV1;
        r_divider = 1;
        d24 = D24_DIV4;
        cps = CPS_I_CP_FROM_VAS;
        icp = ICP_I_CP_600UA;
        vco = 25;
        vas = VAS_ENABLED;
        adl = ADL_ENABLED;
        ade = ADE_ENABLED;
        lp = 75;
        stby = STBY_NORMAL;
        pwdn = PWDN_NORMAL;
        bbg = 0;
        pll_shutdown = PLL_SHUTDOWN_NORMAL;
        div_shutdown = DIV_SHUTDOWN_NORMAL;
        vco_shutdown = VCO_SHUTDOWN_NORMAL;
        bb_shutdown = BB_SHUTDOWN_NORMAL;
        rfmix_shutdown = RFMIX_SHUTDOWN_NORMAL;
        rfvga_shutdown = RFVGA_SHUTDOWN_NORMAL;
        fe_shutdown = FE_SHUTDOWN_NORMAL;
        cptst = 0;
        turbo = 1;
        ld_mux = LD_MUX_REFOUT;
    }

    ~max2112_write_regs_t(void){
        delete _state;
    }

    uint8_t get_reg(uint8_t addr){
        uint8_t reg = 0;
        switch(addr){
        case 0:
            reg |= (uint8_t(frac) & 0x1) << 7;
            reg |= (uint8_t(n_divider_msb) & 0x7f) << 0;
            break;
        case 1:
            reg |= (uint8_t(n_divider_lsb) & 0xff) << 0;
            break;
        case 2:
            reg |= (uint8_t(cpmp) & 0x3) << 6;
            reg |= (uint8_t(cplin) & 0x3) << 4;
            reg |= (uint8_t(f_divider_mmsb) & 0xf) << 0;
            break;
        case 3:
            reg |= (uint8_t(f_divider_msb) & 0xff) << 0;
            break;
        case 4:
            reg |= (uint8_t(f_divider_lsb) & 0xff) << 0;
            break;
        case 5:
            reg |= (uint8_t(xtal_divider) & 0x7) << 5;
            reg |= (uint8_t(r_divider) & 0x1f) << 0;
            break;
        case 6:
            reg |= (uint8_t(d24) & 0x1) << 7;
            reg |= (uint8_t(cps) & 0x1) << 6;
            reg |= (uint8_t(icp) & 0x1) << 5;
            break;
        case 7:
            reg |= (uint8_t(vco) & 0x1f) << 3;
            reg |= (uint8_t(vas) & 0x1) << 2;
            reg |= (uint8_t(adl) & 0x1) << 1;
            reg |= (uint8_t(ade) & 0x1) << 0;
            break;
        case 8:
            reg |= (uint8_t(lp) & 0xff) << 0;
            break;
        case 9:
            reg |= (uint8_t(stby) & 0x1) << 7;
            reg |= (uint8_t(pwdn) & 0x1) << 5;
            reg |= (uint8_t(bbg) & 0xf) << 0;
            break;
        case 10:
            reg |= (uint8_t(pll_shutdown) & 0x1) << 6;
            reg |= (uint8_t(div_shutdown) & 0x1) << 5;
            reg |= (uint8_t(vco_shutdown) & 0x1) << 4;
            reg |= (uint8_t(bb_shutdown) & 0x1) << 3;
            reg |= (uint8_t(rfmix_shutdown) & 0x1) << 2;
            reg |= (uint8_t(rfvga_shutdown) & 0x1) << 1;
            reg |= (uint8_t(fe_shutdown) & 0x1) << 0;
            break;
        case 11:
            reg |= (uint8_t(cptst) & 0x7) << 5;
            reg |= (uint8_t(turbo) & 0x1) << 3;
            reg |= (uint8_t(ld_mux) & 0x7) << 0;
            break;
        }
        return uint8_t(reg);
    }
    
    void set_reg(uint8_t addr, uint8_t reg){
        switch(addr){
        case 0:
            frac = frac_t((reg >> 7) & 0x1);
            n_divider_msb = uint8_t((reg >> 0) & 0x7f);
            break;
        case 1:
            n_divider_lsb = uint8_t((reg >> 0) & 0xff);
            break;
        case 2:
            cpmp = uint8_t((reg >> 6) & 0x3);
            cplin = uint8_t((reg >> 4) & 0x3);
            f_divider_mmsb = uint8_t((reg >> 0) & 0xf);
            break;
        case 3:
            f_divider_msb = uint8_t((reg >> 0) & 0xff);
            break;
        case 4:
            f_divider_lsb = uint8_t((reg >> 0) & 0xff);
            break;
        case 5:
            xtal_divider = xtal_divider_t((reg >> 5) & 0x7);
            r_divider = uint8_t((reg >> 0) & 0x1f);
            break;
        case 6:
            d24 = d24_t((reg >> 7) & 0x1);
            cps = cps_t((reg >> 6) & 0x1);
            icp = icp_t((reg >> 5) & 0x1);
            break;
        case 7:
            vco = uint8_t((reg >> 3) & 0x1f);
            vas = vas_t((reg >> 2) & 0x1);
            adl = adl_t((reg >> 1) & 0x1);
            ade = ade_t((reg >> 0) & 0x1);
            break;
        case 8:
            lp = uint8_t((reg >> 0) & 0xff);
            break;
        case 9:
            stby = stby_t((reg >> 7) & 0x1);
            pwdn = pwdn_t((reg >> 5) & 0x1);
            bbg = uint8_t((reg >> 0) & 0xf);
            break;
        case 10:
            pll_shutdown = pll_shutdown_t((reg >> 6) & 0x1);
            div_shutdown = div_shutdown_t((reg >> 5) & 0x1);
            vco_shutdown = vco_shutdown_t((reg >> 4) & 0x1);
            bb_shutdown = bb_shutdown_t((reg >> 3) & 0x1);
            rfmix_shutdown = rfmix_shutdown_t((reg >> 2) & 0x1);
            rfvga_shutdown = rfvga_shutdown_t((reg >> 1) & 0x1);
            fe_shutdown = fe_shutdown_t((reg >> 0) & 0x1);
            break;
        case 11:
            cptst = uint8_t((reg >> 5) & 0x7);
            turbo = uint8_t((reg >> 3) & 0x1);
            ld_mux = ld_mux_t((reg >> 0) & 0x7);
            break;
        }
    }

    void save_state(void){
        if (_state == NULL) _state = new max2112_write_regs_t();
        _state->frac = this->frac;
        _state->n_divider_msb = this->n_divider_msb;
        _state->n_divider_lsb = this->n_divider_lsb;
        _state->cpmp = this->cpmp;
        _state->cplin = this->cplin;
        _state->f_divider_mmsb = this->f_divider_mmsb;
        _state->f_divider_msb = this->f_divider_msb;
        _state->f_divider_lsb = this->f_divider_lsb;
        _state->xtal_divider = this->xtal_divider;
        _state->r_divider = this->r_divider;
        _state->d24 = this->d24;
        _state->cps = this->cps;
        _state->icp = this->icp;
        _state->vco = this->vco;
        _state->vas = this->vas;
        _state->adl = this->adl;
        _state->ade = this->ade;
        _state->lp = this->lp;
        _state->stby = this->stby;
        _state->pwdn = this->pwdn;
        _state->bbg = this->bbg;
        _state->pll_shutdown = this->pll_shutdown;
        _state->div_shutdown = this->div_shutdown;
        _state->vco_shutdown = this->vco_shutdown;
        _state->bb_shutdown = this->bb_shutdown;
        _state->rfmix_shutdown = this->rfmix_shutdown;
        _state->rfvga_shutdown = this->rfvga_shutdown;
        _state->fe_shutdown = this->fe_shutdown;
        _state->cptst = this->cptst;
        _state->turbo = this->turbo;
        _state->ld_mux = this->ld_mux;
    }

    frac_t get_state_frac(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->frac;
    }

    uint8_t get_state_n_divider_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->n_divider_msb;
    }

    uint8_t get_state_n_divider_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->n_divider_lsb;
    }

    uint8_t get_state_cpmp(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cpmp;
    }

    uint8_t get_state_cplin(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cplin;
    }

    uint8_t get_state_f_divider_mmsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->f_divider_mmsb;
    }

    uint8_t get_state_f_divider_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->f_divider_msb;
    }

    uint8_t get_state_f_divider_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->f_divider_lsb;
    }

    xtal_divider_t get_state_xtal_divider(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->xtal_divider;
    }

    uint8_t get_state_r_divider(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->r_divider;
    }

    d24_t get_state_d24(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->d24;
    }

    cps_t get_state_cps(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cps;
    }

    icp_t get_state_icp(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->icp;
    }

    uint8_t get_state_vco(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco;
    }

    vas_t get_state_vas(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vas;
    }

    adl_t get_state_adl(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->adl;
    }

    ade_t get_state_ade(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ade;
    }

    uint8_t get_state_lp(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lp;
    }

    stby_t get_state_stby(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->stby;
    }

    pwdn_t get_state_pwdn(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pwdn;
    }

    uint8_t get_state_bbg(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bbg;
    }

    pll_shutdown_t get_state_pll_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_shutdown;
    }

    div_shutdown_t get_state_div_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->div_shutdown;
    }

    vco_shutdown_t get_state_vco_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vco_shutdown;
    }

    bb_shutdown_t get_state_bb_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bb_shutdown;
    }

    rfmix_shutdown_t get_state_rfmix_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rfmix_shutdown;
    }

    rfvga_shutdown_t get_state_rfvga_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rfvga_shutdown;
    }

    fe_shutdown_t get_state_fe_shutdown(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->fe_shutdown;
    }

    uint8_t get_state_cptst(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cptst;
    }

    uint8_t get_state_turbo(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->turbo;
    }

    ld_mux_t get_state_ld_mux(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld_mux;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->frac != this->frac) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->n_divider_msb != this->n_divider_msb) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->n_divider_lsb != this->n_divider_lsb) {
                addrs.insert(1);
            }
        }
        if (include_ro || !false) {
            if(_state->cpmp != this->cpmp) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->cplin != this->cplin) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->f_divider_mmsb != this->f_divider_mmsb) {
                addrs.insert(2);
            }
        }
        if (include_ro || !false) {
            if(_state->f_divider_msb != this->f_divider_msb) {
                addrs.insert(3);
            }
        }
        if (include_ro || !false) {
            if(_state->f_divider_lsb != this->f_divider_lsb) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->xtal_divider != this->xtal_divider) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->r_divider != this->r_divider) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->d24 != this->d24) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->cps != this->cps) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->icp != this->icp) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->vco != this->vco) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->vas != this->vas) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->adl != this->adl) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->ade != this->ade) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->lp != this->lp) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->stby != this->stby) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->pwdn != this->pwdn) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->bbg != this->bbg) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_shutdown != this->pll_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->div_shutdown != this->div_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->vco_shutdown != this->vco_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->bb_shutdown != this->bb_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->rfmix_shutdown != this->rfmix_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->rfvga_shutdown != this->rfvga_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->fe_shutdown != this->fe_shutdown) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->cptst != this->cptst) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->turbo != this->turbo) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->ld_mux != this->ld_mux) {
                addrs.insert(11);
            }
        }
        return addrs;
    }

    uint16_t get_n_divider(void){
        return 
        (uint16_t(n_divider_lsb & 0xff) << 0) |
        (uint16_t(n_divider_msb & 0x7f) << 8) |
        0;
    }

    void set_n_divider(uint16_t reg){
        n_divider_lsb = (reg >> 0) & 0xff;
        n_divider_msb = (reg >> 8) & 0x7f;
    }

    uint32_t get_f_divider(void){
        return 
        (uint32_t(f_divider_lsb & 0xff) << 0) |
        (uint32_t(f_divider_msb & 0xff) << 8) |
        (uint32_t(f_divider_mmsb & 0xf) << 16) |
        0;
    }

    void set_f_divider(uint32_t reg){
        f_divider_lsb = (reg >> 0) & 0xff;
        f_divider_msb = (reg >> 8) & 0xff;
        f_divider_mmsb = (reg >> 16) & 0xf;
    }

private:
    max2112_write_regs_t *_state;
};

#endif /* INCLUDED_MAX2112_WRITE_REGS_HPP */
/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_max2112_regs.py on Sat Dec 13 19:39:22 2025
 **********************************************************************/

#ifndef INCLUDED_MAX2112_READ_REGS_HPP
#define INCLUDED_MAX2112_READ_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class max2112_read_regs_t{
public:
    enum por_t{
        POR_READ = 0,
        POR_RESET = 1
    };
    por_t por;
    enum vasa_t{
        VASA_VAS_FAIL = 0,
        VASA_VAS_WIN = 1
    };
    vasa_t vasa;
    enum vase_t{
        VASE_ACTIVE = 0,
        VASE_INACTIVE = 1
    };
    vase_t vase;
    enum ld_t{
        LD_UNLOCKED = 0,
        LD_LOCKED = 1
    };
    ld_t ld;
    uint8_t vcosbr;
    enum adc_t{
        ADC_OOL0 = 0,
        ADC_LOCK0 = 1,
        ADC_VASLOCK0 = 2,
        ADC_VASLOCK1 = 3,
        ADC_VASLOCK2 = 4,
        ADC_VASLOCK3 = 5,
        ADC_LOCK1 = 6,
        ADC_OOL1 = 7
    };
    adc_t adc;

    max2112_read_regs_t(void){
        _state = NULL;
        por = POR_READ;
        vasa = VASA_VAS_FAIL;
        vase = VASE_ACTIVE;
        ld = LD_UNLOCKED;
        vcosbr = 0;
        adc = ADC_OOL0;
    }

    ~max2112_read_regs_t(void){
        delete _state;
    }

    uint8_t get_reg(uint8_t addr){
        uint8_t reg = 0;
        switch(addr){
        case 12:
            reg |= (uint8_t(por) & 0x1) << 7;
            reg |= (uint8_t(vasa) & 0x1) << 6;
            reg |= (uint8_t(vase) & 0x1) << 5;
            reg |= (uint8_t(ld) & 0x1) << 4;
            break;
        case 13:
            reg |= (uint8_t(vcosbr) & 0x1f) << 3;
            reg |= (uint8_t(adc) & 0x7) << 0;
            break;
        }
        return uint8_t(reg);
    }
    
    void set_reg(uint8_t addr, uint8_t reg){
        switch(addr){
        case 12:
            por = por_t((reg >> 7) & 0x1);
            vasa = vasa_t((reg >> 6) & 0x1);
            vase = vase_t((reg >> 5) & 0x1);
            ld = ld_t((reg >> 4) & 0x1);
            break;
        case 13:
            vcosbr = uint8_t((reg >> 3) & 0x1f);
            adc = adc_t((reg >> 0) & 0x7);
            break;
        }
    }

    void save_state(void){
        if (_state == NULL) _state = new max2112_read_regs_t();
        _state->por = this->por;
        _state->vasa = this->vasa;
        _state->vase = this->vase;
        _state->ld = this->ld;
        _state->vcosbr = this->vcosbr;
        _state->adc = this->adc;
    }

    por_t get_state_por(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->por;
    }

    vasa_t get_state_vasa(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vasa;
    }

    vase_t get_state_vase(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vase;
    }

    ld_t get_state_ld(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ld;
    }

    uint8_t get_state_vcosbr(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->vcosbr;
    }

    adc_t get_state_adc(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->adc;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->por != this->por) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->vasa != this->vasa) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->vase != this->vase) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->ld != this->ld) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->vcosbr != this->vcosbr) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->adc != this->adc) {
                addrs.insert(13);
            }
        }
        return addrs;
    }

private:
    max2112_read_regs_t *_state;
};

#endif /* INCLUDED_MAX2112_READ_REGS_HPP */
