/* This file is auto-generated from ../src/admin/admin_protocol.x */

#include <rpc/rpc.h>
#include "internal.h"

#pragma once

#include <libvirt/libvirt-admin.h>

#include "virxdrdefs.h"

#define ADMIN_STRING_MAX 4194304

#define ADMIN_SERVER_LIST_MAX 16384

#define ADMIN_SERVER_THREADPOOL_PARAMETERS_MAX 32

#define ADMIN_CLIENT_LIST_MAX 16384

#define ADMIN_CLIENT_INFO_PARAMETERS_MAX 64

#define ADMIN_SERVER_CLIENT_LIMITS_MAX 32

typedef char *admin_nonnull_string;
void xdr_admin_nonnull_string_clear(admin_nonnull_string *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_nonnull_string, xdr_admin_nonnull_string_clear);

typedef admin_nonnull_string *admin_string;
void xdr_admin_string_clear(admin_string *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_string, xdr_admin_string_clear);

struct admin_typed_param_value {
    int type;
    union {
        int i;
        u_int ui;
        int64_t l;
        uint64_t ul;
        double d;
        int b;
        admin_nonnull_string s;
    } admin_typed_param_value_u;
};
typedef struct admin_typed_param_value admin_typed_param_value;
void xdr_admin_typed_param_value_clear(admin_typed_param_value *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_typed_param_value, xdr_admin_typed_param_value_clear);

struct admin_typed_param {
    admin_nonnull_string field;
    admin_typed_param_value value;
};
typedef struct admin_typed_param admin_typed_param;
void xdr_admin_typed_param_clear(admin_typed_param *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_typed_param, xdr_admin_typed_param_clear);

struct admin_nonnull_server {
    admin_nonnull_string name;
};
typedef struct admin_nonnull_server admin_nonnull_server;
void xdr_admin_nonnull_server_clear(admin_nonnull_server *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_nonnull_server, xdr_admin_nonnull_server_clear);

struct admin_nonnull_client {
    admin_nonnull_server srv;
    uint64_t id;
    int64_t timestamp;
    u_int transport;
};
typedef struct admin_nonnull_client admin_nonnull_client;
void xdr_admin_nonnull_client_clear(admin_nonnull_client *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_nonnull_client, xdr_admin_nonnull_client_clear);

struct admin_connect_open_args {
    u_int flags;
};
typedef struct admin_connect_open_args admin_connect_open_args;
void xdr_admin_connect_open_args_clear(admin_connect_open_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_open_args, xdr_admin_connect_open_args_clear);

struct admin_connect_get_lib_version_ret {
    uint64_t libVer;
};
typedef struct admin_connect_get_lib_version_ret admin_connect_get_lib_version_ret;
void xdr_admin_connect_get_lib_version_ret_clear(admin_connect_get_lib_version_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_get_lib_version_ret, xdr_admin_connect_get_lib_version_ret_clear);

struct admin_connect_list_servers_args {
    u_int need_results;
    u_int flags;
};
typedef struct admin_connect_list_servers_args admin_connect_list_servers_args;
void xdr_admin_connect_list_servers_args_clear(admin_connect_list_servers_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_list_servers_args, xdr_admin_connect_list_servers_args_clear);

struct admin_connect_list_servers_ret {
    struct {
        u_int servers_len;
        admin_nonnull_server *servers_val;
    } servers;
    u_int ret;
};
typedef struct admin_connect_list_servers_ret admin_connect_list_servers_ret;
void xdr_admin_connect_list_servers_ret_clear(admin_connect_list_servers_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_list_servers_ret, xdr_admin_connect_list_servers_ret_clear);

struct admin_connect_lookup_server_args {
    admin_nonnull_string name;
    u_int flags;
};
typedef struct admin_connect_lookup_server_args admin_connect_lookup_server_args;
void xdr_admin_connect_lookup_server_args_clear(admin_connect_lookup_server_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_lookup_server_args, xdr_admin_connect_lookup_server_args_clear);

struct admin_connect_lookup_server_ret {
    admin_nonnull_server srv;
};
typedef struct admin_connect_lookup_server_ret admin_connect_lookup_server_ret;
void xdr_admin_connect_lookup_server_ret_clear(admin_connect_lookup_server_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_lookup_server_ret, xdr_admin_connect_lookup_server_ret_clear);

struct admin_server_get_threadpool_parameters_args {
    admin_nonnull_server srv;
    u_int flags;
};
typedef struct admin_server_get_threadpool_parameters_args admin_server_get_threadpool_parameters_args;
void xdr_admin_server_get_threadpool_parameters_args_clear(admin_server_get_threadpool_parameters_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_get_threadpool_parameters_args, xdr_admin_server_get_threadpool_parameters_args_clear);

struct admin_server_get_threadpool_parameters_ret {
    struct {
        u_int params_len;
        admin_typed_param *params_val;
    } params;
};
typedef struct admin_server_get_threadpool_parameters_ret admin_server_get_threadpool_parameters_ret;
void xdr_admin_server_get_threadpool_parameters_ret_clear(admin_server_get_threadpool_parameters_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_get_threadpool_parameters_ret, xdr_admin_server_get_threadpool_parameters_ret_clear);

struct admin_server_set_threadpool_parameters_args {
    admin_nonnull_server srv;
    struct {
        u_int params_len;
        admin_typed_param *params_val;
    } params;
    u_int flags;
};
typedef struct admin_server_set_threadpool_parameters_args admin_server_set_threadpool_parameters_args;
void xdr_admin_server_set_threadpool_parameters_args_clear(admin_server_set_threadpool_parameters_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_set_threadpool_parameters_args, xdr_admin_server_set_threadpool_parameters_args_clear);

struct admin_server_list_clients_args {
    admin_nonnull_server srv;
    u_int need_results;
    u_int flags;
};
typedef struct admin_server_list_clients_args admin_server_list_clients_args;
void xdr_admin_server_list_clients_args_clear(admin_server_list_clients_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_list_clients_args, xdr_admin_server_list_clients_args_clear);

struct admin_server_list_clients_ret {
    struct {
        u_int clients_len;
        admin_nonnull_client *clients_val;
    } clients;
    u_int ret;
};
typedef struct admin_server_list_clients_ret admin_server_list_clients_ret;
void xdr_admin_server_list_clients_ret_clear(admin_server_list_clients_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_list_clients_ret, xdr_admin_server_list_clients_ret_clear);

struct admin_server_lookup_client_args {
    admin_nonnull_server srv;
    uint64_t id;
    u_int flags;
};
typedef struct admin_server_lookup_client_args admin_server_lookup_client_args;
void xdr_admin_server_lookup_client_args_clear(admin_server_lookup_client_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_lookup_client_args, xdr_admin_server_lookup_client_args_clear);

struct admin_server_lookup_client_ret {
    admin_nonnull_client clnt;
};
typedef struct admin_server_lookup_client_ret admin_server_lookup_client_ret;
void xdr_admin_server_lookup_client_ret_clear(admin_server_lookup_client_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_lookup_client_ret, xdr_admin_server_lookup_client_ret_clear);

struct admin_client_get_info_args {
    admin_nonnull_client clnt;
    u_int flags;
};
typedef struct admin_client_get_info_args admin_client_get_info_args;
void xdr_admin_client_get_info_args_clear(admin_client_get_info_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_client_get_info_args, xdr_admin_client_get_info_args_clear);

struct admin_client_get_info_ret {
    struct {
        u_int params_len;
        admin_typed_param *params_val;
    } params;
};
typedef struct admin_client_get_info_ret admin_client_get_info_ret;
void xdr_admin_client_get_info_ret_clear(admin_client_get_info_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_client_get_info_ret, xdr_admin_client_get_info_ret_clear);

struct admin_client_close_args {
    admin_nonnull_client clnt;
    u_int flags;
};
typedef struct admin_client_close_args admin_client_close_args;
void xdr_admin_client_close_args_clear(admin_client_close_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_client_close_args, xdr_admin_client_close_args_clear);

struct admin_server_get_client_limits_args {
    admin_nonnull_server srv;
    u_int flags;
};
typedef struct admin_server_get_client_limits_args admin_server_get_client_limits_args;
void xdr_admin_server_get_client_limits_args_clear(admin_server_get_client_limits_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_get_client_limits_args, xdr_admin_server_get_client_limits_args_clear);

struct admin_server_get_client_limits_ret {
    struct {
        u_int params_len;
        admin_typed_param *params_val;
    } params;
};
typedef struct admin_server_get_client_limits_ret admin_server_get_client_limits_ret;
void xdr_admin_server_get_client_limits_ret_clear(admin_server_get_client_limits_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_get_client_limits_ret, xdr_admin_server_get_client_limits_ret_clear);

struct admin_server_set_client_limits_args {
    admin_nonnull_server srv;
    struct {
        u_int params_len;
        admin_typed_param *params_val;
    } params;
    u_int flags;
};
typedef struct admin_server_set_client_limits_args admin_server_set_client_limits_args;
void xdr_admin_server_set_client_limits_args_clear(admin_server_set_client_limits_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_set_client_limits_args, xdr_admin_server_set_client_limits_args_clear);

struct admin_server_update_tls_files_args {
    admin_nonnull_server srv;
    u_int flags;
};
typedef struct admin_server_update_tls_files_args admin_server_update_tls_files_args;
void xdr_admin_server_update_tls_files_args_clear(admin_server_update_tls_files_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_server_update_tls_files_args, xdr_admin_server_update_tls_files_args_clear);

struct admin_connect_get_logging_outputs_args {
    u_int flags;
};
typedef struct admin_connect_get_logging_outputs_args admin_connect_get_logging_outputs_args;
void xdr_admin_connect_get_logging_outputs_args_clear(admin_connect_get_logging_outputs_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_get_logging_outputs_args, xdr_admin_connect_get_logging_outputs_args_clear);

struct admin_connect_get_logging_outputs_ret {
    admin_nonnull_string outputs;
    u_int noutputs;
};
typedef struct admin_connect_get_logging_outputs_ret admin_connect_get_logging_outputs_ret;
void xdr_admin_connect_get_logging_outputs_ret_clear(admin_connect_get_logging_outputs_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_get_logging_outputs_ret, xdr_admin_connect_get_logging_outputs_ret_clear);

struct admin_connect_get_logging_filters_args {
    u_int flags;
};
typedef struct admin_connect_get_logging_filters_args admin_connect_get_logging_filters_args;
void xdr_admin_connect_get_logging_filters_args_clear(admin_connect_get_logging_filters_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_get_logging_filters_args, xdr_admin_connect_get_logging_filters_args_clear);

struct admin_connect_get_logging_filters_ret {
    admin_string filters;
    u_int nfilters;
};
typedef struct admin_connect_get_logging_filters_ret admin_connect_get_logging_filters_ret;
void xdr_admin_connect_get_logging_filters_ret_clear(admin_connect_get_logging_filters_ret *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_get_logging_filters_ret, xdr_admin_connect_get_logging_filters_ret_clear);

struct admin_connect_set_logging_outputs_args {
    admin_string outputs;
    u_int flags;
};
typedef struct admin_connect_set_logging_outputs_args admin_connect_set_logging_outputs_args;
void xdr_admin_connect_set_logging_outputs_args_clear(admin_connect_set_logging_outputs_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_set_logging_outputs_args, xdr_admin_connect_set_logging_outputs_args_clear);

struct admin_connect_set_logging_filters_args {
    admin_string filters;
    u_int flags;
};
typedef struct admin_connect_set_logging_filters_args admin_connect_set_logging_filters_args;
void xdr_admin_connect_set_logging_filters_args_clear(admin_connect_set_logging_filters_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_set_logging_filters_args, xdr_admin_connect_set_logging_filters_args_clear);

struct admin_connect_set_daemon_timeout_args {
    u_int timeout;
    u_int flags;
};
typedef struct admin_connect_set_daemon_timeout_args admin_connect_set_daemon_timeout_args;
void xdr_admin_connect_set_daemon_timeout_args_clear(admin_connect_set_daemon_timeout_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_set_daemon_timeout_args, xdr_admin_connect_set_daemon_timeout_args_clear);

struct admin_connect_daemon_shutdown_args {
    u_int flags;
};
typedef struct admin_connect_daemon_shutdown_args admin_connect_daemon_shutdown_args;
void xdr_admin_connect_daemon_shutdown_args_clear(admin_connect_daemon_shutdown_args *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(admin_connect_daemon_shutdown_args, xdr_admin_connect_daemon_shutdown_args_clear);

#define ADMIN_PROGRAM 0x06900690

#define ADMIN_PROTOCOL_VERSION 1

enum admin_procedure {
    ADMIN_PROC_CONNECT_OPEN = 1,
    ADMIN_PROC_CONNECT_CLOSE = 2,
    ADMIN_PROC_CONNECT_GET_LIB_VERSION = 3,
    ADMIN_PROC_CONNECT_LIST_SERVERS = 4,
    ADMIN_PROC_CONNECT_LOOKUP_SERVER = 5,
    ADMIN_PROC_SERVER_GET_THREADPOOL_PARAMETERS = 6,
    ADMIN_PROC_SERVER_SET_THREADPOOL_PARAMETERS = 7,
    ADMIN_PROC_SERVER_LIST_CLIENTS = 8,
    ADMIN_PROC_SERVER_LOOKUP_CLIENT = 9,
    ADMIN_PROC_CLIENT_GET_INFO = 10,
    ADMIN_PROC_CLIENT_CLOSE = 11,
    ADMIN_PROC_SERVER_GET_CLIENT_LIMITS = 12,
    ADMIN_PROC_SERVER_SET_CLIENT_LIMITS = 13,
    ADMIN_PROC_CONNECT_GET_LOGGING_OUTPUTS = 14,
    ADMIN_PROC_CONNECT_GET_LOGGING_FILTERS = 15,
    ADMIN_PROC_CONNECT_SET_LOGGING_OUTPUTS = 16,
    ADMIN_PROC_CONNECT_SET_LOGGING_FILTERS = 17,
    ADMIN_PROC_SERVER_UPDATE_TLS_FILES = 18,
    ADMIN_PROC_CONNECT_SET_DAEMON_TIMEOUT = 19,
    ADMIN_PROC_CONNECT_DAEMON_SHUTDOWN = 20,
};
typedef enum admin_procedure admin_procedure;

extern  bool_t xdr_admin_nonnull_string(XDR *, admin_nonnull_string*);

extern  bool_t xdr_admin_string(XDR *, admin_string*);

extern  bool_t xdr_admin_typed_param_value(XDR *, admin_typed_param_value*);

extern  bool_t xdr_admin_typed_param(XDR *, admin_typed_param*);

extern  bool_t xdr_admin_nonnull_server(XDR *, admin_nonnull_server*);

extern  bool_t xdr_admin_nonnull_client(XDR *, admin_nonnull_client*);

extern  bool_t xdr_admin_connect_open_args(XDR *, admin_connect_open_args*);

extern  bool_t xdr_admin_connect_get_lib_version_ret(XDR *, admin_connect_get_lib_version_ret*);

extern  bool_t xdr_admin_connect_list_servers_args(XDR *, admin_connect_list_servers_args*);

extern  bool_t xdr_admin_connect_list_servers_ret(XDR *, admin_connect_list_servers_ret*);

extern  bool_t xdr_admin_connect_lookup_server_args(XDR *, admin_connect_lookup_server_args*);

extern  bool_t xdr_admin_connect_lookup_server_ret(XDR *, admin_connect_lookup_server_ret*);

extern  bool_t xdr_admin_server_get_threadpool_parameters_args(XDR *, admin_server_get_threadpool_parameters_args*);

extern  bool_t xdr_admin_server_get_threadpool_parameters_ret(XDR *, admin_server_get_threadpool_parameters_ret*);

extern  bool_t xdr_admin_server_set_threadpool_parameters_args(XDR *, admin_server_set_threadpool_parameters_args*);

extern  bool_t xdr_admin_server_list_clients_args(XDR *, admin_server_list_clients_args*);

extern  bool_t xdr_admin_server_list_clients_ret(XDR *, admin_server_list_clients_ret*);

extern  bool_t xdr_admin_server_lookup_client_args(XDR *, admin_server_lookup_client_args*);

extern  bool_t xdr_admin_server_lookup_client_ret(XDR *, admin_server_lookup_client_ret*);

extern  bool_t xdr_admin_client_get_info_args(XDR *, admin_client_get_info_args*);

extern  bool_t xdr_admin_client_get_info_ret(XDR *, admin_client_get_info_ret*);

extern  bool_t xdr_admin_client_close_args(XDR *, admin_client_close_args*);

extern  bool_t xdr_admin_server_get_client_limits_args(XDR *, admin_server_get_client_limits_args*);

extern  bool_t xdr_admin_server_get_client_limits_ret(XDR *, admin_server_get_client_limits_ret*);

extern  bool_t xdr_admin_server_set_client_limits_args(XDR *, admin_server_set_client_limits_args*);

extern  bool_t xdr_admin_server_update_tls_files_args(XDR *, admin_server_update_tls_files_args*);

extern  bool_t xdr_admin_connect_get_logging_outputs_args(XDR *, admin_connect_get_logging_outputs_args*);

extern  bool_t xdr_admin_connect_get_logging_outputs_ret(XDR *, admin_connect_get_logging_outputs_ret*);

extern  bool_t xdr_admin_connect_get_logging_filters_args(XDR *, admin_connect_get_logging_filters_args*);

extern  bool_t xdr_admin_connect_get_logging_filters_ret(XDR *, admin_connect_get_logging_filters_ret*);

extern  bool_t xdr_admin_connect_set_logging_outputs_args(XDR *, admin_connect_set_logging_outputs_args*);

extern  bool_t xdr_admin_connect_set_logging_filters_args(XDR *, admin_connect_set_logging_filters_args*);

extern  bool_t xdr_admin_connect_set_daemon_timeout_args(XDR *, admin_connect_set_daemon_timeout_args*);

extern  bool_t xdr_admin_connect_daemon_shutdown_args(XDR *, admin_connect_daemon_shutdown_args*);

extern  bool_t xdr_admin_procedure(XDR *, admin_procedure*);

